/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioListener.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsAudioListenerPrototypeFunctionSetPosition(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioListenerPrototypeFunctionSetOrientation(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsAudioListenerPrototypeFunctionSetVelocity(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsAudioListenerDopplerFactor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioListenerDopplerFactor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioListenerSpeedOfSound(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioListenerSpeedOfSound(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsAudioListenerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
void setJSAudioListenerConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSAudioListenerPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSAudioListenerPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioListenerPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioListenerPrototype>(vm.heap)) JSAudioListenerPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioListenerPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

typedef JSDOMConstructorNotConstructable<JSAudioListener> JSAudioListenerConstructor;

template<> JSValue JSAudioListenerConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAudioListenerConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSAudioListener::getPrototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("AudioListener"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSAudioListenerConstructor::s_info = { "AudioListener", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioListenerConstructor) };

/* Hash table for prototype */

static const HashTableValue JSAudioListenerPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioListenerConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioListenerConstructor) } },
    { "dopplerFactor", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioListenerDopplerFactor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioListenerDopplerFactor) } },
    { "speedOfSound", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsAudioListenerSpeedOfSound), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSAudioListenerSpeedOfSound) } },
    { "setPosition", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioListenerPrototypeFunctionSetPosition), (intptr_t) (3) } },
    { "setOrientation", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioListenerPrototypeFunctionSetOrientation), (intptr_t) (6) } },
    { "setVelocity", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsAudioListenerPrototypeFunctionSetVelocity), (intptr_t) (3) } },
};

const ClassInfo JSAudioListenerPrototype::s_info = { "AudioListenerPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioListenerPrototype) };

void JSAudioListenerPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioListenerPrototypeTableValues, *this);
}

const ClassInfo JSAudioListener::s_info = { "AudioListener", &Base::s_info, 0, CREATE_METHOD_TABLE(JSAudioListener) };

JSAudioListener::JSAudioListener(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioListener>&& impl)
    : JSDOMWrapper<AudioListener>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSAudioListener::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSAudioListenerPrototype::create(vm, globalObject, JSAudioListenerPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSAudioListener::getPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSAudioListener>(vm, globalObject);
}

void JSAudioListener::destroy(JSC::JSCell* cell)
{
    JSAudioListener* thisObject = static_cast<JSAudioListener*>(cell);
    thisObject->JSAudioListener::~JSAudioListener();
}

EncodedJSValue jsAudioListenerDopplerFactor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioListener*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioListener", "dopplerFactor");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.dopplerFactor());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioListenerSpeedOfSound(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(thisValue);
    JSValue decodedThisValue = JSValue::decode(thisValue);
    auto* castedThis = jsDynamicCast<JSAudioListener*>(decodedThisValue);
    if (UNLIKELY(!castedThis)) {
        return throwGetterTypeError(*state, "AudioListener", "speedOfSound");
    }
    auto& impl = castedThis->wrapped();
    JSValue result = jsNumber(impl.speedOfSound());
    return JSValue::encode(result);
}


EncodedJSValue jsAudioListenerConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    JSAudioListenerPrototype* domObject = jsDynamicCast<JSAudioListenerPrototype*>(JSValue::decode(thisValue));
    if (!domObject)
        return throwVMTypeError(state);
    return JSValue::encode(JSAudioListener::getConstructor(state->vm(), domObject->globalObject()));
}

void setJSAudioListenerConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    JSAudioListenerPrototype* domObject = jsDynamicCast<JSAudioListenerPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state);
        return;
    }
    // Shadowing a built-in constructor
    domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

void setJSAudioListenerDopplerFactor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioListener* castedThis = jsDynamicCast<JSAudioListener*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioListener", "dopplerFactor");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setDopplerFactor(nativeValue);
}


void setJSAudioListenerSpeedOfSound(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    JSValue value = JSValue::decode(encodedValue);
    UNUSED_PARAM(thisValue);
    JSAudioListener* castedThis = jsDynamicCast<JSAudioListener*>(JSValue::decode(thisValue));
    if (UNLIKELY(!castedThis)) {
        throwSetterTypeError(*state, "AudioListener", "speedOfSound");
        return;
    }
    auto& impl = castedThis->wrapped();
    float nativeValue = value.toFloat(state);
    if (UNLIKELY(state->hadException()))
        return;
    impl.setSpeedOfSound(nativeValue);
}


JSValue JSAudioListener::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioListenerConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsAudioListenerPrototypeFunctionSetPosition(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioListener*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioListener", "setPosition");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioListener::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float z = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setPosition(x, y, z);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioListenerPrototypeFunctionSetOrientation(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioListener*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioListener", "setOrientation");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioListener::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 6))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float z = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float xUp = state->argument(3).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float yUp = state->argument(4).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float zUp = state->argument(5).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setOrientation(x, y, z, xUp, yUp, zUp);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsAudioListenerPrototypeFunctionSetVelocity(ExecState* state)
{
    JSValue thisValue = state->thisValue();
    auto castedThis = jsDynamicCast<JSAudioListener*>(thisValue);
    if (UNLIKELY(!castedThis))
        return throwThisTypeError(*state, "AudioListener", "setVelocity");
    ASSERT_GC_OBJECT_INHERITS(castedThis, JSAudioListener::info());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(state->argumentCount() < 3))
        return throwVMError(state, createNotEnoughArgumentsError(state));
    float x = state->argument(0).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float y = state->argument(1).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    float z = state->argument(2).toFloat(state);
    if (UNLIKELY(state->hadException()))
        return JSValue::encode(jsUndefined());
    impl.setVelocity(x, y, z);
    return JSValue::encode(jsUndefined());
}

bool JSAudioListenerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSAudioListenerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioListener = jsCast<JSAudioListener*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsAudioListener->wrapped(), jsAudioListener);
}

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioListener* impl)
{
    if (!impl)
        return jsNull();
    return createNewWrapper<JSAudioListener>(globalObject, impl);
}

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject* globalObject, AudioListener* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSAudioListener>(globalObject, impl))
        return result;
#if COMPILER(CLANG)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to AudioListener.
    COMPILE_ASSERT(!__is_polymorphic(AudioListener), AudioListener_is_polymorphic_but_idl_claims_not_to_be);
#endif
    return createNewWrapper<JSAudioListener>(globalObject, impl);
}

AudioListener* JSAudioListener::toWrapped(JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioListener*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
