/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013, 2014 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json
// by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "InspectorProtocolObjects.h"

#include <wtf/text/CString.h>

namespace Inspector {

namespace Protocol {

static const char* const enum_constant_values[] = {
    "user",
    "user-agent",
    "inspector",
    "regular",
    "active",
    "inactive",
    "disabled",
    "style",
    "mediaRule",
    "importRule",
    "linkedSheet",
    "inlineSheet",
    "overset",
    "fit",
    "empty",
    "xml",
    "javascript",
    "network",
    "console-api",
    "storage",
    "appcache",
    "rendering",
    "css",
    "security",
    "content-blocker",
    "other",
    "log",
    "info",
    "warning",
    "error",
    "debug",
    "dir",
    "dirxml",
    "table",
    "trace",
    "clear",
    "startGroup",
    "startGroupCollapsed",
    "endGroup",
    "assert",
    "timing",
    "profile",
    "profileEnd",
    "before",
    "after",
    "additions",
    "removals",
    "text",
    "true",
    "false",
    "mixed",
    "page",
    "step",
    "location",
    "date",
    "time",
    "grammar",
    "spelling",
    "assertive",
    "polite",
    "off",
    "subtree-modified",
    "attribute-modified",
    "node-removed",
    "evaluate",
    "sound",
    "probe",
    "global",
    "with",
    "closure",
    "catch",
    "functionName",
    "globalLexicalEnvironment",
    "nestedLexical",
    "full",
    "partial",
    "number",
    "string",
    "array",
    "null",
    "Document",
    "Stylesheet",
    "Image",
    "Font",
    "Script",
    "XHR",
    "WebSocket",
    "Other",
    "parser",
    "script",
    "Viewport",
    "Page",
    "object",
    "function",
    "undefined",
    "boolean",
    "symbol",
    "node",
    "regexp",
    "map",
    "set",
    "weakmap",
    "weakset",
    "iterator",
    "class",
    "accessor",
    "none",
    "irrecoverable",
    "unterminated-literal",
    "recoverable",
    "API",
    "Microtask",
    "EventDispatch",
    "ScheduleStyleRecalculation",
    "RecalculateStyles",
    "InvalidateLayout",
    "Layout",
    "Paint",
    "Composite",
    "RenderingFrame",
    "TimerInstall",
    "TimerRemove",
    "TimerFire",
    "EvaluateScript",
    "TimeStamp",
    "Time",
    "TimeEnd",
    "FunctionCall",
    "ProbeSample",
    "ConsoleProfile",
    "RequestAnimationFrame",
    "CancelAnimationFrame",
    "FireAnimationFrame",
    "DOM",
    "EventListener",
    "exception",
    "CSPViolation",
    "DebuggerStatement",
    "Breakpoint",
    "PauseOnNextStatement",
    "uncaught",
    "all",
    "allowed",
    "forbidden",
};

String getEnumConstantValue(int code) {
    return enum_constant_values[code];
}

const char* Inspector::Protocol::CSS::CSSProperty::Implicit = "implicit";
const char* Inspector::Protocol::CSS::CSSProperty::Name = "name";
const char* Inspector::Protocol::CSS::CSSProperty::ParsedOk = "parsedOk";
const char* Inspector::Protocol::CSS::CSSProperty::Priority = "priority";
const char* Inspector::Protocol::CSS::CSSProperty::Range = "range";
const char* Inspector::Protocol::CSS::CSSProperty::Status = "status";
const char* Inspector::Protocol::CSS::CSSProperty::Text = "text";
const char* Inspector::Protocol::CSS::CSSProperty::Value = "value";
const char* Inspector::Protocol::Network::Response::FromDiskCache = "fromDiskCache";
const char* Inspector::Protocol::Network::Response::Headers = "headers";
const char* Inspector::Protocol::Network::Response::HeadersText = "headersText";
const char* Inspector::Protocol::Network::Response::MimeType = "mimeType";
const char* Inspector::Protocol::Network::Response::RequestHeaders = "requestHeaders";
const char* Inspector::Protocol::Network::Response::RequestHeadersText = "requestHeadersText";
const char* Inspector::Protocol::Network::Response::Status = "status";
const char* Inspector::Protocol::Network::Response::StatusText = "statusText";
const char* Inspector::Protocol::Network::Response::Timing = "timing";
const char* Inspector::Protocol::Network::Response::Url = "url";
const char* Inspector::Protocol::Timeline::TimelineEvent::Children = "children";
const char* Inspector::Protocol::Timeline::TimelineEvent::Data = "data";
const char* Inspector::Protocol::Timeline::TimelineEvent::Type = "type";

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Debugger::Location>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator scriptIdPos = object->find(ASCIILiteral("scriptId"));
        ASSERT(scriptIdPos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(scriptIdPos->value.get());
    }
    {
        InspectorObject::iterator lineNumberPos = object->find(ASCIILiteral("lineNumber"));
        ASSERT(lineNumberPos != object->end());
        BindingTraits<int>::assertValueHasExpectedType(lineNumberPos->value.get());
    }

    int foundPropertiesCount = 2;
    {
        InspectorObject::iterator columnNumberPos = object->find(ASCIILiteral("columnNumber"));
        if (columnNumberPos != object->end()) {
            BindingTraits<int>::assertValueHasExpectedType(columnNumberPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Debugger::FunctionDetails>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator locationPos = object->find(ASCIILiteral("location"));
        ASSERT(locationPos != object->end());
        BindingTraits<Inspector::Protocol::Debugger::Location>::assertValueHasExpectedType(locationPos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        InspectorObject::iterator namePos = object->find(ASCIILiteral("name"));
        if (namePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(namePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator displayNamePos = object->find(ASCIILiteral("displayName"));
        if (displayNamePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(displayNamePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator inferredNamePos = object->find(ASCIILiteral("inferredName"));
        if (inferredNamePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(inferredNamePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator scopeChainPos = object->find(ASCIILiteral("scopeChain"));
        if (scopeChainPos != object->end()) {
            BindingTraits<Inspector::Protocol::Array<Inspector::Protocol::Debugger::Scope>>::assertValueHasExpectedType(scopeChainPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

RefPtr<Inspector::Protocol::Debugger::FunctionDetails> BindingTraits<Inspector::Protocol::Debugger::FunctionDetails>::runtimeCast(RefPtr<InspectorValue>&& value)
{
    RefPtr<InspectorObject> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
#if !ASSERT_DISABLED
    BindingTraits<Inspector::Protocol::Debugger::FunctionDetails>::assertValueHasExpectedType(result.get());
#endif  // !ASSERT_DISABLED
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Debugger::FunctionDetails) == sizeof(InspectorObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Debugger::FunctionDetails*>(static_cast<InspectorObjectBase*>(result.get()));
}


#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Debugger::CallFrame>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator callFrameIdPos = object->find(ASCIILiteral("callFrameId"));
        ASSERT(callFrameIdPos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(callFrameIdPos->value.get());
    }
    {
        InspectorObject::iterator functionNamePos = object->find(ASCIILiteral("functionName"));
        ASSERT(functionNamePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(functionNamePos->value.get());
    }
    {
        InspectorObject::iterator locationPos = object->find(ASCIILiteral("location"));
        ASSERT(locationPos != object->end());
        BindingTraits<Inspector::Protocol::Debugger::Location>::assertValueHasExpectedType(locationPos->value.get());
    }
    {
        InspectorObject::iterator scopeChainPos = object->find(ASCIILiteral("scopeChain"));
        ASSERT(scopeChainPos != object->end());
        BindingTraits<Inspector::Protocol::Array<Inspector::Protocol::Debugger::Scope>>::assertValueHasExpectedType(scopeChainPos->value.get());
    }
    {
        InspectorObject::iterator thisPos = object->find(ASCIILiteral("this"));
        ASSERT(thisPos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(thisPos->value.get());
    }

    int foundPropertiesCount = 5;
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

RefPtr<Inspector::Protocol::Debugger::CallFrame> BindingTraits<Inspector::Protocol::Debugger::CallFrame>::runtimeCast(RefPtr<InspectorValue>&& value)
{
    RefPtr<InspectorObject> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
#if !ASSERT_DISABLED
    BindingTraits<Inspector::Protocol::Debugger::CallFrame>::assertValueHasExpectedType(result.get());
#endif  // !ASSERT_DISABLED
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Debugger::CallFrame) == sizeof(InspectorObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Debugger::CallFrame*>(static_cast<InspectorObjectBase*>(result.get()));
}


#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Debugger::Scope::Type>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "global" || result == "with" || result == "closure" || result == "catch" || result == "functionName" || result == "globalLexicalEnvironment" || result == "nestedLexical");
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Debugger::Scope>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator typePos = object->find(ASCIILiteral("type"));
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Debugger::Scope::Type>::assertValueHasExpectedType(typePos->value.get());
    }
    {
        InspectorObject::iterator objectPos = object->find(ASCIILiteral("object"));
        ASSERT(objectPos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(objectPos->value.get());
    }

    int foundPropertiesCount = 2;
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Type>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "object" || result == "function" || result == "undefined" || result == "string" || result == "number" || result == "boolean" || result == "symbol");
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Subtype>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "array" || result == "null" || result == "node" || result == "regexp" || result == "date" || result == "error" || result == "map" || result == "set" || result == "weakmap" || result == "weakset" || result == "iterator" || result == "class");
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator typePos = object->find(ASCIILiteral("type"));
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Type>::assertValueHasExpectedType(typePos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        InspectorObject::iterator subtypePos = object->find(ASCIILiteral("subtype"));
        if (subtypePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject::Subtype>::assertValueHasExpectedType(subtypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator classNamePos = object->find(ASCIILiteral("className"));
        if (classNamePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(classNamePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator valuePos = object->find(ASCIILiteral("value"));
        if (valuePos != object->end()) {
            BindingTraits<Inspector::InspectorValue>::assertValueHasExpectedType(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator descriptionPos = object->find(ASCIILiteral("description"));
        if (descriptionPos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(descriptionPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator objectIdPos = object->find(ASCIILiteral("objectId"));
        if (objectIdPos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(objectIdPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator sizePos = object->find(ASCIILiteral("size"));
        if (sizePos != object->end()) {
            BindingTraits<int>::assertValueHasExpectedType(sizePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator classPrototypePos = object->find(ASCIILiteral("classPrototype"));
        if (classPrototypePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(classPrototypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator previewPos = object->find(ASCIILiteral("preview"));
        if (previewPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(previewPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

RefPtr<Inspector::Protocol::Runtime::RemoteObject> BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::runtimeCast(RefPtr<InspectorValue>&& value)
{
    RefPtr<InspectorObject> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
#if !ASSERT_DISABLED
    BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(result.get());
#endif  // !ASSERT_DISABLED
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Runtime::RemoteObject) == sizeof(InspectorObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Runtime::RemoteObject*>(static_cast<InspectorObjectBase*>(result.get()));
}


#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Type>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "object" || result == "function" || result == "undefined" || result == "string" || result == "number" || result == "boolean" || result == "symbol");
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Subtype>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "array" || result == "null" || result == "node" || result == "regexp" || result == "date" || result == "error" || result == "map" || result == "set" || result == "weakmap" || result == "weakset" || result == "iterator" || result == "class");
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator typePos = object->find(ASCIILiteral("type"));
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Type>::assertValueHasExpectedType(typePos->value.get());
    }
    {
        InspectorObject::iterator losslessPos = object->find(ASCIILiteral("lossless"));
        ASSERT(losslessPos != object->end());
        BindingTraits<bool>::assertValueHasExpectedType(losslessPos->value.get());
    }

    int foundPropertiesCount = 2;
    {
        InspectorObject::iterator subtypePos = object->find(ASCIILiteral("subtype"));
        if (subtypePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::ObjectPreview::Subtype>::assertValueHasExpectedType(subtypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator descriptionPos = object->find(ASCIILiteral("description"));
        if (descriptionPos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(descriptionPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator overflowPos = object->find(ASCIILiteral("overflow"));
        if (overflowPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(overflowPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator propertiesPos = object->find(ASCIILiteral("properties"));
        if (propertiesPos != object->end()) {
            BindingTraits<Inspector::Protocol::Array<Inspector::Protocol::Runtime::PropertyPreview>>::assertValueHasExpectedType(propertiesPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator entriesPos = object->find(ASCIILiteral("entries"));
        if (entriesPos != object->end()) {
            BindingTraits<Inspector::Protocol::Array<Inspector::Protocol::Runtime::EntryPreview>>::assertValueHasExpectedType(entriesPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator sizePos = object->find(ASCIILiteral("size"));
        if (sizePos != object->end()) {
            BindingTraits<int>::assertValueHasExpectedType(sizePos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Type>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "object" || result == "function" || result == "undefined" || result == "string" || result == "number" || result == "boolean" || result == "symbol" || result == "accessor");
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Subtype>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "array" || result == "null" || result == "node" || result == "regexp" || result == "date" || result == "error" || result == "map" || result == "set" || result == "weakmap" || result == "weakset" || result == "iterator" || result == "class");
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::PropertyPreview>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator namePos = object->find(ASCIILiteral("name"));
        ASSERT(namePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(namePos->value.get());
    }
    {
        InspectorObject::iterator typePos = object->find(ASCIILiteral("type"));
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Type>::assertValueHasExpectedType(typePos->value.get());
    }

    int foundPropertiesCount = 2;
    {
        InspectorObject::iterator subtypePos = object->find(ASCIILiteral("subtype"));
        if (subtypePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::PropertyPreview::Subtype>::assertValueHasExpectedType(subtypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator valuePos = object->find(ASCIILiteral("value"));
        if (valuePos != object->end()) {
            BindingTraits<String>::assertValueHasExpectedType(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator valuePreviewPos = object->find(ASCIILiteral("valuePreview"));
        if (valuePreviewPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(valuePreviewPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator internalPos = object->find(ASCIILiteral("internal"));
        if (internalPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(internalPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::EntryPreview>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator valuePos = object->find(ASCIILiteral("value"));
        ASSERT(valuePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(valuePos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        InspectorObject::iterator keyPos = object->find(ASCIILiteral("key"));
        if (keyPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::ObjectPreview>::assertValueHasExpectedType(keyPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::CollectionEntry>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator valuePos = object->find(ASCIILiteral("value"));
        ASSERT(valuePos != object->end());
        BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(valuePos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        InspectorObject::iterator keyPos = object->find(ASCIILiteral("key"));
        if (keyPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(keyPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

RefPtr<Inspector::Protocol::Runtime::CollectionEntry> BindingTraits<Inspector::Protocol::Runtime::CollectionEntry>::runtimeCast(RefPtr<InspectorValue>&& value)
{
    RefPtr<InspectorObject> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
#if !ASSERT_DISABLED
    BindingTraits<Inspector::Protocol::Runtime::CollectionEntry>::assertValueHasExpectedType(result.get());
#endif  // !ASSERT_DISABLED
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Runtime::CollectionEntry) == sizeof(InspectorObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Runtime::CollectionEntry*>(static_cast<InspectorObjectBase*>(result.get()));
}


#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::PropertyDescriptor>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator namePos = object->find(ASCIILiteral("name"));
        ASSERT(namePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(namePos->value.get());
    }
    {
        InspectorObject::iterator configurablePos = object->find(ASCIILiteral("configurable"));
        ASSERT(configurablePos != object->end());
        BindingTraits<bool>::assertValueHasExpectedType(configurablePos->value.get());
    }
    {
        InspectorObject::iterator enumerablePos = object->find(ASCIILiteral("enumerable"));
        ASSERT(enumerablePos != object->end());
        BindingTraits<bool>::assertValueHasExpectedType(enumerablePos->value.get());
    }

    int foundPropertiesCount = 3;
    {
        InspectorObject::iterator valuePos = object->find(ASCIILiteral("value"));
        if (valuePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator writablePos = object->find(ASCIILiteral("writable"));
        if (writablePos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(writablePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator getPos = object->find(ASCIILiteral("get"));
        if (getPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(getPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator setPos = object->find(ASCIILiteral("set"));
        if (setPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(setPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator wasThrownPos = object->find(ASCIILiteral("wasThrown"));
        if (wasThrownPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(wasThrownPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator isOwnPos = object->find(ASCIILiteral("isOwn"));
        if (isOwnPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(isOwnPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator symbolPos = object->find(ASCIILiteral("symbol"));
        if (symbolPos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(symbolPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator nativeGetterPos = object->find(ASCIILiteral("nativeGetter"));
        if (nativeGetterPos != object->end()) {
            BindingTraits<bool>::assertValueHasExpectedType(nativeGetterPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

RefPtr<Inspector::Protocol::Runtime::PropertyDescriptor> BindingTraits<Inspector::Protocol::Runtime::PropertyDescriptor>::runtimeCast(RefPtr<InspectorValue>&& value)
{
    RefPtr<InspectorObject> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
#if !ASSERT_DISABLED
    BindingTraits<Inspector::Protocol::Runtime::PropertyDescriptor>::assertValueHasExpectedType(result.get());
#endif  // !ASSERT_DISABLED
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Runtime::PropertyDescriptor) == sizeof(InspectorObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Runtime::PropertyDescriptor*>(static_cast<InspectorObjectBase*>(result.get()));
}


#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Runtime::InternalPropertyDescriptor>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator namePos = object->find(ASCIILiteral("name"));
        ASSERT(namePos != object->end());
        BindingTraits<String>::assertValueHasExpectedType(namePos->value.get());
    }

    int foundPropertiesCount = 1;
    {
        InspectorObject::iterator valuePos = object->find(ASCIILiteral("value"));
        if (valuePos != object->end()) {
            BindingTraits<Inspector::Protocol::Runtime::RemoteObject>::assertValueHasExpectedType(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}
#endif // !ASSERT_DISABLED

RefPtr<Inspector::Protocol::Runtime::InternalPropertyDescriptor> BindingTraits<Inspector::Protocol::Runtime::InternalPropertyDescriptor>::runtimeCast(RefPtr<InspectorValue>&& value)
{
    RefPtr<InspectorObject> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
#if !ASSERT_DISABLED
    BindingTraits<Inspector::Protocol::Runtime::InternalPropertyDescriptor>::assertValueHasExpectedType(result.get());
#endif  // !ASSERT_DISABLED
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Runtime::InternalPropertyDescriptor) == sizeof(InspectorObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Runtime::InternalPropertyDescriptor*>(static_cast<InspectorObjectBase*>(result.get()));
}


#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Timeline::EventType>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    String result;
    bool castSucceeded = value->asString(result);
    ASSERT(castSucceeded);
    ASSERT(result == "EventDispatch" || result == "ScheduleStyleRecalculation" || result == "RecalculateStyles" || result == "InvalidateLayout" || result == "Layout" || result == "Paint" || result == "Composite" || result == "RenderingFrame" || result == "TimerInstall" || result == "TimerRemove" || result == "TimerFire" || result == "EvaluateScript" || result == "TimeStamp" || result == "Time" || result == "TimeEnd" || result == "FunctionCall" || result == "ProbeSample" || result == "ConsoleProfile" || result == "RequestAnimationFrame" || result == "CancelAnimationFrame" || result == "FireAnimationFrame");
}
#endif // !ASSERT_DISABLED

#if !ASSERT_DISABLED
void BindingTraits<Inspector::Protocol::Timeline::TimelineEvent>::assertValueHasExpectedType(Inspector::InspectorValue* value)
{
    ASSERT_ARG(value, value);
    RefPtr<InspectorObject> object;
    bool castSucceeded = value->asObject(object);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
    {
        InspectorObject::iterator typePos = object->find(ASCIILiteral("type"));
        ASSERT(typePos != object->end());
        BindingTraits<Inspector::Protocol::Timeline::EventType>::assertValueHasExpectedType(typePos->value.get());
    }
    {
        InspectorObject::iterator dataPos = object->find(ASCIILiteral("data"));
        ASSERT(dataPos != object->end());
        BindingTraits<Inspector::InspectorObject>::assertValueHasExpectedType(dataPos->value.get());
    }
    {
        InspectorObject::iterator childrenPos = object->find(ASCIILiteral("children"));
        if (childrenPos != object->end()) {
            BindingTraits<Inspector::Protocol::Array<Inspector::Protocol::Timeline::TimelineEvent>>::assertValueHasExpectedType(childrenPos->value.get());
        }
    }
}
#endif // !ASSERT_DISABLED

RefPtr<Inspector::Protocol::Timeline::TimelineEvent> BindingTraits<Inspector::Protocol::Timeline::TimelineEvent>::runtimeCast(RefPtr<InspectorValue>&& value)
{
    RefPtr<InspectorObject> result;
    bool castSucceeded = value->asObject(result);
    ASSERT_UNUSED(castSucceeded, castSucceeded);
#if !ASSERT_DISABLED
    BindingTraits<Inspector::Protocol::Timeline::TimelineEvent>::assertValueHasExpectedType(result.get());
#endif  // !ASSERT_DISABLED
    COMPILE_ASSERT(sizeof(Inspector::Protocol::Timeline::TimelineEvent) == sizeof(InspectorObjectBase), type_cast_problem);
    return static_cast<Inspector::Protocol::Timeline::TimelineEvent*>(static_cast<InspectorObjectBase*>(result.get()));
}


} // namespace Protocol

} // namespace Inspector
