
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in TopoShapeFacePyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of TopoShapeFacePy
PyTypeObject TopoShapeFacePy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.TopoShape",     /*tp_name*/
    sizeof(TopoShapeFacePy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "TopoShapeFace is the OpenCasCade topological face wrapper",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::TopoShapeFacePy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::TopoShapeFacePy::GetterSetter,                     /*tp_getset */
    &Part::TopoShapePy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::TopoShapeFacePy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of TopoShapeFacePy
PyMethodDef TopoShapeFacePy::Methods[] = {
    {"addWire",
        reinterpret_cast<PyCFunction>( staticCallback_addWire ),
        METH_VARARGS,
        "Adds a wire to the face.\naddWire(wire)\n                "
    },
    {"makeOffset",
        reinterpret_cast<PyCFunction>( staticCallback_makeOffset ),
        METH_VARARGS,
        "Offset the face by a given amount.\nmakeOffset(dist) -> Face\n--\nReturns Compound of Wires. Deprecated - use makeOffset2D instead.\n                "
    },
    {"makeEvolved",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) (void)>( staticCallback_makeEvolved )),
        METH_VARARGS|METH_KEYWORDS,
        "Profile along the spine"
    },
    {"getUVNodes",
        reinterpret_cast<PyCFunction>( staticCallback_getUVNodes ),
        METH_VARARGS,
        "Get the list of (u,v) nodes of the tessellation\ngetUVNodes() -> list\n--\nAn exception is raised if the face is not triangulated.\n"
    },
    {"tangentAt",
        reinterpret_cast<PyCFunction>( staticCallback_tangentAt ),
        METH_VARARGS,
        "Get the tangent in u and v isoparametric at the given point if defined\ntangentAt(u,v) -> Vector\n                "
    },
    {"valueAt",
        reinterpret_cast<PyCFunction>( staticCallback_valueAt ),
        METH_VARARGS,
        "Get the point at the given parameter [0|Length] if defined\nvalueAt(u,v) -> Vector\n                "
    },
    {"normalAt",
        reinterpret_cast<PyCFunction>( staticCallback_normalAt ),
        METH_VARARGS,
        "Get the normal vector at the given parameter [0|Length] if defined\nnormalAt(pos) -> Vector\n                "
    },
    {"derivative1At",
        reinterpret_cast<PyCFunction>( staticCallback_derivative1At ),
        METH_VARARGS,
        "Get the first derivative at the given parameter [0|Length] if defined\nderivative1At(u,v) -> (vectorU,vectorV)\n                "
    },
    {"derivative2At",
        reinterpret_cast<PyCFunction>( staticCallback_derivative2At ),
        METH_VARARGS,
        "Vector = d2At(pos) - Get the second derivative at the given parameter [0|Length] if defined\nderivative2At(u,v) -> (vectorU,vectorV)\n                "
    },
    {"curvatureAt",
        reinterpret_cast<PyCFunction>( staticCallback_curvatureAt ),
        METH_VARARGS,
        "Get the curvature at the given parameter [0|Length] if defined\ncurvatureAt(u,v) -> Float\n                "
    },
    {"isPartOfDomain",
        reinterpret_cast<PyCFunction>( staticCallback_isPartOfDomain ),
        METH_VARARGS,
        "Check if a given (u,v) pair is inside the domain of a face\nisPartOfDomain(u,v) -> bool\n                "
    },
    {"makeHalfSpace",
        reinterpret_cast<PyCFunction>( staticCallback_makeHalfSpace ),
        METH_VARARGS,
        "Make a half-space solid by this face and a reference point.\nmakeHalfSpace(pos) -> Shape\n                "
    },
    {"validate",
        reinterpret_cast<PyCFunction>( staticCallback_validate ),
        METH_VARARGS,
        "Validate the face.\nvalidate()\n                "
    },
    {"countNodes",
        reinterpret_cast<PyCFunction>( staticCallback_countNodes ),
        METH_VARARGS,
        "Returns the number of nodes of the triangulation."
    },
    {"countTriangles",
        reinterpret_cast<PyCFunction>( staticCallback_countTriangles ),
        METH_VARARGS,
        "Returns the number of triangles of the triangulation."
    },
    {"curveOnSurface",
        reinterpret_cast<PyCFunction>( staticCallback_curveOnSurface ),
        METH_VARARGS,
        "Returns the curve associated to the edge in the parametric space of the face.\ncurveOnSurface(Edge) -> (curve, min, max) or None\n--\nIf this curve exists then a tuple of curve and parameter range is returned.\nReturns None if this curve  does not exist.\n                "
    },
    {"cutHoles",
        reinterpret_cast<PyCFunction>( staticCallback_cutHoles ),
        METH_VARARGS,
        "Cut holes in the face.\ncutHoles(list_of_wires)\n                "
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of TopoShapeFacePy
PyGetSetDef TopoShapeFacePy::GetterSetter[] = {
    {"Tolerance",
        (getter) staticCallback_getTolerance,
        (setter) staticCallback_setTolerance,
        "Set or get the tolerance of the vertex",
        nullptr
    },
    {"ParameterRange",
        (getter) staticCallback_getParameterRange,
        (setter) staticCallback_setParameterRange,
        "Returns a 4 tuple with the parameter range",
        nullptr
    },
    {"Surface",
        (getter) staticCallback_getSurface,
        (setter) staticCallback_setSurface,
        "Returns the geometric surface of the face",
        nullptr
    },
    {"Wire",
        (getter) staticCallback_getWire,
        (setter) staticCallback_setWire,
        "The outer wire of this face\ndeprecated -- please use OuterWire",
        nullptr
    },
    {"OuterWire",
        (getter) staticCallback_getOuterWire,
        (setter) staticCallback_setOuterWire,
        "The outer wire of this face",
        nullptr
    },
    {"Mass",
        (getter) staticCallback_getMass,
        (setter) staticCallback_setMass,
        "Returns the mass of the current system.",
        nullptr
    },
    {"CenterOfMass",
        (getter) staticCallback_getCenterOfMass,
        (setter) staticCallback_setCenterOfMass,
        "Returns the center of mass of the current system.\nIf the gravitational field is uniform, it is the center of gravity.\nThe coordinates returned for the center of mass are expressed in the\nabsolute Cartesian coordinate system.",
        nullptr
    },
    {"MatrixOfInertia",
        (getter) staticCallback_getMatrixOfInertia,
        (setter) staticCallback_setMatrixOfInertia,
        "Returns the matrix of inertia. It is a symmetrical matrix.\nThe coefficients of the matrix are the quadratic moments of\ninertia.\n\n | Ixx Ixy Ixz 0 |\n | Ixy Iyy Iyz 0 |\n | Ixz Iyz Izz 0 |\n | 0   0   0   1 |\n\nThe moments of inertia are denoted by Ixx, Iyy, Izz.\nThe products of inertia are denoted by Ixy, Ixz, Iyz.\nThe matrix of inertia is returned in the central coordinate\nsystem (G, Gx, Gy, Gz) where G is the centre of mass of the\nsystem and Gx, Gy, Gz the directions parallel to the X(1,0,0)\nY(0,1,0) Z(0,0,1) directions of the absolute cartesian\ncoordinate system.",
        nullptr
    },
    {"StaticMoments",
        (getter) staticCallback_getStaticMoments,
        (setter) staticCallback_setStaticMoments,
        "Returns Ix, Iy, Iz, the static moments of inertia of the\n current system; i.e. the moments of inertia about the\n three axes of the Cartesian coordinate system.",
        nullptr
    },
    {"PrincipalProperties",
        (getter) staticCallback_getPrincipalProperties,
        (setter) staticCallback_setPrincipalProperties,
        "Computes the principal properties of inertia of the current system.\n There is always a set of axes for which the products\n of inertia of a geometric system are equal to 0; i.e. the\n matrix of inertia of the system is diagonal. These axes\n are the principal axes of inertia. Their origin is\n coincident with the center of mass of the system. The\n associated moments are called the principal moments of inertia.\n This function computes the eigen values and the\n eigen vectors of the matrix of inertia of the system.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// addWire() callback and implementer
// PyObject*  TopoShapeFacePy::addWire(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_addWire (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addWire' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->addWire(args);
        if (ret != 0)
            static_cast<TopoShapeFacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeOffset() callback and implementer
// PyObject*  TopoShapeFacePy::makeOffset(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_makeOffset (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeOffset' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->makeOffset(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeEvolved() callback and implementer
// PyObject*  TopoShapeFacePy::makeEvolved(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_makeEvolved (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeEvolved' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->makeEvolved(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getUVNodes() callback and implementer
// PyObject*  TopoShapeFacePy::getUVNodes(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getUVNodes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getUVNodes' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->getUVNodes(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// tangentAt() callback and implementer
// PyObject*  TopoShapeFacePy::tangentAt(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_tangentAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'tangentAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->tangentAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// valueAt() callback and implementer
// PyObject*  TopoShapeFacePy::valueAt(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_valueAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'valueAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->valueAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// normalAt() callback and implementer
// PyObject*  TopoShapeFacePy::normalAt(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_normalAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'normalAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->normalAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// derivative1At() callback and implementer
// PyObject*  TopoShapeFacePy::derivative1At(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_derivative1At (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'derivative1At' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->derivative1At(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// derivative2At() callback and implementer
// PyObject*  TopoShapeFacePy::derivative2At(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_derivative2At (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'derivative2At' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->derivative2At(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// curvatureAt() callback and implementer
// PyObject*  TopoShapeFacePy::curvatureAt(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_curvatureAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'curvatureAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->curvatureAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isPartOfDomain() callback and implementer
// PyObject*  TopoShapeFacePy::isPartOfDomain(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_isPartOfDomain (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isPartOfDomain' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->isPartOfDomain(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// makeHalfSpace() callback and implementer
// PyObject*  TopoShapeFacePy::makeHalfSpace(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_makeHalfSpace (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'makeHalfSpace' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->makeHalfSpace(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// validate() callback and implementer
// PyObject*  TopoShapeFacePy::validate(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_validate (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'validate' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->validate(args);
        if (ret != 0)
            static_cast<TopoShapeFacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// countNodes() callback and implementer
// PyObject*  TopoShapeFacePy::countNodes(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_countNodes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'countNodes' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->countNodes(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// countTriangles() callback and implementer
// PyObject*  TopoShapeFacePy::countTriangles(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_countTriangles (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'countTriangles' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->countTriangles(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// curveOnSurface() callback and implementer
// PyObject*  TopoShapeFacePy::curveOnSurface(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_curveOnSurface (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'curveOnSurface' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->curveOnSurface(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// cutHoles() callback and implementer
// PyObject*  TopoShapeFacePy::cutHoles(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_cutHoles (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'cutHoles' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeFacePy*>(self)->cutHoles(args);
        if (ret != 0)
            static_cast<TopoShapeFacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Tolerance() callback and implementer
// PyObject*  TopoShapeFacePy::Tolerance(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getTolerance (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getTolerance());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Tolerance' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setTolerance (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<TopoShapeFacePy*>(self)->setTolerance(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Tolerance' of object 'TopoShape'");
        return -1;
    }
}

// ParameterRange() callback and implementer
// PyObject*  TopoShapeFacePy::ParameterRange(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getParameterRange (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getParameterRange());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ParameterRange' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setParameterRange (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'ParameterRange' of object 'TopoShape' is read-only");
    return -1;
}

// Surface() callback and implementer
// PyObject*  TopoShapeFacePy::Surface(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getSurface (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getSurface());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Surface' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setSurface (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Surface' of object 'TopoShape' is read-only");
    return -1;
}

// Wire() callback and implementer
// PyObject*  TopoShapeFacePy::Wire(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getWire (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getWire());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Wire' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setWire (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Wire' of object 'TopoShape' is read-only");
    return -1;
}

// OuterWire() callback and implementer
// PyObject*  TopoShapeFacePy::OuterWire(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getOuterWire (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getOuterWire());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'OuterWire' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setOuterWire (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'OuterWire' of object 'TopoShape' is read-only");
    return -1;
}

// Mass() callback and implementer
// PyObject*  TopoShapeFacePy::Mass(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getMass (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getMass());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Mass' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setMass (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Mass' of object 'TopoShape' is read-only");
    return -1;
}

// CenterOfMass() callback and implementer
// PyObject*  TopoShapeFacePy::CenterOfMass(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getCenterOfMass (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getCenterOfMass());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'CenterOfMass' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setCenterOfMass (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'CenterOfMass' of object 'TopoShape' is read-only");
    return -1;
}

// MatrixOfInertia() callback and implementer
// PyObject*  TopoShapeFacePy::MatrixOfInertia(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getMatrixOfInertia (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getMatrixOfInertia());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MatrixOfInertia' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setMatrixOfInertia (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'MatrixOfInertia' of object 'TopoShape' is read-only");
    return -1;
}

// StaticMoments() callback and implementer
// PyObject*  TopoShapeFacePy::StaticMoments(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getStaticMoments (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getStaticMoments());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'StaticMoments' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setStaticMoments (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'StaticMoments' of object 'TopoShape' is read-only");
    return -1;
}

// PrincipalProperties() callback and implementer
// PyObject*  TopoShapeFacePy::PrincipalProperties(PyObject *args){};
// has to be implemented in TopoShapeFacePyImp.cpp
PyObject * TopoShapeFacePy::staticCallback_getPrincipalProperties (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeFacePy*>(self)->getPrincipalProperties());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'PrincipalProperties' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeFacePy::staticCallback_setPrincipalProperties (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'PrincipalProperties' of object 'TopoShape' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
TopoShapeFacePy::TopoShapeFacePy(TopoShape *pcObject, PyTypeObject *T)
    : TopoShapePy(static_cast<TopoShapePy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
TopoShapeFacePy::~TopoShapeFacePy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// TopoShapeFacePy representation
//--------------------------------------------------------------------------
PyObject *TopoShapeFacePy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// TopoShapeFacePy Attributes
//--------------------------------------------------------------------------
PyObject *TopoShapeFacePy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return TopoShapePy::_getattr(attr);
}

int TopoShapeFacePy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return TopoShapePy::_setattr(attr, value);
}

TopoShape *TopoShapeFacePy::getTopoShapePtr() const
{
    return static_cast<TopoShape *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in TopoShapeFacePyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *TopoShapeFacePy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // create a new instance of TopoShapeFacePy and the Twin object
    return new TopoShapeFacePy(new TopoShape);
}

// constructor method
int TopoShapeFacePy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string TopoShapeFacePy::representation() const
{
    return std::string("<TopoShape object>");
}

PyObject* TopoShapeFacePy::addWire(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::makeOffset(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::makeEvolved(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::getUVNodes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::tangentAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::valueAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::normalAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::derivative1At(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::derivative2At(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::curvatureAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::isPartOfDomain(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::makeHalfSpace(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::validate(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::countNodes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::countTriangles(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::curveOnSurface(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeFacePy::cutHoles(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Float TopoShapeFacePy::getTolerance() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  TopoShapeFacePy::setTolerance(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Tuple TopoShapeFacePy::getParameterRange() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeFacePy::getSurface() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeFacePy::getWire() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeFacePy::getOuterWire() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeFacePy::getMass() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeFacePy::getCenterOfMass() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeFacePy::getMatrixOfInertia() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeFacePy::getStaticMoments() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Dict TopoShapeFacePy::getPrincipalProperties() const
{
    //return Py::Dict();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *TopoShapeFacePy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int TopoShapeFacePy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



