
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in SelectionObjectPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Gui;

/// Type structure of SelectionObjectPy
PyTypeObject SelectionObjectPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Gui.SelectionObject",     /*tp_name*/
    sizeof(SelectionObjectPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "This class represents selections made by the user. It holds information about the object, document and sub-element of the selection.",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Gui::SelectionObjectPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Gui::SelectionObjectPy::GetterSetter,                     /*tp_getset */
    &Base::BaseClassPy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Gui::SelectionObjectPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of SelectionObjectPy
PyMethodDef SelectionObjectPy::Methods[] = {
    {"remove",
        reinterpret_cast<PyCFunction>( staticCallback_remove ),
        METH_VARARGS,
        "Remove this selection item from the selection.\nremove() -> None\n--\nThis object becomes invalid.\n"
    },
    {"isObjectTypeOf",
        reinterpret_cast<PyCFunction>( staticCallback_isObjectTypeOf ),
        METH_VARARGS,
        "Test for a certain father class.\nisObjectTypeOf(type) -> Bool\n"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of SelectionObjectPy
PyGetSetDef SelectionObjectPy::GetterSetter[] = {
    {"ObjectName",
        (getter) staticCallback_getObjectName,
        (setter) staticCallback_setObjectName,
        "Name of the selected object",
        nullptr
    },
    {"SubElementNames",
        (getter) staticCallback_getSubElementNames,
        (setter) staticCallback_setSubElementNames,
        "Name of the selected sub-element if any",
        nullptr
    },
    {"FullName",
        (getter) staticCallback_getFullName,
        (setter) staticCallback_setFullName,
        "Name of the selected object",
        nullptr
    },
    {"TypeName",
        (getter) staticCallback_getTypeName,
        (setter) staticCallback_setTypeName,
        "Type name of the selected object",
        nullptr
    },
    {"DocumentName",
        (getter) staticCallback_getDocumentName,
        (setter) staticCallback_setDocumentName,
        "Name of the document of the selected object",
        nullptr
    },
    {"Document",
        (getter) staticCallback_getDocument,
        (setter) staticCallback_setDocument,
        "Document of the selected object",
        nullptr
    },
    {"Object",
        (getter) staticCallback_getObject,
        (setter) staticCallback_setObject,
        "Selected object",
        nullptr
    },
    {"SubObjects",
        (getter) staticCallback_getSubObjects,
        (setter) staticCallback_setSubObjects,
        "Selected sub-element, if any",
        nullptr
    },
    {"PickedPoints",
        (getter) staticCallback_getPickedPoints,
        (setter) staticCallback_setPickedPoints,
        "Picked points for selection",
        nullptr
    },
    {"HasSubObjects",
        (getter) staticCallback_getHasSubObjects,
        (setter) staticCallback_setHasSubObjects,
        "Selected sub-element, if any",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// remove() callback and implementer
// PyObject*  SelectionObjectPy::remove(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_remove (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'remove' of 'Gui.SelectionObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SelectionObjectPy*>(self)->remove(args);
        if (ret != 0)
            static_cast<SelectionObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isObjectTypeOf() callback and implementer
// PyObject*  SelectionObjectPy::isObjectTypeOf(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_isObjectTypeOf (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isObjectTypeOf' of 'Gui.SelectionObject' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<SelectionObjectPy*>(self)->isObjectTypeOf(args);
        if (ret != 0)
            static_cast<SelectionObjectPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// ObjectName() callback and implementer
// PyObject*  SelectionObjectPy::ObjectName(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getObjectName (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getObjectName());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ObjectName' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setObjectName (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'ObjectName' of object 'SelectionObject' is read-only");
    return -1;
}

// SubElementNames() callback and implementer
// PyObject*  SelectionObjectPy::SubElementNames(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getSubElementNames (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getSubElementNames());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'SubElementNames' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setSubElementNames (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'SubElementNames' of object 'SelectionObject' is read-only");
    return -1;
}

// FullName() callback and implementer
// PyObject*  SelectionObjectPy::FullName(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getFullName (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getFullName());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'FullName' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setFullName (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'FullName' of object 'SelectionObject' is read-only");
    return -1;
}

// TypeName() callback and implementer
// PyObject*  SelectionObjectPy::TypeName(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getTypeName (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getTypeName());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'TypeName' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setTypeName (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'TypeName' of object 'SelectionObject' is read-only");
    return -1;
}

// DocumentName() callback and implementer
// PyObject*  SelectionObjectPy::DocumentName(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getDocumentName (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getDocumentName());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'DocumentName' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setDocumentName (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'DocumentName' of object 'SelectionObject' is read-only");
    return -1;
}

// Document() callback and implementer
// PyObject*  SelectionObjectPy::Document(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getDocument (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getDocument());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Document' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setDocument (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Document' of object 'SelectionObject' is read-only");
    return -1;
}

// Object() callback and implementer
// PyObject*  SelectionObjectPy::Object(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getObject (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getObject());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Object' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setObject (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Object' of object 'SelectionObject' is read-only");
    return -1;
}

// SubObjects() callback and implementer
// PyObject*  SelectionObjectPy::SubObjects(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getSubObjects (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getSubObjects());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'SubObjects' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setSubObjects (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'SubObjects' of object 'SelectionObject' is read-only");
    return -1;
}

// PickedPoints() callback and implementer
// PyObject*  SelectionObjectPy::PickedPoints(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getPickedPoints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getPickedPoints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'PickedPoints' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setPickedPoints (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'PickedPoints' of object 'SelectionObject' is read-only");
    return -1;
}

// HasSubObjects() callback and implementer
// PyObject*  SelectionObjectPy::HasSubObjects(PyObject *args){};
// has to be implemented in SelectionObjectPyImp.cpp
PyObject * SelectionObjectPy::staticCallback_getHasSubObjects (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<SelectionObjectPy*>(self)->getHasSubObjects());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'HasSubObjects' of object 'SelectionObject'");
        return nullptr;
    }
}

int SelectionObjectPy::staticCallback_setHasSubObjects (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'HasSubObjects' of object 'SelectionObject' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
SelectionObjectPy::SelectionObjectPy(SelectionObject *pcObject, PyTypeObject *T)
    : BaseClassPy(static_cast<BaseClassPy::PointerType>(pcObject), T)
{
}

PyObject *SelectionObjectPy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // never create such objects with the constructor
    PyErr_SetString(PyExc_RuntimeError, "You cannot create directly an instance of 'SelectionObjectPy'.");

    return nullptr;
}

int SelectionObjectPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}

//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
SelectionObjectPy::~SelectionObjectPy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    SelectionObjectPy::PointerType ptr = static_cast<SelectionObjectPy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// SelectionObjectPy representation
//--------------------------------------------------------------------------
PyObject *SelectionObjectPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// SelectionObjectPy Attributes
//--------------------------------------------------------------------------
PyObject *SelectionObjectPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return BaseClassPy::_getattr(attr);
}

int SelectionObjectPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return BaseClassPy::_setattr(attr, value);
}

SelectionObject *SelectionObjectPy::getSelectionObjectPtr() const
{
    return static_cast<SelectionObject *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in SelectionObjectPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */



// returns a string which represents the object e.g. when printed in python
std::string SelectionObjectPy::representation() const
{
    return std::string("<SelectionObject object>");
}

PyObject* SelectionObjectPy::remove(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* SelectionObjectPy::isObjectTypeOf(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::String SelectionObjectPy::getObjectName() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::Tuple SelectionObjectPy::getSubElementNames() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

Py::String SelectionObjectPy::getFullName() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String SelectionObjectPy::getTypeName() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::String SelectionObjectPy::getDocumentName() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object SelectionObjectPy::getDocument() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object SelectionObjectPy::getObject() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Tuple SelectionObjectPy::getSubObjects() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

Py::Tuple SelectionObjectPy::getPickedPoints() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean SelectionObjectPy::getHasSubObjects() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *SelectionObjectPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int SelectionObjectPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



