
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in MatrixPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Base;

/// Type structure of MatrixPy
PyTypeObject MatrixPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Base.Matrix",     /*tp_name*/
    sizeof(MatrixPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    Base::MatrixPy::Number,      /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Base.Matrix class.\n\n"
    "A 4x4 Matrix.\n"
    "In particular, this matrix can represent an affine transformation, that is,\n"
    "given a 3D vector `x`, apply the transformation y = M*x + b, where the matrix\n"
    "`M` is a linear map and the vector `b` is a translation.\n"
    "`y` can be obtained using a linear transformation represented by the 4x4 matrix\n"
    "`A` conformed by the augmented 3x4 matrix (M|b), augmented by row with\n"
    "(0,0,0,1), therefore: (y, 1) = A*(x, 1).\n\n"
    "The following constructors are supported:\n\n"
    "Matrix()\n"
    "Empty constructor.\n\n"
    "Matrix(matrix)\n"
    "Copy constructor.\n"
    "matrix : Base.Matrix.\n\n"
    "Matrix(*coef)\n"
    "Define from 16 coefficients of the 4x4 matrix.\n"
    "coef : sequence of float\n    The sequence can have up to 16 elements which complete the matrix by rows.\n\n"
    "Matrix(vector1, vector2, vector3, vector4)\n"
    "Define from four 3D vectors which represent the columns of the 3x4 submatrix,\n"
    "useful to represent an affine transformation. The fourth row is made up by\n"
    "(0,0,0,1).\n"
    "vector1 : Base.Vector\n"
    "vector2 : Base.Vector\n"
    "vector3 : Base.Vector\n"
    "vector4 : Base.Vector\n    Default to (0,0,0). Optional.",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    Base::MatrixPy::richCompare,      /*tp_richcompare*/
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Base::MatrixPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Base::MatrixPy::GetterSetter,                     /*tp_getset */
    &Base::PyObjectBase::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Base::MatrixPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of MatrixPy
PyMethodDef MatrixPy::Methods[] = {
    {"move",
        reinterpret_cast<PyCFunction>( staticCallback_move ),
        METH_VARARGS,
        "move(vector) -> None\nmove(x, y, z) -> None\n\nMove the matrix along a vector, equivalent to left multiply the matrix\nby a pure translation transformation.\n\nvector : Base.Vector, tuple\nx : float\n    `x` translation.\ny : float\n    `y` translation.\nz : float\n    `z` translation."
    },
    {"scale",
        reinterpret_cast<PyCFunction>( staticCallback_scale ),
        METH_VARARGS,
        "scale(vector) -> None\nscale(x, y, z) -> None\nscale(factor) -> None\n\nScale the first three rows of the matrix.\n\nvector : Base.Vector\nx : float\n    First row factor scale.\ny : float\n    Second row factor scale.\nz : float\n    Third row factor scale.\nfactor : float\n    global factor scale."
    },
    {"hasScale",
        reinterpret_cast<PyCFunction>( staticCallback_hasScale ),
        METH_VARARGS,
        "hasScale(tol=0) -> ScaleType\n\nReturn an enum value of ScaleType. Possible values are:\nUniform, NonUniformLeft, NonUniformRight, NoScaling or Other\nif it's not a scale matrix.\n\ntol : float"
    },
    {"nullify",
        reinterpret_cast<PyCFunction>( staticCallback_nullify ),
        METH_VARARGS,
        "nullify() -> None\n\nMake this the null matrix."
    },
    {"isNull",
        reinterpret_cast<PyCFunction>( staticCallback_isNull ),
        METH_VARARGS,
        "isNull() -> bool\n\nCheck if this is the null matrix."
    },
    {"unity",
        reinterpret_cast<PyCFunction>( staticCallback_unity ),
        METH_VARARGS,
        "unity() -> None\n\nMake this matrix to unity (4D identity matrix)."
    },
    {"isUnity",
        reinterpret_cast<PyCFunction>( staticCallback_isUnity ),
        METH_VARARGS,
        "isUnity() -> bool\n\nCheck if this is the unit matrix (4D identity matrix)."
    },
    {"transform",
        reinterpret_cast<PyCFunction>( staticCallback_transform ),
        METH_VARARGS,
        "transform(vector, matrix2) -> None\n\nTransform the matrix around a given point.\nEquivalent to left multiply the matrix by T*M*T_inv, where M is `matrix2`, T the\ntranslation generated by `vector` and T_inv the inverse translation.\nFor example, if `matrix2` is a rotation, the result is the transformation generated\nby the current matrix followed by a rotation around the point represented by `vector`.\n\nvector : Base.Vector\nmatrix2 : Base.Matrix"
    },
    {"col",
        reinterpret_cast<PyCFunction>( staticCallback_col ),
        METH_VARARGS,
        "col(index) -> Base.Vector\n\nReturn the vector of a column, that is, the vector generated by the three\nfirst elements of the specified column.\n\nindex : int\n    Required column index."
    },
    {"setCol",
        reinterpret_cast<PyCFunction>( staticCallback_setCol ),
        METH_VARARGS,
        "setCol(index, vector) -> None\n\nSet the vector of a column, that is, the three first elements of the specified\ncolumn by index.\n\nindex : int\n    Required column index.\nvector : Base.Vector"
    },
    {"row",
        reinterpret_cast<PyCFunction>( staticCallback_row ),
        METH_VARARGS,
        "row(index) -> Base.Vector\n\nReturn the vector of a row, that is, the vector generated by the three\nfirst elements of the specified row.\n\nindex : int\n    Required row index."
    },
    {"setRow",
        reinterpret_cast<PyCFunction>( staticCallback_setRow ),
        METH_VARARGS,
        "setRow(index, vector) -> None\n\nSet the vector of a row, that is, the three first elements of the specified\nrow by index.\n\nindex : int\n    Required row index.\nvector : Base.Vector"
    },
    {"trace",
        reinterpret_cast<PyCFunction>( staticCallback_trace ),
        METH_VARARGS,
        "trace() -> Base.Vector\n\nReturn the diagonal of the 3x3 leading principal submatrix as vector."
    },
    {"setTrace",
        reinterpret_cast<PyCFunction>( staticCallback_setTrace ),
        METH_VARARGS,
        "setTrace(vector) -> None\n\nSet the diagonal of the 3x3 leading principal submatrix.\n\nvector : Base.Vector"
    },
    {"rotateX",
        reinterpret_cast<PyCFunction>( staticCallback_rotateX ),
        METH_VARARGS,
        "rotateX(angle) -> None\n\nRotate around X axis.\n\nangle : float\n    Angle in radians."
    },
    {"rotateY",
        reinterpret_cast<PyCFunction>( staticCallback_rotateY ),
        METH_VARARGS,
        "rotateY(angle) -> None\n\nRotate around Y axis.\n\nangle : float\n    Angle in radians."
    },
    {"rotateZ",
        reinterpret_cast<PyCFunction>( staticCallback_rotateZ ),
        METH_VARARGS,
        "rotateZ(angle) -> None\n\nRotate around Z axis.\n\nangle : float\n    Angle in radians."
    },
    {"multiply",
        reinterpret_cast<PyCFunction>( staticCallback_multiply ),
        METH_VARARGS,
        "multiply(matrix) -> Base.Matrix\nmultiply(vector) -> Base.Vector\n\nRight multiply the matrix by the given object.\nIf the argument is a vector, this is augmented to the 4D vector (`vector`, 1).\n\nmatrix : Base.Matrix\nvector : Base.Vector"
    },
    {"multVec",
        reinterpret_cast<PyCFunction>( staticCallback_multVec ),
        METH_VARARGS,
        "multVec(vector) -> Base.Vector\n\nCompute the transformed vector using the matrix.\n\nvector : Base.Vector"
    },
    {"invert",
        reinterpret_cast<PyCFunction>( staticCallback_invert ),
        METH_VARARGS,
        "invert() -> None\n\nCompute the inverse matrix in-place, if possible."
    },
    {"inverse",
        reinterpret_cast<PyCFunction>( staticCallback_inverse ),
        METH_VARARGS,
        "inverse() -> Base.Matrix\n\nCompute the inverse matrix, if possible."
    },
    {"transpose",
        reinterpret_cast<PyCFunction>( staticCallback_transpose ),
        METH_VARARGS,
        "transpose() -> None\n\nTranspose the matrix in-place."
    },
    {"transposed",
        reinterpret_cast<PyCFunction>( staticCallback_transposed ),
        METH_VARARGS,
        "transposed() -> Base.Matrix\n\nReturns a transposed copy of this matrix."
    },
    {"determinant",
        reinterpret_cast<PyCFunction>( staticCallback_determinant ),
        METH_VARARGS,
        "determinant() -> float\n\nCompute the determinant of the matrix."
    },
    {"isOrthogonal",
        reinterpret_cast<PyCFunction>( staticCallback_isOrthogonal ),
        METH_VARARGS,
        "isOrthogonal(tol=1e-6) -> float\n\nChecks if the matrix is orthogonal, i.e. M * M^T = k*I and returns\nthe multiple of the identity matrix. If it's not orthogonal 0 is returned.\n\ntol : float\n    Tolerance used to check orthogonality."
    },
    {"submatrix",
        reinterpret_cast<PyCFunction>( staticCallback_submatrix ),
        METH_VARARGS,
        "submatrix(dim) -> Base.Matrix\n\nGet the leading principal submatrix of the given dimension.\nThe (4 - `dim`) remaining dimensions are completed with the\ncorresponding identity matrix.\n\ndim : int\n    Dimension parameter must be in the range [1,4]."
    },
    {"analyze",
        reinterpret_cast<PyCFunction>( staticCallback_analyze ),
        METH_VARARGS,
        "analyze() -> str\n\nAnalyzes the type of transformation."
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};

PyNumberMethods MatrixPy::Number[] = { {
    number_add_handler,
    number_subtract_handler,
    number_multiply_handler,
    number_remainder_handler,
    number_divmod_handler,
    number_power_handler,
    number_negative_handler,
    number_positive_handler,
    number_absolute_handler,
    number_nonzero_handler,
    number_invert_handler,
    number_lshift_handler,
    number_rshift_handler,
    number_and_handler,
    number_xor_handler,
    number_or_handler,
    number_int_handler,
    nullptr,
    number_float_handler,
    nullptr,    /*nb_inplace_add*/
    nullptr,    /*nb_inplace_subtract*/
    nullptr,    /*nb_inplace_multiply*/
    nullptr,    /*nb_inplace_remainder*/
    nullptr,    /*nb_inplace_power*/
    nullptr,    /*nb_inplace_lshift*/
    nullptr,    /*nb_inplace_rshift*/
    nullptr,    /*nb_inplace_and*/
    nullptr,    /*nb_inplace_xor*/
    nullptr,    /*nb_inplace_or*/
    nullptr,    /*nb_floor_divide*/
    number_divide_handler,    /*nb_true_divide*/
    nullptr,    /*nb_inplace_floor_divide*/
    nullptr,    /*nb_inplace_true_divide*/
    nullptr     /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
   ,nullptr     /*nb_matrix_multiply*/
   ,nullptr     /*nb_inplace_matrix_multiply*/
#endif
} };


/// Attribute structure of MatrixPy
PyGetSetDef MatrixPy::GetterSetter[] = {
    {"A11",
        (getter) staticCallback_getA11,
        (setter) staticCallback_setA11,
        "The (1,1) matrix element.",
        nullptr
    },
    {"A12",
        (getter) staticCallback_getA12,
        (setter) staticCallback_setA12,
        "The (1,2) matrix element.",
        nullptr
    },
    {"A13",
        (getter) staticCallback_getA13,
        (setter) staticCallback_setA13,
        "The (1,3) matrix element.",
        nullptr
    },
    {"A14",
        (getter) staticCallback_getA14,
        (setter) staticCallback_setA14,
        "The (1,4) matrix element.",
        nullptr
    },
    {"A21",
        (getter) staticCallback_getA21,
        (setter) staticCallback_setA21,
        "The (2,1) matrix element.",
        nullptr
    },
    {"A22",
        (getter) staticCallback_getA22,
        (setter) staticCallback_setA22,
        "The (2,2) matrix element.",
        nullptr
    },
    {"A23",
        (getter) staticCallback_getA23,
        (setter) staticCallback_setA23,
        "The (2,3) matrix element.",
        nullptr
    },
    {"A24",
        (getter) staticCallback_getA24,
        (setter) staticCallback_setA24,
        "The (2,4) matrix element.",
        nullptr
    },
    {"A31",
        (getter) staticCallback_getA31,
        (setter) staticCallback_setA31,
        "The (3,1) matrix element.",
        nullptr
    },
    {"A32",
        (getter) staticCallback_getA32,
        (setter) staticCallback_setA32,
        "The (3,2) matrix element.",
        nullptr
    },
    {"A33",
        (getter) staticCallback_getA33,
        (setter) staticCallback_setA33,
        "The (3,3) matrix element.",
        nullptr
    },
    {"A34",
        (getter) staticCallback_getA34,
        (setter) staticCallback_setA34,
        "The (3,4) matrix element.",
        nullptr
    },
    {"A41",
        (getter) staticCallback_getA41,
        (setter) staticCallback_setA41,
        "The (4,1) matrix element.",
        nullptr
    },
    {"A42",
        (getter) staticCallback_getA42,
        (setter) staticCallback_setA42,
        "The (4,2) matrix element.",
        nullptr
    },
    {"A43",
        (getter) staticCallback_getA43,
        (setter) staticCallback_setA43,
        "The (4,3) matrix element.",
        nullptr
    },
    {"A44",
        (getter) staticCallback_getA44,
        (setter) staticCallback_setA44,
        "The (4,4) matrix element.",
        nullptr
    },
    {"A",
        (getter) staticCallback_getA,
        (setter) staticCallback_setA,
        "The matrix elements.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// move() callback and implementer
// PyObject*  MatrixPy::move(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_move (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'move' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->move(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// scale() callback and implementer
// PyObject*  MatrixPy::scale(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_scale (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'scale' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->scale(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// hasScale() callback and implementer
// PyObject*  MatrixPy::hasScale(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_hasScale (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'hasScale' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->hasScale(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// nullify() callback and implementer
// PyObject*  MatrixPy::nullify(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_nullify (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'nullify' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->nullify(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isNull() callback and implementer
// PyObject*  MatrixPy::isNull(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_isNull (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isNull' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->isNull(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// unity() callback and implementer
// PyObject*  MatrixPy::unity(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_unity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'unity' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->unity(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isUnity() callback and implementer
// PyObject*  MatrixPy::isUnity(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_isUnity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isUnity' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->isUnity(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// transform() callback and implementer
// PyObject*  MatrixPy::transform(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_transform (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'transform' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->transform(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// col() callback and implementer
// PyObject*  MatrixPy::col(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_col (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'col' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->col(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setCol() callback and implementer
// PyObject*  MatrixPy::setCol(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_setCol (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setCol' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->setCol(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// row() callback and implementer
// PyObject*  MatrixPy::row(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_row (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'row' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->row(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setRow() callback and implementer
// PyObject*  MatrixPy::setRow(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_setRow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setRow' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->setRow(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// trace() callback and implementer
// PyObject*  MatrixPy::trace(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_trace (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'trace' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->trace(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setTrace() callback and implementer
// PyObject*  MatrixPy::setTrace(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_setTrace (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setTrace' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->setTrace(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// rotateX() callback and implementer
// PyObject*  MatrixPy::rotateX(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_rotateX (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'rotateX' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->rotateX(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// rotateY() callback and implementer
// PyObject*  MatrixPy::rotateY(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_rotateY (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'rotateY' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->rotateY(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// rotateZ() callback and implementer
// PyObject*  MatrixPy::rotateZ(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_rotateZ (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'rotateZ' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->rotateZ(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// multiply() callback and implementer
// PyObject*  MatrixPy::multiply(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_multiply (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'multiply' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->multiply(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// multVec() callback and implementer
// PyObject*  MatrixPy::multVec(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_multVec (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'multVec' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->multVec(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// invert() callback and implementer
// PyObject*  MatrixPy::invert(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_invert (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'invert' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->invert(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// inverse() callback and implementer
// PyObject*  MatrixPy::inverse(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_inverse (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'inverse' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->inverse(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// transpose() callback and implementer
// PyObject*  MatrixPy::transpose(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_transpose (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'transpose' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->transpose(args);
        if (ret != 0)
            static_cast<MatrixPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// transposed() callback and implementer
// PyObject*  MatrixPy::transposed(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_transposed (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'transposed' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->transposed(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// determinant() callback and implementer
// PyObject*  MatrixPy::determinant(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_determinant (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'determinant' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->determinant(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isOrthogonal() callback and implementer
// PyObject*  MatrixPy::isOrthogonal(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_isOrthogonal (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isOrthogonal' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->isOrthogonal(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// submatrix() callback and implementer
// PyObject*  MatrixPy::submatrix(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_submatrix (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'submatrix' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->submatrix(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// analyze() callback and implementer
// PyObject*  MatrixPy::analyze(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_analyze (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'analyze' of 'Base.Matrix' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<MatrixPy*>(self)->analyze(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// A11() callback and implementer
// PyObject*  MatrixPy::A11(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA11 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA11());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A11' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA11 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA11(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A11' of object 'Matrix'");
        return -1;
    }
}

// A12() callback and implementer
// PyObject*  MatrixPy::A12(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA12 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA12());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A12' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA12 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA12(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A12' of object 'Matrix'");
        return -1;
    }
}

// A13() callback and implementer
// PyObject*  MatrixPy::A13(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA13 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA13());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A13' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA13 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA13(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A13' of object 'Matrix'");
        return -1;
    }
}

// A14() callback and implementer
// PyObject*  MatrixPy::A14(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA14 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA14());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A14' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA14 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA14(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A14' of object 'Matrix'");
        return -1;
    }
}

// A21() callback and implementer
// PyObject*  MatrixPy::A21(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA21 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA21());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A21' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA21 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA21(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A21' of object 'Matrix'");
        return -1;
    }
}

// A22() callback and implementer
// PyObject*  MatrixPy::A22(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA22 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA22());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A22' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA22 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA22(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A22' of object 'Matrix'");
        return -1;
    }
}

// A23() callback and implementer
// PyObject*  MatrixPy::A23(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA23 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA23());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A23' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA23 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA23(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A23' of object 'Matrix'");
        return -1;
    }
}

// A24() callback and implementer
// PyObject*  MatrixPy::A24(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA24 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA24());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A24' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA24 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA24(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A24' of object 'Matrix'");
        return -1;
    }
}

// A31() callback and implementer
// PyObject*  MatrixPy::A31(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA31 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA31());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A31' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA31 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA31(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A31' of object 'Matrix'");
        return -1;
    }
}

// A32() callback and implementer
// PyObject*  MatrixPy::A32(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA32 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA32());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A32' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA32 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA32(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A32' of object 'Matrix'");
        return -1;
    }
}

// A33() callback and implementer
// PyObject*  MatrixPy::A33(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA33 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA33());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A33' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA33 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA33(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A33' of object 'Matrix'");
        return -1;
    }
}

// A34() callback and implementer
// PyObject*  MatrixPy::A34(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA34 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA34());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A34' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA34 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA34(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A34' of object 'Matrix'");
        return -1;
    }
}

// A41() callback and implementer
// PyObject*  MatrixPy::A41(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA41 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA41());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A41' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA41 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA41(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A41' of object 'Matrix'");
        return -1;
    }
}

// A42() callback and implementer
// PyObject*  MatrixPy::A42(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA42 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA42());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A42' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA42 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA42(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A42' of object 'Matrix'");
        return -1;
    }
}

// A43() callback and implementer
// PyObject*  MatrixPy::A43(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA43 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA43());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A43' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA43 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA43(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A43' of object 'Matrix'");
        return -1;
    }
}

// A44() callback and implementer
// PyObject*  MatrixPy::A44(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA44 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA44());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A44' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA44 (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA44(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A44' of object 'Matrix'");
        return -1;
    }
}

// A() callback and implementer
// PyObject*  MatrixPy::A(PyObject *args){};
// has to be implemented in MatrixPyImp.cpp
PyObject * MatrixPy::staticCallback_getA (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<MatrixPy*>(self)->getA());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'A' of object 'Matrix'");
        return nullptr;
    }
}

int MatrixPy::staticCallback_setA (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<MatrixPy*>(self)->setA(Py::Sequence(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'A' of object 'Matrix'");
        return -1;
    }
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
MatrixPy::MatrixPy(Matrix4D *pcObject, PyTypeObject *T)
    : PyObjectBase(static_cast<PyObjectBase::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
MatrixPy::~MatrixPy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    MatrixPy::PointerType ptr = static_cast<MatrixPy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// MatrixPy representation
//--------------------------------------------------------------------------
PyObject *MatrixPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// MatrixPy Attributes
//--------------------------------------------------------------------------
PyObject *MatrixPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return PyObjectBase::_getattr(attr);
}

int MatrixPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return PyObjectBase::_setattr(attr, value);
}

Matrix4D *MatrixPy::getMatrixPtr() const
{
    return static_cast<Matrix4D *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in MatrixPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *MatrixPy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // create a new instance of MatrixPy and the Twin object
    return new MatrixPy(new Matrix4D);
}

// constructor method
int MatrixPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string MatrixPy::representation() const
{
    return std::string("<Matrix object>");
}

PyObject* MatrixPy::move(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::scale(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::hasScale(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::nullify(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::isNull(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::unity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::isUnity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::transform(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::col(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::setCol(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::row(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::setRow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::trace(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::setTrace(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::rotateX(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::rotateY(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::rotateZ(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::multiply(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::multVec(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::invert(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::inverse(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::transpose(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::transposed(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::determinant(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::isOrthogonal(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::submatrix(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::analyze(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* MatrixPy::number_add_handler(PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject* MatrixPy::number_subtract_handler(PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject* MatrixPy::number_multiply_handler(PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_divide_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_remainder_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_divmod_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_power_handler (PyObject* /*self*/, PyObject* /*other*/, PyObject* /*modulo*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_negative_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_positive_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_absolute_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

int MatrixPy::number_nonzero_handler (PyObject* /*self*/)
{
    return 1;
}

PyObject * MatrixPy::number_invert_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_lshift_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_rshift_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_and_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_xor_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_or_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

int MatrixPy::number_coerce_handler (PyObject** /*self*/, PyObject** /*other*/)
{
    return 1;
}

PyObject * MatrixPy::number_int_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_long_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_float_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_oct_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * MatrixPy::number_hex_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject* MatrixPy::richCompare(PyObject *v, PyObject *w, int op)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

Py::Float MatrixPy::getA11() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA11(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA12() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA12(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA13() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA13(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA14() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA14(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA21() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA21(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA22() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA22(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA23() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA23(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA24() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA24(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA31() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA31(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA32() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA32(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA33() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA33(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA34() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA34(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA41() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA41(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA42() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA42(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA43() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA43(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float MatrixPy::getA44() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA44(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Sequence MatrixPy::getA() const
{
    //return Py::Sequence();
    throw Py::AttributeError("Not yet implemented");
}

void  MatrixPy::setA(Py::Sequence arg)
{
    throw Py::AttributeError("Not yet implemented");
}

PyObject *MatrixPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int MatrixPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



