
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in DocumentPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace App;

/// Type structure of DocumentPy
PyTypeObject DocumentPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "App.Document",     /*tp_name*/
    sizeof(DocumentPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "This is a Document class",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    App::DocumentPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    App::DocumentPy::GetterSetter,                     /*tp_getset */
    &App::PropertyContainerPy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    App::DocumentPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of DocumentPy
PyMethodDef DocumentPy::Methods[] = {
    {"save",
        reinterpret_cast<PyCFunction>( staticCallback_save ),
        METH_VARARGS,
        "Save the document to disk"
    },
    {"saveAs",
        reinterpret_cast<PyCFunction>( staticCallback_saveAs ),
        METH_VARARGS,
        "Save the document under a new name to disk"
    },
    {"saveCopy",
        reinterpret_cast<PyCFunction>( staticCallback_saveCopy ),
        METH_VARARGS,
        "Save a copy of the document under a new name to disk"
    },
    {"load",
        reinterpret_cast<PyCFunction>( staticCallback_load ),
        METH_VARARGS,
        "Load the document from the given path"
    },
    {"restore",
        reinterpret_cast<PyCFunction>( staticCallback_restore ),
        METH_VARARGS,
        "Restore the document from disk"
    },
    {"isSaved",
        reinterpret_cast<PyCFunction>( staticCallback_isSaved ),
        METH_VARARGS,
        "Checks if the document is saved"
    },
    {"getProgramVersion",
        reinterpret_cast<PyCFunction>( staticCallback_getProgramVersion ),
        METH_VARARGS,
        "Get the program version that a project file was created with"
    },
    {"getFileName",
        reinterpret_cast<PyCFunction>( staticCallback_getFileName ),
        METH_VARARGS,
        "\nFor a regular document it returns its file name property.\nFor a temporary document it returns its transient directory.\n        "
    },
    {"mergeProject",
        reinterpret_cast<PyCFunction>( staticCallback_mergeProject ),
        METH_VARARGS,
        "Merges this document with another project file"
    },
    {"exportGraphviz",
        reinterpret_cast<PyCFunction>( staticCallback_exportGraphviz ),
        METH_VARARGS,
        "Export the dependencies of the objects as graph"
    },
    {"openTransaction",
        reinterpret_cast<PyCFunction>( staticCallback_openTransaction ),
        METH_VARARGS,
        "openTransaction(name) - Open a new Undo/Redo transaction.\n\nThis function no long creates a new transaction, but calls\nFreeCAD.setActiveTransaction(name) instead, which will auto creates a\ntransaction with the given name when any change happed in any opened document.\nIf more than one document is changed, all newly created transactions will have\nthe same internal ID and will be undo/redo together.\n          "
    },
    {"abortTransaction",
        reinterpret_cast<PyCFunction>( staticCallback_abortTransaction ),
        METH_VARARGS,
        "Abort an Undo/Redo transaction (rollback)"
    },
    {"commitTransaction",
        reinterpret_cast<PyCFunction>( staticCallback_commitTransaction ),
        METH_VARARGS,
        "Commit an Undo/Redo transaction"
    },
    {"addObject",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) (void)>( staticCallback_addObject )),
        METH_VARARGS|METH_KEYWORDS,
        "addObject(type, name=None, objProxy=None, viewProxy=None, attach=False, viewType=None)\n\nAdd an object to document\n\ntype (String): the type of the document object to create.\nname (String): the optional name of the new object.\nobjProxy (Object): the Python binding object to attach to the new document object.\nviewProxy (Object): the Python binding object to attach the view provider of this object.\nattach (Boolean): if True, then bind the document object first before adding to the document\n        to allow Python code to override view provider type. Once bound, and before adding to\n        the document, it will try to call Python binding object's attach(obj) method.\nviewType (String): override the view provider type directly, only effective when attach is False."
    },
    {"addProperty",
        reinterpret_cast<PyCFunction>( staticCallback_addProperty ),
        METH_VARARGS,
        "\n                addProperty(string, string) -- Add a generic property.\n                The first argument specifies the type, the second the\n                name of the property.\n            "
    },
    {"removeProperty",
        reinterpret_cast<PyCFunction>( staticCallback_removeProperty ),
        METH_VARARGS,
        "\n                removeProperty(string) -- Remove a generic property.\n                Note, you can only remove user-defined properties but not built-in ones.\n            "
    },
    {"removeObject",
        reinterpret_cast<PyCFunction>( staticCallback_removeObject ),
        METH_VARARGS,
        "Remove an object from the document"
    },
    {"copyObject",
        reinterpret_cast<PyCFunction>( staticCallback_copyObject ),
        METH_VARARGS,
        "\ncopyObject(object, with_dependencies=False, return_all=False)\nCopy an object or objects from another document to this document.\n\nobject: can either a single object or sequence of objects\nwith_dependencies: if True, all internal dependent objects are copied too.\nreturn_all: if True, return all copied objects, or else return only the copied\n            object corresponding to the input objects.\n          "
    },
    {"moveObject",
        reinterpret_cast<PyCFunction>( staticCallback_moveObject ),
        METH_VARARGS,
        "\nmoveObject(object, bool with_dependencies = False)\nTransfers an object from another document to this document.\n\nobject: can either a single object or sequence of objects\nwith_dependencies: if True, all internal dependent objects are copied too.\n        "
    },
    {"importLinks",
        reinterpret_cast<PyCFunction>( staticCallback_importLinks ),
        METH_VARARGS,
        "\nimportLinks(object|[object...])\n\nImport any externally linked object given a list of objects in\nthis document.  Any link type properties of the input objects\nwill be automatically reassigned to the imported object\n\nIf no object is given as input, it import all externally linked\nobject of this document.\n          "
    },
    {"undo",
        reinterpret_cast<PyCFunction>( staticCallback_undo ),
        METH_VARARGS,
        "Undo one transaction"
    },
    {"redo",
        reinterpret_cast<PyCFunction>( staticCallback_redo ),
        METH_VARARGS,
        "Redo a previously undone transaction"
    },
    {"clearUndos",
        reinterpret_cast<PyCFunction>( staticCallback_clearUndos ),
        METH_VARARGS,
        "Clear the undo stack of the document"
    },
    {"clearDocument",
        reinterpret_cast<PyCFunction>( staticCallback_clearDocument ),
        METH_VARARGS,
        "Clear the whole document"
    },
    {"setClosable",
        reinterpret_cast<PyCFunction>( staticCallback_setClosable ),
        METH_VARARGS,
        "Set a flag that allows or forbids to close a document"
    },
    {"isClosable",
        reinterpret_cast<PyCFunction>( staticCallback_isClosable ),
        METH_VARARGS,
        "Check if the document can be closed. The default value is True"
    },
    {"recompute",
        reinterpret_cast<PyCFunction>( staticCallback_recompute ),
        METH_VARARGS,
        "recompute(objs=None): Recompute the document and returns the amount of recomputed features"
    },
    {"mustExecute",
        reinterpret_cast<PyCFunction>( staticCallback_mustExecute ),
        METH_VARARGS,
        "Check if any object must be recomputed"
    },
    {"purgeTouched",
        reinterpret_cast<PyCFunction>( staticCallback_purgeTouched ),
        METH_VARARGS,
        "Purge the touched state of all objects"
    },
    {"isTouched",
        reinterpret_cast<PyCFunction>( staticCallback_isTouched ),
        METH_VARARGS,
        "Check if any object is in touched state"
    },
    {"getObject",
        reinterpret_cast<PyCFunction>( staticCallback_getObject ),
        METH_VARARGS,
        "Return the object with the given name"
    },
    {"getObjectsByLabel",
        reinterpret_cast<PyCFunction>( staticCallback_getObjectsByLabel ),
        METH_VARARGS,
        "Return the objects with the given label name.\nNOTE: It's possible that several objects have the same label name."
    },
    {"findObjects",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) (void)>( staticCallback_findObjects )),
        METH_VARARGS|METH_KEYWORDS,
        "findObjects([Type=string], [Name=string], [Label=string]) -> list\nReturn a list of objects that match the specified type, name or label.\nName and label support regular expressions. All parameters are optional."
    },
    {"getLinksTo",
        reinterpret_cast<PyCFunction>( staticCallback_getLinksTo ),
        METH_VARARGS,
        "\ngetLinksTo(obj, options=0, maxCount=0): return objects linked to 'obj'\n\noptions: 1: recursive, 2: check link array. Options can combine.\nmaxCount: to limit the number of links returned\n            "
    },
    {"supportedTypes",
        reinterpret_cast<PyCFunction>( staticCallback_supportedTypes ),
        METH_VARARGS,
        "A list of supported types of objects"
    },
    {"getTempFileName",
        reinterpret_cast<PyCFunction>( staticCallback_getTempFileName ),
        METH_VARARGS,
        "Returns a file name with path in the temp directory of the document."
    },
    {"getDependentDocuments",
        reinterpret_cast<PyCFunction>( staticCallback_getDependentDocuments ),
        METH_VARARGS,
        "\ngetDependentDocuments(sort=True)\n\nReturns a list of documents that this document directly or indirectly links to including itself.\n\nsort: whether to topologically sort the return list\n              "
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of DocumentPy
PyGetSetDef DocumentPy::GetterSetter[] = {
    {"DependencyGraph",
        (getter) staticCallback_getDependencyGraph,
        (setter) staticCallback_setDependencyGraph,
        "The dependency graph as GraphViz text",
        nullptr
    },
    {"ActiveObject",
        (getter) staticCallback_getActiveObject,
        (setter) staticCallback_setActiveObject,
        "The active object of the document",
        nullptr
    },
    {"Objects",
        (getter) staticCallback_getObjects,
        (setter) staticCallback_setObjects,
        "The list of object handled by this document",
        nullptr
    },
    {"TopologicalSortedObjects",
        (getter) staticCallback_getTopologicalSortedObjects,
        (setter) staticCallback_setTopologicalSortedObjects,
        "The list of object of this document in topological sorted order",
        nullptr
    },
    {"RootObjects",
        (getter) staticCallback_getRootObjects,
        (setter) staticCallback_setRootObjects,
        "The list of root object of this document",
        nullptr
    },
    {"UndoMode",
        (getter) staticCallback_getUndoMode,
        (setter) staticCallback_setUndoMode,
        "The Undo mode of the Document (0 = no Undo, 1 = Undo/Redo)",
        nullptr
    },
    {"UndoRedoMemSize",
        (getter) staticCallback_getUndoRedoMemSize,
        (setter) staticCallback_setUndoRedoMemSize,
        "The size of the Undo stack in byte",
        nullptr
    },
    {"UndoCount",
        (getter) staticCallback_getUndoCount,
        (setter) staticCallback_setUndoCount,
        "Number of possible Undos",
        nullptr
    },
    {"RedoCount",
        (getter) staticCallback_getRedoCount,
        (setter) staticCallback_setRedoCount,
        "Number of possible Redos",
        nullptr
    },
    {"UndoNames",
        (getter) staticCallback_getUndoNames,
        (setter) staticCallback_setUndoNames,
        "A list of Undo names",
        nullptr
    },
    {"RedoNames",
        (getter) staticCallback_getRedoNames,
        (setter) staticCallback_setRedoNames,
        "A List of Redo names",
        nullptr
    },
    {"Name",
        (getter) staticCallback_getName,
        (setter) staticCallback_setName,
        "The internal name of the document",
        nullptr
    },
    {"RecomputesFrozen",
        (getter) staticCallback_getRecomputesFrozen,
        (setter) staticCallback_setRecomputesFrozen,
        "Returns or sets if automatic recomputes for this document are disabled.",
        nullptr
    },
    {"HasPendingTransaction",
        (getter) staticCallback_getHasPendingTransaction,
        (setter) staticCallback_setHasPendingTransaction,
        "Check if there is a pending transaction",
        nullptr
    },
    {"InList",
        (getter) staticCallback_getInList,
        (setter) staticCallback_setInList,
        "A list of all documents that link to this document.",
        nullptr
    },
    {"OutList",
        (getter) staticCallback_getOutList,
        (setter) staticCallback_setOutList,
        "A list of all documents that this document links to.",
        nullptr
    },
    {"Restoring",
        (getter) staticCallback_getRestoring,
        (setter) staticCallback_setRestoring,
        "Indicate if the document is restoring",
        nullptr
    },
    {"Partial",
        (getter) staticCallback_getPartial,
        (setter) staticCallback_setPartial,
        "Indicate if the document is partially loaded",
        nullptr
    },
    {"Importing",
        (getter) staticCallback_getImporting,
        (setter) staticCallback_setImporting,
        "Indicate if the document is importing. Note the document will also report Restoring while importing",
        nullptr
    },
    {"Recomputing",
        (getter) staticCallback_getRecomputing,
        (setter) staticCallback_setRecomputing,
        "Indicate if the document is recomputing",
        nullptr
    },
    {"Transacting",
        (getter) staticCallback_getTransacting,
        (setter) staticCallback_setTransacting,
        "Indicate whether the document is undoing/redoing",
        nullptr
    },
    {"OldLabel",
        (getter) staticCallback_getOldLabel,
        (setter) staticCallback_setOldLabel,
        "Contains the old label before change",
        nullptr
    },
    {"Temporary",
        (getter) staticCallback_getTemporary,
        (setter) staticCallback_setTemporary,
        "Check if this is a temporary document",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// save() callback and implementer
// PyObject*  DocumentPy::save(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_save (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'save' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->save(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// saveAs() callback and implementer
// PyObject*  DocumentPy::saveAs(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_saveAs (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'saveAs' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->saveAs(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// saveCopy() callback and implementer
// PyObject*  DocumentPy::saveCopy(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_saveCopy (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'saveCopy' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->saveCopy(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// load() callback and implementer
// PyObject*  DocumentPy::load(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_load (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'load' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->load(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// restore() callback and implementer
// PyObject*  DocumentPy::restore(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_restore (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'restore' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->restore(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isSaved() callback and implementer
// PyObject*  DocumentPy::isSaved(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_isSaved (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isSaved' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->isSaved(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getProgramVersion() callback and implementer
// PyObject*  DocumentPy::getProgramVersion(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getProgramVersion (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getProgramVersion' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->getProgramVersion(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getFileName() callback and implementer
// PyObject*  DocumentPy::getFileName(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getFileName (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getFileName' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->getFileName(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// mergeProject() callback and implementer
// PyObject*  DocumentPy::mergeProject(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_mergeProject (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'mergeProject' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->mergeProject(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exportGraphviz() callback and implementer
// PyObject*  DocumentPy::exportGraphviz(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_exportGraphviz (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exportGraphviz' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->exportGraphviz(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// openTransaction() callback and implementer
// PyObject*  DocumentPy::openTransaction(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_openTransaction (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'openTransaction' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->openTransaction(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// abortTransaction() callback and implementer
// PyObject*  DocumentPy::abortTransaction(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_abortTransaction (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'abortTransaction' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->abortTransaction(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// commitTransaction() callback and implementer
// PyObject*  DocumentPy::commitTransaction(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_commitTransaction (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'commitTransaction' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->commitTransaction(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addObject() callback and implementer
// PyObject*  DocumentPy::addObject(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_addObject (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addObject' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->addObject(args, kwd);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// addProperty() callback and implementer
// PyObject*  DocumentPy::addProperty(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_addProperty (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'addProperty' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->addProperty(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeProperty() callback and implementer
// PyObject*  DocumentPy::removeProperty(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_removeProperty (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeProperty' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->removeProperty(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeObject() callback and implementer
// PyObject*  DocumentPy::removeObject(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_removeObject (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeObject' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->removeObject(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// copyObject() callback and implementer
// PyObject*  DocumentPy::copyObject(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_copyObject (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'copyObject' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->copyObject(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// moveObject() callback and implementer
// PyObject*  DocumentPy::moveObject(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_moveObject (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'moveObject' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->moveObject(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// importLinks() callback and implementer
// PyObject*  DocumentPy::importLinks(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_importLinks (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'importLinks' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->importLinks(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// undo() callback and implementer
// PyObject*  DocumentPy::undo(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_undo (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'undo' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->undo(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// redo() callback and implementer
// PyObject*  DocumentPy::redo(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_redo (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'redo' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->redo(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// clearUndos() callback and implementer
// PyObject*  DocumentPy::clearUndos(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_clearUndos (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'clearUndos' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->clearUndos(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// clearDocument() callback and implementer
// PyObject*  DocumentPy::clearDocument(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_clearDocument (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'clearDocument' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->clearDocument(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setClosable() callback and implementer
// PyObject*  DocumentPy::setClosable(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_setClosable (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setClosable' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->setClosable(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isClosable() callback and implementer
// PyObject*  DocumentPy::isClosable(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_isClosable (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isClosable' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->isClosable(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// recompute() callback and implementer
// PyObject*  DocumentPy::recompute(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_recompute (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'recompute' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->recompute(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// mustExecute() callback and implementer
// PyObject*  DocumentPy::mustExecute(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_mustExecute (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'mustExecute' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->mustExecute(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// purgeTouched() callback and implementer
// PyObject*  DocumentPy::purgeTouched(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_purgeTouched (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'purgeTouched' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->purgeTouched(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isTouched() callback and implementer
// PyObject*  DocumentPy::isTouched(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_isTouched (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isTouched' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->isTouched(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getObject() callback and implementer
// PyObject*  DocumentPy::getObject(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getObject (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getObject' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->getObject(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getObjectsByLabel() callback and implementer
// PyObject*  DocumentPy::getObjectsByLabel(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getObjectsByLabel (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getObjectsByLabel' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->getObjectsByLabel(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// findObjects() callback and implementer
// PyObject*  DocumentPy::findObjects(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_findObjects (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'findObjects' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->findObjects(args, kwd);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getLinksTo() callback and implementer
// PyObject*  DocumentPy::getLinksTo(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getLinksTo (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getLinksTo' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->getLinksTo(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// supportedTypes() callback and implementer
// PyObject*  DocumentPy::supportedTypes(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_supportedTypes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'supportedTypes' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->supportedTypes(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getTempFileName() callback and implementer
// PyObject*  DocumentPy::getTempFileName(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getTempFileName (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getTempFileName' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->getTempFileName(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getDependentDocuments() callback and implementer
// PyObject*  DocumentPy::getDependentDocuments(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getDependentDocuments (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getDependentDocuments' of 'App.Document' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<DocumentPy*>(self)->getDependentDocuments(args);
        if (ret != 0)
            static_cast<DocumentPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// DependencyGraph() callback and implementer
// PyObject*  DocumentPy::DependencyGraph(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getDependencyGraph (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getDependencyGraph());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'DependencyGraph' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setDependencyGraph (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'DependencyGraph' of object 'Document' is read-only");
    return -1;
}

// ActiveObject() callback and implementer
// PyObject*  DocumentPy::ActiveObject(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getActiveObject (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getActiveObject());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ActiveObject' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setActiveObject (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'ActiveObject' of object 'Document' is read-only");
    return -1;
}

// Objects() callback and implementer
// PyObject*  DocumentPy::Objects(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getObjects (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getObjects());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Objects' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setObjects (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Objects' of object 'Document' is read-only");
    return -1;
}

// TopologicalSortedObjects() callback and implementer
// PyObject*  DocumentPy::TopologicalSortedObjects(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getTopologicalSortedObjects (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getTopologicalSortedObjects());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'TopologicalSortedObjects' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setTopologicalSortedObjects (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'TopologicalSortedObjects' of object 'Document' is read-only");
    return -1;
}

// RootObjects() callback and implementer
// PyObject*  DocumentPy::RootObjects(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getRootObjects (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getRootObjects());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'RootObjects' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setRootObjects (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'RootObjects' of object 'Document' is read-only");
    return -1;
}

// UndoMode() callback and implementer
// PyObject*  DocumentPy::UndoMode(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getUndoMode (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getUndoMode());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'UndoMode' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setUndoMode (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<DocumentPy*>(self)->setUndoMode(Py::Int(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'UndoMode' of object 'Document'");
        return -1;
    }
}

// UndoRedoMemSize() callback and implementer
// PyObject*  DocumentPy::UndoRedoMemSize(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getUndoRedoMemSize (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getUndoRedoMemSize());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'UndoRedoMemSize' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setUndoRedoMemSize (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'UndoRedoMemSize' of object 'Document' is read-only");
    return -1;
}

// UndoCount() callback and implementer
// PyObject*  DocumentPy::UndoCount(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getUndoCount (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getUndoCount());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'UndoCount' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setUndoCount (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'UndoCount' of object 'Document' is read-only");
    return -1;
}

// RedoCount() callback and implementer
// PyObject*  DocumentPy::RedoCount(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getRedoCount (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getRedoCount());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'RedoCount' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setRedoCount (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'RedoCount' of object 'Document' is read-only");
    return -1;
}

// UndoNames() callback and implementer
// PyObject*  DocumentPy::UndoNames(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getUndoNames (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getUndoNames());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'UndoNames' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setUndoNames (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'UndoNames' of object 'Document' is read-only");
    return -1;
}

// RedoNames() callback and implementer
// PyObject*  DocumentPy::RedoNames(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getRedoNames (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getRedoNames());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'RedoNames' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setRedoNames (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'RedoNames' of object 'Document' is read-only");
    return -1;
}

// Name() callback and implementer
// PyObject*  DocumentPy::Name(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getName (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getName());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Name' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setName (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Name' of object 'Document' is read-only");
    return -1;
}

// RecomputesFrozen() callback and implementer
// PyObject*  DocumentPy::RecomputesFrozen(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getRecomputesFrozen (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getRecomputesFrozen());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'RecomputesFrozen' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setRecomputesFrozen (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<DocumentPy*>(self)->setRecomputesFrozen(Py::Boolean(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'RecomputesFrozen' of object 'Document'");
        return -1;
    }
}

// HasPendingTransaction() callback and implementer
// PyObject*  DocumentPy::HasPendingTransaction(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getHasPendingTransaction (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getHasPendingTransaction());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'HasPendingTransaction' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setHasPendingTransaction (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'HasPendingTransaction' of object 'Document' is read-only");
    return -1;
}

// InList() callback and implementer
// PyObject*  DocumentPy::InList(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getInList (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getInList());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'InList' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setInList (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'InList' of object 'Document' is read-only");
    return -1;
}

// OutList() callback and implementer
// PyObject*  DocumentPy::OutList(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getOutList (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getOutList());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'OutList' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setOutList (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'OutList' of object 'Document' is read-only");
    return -1;
}

// Restoring() callback and implementer
// PyObject*  DocumentPy::Restoring(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getRestoring (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getRestoring());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Restoring' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setRestoring (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Restoring' of object 'Document' is read-only");
    return -1;
}

// Partial() callback and implementer
// PyObject*  DocumentPy::Partial(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getPartial (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getPartial());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Partial' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setPartial (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Partial' of object 'Document' is read-only");
    return -1;
}

// Importing() callback and implementer
// PyObject*  DocumentPy::Importing(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getImporting (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getImporting());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Importing' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setImporting (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Importing' of object 'Document' is read-only");
    return -1;
}

// Recomputing() callback and implementer
// PyObject*  DocumentPy::Recomputing(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getRecomputing (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getRecomputing());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Recomputing' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setRecomputing (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Recomputing' of object 'Document' is read-only");
    return -1;
}

// Transacting() callback and implementer
// PyObject*  DocumentPy::Transacting(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getTransacting (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getTransacting());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Transacting' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setTransacting (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Transacting' of object 'Document' is read-only");
    return -1;
}

// OldLabel() callback and implementer
// PyObject*  DocumentPy::OldLabel(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getOldLabel (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getOldLabel());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'OldLabel' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setOldLabel (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'OldLabel' of object 'Document' is read-only");
    return -1;
}

// Temporary() callback and implementer
// PyObject*  DocumentPy::Temporary(PyObject *args){};
// has to be implemented in DocumentPyImp.cpp
PyObject * DocumentPy::staticCallback_getTemporary (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<DocumentPy*>(self)->getTemporary());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Temporary' of object 'Document'");
        return nullptr;
    }
}

int DocumentPy::staticCallback_setTemporary (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Temporary' of object 'Document' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
DocumentPy::DocumentPy(Document *pcObject, PyTypeObject *T)
    : PropertyContainerPy(static_cast<PropertyContainerPy::PointerType>(pcObject), T)
{
}

PyObject *DocumentPy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // never create such objects with the constructor
    PyErr_SetString(PyExc_RuntimeError, "You cannot create directly an instance of 'DocumentPy'.");

    return nullptr;
}

int DocumentPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}

//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
DocumentPy::~DocumentPy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// DocumentPy representation
//--------------------------------------------------------------------------
PyObject *DocumentPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// DocumentPy Attributes
//--------------------------------------------------------------------------
PyObject *DocumentPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return PropertyContainerPy::_getattr(attr);
}

int DocumentPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return PropertyContainerPy::_setattr(attr, value);
}

Document *DocumentPy::getDocumentPtr() const
{
    return static_cast<Document *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in DocumentPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */



// returns a string which represents the object e.g. when printed in python
std::string DocumentPy::representation() const
{
    return std::string("<Document object>");
}

PyObject* DocumentPy::save(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::saveAs(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::saveCopy(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::load(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::restore(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::isSaved(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::getProgramVersion(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::getFileName(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::mergeProject(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::exportGraphviz(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::openTransaction(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::abortTransaction(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::commitTransaction(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::addObject(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::addProperty(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::removeProperty(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::removeObject(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::copyObject(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::moveObject(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::importLinks(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::undo(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::redo(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::clearUndos(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::clearDocument(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::setClosable(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::isClosable(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::recompute(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::mustExecute(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::purgeTouched(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::isTouched(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::getObject(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::getObjectsByLabel(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::findObjects(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::getLinksTo(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::supportedTypes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::getTempFileName(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* DocumentPy::getDependentDocuments(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::String DocumentPy::getDependencyGraph() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object DocumentPy::getActiveObject() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::List DocumentPy::getObjects() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List DocumentPy::getTopologicalSortedObjects() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List DocumentPy::getRootObjects() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::Int DocumentPy::getUndoMode() const
{
    //return Py::Int();
    throw Py::AttributeError("Not yet implemented");
}

void  DocumentPy::setUndoMode(Py::Int arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Int DocumentPy::getUndoRedoMemSize() const
{
    //return Py::Int();
    throw Py::AttributeError("Not yet implemented");
}

Py::Int DocumentPy::getUndoCount() const
{
    //return Py::Int();
    throw Py::AttributeError("Not yet implemented");
}

Py::Int DocumentPy::getRedoCount() const
{
    //return Py::Int();
    throw Py::AttributeError("Not yet implemented");
}

Py::List DocumentPy::getUndoNames() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List DocumentPy::getRedoNames() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::String DocumentPy::getName() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean DocumentPy::getRecomputesFrozen() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

void  DocumentPy::setRecomputesFrozen(Py::Boolean arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean DocumentPy::getHasPendingTransaction() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::List DocumentPy::getInList() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List DocumentPy::getOutList() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean DocumentPy::getRestoring() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean DocumentPy::getPartial() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean DocumentPy::getImporting() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean DocumentPy::getRecomputing() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean DocumentPy::getTransacting() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::String DocumentPy::getOldLabel() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean DocumentPy::getTemporary() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *DocumentPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int DocumentPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



