
/* Automatically generated struct definitions for the Data API.
 * Do not edit manually, changes will be overwritten.           */

#define RNA_RUNTIME

#include <float.h>
#include <stdio.h>
#include <limits.h>
#include <limits>
#include <string.h>

#include <stddef.h>

#include <algorithm>

#include "MEM_guardedalloc.h"

#include "DNA_ID.h"
#include "DNA_scene_types.h"
#include "DNA_node_types.h"
#include "BLI_fileops.h"

#include "BLI_listbase.h"

#include "BLI_path_utils.hh"

#include "BLI_rect.h"

#include "BLI_string.h"

#include "BLI_string_utf8.h"

#include "BLI_utildefines.h"

#include "BKE_context.hh"
#include "BKE_lib_id.hh"
#include "BKE_main.hh"
#include "BKE_report.hh"
#include "RNA_define.hh"
#include "RNA_types.hh"
#include "rna_internal.hh"

#include "rna_prototypes_gen.hh"

#include "rna_annotations.cc"

#pragma GCC diagnostic ignored "-Wunused-parameter"

/* Auto-generated Functions. */


extern PropertyRNA &rna_ID_rna_properties;
extern PropertyRNA &rna_ID_rna_type;
extern PropertyRNA &rna_ID_name;
extern PropertyRNA &rna_ID_name_full;
extern PropertyRNA &rna_ID_id_type;
extern PropertyRNA &rna_ID_session_uid;
extern PropertyRNA &rna_ID_is_evaluated;
extern PropertyRNA &rna_ID_original;
extern PropertyRNA &rna_ID_users;
extern PropertyRNA &rna_ID_use_fake_user;
extern PropertyRNA &rna_ID_use_extra_user;
extern PropertyRNA &rna_ID_is_embedded_data;
extern PropertyRNA &rna_ID_is_missing;
extern PropertyRNA &rna_ID_is_runtime_data;
extern PropertyRNA &rna_ID_is_editable;
extern PropertyRNA &rna_ID_tag;
extern PropertyRNA &rna_ID_is_library_indirect;
extern PropertyRNA &rna_ID_library;
extern PropertyRNA &rna_ID_library_weak_reference;
extern PropertyRNA &rna_ID_asset_data;
extern PropertyRNA &rna_ID_override_library;
extern PropertyRNA &rna_ID_preview;

extern PropertyRNA &rna_GreasePencil_layers;
extern PropertyRNA &rna_GreasePencil_animation_data;

extern FunctionRNA rna_ID_rename_func;
extern PropertyRNA &rna_ID_rename_name;
extern PropertyRNA &rna_ID_rename_mode;
extern PropertyRNA &rna_ID_rename_id_rename_result;

extern FunctionRNA rna_ID_evaluated_get_func;
extern PropertyRNA &rna_ID_evaluated_get_depsgraph;
extern PropertyRNA &rna_ID_evaluated_get_id;

extern FunctionRNA rna_ID_copy_func;
extern PropertyRNA &rna_ID_copy_id;

extern FunctionRNA rna_ID_asset_mark_func;
extern FunctionRNA rna_ID_asset_clear_func;
extern FunctionRNA rna_ID_asset_generate_preview_func;
extern FunctionRNA rna_ID_override_create_func;
extern PropertyRNA &rna_ID_override_create_id;
extern PropertyRNA &rna_ID_override_create_remap_local_usages;

extern FunctionRNA rna_ID_override_hierarchy_create_func;
extern PropertyRNA &rna_ID_override_hierarchy_create_id;
extern PropertyRNA &rna_ID_override_hierarchy_create_scene;
extern PropertyRNA &rna_ID_override_hierarchy_create_view_layer;
extern PropertyRNA &rna_ID_override_hierarchy_create_reference;
extern PropertyRNA &rna_ID_override_hierarchy_create_do_fully_editable;

extern FunctionRNA rna_ID_user_clear_func;
extern FunctionRNA rna_ID_user_remap_func;
extern PropertyRNA &rna_ID_user_remap_new_id;

extern FunctionRNA rna_ID_make_local_func;
extern PropertyRNA &rna_ID_make_local_clear_proxy;
extern PropertyRNA &rna_ID_make_local_clear_liboverride;
extern PropertyRNA &rna_ID_make_local_clear_asset_data;
extern PropertyRNA &rna_ID_make_local_id;

extern FunctionRNA rna_ID_user_of_id_func;
extern PropertyRNA &rna_ID_user_of_id_id;
extern PropertyRNA &rna_ID_user_of_id_count;

extern FunctionRNA rna_ID_animation_data_create_func;
extern PropertyRNA &rna_ID_animation_data_create_anim_data;

extern FunctionRNA rna_ID_animation_data_clear_func;
extern FunctionRNA rna_ID_update_tag_func;
extern PropertyRNA &rna_ID_update_tag_refresh;

extern FunctionRNA rna_ID_preview_ensure_func;
extern PropertyRNA &rna_ID_preview_ensure_preview_image;



extern PropertyRNA &rna_GreasePencilLayers_rna_properties;
extern PropertyRNA &rna_GreasePencilLayers_rna_type;
extern PropertyRNA &rna_GreasePencilLayers_active_index;
extern PropertyRNA &rna_GreasePencilLayers_active_note;

extern FunctionRNA rna_GreasePencilLayers_new_func;
extern PropertyRNA &rna_GreasePencilLayers_new_name;
extern PropertyRNA &rna_GreasePencilLayers_new_set_active;
extern PropertyRNA &rna_GreasePencilLayers_new_layer;

extern FunctionRNA rna_GreasePencilLayers_remove_func;
extern PropertyRNA &rna_GreasePencilLayers_remove_layer;



extern PropertyRNA &rna_GPencilLayer_rna_properties;
extern PropertyRNA &rna_GPencilLayer_rna_type;
extern PropertyRNA &rna_GPencilLayer_info;
extern PropertyRNA &rna_GPencilLayer_frames;
extern PropertyRNA &rna_GPencilLayer_active_frame;
extern PropertyRNA &rna_GPencilLayer_annotation_opacity;
extern PropertyRNA &rna_GPencilLayer_color;
extern PropertyRNA &rna_GPencilLayer_thickness;
extern PropertyRNA &rna_GPencilLayer_use_annotation_onion_skinning;
extern PropertyRNA &rna_GPencilLayer_annotation_onion_before_range;
extern PropertyRNA &rna_GPencilLayer_annotation_onion_after_range;
extern PropertyRNA &rna_GPencilLayer_annotation_onion_before_color;
extern PropertyRNA &rna_GPencilLayer_annotation_onion_after_color;
extern PropertyRNA &rna_GPencilLayer_annotation_onion_use_custom_color;
extern PropertyRNA &rna_GPencilLayer_annotation_hide;
extern PropertyRNA &rna_GPencilLayer_lock;
extern PropertyRNA &rna_GPencilLayer_lock_frame;
extern PropertyRNA &rna_GPencilLayer_is_ruler;
extern PropertyRNA &rna_GPencilLayer_select;
extern PropertyRNA &rna_GPencilLayer_show_in_front;


extern PropertyRNA &rna_GPencilFrames_rna_properties;
extern PropertyRNA &rna_GPencilFrames_rna_type;

extern FunctionRNA rna_GPencilFrames_new_func;
extern PropertyRNA &rna_GPencilFrames_new_frame_number;
extern PropertyRNA &rna_GPencilFrames_new_active;
extern PropertyRNA &rna_GPencilFrames_new_frame;

extern FunctionRNA rna_GPencilFrames_remove_func;
extern PropertyRNA &rna_GPencilFrames_remove_frame;

extern FunctionRNA rna_GPencilFrames_copy_func;
extern PropertyRNA &rna_GPencilFrames_copy_source;
extern PropertyRNA &rna_GPencilFrames_copy_copy;



extern PropertyRNA &rna_GPencilFrame_rna_properties;
extern PropertyRNA &rna_GPencilFrame_rna_type;
extern PropertyRNA &rna_GPencilFrame_strokes;
extern PropertyRNA &rna_GPencilFrame_frame_number;
extern PropertyRNA &rna_GPencilFrame_select;


extern PropertyRNA &rna_GPencilStroke_rna_properties;
extern PropertyRNA &rna_GPencilStroke_rna_type;
extern PropertyRNA &rna_GPencilStroke_points;


extern PropertyRNA &rna_GPencilStrokePoint_rna_properties;
extern PropertyRNA &rna_GPencilStrokePoint_rna_type;
extern PropertyRNA &rna_GPencilStrokePoint_co;

static PointerRNA GreasePencil_layers_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_GPencilLayer, rna_iterator_listbase_get(iter));
}

extern void GreasePencil_layers_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    bGPdata *data = (bGPdata *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GreasePencil_layers;

    rna_iterator_listbase_begin(iter, ptr, &data->layers, nullptr);

    if (iter->valid) {
        iter->ptr = GreasePencil_layers_get(iter);
    }
}

extern void GreasePencil_layers_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_listbase_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GreasePencil_layers_get(iter);
    }
}

extern void GreasePencil_layers_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GreasePencil_layers_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    GreasePencil_layers_begin(&iter, ptr);

    if (iter.valid) {
        ListBaseIterator *internal = &iter.internal.listbase;
        if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_listbase_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            while (index-- > 0 && internal->link) {
                internal->link = internal->link->next;
            }
            found = (index == -1 && internal->link);
        }
        if (found) { *r_ptr = GreasePencil_layers_get(&iter); }
    }

    GreasePencil_layers_end(&iter);

    return found;
}

extern int GPencilLayer_info_length(PointerRNA *);
extern void GPencilLayer_info_get(PointerRNA *, char *);

extern bool GreasePencil_layers_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;
    char namebuf[1024];
    char *name;

    GreasePencil_layers_begin(&iter, ptr);

    while (iter.valid) {
        if (iter.ptr.data) {
            int namelen = GPencilLayer_info_length(&iter.ptr);
            if (namelen < 1024) {
                GPencilLayer_info_get(&iter.ptr, namebuf);
                if (strcmp(namebuf, key) == 0) {
                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
            }
            else {
                name = MEM_malloc_arrayN<char>(size_t(namelen) + 1,
                                               "name string");
                GPencilLayer_info_get(&iter.ptr, name);
                if (strcmp(name, key) == 0) {
                    MEM_freeN(name);

                    found = true;
                    *r_ptr = iter.ptr;
                    break;
                }
                else {
                    MEM_freeN(name);
                }
            }
        }
        GreasePencil_layers_next(&iter);
    }
    GreasePencil_layers_end(&iter);

    return found;
}

extern PointerRNA GreasePencil_animation_data_get(PointerRNA *ptr)
{
    bGPdata *data = (bGPdata *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_AnimData, data->adt);
}

static PointerRNA GreasePencilLayers_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void GreasePencilLayers_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GreasePencilLayers_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = GreasePencilLayers_rna_properties_get(iter);
    }
}

extern void GreasePencilLayers_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GreasePencilLayers_rna_properties_get(iter);
    }
}

extern void GreasePencilLayers_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GreasePencilLayers_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA GreasePencilLayers_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int GreasePencilLayers_active_index_get(PointerRNA *ptr)
{
    PropIntGetFunc fn = rna_annotation_active_layer_index_get;
    return fn(ptr);
}

extern void GreasePencilLayers_active_index_set(PointerRNA *ptr, int value)
{
    PropIntSetFunc fn = rna_annotation_active_layer_index_set;
    fn(ptr, value);
}

extern int GreasePencilLayers_active_note_get(PointerRNA *ptr)
{
    PropEnumGetFunc fn = rna_annotation_active_layer_index_get;
    return fn(ptr);
}

extern void GreasePencilLayers_active_note_set(PointerRNA *ptr, int value)
{
    PropEnumSetFunc fn = rna_annotation_active_layer_index_set;
    fn(ptr, value);
}

static PointerRNA GPencilLayer_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void GPencilLayer_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilLayer_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = GPencilLayer_rna_properties_get(iter);
    }
}

extern void GPencilLayer_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilLayer_rna_properties_get(iter);
    }
}

extern void GPencilLayer_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GPencilLayer_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA GPencilLayer_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void GPencilLayer_info_get(PointerRNA *ptr, char *value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    strcpy(value, data->info);
}

extern int GPencilLayer_info_length(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return strlen(data->info);
}

extern void GPencilLayer_info_set(PointerRNA *ptr, const char *value)
{
    PropStringSetFunc fn = rna_annotation_layer_info_set;
    fn(ptr, value);
}

static PointerRNA GPencilLayer_frames_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_GPencilFrame, rna_iterator_listbase_get(iter));
}

extern void GPencilLayer_frames_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilLayer_frames;

    rna_iterator_listbase_begin(iter, ptr, &data->frames, nullptr);

    if (iter->valid) {
        iter->ptr = GPencilLayer_frames_get(iter);
    }
}

extern void GPencilLayer_frames_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_listbase_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilLayer_frames_get(iter);
    }
}

extern void GPencilLayer_frames_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GPencilLayer_frames_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    GPencilLayer_frames_begin(&iter, ptr);

    if (iter.valid) {
        ListBaseIterator *internal = &iter.internal.listbase;
        if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_listbase_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            while (index-- > 0 && internal->link) {
                internal->link = internal->link->next;
            }
            found = (index == -1 && internal->link);
        }
        if (found) { *r_ptr = GPencilLayer_frames_get(&iter); }
    }

    GPencilLayer_frames_end(&iter);

    return found;
}

extern PointerRNA GPencilLayer_active_frame_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return RNA_pointer_create_with_parent(*ptr, &RNA_GPencilFrame, data->actframe);
}

extern float GPencilLayer_annotation_opacity_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (float)(data->opacity);
}

extern void GPencilLayer_annotation_opacity_set(PointerRNA *ptr, float value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
#ifdef __cplusplus
    data->opacity = (std::remove_reference_t<decltype(data->opacity)>)std::clamp(value, 0.0f, 1.0f);
#else
    data->opacity = std::clamp(value, 0.0f, 1.0f);
#endif
}

extern void GPencilLayer_color_get(PointerRNA *ptr, float values[3])
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->color)[i]);
    }
}

extern void GPencilLayer_color_set(PointerRNA *ptr, const float values[3])
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->color)[i] = std::clamp(values[i], 0.0f, 1.0f);
    }
}

extern int GPencilLayer_thickness_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (int)(data->thickness);
}

extern void GPencilLayer_thickness_set(PointerRNA *ptr, int value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
#ifdef __cplusplus
    data->thickness = (std::remove_reference_t<decltype(data->thickness)>)std::clamp(value, 1, 10);
#else
    data->thickness = std::clamp(value, 1, 10);
#endif
}

extern bool GPencilLayer_use_annotation_onion_skinning_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (((data->onion_flag) & 1) != 0);
}

extern void GPencilLayer_use_annotation_onion_skinning_set(PointerRNA *ptr, bool value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    if (value) { data->onion_flag |= 1; }
    else { data->onion_flag &= ~1; }
}

extern int GPencilLayer_annotation_onion_before_range_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (int)(data->gstep);
}

extern void GPencilLayer_annotation_onion_before_range_set(PointerRNA *ptr, int value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
#ifdef __cplusplus
    data->gstep = (std::remove_reference_t<decltype(data->gstep)>)std::clamp(value, -1, 120);
#else
    data->gstep = std::clamp(value, -1, 120);
#endif
}

extern int GPencilLayer_annotation_onion_after_range_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (int)(data->gstep_next);
}

extern void GPencilLayer_annotation_onion_after_range_set(PointerRNA *ptr, int value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
#ifdef __cplusplus
    data->gstep_next = (std::remove_reference_t<decltype(data->gstep_next)>)std::clamp(value, -1, 120);
#else
    data->gstep_next = std::clamp(value, -1, 120);
#endif
}

extern void GPencilLayer_annotation_onion_before_color_get(PointerRNA *ptr, float values[3])
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->gcolor_prev)[i]);
    }
}

extern void GPencilLayer_annotation_onion_before_color_set(PointerRNA *ptr, const float values[3])
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->gcolor_prev)[i] = std::clamp(values[i], 0.0f, 1.0f);
    }
}

extern void GPencilLayer_annotation_onion_after_color_get(PointerRNA *ptr, float values[3])
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)(((float *)data->gcolor_next)[i]);
    }
}

extern void GPencilLayer_annotation_onion_after_color_set(PointerRNA *ptr, const float values[3])
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        ((float *)data->gcolor_next)[i] = std::clamp(values[i], 0.0f, 1.0f);
    }
}

extern bool GPencilLayer_annotation_onion_use_custom_color_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (((data->onion_flag) & 2) != 0);
}

extern void GPencilLayer_annotation_onion_use_custom_color_set(PointerRNA *ptr, bool value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    if (value) { data->onion_flag |= 2; }
    else { data->onion_flag &= ~2; }
}

extern bool GPencilLayer_annotation_hide_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (((data->flag) & 1) != 0);
}

extern void GPencilLayer_annotation_hide_set(PointerRNA *ptr, bool value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    if (value) { data->flag |= 1; }
    else { data->flag &= ~1; }
}

extern bool GPencilLayer_lock_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (((data->flag) & 2) != 0);
}

extern void GPencilLayer_lock_set(PointerRNA *ptr, bool value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    if (value) { data->flag |= 2; }
    else { data->flag &= ~2; }
}

extern bool GPencilLayer_lock_frame_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (((data->flag) & 64) != 0);
}

extern void GPencilLayer_lock_frame_set(PointerRNA *ptr, bool value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    if (value) { data->flag |= 64; }
    else { data->flag &= ~64; }
}

extern bool GPencilLayer_is_ruler_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (((data->flag) & 16384) != 0);
}

extern bool GPencilLayer_select_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return (((data->flag) & 32) != 0);
}

extern void GPencilLayer_select_set(PointerRNA *ptr, bool value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    if (value) { data->flag |= 32; }
    else { data->flag &= ~32; }
}

extern bool GPencilLayer_show_in_front_get(PointerRNA *ptr)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    return !(((data->flag) & 128) != 0);
}

extern void GPencilLayer_show_in_front_set(PointerRNA *ptr, bool value)
{
    bGPDlayer *data = (bGPDlayer *)(ptr->data);
    if (!value) { data->flag |= 128; }
    else { data->flag &= ~128; }
}

static PointerRNA GPencilFrames_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void GPencilFrames_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilFrames_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = GPencilFrames_rna_properties_get(iter);
    }
}

extern void GPencilFrames_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilFrames_rna_properties_get(iter);
    }
}

extern void GPencilFrames_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GPencilFrames_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA GPencilFrames_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

static PointerRNA GPencilFrame_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void GPencilFrame_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilFrame_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = GPencilFrame_rna_properties_get(iter);
    }
}

extern void GPencilFrame_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilFrame_rna_properties_get(iter);
    }
}

extern void GPencilFrame_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GPencilFrame_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA GPencilFrame_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

static PointerRNA GPencilFrame_strokes_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_GPencilStroke, rna_iterator_listbase_get(iter));
}

extern void GPencilFrame_strokes_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    bGPDframe *data = (bGPDframe *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilFrame_strokes;

    rna_iterator_listbase_begin(iter, ptr, &data->strokes, nullptr);

    if (iter->valid) {
        iter->ptr = GPencilFrame_strokes_get(iter);
    }
}

extern void GPencilFrame_strokes_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_listbase_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilFrame_strokes_get(iter);
    }
}

extern void GPencilFrame_strokes_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GPencilFrame_strokes_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    GPencilFrame_strokes_begin(&iter, ptr);

    if (iter.valid) {
        ListBaseIterator *internal = &iter.internal.listbase;
        if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_listbase_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            while (index-- > 0 && internal->link) {
                internal->link = internal->link->next;
            }
            found = (index == -1 && internal->link);
        }
        if (found) { *r_ptr = GPencilFrame_strokes_get(&iter); }
    }

    GPencilFrame_strokes_end(&iter);

    return found;
}

extern int GPencilFrame_frame_number_get(PointerRNA *ptr)
{
    bGPDframe *data = (bGPDframe *)(ptr->data);
    return (int)(data->framenum);
}

extern void GPencilFrame_frame_number_set(PointerRNA *ptr, int value)
{
    bGPDframe *data = (bGPDframe *)(ptr->data);
#ifdef __cplusplus
    data->framenum = (std::remove_reference_t<decltype(data->framenum)>)std::clamp(value, -1048574, 1048574);
#else
    data->framenum = std::clamp(value, -1048574, 1048574);
#endif
}

extern bool GPencilFrame_select_get(PointerRNA *ptr)
{
    bGPDframe *data = (bGPDframe *)(ptr->data);
    return (((data->flag) & 2) != 0);
}

extern void GPencilFrame_select_set(PointerRNA *ptr, bool value)
{
    bGPDframe *data = (bGPDframe *)(ptr->data);
    if (value) { data->flag |= 2; }
    else { data->flag &= ~2; }
}

static PointerRNA GPencilStroke_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void GPencilStroke_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilStroke_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = GPencilStroke_rna_properties_get(iter);
    }
}

extern void GPencilStroke_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilStroke_rna_properties_get(iter);
    }
}

extern void GPencilStroke_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GPencilStroke_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA GPencilStroke_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern int GPencilStroke_points_length(PointerRNA *ptr)
{
    bGPDstroke *data = (bGPDstroke *)(ptr->data);
    return (data->points == nullptr) ? 0 : data->totpoints;
}

static PointerRNA GPencilStroke_points_get(CollectionPropertyIterator *iter)
{
    return RNA_pointer_create_with_parent(iter->parent, &RNA_GPencilStrokePoint, rna_iterator_array_get(iter));
}

extern void GPencilStroke_points_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{
    bGPDstroke *data = (bGPDstroke *)(ptr->data);

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilStroke_points;

    rna_iterator_array_begin(iter, ptr, data->points, sizeof(data->points[0]), data->totpoints, 0, nullptr);

    if (iter->valid) {
        iter->ptr = GPencilStroke_points_get(iter);
    }
}

extern void GPencilStroke_points_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_iterator_array_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilStroke_points_get(iter);
    }
}

extern void GPencilStroke_points_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_array_end;
    fn(iter);
}

extern bool GPencilStroke_points_lookup_int(PointerRNA *ptr, int index, PointerRNA *r_ptr)
{
    bool found = false;
    CollectionPropertyIterator iter;

    GPencilStroke_points_begin(&iter, ptr);

    if (iter.valid) {
        ArrayIterator *internal = &iter.internal.array;
        if (index < 0 || index >= internal->length) {
#ifdef __GNUC__
            printf("Array iterator out of range: %s (index %d)\n", __func__, index);
#else
            printf("Array iterator out of range: (index %d)\n", index);
#endif
        }
        else if (internal->skip) {
            while (index-- > 0 && iter.valid) {
                rna_iterator_array_next(&iter);
            }
            found = (index == -1 && iter.valid);
        }
        else {
            internal->ptr += internal->itemsize * index;
            found = 1;
        }
        if (found) { *r_ptr = GPencilStroke_points_get(&iter); }
    }

    GPencilStroke_points_end(&iter);

    return found;
}

static PointerRNA GPencilStrokePoint_rna_properties_get(CollectionPropertyIterator *iter)
{
    PropCollectionGetFunc fn = rna_builtin_properties_get;
    return fn(iter);
}

extern void GPencilStrokePoint_rna_properties_begin(CollectionPropertyIterator *iter, PointerRNA *ptr)
{

    *iter = {};
    iter->parent = *ptr;
    iter->prop = &rna_GPencilStrokePoint_rna_properties;

    PropCollectionBeginFunc fn = rna_builtin_properties_begin;
    fn(iter, ptr);

    if (iter->valid) {
        iter->ptr = GPencilStrokePoint_rna_properties_get(iter);
    }
}

extern void GPencilStrokePoint_rna_properties_next(CollectionPropertyIterator *iter)
{
    PropCollectionNextFunc fn = rna_builtin_properties_next;
    fn(iter);

    if (iter->valid) {
        iter->ptr = GPencilStrokePoint_rna_properties_get(iter);
    }
}

extern void GPencilStrokePoint_rna_properties_end(CollectionPropertyIterator *iter)
{
    PropCollectionEndFunc fn = rna_iterator_listbase_end;
    fn(iter);
}

extern bool GPencilStrokePoint_rna_properties_lookup_string(PointerRNA *ptr, const char *key, PointerRNA *r_ptr)
{
    PropCollectionLookupStringFunc fn = rna_builtin_properties_lookup_string;
    return fn(ptr, key, r_ptr);
}

extern PointerRNA GPencilStrokePoint_rna_type_get(PointerRNA *ptr)
{
    PropPointerGetFunc fn = rna_builtin_type_get;
    return fn(ptr);
}

extern void GPencilStrokePoint_co_get(PointerRNA *ptr, float values[3])
{
    bGPDspoint *data = (bGPDspoint *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        values[i] = (float)((&data->x)[i]);
    }
}

extern void GPencilStrokePoint_co_set(PointerRNA *ptr, const float values[3])
{
    bGPDspoint *data = (bGPDspoint *)(ptr->data);
    unsigned int i;

    for (i = 0; i < 3; i++) {
        (&data->x)[i] = values[i];
    }
}


extern struct bGPDlayer *GreasePencilLayers_new_func(struct bGPdata *_self, const char * name, bool set_active)
{
	return rna_annotation_layer_new(_self, name, set_active);
}

static void GreasePencilLayers_new_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct bGPdata *_self;
	const char * name;
	bool set_active;
	struct bGPDlayer *layer;
	char *_data, *_retdata;
	
	_self = (struct bGPdata *)_ptr->data;
	_data = (char *)_parms->data;
	name = *((const char * *)_data);
	_data += 8;
	set_active = *((bool *)_data);
	_data += 8;
	_retdata = _data;
	
	layer = rna_annotation_layer_new(_self, name, set_active);
	*((struct bGPDlayer **)_retdata) = layer;
}

extern void GreasePencilLayers_remove_func(struct bGPdata *_self, ReportList *reports, struct PointerRNA *layer)
{
	rna_annotation_layer_remove(_self, reports, layer);
}

static void GreasePencilLayers_remove_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct bGPdata *_self;
	struct PointerRNA *layer;
	char *_data;
	
	_self = (struct bGPdata *)_ptr->data;
	_data = (char *)_parms->data;
	layer = *((struct PointerRNA **)_data);
	
	rna_annotation_layer_remove(_self, reports, layer);
}

/* Repeated prototypes to detect errors */

struct bGPDlayer *rna_annotation_layer_new(struct bGPdata *_self, const char * name, bool set_active);
void rna_annotation_layer_remove(struct bGPdata *_self, ReportList *reports, struct PointerRNA *layer);


extern struct bGPDframe *GPencilFrames_new_func(struct bGPDlayer *_self, ReportList *reports, int frame_number, bool active)
{
	return rna_annotation_frame_new(_self, reports, frame_number, active);
}

static void GPencilFrames_new_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct bGPDlayer *_self;
	int frame_number;
	bool active;
	struct bGPDframe *frame;
	char *_data, *_retdata;
	
	_self = (struct bGPDlayer *)_ptr->data;
	_data = (char *)_parms->data;
	frame_number = *((int *)_data);
	_data += 8;
	active = *((bool *)_data);
	_data += 8;
	_retdata = _data;
	
	frame = rna_annotation_frame_new(_self, reports, frame_number, active);
	*((struct bGPDframe **)_retdata) = frame;
}

extern void GPencilFrames_remove_func(struct bGPDlayer *_self, ReportList *reports, struct PointerRNA *frame)
{
	rna_annotation_frame_remove(_self, reports, frame);
}

static void GPencilFrames_remove_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct bGPDlayer *_self;
	struct PointerRNA *frame;
	char *_data;
	
	_self = (struct bGPDlayer *)_ptr->data;
	_data = (char *)_parms->data;
	frame = *((struct PointerRNA **)_data);
	
	rna_annotation_frame_remove(_self, reports, frame);
}

extern struct bGPDframe *GPencilFrames_copy_func(struct bGPDlayer *_self, struct bGPDframe *source)
{
	return rna_annotation_frame_copy(_self, source);
}

static void GPencilFrames_copy_call(bContext *C, ReportList *reports, PointerRNA *_ptr, ParameterList *_parms)
{
	struct bGPDlayer *_self;
	struct bGPDframe *source;
	struct bGPDframe *copy;
	char *_data, *_retdata;
	
	_self = (struct bGPDlayer *)_ptr->data;
	_data = (char *)_parms->data;
	source = *((struct bGPDframe **)_data);
	_data += 8;
	_retdata = _data;
	
	copy = rna_annotation_frame_copy(_self, source);
	*((struct bGPDframe **)_retdata) = copy;
}

/* Repeated prototypes to detect errors */

struct bGPDframe *rna_annotation_frame_new(struct bGPDlayer *_self, ReportList *reports, int frame_number, bool active);
void rna_annotation_frame_remove(struct bGPDlayer *_self, ReportList *reports, struct PointerRNA *frame);
struct bGPDframe *rna_annotation_frame_copy(struct bGPDlayer *_self, struct bGPDframe *source);




/* Annotation */
static CollectionPropertyRNA rna_GreasePencil_layers_ = {
	{&rna_GreasePencil_animation_data, nullptr,
	-1, "layers", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Layers",
	"",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, &RNA_GreasePencilLayers},
	GreasePencil_layers_begin, GreasePencil_layers_next, GreasePencil_layers_end, GreasePencil_layers_get, nullptr, GreasePencil_layers_lookup_int, GreasePencil_layers_lookup_string, nullptr, &RNA_GPencilLayer
};
PropertyRNA &rna_GreasePencil_layers = reinterpret_cast<PropertyRNA &>(rna_GreasePencil_layers_);

static PointerPropertyRNA rna_GreasePencil_animation_data_ = {
	{nullptr, &rna_GreasePencil_layers,
	-1, "animation_data", 8388608, 1, 0, 0, 0, PropertyPathTemplateType(0), "Animation Data",
	"Animation data for this data-block",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, rna_AnimaData_override_apply,
	0, PROP_RAW_UNSET, nullptr},
	GreasePencil_animation_data_get, nullptr, nullptr, nullptr,&RNA_AnimData
};
PropertyRNA &rna_GreasePencil_animation_data = reinterpret_cast<PropertyRNA &>(rna_GreasePencil_animation_data_);

StructRNA RNA_GreasePencil = {
	{(ContainerRNA *)&RNA_GreasePencilLayers, (ContainerRNA *)&RNA_FModifierStepped,
	nullptr,
	{&rna_GreasePencil_layers, &rna_GreasePencil_animation_data}},
	"GreasePencil", nullptr, nullptr, 519, nullptr, "Annotation",
	"Freehand annotation sketchbook",
	"*", 248,
	&rna_ID_name, &rna_ID_rna_properties,
	&RNA_ID,
	nullptr,
	rna_ID_refine,
	nullptr,
	nullptr,
	nullptr,
	rna_ID_instance,
	rna_ID_idprops,
	{nullptr, nullptr}
};

/* Annotation Layers */
static CollectionPropertyRNA rna_GreasePencilLayers_rna_properties_ = {
	{&rna_GreasePencilLayers_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GreasePencilLayers_rna_properties_begin, GreasePencilLayers_rna_properties_next, GreasePencilLayers_rna_properties_end, GreasePencilLayers_rna_properties_get, nullptr, nullptr, GreasePencilLayers_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_GreasePencilLayers_rna_properties = reinterpret_cast<PropertyRNA &>(rna_GreasePencilLayers_rna_properties_);

static PointerPropertyRNA rna_GreasePencilLayers_rna_type_ = {
	{&rna_GreasePencilLayers_active_index, &rna_GreasePencilLayers_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GreasePencilLayers_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_GreasePencilLayers_rna_type = reinterpret_cast<PropertyRNA &>(rna_GreasePencilLayers_rna_type_);

static IntPropertyRNA rna_GreasePencilLayers_active_index_ = {
	{&rna_GreasePencilLayers_active_note, &rna_GreasePencilLayers_rna_type,
	-1, "active_index", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Active Layer Index",
	"Index of active annotation layer",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_UNSIGNED) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 391839750, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GreasePencilLayers_active_index_get, GreasePencilLayers_active_index_set, nullptr, nullptr, rna_annotation_active_layer_index_range, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 0, 10000, 0, INT_MAX, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GreasePencilLayers_active_index = reinterpret_cast<PropertyRNA &>(rna_GreasePencilLayers_active_index_);

static EnumPropertyRNA rna_GreasePencilLayers_active_note_ = {
	{nullptr, &rna_GreasePencilLayers_active_index,
	-1, "active_note", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Active Note",
	"Note/Layer to add annotation strokes to",
	0, "*",
	PROP_ENUM, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GreasePencilLayers_active_note_get, GreasePencilLayers_active_note_set, rna_annotation_active_layer_itemf, nullptr, nullptr, nullptr, rna_enum_dummy_DEFAULT_items, 1, 0
};
PropertyRNA &rna_GreasePencilLayers_active_note = reinterpret_cast<PropertyRNA &>(rna_GreasePencilLayers_active_note_);

static StringPropertyRNA rna_GreasePencilLayers_new_name_ = {
	{&rna_GreasePencilLayers_new_set_active, nullptr,
	-1, "name", 262145, 0, 1, 0, 0, PropertyPathTemplateType(0), "Name",
	"Name of the layer",
	0, "*",
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 64, "Layer"
};
PropertyRNA &rna_GreasePencilLayers_new_name = reinterpret_cast<PropertyRNA &>(rna_GreasePencilLayers_new_name_);

static BoolPropertyRNA rna_GreasePencilLayers_new_set_active_ = {
	{&rna_GreasePencilLayers_new_layer, &rna_GreasePencilLayers_new_name,
	-1, "set_active", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Set Active",
	"Set the newly created layer to the active layer",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_GreasePencilLayers_new_set_active = reinterpret_cast<PropertyRNA &>(rna_GreasePencilLayers_new_set_active_);

static PointerPropertyRNA rna_GreasePencilLayers_new_layer_ = {
	{nullptr, &rna_GreasePencilLayers_new_set_active,
	-1, "layer", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"The newly created layer",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_GPencilLayer
};
PropertyRNA &rna_GreasePencilLayers_new_layer = reinterpret_cast<PropertyRNA &>(rna_GreasePencilLayers_new_layer_);

FunctionRNA rna_GreasePencilLayers_new_func = {
	{(FunctionRNA *)&rna_GreasePencilLayers_remove_func, nullptr,
	nullptr,
	{&rna_GreasePencilLayers_new_name, &rna_GreasePencilLayers_new_layer}},
	"new", 0, "Add a new annotation layer",
	GreasePencilLayers_new_call,
	&rna_GreasePencilLayers_new_layer
};

static PointerPropertyRNA rna_GreasePencilLayers_remove_layer_ = {
	{nullptr, nullptr,
	-1, "layer", 262144, 0, 5, 0, 0, PropertyPathTemplateType(0), "",
	"The layer to remove",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_GPencilLayer
};
PropertyRNA &rna_GreasePencilLayers_remove_layer = reinterpret_cast<PropertyRNA &>(rna_GreasePencilLayers_remove_layer_);

FunctionRNA rna_GreasePencilLayers_remove_func = {
	{nullptr, (FunctionRNA *)&rna_GreasePencilLayers_new_func,
	nullptr,
	{&rna_GreasePencilLayers_remove_layer, &rna_GreasePencilLayers_remove_layer}},
	"remove", 16, "Remove a annotation layer",
	GreasePencilLayers_remove_call,
	nullptr
};

StructRNA RNA_GreasePencilLayers = {
	{(ContainerRNA *)&RNA_GPencilLayer, (ContainerRNA *)&RNA_GreasePencil,
	nullptr,
	{&rna_GreasePencilLayers_rna_properties, &rna_GreasePencilLayers_active_note}},
	"GreasePencilLayers", nullptr, nullptr, 516, nullptr, "Annotation Layers",
	"Collection of annotation layers",
	"*", 61,
	nullptr, &rna_GreasePencilLayers_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_GreasePencilLayers_new_func, (FunctionRNA *)&rna_GreasePencilLayers_remove_func}
};

/* Annotation Layer */
static CollectionPropertyRNA rna_GPencilLayer_rna_properties_ = {
	{&rna_GPencilLayer_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_rna_properties_begin, GPencilLayer_rna_properties_next, GPencilLayer_rna_properties_end, GPencilLayer_rna_properties_get, nullptr, nullptr, GPencilLayer_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_GPencilLayer_rna_properties = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_rna_properties_);

static PointerPropertyRNA rna_GPencilLayer_rna_type_ = {
	{&rna_GPencilLayer_info, &rna_GPencilLayer_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_GPencilLayer_rna_type = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_rna_type_);

static StringPropertyRNA rna_GPencilLayer_info_ = {
	{&rna_GPencilLayer_frames, &rna_GPencilLayer_rna_type,
	-1, "info", 262145, 0, 0, 0, 0, PropertyPathTemplateType(0), "Info",
	"Layer name",
	0, "*",
	PROP_STRING, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {128, 0, 0}, 0,
	rna_annotation_update, 391839749, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_info_get, GPencilLayer_info_length, GPencilLayer_info_set, nullptr, nullptr, nullptr, nullptr, eStringPropertySearchFlag(0), nullptr, 128, ""
};
PropertyRNA &rna_GPencilLayer_info = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_info_);

static CollectionPropertyRNA rna_GPencilLayer_frames_ = {
	{&rna_GPencilLayer_active_frame, &rna_GPencilLayer_info,
	-1, "frames", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Frames",
	"Sketches for this layer on different frames",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, &RNA_GPencilFrames},
	GPencilLayer_frames_begin, GPencilLayer_frames_next, GPencilLayer_frames_end, GPencilLayer_frames_get, nullptr, GPencilLayer_frames_lookup_int, nullptr, nullptr, &RNA_GPencilFrame
};
PropertyRNA &rna_GPencilLayer_frames = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_frames_);

static PointerPropertyRNA rna_GPencilLayer_active_frame_ = {
	{&rna_GPencilLayer_annotation_opacity, &rna_GPencilLayer_frames,
	-1, "active_frame", 8388608, 0, 0, 0, 0, PropertyPathTemplateType(0), "Active Frame",
	"Frame currently being displayed for this layer",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 391839744, rna_annotation_layer_active_frame_editable, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_active_frame_get, nullptr, nullptr, nullptr,&RNA_GPencilFrame
};
PropertyRNA &rna_GPencilLayer_active_frame = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_active_frame_);

static FloatPropertyRNA rna_GPencilLayer_annotation_opacity_ = {
	{&rna_GPencilLayer_color, &rna_GPencilLayer_active_frame,
	-1, "annotation_opacity", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Opacity",
	"Annotation Layer Opacity",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bGPDlayer, opacity), RawPropertyType(5), nullptr},
	GPencilLayer_annotation_opacity_get, GPencilLayer_annotation_opacity_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.0f, nullptr
};
PropertyRNA &rna_GPencilLayer_annotation_opacity = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_annotation_opacity_);

static float rna_GPencilLayer_color_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_GPencilLayer_color_ = {
	{&rna_GPencilLayer_thickness, &rna_GPencilLayer_annotation_opacity,
	-1, "color", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Color",
	"Color for all strokes in this layer",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_COLOR_GAMMA) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bGPDlayer, color), RawPropertyType(5), nullptr},
	nullptr, nullptr, GPencilLayer_color_get, GPencilLayer_color_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.0f, rna_GPencilLayer_color_default
};
PropertyRNA &rna_GPencilLayer_color = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_color_);

static IntPropertyRNA rna_GPencilLayer_thickness_ = {
	{&rna_GPencilLayer_use_annotation_onion_skinning, &rna_GPencilLayer_color,
	-1, "thickness", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Thickness",
	"Thickness of annotation strokes",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_PIXEL) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bGPDlayer, thickness), RawPropertyType(1), nullptr},
	GPencilLayer_thickness_get, GPencilLayer_thickness_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, 1, 10, 1, 10, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_thickness = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_thickness_);

static BoolPropertyRNA rna_GPencilLayer_use_annotation_onion_skinning_ = {
	{&rna_GPencilLayer_annotation_onion_before_range, &rna_GPencilLayer_thickness,
	-1, "use_annotation_onion_skinning", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Onion Skinning",
	"Display annotation onion skins before and after the current frame",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_use_annotation_onion_skinning_get, GPencilLayer_use_annotation_onion_skinning_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_use_annotation_onion_skinning = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_use_annotation_onion_skinning_);

static IntPropertyRNA rna_GPencilLayer_annotation_onion_before_range_ = {
	{&rna_GPencilLayer_annotation_onion_after_range, &rna_GPencilLayer_use_annotation_onion_skinning,
	-1, "annotation_onion_before_range", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Frames Before",
	"Maximum number of frames to show before current frame",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bGPDlayer, gstep), RawPropertyType(1), nullptr},
	GPencilLayer_annotation_onion_before_range_get, GPencilLayer_annotation_onion_before_range_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -1, 120, -1, 120, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_annotation_onion_before_range = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_annotation_onion_before_range_);

static IntPropertyRNA rna_GPencilLayer_annotation_onion_after_range_ = {
	{&rna_GPencilLayer_annotation_onion_before_color, &rna_GPencilLayer_annotation_onion_before_range,
	-1, "annotation_onion_after_range", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Frames After",
	"Maximum number of frames to show after current frame",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bGPDlayer, gstep_next), RawPropertyType(1), nullptr},
	GPencilLayer_annotation_onion_after_range_get, GPencilLayer_annotation_onion_after_range_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -1, 120, -1, 120, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_annotation_onion_after_range = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_annotation_onion_after_range_);

static float rna_GPencilLayer_annotation_onion_before_color_default[3] = {
	0.3019999862f,
	0.8510000110f,
	0.3019999862f
};

static FloatPropertyRNA rna_GPencilLayer_annotation_onion_before_color_ = {
	{&rna_GPencilLayer_annotation_onion_after_color, &rna_GPencilLayer_annotation_onion_after_range,
	-1, "annotation_onion_before_color", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "Before Color",
	"Base color for ghosts before the active frame",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_COLOR_GAMMA) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bGPDlayer, gcolor_prev), RawPropertyType(5), nullptr},
	nullptr, nullptr, GPencilLayer_annotation_onion_before_color_get, GPencilLayer_annotation_onion_before_color_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.0f, rna_GPencilLayer_annotation_onion_before_color_default
};
PropertyRNA &rna_GPencilLayer_annotation_onion_before_color = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_annotation_onion_before_color_);

static float rna_GPencilLayer_annotation_onion_after_color_default[3] = {
	0.2500000000f,
	0.1000000015f,
	1.0f
};

static FloatPropertyRNA rna_GPencilLayer_annotation_onion_after_color_ = {
	{&rna_GPencilLayer_annotation_onion_use_custom_color, &rna_GPencilLayer_annotation_onion_before_color,
	-1, "annotation_onion_after_color", 1, 0, 0, 4, 0, PropertyPathTemplateType(0), "After Color",
	"Base color for ghosts after the active frame",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_COLOR_GAMMA) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bGPDlayer, gcolor_next), RawPropertyType(5), nullptr},
	nullptr, nullptr, GPencilLayer_annotation_onion_after_color_get, GPencilLayer_annotation_onion_after_color_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, 0.0f, 1.0f, 0.0f, 1.0f, 10.0f, 3, nullptr, nullptr, 0.0f, rna_GPencilLayer_annotation_onion_after_color_default
};
PropertyRNA &rna_GPencilLayer_annotation_onion_after_color = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_annotation_onion_after_color_);

static BoolPropertyRNA rna_GPencilLayer_annotation_onion_use_custom_color_ = {
	{&rna_GPencilLayer_annotation_hide, &rna_GPencilLayer_annotation_onion_after_color,
	-1, "annotation_onion_use_custom_color", 1, 0, 0, 0, 0, PropertyPathTemplateType(0), "Custom Onion Skin Colors",
	"Use custom colors for onion skinning instead of the theme",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_annotation_onion_use_custom_color_get, GPencilLayer_annotation_onion_use_custom_color_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_annotation_onion_use_custom_color = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_annotation_onion_use_custom_color_);

static BoolPropertyRNA rna_GPencilLayer_annotation_hide_ = {
	{&rna_GPencilLayer_lock, &rna_GPencilLayer_annotation_onion_use_custom_color,
	-1, "annotation_hide", 4353, 0, 0, 0, 0, PropertyPathTemplateType(0), "Hide",
	"Set annotation Visibility",
	16, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_annotation_hide_get, GPencilLayer_annotation_hide_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_annotation_hide = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_annotation_hide_);

static BoolPropertyRNA rna_GPencilLayer_lock_ = {
	{&rna_GPencilLayer_lock_frame, &rna_GPencilLayer_annotation_hide,
	-1, "lock", 4099, 0, 0, 0, 0, PropertyPathTemplateType(0), "Locked",
	"Protect layer from further editing and/or frame changes",
	39, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_lock_get, GPencilLayer_lock_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_lock = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_lock_);

static BoolPropertyRNA rna_GPencilLayer_lock_frame_ = {
	{&rna_GPencilLayer_is_ruler, &rna_GPencilLayer_lock,
	-1, "lock_frame", 4097, 0, 0, 0, 0, PropertyPathTemplateType(0), "Frame Locked",
	"Lock current frame displayed by layer",
	39, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_lock_frame_get, GPencilLayer_lock_frame_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_lock_frame = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_lock_frame_);

static BoolPropertyRNA rna_GPencilLayer_is_ruler_ = {
	{&rna_GPencilLayer_select, &rna_GPencilLayer_lock_frame,
	-1, "is_ruler", 2, 0, 0, 0, 0, PropertyPathTemplateType(0), "Ruler",
	"This is a special ruler layer",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_is_ruler_get, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_is_ruler = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_is_ruler_);

static BoolPropertyRNA rna_GPencilLayer_select_ = {
	{&rna_GPencilLayer_show_in_front, &rna_GPencilLayer_is_ruler,
	-1, "select", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select",
	"Layer is selected for editing in the Dope Sheet",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839750, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_select_get, GPencilLayer_select_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_select = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_select_);

static BoolPropertyRNA rna_GPencilLayer_show_in_front_ = {
	{nullptr, &rna_GPencilLayer_select,
	-1, "show_in_front", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "In Front",
	"Make the layer display in front of objects",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilLayer_show_in_front_get, GPencilLayer_show_in_front_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilLayer_show_in_front = reinterpret_cast<PropertyRNA &>(rna_GPencilLayer_show_in_front_);

StructRNA RNA_GPencilLayer = {
	{(ContainerRNA *)&RNA_GPencilFrames, (ContainerRNA *)&RNA_GreasePencilLayers,
	nullptr,
	{&rna_GPencilLayer_rna_properties, &rna_GPencilLayer_show_in_front}},
	"GPencilLayer", nullptr, nullptr, 516, nullptr, "Annotation Layer",
	"Collection of related sketches",
	"*", 61,
	&rna_GPencilLayer_info, &rna_GPencilLayer_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	rna_annotation_layer_path,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Annotation Frames */
static CollectionPropertyRNA rna_GPencilFrames_rna_properties_ = {
	{&rna_GPencilFrames_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilFrames_rna_properties_begin, GPencilFrames_rna_properties_next, GPencilFrames_rna_properties_end, GPencilFrames_rna_properties_get, nullptr, nullptr, GPencilFrames_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_GPencilFrames_rna_properties = reinterpret_cast<PropertyRNA &>(rna_GPencilFrames_rna_properties_);

static PointerPropertyRNA rna_GPencilFrames_rna_type_ = {
	{nullptr, &rna_GPencilFrames_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilFrames_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_GPencilFrames_rna_type = reinterpret_cast<PropertyRNA &>(rna_GPencilFrames_rna_type_);

static IntPropertyRNA rna_GPencilFrames_new_frame_number_ = {
	{&rna_GPencilFrames_new_active, nullptr,
	-1, "frame_number", 3, 0, 1, 0, 0, PropertyPathTemplateType(0), "Frame Number",
	"The frame on which this sketch appears",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -1048574, 1048574, -1048574, 1048574, 1, nullptr, nullptr, 1, nullptr
};
PropertyRNA &rna_GPencilFrames_new_frame_number = reinterpret_cast<PropertyRNA &>(rna_GPencilFrames_new_frame_number_);

static BoolPropertyRNA rna_GPencilFrames_new_active_ = {
	{&rna_GPencilFrames_new_frame, &rna_GPencilFrames_new_frame_number,
	-1, "active", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Active",
	"",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilFrames_new_active = reinterpret_cast<PropertyRNA &>(rna_GPencilFrames_new_active_);

static PointerPropertyRNA rna_GPencilFrames_new_frame_ = {
	{nullptr, &rna_GPencilFrames_new_active,
	-1, "frame", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"The newly created frame",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_GPencilFrame
};
PropertyRNA &rna_GPencilFrames_new_frame = reinterpret_cast<PropertyRNA &>(rna_GPencilFrames_new_frame_);

FunctionRNA rna_GPencilFrames_new_func = {
	{(FunctionRNA *)&rna_GPencilFrames_remove_func, nullptr,
	nullptr,
	{&rna_GPencilFrames_new_frame_number, &rna_GPencilFrames_new_frame}},
	"new", 16, "Add a new annotation frame",
	GPencilFrames_new_call,
	&rna_GPencilFrames_new_frame
};

static PointerPropertyRNA rna_GPencilFrames_remove_frame_ = {
	{nullptr, nullptr,
	-1, "frame", 262144, 0, 5, 0, 0, PropertyPathTemplateType(0), "Frame",
	"The frame to remove",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_GPencilFrame
};
PropertyRNA &rna_GPencilFrames_remove_frame = reinterpret_cast<PropertyRNA &>(rna_GPencilFrames_remove_frame_);

FunctionRNA rna_GPencilFrames_remove_func = {
	{(FunctionRNA *)&rna_GPencilFrames_copy_func, (FunctionRNA *)&rna_GPencilFrames_new_func,
	nullptr,
	{&rna_GPencilFrames_remove_frame, &rna_GPencilFrames_remove_frame}},
	"remove", 16, "Remove an annotation frame",
	GPencilFrames_remove_call,
	nullptr
};

static PointerPropertyRNA rna_GPencilFrames_copy_source_ = {
	{&rna_GPencilFrames_copy_copy, nullptr,
	-1, "source", 8650752, 0, 1, 0, 0, PropertyPathTemplateType(0), "Source",
	"The source frame",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_GPencilFrame
};
PropertyRNA &rna_GPencilFrames_copy_source = reinterpret_cast<PropertyRNA &>(rna_GPencilFrames_copy_source_);

static PointerPropertyRNA rna_GPencilFrames_copy_copy_ = {
	{nullptr, &rna_GPencilFrames_copy_source,
	-1, "copy", 8388608, 0, 2, 0, 0, PropertyPathTemplateType(0), "",
	"The newly copied frame",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	nullptr, nullptr, nullptr, nullptr,&RNA_GPencilFrame
};
PropertyRNA &rna_GPencilFrames_copy_copy = reinterpret_cast<PropertyRNA &>(rna_GPencilFrames_copy_copy_);

FunctionRNA rna_GPencilFrames_copy_func = {
	{nullptr, (FunctionRNA *)&rna_GPencilFrames_remove_func,
	nullptr,
	{&rna_GPencilFrames_copy_source, &rna_GPencilFrames_copy_copy}},
	"copy", 0, "Copy an annotation frame",
	GPencilFrames_copy_call,
	&rna_GPencilFrames_copy_copy
};

StructRNA RNA_GPencilFrames = {
	{(ContainerRNA *)&RNA_GPencilFrame, (ContainerRNA *)&RNA_GPencilLayer,
	nullptr,
	{&rna_GPencilFrames_rna_properties, &rna_GPencilFrames_rna_type}},
	"GPencilFrames", nullptr, nullptr, 516, nullptr, "Annotation Frames",
	"Collection of annotation frames",
	"*", 61,
	nullptr, &rna_GPencilFrames_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{(FunctionRNA *)&rna_GPencilFrames_new_func, (FunctionRNA *)&rna_GPencilFrames_copy_func}
};

/* Annotation Frame */
static CollectionPropertyRNA rna_GPencilFrame_rna_properties_ = {
	{&rna_GPencilFrame_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilFrame_rna_properties_begin, GPencilFrame_rna_properties_next, GPencilFrame_rna_properties_end, GPencilFrame_rna_properties_get, nullptr, nullptr, GPencilFrame_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_GPencilFrame_rna_properties = reinterpret_cast<PropertyRNA &>(rna_GPencilFrame_rna_properties_);

static PointerPropertyRNA rna_GPencilFrame_rna_type_ = {
	{&rna_GPencilFrame_strokes, &rna_GPencilFrame_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilFrame_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_GPencilFrame_rna_type = reinterpret_cast<PropertyRNA &>(rna_GPencilFrame_rna_type_);

static CollectionPropertyRNA rna_GPencilFrame_strokes_ = {
	{&rna_GPencilFrame_frame_number, &rna_GPencilFrame_rna_type,
	-1, "strokes", 0, 0, 0, 0, 0, PropertyPathTemplateType(0), "Strokes",
	"Freehand curves defining the sketch on this frame",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilFrame_strokes_begin, GPencilFrame_strokes_next, GPencilFrame_strokes_end, GPencilFrame_strokes_get, nullptr, GPencilFrame_strokes_lookup_int, nullptr, nullptr, &RNA_GPencilStroke
};
PropertyRNA &rna_GPencilFrame_strokes = reinterpret_cast<PropertyRNA &>(rna_GPencilFrame_strokes_);

static IntPropertyRNA rna_GPencilFrame_frame_number_ = {
	{&rna_GPencilFrame_select, &rna_GPencilFrame_strokes,
	-1, "frame_number", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Frame Number",
	"The frame on which this sketch appears",
	0, "*",
	PROP_INT, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bGPDframe, framenum), RawPropertyType(0), nullptr},
	GPencilFrame_frame_number_get, GPencilFrame_frame_number_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr,
	PROP_SCALE_LINEAR, -1048574, 1048574, -1048574, 1048574, 1, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilFrame_frame_number = reinterpret_cast<PropertyRNA &>(rna_GPencilFrame_frame_number_);

static BoolPropertyRNA rna_GPencilFrame_select_ = {
	{nullptr, &rna_GPencilFrame_frame_number,
	-1, "select", 3, 0, 0, 0, 0, PropertyPathTemplateType(0), "Select",
	"Frame is selected for editing in the Dope Sheet",
	0, "*",
	PROP_BOOLEAN, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilFrame_select_get, GPencilFrame_select_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, 0, nullptr
};
PropertyRNA &rna_GPencilFrame_select = reinterpret_cast<PropertyRNA &>(rna_GPencilFrame_select_);

StructRNA RNA_GPencilFrame = {
	{(ContainerRNA *)&RNA_GPencilStroke, (ContainerRNA *)&RNA_GPencilFrames,
	nullptr,
	{&rna_GPencilFrame_rna_properties, &rna_GPencilFrame_select}},
	"GPencilFrame", nullptr, nullptr, 516, nullptr, "Annotation Frame",
	"Collection of related sketches on a particular frame",
	"*", 61,
	nullptr, &rna_GPencilFrame_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Annotation Stroke */
static CollectionPropertyRNA rna_GPencilStroke_rna_properties_ = {
	{&rna_GPencilStroke_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilStroke_rna_properties_begin, GPencilStroke_rna_properties_next, GPencilStroke_rna_properties_end, GPencilStroke_rna_properties_get, nullptr, nullptr, GPencilStroke_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_GPencilStroke_rna_properties = reinterpret_cast<PropertyRNA &>(rna_GPencilStroke_rna_properties_);

static PointerPropertyRNA rna_GPencilStroke_rna_type_ = {
	{&rna_GPencilStroke_points, &rna_GPencilStroke_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilStroke_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_GPencilStroke_rna_type = reinterpret_cast<PropertyRNA &>(rna_GPencilStroke_rna_type_);

static CollectionPropertyRNA rna_GPencilStroke_points_ = {
	{nullptr, &rna_GPencilStroke_rna_type,
	-1, "points", 0, 0, 0, 8, 0, PropertyPathTemplateType(0), "Stroke Points",
	"Stroke data points",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilStroke_points_begin, GPencilStroke_points_next, GPencilStroke_points_end, GPencilStroke_points_get, GPencilStroke_points_length, GPencilStroke_points_lookup_int, nullptr, nullptr, &RNA_GPencilStrokePoint
};
PropertyRNA &rna_GPencilStroke_points = reinterpret_cast<PropertyRNA &>(rna_GPencilStroke_points_);

StructRNA RNA_GPencilStroke = {
	{(ContainerRNA *)&RNA_GPencilStrokePoint, (ContainerRNA *)&RNA_GPencilFrame,
	nullptr,
	{&rna_GPencilStroke_rna_properties, &rna_GPencilStroke_points}},
	"GPencilStroke", nullptr, nullptr, 516, nullptr, "Annotation Stroke",
	"Freehand curve defining part of a sketch",
	"*", 61,
	nullptr, &rna_GPencilStroke_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

/* Annotation Stroke Point */
static CollectionPropertyRNA rna_GPencilStrokePoint_rna_properties_ = {
	{&rna_GPencilStrokePoint_rna_type, nullptr,
	-1, "rna_properties", 0, 0, 0, 1, 0, PropertyPathTemplateType(0), "Properties",
	"RNA property collection",
	0, "*",
	PROP_COLLECTION, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilStrokePoint_rna_properties_begin, GPencilStrokePoint_rna_properties_next, GPencilStrokePoint_rna_properties_end, GPencilStrokePoint_rna_properties_get, nullptr, nullptr, GPencilStrokePoint_rna_properties_lookup_string, nullptr, &RNA_Property
};
PropertyRNA &rna_GPencilStrokePoint_rna_properties = reinterpret_cast<PropertyRNA &>(rna_GPencilStrokePoint_rna_properties_);

static PointerPropertyRNA rna_GPencilStrokePoint_rna_type_ = {
	{&rna_GPencilStrokePoint_co, &rna_GPencilStrokePoint_rna_properties,
	-1, "rna_type", 8912896, 0, 0, 0, 0, PropertyPathTemplateType(0), "RNA",
	"RNA type definition",
	0, "*",
	PROP_POINTER, PropertySubType(int(PROP_NONE) | int(PROP_UNIT_NONE)), nullptr, 0, {0, 0, 0}, 0,
	nullptr, 0, nullptr, nullptr, nullptr, nullptr, nullptr,
	0, PROP_RAW_UNSET, nullptr},
	GPencilStrokePoint_rna_type_get, nullptr, nullptr, nullptr,&RNA_Struct
};
PropertyRNA &rna_GPencilStrokePoint_rna_type = reinterpret_cast<PropertyRNA &>(rna_GPencilStrokePoint_rna_type_);

static float rna_GPencilStrokePoint_co_default[3] = {
	0.0f,
	0.0f,
	0.0f
};

static FloatPropertyRNA rna_GPencilStrokePoint_co_ = {
	{nullptr, &rna_GPencilStrokePoint_rna_type,
	-1, "co", 3, 0, 0, 4, 0, PropertyPathTemplateType(0), "Coordinates",
	"",
	0, "*",
	PROP_FLOAT, PropertySubType(int(PROP_XYZ) | int(PROP_UNIT_NONE)), nullptr, 1, {3, 0, 0}, 3,
	rna_annotation_update, 391839744, nullptr, nullptr, nullptr, nullptr, nullptr,
	offsetof(bGPDspoint, x), RawPropertyType(5), nullptr},
	nullptr, nullptr, GPencilStrokePoint_co_get, GPencilStrokePoint_co_set, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, PROP_SCALE_LINEAR, -10000.0f, 10000.0f, -FLT_MAX, FLT_MAX, 10.0f, 3, nullptr, nullptr, 0.0f, rna_GPencilStrokePoint_co_default
};
PropertyRNA &rna_GPencilStrokePoint_co = reinterpret_cast<PropertyRNA &>(rna_GPencilStrokePoint_co_);

StructRNA RNA_GPencilStrokePoint = {
	{(ContainerRNA *)&RNA_GreasePencilv3, (ContainerRNA *)&RNA_GPencilStroke,
	nullptr,
	{&rna_GPencilStrokePoint_rna_properties, &rna_GPencilStrokePoint_co}},
	"GPencilStrokePoint", nullptr, nullptr, 516, nullptr, "Annotation Stroke Point",
	"Data point for freehand stroke curve",
	"*", 61,
	nullptr, &rna_GPencilStrokePoint_rna_properties,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	nullptr,
	{nullptr, nullptr}
};

