/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomVisitorExAdapter;

class AnnotationVisitor<C>
extends OWLAxiomVisitorExAdapter<Set<C>> {
    private final boolean value;

    AnnotationVisitor(boolean value) {
        super(CollectionFactory.emptySet());
        this.value = value;
    }

    @Override
    @Nonnull
    protected Set<C> doDefault(@Nonnull OWLAxiom object) {
        return this.get(object.getAnnotations());
    }

    @Nonnull
    private Set<C> get(@Nonnull Collection<OWLAnnotation> collection) {
        HashSet<OWLObject> toReturn = new HashSet<OWLObject>();
        for (OWLAnnotation c : collection) {
            if (this.value) {
                toReturn.add(c.getValue());
                continue;
            }
            toReturn.add(c);
        }
        return toReturn;
    }

    @Override
    @Nonnull
    public Set<C> visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
        if (this.value) {
            return CollectionFactory.createSet(axiom.getValue());
        }
        return CollectionFactory.createSet(axiom.getAnnotation());
    }
}

