/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.cache.OWLExpressionUserCache;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLClassExpressionEditor;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLClassExpressionExpressionEditor
extends AbstractOWLClassExpressionEditor {
    private static final Logger logger = LoggerFactory.getLogger(OWLClassExpressionExpressionEditor.class);
    private static final String CLASS_EXPRESSION_SYNTAX_URL = "http://protegeproject.github.io/protege/class-expression-syntax";
    private ExpressionEditor<OWLClassExpression> editor;
    private JPanel editorPanel = new JPanel(new BorderLayout(3, 3));

    public void initialise() throws Exception {
        OWLEditorKit eKit = this.getOWLEditorKit();
        OWLExpressionChecker<OWLClassExpression> checker = eKit.getModelManager().getOWLExpressionCheckerFactory().getOWLClassExpressionChecker();
        this.editor = new ExpressionEditor<OWLClassExpression>(eKit, checker);
        JScrollPane sp = new JScrollPane(this.editor);
        this.editorPanel.add(sp);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        this.editorPanel.add((Component)buttonPanel, "South");
        JButton helpButton = new JButton("Help...");
        buttonPanel.add(helpButton);
        helpButton.addActionListener(e -> this.showClassExpressionSyntaxHelp());
    }

    private void showClassExpressionSyntaxHelp() {
        try {
            Desktop.getDesktop().browse(URI.create(CLASS_EXPRESSION_SYNTAX_URL));
        }
        catch (IOException ex) {
            logger.warn("An error occurred when attempting to display the Class Expression documentation: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.editorPanel;
    }

    @Override
    public boolean isValidInput() {
        return this.editor.isWellFormed();
    }

    @Override
    public boolean setDescription(OWLClassExpression description) {
        this.editor.setExpressionObject(description);
        return true;
    }

    @Override
    public Set<OWLClassExpression> getClassExpressions() {
        try {
            if (this.editor.isWellFormed()) {
                OWLClassExpression owlDescription = this.editor.createObject();
                OWLExpressionUserCache.getInstance(this.getOWLEditorKit().getModelManager()).add(owlDescription, this.editor.getText());
                return Collections.singleton(owlDescription);
            }
            return null;
        }
        catch (OWLException e) {
            return null;
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.editor.addStatusChangedListener(l);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.editor.removeStatusChangedListener(l);
    }

    public void dispose() throws Exception {
    }
}

