/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemEntry.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFileSystem.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorCallback.h"
#include "JSFileSystemEntryCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFileSystemEntryPrototypeFunction_getParent);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemEntryConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemEntry_isFile);
static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemEntry_isDirectory);
static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemEntry_name);
static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemEntry_fullPath);
static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemEntry_filesystem);

class JSFileSystemEntryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemEntryPrototype>(vm)) JSFileSystemEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemEntryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemEntryPrototype, JSFileSystemEntryPrototype::Base);

using JSFileSystemEntryDOMConstructor = JSDOMConstructorNotConstructable<JSFileSystemEntry>;

template<> const ClassInfo JSFileSystemEntryDOMConstructor::s_info = { "FileSystemEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemEntryDOMConstructor) };

template<> JSValue JSFileSystemEntryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSFileSystemEntryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileSystemEntry"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemEntry::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSFileSystemEntryPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemEntryConstructor, 0 } },
    { "isFile"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemEntry_isFile, 0 } },
    { "isDirectory"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemEntry_isDirectory, 0 } },
    { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemEntry_name, 0 } },
    { "fullPath"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemEntry_fullPath, 0 } },
    { "filesystem"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemEntry_filesystem, 0 } },
    { "getParent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemEntryPrototypeFunction_getParent, 0 } },
};

const ClassInfo JSFileSystemEntryPrototype::s_info = { "FileSystemEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemEntryPrototype) };

void JSFileSystemEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemEntry::info(), JSFileSystemEntryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFileSystemEntry::s_info = { "FileSystemEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemEntry) };

JSFileSystemEntry::JSFileSystemEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemEntry>&& impl)
    : JSDOMWrapper<FileSystemEntry>(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, FileSystemEntry>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFileSystemEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFileSystemEntryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSFileSystemEntryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFileSystemEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemEntry>(vm, globalObject);
}

JSValue JSFileSystemEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemEntryDOMConstructor, DOMConstructorID::FileSystemEntry>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSFileSystemEntry::destroy(JSC::JSCell* cell)
{
    JSFileSystemEntry* thisObject = static_cast<JSFileSystemEntry*>(cell);
    thisObject->JSFileSystemEntry::~JSFileSystemEntry();
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemEntryPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemEntry::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsFileSystemEntry_isFileGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isFile())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemEntry_isFile, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntry_isFileGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFileSystemEntry_isDirectoryGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isDirectory())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemEntry_isDirectory, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntry_isDirectoryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFileSystemEntry_nameGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemEntry_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntry_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFileSystemEntry_fullPathGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.virtualPath())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemEntry_fullPath, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntry_fullPathGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFileSystemEntry_filesystemGetter(JSGlobalObject& lexicalGlobalObject, JSFileSystemEntry& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<DOMFileSystem>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.filesystem())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemEntry_filesystem, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFileSystemEntry>::get<jsFileSystemEntry_filesystemGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsFileSystemEntryPrototypeFunction_getParentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemEntry>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto successCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSFileSystemEntryCallback>>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "successCallback"_s, "FileSystemEntry"_s, "getParent"_s); });
    if (UNLIKELY(successCallbackConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback"_s, "FileSystemEntry"_s, "getParent"_s); });
    if (UNLIKELY(errorCallbackConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.getParent(*context, successCallbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemEntryPrototypeFunction_getParent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemEntry>::call<jsFileSystemEntryPrototypeFunction_getParentBody>(*lexicalGlobalObject, *callFrame, "getParent");
}

JSC::GCClient::IsoSubspace* JSFileSystemEntry::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFileSystemEntry, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFileSystemEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileSystemEntry = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFileSystemEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileSystemEntry = std::forward<decltype(space)>(space); }
    );
}

void JSFileSystemEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFileSystemEntry = jsCast<JSFileSystemEntry*>(handle.slot()->asCell());
    auto& wrapped = jsFileSystemEntry->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemEntry = static_cast<JSFileSystemEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileSystemEntry->protectedWrapped().ptr(), jsFileSystemEntry);
}

FileSystemEntry* JSFileSystemEntry::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFileSystemEntry*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
