/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSAesGcmParams.h"

#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CryptoAlgorithmAesGcmParams>> convertDictionary<CryptoAlgorithmAesGcmParams>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CryptoAlgorithmAesGcmParams result;
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (nameValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name"_s, "AesGcmParams"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto nameConversionResult = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
    if (UNLIKELY(nameConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    JSValue additionalDataValue;
    if (isNullOrUndefined)
        additionalDataValue = jsUndefined();
    else {
        additionalDataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "additionalData"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!additionalDataValue.isUndefined()) {
        auto additionalDataConversionResult = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, additionalDataValue);
        if (UNLIKELY(additionalDataConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.additionalData = additionalDataConversionResult.releaseReturnValue();
    }
    JSValue ivValue;
    if (isNullOrUndefined)
        ivValue = jsUndefined();
    else {
        ivValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iv"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (ivValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "iv"_s, "AesGcmParams"_s, "(ArrayBufferView or ArrayBuffer)"_s);
        return ConversionResultException { };
    }
    auto ivConversionResult = convert<IDLUnion<IDLArrayBufferView, IDLArrayBuffer>>(lexicalGlobalObject, ivValue);
    if (UNLIKELY(ivConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.iv = ivConversionResult.releaseReturnValue();
    JSValue tagLengthValue;
    if (isNullOrUndefined)
        tagLengthValue = jsUndefined();
    else {
        tagLengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tagLength"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!tagLengthValue.isUndefined()) {
        auto tagLengthConversionResult = convert<IDLEnforceRangeAdaptor<IDLOctet>>(lexicalGlobalObject, tagLengthValue);
        if (UNLIKELY(tagLengthConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.tagLength = tagLengthConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
