/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLClipCullDistance.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLClipCullDistancePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLClipCullDistancePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLClipCullDistancePrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLClipCullDistancePrototype>(vm)) JSWebGLClipCullDistancePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLClipCullDistancePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLClipCullDistancePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLClipCullDistancePrototype, JSWebGLClipCullDistancePrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLClipCullDistancePrototypeTableValues[] =
{
    { "MAX_CLIP_DISTANCES_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x0D32 } },
    { "MAX_CULL_DISTANCES_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x82F9 } },
    { "MAX_COMBINED_CLIP_AND_CULL_DISTANCES_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x82FA } },
    { "CLIP_DISTANCE0_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x3000 } },
    { "CLIP_DISTANCE1_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x3001 } },
    { "CLIP_DISTANCE2_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x3002 } },
    { "CLIP_DISTANCE3_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x3003 } },
    { "CLIP_DISTANCE4_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x3004 } },
    { "CLIP_DISTANCE5_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x3005 } },
    { "CLIP_DISTANCE6_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x3006 } },
    { "CLIP_DISTANCE7_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x3007 } },
};

const ClassInfo JSWebGLClipCullDistancePrototype::s_info = { "WebGLClipCullDistance"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLClipCullDistancePrototype) };

void JSWebGLClipCullDistancePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLClipCullDistance::info(), JSWebGLClipCullDistancePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLClipCullDistance::s_info = { "WebGLClipCullDistance"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLClipCullDistance) };

JSWebGLClipCullDistance::JSWebGLClipCullDistance(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLClipCullDistance>&& impl)
    : JSDOMWrapper<WebGLClipCullDistance>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLClipCullDistance>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLClipCullDistance::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLClipCullDistancePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLClipCullDistancePrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLClipCullDistance::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLClipCullDistance>(vm, globalObject);
}

void JSWebGLClipCullDistance::destroy(JSC::JSCell* cell)
{
    JSWebGLClipCullDistance* thisObject = static_cast<JSWebGLClipCullDistance*>(cell);
    thisObject->JSWebGLClipCullDistance::~JSWebGLClipCullDistance();
}

JSC::GCClient::IsoSubspace* JSWebGLClipCullDistance::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLClipCullDistance, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLClipCullDistance.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLClipCullDistance = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLClipCullDistance.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLClipCullDistance = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLClipCullDistance::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLClipCullDistance*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLClipCullDistanceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLClipCullDistance = jsCast<JSWebGLClipCullDistance*>(handle.slot()->asCell());
    WebGLRenderingContextBase* owner = WTF::getPtr(jsWebGLClipCullDistance->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLClipCullDistance";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLClipCullDistanceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLClipCullDistance = static_cast<JSWebGLClipCullDistance*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLClipCullDistance->wrapped(), jsWebGLClipCullDistance);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLClipCullDistance@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore21WebGLClipCullDistanceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLClipCullDistance>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLClipCullDistance>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLClipCullDistance@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore21WebGLClipCullDistanceE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLClipCullDistance has subclasses. If WebGLClipCullDistance has subclasses that get passed
        // to toJS() we currently require WebGLClipCullDistance you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLClipCullDistance>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLClipCullDistance& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLClipCullDistance* JSWebGLClipCullDistance::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLClipCullDistance*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
