/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoColorSpaceInit.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMGlobalObject.h"
#include "JSVideoColorPrimaries.h"
#include "JSVideoMatrixCoefficients.h"
#include "JSVideoTransferCharacteristics.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(VIDEO)

template<> VideoColorSpaceInit convertDictionary<VideoColorSpaceInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    VideoColorSpaceInit result;
    JSValue fullRangeValue;
    if (isNullOrUndefined)
        fullRangeValue = jsUndefined();
    else {
        fullRangeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fullRange"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fullRangeValue.isUndefined()) {
        result.fullRange = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, fullRangeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.fullRange = std::nullopt;
    JSValue matrixValue;
    if (isNullOrUndefined)
        matrixValue = jsUndefined();
    else {
        matrixValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "matrix"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!matrixValue.isUndefined()) {
        result.matrix = convert<IDLNullable<IDLEnumeration<VideoMatrixCoefficients>>>(lexicalGlobalObject, matrixValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.matrix = std::nullopt;
    JSValue primariesValue;
    if (isNullOrUndefined)
        primariesValue = jsUndefined();
    else {
        primariesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "primaries"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!primariesValue.isUndefined()) {
        result.primaries = convert<IDLNullable<IDLEnumeration<VideoColorPrimaries>>>(lexicalGlobalObject, primariesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.primaries = std::nullopt;
    JSValue transferValue;
    if (isNullOrUndefined)
        transferValue = jsUndefined();
    else {
        transferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transfer"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!transferValue.isUndefined()) {
        result.transfer = convert<IDLNullable<IDLEnumeration<VideoTransferCharacteristics>>>(lexicalGlobalObject, transferValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.transfer = std::nullopt;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const VideoColorSpaceInit& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto fullRangeValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, dictionary.fullRange);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "fullRange"_s), fullRangeValue);
    auto matrixValue = toJS<IDLNullable<IDLEnumeration<VideoMatrixCoefficients>>>(lexicalGlobalObject, throwScope, dictionary.matrix);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "matrix"_s), matrixValue);
    auto primariesValue = toJS<IDLNullable<IDLEnumeration<VideoColorPrimaries>>>(lexicalGlobalObject, throwScope, dictionary.primaries);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "primaries"_s), primariesValue);
    auto transferValue = toJS<IDLNullable<IDLEnumeration<VideoTransferCharacteristics>>>(lexicalGlobalObject, throwScope, dictionary.transfer);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "transfer"_s), transferValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(VIDEO)
