/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SERVICE_WORKER)

#include "JSServiceWorkerClient.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSServiceWorkerClientType.h"
#include "JSStructuredSerializeOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/IteratorOperations.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ServiceWorkerClient::FrameType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("auxiliary"),
        MAKE_STATIC_STRING_IMPL("top-level"),
        MAKE_STATIC_STRING_IMPL("nested"),
        MAKE_STATIC_STRING_IMPL("none"),
    };
    static_assert(static_cast<size_t>(ServiceWorkerClient::FrameType::Auxiliary) == 0, "ServiceWorkerClient::FrameType::Auxiliary is not 0 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerClient::FrameType::TopLevel) == 1, "ServiceWorkerClient::FrameType::TopLevel is not 1 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerClient::FrameType::Nested) == 2, "ServiceWorkerClient::FrameType::Nested is not 2 as expected");
    static_assert(static_cast<size_t>(ServiceWorkerClient::FrameType::None) == 3, "ServiceWorkerClient::FrameType::None is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ServiceWorkerClient::FrameType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ServiceWorkerClient::FrameType> parseEnumerationFromString<ServiceWorkerClient::FrameType>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, ServiceWorkerClient::FrameType> mappings[] = {
        { "auxiliary", ServiceWorkerClient::FrameType::Auxiliary },
        { "nested", ServiceWorkerClient::FrameType::Nested },
        { "none", ServiceWorkerClient::FrameType::None },
        { "top-level", ServiceWorkerClient::FrameType::TopLevel },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ServiceWorkerClient::FrameType> parseEnumeration<ServiceWorkerClient::FrameType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ServiceWorkerClient::FrameType>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<ServiceWorkerClient::FrameType>()
{
    return "\"auxiliary\", \"top-level\", \"nested\", \"none\"";
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsServiceWorkerClientPrototypeFunction_postMessage);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerClientConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerClient_url);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerClient_frameType);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerClient_type);
static JSC_DECLARE_CUSTOM_GETTER(jsServiceWorkerClient_id);

class JSServiceWorkerClientPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSServiceWorkerClientPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSServiceWorkerClientPrototype* ptr = new (NotNull, JSC::allocateCell<JSServiceWorkerClientPrototype>(vm)) JSServiceWorkerClientPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerClientPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSServiceWorkerClientPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSServiceWorkerClientPrototype, JSServiceWorkerClientPrototype::Base);

using JSServiceWorkerClientDOMConstructor = JSDOMConstructorNotConstructable<JSServiceWorkerClient>;

template<> const ClassInfo JSServiceWorkerClientDOMConstructor::s_info = { "Client"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerClientDOMConstructor) };

template<> JSValue JSServiceWorkerClientDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSServiceWorkerClientDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Client"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSServiceWorkerClient::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSServiceWorkerClientPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerClientConstructor, 0 } },
    { "url"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerClient_url, 0 } },
    { "frameType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerClient_frameType, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerClient_type, 0 } },
    { "id"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsServiceWorkerClient_id, 0 } },
    { "postMessage"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsServiceWorkerClientPrototypeFunction_postMessage, 1 } },
};

const ClassInfo JSServiceWorkerClientPrototype::s_info = { "Client"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerClientPrototype) };

void JSServiceWorkerClientPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSServiceWorkerClient::info(), JSServiceWorkerClientPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSServiceWorkerClient::s_info = { "Client"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSServiceWorkerClient) };

JSServiceWorkerClient::JSServiceWorkerClient(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ServiceWorkerClient>&& impl)
    : JSDOMWrapper<ServiceWorkerClient>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, ServiceWorkerClient>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSServiceWorkerClient::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSServiceWorkerClientPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSServiceWorkerClientPrototype::create(vm, &globalObject, structure);
}

JSObject* JSServiceWorkerClient::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSServiceWorkerClient>(vm, globalObject);
}

JSValue JSServiceWorkerClient::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSServiceWorkerClientDOMConstructor, DOMConstructorID::ServiceWorkerClient>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSServiceWorkerClient::destroy(JSC::JSCell* cell)
{
    JSServiceWorkerClient* thisObject = static_cast<JSServiceWorkerClient*>(cell);
    thisObject->JSServiceWorkerClient::~JSServiceWorkerClient();
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerClientConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSServiceWorkerClientPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSServiceWorkerClient::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsServiceWorkerClient_urlGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerClient& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.url())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerClient_url, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerClient>::get<jsServiceWorkerClient_urlGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerClient_frameTypeGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerClient& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ServiceWorkerClient::FrameType>>(lexicalGlobalObject, throwScope, impl.frameType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerClient_frameType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerClient>::get<jsServiceWorkerClient_frameTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerClient_typeGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerClient& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ServiceWorkerClientType>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerClient_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerClient>::get<jsServiceWorkerClient_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsServiceWorkerClient_idGetter(JSGlobalObject& lexicalGlobalObject, JSServiceWorkerClient& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsServiceWorkerClient_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSServiceWorkerClient>::get<jsServiceWorkerClient_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsServiceWorkerClientPrototypeFunction_postMessage1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerClient>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto transfer = convert<IDLSequence<IDLObject>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(message), WTFMove(transfer)); })));
}

static inline JSC::EncodedJSValue jsServiceWorkerClientPrototypeFunction_postMessage2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerClient>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto message = convert<IDLAny>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<StructuredSerializeOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.postMessage(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(message), WTFMove(options)); })));
}

static inline JSC::EncodedJSValue jsServiceWorkerClientPrototypeFunction_postMessageOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSServiceWorkerClient>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsServiceWorkerClientPrototypeFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(1);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsServiceWorkerClientPrototypeFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsServiceWorkerClientPrototypeFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
        {
            bool success = hasIteratorMethod(lexicalGlobalObject, distinguishingArg);
            RETURN_IF_EXCEPTION(throwScope, { });
            if (success)
                RELEASE_AND_RETURN(throwScope, (jsServiceWorkerClientPrototypeFunction_postMessage1Body(lexicalGlobalObject, callFrame, castedThis)));
        }
        if (distinguishingArg.isObject())
            RELEASE_AND_RETURN(throwScope, (jsServiceWorkerClientPrototypeFunction_postMessage2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsServiceWorkerClientPrototypeFunction_postMessage, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSServiceWorkerClient>::call<jsServiceWorkerClientPrototypeFunction_postMessageOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "postMessage");
}

JSC::GCClient::IsoSubspace* JSServiceWorkerClient::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSServiceWorkerClient, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForServiceWorkerClient.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForServiceWorkerClient = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForServiceWorkerClient.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForServiceWorkerClient = std::forward<decltype(space)>(space); }
    );
}

void JSServiceWorkerClient::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSServiceWorkerClient*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSServiceWorkerClientOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSServiceWorkerClientOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsServiceWorkerClient = static_cast<JSServiceWorkerClient*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsServiceWorkerClient->wrapped(), jsServiceWorkerClient);
}

ServiceWorkerClient* JSServiceWorkerClient::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSServiceWorkerClient*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(SERVICE_WORKER)
