/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPointerEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> PointerEvent::Init convertDictionary<PointerEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PointerEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detailValue.isUndefined()) {
        result.detail = convert<IDLLong>(lexicalGlobalObject, detailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detail = 0;
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.view = nullptr;
    JSValue altKeyValue;
    if (isNullOrUndefined)
        altKeyValue = jsUndefined();
    else {
        altKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!altKeyValue.isUndefined()) {
        result.altKey = convert<IDLBoolean>(lexicalGlobalObject, altKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.altKey = false;
    JSValue ctrlKeyValue;
    if (isNullOrUndefined)
        ctrlKeyValue = jsUndefined();
    else {
        ctrlKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ctrlKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ctrlKeyValue.isUndefined()) {
        result.ctrlKey = convert<IDLBoolean>(lexicalGlobalObject, ctrlKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ctrlKey = false;
    JSValue metaKeyValue;
    if (isNullOrUndefined)
        metaKeyValue = jsUndefined();
    else {
        metaKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "metaKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!metaKeyValue.isUndefined()) {
        result.metaKey = convert<IDLBoolean>(lexicalGlobalObject, metaKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.metaKey = false;
    JSValue modifierAltGraphValue;
    if (isNullOrUndefined)
        modifierAltGraphValue = jsUndefined();
    else {
        modifierAltGraphValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierAltGraph"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierAltGraphValue.isUndefined()) {
        result.modifierAltGraph = convert<IDLBoolean>(lexicalGlobalObject, modifierAltGraphValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierAltGraph = false;
    JSValue modifierCapsLockValue;
    if (isNullOrUndefined)
        modifierCapsLockValue = jsUndefined();
    else {
        modifierCapsLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierCapsLock"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierCapsLockValue.isUndefined()) {
        result.modifierCapsLock = convert<IDLBoolean>(lexicalGlobalObject, modifierCapsLockValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierCapsLock = false;
    JSValue shiftKeyValue;
    if (isNullOrUndefined)
        shiftKeyValue = jsUndefined();
    else {
        shiftKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shiftKey"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!shiftKeyValue.isUndefined()) {
        result.shiftKey = convert<IDLBoolean>(lexicalGlobalObject, shiftKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.shiftKey = false;
    JSValue buttonValue;
    if (isNullOrUndefined)
        buttonValue = jsUndefined();
    else {
        buttonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "button"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!buttonValue.isUndefined()) {
        result.button = convert<IDLShort>(lexicalGlobalObject, buttonValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.button = 0;
    JSValue buttonsValue;
    if (isNullOrUndefined)
        buttonsValue = jsUndefined();
    else {
        buttonsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "buttons"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!buttonsValue.isUndefined()) {
        result.buttons = convert<IDLUnsignedShort>(lexicalGlobalObject, buttonsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.buttons = 0;
    JSValue clientXValue;
    if (isNullOrUndefined)
        clientXValue = jsUndefined();
    else {
        clientXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientXValue.isUndefined()) {
        result.clientX = convert<IDLLong>(lexicalGlobalObject, clientXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clientX = 0;
    JSValue clientYValue;
    if (isNullOrUndefined)
        clientYValue = jsUndefined();
    else {
        clientYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clientY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!clientYValue.isUndefined()) {
        result.clientY = convert<IDLLong>(lexicalGlobalObject, clientYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.clientY = 0;
    JSValue movementXValue;
    if (isNullOrUndefined)
        movementXValue = jsUndefined();
    else {
        movementXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!movementXValue.isUndefined()) {
        result.movementX = convert<IDLDouble>(lexicalGlobalObject, movementXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.movementX = 0;
    JSValue movementYValue;
    if (isNullOrUndefined)
        movementYValue = jsUndefined();
    else {
        movementYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "movementY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!movementYValue.isUndefined()) {
        result.movementY = convert<IDLDouble>(lexicalGlobalObject, movementYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.movementY = 0;
    JSValue relatedTargetValue;
    if (isNullOrUndefined)
        relatedTargetValue = jsUndefined();
    else {
        relatedTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "relatedTarget"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!relatedTargetValue.isUndefined()) {
        result.relatedTarget = convert<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, relatedTargetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.relatedTarget = nullptr;
    JSValue screenXValue;
    if (isNullOrUndefined)
        screenXValue = jsUndefined();
    else {
        screenXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!screenXValue.isUndefined()) {
        result.screenX = convert<IDLLong>(lexicalGlobalObject, screenXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.screenX = 0;
    JSValue screenYValue;
    if (isNullOrUndefined)
        screenYValue = jsUndefined();
    else {
        screenYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "screenY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!screenYValue.isUndefined()) {
        result.screenY = convert<IDLLong>(lexicalGlobalObject, screenYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.screenY = 0;
    JSValue heightValue;
    if (isNullOrUndefined)
        heightValue = jsUndefined();
    else {
        heightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "height"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!heightValue.isUndefined()) {
        result.height = convert<IDLDouble>(lexicalGlobalObject, heightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.height = 1;
    JSValue isPrimaryValue;
    if (isNullOrUndefined)
        isPrimaryValue = jsUndefined();
    else {
        isPrimaryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isPrimary"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isPrimaryValue.isUndefined()) {
        result.isPrimary = convert<IDLBoolean>(lexicalGlobalObject, isPrimaryValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.isPrimary = false;
    JSValue pointerIdValue;
    if (isNullOrUndefined)
        pointerIdValue = jsUndefined();
    else {
        pointerIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pointerId"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pointerIdValue.isUndefined()) {
        result.pointerId = convert<IDLLong>(lexicalGlobalObject, pointerIdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pointerId = 0;
    JSValue pointerTypeValue;
    if (isNullOrUndefined)
        pointerTypeValue = jsUndefined();
    else {
        pointerTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pointerType"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pointerTypeValue.isUndefined()) {
        result.pointerType = convert<IDLDOMString>(lexicalGlobalObject, pointerTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pointerType = emptyString();
    JSValue pressureValue;
    if (isNullOrUndefined)
        pressureValue = jsUndefined();
    else {
        pressureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pressure"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pressureValue.isUndefined()) {
        result.pressure = convert<IDLFloat>(lexicalGlobalObject, pressureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pressure = 0;
    JSValue tangentialPressureValue;
    if (isNullOrUndefined)
        tangentialPressureValue = jsUndefined();
    else {
        tangentialPressureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tangentialPressure"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tangentialPressureValue.isUndefined()) {
        result.tangentialPressure = convert<IDLFloat>(lexicalGlobalObject, tangentialPressureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tangentialPressure = 0;
    JSValue tiltXValue;
    if (isNullOrUndefined)
        tiltXValue = jsUndefined();
    else {
        tiltXValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tiltX"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tiltXValue.isUndefined()) {
        result.tiltX = convert<IDLLong>(lexicalGlobalObject, tiltXValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tiltX = 0;
    JSValue tiltYValue;
    if (isNullOrUndefined)
        tiltYValue = jsUndefined();
    else {
        tiltYValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "tiltY"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!tiltYValue.isUndefined()) {
        result.tiltY = convert<IDLLong>(lexicalGlobalObject, tiltYValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.tiltY = 0;
    JSValue twistValue;
    if (isNullOrUndefined)
        twistValue = jsUndefined();
    else {
        twistValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "twist"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!twistValue.isUndefined()) {
        result.twist = convert<IDLLong>(lexicalGlobalObject, twistValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.twist = 0;
    JSValue widthValue;
    if (isNullOrUndefined)
        widthValue = jsUndefined();
    else {
        widthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "width"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!widthValue.isUndefined()) {
        result.width = convert<IDLDouble>(lexicalGlobalObject, widthValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.width = 1;
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsPointerEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_pointerId);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_width);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_height);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_pressure);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_tangentialPressure);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_tiltX);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_tiltY);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_twist);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_pointerType);
static JSC_DECLARE_CUSTOM_GETTER(jsPointerEvent_isPrimary);

class JSPointerEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSPointerEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSPointerEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSPointerEventPrototype>(vm)) JSPointerEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPointerEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSPointerEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSPointerEventPrototype, JSPointerEventPrototype::Base);

using JSPointerEventDOMConstructor = JSDOMConstructor<JSPointerEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSPointerEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSPointerEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDict = convert<IDLDictionary<PointerEvent::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = PointerEvent::create(WTFMove(type), WTFMove(eventInitDict));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<PointerEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<PointerEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSPointerEventDOMConstructorConstruct, JSPointerEventDOMConstructor::construct);

template<> const ClassInfo JSPointerEventDOMConstructor::s_info = { "PointerEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPointerEventDOMConstructor) };

template<> JSValue JSPointerEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMouseEvent::getConstructor(vm, &globalObject);
}

template<> void JSPointerEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "PointerEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSPointerEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSPointerEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEventConstructor, 0 } },
    { "pointerId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_pointerId, 0 } },
    { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_width, 0 } },
    { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_height, 0 } },
    { "pressure"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_pressure, 0 } },
    { "tangentialPressure"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_tangentialPressure, 0 } },
    { "tiltX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_tiltX, 0 } },
    { "tiltY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_tiltY, 0 } },
    { "twist"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_twist, 0 } },
    { "pointerType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_pointerType, 0 } },
    { "isPrimary"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsPointerEvent_isPrimary, 0 } },
};

const ClassInfo JSPointerEventPrototype::s_info = { "PointerEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPointerEventPrototype) };

void JSPointerEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSPointerEvent::info(), JSPointerEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSPointerEvent::s_info = { "PointerEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSPointerEvent) };

JSPointerEvent::JSPointerEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<PointerEvent>&& impl)
    : JSMouseEvent(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, PointerEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSPointerEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSPointerEventPrototype::createStructure(vm, &globalObject, JSMouseEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSPointerEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSPointerEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSPointerEvent>(vm, globalObject);
}

JSValue JSPointerEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPointerEventDOMConstructor, DOMConstructorID::PointerEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSPointerEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSPointerEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsPointerEvent_pointerIdGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.pointerId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_pointerId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_pointerIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_widthGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_heightGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_pressureGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.pressure())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_pressure, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_pressureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_tangentialPressureGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.tangentialPressure())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_tangentialPressure, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_tangentialPressureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_tiltXGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tiltX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_tiltX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_tiltXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_tiltYGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.tiltY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_tiltY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_tiltYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_twistGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.twist())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_twist, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_twistGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_pointerTypeGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.pointerType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_pointerType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_pointerTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsPointerEvent_isPrimaryGetter(JSGlobalObject& lexicalGlobalObject, JSPointerEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isPrimary())));
}

JSC_DEFINE_CUSTOM_GETTER(jsPointerEvent_isPrimary, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSPointerEvent>::get<jsPointerEvent_isPrimaryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSPointerEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSPointerEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForPointerEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForPointerEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForPointerEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForPointerEvent = std::forward<decltype(space)>(space); }
    );
}

void JSPointerEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSPointerEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PointerEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12PointerEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<PointerEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<PointerEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7PointerEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12PointerEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // PointerEvent has subclasses. If PointerEvent has subclasses that get passed
        // to toJS() we currently require PointerEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<PointerEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, PointerEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
