/*
 * Copyright (C) 2022 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "GeneratedSerializers.h"

#include "APIError.h"
#include "APIFrameHandle.h"
#include "APIGeometry.h"
#include "APIPageHandle.h"
#include "APIURL.h"
#include "APIURLRequest.h"
#include "APIURLResponse.h"
#include "ArgumentCoders.h"
#if USE(SOUP)
#include "ArgumentCodersGLib.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "AudioTrackPrivateRemoteConfiguration.h"
#endif
#include "AuxiliaryProcessCreationParameters.h"
#include "BackgroundFetchState.h"
#if ENABLE(SERVICE_WORKER)
#include "BackgroundFetchState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "BufferIdentifierSet.h"
#endif
#include "CacheModel.h"
#include "CallbackID.h"
#include "EditorState.h"
#include "FileSystemSyncAccessHandleInfo.h"
#include "FocusedElementInformation.h"
#include "FrameInfoData.h"
#include "FrameTreeCreationParameters.h"
#include "FrameTreeNodeData.h"
#if ENABLE(GPU_PROCESS)
#include "GPUProcessConnectionParameters.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "GPUProcessSessionParameters.h"
#endif
#if ENABLE(GAMEPAD)
#include "GamepadData.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
#include "InitializationSegmentInfo.h"
#endif
#include "LayerTreeContext.h"
#include "LocalFrameCreationParameters.h"
#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
#include "MediaDescriptionInfo.h"
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW)
#include "ModelIdentifier.h"
#endif
#include "NavigationActionData.h"
#include "NetworkLoadParameters.h"
#include "NetworkProcessConnectionParameters.h"
#include "NetworkProcessCreationParameters.h"
#include "NetworkResourceLoadParameters.h"
#include "PlatformPopupMenuData.h"
#include "PolicyDecision.h"
#if ENABLE(GPU_PROCESS) && PLATFORM(COCOA)
#include "PrepareBackingStoreBuffersData.h"
#endif
#if ENABLE(GPU_PROCESS) && USE(AUDIO_SESSION)
#include "RemoteAudioSessionConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(ENCRYPTED_MEDIA)
#include "RemoteCDMConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteGPURequestAdapterResponse.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteMediaPlayerConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteMediaPlayerProxyConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "RemoteMediaPlayerState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "RemoteRenderingBackendCreationParameters.h"
#endif
#include "RemoteWorkerType.h"
#include "SameDocumentNavigationType.h"
#include "SessionState.h"
#include "ShareableBitmap.h"
#include "StreamConnectionEncoder.h"
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "TextTrackPrivateRemoteConfiguration.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "TrackPrivateRemoteConfiguration.h"
#endif
#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
#include "UpdateInfo.h"
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
#include "VideoTrackPrivateRemoteConfiguration.h"
#endif
#include "WebCoreArgumentCoders.h"
#include "WebEvent.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupEntry.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupLayoutDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBindGroupLayoutEntry.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBlendComponent.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBlendState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBufferBinding.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBufferBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUBufferDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCanvasConfiguration.h"
#endif
#include "WebGPUColor.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUColorTargetState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCommandBufferDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCommandEncoderDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUCompilationMessage.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUComputePassDescriptor.h"
#endif
#include "WebGPUComputePassTimestampWrites.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUComputePipelineDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUDepthStencilState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUDeviceDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUExtent3D.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUExternalTextureBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUExternalTextureDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUFragmentState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyBuffer.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyExternalImage.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyTexture.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageCopyTextureTagged.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUImageDataLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUMultisampleState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUObjectDescriptorBase.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUOrigin2D.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUOrigin3D.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUOutOfMemoryError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUPipelineDescriptorBase.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUPipelineLayoutDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUPresentationContextDescriptor.h"
#endif
#include "WebGPUPrimitiveState.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUPrimitiveState.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUProgrammableStage.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUQuerySetDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderBundleDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderBundleEncoderDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassColorAttachment.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassDepthStencilAttachment.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPassLayout.h"
#endif
#include "WebGPURenderPassTimestampWrites.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPURenderPipelineDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPURequestAdapterOptions.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSamplerBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSamplerDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUShaderModuleCompilationHint.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUShaderModuleDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUStencilFaceState.h"
#endif
#include "WebGPUStorageTextureBindingLayout.h"
#if ENABLE(GPU_PROCESS)
#include "WebGPUStorageTextureBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSupportedFeatures.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUSupportedLimits.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUTextureBindingLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUTextureDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUTextureViewDescriptor.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUValidationError.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUVertexAttribute.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUVertexBufferLayout.h"
#endif
#if ENABLE(GPU_PROCESS)
#include "WebGPUVertexState.h"
#endif
#if ENABLE(MAC_GESTURE_EVENTS)
#include "WebGestureEvent.h"
#endif
#include "WebHitTestResultData.h"
#include "WebIDBResult.h"
#include "WebKeyboardEvent.h"
#include "WebMouseEvent.h"
#include "WebPageCreationParameters.h"
#include "WebPopupItem.h"
#include "WebProcessCreationParameters.h"
#include "WebProcessDataStoreParameters.h"
#include "WebPushDaemonConnectionConfiguration.h"
#include "WebPushMessage.h"
#if ENABLE(SPEECH_SYNTHESIS)
#include "WebSpeechSynthesisVoice.h"
#endif
#if ENABLE(TOUCH_EVENTS)
#include "WebTouchEvent.h"
#endif
#include "WebWheelEvent.h"
#include "WebsiteData.h"
#include "WebsiteDataFetchOption.h"
#include "WebsiteDataStoreParameters.h"
#include "WebsiteDataType.h"
#include "WebsitePoliciesData.h"
#if USE(CG)
#include <CoreGraphics/CGAffineTransform.h>
#endif
#if USE(CG)
#include <CoreGraphics/CGGeometry.h>
#endif
#include <JavaScriptCore/ArrayBuffer.h>
#if USE(SYSTEM_PREVIEW)
#include <WebCore/ARKitBadgeSystemImage.h>
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/AcceleratedEffect.h>
#endif
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/AcceleratedEffectValues.h>
#endif
#include <WebCore/AffineTransform.h>
#if ENABLE(APP_HIGHLIGHTS)
#include <WebCore/AppHighlight.h>
#endif
#if USE(APPKIT)
#include <WebCore/AppKitControlSystemImage.h>
#endif
#if ENABLE(APPLE_PAY_AMS_UI) && ENABLE(PAYMENT_REQUEST)
#include <WebCore/ApplePayAMSUIRequest.h>
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
#include <WebCore/ApplePayAutomaticReloadPaymentRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayButtonPart.h>
#endif
#if ENABLE(APPLE_PAY_COUPON_CODE)
#include <WebCore/ApplePayCouponCodeUpdate.h>
#endif
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
#include <WebCore/ApplePayDateComponents.h>
#endif
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
#include <WebCore/ApplePayDateComponentsRange.h>
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
#include <WebCore/ApplePayDeferredPaymentRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayDetailsUpdateBase.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayError.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayFeature.h>
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
#include <WebCore/ApplePayInstallmentConfigurationWebCore.h>
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
#include <WebCore/ApplePayInstallmentItem.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayLineItem.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayLogoSystemImage.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayPaymentAuthorizationResult.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayPaymentMethodUpdate.h>
#endif
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
#include <WebCore/ApplePayPaymentOrderDetails.h>
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
#include <WebCore/ApplePayPaymentTokenContext.h>
#endif
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
#include <WebCore/ApplePayRecurringPaymentRequest.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePaySetupConfiguration.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayShippingContactUpdate.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayShippingMethod.h>
#endif
#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayShippingMethodUpdate.h>
#endif
#if ENABLE(APPLICATION_MANIFEST)
#include <WebCore/ApplicationManifest.h>
#endif
#include <WebCore/AttributionSecondsUntilSendData.h>
#include <WebCore/AudioConfiguration.h>
#include <WebCore/AudioIOCallback.h>
#if USE(AUDIO_SESSION)
#include <WebCore/AudioSession.h>
#endif
#include <WebCore/AuthenticationChallenge.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticationExtensionsClientInputs.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/AuthenticationExtensionsClientOutputs.h>
#endif
#include <WebCore/AutocapitalizeTypes.h>
#include <WebCore/Autofill.h>
#if ENABLE(SERVICE_WORKER)
#include <WebCore/BackgroundFetchInformation.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/BackgroundFetchOptions.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/BackgroundFetchRecordInformation.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/BackgroundFetchRequest.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/BarcodeDetectorOptionsInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/BarcodeFormatInterface.h>
#endif
#include <WebCore/BasicShapes.h>
#include <WebCore/BufferSource.h>
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMKeySystemConfiguration.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMMediaCapability.h>
#endif
#if ENABLE(ENCRYPTED_MEDIA)
#include <WebCore/CDMRestrictions.h>
#endif
#include <WebCore/COEPInheritenceViolationReportBody.h>
#include <WebCore/CORPViolationReportBody.h>
#include <WebCore/CSPViolationReportBody.h>
#include <WebCore/CSSValueKey.h>
#include <WebCore/CacheQueryOptions.h>
#include <WebCore/CanvasActivityRecord.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/CaptureDevice.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/CaptureDeviceWithCapabilities.h>
#endif
#if PLATFORM(MAC)
#include <WebCore/CaretAnimator.h>
#endif
#include <WebCore/CertificateInfo.h>
#include <WebCore/CharacterRange.h>
#include <WebCore/ClientOrigin.h>
#include <WebCore/ColorInterpolationMethod.h>
#include <WebCore/CompositionHighlight.h>
#include <WebCore/CompositionUnderline.h>
#include <WebCore/ContactInfo.h>
#include <WebCore/ContactsRequestData.h>
#if ENABLE(CONTENT_EXTENSIONS)
#include <WebCore/ContentRuleListResults.h>
#endif
#include <WebCore/ContentSecurityPolicy.h>
#include <WebCore/ContentType.h>
#include <WebCore/ControlStyle.h>
#include <WebCore/Cookie.h>
#include <WebCore/CookieConsentDecisionResult.h>
#include <WebCore/CookieRequestHeaderFieldProxy.h>
#include <WebCore/CookieStoreGetOptions.h>
#include <WebCore/CrossOriginEmbedderPolicy.h>
#include <WebCore/CrossOriginOpenerPolicy.h>
#include <WebCore/CustomHeaderFields.h>
#include <WebCore/DOMCacheEngine.h>
#include <WebCore/DOMPasteAccess.h>
#if ENABLE(DATA_DETECTION)
#include <WebCore/DataDetectorType.h>
#endif
#if ENABLE(DATALIST_ELEMENT)
#include <WebCore/DataListSuggestionInformation.h>
#endif
#include <WebCore/DatabaseDetails.h>
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
#include <WebCore/DateTimeChooserParameters.h>
#endif
#include <WebCore/DecomposedGlyphs.h>
#include <WebCore/DeprecationReportBody.h>
#include <WebCore/DestinationColorSpace.h>
#if ENABLE(WEB_RTC)
#include <WebCore/DetachedRTCDataChannel.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/DetectedBarcodeInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/DetectedFaceInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/DetectedTextInterface.h>
#endif
#include <WebCore/DeviceOrientationOrMotionPermissionState.h>
#include <WebCore/DiagnosticLoggingDomain.h>
#include <WebCore/DictationAlternative.h>
#include <WebCore/DictionaryPopupInfo.h>
#if HAVE(SCREEN_CAPTURE_KIT)
#include <WebCore/DisplayCapturePromptType.h>
#endif
#include <WebCore/DisplayListItems.h>
#include <WebCore/DistantLightSource.h>
#include <WebCore/DocumentLoader.h>
#include <WebCore/DocumentStorageAccess.h>
#include <WebCore/DragData.h>
#if ENABLE(DRAG_SUPPORT)
#include <WebCore/DragData.h>
#endif
#include <WebCore/ElementAnimationContext.h>
#include <WebCore/ElementContext.h>
#include <WebCore/EventInit.h>
#include <WebCore/EventRegion.h>
#include <WebCore/EventTrackingRegions.h>
#include <WebCore/Exception.h>
#include <WebCore/ExceptionData.h>
#include <WebCore/ExceptionDetails.h>
#include <WebCore/FEBlend.h>
#include <WebCore/FEColorMatrix.h>
#include <WebCore/FEComponentTransfer.h>
#include <WebCore/FEComposite.h>
#include <WebCore/FEConvolveMatrix.h>
#include <WebCore/FEDiffuseLighting.h>
#include <WebCore/FEDisplacementMap.h>
#include <WebCore/FEDropShadow.h>
#include <WebCore/FEFlood.h>
#include <WebCore/FEGaussianBlur.h>
#include <WebCore/FEImage.h>
#include <WebCore/FEMerge.h>
#include <WebCore/FEMorphology.h>
#include <WebCore/FEOffset.h>
#include <WebCore/FESpecularLighting.h>
#include <WebCore/FETurbulence.h>
#if ENABLE(GPU_PROCESS)
#include <WebCore/FaceDetectorOptionsInterface.h>
#endif
#include <WebCore/FetchOptions.h>
#include <WebCore/FileChooser.h>
#include <WebCore/FilterEffectGeometry.h>
#include <WebCore/FloatPoint.h>
#include <WebCore/FloatPoint3D.h>
#include <WebCore/FloatQuad.h>
#include <WebCore/FloatRect.h>
#include <WebCore/FloatRoundedRect.h>
#include <WebCore/FloatSize.h>
#include <WebCore/FocusDirection.h>
#include <WebCore/FontAttributeChanges.h>
#include <WebCore/FontAttributes.h>
#include <WebCore/FontShadow.h>
#include <WebCore/FormData.h>
#include <WebCore/FourCC.h>
#include <WebCore/FrameLoaderTypes.h>
#if ENABLE(GAMEPAD)
#include <WebCore/GamepadEffectParameters.h>
#endif
#if ENABLE(GAMEPAD)
#include <WebCore/GamepadHapticEffectType.h>
#endif
#include <WebCore/GeolocationPositionData.h>
#include <WebCore/GlobalFrameIdentifier.h>
#include <WebCore/GlobalWindowIdentifier.h>
#include <WebCore/Gradient.h>
#include <WebCore/GradientColorStop.h>
#include <WebCore/GradientColorStops.h>
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include <WebCore/GraphicsContextGLActiveInfo.h>
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
#include <WebCore/GraphicsContextGLAttributes.h>
#endif
#include <WebCore/GraphicsStyle.h>
#include <WebCore/GraphicsTypes.h>
#include <WebCore/HTMLModelElementCamera.h>
#include <WebCore/HTTPCookieAcceptPolicy.h>
#include <WebCore/HTTPHeaderField.h>
#include <WebCore/HTTPHeaderMap.h>
#include <WebCore/IDBCursorInfo.h>
#include <WebCore/IDBCursorRecord.h>
#include <WebCore/IDBDatabaseIdentifier.h>
#include <WebCore/IDBDatabaseInfo.h>
#include <WebCore/IDBDatabaseNameAndVersion.h>
#include <WebCore/IDBError.h>
#include <WebCore/IDBGetAllRecordsData.h>
#include <WebCore/IDBGetAllResult.h>
#include <WebCore/IDBGetRecordData.h>
#include <WebCore/IDBGetResult.h>
#include <WebCore/IDBIndexInfo.h>
#include <WebCore/IDBIterateCursorData.h>
#include <WebCore/IDBKeyData.h>
#include <WebCore/IDBKeyRangeData.h>
#include <WebCore/IDBObjectStoreInfo.h>
#include <WebCore/IDBRequestData.h>
#include <WebCore/IDBResourceIdentifier.h>
#include <WebCore/IDBResultData.h>
#include <WebCore/IDBTransactionInfo.h>
#include <WebCore/IDBValue.h>
#include <WebCore/ISOVTTCue.h>
#include <WebCore/IdentityTransformOperation.h>
#include <WebCore/ImageBufferBackendParameters.h>
#include <WebCore/ImageDecoder.h>
#include <WebCore/ImageOrientation.h>
#include <WebCore/ImagePaintingOptions.h>
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ImageResource.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/InbandGenericCue.h>
#endif
#include <WebCore/IntPoint.h>
#include <WebCore/IntRect.h>
#include <WebCore/IntSize.h>
#include <WebCore/InteractionRegion.h>
#include <WebCore/KeyboardScroll.h>
#if ENABLE(GPU_PROCESS)
#include <WebCore/LandmarkInterface.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/LandmarkTypeInterface.h>
#endif
#include <WebCore/LayoutPoint.h>
#include <WebCore/LayoutRect.h>
#include <WebCore/LayoutSize.h>
#include <WebCore/LayoutUnit.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/LengthPoint.h>
#endif
#include <WebCore/LengthSize.h>
#include <WebCore/LinkIcon.h>
#include <WebCore/ListStyleType.h>
#include <WebCore/LoadSchedulingMode.h>
#include <WebCore/Matrix3DTransformOperation.h>
#include <WebCore/MatrixTransformOperation.h>
#include <WebCore/MediaCapabilitiesDecodingInfo.h>
#include <WebCore/MediaCapabilitiesEncodingInfo.h>
#include <WebCore/MediaCapabilitiesInfo.h>
#include <WebCore/MediaConfiguration.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MediaConstraints.h>
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS) && USE(UICONTEXTMENU)
#include <WebCore/MediaControlsContextMenuItem.h>
#endif
#include <WebCore/MediaDecodingConfiguration.h>
#include <WebCore/MediaDeviceHashSalts.h>
#include <WebCore/MediaEncodingConfiguration.h>
#if ENABLE(VIDEO)
#include <WebCore/MediaPlayer.h>
#endif
#if ENABLE(MEDIA_SESSION)
#include <WebCore/MediaPositionState.h>
#endif
#include <WebCore/MediaProducer.h>
#include <WebCore/MediaSelectionOption.h>
#if ENABLE(MEDIA_SESSION)
#include <WebCore/MediaSessionAction.h>
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
#include <WebCore/MediaSessionCoordinatorState.h>
#endif
#if ENABLE(MEDIA_SESSION)
#include <WebCore/MediaSessionPlaybackState.h>
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
#include <WebCore/MediaSessionReadyState.h>
#endif
#include <WebCore/MediaStreamRequest.h>
#if ! ENABLE(MEDIA_STREAM)
#include <WebCore/MediaStreamRequest.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MediaStreamRequest.h>
#endif
#include <WebCore/MessagePortIdentifier.h>
#include <WebCore/MessageWithMessagePorts.h>
#include <WebCore/MeterPart.h>
#if ENABLE(CONTENT_FILTERING)
#include <WebCore/MockContentFilterSettings.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/MockMediaDevice.h>
#endif
#if ENABLE(WEB_AUTHN)
#include <WebCore/MockWebAuthenticationConfiguration.h>
#endif
#include <WebCore/ModalContainerTypes.h>
#include <WebCore/Model.h>
#if ENABLE(SERVICE_WORKER)
#include <WebCore/NavigationPreloadState.h>
#endif
#include <WebCore/NavigationRequester.h>
#include <WebCore/NetworkLoadInformation.h>
#include <WebCore/NotificationData.h>
#include <WebCore/NotificationResources.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/OffsetRotation.h>
#endif
#include <WebCore/Pasteboard.h>
#include <WebCore/PasteboardCustomData.h>
#include <WebCore/PasteboardItemInfo.h>
#include <WebCore/PathOperation.h>
#include <WebCore/PathSegment.h>
#include <WebCore/PathSegmentData.h>
#include <WebCore/Pattern.h>
#if ENABLE(APPLE_PAY_INSTALLMENTS)
#include <WebCore/PaymentInstallmentConfigurationWebCore.h>
#endif
#include <WebCore/PermissionDescriptor.h>
#include <WebCore/PermissionQuerySource.h>
#include <WebCore/PermissionState.h>
#include <WebCore/PerspectiveTransformOperation.h>
#include <WebCore/PixelBufferFormat.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformAudioTrackConfiguration.h>
#endif
#if !USE(CG)
#include <WebCore/PlatformColorSpace.h>
#endif
#include <WebCore/PlatformTimeRanges.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformTrackConfiguration.h>
#endif
#include <WebCore/PlatformVideoColorSpace.h>
#if ENABLE(VIDEO)
#include <WebCore/PlatformVideoTrackConfiguration.h>
#endif
#include <WebCore/PlatformWheelEvent.h>
#include <WebCore/PluginData.h>
#include <WebCore/PointLightSource.h>
#include <WebCore/PolicyContainer.h>
#include <WebCore/PositionedGlyphs.h>
#include <WebCore/PrivateClickMeasurement.h>
#include <WebCore/ProcessIdentity.h>
#include <WebCore/ProgressBarPart.h>
#include <WebCore/PromisedAttachmentInfo.h>
#include <WebCore/ProtectionSpace.h>
#include <WebCore/PublicKeyCredentialCreationOptions.h>
#if ENABLE(WEB_AUTHN)
#include <WebCore/PublicKeyCredentialDescriptor.h>
#endif
#include <WebCore/PublicKeyCredentialRequestOptions.h>
#if ENABLE(SERVICE_WORKER)
#include <WebCore/PushPermissionState.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/PushSubscriptionData.h>
#endif
#if ENABLE(WEB_RTC)
#include <WebCore/RTCDataChannelHandler.h>
#endif
#if ENABLE(WEB_RTC)
#include <WebCore/RTCDataChannelIdentifier.h>
#endif
#include <WebCore/RTCErrorDetailType.h>
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSource.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceCapabilities.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceSettings.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/RealtimeMediaSourceSupportedConstraints.h>
#endif
#include <WebCore/RectEdges.h>
#include <WebCore/Region.h>
#include <WebCore/RegistrableDomain.h>
#include <WebCore/RenderStyleConstants.h>
#include <WebCore/RenderTreeAsText.h>
#include <WebCore/Report.h>
#include <WebCore/ReportBody.h>
#include <WebCore/ResourceLoadStatistics.h>
#include <WebCore/ResourceLoaderOptions.h>
#include <WebCore/ResourceRequest.h>
#if !USE(CURL) && !PLATFORM(COCOA)
#include <WebCore/ResourceRequest.h>
#endif
#if PLATFORM(COCOA)
#include <WebCore/ResourceRequest.h>
#endif
#if USE(CURL)
#include <WebCore/ResourceRequest.h>
#endif
#if USE(SOUP)
#include <WebCore/ResourceRequest.h>
#endif
#include <WebCore/ResourceResponse.h>
#include <WebCore/ResourceResponseBase.h>
#include <WebCore/RetrieveRecordsOptions.h>
#include <WebCore/RotateTransformOperation.h>
#include <WebCore/SVGFilterExpression.h>
#include <WebCore/SVGPathByteStream.h>
#include <WebCore/SVGPreserveAspectRatioValue.h>
#include <WebCore/SameSiteInfo.h>
#include <WebCore/ScaleTransformOperation.h>
#include <WebCore/ScreenOrientationLockType.h>
#include <WebCore/ScreenOrientationType.h>
#include <WebCore/ScreenProperties.h>
#include <WebCore/ScrollTypes.h>
#include <WebCore/ScrollingConstraints.h>
#include <WebCore/ScrollingCoordinatorTypes.h>
#if ENABLE(ASYNC_SCROLLING)
#include <WebCore/ScrollingStateNode.h>
#endif
#include <WebCore/SearchPopupMenu.h>
#include <WebCore/SecurityOrigin.h>
#include <WebCore/SecurityOriginData.h>
#include <WebCore/SecurityPolicyViolationEvent.h>
#include <WebCore/SecurityPolicyViolationEventDisposition.h>
#if PLATFORM(IOS_FAMILY)
#include <WebCore/SelectionGeometry.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerClientData.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerClientPendingMessage.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerClientQueryOptions.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerContextData.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerData.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerImportedScript.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerJobData.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerJobDataIdentifier.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerRegistrationData.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerRegistrationKey.h>
#endif
#if ENABLE(SERVICE_WORKER)
#include <WebCore/ServiceWorkerRegistrationOptions.h>
#endif
#include <WebCore/ShareData.h>
#include <WebCore/SharedWorkerKey.h>
#include <WebCore/ShouldTreatAsContinuingLoad.h>
#include <WebCore/SkewTransformOperation.h>
#include <WebCore/SliderTrackPart.h>
#include <WebCore/SourceBrush.h>
#include <WebCore/SourceImage.h>
#include <WebCore/SpeechRecognitionError.h>
#include <WebCore/SpeechRecognitionRequestInfo.h>
#include <WebCore/SpeechRecognitionResultData.h>
#include <WebCore/SpeechRecognitionUpdate.h>
#include <WebCore/SpotLightSource.h>
#include <WebCore/StorageEstimate.h>
#include <WebCore/StorageType.h>
#include <WebCore/SubstituteData.h>
#include <WebCore/TestReportBody.h>
#include <WebCore/TextChecking.h>
#include <WebCore/TextGranularity.h>
#include <WebCore/TextIndicator.h>
#include <WebCore/TextManipulationController.h>
#include <WebCore/TextManipulationItem.h>
#include <WebCore/TextManipulationToken.h>
#if ENABLE(IMAGE_ANALYSIS)
#include <WebCore/TextRecognitionResult.h>
#endif
#include <WebCore/TimingFunction.h>
#include <WebCore/TransformOperation.h>
#include <WebCore/TransformOperations.h>
#include <WebCore/TransformationMatrix.h>
#include <WebCore/TranslateTransformOperation.h>
#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
#include <WebCore/TranslationContextMenuInfo.h>
#endif
#include <WebCore/UserStyleSheet.h>
#include <WebCore/VP9Utilities.h>
#include <WebCore/VelocityData.h>
#if ENABLE(VIDEO)
#include <WebCore/VideoFrame.h>
#endif
#if ENABLE(VIDEO) && USE(AVFOUNDATION)
#include <WebCore/VideoFrameCV.h>
#endif
#if ENABLE(VIDEO)
#include <WebCore/VideoFrameMetadata.h>
#endif
#include <WebCore/VideoFrameTimeMetadata.h>
#if ENABLE(VIDEO)
#include <WebCore/VideoPlaybackQualityMetrics.h>
#endif
#if ENABLE(MEDIA_STREAM)
#include <WebCore/VideoPreset.h>
#endif
#include <WebCore/ViewportArguments.h>
#include <WebCore/VisibleSelection.h>
#if ENABLE(THREADED_ANIMATION_RESOLUTION)
#include <WebCore/WebAnimationTypes.h>
#endif
#include <WebCore/WebCodecsEncodedVideoChunk.h>
#if ENABLE(WEB_CODECS)
#include <WebCore/WebCodecsEncodedVideoChunkData.h>
#endif
#if ENABLE(GPU_PROCESS)
#include <WebCore/WebGPUExternalTextureDescriptor.h>
#endif
#include <WebCore/WebGPUPredefinedColorSpace.h>
#include <WebCore/WebGPUTextureAspect.h>
#include <WebCore/WebGPUTextureFormat.h>
#include <WebCore/WebLockManagerSnapshot.h>
#include <WebCore/WindowFeatures.h>
#include <WebCore/WorkerFetchResult.h>
#include <WebCore/WorkerInitializationData.h>
#include <WebCore/WorkerOptions.h>
#include <WebCore/WritingDirection.h>
#if ENABLE(WK_WEB_EXTENSIONS)
#include <WebKit/WebExtensionEventListenerType.h>
#endif
#include <wtf/MediaTime.h>
#include <wtf/MonotonicTime.h>
#if ENABLE(SERVICE_WORKER)
#include <wtf/RobinHoodHashTable.h>
#endif
#include <wtf/Seconds.h>
#include <wtf/URL.h>
#include <wtf/WallTime.h>
#include <wtf/text/AtomString.h>

template<size_t...> struct MembersInCorrectOrder;
template<size_t onlyOffset> struct MembersInCorrectOrder<onlyOffset> {
    static constexpr bool value = true;
};
template<size_t firstOffset, size_t secondOffset, size_t... remainingOffsets> struct MembersInCorrectOrder<firstOffset, secondOffset, remainingOffsets...> {
    static constexpr bool value = firstOffset > secondOffset ? false : MembersInCorrectOrder<secondOffset, remainingOffsets...>::value;
};

template<uint64_t...> struct BitsInIncreasingOrder;
template<uint64_t onlyBit> struct BitsInIncreasingOrder<onlyBit> {
    static constexpr bool value = true;
};
template<uint64_t firstBit, uint64_t secondBit, uint64_t... remainingBits> struct BitsInIncreasingOrder<firstBit, secondBit, remainingBits...> {
    static constexpr bool value = firstBit == secondBit >> 1 && BitsInIncreasingOrder<secondBit, remainingBits...>::value;
};

template<bool, bool> struct VirtualTableAndRefCountOverhead;
template<> struct VirtualTableAndRefCountOverhead<true, true> {
    virtual ~VirtualTableAndRefCountOverhead() { }
    unsigned refCount;
#if ASSERT_ENABLED
    bool m_isOwnedByMainThread;
    bool m_areThreadingChecksEnabled;
#endif
#if CHECK_REF_COUNTED_LIFECYCLE
    bool m_deletionHasBegun;
    bool m_adoptionIsRequired;
#endif
};
template<> struct VirtualTableAndRefCountOverhead<false, true> {
    unsigned refCount;
#if ASSERT_ENABLED
    bool m_isOwnedByMainThread;
    bool m_areThreadingChecksEnabled;
#endif
#if CHECK_REF_COUNTED_LIFECYCLE
    bool m_deletionHasBegun;
    bool m_adoptionIsRequired;
#endif
};
template<> struct VirtualTableAndRefCountOverhead<true, false> {
    virtual ~VirtualTableAndRefCountOverhead() { }
};
template<> struct VirtualTableAndRefCountOverhead<false, false> { };

#if COMPILER(GCC)
IGNORE_WARNINGS_BEGIN("invalid-offsetof")
#endif

namespace IPC {


#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
template<> struct ArgumentCoder<WebKit::InitializationSegmentInfo::TrackInformation> {
    static void encode(Encoder&, const WebKit::InitializationSegmentInfo::TrackInformation&);
    static std::optional<WebKit::InitializationSegmentInfo::TrackInformation> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebKit::EditorState::PostLayoutData> {
    static void encode(Encoder&, const WebKit::EditorState::PostLayoutData&);
    static std::optional<WebKit::EditorState::PostLayoutData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::EditorState::VisualData> {
    static void encode(Encoder&, const WebKit::EditorState::VisualData&);
    static std::optional<WebKit::EditorState::VisualData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::HTTPBody::Element> {
    static void encode(Encoder&, const WebKit::HTTPBody::Element&);
    static std::optional<WebKit::HTTPBody::Element> decode(Decoder&);
};

template<> struct ArgumentCoder<WebKit::HTTPBody::Element::FileData> {
    static void encode(Encoder&, const WebKit::HTTPBody::Element::FileData&);
    static std::optional<WebKit::HTTPBody::Element::FileData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::IDBKeyData::Invalid> {
    static void encode(Encoder&, const WebCore::IDBKeyData::Invalid&);
    static std::optional<WebCore::IDBKeyData::Invalid> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::IDBKeyData::Min> {
    static void encode(Encoder&, const WebCore::IDBKeyData::Min&);
    static std::optional<WebCore::IDBKeyData::Min> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::IDBKeyData::Max> {
    static void encode(Encoder&, const WebCore::IDBKeyData::Max&);
    static std::optional<WebCore::IDBKeyData::Max> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::IDBKeyData::Date> {
    static void encode(Encoder&, const WebCore::IDBKeyData::Date&);
    static std::optional<WebCore::IDBKeyData::Date> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::LinearTimingFunction::Point> {
    static void encode(Encoder&, const WebCore::LinearTimingFunction::Point&);
    static std::optional<WebCore::LinearTimingFunction::Point> decode(Decoder&);
};

#if ENABLE(APPLICATION_MANIFEST)
template<> struct ArgumentCoder<WebCore::ApplicationManifest::Icon> {
    static void encode(Encoder&, const WebCore::ApplicationManifest::Icon&);
    static std::optional<WebCore::ApplicationManifest::Icon> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::WebLockManagerSnapshot::Info> {
    static void encode(Encoder&, const WebCore::WebLockManagerSnapshot::Info&);
    static std::optional<WebCore::WebLockManagerSnapshot::Info> decode(Decoder&);
};

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs> {
    static void encode(Encoder&, const WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs&);
    static std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput> {
    static void encode(Encoder&, const WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput&);
    static std::optional<WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs> {
    static void encode(Encoder&, const WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs&);
    static std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::Parameters> {
    static void encode(Encoder&, const WebCore::PublicKeyCredentialCreationOptions::Parameters&);
    static std::optional<WebCore::PublicKeyCredentialCreationOptions::Parameters> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria> {
    static void encode(Encoder&, const WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria&);
    static std::optional<WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::Entity> {
    static void encode(Encoder&, const WebCore::PublicKeyCredentialCreationOptions::Entity&);
    static std::optional<WebCore::PublicKeyCredentialCreationOptions::Entity> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::RpEntity> {
    static void encode(Encoder&, const WebCore::PublicKeyCredentialCreationOptions::RpEntity&);
    static std::optional<WebCore::PublicKeyCredentialCreationOptions::RpEntity> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::UserEntity> {
    static void encode(Encoder&, const WebCore::PublicKeyCredentialCreationOptions::UserEntity&);
    static std::optional<WebCore::PublicKeyCredentialCreationOptions::UserEntity> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::HTTPHeaderMap::CommonHeader> {
    static void encode(Encoder&, const WebCore::HTTPHeaderMap::CommonHeader&);
    static std::optional<WebCore::HTTPHeaderMap::CommonHeader> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::HTTPHeaderMap::UncommonHeader> {
    static void encode(Encoder&, const WebCore::HTTPHeaderMap::UncommonHeader&);
    static std::optional<WebCore::HTTPHeaderMap::UncommonHeader> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ResourceRequest::RequestData> {
    static void encode(Encoder&, const WebCore::ResourceRequest::RequestData&);
    static std::optional<WebCore::ResourceRequest::RequestData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::FormDataElement::EncodedFileData> {
    static void encode(Encoder&, const WebCore::FormDataElement::EncodedFileData&);
    static std::optional<WebCore::FormDataElement::EncodedFileData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::FormDataElement::EncodedBlobData> {
    static void encode(Encoder&, const WebCore::FormDataElement::EncodedBlobData&);
    static std::optional<WebCore::FormDataElement::EncodedBlobData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::PlatformTimeRanges::Range> {
    static void encode(Encoder&, const WebCore::PlatformTimeRanges::Range&);
    static std::optional<WebCore::PlatformTimeRanges::Range> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::PasteboardCustomData::Entry> {
    static void encode(Encoder&, const WebCore::PasteboardCustomData::Entry&);
    static std::optional<WebCore::PasteboardCustomData::Entry> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Gradient::LinearData> {
    static void encode(Encoder&, const WebCore::Gradient::LinearData&);
    static void encode(StreamConnectionEncoder&, const WebCore::Gradient::LinearData&);
    static std::optional<WebCore::Gradient::LinearData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Gradient::RadialData> {
    static void encode(Encoder&, const WebCore::Gradient::RadialData&);
    static void encode(StreamConnectionEncoder&, const WebCore::Gradient::RadialData&);
    static std::optional<WebCore::Gradient::RadialData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Gradient::ConicData> {
    static void encode(Encoder&, const WebCore::Gradient::ConicData&);
    static void encode(StreamConnectionEncoder&, const WebCore::Gradient::ConicData&);
    static std::optional<WebCore::Gradient::ConicData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Pattern::Parameters> {
    static void encode(Encoder&, const WebCore::Pattern::Parameters&);
    static void encode(StreamConnectionEncoder&, const WebCore::Pattern::Parameters&);
    static std::optional<WebCore::Pattern::Parameters> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SourceBrush::Brush> {
    static void encode(Encoder&, const WebCore::SourceBrush::Brush&);
    static void encode(StreamConnectionEncoder&, const WebCore::SourceBrush::Brush&);
    static std::optional<WebCore::SourceBrush::Brush> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ResourceResponseBase::ResponseData> {
    static void encode(Encoder&, const WebCore::ResourceResponseBase::ResponseData&);
    static std::optional<WebCore::ResourceResponseBase::ResponseData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ResourceResponseBase::CrossThreadData> {
    static void encode(Encoder&, const WebCore::ResourceResponseBase::CrossThreadData&);
    static std::optional<WebCore::ResourceResponseBase::CrossThreadData> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::TextManipulationControllerExclusionRule::ElementRule> {
    static void encode(Encoder&, const WebCore::TextManipulationControllerExclusionRule::ElementRule&);
    static std::optional<WebCore::TextManipulationControllerExclusionRule::ElementRule> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::TextManipulationControllerExclusionRule::AttributeRule> {
    static void encode(Encoder&, const WebCore::TextManipulationControllerExclusionRule::AttributeRule&);
    static std::optional<WebCore::TextManipulationControllerExclusionRule::AttributeRule> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::TextManipulationControllerExclusionRule::ClassRule> {
    static void encode(Encoder&, const WebCore::TextManipulationControllerExclusionRule::ClassRule&);
    static std::optional<WebCore::TextManipulationControllerExclusionRule::ClassRule> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::HSL> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::HSL&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::HSL&);
    static std::optional<WebCore::ColorInterpolationMethod::HSL> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::HWB> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::HWB&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::HWB&);
    static std::optional<WebCore::ColorInterpolationMethod::HWB> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::LCH> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::LCH&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::LCH&);
    static std::optional<WebCore::ColorInterpolationMethod::LCH> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::Lab> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::Lab&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::Lab&);
    static std::optional<WebCore::ColorInterpolationMethod::Lab> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::OKLCH> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::OKLCH&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::OKLCH&);
    static std::optional<WebCore::ColorInterpolationMethod::OKLCH> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::OKLab> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::OKLab&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::OKLab&);
    static std::optional<WebCore::ColorInterpolationMethod::OKLab> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::SRGB> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::SRGB&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::SRGB&);
    static std::optional<WebCore::ColorInterpolationMethod::SRGB> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::SRGBLinear> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::SRGBLinear&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::SRGBLinear&);
    static std::optional<WebCore::ColorInterpolationMethod::SRGBLinear> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::XYZD50> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::XYZD50&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::XYZD50&);
    static std::optional<WebCore::ColorInterpolationMethod::XYZD50> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::ColorInterpolationMethod::XYZD65> {
    static void encode(Encoder&, const WebCore::ColorInterpolationMethod::XYZD65&);
    static void encode(StreamConnectionEncoder&, const WebCore::ColorInterpolationMethod::XYZD65&);
    static std::optional<WebCore::ColorInterpolationMethod::XYZD65> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::SecurityOriginData::Tuple> {
    static void encode(Encoder&, const WebCore::SecurityOriginData::Tuple&);
    static std::optional<WebCore::SecurityOriginData::Tuple> decode(Decoder&);
};

#if ENABLE(CONTENT_EXTENSIONS)
template<> struct ArgumentCoder<WebCore::ContentRuleListResults::Result> {
    static void encode(Encoder&, const WebCore::ContentRuleListResults::Result&);
    static std::optional<WebCore::ContentRuleListResults::Result> decode(Decoder&);
};
#endif

#if ENABLE(CONTENT_EXTENSIONS)
template<> struct ArgumentCoder<WebCore::ContentRuleListResults::Summary> {
    static void encode(Encoder&, const WebCore::ContentRuleListResults::Summary&);
    static std::optional<WebCore::ContentRuleListResults::Summary> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebCore::Region::Span> {
    static void encode(Encoder&, const WebCore::Region::Span&);
    static std::optional<WebCore::Region::Span> decode(Decoder&);
};

template<> struct ArgumentCoder<WebCore::Region::Shape> {
    static void encode(Encoder&, const WebCore::Region::Shape&);
    static std::optional<WebCore::Region::Shape> decode(Decoder&);
};

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::MockWebAuthenticationConfiguration::LocalConfiguration> {
    static void encode(Encoder&, const WebCore::MockWebAuthenticationConfiguration::LocalConfiguration&);
    static std::optional<WebCore::MockWebAuthenticationConfiguration::LocalConfiguration> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::MockWebAuthenticationConfiguration::HidConfiguration> {
    static void encode(Encoder&, const WebCore::MockWebAuthenticationConfiguration::HidConfiguration&);
    static std::optional<WebCore::MockWebAuthenticationConfiguration::HidConfiguration> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::MockWebAuthenticationConfiguration::NfcConfiguration> {
    static void encode(Encoder&, const WebCore::MockWebAuthenticationConfiguration::NfcConfiguration&);
    static std::optional<WebCore::MockWebAuthenticationConfiguration::NfcConfiguration> decode(Decoder&);
};
#endif

#if ENABLE(WEB_AUTHN)
template<> struct ArgumentCoder<WebCore::MockWebAuthenticationConfiguration::CcidConfiguration> {
    static void encode(Encoder&, const WebCore::MockWebAuthenticationConfiguration::CcidConfiguration&);
    static std::optional<WebCore::MockWebAuthenticationConfiguration::CcidConfiguration> decode(Decoder&);
};
#endif

template<> struct ArgumentCoder<WebKit::WebsiteData::Entry> {
    static void encode(Encoder&, const WebKit::WebsiteData::Entry&);
    static std::optional<WebKit::WebsiteData::Entry> decode(Decoder&);
};

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::GPUProcessSessionParameters>::encode(Encoder& encoder, const WebKit::GPUProcessSessionParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaCacheDirectory)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaCacheDirectorySandboxExtensionHandle)>, WebKit::SandboxExtension::Handle>);
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaKeysStorageDirectory)>, String>);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaKeysStorageDirectorySandboxExtensionHandle)>, WebKit::SandboxExtension::Handle>);
#endif
    struct ShouldBeSameSizeAsGPUProcessSessionParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::GPUProcessSessionParameters>, false> {
        String mediaCacheDirectory;
        WebKit::SandboxExtension::Handle mediaCacheDirectorySandboxExtensionHandle;
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
        String mediaKeysStorageDirectory;
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
        WebKit::SandboxExtension::Handle mediaKeysStorageDirectorySandboxExtensionHandle;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsGPUProcessSessionParameters) == sizeof(WebKit::GPUProcessSessionParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::GPUProcessSessionParameters, mediaCacheDirectory)
        , offsetof(WebKit::GPUProcessSessionParameters, mediaCacheDirectorySandboxExtensionHandle)
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
        , offsetof(WebKit::GPUProcessSessionParameters, mediaKeysStorageDirectory)
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
        , offsetof(WebKit::GPUProcessSessionParameters, mediaKeysStorageDirectorySandboxExtensionHandle)
#endif
    >::value);
    encoder << instance.mediaCacheDirectory;
    encoder << instance.mediaCacheDirectorySandboxExtensionHandle;
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    encoder << instance.mediaKeysStorageDirectory;
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    encoder << instance.mediaKeysStorageDirectorySandboxExtensionHandle;
#endif
}

std::optional<WebKit::GPUProcessSessionParameters> ArgumentCoder<WebKit::GPUProcessSessionParameters>::decode(Decoder& decoder)
{
    auto mediaCacheDirectory = decoder.decode<String>();
    auto mediaCacheDirectorySandboxExtensionHandle = decoder.decode<WebKit::SandboxExtension::Handle>();
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    auto mediaKeysStorageDirectory = decoder.decode<String>();
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    auto mediaKeysStorageDirectorySandboxExtensionHandle = decoder.decode<WebKit::SandboxExtension::Handle>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::GPUProcessSessionParameters {
            WTFMove(*mediaCacheDirectory),
            WTFMove(*mediaCacheDirectorySandboxExtensionHandle),
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
            WTFMove(*mediaKeysStorageDirectory),
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
            WTFMove(*mediaKeysStorageDirectorySandboxExtensionHandle)
#endif
        }
    };
}

#endif

void ArgumentCoder<WebCore::PathMoveTo>::encode(Encoder& encoder, const WebCore::PathMoveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathMoveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathMoveTo>, false> {
        WebCore::FloatPoint point;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathMoveTo) == sizeof(WebCore::PathMoveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathMoveTo, point)
    >::value);
    encoder << instance.point;
}

void ArgumentCoder<WebCore::PathMoveTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathMoveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathMoveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathMoveTo>, false> {
        WebCore::FloatPoint point;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathMoveTo) == sizeof(WebCore::PathMoveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathMoveTo, point)
    >::value);
    encoder << instance.point;
}

std::optional<WebCore::PathMoveTo> ArgumentCoder<WebCore::PathMoveTo>::decode(Decoder& decoder)
{
    auto point = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathMoveTo {
            WTFMove(*point)
        }
    };
}

void ArgumentCoder<WebCore::PathLineTo>::encode(Encoder& encoder, const WebCore::PathLineTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathLineTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathLineTo>, false> {
        WebCore::FloatPoint point;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathLineTo) == sizeof(WebCore::PathLineTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathLineTo, point)
    >::value);
    encoder << instance.point;
}

void ArgumentCoder<WebCore::PathLineTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathLineTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathLineTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathLineTo>, false> {
        WebCore::FloatPoint point;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathLineTo) == sizeof(WebCore::PathLineTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathLineTo, point)
    >::value);
    encoder << instance.point;
}

std::optional<WebCore::PathLineTo> ArgumentCoder<WebCore::PathLineTo>::decode(Decoder& decoder)
{
    auto point = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathLineTo {
            WTFMove(*point)
        }
    };
}

void ArgumentCoder<WebCore::PathQuadCurveTo>::encode(Encoder& encoder, const WebCore::PathQuadCurveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathQuadCurveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathQuadCurveTo>, false> {
        WebCore::FloatPoint controlPoint;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathQuadCurveTo) == sizeof(WebCore::PathQuadCurveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathQuadCurveTo, controlPoint)
        , offsetof(WebCore::PathQuadCurveTo, endPoint)
    >::value);
    encoder << instance.controlPoint;
    encoder << instance.endPoint;
}

void ArgumentCoder<WebCore::PathQuadCurveTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathQuadCurveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathQuadCurveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathQuadCurveTo>, false> {
        WebCore::FloatPoint controlPoint;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathQuadCurveTo) == sizeof(WebCore::PathQuadCurveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathQuadCurveTo, controlPoint)
        , offsetof(WebCore::PathQuadCurveTo, endPoint)
    >::value);
    encoder << instance.controlPoint;
    encoder << instance.endPoint;
}

std::optional<WebCore::PathQuadCurveTo> ArgumentCoder<WebCore::PathQuadCurveTo>::decode(Decoder& decoder)
{
    auto controlPoint = decoder.decode<WebCore::FloatPoint>();
    auto endPoint = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathQuadCurveTo {
            WTFMove(*controlPoint),
            WTFMove(*endPoint)
        }
    };
}

void ArgumentCoder<WebCore::PathBezierCurveTo>::encode(Encoder& encoder, const WebCore::PathBezierCurveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathBezierCurveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathBezierCurveTo>, false> {
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathBezierCurveTo) == sizeof(WebCore::PathBezierCurveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathBezierCurveTo, controlPoint1)
        , offsetof(WebCore::PathBezierCurveTo, controlPoint2)
        , offsetof(WebCore::PathBezierCurveTo, endPoint)
    >::value);
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.endPoint;
}

void ArgumentCoder<WebCore::PathBezierCurveTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathBezierCurveTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathBezierCurveTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathBezierCurveTo>, false> {
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathBezierCurveTo) == sizeof(WebCore::PathBezierCurveTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathBezierCurveTo, controlPoint1)
        , offsetof(WebCore::PathBezierCurveTo, controlPoint2)
        , offsetof(WebCore::PathBezierCurveTo, endPoint)
    >::value);
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.endPoint;
}

std::optional<WebCore::PathBezierCurveTo> ArgumentCoder<WebCore::PathBezierCurveTo>::decode(Decoder& decoder)
{
    auto controlPoint1 = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint2 = decoder.decode<WebCore::FloatPoint>();
    auto endPoint = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathBezierCurveTo {
            WTFMove(*controlPoint1),
            WTFMove(*controlPoint2),
            WTFMove(*endPoint)
        }
    };
}

void ArgumentCoder<WebCore::PathArcTo>::encode(Encoder& encoder, const WebCore::PathArcTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    struct ShouldBeSameSizeAsPathArcTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathArcTo>, false> {
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        float radius;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathArcTo) == sizeof(WebCore::PathArcTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathArcTo, controlPoint1)
        , offsetof(WebCore::PathArcTo, controlPoint2)
        , offsetof(WebCore::PathArcTo, radius)
    >::value);
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.radius;
}

void ArgumentCoder<WebCore::PathArcTo>::encode(StreamConnectionEncoder& encoder, const WebCore::PathArcTo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    struct ShouldBeSameSizeAsPathArcTo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathArcTo>, false> {
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        float radius;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathArcTo) == sizeof(WebCore::PathArcTo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathArcTo, controlPoint1)
        , offsetof(WebCore::PathArcTo, controlPoint2)
        , offsetof(WebCore::PathArcTo, radius)
    >::value);
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.radius;
}

std::optional<WebCore::PathArcTo> ArgumentCoder<WebCore::PathArcTo>::decode(Decoder& decoder)
{
    auto controlPoint1 = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint2 = decoder.decode<WebCore::FloatPoint>();
    auto radius = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathArcTo {
            WTFMove(*controlPoint1),
            WTFMove(*controlPoint2),
            WTFMove(*radius)
        }
    };
}

void ArgumentCoder<WebCore::PathArc>::encode(Encoder& encoder, const WebCore::PathArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.center)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::RotationDirection>);
    struct ShouldBeSameSizeAsPathArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathArc>, false> {
        WebCore::FloatPoint center;
        float radius;
        float startAngle;
        float endAngle;
        WebCore::RotationDirection direction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathArc) == sizeof(WebCore::PathArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathArc, center)
        , offsetof(WebCore::PathArc, radius)
        , offsetof(WebCore::PathArc, startAngle)
        , offsetof(WebCore::PathArc, endAngle)
        , offsetof(WebCore::PathArc, direction)
    >::value);
    encoder << instance.center;
    encoder << instance.radius;
    encoder << instance.startAngle;
    encoder << instance.endAngle;
    encoder << instance.direction;
}

void ArgumentCoder<WebCore::PathArc>::encode(StreamConnectionEncoder& encoder, const WebCore::PathArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.center)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::RotationDirection>);
    struct ShouldBeSameSizeAsPathArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathArc>, false> {
        WebCore::FloatPoint center;
        float radius;
        float startAngle;
        float endAngle;
        WebCore::RotationDirection direction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathArc) == sizeof(WebCore::PathArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathArc, center)
        , offsetof(WebCore::PathArc, radius)
        , offsetof(WebCore::PathArc, startAngle)
        , offsetof(WebCore::PathArc, endAngle)
        , offsetof(WebCore::PathArc, direction)
    >::value);
    encoder << instance.center;
    encoder << instance.radius;
    encoder << instance.startAngle;
    encoder << instance.endAngle;
    encoder << instance.direction;
}

std::optional<WebCore::PathArc> ArgumentCoder<WebCore::PathArc>::decode(Decoder& decoder)
{
    auto center = decoder.decode<WebCore::FloatPoint>();
    auto radius = decoder.decode<float>();
    auto startAngle = decoder.decode<float>();
    auto endAngle = decoder.decode<float>();
    auto direction = decoder.decode<WebCore::RotationDirection>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathArc {
            WTFMove(*center),
            WTFMove(*radius),
            WTFMove(*startAngle),
            WTFMove(*endAngle),
            WTFMove(*direction)
        }
    };
}

void ArgumentCoder<WebCore::PathEllipse>::encode(Encoder& encoder, const WebCore::PathEllipse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.center)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusX)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusY)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rotation)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::RotationDirection>);
    struct ShouldBeSameSizeAsPathEllipse : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathEllipse>, false> {
        WebCore::FloatPoint center;
        float radiusX;
        float radiusY;
        float rotation;
        float startAngle;
        float endAngle;
        WebCore::RotationDirection direction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathEllipse) == sizeof(WebCore::PathEllipse));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathEllipse, center)
        , offsetof(WebCore::PathEllipse, radiusX)
        , offsetof(WebCore::PathEllipse, radiusY)
        , offsetof(WebCore::PathEllipse, rotation)
        , offsetof(WebCore::PathEllipse, startAngle)
        , offsetof(WebCore::PathEllipse, endAngle)
        , offsetof(WebCore::PathEllipse, direction)
    >::value);
    encoder << instance.center;
    encoder << instance.radiusX;
    encoder << instance.radiusY;
    encoder << instance.rotation;
    encoder << instance.startAngle;
    encoder << instance.endAngle;
    encoder << instance.direction;
}

void ArgumentCoder<WebCore::PathEllipse>::encode(StreamConnectionEncoder& encoder, const WebCore::PathEllipse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.center)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusX)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusY)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rotation)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endAngle)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::RotationDirection>);
    struct ShouldBeSameSizeAsPathEllipse : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathEllipse>, false> {
        WebCore::FloatPoint center;
        float radiusX;
        float radiusY;
        float rotation;
        float startAngle;
        float endAngle;
        WebCore::RotationDirection direction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathEllipse) == sizeof(WebCore::PathEllipse));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathEllipse, center)
        , offsetof(WebCore::PathEllipse, radiusX)
        , offsetof(WebCore::PathEllipse, radiusY)
        , offsetof(WebCore::PathEllipse, rotation)
        , offsetof(WebCore::PathEllipse, startAngle)
        , offsetof(WebCore::PathEllipse, endAngle)
        , offsetof(WebCore::PathEllipse, direction)
    >::value);
    encoder << instance.center;
    encoder << instance.radiusX;
    encoder << instance.radiusY;
    encoder << instance.rotation;
    encoder << instance.startAngle;
    encoder << instance.endAngle;
    encoder << instance.direction;
}

std::optional<WebCore::PathEllipse> ArgumentCoder<WebCore::PathEllipse>::decode(Decoder& decoder)
{
    auto center = decoder.decode<WebCore::FloatPoint>();
    auto radiusX = decoder.decode<float>();
    auto radiusY = decoder.decode<float>();
    auto rotation = decoder.decode<float>();
    auto startAngle = decoder.decode<float>();
    auto endAngle = decoder.decode<float>();
    auto direction = decoder.decode<WebCore::RotationDirection>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathEllipse {
            WTFMove(*center),
            WTFMove(*radiusX),
            WTFMove(*radiusY),
            WTFMove(*rotation),
            WTFMove(*startAngle),
            WTFMove(*endAngle),
            WTFMove(*direction)
        }
    };
}

void ArgumentCoder<WebCore::PathEllipseInRect>::encode(Encoder& encoder, const WebCore::PathEllipseInRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    struct ShouldBeSameSizeAsPathEllipseInRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathEllipseInRect>, false> {
        WebCore::FloatRect rect;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathEllipseInRect) == sizeof(WebCore::PathEllipseInRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathEllipseInRect, rect)
    >::value);
    encoder << instance.rect;
}

void ArgumentCoder<WebCore::PathEllipseInRect>::encode(StreamConnectionEncoder& encoder, const WebCore::PathEllipseInRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    struct ShouldBeSameSizeAsPathEllipseInRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathEllipseInRect>, false> {
        WebCore::FloatRect rect;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathEllipseInRect) == sizeof(WebCore::PathEllipseInRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathEllipseInRect, rect)
    >::value);
    encoder << instance.rect;
}

std::optional<WebCore::PathEllipseInRect> ArgumentCoder<WebCore::PathEllipseInRect>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathEllipseInRect {
            WTFMove(*rect)
        }
    };
}

void ArgumentCoder<WebCore::PathRect>::encode(Encoder& encoder, const WebCore::PathRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    struct ShouldBeSameSizeAsPathRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathRect>, false> {
        WebCore::FloatRect rect;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathRect) == sizeof(WebCore::PathRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathRect, rect)
    >::value);
    encoder << instance.rect;
}

void ArgumentCoder<WebCore::PathRect>::encode(StreamConnectionEncoder& encoder, const WebCore::PathRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect)>, WebCore::FloatRect>);
    struct ShouldBeSameSizeAsPathRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathRect>, false> {
        WebCore::FloatRect rect;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathRect) == sizeof(WebCore::PathRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathRect, rect)
    >::value);
    encoder << instance.rect;
}

std::optional<WebCore::PathRect> ArgumentCoder<WebCore::PathRect>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathRect {
            WTFMove(*rect)
        }
    };
}

void ArgumentCoder<WebCore::PathRoundedRect>::encode(Encoder& encoder, const WebCore::PathRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.roundedRect)>, WebCore::FloatRoundedRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.strategy)>, WebCore::PathRoundedRect::Strategy>);
    struct ShouldBeSameSizeAsPathRoundedRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathRoundedRect>, false> {
        WebCore::FloatRoundedRect roundedRect;
        WebCore::PathRoundedRect::Strategy strategy;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathRoundedRect) == sizeof(WebCore::PathRoundedRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathRoundedRect, roundedRect)
        , offsetof(WebCore::PathRoundedRect, strategy)
    >::value);
    encoder << instance.roundedRect;
    encoder << instance.strategy;
}

void ArgumentCoder<WebCore::PathRoundedRect>::encode(StreamConnectionEncoder& encoder, const WebCore::PathRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.roundedRect)>, WebCore::FloatRoundedRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.strategy)>, WebCore::PathRoundedRect::Strategy>);
    struct ShouldBeSameSizeAsPathRoundedRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathRoundedRect>, false> {
        WebCore::FloatRoundedRect roundedRect;
        WebCore::PathRoundedRect::Strategy strategy;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathRoundedRect) == sizeof(WebCore::PathRoundedRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathRoundedRect, roundedRect)
        , offsetof(WebCore::PathRoundedRect, strategy)
    >::value);
    encoder << instance.roundedRect;
    encoder << instance.strategy;
}

std::optional<WebCore::PathRoundedRect> ArgumentCoder<WebCore::PathRoundedRect>::decode(Decoder& decoder)
{
    auto roundedRect = decoder.decode<WebCore::FloatRoundedRect>();
    auto strategy = decoder.decode<WebCore::PathRoundedRect::Strategy>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathRoundedRect {
            WTFMove(*roundedRect),
            WTFMove(*strategy)
        }
    };
}

void ArgumentCoder<WebCore::PathDataLine>::encode(Encoder& encoder, const WebCore::PathDataLine& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.end)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataLine : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataLine>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint end;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataLine) == sizeof(WebCore::PathDataLine));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataLine, start)
        , offsetof(WebCore::PathDataLine, end)
    >::value);
    encoder << instance.start;
    encoder << instance.end;
}

void ArgumentCoder<WebCore::PathDataLine>::encode(StreamConnectionEncoder& encoder, const WebCore::PathDataLine& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.end)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataLine : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataLine>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint end;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataLine) == sizeof(WebCore::PathDataLine));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataLine, start)
        , offsetof(WebCore::PathDataLine, end)
    >::value);
    encoder << instance.start;
    encoder << instance.end;
}

std::optional<WebCore::PathDataLine> ArgumentCoder<WebCore::PathDataLine>::decode(Decoder& decoder)
{
    auto start = decoder.decode<WebCore::FloatPoint>();
    auto end = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathDataLine {
            WTFMove(*start),
            WTFMove(*end)
        }
    };
}

void ArgumentCoder<WebCore::PathDataQuadCurve>::encode(Encoder& encoder, const WebCore::PathDataQuadCurve& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataQuadCurve : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataQuadCurve>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataQuadCurve) == sizeof(WebCore::PathDataQuadCurve));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataQuadCurve, start)
        , offsetof(WebCore::PathDataQuadCurve, controlPoint)
        , offsetof(WebCore::PathDataQuadCurve, endPoint)
    >::value);
    encoder << instance.start;
    encoder << instance.controlPoint;
    encoder << instance.endPoint;
}

void ArgumentCoder<WebCore::PathDataQuadCurve>::encode(StreamConnectionEncoder& encoder, const WebCore::PathDataQuadCurve& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataQuadCurve : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataQuadCurve>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataQuadCurve) == sizeof(WebCore::PathDataQuadCurve));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataQuadCurve, start)
        , offsetof(WebCore::PathDataQuadCurve, controlPoint)
        , offsetof(WebCore::PathDataQuadCurve, endPoint)
    >::value);
    encoder << instance.start;
    encoder << instance.controlPoint;
    encoder << instance.endPoint;
}

std::optional<WebCore::PathDataQuadCurve> ArgumentCoder<WebCore::PathDataQuadCurve>::decode(Decoder& decoder)
{
    auto start = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint = decoder.decode<WebCore::FloatPoint>();
    auto endPoint = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathDataQuadCurve {
            WTFMove(*start),
            WTFMove(*controlPoint),
            WTFMove(*endPoint)
        }
    };
}

void ArgumentCoder<WebCore::PathDataBezierCurve>::encode(Encoder& encoder, const WebCore::PathDataBezierCurve& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataBezierCurve : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataBezierCurve>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataBezierCurve) == sizeof(WebCore::PathDataBezierCurve));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataBezierCurve, start)
        , offsetof(WebCore::PathDataBezierCurve, controlPoint1)
        , offsetof(WebCore::PathDataBezierCurve, controlPoint2)
        , offsetof(WebCore::PathDataBezierCurve, endPoint)
    >::value);
    encoder << instance.start;
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.endPoint;
}

void ArgumentCoder<WebCore::PathDataBezierCurve>::encode(StreamConnectionEncoder& encoder, const WebCore::PathDataBezierCurve& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endPoint)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsPathDataBezierCurve : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataBezierCurve>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        WebCore::FloatPoint endPoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataBezierCurve) == sizeof(WebCore::PathDataBezierCurve));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataBezierCurve, start)
        , offsetof(WebCore::PathDataBezierCurve, controlPoint1)
        , offsetof(WebCore::PathDataBezierCurve, controlPoint2)
        , offsetof(WebCore::PathDataBezierCurve, endPoint)
    >::value);
    encoder << instance.start;
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.endPoint;
}

std::optional<WebCore::PathDataBezierCurve> ArgumentCoder<WebCore::PathDataBezierCurve>::decode(Decoder& decoder)
{
    auto start = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint1 = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint2 = decoder.decode<WebCore::FloatPoint>();
    auto endPoint = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathDataBezierCurve {
            WTFMove(*start),
            WTFMove(*controlPoint1),
            WTFMove(*controlPoint2),
            WTFMove(*endPoint)
        }
    };
}

void ArgumentCoder<WebCore::PathDataArc>::encode(Encoder& encoder, const WebCore::PathDataArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    struct ShouldBeSameSizeAsPathDataArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataArc>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        float radius;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataArc) == sizeof(WebCore::PathDataArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataArc, start)
        , offsetof(WebCore::PathDataArc, controlPoint1)
        , offsetof(WebCore::PathDataArc, controlPoint2)
        , offsetof(WebCore::PathDataArc, radius)
    >::value);
    encoder << instance.start;
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.radius;
}

void ArgumentCoder<WebCore::PathDataArc>::encode(StreamConnectionEncoder& encoder, const WebCore::PathDataArc& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.controlPoint2)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius)>, float>);
    struct ShouldBeSameSizeAsPathDataArc : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathDataArc>, false> {
        WebCore::FloatPoint start;
        WebCore::FloatPoint controlPoint1;
        WebCore::FloatPoint controlPoint2;
        float radius;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathDataArc) == sizeof(WebCore::PathDataArc));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PathDataArc, start)
        , offsetof(WebCore::PathDataArc, controlPoint1)
        , offsetof(WebCore::PathDataArc, controlPoint2)
        , offsetof(WebCore::PathDataArc, radius)
    >::value);
    encoder << instance.start;
    encoder << instance.controlPoint1;
    encoder << instance.controlPoint2;
    encoder << instance.radius;
}

std::optional<WebCore::PathDataArc> ArgumentCoder<WebCore::PathDataArc>::decode(Decoder& decoder)
{
    auto start = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint1 = decoder.decode<WebCore::FloatPoint>();
    auto controlPoint2 = decoder.decode<WebCore::FloatPoint>();
    auto radius = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathDataArc {
            WTFMove(*start),
            WTFMove(*controlPoint1),
            WTFMove(*controlPoint2),
            WTFMove(*radius)
        }
    };
}

void ArgumentCoder<WebCore::PathCloseSubpath>::encode(Encoder& encoder, const WebCore::PathCloseSubpath& instance)
{
    struct ShouldBeSameSizeAsPathCloseSubpath : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathCloseSubpath>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathCloseSubpath) == sizeof(WebCore::PathCloseSubpath));
    static_assert(MembersInCorrectOrder < 0
    >::value);
}

void ArgumentCoder<WebCore::PathCloseSubpath>::encode(StreamConnectionEncoder& encoder, const WebCore::PathCloseSubpath& instance)
{
    struct ShouldBeSameSizeAsPathCloseSubpath : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PathCloseSubpath>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsPathCloseSubpath) == sizeof(WebCore::PathCloseSubpath));
    static_assert(MembersInCorrectOrder < 0
    >::value);
}

std::optional<WebCore::PathCloseSubpath> ArgumentCoder<WebCore::PathCloseSubpath>::decode(Decoder& decoder)
{
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathCloseSubpath {
        }
    };
}

void ArgumentCoder<WebCore::PathSegment>::encode(Encoder& encoder, const WebCore::PathSegment& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, WebCore::PathSegment::Data>);
    encoder << instance.data();
}

void ArgumentCoder<WebCore::PathSegment>::encode(StreamConnectionEncoder& encoder, const WebCore::PathSegment& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, WebCore::PathSegment::Data>);
    encoder << instance.data();
}

std::optional<WebCore::PathSegment> ArgumentCoder<WebCore::PathSegment>::decode(Decoder& decoder)
{
    auto data = decoder.decode<WebCore::PathSegment::Data>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PathSegment {
            WTFMove(*data)
        }
    };
}

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::RemoteRenderingBackendCreationParameters>::encode(Encoder& encoder, const WebKit::RemoteRenderingBackendCreationParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebKit::RenderingBackendIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageProxyID)>, WebKit::WebPageProxyIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageID)>, WebCore::PageIdentifier>);
    struct ShouldBeSameSizeAsRemoteRenderingBackendCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteRenderingBackendCreationParameters>, false> {
        WebKit::RenderingBackendIdentifier identifier;
        WebKit::WebPageProxyIdentifier pageProxyID;
        WebCore::PageIdentifier pageID;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteRenderingBackendCreationParameters) == sizeof(WebKit::RemoteRenderingBackendCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteRenderingBackendCreationParameters, identifier)
        , offsetof(WebKit::RemoteRenderingBackendCreationParameters, pageProxyID)
        , offsetof(WebKit::RemoteRenderingBackendCreationParameters, pageID)
    >::value);
    encoder << instance.identifier;
    encoder << instance.pageProxyID;
    encoder << instance.pageID;
}

std::optional<WebKit::RemoteRenderingBackendCreationParameters> ArgumentCoder<WebKit::RemoteRenderingBackendCreationParameters>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebKit::RenderingBackendIdentifier>();
    auto pageProxyID = decoder.decode<WebKit::WebPageProxyIdentifier>();
    auto pageID = decoder.decode<WebCore::PageIdentifier>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::RemoteRenderingBackendCreationParameters {
            WTFMove(*identifier),
            WTFMove(*pageProxyID),
            WTFMove(*pageID)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::RemoteGPURequestAdapterResponse>::encode(Encoder& encoder, const WebKit::RemoteGPURequestAdapterResponse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.features)>, WebKit::WebGPU::SupportedFeatures>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.limits)>, WebKit::WebGPU::SupportedLimits>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFallbackAdapter)>, bool>);
    struct ShouldBeSameSizeAsRemoteGPURequestAdapterResponse : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteGPURequestAdapterResponse>, false> {
        String name;
        WebKit::WebGPU::SupportedFeatures features;
        WebKit::WebGPU::SupportedLimits limits;
        bool isFallbackAdapter;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteGPURequestAdapterResponse) == sizeof(WebKit::RemoteGPURequestAdapterResponse));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, name)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, features)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, limits)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, isFallbackAdapter)
    >::value);
    encoder << instance.name;
    encoder << instance.features;
    encoder << instance.limits;
    encoder << instance.isFallbackAdapter;
}

void ArgumentCoder<WebKit::RemoteGPURequestAdapterResponse>::encode(StreamConnectionEncoder& encoder, const WebKit::RemoteGPURequestAdapterResponse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.features)>, WebKit::WebGPU::SupportedFeatures>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.limits)>, WebKit::WebGPU::SupportedLimits>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFallbackAdapter)>, bool>);
    struct ShouldBeSameSizeAsRemoteGPURequestAdapterResponse : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteGPURequestAdapterResponse>, false> {
        String name;
        WebKit::WebGPU::SupportedFeatures features;
        WebKit::WebGPU::SupportedLimits limits;
        bool isFallbackAdapter;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteGPURequestAdapterResponse) == sizeof(WebKit::RemoteGPURequestAdapterResponse));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, name)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, features)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, limits)
        , offsetof(WebKit::RemoteGPURequestAdapterResponse, isFallbackAdapter)
    >::value);
    encoder << instance.name;
    encoder << instance.features;
    encoder << instance.limits;
    encoder << instance.isFallbackAdapter;
}

std::optional<WebKit::RemoteGPURequestAdapterResponse> ArgumentCoder<WebKit::RemoteGPURequestAdapterResponse>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto features = decoder.decode<WebKit::WebGPU::SupportedFeatures>();
    auto limits = decoder.decode<WebKit::WebGPU::SupportedLimits>();
    auto isFallbackAdapter = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::RemoteGPURequestAdapterResponse {
            WTFMove(*name),
            WTFMove(*features),
            WTFMove(*limits),
            WTFMove(*isFallbackAdapter)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::AudioTrackPrivateRemoteConfiguration>::encode(Encoder& encoder, const WebKit::AudioTrackPrivateRemoteConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackId)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startTimeVariance)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackIndex)>, int>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackId)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, label)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, language)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, startTimeVariance)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackIndex)
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kind)>, WebCore::AudioTrackPrivate::Kind>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackConfiguration)>, WebCore::PlatformAudioTrackConfiguration>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::AudioTrackPrivateRemoteConfiguration, enabled)
        , offsetof(WebKit::AudioTrackPrivateRemoteConfiguration, kind)
        , offsetof(WebKit::AudioTrackPrivateRemoteConfiguration, trackConfiguration)
    >::value);
    encoder << instance.trackId;
    encoder << instance.label;
    encoder << instance.language;
    encoder << instance.startTimeVariance;
    encoder << instance.trackIndex;
    encoder << instance.enabled;
    encoder << instance.kind;
    encoder << instance.trackConfiguration;
}

std::optional<WebKit::AudioTrackPrivateRemoteConfiguration> ArgumentCoder<WebKit::AudioTrackPrivateRemoteConfiguration>::decode(Decoder& decoder)
{
    auto trackId = decoder.decode<AtomString>();
    auto label = decoder.decode<AtomString>();
    auto language = decoder.decode<AtomString>();
    auto startTimeVariance = decoder.decode<MediaTime>();
    auto trackIndex = decoder.decode<int>();
    auto enabled = decoder.decode<bool>();
    auto kind = decoder.decode<WebCore::AudioTrackPrivate::Kind>();
    auto trackConfiguration = decoder.decode<WebCore::PlatformAudioTrackConfiguration>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::AudioTrackPrivateRemoteConfiguration {
            WebKit::TrackPrivateRemoteConfiguration {
                WTFMove(*trackId),
                WTFMove(*label),
                WTFMove(*language),
                WTFMove(*startTimeVariance),
                WTFMove(*trackIndex)
            },
            WTFMove(*enabled),
            WTFMove(*kind),
            WTFMove(*trackConfiguration)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
void ArgumentCoder<WebKit::InitializationSegmentInfo>::encode(Encoder& encoder, const WebKit::InitializationSegmentInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.duration)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.audioTracks)>, Vector<WebKit::InitializationSegmentInfo::TrackInformation>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.videoTracks)>, Vector<WebKit::InitializationSegmentInfo::TrackInformation>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textTracks)>, Vector<WebKit::InitializationSegmentInfo::TrackInformation>>);
    struct ShouldBeSameSizeAsInitializationSegmentInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::InitializationSegmentInfo>, false> {
        MediaTime duration;
        Vector<WebKit::InitializationSegmentInfo::TrackInformation> audioTracks;
        Vector<WebKit::InitializationSegmentInfo::TrackInformation> videoTracks;
        Vector<WebKit::InitializationSegmentInfo::TrackInformation> textTracks;
    };
    static_assert(sizeof(ShouldBeSameSizeAsInitializationSegmentInfo) == sizeof(WebKit::InitializationSegmentInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::InitializationSegmentInfo, duration)
        , offsetof(WebKit::InitializationSegmentInfo, audioTracks)
        , offsetof(WebKit::InitializationSegmentInfo, videoTracks)
        , offsetof(WebKit::InitializationSegmentInfo, textTracks)
    >::value);
    encoder << instance.duration;
    encoder << instance.audioTracks;
    encoder << instance.videoTracks;
    encoder << instance.textTracks;
}

std::optional<WebKit::InitializationSegmentInfo> ArgumentCoder<WebKit::InitializationSegmentInfo>::decode(Decoder& decoder)
{
    auto duration = decoder.decode<MediaTime>();
    auto audioTracks = decoder.decode<Vector<WebKit::InitializationSegmentInfo::TrackInformation>>();
    auto videoTracks = decoder.decode<Vector<WebKit::InitializationSegmentInfo::TrackInformation>>();
    auto textTracks = decoder.decode<Vector<WebKit::InitializationSegmentInfo::TrackInformation>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::InitializationSegmentInfo {
            WTFMove(*duration),
            WTFMove(*audioTracks),
            WTFMove(*videoTracks),
            WTFMove(*textTracks)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
void ArgumentCoder<WebKit::InitializationSegmentInfo::TrackInformation>::encode(Encoder& encoder, const WebKit::InitializationSegmentInfo::TrackInformation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.description)>, WebKit::MediaDescriptionInfo>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebKit::TrackPrivateRemoteIdentifier>);
    struct ShouldBeSameSizeAsTrackInformation : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::InitializationSegmentInfo::TrackInformation>, false> {
        WebKit::MediaDescriptionInfo description;
        WebKit::TrackPrivateRemoteIdentifier identifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTrackInformation) == sizeof(WebKit::InitializationSegmentInfo::TrackInformation));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::InitializationSegmentInfo::TrackInformation, description)
        , offsetof(WebKit::InitializationSegmentInfo::TrackInformation, identifier)
    >::value);
    encoder << instance.description;
    encoder << instance.identifier;
}

std::optional<WebKit::InitializationSegmentInfo::TrackInformation> ArgumentCoder<WebKit::InitializationSegmentInfo::TrackInformation>::decode(Decoder& decoder)
{
    auto description = decoder.decode<WebKit::MediaDescriptionInfo>();
    auto identifier = decoder.decode<WebKit::TrackPrivateRemoteIdentifier>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::InitializationSegmentInfo::TrackInformation {
            WTFMove(*description),
            WTFMove(*identifier)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(MEDIA_SOURCE)
void ArgumentCoder<WebKit::MediaDescriptionInfo>::encode(Encoder& encoder, const WebKit::MediaDescriptionInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_codec)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isVideo)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isAudio)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isText)>, bool>);
    struct ShouldBeSameSizeAsMediaDescriptionInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::MediaDescriptionInfo>, false> {
        AtomString m_codec;
        bool m_isVideo;
        bool m_isAudio;
        bool m_isText;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaDescriptionInfo) == sizeof(WebKit::MediaDescriptionInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::MediaDescriptionInfo, m_codec)
        , offsetof(WebKit::MediaDescriptionInfo, m_isVideo)
        , offsetof(WebKit::MediaDescriptionInfo, m_isAudio)
        , offsetof(WebKit::MediaDescriptionInfo, m_isText)
    >::value);
    encoder << instance.m_codec;
    encoder << instance.m_isVideo;
    encoder << instance.m_isAudio;
    encoder << instance.m_isText;
}

std::optional<WebKit::MediaDescriptionInfo> ArgumentCoder<WebKit::MediaDescriptionInfo>::decode(Decoder& decoder)
{
    auto m_codec = decoder.decode<AtomString>();
    auto m_isVideo = decoder.decode<bool>();
    auto m_isAudio = decoder.decode<bool>();
    auto m_isText = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::MediaDescriptionInfo {
            WTFMove(*m_codec),
            WTFMove(*m_isVideo),
            WTFMove(*m_isAudio),
            WTFMove(*m_isText)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::RemoteMediaPlayerProxyConfiguration>::encode(Encoder& encoder, const WebKit::RemoteMediaPlayerProxyConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrer)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userAgent)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceApplicationIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkInterfaceName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaContentTypesRequiringHardwareSupport)>, Vector<WebCore::ContentType>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaContainerTypes)>, std::optional<Vector<String>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaCodecTypes)>, std::optional<Vector<String>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaVideoCodecIDs)>, std::optional<Vector<WebCore::FourCC>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaAudioCodecIDs)>, std::optional<Vector<WebCore::FourCC>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaCaptionFormatTypes)>, std::optional<Vector<WebCore::FourCC>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.playerContentBoxRect)>, WebCore::LayoutRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preferredAudioCharacteristics)>, Vector<String>>);
#if ENABLE(AVF_CAPTIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.outOfBandTrackData)>, Vector<WebCore::PlatformTextTrackData>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentSecurityOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.presentationSize)>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.videoInlineSize)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.logIdentifier)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldUsePersistentCache)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isVideo)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.renderingCanBeAccelerated)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prefersSandboxedParsing)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldDisableHDR)>, bool>);
    struct ShouldBeSameSizeAsRemoteMediaPlayerProxyConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::RemoteMediaPlayerProxyConfiguration>, false> {
        String referrer;
        String userAgent;
        String sourceApplicationIdentifier;
        String networkInterfaceName;
        Vector<WebCore::ContentType> mediaContentTypesRequiringHardwareSupport;
        std::optional<Vector<String>> allowedMediaContainerTypes;
        std::optional<Vector<String>> allowedMediaCodecTypes;
        std::optional<Vector<WebCore::FourCC>> allowedMediaVideoCodecIDs;
        std::optional<Vector<WebCore::FourCC>> allowedMediaAudioCodecIDs;
        std::optional<Vector<WebCore::FourCC>> allowedMediaCaptionFormatTypes;
        WebCore::LayoutRect playerContentBoxRect;
        Vector<String> preferredAudioCharacteristics;
#if ENABLE(AVF_CAPTIONS)
        Vector<WebCore::PlatformTextTrackData> outOfBandTrackData;
#endif
        WebCore::SecurityOriginData documentSecurityOrigin;
        WebCore::IntSize presentationSize;
        WebCore::FloatSize videoInlineSize;
        uint64_t logIdentifier;
        bool shouldUsePersistentCache;
        bool isVideo;
        bool renderingCanBeAccelerated;
        bool prefersSandboxedParsing;
        bool shouldDisableHDR;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRemoteMediaPlayerProxyConfiguration) == sizeof(WebKit::RemoteMediaPlayerProxyConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, referrer)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, userAgent)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, sourceApplicationIdentifier)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, networkInterfaceName)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, mediaContentTypesRequiringHardwareSupport)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaContainerTypes)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaCodecTypes)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaVideoCodecIDs)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaAudioCodecIDs)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, allowedMediaCaptionFormatTypes)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, playerContentBoxRect)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, preferredAudioCharacteristics)
#if ENABLE(AVF_CAPTIONS)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, outOfBandTrackData)
#endif
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, documentSecurityOrigin)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, presentationSize)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, videoInlineSize)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, logIdentifier)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, shouldUsePersistentCache)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, isVideo)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, renderingCanBeAccelerated)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, prefersSandboxedParsing)
        , offsetof(WebKit::RemoteMediaPlayerProxyConfiguration, shouldDisableHDR)
    >::value);
    encoder << instance.referrer;
    encoder << instance.userAgent;
    encoder << instance.sourceApplicationIdentifier;
    encoder << instance.networkInterfaceName;
    encoder << instance.mediaContentTypesRequiringHardwareSupport;
    encoder << instance.allowedMediaContainerTypes;
    encoder << instance.allowedMediaCodecTypes;
    encoder << instance.allowedMediaVideoCodecIDs;
    encoder << instance.allowedMediaAudioCodecIDs;
    encoder << instance.allowedMediaCaptionFormatTypes;
    encoder << instance.playerContentBoxRect;
    encoder << instance.preferredAudioCharacteristics;
#if ENABLE(AVF_CAPTIONS)
    encoder << instance.outOfBandTrackData;
#endif
    encoder << instance.documentSecurityOrigin;
    encoder << instance.presentationSize;
    encoder << instance.videoInlineSize;
    encoder << instance.logIdentifier;
    encoder << instance.shouldUsePersistentCache;
    encoder << instance.isVideo;
    encoder << instance.renderingCanBeAccelerated;
    encoder << instance.prefersSandboxedParsing;
    encoder << instance.shouldDisableHDR;
}

std::optional<WebKit::RemoteMediaPlayerProxyConfiguration> ArgumentCoder<WebKit::RemoteMediaPlayerProxyConfiguration>::decode(Decoder& decoder)
{
    auto referrer = decoder.decode<String>();
    auto userAgent = decoder.decode<String>();
    auto sourceApplicationIdentifier = decoder.decode<String>();
    auto networkInterfaceName = decoder.decode<String>();
    auto mediaContentTypesRequiringHardwareSupport = decoder.decode<Vector<WebCore::ContentType>>();
    auto allowedMediaContainerTypes = decoder.decode<std::optional<Vector<String>>>();
    auto allowedMediaCodecTypes = decoder.decode<std::optional<Vector<String>>>();
    auto allowedMediaVideoCodecIDs = decoder.decode<std::optional<Vector<WebCore::FourCC>>>();
    auto allowedMediaAudioCodecIDs = decoder.decode<std::optional<Vector<WebCore::FourCC>>>();
    auto allowedMediaCaptionFormatTypes = decoder.decode<std::optional<Vector<WebCore::FourCC>>>();
    auto playerContentBoxRect = decoder.decode<WebCore::LayoutRect>();
    auto preferredAudioCharacteristics = decoder.decode<Vector<String>>();
#if ENABLE(AVF_CAPTIONS)
    auto outOfBandTrackData = decoder.decode<Vector<WebCore::PlatformTextTrackData>>();
#endif
    auto documentSecurityOrigin = decoder.decode<WebCore::SecurityOriginData>();
    auto presentationSize = decoder.decode<WebCore::IntSize>();
    auto videoInlineSize = decoder.decode<WebCore::FloatSize>();
    auto logIdentifier = decoder.decode<uint64_t>();
    auto shouldUsePersistentCache = decoder.decode<bool>();
    auto isVideo = decoder.decode<bool>();
    auto renderingCanBeAccelerated = decoder.decode<bool>();
    auto prefersSandboxedParsing = decoder.decode<bool>();
    auto shouldDisableHDR = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::RemoteMediaPlayerProxyConfiguration {
            WTFMove(*referrer),
            WTFMove(*userAgent),
            WTFMove(*sourceApplicationIdentifier),
            WTFMove(*networkInterfaceName),
            WTFMove(*mediaContentTypesRequiringHardwareSupport),
            WTFMove(*allowedMediaContainerTypes),
            WTFMove(*allowedMediaCodecTypes),
            WTFMove(*allowedMediaVideoCodecIDs),
            WTFMove(*allowedMediaAudioCodecIDs),
            WTFMove(*allowedMediaCaptionFormatTypes),
            WTFMove(*playerContentBoxRect),
            WTFMove(*preferredAudioCharacteristics),
#if ENABLE(AVF_CAPTIONS)
            WTFMove(*outOfBandTrackData),
#endif
            WTFMove(*documentSecurityOrigin),
            WTFMove(*presentationSize),
            WTFMove(*videoInlineSize),
            WTFMove(*logIdentifier),
            WTFMove(*shouldUsePersistentCache),
            WTFMove(*isVideo),
            WTFMove(*renderingCanBeAccelerated),
            WTFMove(*prefersSandboxedParsing),
            WTFMove(*shouldDisableHDR)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::TextTrackPrivateRemoteConfiguration>::encode(Encoder& encoder, const WebKit::TextTrackPrivateRemoteConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackId)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.inBandMetadataTrackDispatchType)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startTimeVariance)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackIndex)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cueFormat)>, WebCore::InbandTextTrackPrivate::CueFormat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kind)>, WebCore::InbandTextTrackPrivate::Kind>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isClosedCaptions)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSDH)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containsOnlyForcedSubtitles)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMainProgramContent)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isEasyToRead)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isDefault)>, bool>);
    struct ShouldBeSameSizeAsTextTrackPrivateRemoteConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::TextTrackPrivateRemoteConfiguration>, false> {
        AtomString trackId;
        AtomString label;
        AtomString language;
        AtomString inBandMetadataTrackDispatchType;
        MediaTime startTimeVariance;
        int trackIndex;
        WebCore::InbandTextTrackPrivate::CueFormat cueFormat;
        WebCore::InbandTextTrackPrivate::Kind kind;
        bool isClosedCaptions;
        bool isSDH;
        bool containsOnlyForcedSubtitles;
        bool isMainProgramContent;
        bool isEasyToRead;
        bool isDefault;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextTrackPrivateRemoteConfiguration) == sizeof(WebKit::TextTrackPrivateRemoteConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, trackId)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, label)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, language)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, inBandMetadataTrackDispatchType)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, startTimeVariance)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, trackIndex)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, cueFormat)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, kind)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isClosedCaptions)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isSDH)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, containsOnlyForcedSubtitles)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isMainProgramContent)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isEasyToRead)
        , offsetof(WebKit::TextTrackPrivateRemoteConfiguration, isDefault)
    >::value);
    encoder << instance.trackId;
    encoder << instance.label;
    encoder << instance.language;
    encoder << instance.inBandMetadataTrackDispatchType;
    encoder << instance.startTimeVariance;
    encoder << instance.trackIndex;
    encoder << instance.cueFormat;
    encoder << instance.kind;
    encoder << instance.isClosedCaptions;
    encoder << instance.isSDH;
    encoder << instance.containsOnlyForcedSubtitles;
    encoder << instance.isMainProgramContent;
    encoder << instance.isEasyToRead;
    encoder << instance.isDefault;
}

std::optional<WebKit::TextTrackPrivateRemoteConfiguration> ArgumentCoder<WebKit::TextTrackPrivateRemoteConfiguration>::decode(Decoder& decoder)
{
    auto trackId = decoder.decode<AtomString>();
    auto label = decoder.decode<AtomString>();
    auto language = decoder.decode<AtomString>();
    auto inBandMetadataTrackDispatchType = decoder.decode<AtomString>();
    auto startTimeVariance = decoder.decode<MediaTime>();
    auto trackIndex = decoder.decode<int>();
    auto cueFormat = decoder.decode<WebCore::InbandTextTrackPrivate::CueFormat>();
    auto kind = decoder.decode<WebCore::InbandTextTrackPrivate::Kind>();
    auto isClosedCaptions = decoder.decode<bool>();
    auto isSDH = decoder.decode<bool>();
    auto containsOnlyForcedSubtitles = decoder.decode<bool>();
    auto isMainProgramContent = decoder.decode<bool>();
    auto isEasyToRead = decoder.decode<bool>();
    auto isDefault = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::TextTrackPrivateRemoteConfiguration {
            WTFMove(*trackId),
            WTFMove(*label),
            WTFMove(*language),
            WTFMove(*inBandMetadataTrackDispatchType),
            WTFMove(*startTimeVariance),
            WTFMove(*trackIndex),
            WTFMove(*cueFormat),
            WTFMove(*kind),
            WTFMove(*isClosedCaptions),
            WTFMove(*isSDH),
            WTFMove(*containsOnlyForcedSubtitles),
            WTFMove(*isMainProgramContent),
            WTFMove(*isEasyToRead),
            WTFMove(*isDefault)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::TrackPrivateRemoteConfiguration>::encode(Encoder& encoder, const WebKit::TrackPrivateRemoteConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackId)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startTimeVariance)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackIndex)>, int>);
    struct ShouldBeSameSizeAsTrackPrivateRemoteConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::TrackPrivateRemoteConfiguration>, false> {
        AtomString trackId;
        AtomString label;
        AtomString language;
        MediaTime startTimeVariance;
        int trackIndex;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTrackPrivateRemoteConfiguration) == sizeof(WebKit::TrackPrivateRemoteConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackId)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, label)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, language)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, startTimeVariance)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackIndex)
    >::value);
    encoder << instance.trackId;
    encoder << instance.label;
    encoder << instance.language;
    encoder << instance.startTimeVariance;
    encoder << instance.trackIndex;
}

std::optional<WebKit::TrackPrivateRemoteConfiguration> ArgumentCoder<WebKit::TrackPrivateRemoteConfiguration>::decode(Decoder& decoder)
{
    auto trackId = decoder.decode<AtomString>();
    auto label = decoder.decode<AtomString>();
    auto language = decoder.decode<AtomString>();
    auto startTimeVariance = decoder.decode<MediaTime>();
    auto trackIndex = decoder.decode<int>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::TrackPrivateRemoteConfiguration {
            WTFMove(*trackId),
            WTFMove(*label),
            WTFMove(*language),
            WTFMove(*startTimeVariance),
            WTFMove(*trackIndex)
        }
    };
}

#endif

#if ENABLE(GPU_PROCESS) && ENABLE(VIDEO)
void ArgumentCoder<WebKit::VideoTrackPrivateRemoteConfiguration>::encode(Encoder& encoder, const WebKit::VideoTrackPrivateRemoteConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackId)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startTimeVariance)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackIndex)>, int>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackId)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, label)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, language)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, startTimeVariance)
        , offsetof(WebKit::TrackPrivateRemoteConfiguration, trackIndex)
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selected)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kind)>, WebCore::VideoTrackPrivate::Kind>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackConfiguration)>, WebCore::PlatformVideoTrackConfiguration>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::VideoTrackPrivateRemoteConfiguration, selected)
        , offsetof(WebKit::VideoTrackPrivateRemoteConfiguration, kind)
        , offsetof(WebKit::VideoTrackPrivateRemoteConfiguration, trackConfiguration)
    >::value);
    encoder << instance.trackId;
    encoder << instance.label;
    encoder << instance.language;
    encoder << instance.startTimeVariance;
    encoder << instance.trackIndex;
    encoder << instance.selected;
    encoder << instance.kind;
    encoder << instance.trackConfiguration;
}

std::optional<WebKit::VideoTrackPrivateRemoteConfiguration> ArgumentCoder<WebKit::VideoTrackPrivateRemoteConfiguration>::decode(Decoder& decoder)
{
    auto trackId = decoder.decode<AtomString>();
    auto label = decoder.decode<AtomString>();
    auto language = decoder.decode<AtomString>();
    auto startTimeVariance = decoder.decode<MediaTime>();
    auto trackIndex = decoder.decode<int>();
    auto selected = decoder.decode<bool>();
    auto kind = decoder.decode<WebCore::VideoTrackPrivate::Kind>();
    auto trackConfiguration = decoder.decode<WebCore::PlatformVideoTrackConfiguration>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::VideoTrackPrivateRemoteConfiguration {
            WebKit::TrackPrivateRemoteConfiguration {
                WTFMove(*trackId),
                WTFMove(*label),
                WTFMove(*language),
                WTFMove(*startTimeVariance),
                WTFMove(*trackIndex)
            },
            WTFMove(*selected),
            WTFMove(*kind),
            WTFMove(*trackConfiguration)
        }
    };
}

#endif

void ArgumentCoder<WebKit::NetworkProcessCreationParameters>::encode(Encoder& encoder, const WebKit::NetworkProcessCreationParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.auxiliaryProcessParameters)>, WebKit::AuxiliaryProcessCreationParameters>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cacheModel)>, WebKit::CacheModel>);
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uiProcessCookieStorageIdentifier)>, Vector<uint8_t>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldSuppressMemoryPressureHandler)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredForCustomProtocols)>, Vector<String>>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uiProcessBundleIdentifier)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkATSContext)>, RetainPtr<CFDataRef>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.strictSecureDecodingForAllObjCEnabled)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isParentProcessFullWebBrowserOrRunningTest)>, bool>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cookieAcceptPolicy)>, WebCore::HTTPCookieAcceptPolicy>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.languages)>, Vector<String>>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.memoryPressureHandlerConfiguration)>, std::optional<MemoryPressureHandler::Configuration>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredAsSecure)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredAsBypassingContentSecurityPolicy)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredAsLocal)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlSchemesRegisteredAsNoAccess)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enablePrivateClickMeasurement)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ftpEnabled)>, bool>);
#if ENABLE(BUILT_IN_NOTIFICATIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.builtInNotificationsEnabled)>, bool>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.websiteDataStoreParameters)>, Vector<WebKit::WebsiteDataStoreParameters>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedFirstPartiesForCookies)>, Vector<std::pair<WebCore::ProcessIdentifier, WebCore::RegistrableDomain>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.localhostAliasesForTesting)>, HashSet<String>>);
    struct ShouldBeSameSizeAsNetworkProcessCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NetworkProcessCreationParameters>, false> {
        WebKit::AuxiliaryProcessCreationParameters auxiliaryProcessParameters;
        WebKit::CacheModel cacheModel;
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
        Vector<uint8_t> uiProcessCookieStorageIdentifier;
#endif
        bool shouldSuppressMemoryPressureHandler;
        Vector<String> urlSchemesRegisteredForCustomProtocols;
#if PLATFORM(COCOA)
        String uiProcessBundleIdentifier;
#endif
#if PLATFORM(COCOA)
        RetainPtr<CFDataRef> networkATSContext;
#endif
#if PLATFORM(COCOA)
        bool strictSecureDecodingForAllObjCEnabled;
#endif
#if PLATFORM(COCOA)
        bool isParentProcessFullWebBrowserOrRunningTest;
#endif
#if USE(SOUP)
        WebCore::HTTPCookieAcceptPolicy cookieAcceptPolicy;
#endif
#if USE(SOUP)
        Vector<String> languages;
#endif
#if USE(SOUP)
        std::optional<MemoryPressureHandler::Configuration> memoryPressureHandlerConfiguration;
#endif
        Vector<String> urlSchemesRegisteredAsSecure;
        Vector<String> urlSchemesRegisteredAsBypassingContentSecurityPolicy;
        Vector<String> urlSchemesRegisteredAsLocal;
        Vector<String> urlSchemesRegisteredAsNoAccess;
        bool enablePrivateClickMeasurement;
        bool ftpEnabled;
#if ENABLE(BUILT_IN_NOTIFICATIONS)
        bool builtInNotificationsEnabled;
#endif
        Vector<WebKit::WebsiteDataStoreParameters> websiteDataStoreParameters;
        Vector<std::pair<WebCore::ProcessIdentifier, WebCore::RegistrableDomain>> allowedFirstPartiesForCookies;
        HashSet<String> localhostAliasesForTesting;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNetworkProcessCreationParameters) == sizeof(WebKit::NetworkProcessCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NetworkProcessCreationParameters, auxiliaryProcessParameters)
        , offsetof(WebKit::NetworkProcessCreationParameters, cacheModel)
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
        , offsetof(WebKit::NetworkProcessCreationParameters, uiProcessCookieStorageIdentifier)
#endif
        , offsetof(WebKit::NetworkProcessCreationParameters, shouldSuppressMemoryPressureHandler)
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredForCustomProtocols)
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkProcessCreationParameters, uiProcessBundleIdentifier)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkProcessCreationParameters, networkATSContext)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkProcessCreationParameters, strictSecureDecodingForAllObjCEnabled)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::NetworkProcessCreationParameters, isParentProcessFullWebBrowserOrRunningTest)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkProcessCreationParameters, cookieAcceptPolicy)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkProcessCreationParameters, languages)
#endif
#if USE(SOUP)
        , offsetof(WebKit::NetworkProcessCreationParameters, memoryPressureHandlerConfiguration)
#endif
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredAsSecure)
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredAsBypassingContentSecurityPolicy)
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredAsLocal)
        , offsetof(WebKit::NetworkProcessCreationParameters, urlSchemesRegisteredAsNoAccess)
        , offsetof(WebKit::NetworkProcessCreationParameters, enablePrivateClickMeasurement)
        , offsetof(WebKit::NetworkProcessCreationParameters, ftpEnabled)
#if ENABLE(BUILT_IN_NOTIFICATIONS)
        , offsetof(WebKit::NetworkProcessCreationParameters, builtInNotificationsEnabled)
#endif
        , offsetof(WebKit::NetworkProcessCreationParameters, websiteDataStoreParameters)
        , offsetof(WebKit::NetworkProcessCreationParameters, allowedFirstPartiesForCookies)
        , offsetof(WebKit::NetworkProcessCreationParameters, localhostAliasesForTesting)
    >::value);
    encoder << instance.auxiliaryProcessParameters;
    encoder << instance.cacheModel;
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    encoder << instance.uiProcessCookieStorageIdentifier;
#endif
    encoder << instance.shouldSuppressMemoryPressureHandler;
    encoder << instance.urlSchemesRegisteredForCustomProtocols;
#if PLATFORM(COCOA)
    encoder << instance.uiProcessBundleIdentifier;
#endif
#if PLATFORM(COCOA)
    encoder << instance.networkATSContext;
#endif
#if PLATFORM(COCOA)
    encoder << instance.strictSecureDecodingForAllObjCEnabled;
#endif
#if PLATFORM(COCOA)
    encoder << instance.isParentProcessFullWebBrowserOrRunningTest;
#endif
#if USE(SOUP)
    encoder << instance.cookieAcceptPolicy;
#endif
#if USE(SOUP)
    encoder << instance.languages;
#endif
#if USE(SOUP)
    encoder << instance.memoryPressureHandlerConfiguration;
#endif
    encoder << instance.urlSchemesRegisteredAsSecure;
    encoder << instance.urlSchemesRegisteredAsBypassingContentSecurityPolicy;
    encoder << instance.urlSchemesRegisteredAsLocal;
    encoder << instance.urlSchemesRegisteredAsNoAccess;
    encoder << instance.enablePrivateClickMeasurement;
    encoder << instance.ftpEnabled;
#if ENABLE(BUILT_IN_NOTIFICATIONS)
    encoder << instance.builtInNotificationsEnabled;
#endif
    encoder << instance.websiteDataStoreParameters;
    encoder << instance.allowedFirstPartiesForCookies;
    encoder << instance.localhostAliasesForTesting;
}

std::optional<WebKit::NetworkProcessCreationParameters> ArgumentCoder<WebKit::NetworkProcessCreationParameters>::decode(Decoder& decoder)
{
    auto auxiliaryProcessParameters = decoder.decode<WebKit::AuxiliaryProcessCreationParameters>();
    auto cacheModel = decoder.decode<WebKit::CacheModel>();
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    auto uiProcessCookieStorageIdentifier = decoder.decode<Vector<uint8_t>>();
#endif
    auto shouldSuppressMemoryPressureHandler = decoder.decode<bool>();
    auto urlSchemesRegisteredForCustomProtocols = decoder.decode<Vector<String>>();
#if PLATFORM(COCOA)
    auto uiProcessBundleIdentifier = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto networkATSContext = decoder.decode<RetainPtr<CFDataRef>>();
#endif
#if PLATFORM(COCOA)
    auto strictSecureDecodingForAllObjCEnabled = decoder.decode<bool>();
#endif
#if PLATFORM(COCOA)
    auto isParentProcessFullWebBrowserOrRunningTest = decoder.decode<bool>();
#endif
#if USE(SOUP)
    auto cookieAcceptPolicy = decoder.decode<WebCore::HTTPCookieAcceptPolicy>();
#endif
#if USE(SOUP)
    auto languages = decoder.decode<Vector<String>>();
#endif
#if USE(SOUP)
    auto memoryPressureHandlerConfiguration = decoder.decode<std::optional<MemoryPressureHandler::Configuration>>();
#endif
    auto urlSchemesRegisteredAsSecure = decoder.decode<Vector<String>>();
    auto urlSchemesRegisteredAsBypassingContentSecurityPolicy = decoder.decode<Vector<String>>();
    auto urlSchemesRegisteredAsLocal = decoder.decode<Vector<String>>();
    auto urlSchemesRegisteredAsNoAccess = decoder.decode<Vector<String>>();
    auto enablePrivateClickMeasurement = decoder.decode<bool>();
    auto ftpEnabled = decoder.decode<bool>();
#if ENABLE(BUILT_IN_NOTIFICATIONS)
    auto builtInNotificationsEnabled = decoder.decode<bool>();
#endif
    auto websiteDataStoreParameters = decoder.decode<Vector<WebKit::WebsiteDataStoreParameters>>();
    auto allowedFirstPartiesForCookies = decoder.decode<Vector<std::pair<WebCore::ProcessIdentifier, WebCore::RegistrableDomain>>>();
    auto localhostAliasesForTesting = decoder.decode<HashSet<String>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::NetworkProcessCreationParameters {
            WTFMove(*auxiliaryProcessParameters),
            WTFMove(*cacheModel),
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
            WTFMove(*uiProcessCookieStorageIdentifier),
#endif
            WTFMove(*shouldSuppressMemoryPressureHandler),
            WTFMove(*urlSchemesRegisteredForCustomProtocols),
#if PLATFORM(COCOA)
            WTFMove(*uiProcessBundleIdentifier),
#endif
#if PLATFORM(COCOA)
            WTFMove(*networkATSContext),
#endif
#if PLATFORM(COCOA)
            WTFMove(*strictSecureDecodingForAllObjCEnabled),
#endif
#if PLATFORM(COCOA)
            WTFMove(*isParentProcessFullWebBrowserOrRunningTest),
#endif
#if USE(SOUP)
            WTFMove(*cookieAcceptPolicy),
#endif
#if USE(SOUP)
            WTFMove(*languages),
#endif
#if USE(SOUP)
            WTFMove(*memoryPressureHandlerConfiguration),
#endif
            WTFMove(*urlSchemesRegisteredAsSecure),
            WTFMove(*urlSchemesRegisteredAsBypassingContentSecurityPolicy),
            WTFMove(*urlSchemesRegisteredAsLocal),
            WTFMove(*urlSchemesRegisteredAsNoAccess),
            WTFMove(*enablePrivateClickMeasurement),
            WTFMove(*ftpEnabled),
#if ENABLE(BUILT_IN_NOTIFICATIONS)
            WTFMove(*builtInNotificationsEnabled),
#endif
            WTFMove(*websiteDataStoreParameters),
            WTFMove(*allowedFirstPartiesForCookies),
            WTFMove(*localhostAliasesForTesting)
        }
    };
}

void ArgumentCoder<WebKit::NetworkLoadParameters>::encode(Encoder& encoder, const WebKit::NetworkLoadParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPageProxyID)>, WebKit::WebPageProxyIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPageID)>, WebCore::PageIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webFrameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topOrigin)>, RefPtr<WebCore::SecurityOrigin>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceOrigin)>, RefPtr<WebCore::SecurityOrigin>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentPID)>, WTF::ProcessID>);
#if HAVE(AUDIT_TOKEN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkProcessAuditToken)>, std::optional<audit_token_t>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentSniffingPolicy)>, WebCore::ContentSniffingPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentEncodingSniffingPolicy)>, WebCore::ContentEncodingSniffingPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.storedCredentialsPolicy)>, WebCore::StoredCredentialsPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientCredentialPolicy)>, WebCore::ClientCredentialPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldClearReferrerOnHTTPSToHTTPRedirect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.needsCertificateInfo)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMainFrameNavigation)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMainResourceNavigationForAnyFrame)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldRelaxThirdPartyCookieBlocking)>, WebCore::ShouldRelaxThirdPartyCookieBlocking>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blobFileReferences)>, Vector<RefPtr<WebCore::BlobDataFileReference>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldPreconnectOnly)>, WebKit::PreconnectOnly>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkActivityTracker)>, std::optional<WebKit::NetworkActivityTracker>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isNavigatingToAppBoundDomain)>, std::optional<WebKit::NavigatingToAppBoundDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hadMainFrameMainResourcePrivateRelayed)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowPrivacyProxy)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.advancedPrivacyProtections)>, OptionSet<WebCore::AdvancedPrivacyProtections>>);
    struct ShouldBeSameSizeAsNetworkLoadParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NetworkLoadParameters>, false> {
        WebKit::WebPageProxyIdentifier webPageProxyID;
        WebCore::PageIdentifier webPageID;
        WebCore::FrameIdentifier webFrameID;
        RefPtr<WebCore::SecurityOrigin> topOrigin;
        RefPtr<WebCore::SecurityOrigin> sourceOrigin;
        WTF::ProcessID parentPID;
#if HAVE(AUDIT_TOKEN)
        std::optional<audit_token_t> networkProcessAuditToken;
#endif
        WebCore::ResourceRequest request;
        WebCore::ContentSniffingPolicy contentSniffingPolicy;
        WebCore::ContentEncodingSniffingPolicy contentEncodingSniffingPolicy;
        WebCore::StoredCredentialsPolicy storedCredentialsPolicy;
        WebCore::ClientCredentialPolicy clientCredentialPolicy;
        bool shouldClearReferrerOnHTTPSToHTTPRedirect;
        bool needsCertificateInfo;
        bool isMainFrameNavigation;
        bool isMainResourceNavigationForAnyFrame;
        WebCore::ShouldRelaxThirdPartyCookieBlocking shouldRelaxThirdPartyCookieBlocking;
        Vector<RefPtr<WebCore::BlobDataFileReference>> blobFileReferences;
        WebKit::PreconnectOnly shouldPreconnectOnly;
        std::optional<WebKit::NetworkActivityTracker> networkActivityTracker;
        std::optional<WebKit::NavigatingToAppBoundDomain> isNavigatingToAppBoundDomain;
        bool hadMainFrameMainResourcePrivateRelayed;
        bool allowPrivacyProxy;
        OptionSet<WebCore::AdvancedPrivacyProtections> advancedPrivacyProtections;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNetworkLoadParameters) == sizeof(WebKit::NetworkLoadParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NetworkLoadParameters, webPageProxyID)
        , offsetof(WebKit::NetworkLoadParameters, webPageID)
        , offsetof(WebKit::NetworkLoadParameters, webFrameID)
        , offsetof(WebKit::NetworkLoadParameters, topOrigin)
        , offsetof(WebKit::NetworkLoadParameters, sourceOrigin)
        , offsetof(WebKit::NetworkLoadParameters, parentPID)
#if HAVE(AUDIT_TOKEN)
        , offsetof(WebKit::NetworkLoadParameters, networkProcessAuditToken)
#endif
        , offsetof(WebKit::NetworkLoadParameters, request)
        , offsetof(WebKit::NetworkLoadParameters, contentSniffingPolicy)
        , offsetof(WebKit::NetworkLoadParameters, contentEncodingSniffingPolicy)
        , offsetof(WebKit::NetworkLoadParameters, storedCredentialsPolicy)
        , offsetof(WebKit::NetworkLoadParameters, clientCredentialPolicy)
        , offsetof(WebKit::NetworkLoadParameters, shouldClearReferrerOnHTTPSToHTTPRedirect)
        , offsetof(WebKit::NetworkLoadParameters, needsCertificateInfo)
        , offsetof(WebKit::NetworkLoadParameters, isMainFrameNavigation)
        , offsetof(WebKit::NetworkLoadParameters, isMainResourceNavigationForAnyFrame)
        , offsetof(WebKit::NetworkLoadParameters, shouldRelaxThirdPartyCookieBlocking)
        , offsetof(WebKit::NetworkLoadParameters, blobFileReferences)
        , offsetof(WebKit::NetworkLoadParameters, shouldPreconnectOnly)
        , offsetof(WebKit::NetworkLoadParameters, networkActivityTracker)
        , offsetof(WebKit::NetworkLoadParameters, isNavigatingToAppBoundDomain)
        , offsetof(WebKit::NetworkLoadParameters, hadMainFrameMainResourcePrivateRelayed)
        , offsetof(WebKit::NetworkLoadParameters, allowPrivacyProxy)
        , offsetof(WebKit::NetworkLoadParameters, advancedPrivacyProtections)
    >::value);
    encoder << instance.webPageProxyID;
    encoder << instance.webPageID;
    encoder << instance.webFrameID;
    encoder << instance.topOrigin;
    encoder << instance.sourceOrigin;
    encoder << instance.parentPID;
    encoder << instance.request;
    encoder << instance.contentSniffingPolicy;
    encoder << instance.contentEncodingSniffingPolicy;
    encoder << instance.storedCredentialsPolicy;
    encoder << instance.clientCredentialPolicy;
    encoder << instance.shouldClearReferrerOnHTTPSToHTTPRedirect;
    encoder << instance.needsCertificateInfo;
    encoder << instance.isMainFrameNavigation;
    encoder << instance.isMainResourceNavigationForAnyFrame;
    encoder << instance.shouldRelaxThirdPartyCookieBlocking;
    encoder << instance.shouldPreconnectOnly;
    encoder << instance.isNavigatingToAppBoundDomain;
    encoder << instance.hadMainFrameMainResourcePrivateRelayed;
    encoder << instance.allowPrivacyProxy;
    encoder << instance.advancedPrivacyProtections;
}

std::optional<WebKit::NetworkLoadParameters> ArgumentCoder<WebKit::NetworkLoadParameters>::decode(Decoder& decoder)
{
    auto webPageProxyID = decoder.decode<WebKit::WebPageProxyIdentifier>();
    auto webPageID = decoder.decode<WebCore::PageIdentifier>();
    auto webFrameID = decoder.decode<WebCore::FrameIdentifier>();
    auto topOrigin = decoder.decode<RefPtr<WebCore::SecurityOrigin>>();
    auto sourceOrigin = decoder.decode<RefPtr<WebCore::SecurityOrigin>>();
    auto parentPID = decoder.decode<WTF::ProcessID>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    auto contentSniffingPolicy = decoder.decode<WebCore::ContentSniffingPolicy>();
    auto contentEncodingSniffingPolicy = decoder.decode<WebCore::ContentEncodingSniffingPolicy>();
    auto storedCredentialsPolicy = decoder.decode<WebCore::StoredCredentialsPolicy>();
    auto clientCredentialPolicy = decoder.decode<WebCore::ClientCredentialPolicy>();
    auto shouldClearReferrerOnHTTPSToHTTPRedirect = decoder.decode<bool>();
    auto needsCertificateInfo = decoder.decode<bool>();
    auto isMainFrameNavigation = decoder.decode<bool>();
    auto isMainResourceNavigationForAnyFrame = decoder.decode<bool>();
    auto shouldRelaxThirdPartyCookieBlocking = decoder.decode<WebCore::ShouldRelaxThirdPartyCookieBlocking>();
    auto shouldPreconnectOnly = decoder.decode<WebKit::PreconnectOnly>();
    auto isNavigatingToAppBoundDomain = decoder.decode<std::optional<WebKit::NavigatingToAppBoundDomain>>();
    auto hadMainFrameMainResourcePrivateRelayed = decoder.decode<bool>();
    auto allowPrivacyProxy = decoder.decode<bool>();
    auto advancedPrivacyProtections = decoder.decode<OptionSet<WebCore::AdvancedPrivacyProtections>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::NetworkLoadParameters {
            WTFMove(*webPageProxyID),
            WTFMove(*webPageID),
            WTFMove(*webFrameID),
            WTFMove(*topOrigin),
            WTFMove(*sourceOrigin),
            WTFMove(*parentPID),
            WTFMove(*request),
            WTFMove(*contentSniffingPolicy),
            WTFMove(*contentEncodingSniffingPolicy),
            WTFMove(*storedCredentialsPolicy),
            WTFMove(*clientCredentialPolicy),
            WTFMove(*shouldClearReferrerOnHTTPSToHTTPRedirect),
            WTFMove(*needsCertificateInfo),
            WTFMove(*isMainFrameNavigation),
            WTFMove(*isMainResourceNavigationForAnyFrame),
            WTFMove(*shouldRelaxThirdPartyCookieBlocking),
            WTFMove(*shouldPreconnectOnly),
            WTFMove(*isNavigatingToAppBoundDomain),
            WTFMove(*hadMainFrameMainResourcePrivateRelayed),
            WTFMove(*allowPrivacyProxy),
            WTFMove(*advancedPrivacyProtections)
        }
    };
}

void ArgumentCoder<WebKit::NetworkResourceLoadParameters>::encode(Encoder& encoder, const WebKit::NetworkResourceLoadParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPageProxyID)>, WebKit::WebPageProxyIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPageID)>, WebCore::PageIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webFrameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topOrigin)>, RefPtr<WebCore::SecurityOrigin>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceOrigin)>, RefPtr<WebCore::SecurityOrigin>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentPID)>, WTF::ProcessID>);
#if HAVE(AUDIT_TOKEN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkProcessAuditToken)>, std::optional<audit_token_t>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentSniffingPolicy)>, WebCore::ContentSniffingPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentEncodingSniffingPolicy)>, WebCore::ContentEncodingSniffingPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.storedCredentialsPolicy)>, WebCore::StoredCredentialsPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientCredentialPolicy)>, WebCore::ClientCredentialPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldClearReferrerOnHTTPSToHTTPRedirect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.needsCertificateInfo)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMainFrameNavigation)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMainResourceNavigationForAnyFrame)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldRelaxThirdPartyCookieBlocking)>, WebCore::ShouldRelaxThirdPartyCookieBlocking>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blobFileReferences)>, Vector<RefPtr<WebCore::BlobDataFileReference>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldPreconnectOnly)>, WebKit::PreconnectOnly>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkActivityTracker)>, std::optional<WebKit::NetworkActivityTracker>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isNavigatingToAppBoundDomain)>, std::optional<WebKit::NavigatingToAppBoundDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hadMainFrameMainResourcePrivateRelayed)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowPrivacyProxy)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.advancedPrivacyProtections)>, OptionSet<WebCore::AdvancedPrivacyProtections>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NetworkLoadParameters, webPageProxyID)
        , offsetof(WebKit::NetworkLoadParameters, webPageID)
        , offsetof(WebKit::NetworkLoadParameters, webFrameID)
        , offsetof(WebKit::NetworkLoadParameters, topOrigin)
        , offsetof(WebKit::NetworkLoadParameters, sourceOrigin)
        , offsetof(WebKit::NetworkLoadParameters, parentPID)
#if HAVE(AUDIT_TOKEN)
        , offsetof(WebKit::NetworkLoadParameters, networkProcessAuditToken)
#endif
        , offsetof(WebKit::NetworkLoadParameters, request)
        , offsetof(WebKit::NetworkLoadParameters, contentSniffingPolicy)
        , offsetof(WebKit::NetworkLoadParameters, contentEncodingSniffingPolicy)
        , offsetof(WebKit::NetworkLoadParameters, storedCredentialsPolicy)
        , offsetof(WebKit::NetworkLoadParameters, clientCredentialPolicy)
        , offsetof(WebKit::NetworkLoadParameters, shouldClearReferrerOnHTTPSToHTTPRedirect)
        , offsetof(WebKit::NetworkLoadParameters, needsCertificateInfo)
        , offsetof(WebKit::NetworkLoadParameters, isMainFrameNavigation)
        , offsetof(WebKit::NetworkLoadParameters, isMainResourceNavigationForAnyFrame)
        , offsetof(WebKit::NetworkLoadParameters, shouldRelaxThirdPartyCookieBlocking)
        , offsetof(WebKit::NetworkLoadParameters, blobFileReferences)
        , offsetof(WebKit::NetworkLoadParameters, shouldPreconnectOnly)
        , offsetof(WebKit::NetworkLoadParameters, networkActivityTracker)
        , offsetof(WebKit::NetworkLoadParameters, isNavigatingToAppBoundDomain)
        , offsetof(WebKit::NetworkLoadParameters, hadMainFrameMainResourcePrivateRelayed)
        , offsetof(WebKit::NetworkLoadParameters, allowPrivacyProxy)
        , offsetof(WebKit::NetworkLoadParameters, advancedPrivacyProtections)
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::ResourceLoaderIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request.httpBody())>, RefPtr<WebCore::FormData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sandboxExtensionsIfHttpBody())>, std::optional<Vector<WebKit::SandboxExtension::Handle>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sandboxExtensionIflocalFile())>, std::optional<WebKit::SandboxExtension::Handle>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximumBufferingTime)>, Seconds>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, WebCore::FetchOptions>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cspResponseHeaders)>, std::optional<WebCore::ContentSecurityPolicyResponseHeaders>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentFrameURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentCrossOriginEmbedderPolicy)>, WebCore::CrossOriginEmbedderPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.crossOriginEmbedderPolicy)>, WebCore::CrossOriginEmbedderPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originalRequestHeaders)>, WebCore::HTTPHeaderMap>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldRestrictHTTPResponseAccess)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preflightPolicy)>, WebCore::PreflightPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldEnableCrossOriginResourcePolicy)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameAncestorOrigins)>, Vector<RefPtr<WebCore::SecurityOrigin>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageHasResourceLoadClient)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentFrameID)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.crossOriginAccessControlCheckEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isCrossOriginOpenerPolicyEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isClearSiteDataHeaderEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isDisplayingInitialEmptyDocument)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.effectiveSandboxFlags)>, WebCore::SandboxFlags>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.openerURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceCrossOriginOpenerPolicy)>, WebCore::CrossOriginOpenerPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationID)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationRequester)>, std::optional<WebCore::NavigationRequester>>);
#if ENABLE(SERVICE_WORKER)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serviceWorkersMode)>, WebCore::ServiceWorkersMode>);
#endif
#if ENABLE(SERVICE_WORKER)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serviceWorkerRegistrationIdentifier)>, std::optional<WebCore::ServiceWorkerRegistrationIdentifier>>);
#endif
#if ENABLE(SERVICE_WORKER)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpHeadersToKeep)>, OptionSet<WebCore::HTTPHeadersToKeepFromCleaning>>);
#endif
#if ENABLE(SERVICE_WORKER)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationPreloadIdentifier)>, std::optional<WebCore::FetchIdentifier>>);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mainDocumentURL)>, URL>);
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userContentControllerIdentifier)>, std::optional<WebKit::UserContentControllerIdentifier>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.linkPreconnectEarlyHintsEnabled)>, bool>);
    encoder << instance.webPageProxyID;
    encoder << instance.webPageID;
    encoder << instance.webFrameID;
    encoder << instance.topOrigin;
    encoder << instance.sourceOrigin;
    encoder << instance.parentPID;
    encoder << instance.request;
    encoder << instance.contentSniffingPolicy;
    encoder << instance.contentEncodingSniffingPolicy;
    encoder << instance.storedCredentialsPolicy;
    encoder << instance.clientCredentialPolicy;
    encoder << instance.shouldClearReferrerOnHTTPSToHTTPRedirect;
    encoder << instance.needsCertificateInfo;
    encoder << instance.isMainFrameNavigation;
    encoder << instance.isMainResourceNavigationForAnyFrame;
    encoder << instance.shouldRelaxThirdPartyCookieBlocking;
    encoder << instance.shouldPreconnectOnly;
    encoder << instance.isNavigatingToAppBoundDomain;
    encoder << instance.hadMainFrameMainResourcePrivateRelayed;
    encoder << instance.allowPrivacyProxy;
    encoder << instance.advancedPrivacyProtections;
    encoder << instance.identifier;
    encoder << instance.request.httpBody();
    encoder << instance.sandboxExtensionsIfHttpBody();
    encoder << instance.sandboxExtensionIflocalFile();
    encoder << instance.maximumBufferingTime;
    encoder << instance.options;
    encoder << instance.cspResponseHeaders;
    encoder << instance.parentFrameURL;
    encoder << instance.frameURL;
    encoder << instance.parentCrossOriginEmbedderPolicy;
    encoder << instance.crossOriginEmbedderPolicy;
    encoder << instance.originalRequestHeaders;
    encoder << instance.shouldRestrictHTTPResponseAccess;
    encoder << instance.preflightPolicy;
    encoder << instance.shouldEnableCrossOriginResourcePolicy;
    encoder << instance.frameAncestorOrigins;
    encoder << instance.pageHasResourceLoadClient;
    encoder << instance.parentFrameID;
    encoder << instance.crossOriginAccessControlCheckEnabled;
    encoder << instance.documentURL;
    encoder << instance.isCrossOriginOpenerPolicyEnabled;
    encoder << instance.isClearSiteDataHeaderEnabled;
    encoder << instance.isDisplayingInitialEmptyDocument;
    encoder << instance.effectiveSandboxFlags;
    encoder << instance.openerURL;
    encoder << instance.sourceCrossOriginOpenerPolicy;
    encoder << instance.navigationID;
    encoder << instance.navigationRequester;
#if ENABLE(SERVICE_WORKER)
    encoder << instance.serviceWorkersMode;
#endif
#if ENABLE(SERVICE_WORKER)
    encoder << instance.serviceWorkerRegistrationIdentifier;
#endif
#if ENABLE(SERVICE_WORKER)
    encoder << instance.httpHeadersToKeep;
#endif
#if ENABLE(SERVICE_WORKER)
    encoder << instance.navigationPreloadIdentifier;
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    encoder << instance.mainDocumentURL;
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    encoder << instance.userContentControllerIdentifier;
#endif
    encoder << instance.linkPreconnectEarlyHintsEnabled;
}

std::optional<WebKit::NetworkResourceLoadParameters> ArgumentCoder<WebKit::NetworkResourceLoadParameters>::decode(Decoder& decoder)
{
    auto webPageProxyID = decoder.decode<WebKit::WebPageProxyIdentifier>();
    auto webPageID = decoder.decode<WebCore::PageIdentifier>();
    auto webFrameID = decoder.decode<WebCore::FrameIdentifier>();
    auto topOrigin = decoder.decode<RefPtr<WebCore::SecurityOrigin>>();
    auto sourceOrigin = decoder.decode<RefPtr<WebCore::SecurityOrigin>>();
    auto parentPID = decoder.decode<WTF::ProcessID>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    auto contentSniffingPolicy = decoder.decode<WebCore::ContentSniffingPolicy>();
    auto contentEncodingSniffingPolicy = decoder.decode<WebCore::ContentEncodingSniffingPolicy>();
    auto storedCredentialsPolicy = decoder.decode<WebCore::StoredCredentialsPolicy>();
    auto clientCredentialPolicy = decoder.decode<WebCore::ClientCredentialPolicy>();
    auto shouldClearReferrerOnHTTPSToHTTPRedirect = decoder.decode<bool>();
    auto needsCertificateInfo = decoder.decode<bool>();
    auto isMainFrameNavigation = decoder.decode<bool>();
    auto isMainResourceNavigationForAnyFrame = decoder.decode<bool>();
    auto shouldRelaxThirdPartyCookieBlocking = decoder.decode<WebCore::ShouldRelaxThirdPartyCookieBlocking>();
    auto shouldPreconnectOnly = decoder.decode<WebKit::PreconnectOnly>();
    auto isNavigatingToAppBoundDomain = decoder.decode<std::optional<WebKit::NavigatingToAppBoundDomain>>();
    auto hadMainFrameMainResourcePrivateRelayed = decoder.decode<bool>();
    auto allowPrivacyProxy = decoder.decode<bool>();
    auto advancedPrivacyProtections = decoder.decode<OptionSet<WebCore::AdvancedPrivacyProtections>>();
    auto identifier = decoder.decode<WebCore::ResourceLoaderIdentifier>();
    auto requesthttpBody = decoder.decode<RefPtr<WebCore::FormData>>();
    auto sandboxExtensionsIfHttpBody = decoder.decode<std::optional<Vector<WebKit::SandboxExtension::Handle>>>();
    auto sandboxExtensionIflocalFile = decoder.decode<std::optional<WebKit::SandboxExtension::Handle>>();
    auto maximumBufferingTime = decoder.decode<Seconds>();
    auto options = decoder.decode<WebCore::FetchOptions>();
    auto cspResponseHeaders = decoder.decode<std::optional<WebCore::ContentSecurityPolicyResponseHeaders>>();
    auto parentFrameURL = decoder.decode<URL>();
    auto frameURL = decoder.decode<URL>();
    auto parentCrossOriginEmbedderPolicy = decoder.decode<WebCore::CrossOriginEmbedderPolicy>();
    auto crossOriginEmbedderPolicy = decoder.decode<WebCore::CrossOriginEmbedderPolicy>();
    auto originalRequestHeaders = decoder.decode<WebCore::HTTPHeaderMap>();
    auto shouldRestrictHTTPResponseAccess = decoder.decode<bool>();
    auto preflightPolicy = decoder.decode<WebCore::PreflightPolicy>();
    auto shouldEnableCrossOriginResourcePolicy = decoder.decode<bool>();
    auto frameAncestorOrigins = decoder.decode<Vector<RefPtr<WebCore::SecurityOrigin>>>();
    auto pageHasResourceLoadClient = decoder.decode<bool>();
    auto parentFrameID = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto crossOriginAccessControlCheckEnabled = decoder.decode<bool>();
    auto documentURL = decoder.decode<URL>();
    auto isCrossOriginOpenerPolicyEnabled = decoder.decode<bool>();
    auto isClearSiteDataHeaderEnabled = decoder.decode<bool>();
    auto isDisplayingInitialEmptyDocument = decoder.decode<bool>();
    auto effectiveSandboxFlags = decoder.decode<WebCore::SandboxFlags>();
    auto openerURL = decoder.decode<URL>();
    auto sourceCrossOriginOpenerPolicy = decoder.decode<WebCore::CrossOriginOpenerPolicy>();
    auto navigationID = decoder.decode<uint64_t>();
    auto navigationRequester = decoder.decode<std::optional<WebCore::NavigationRequester>>();
#if ENABLE(SERVICE_WORKER)
    auto serviceWorkersMode = decoder.decode<WebCore::ServiceWorkersMode>();
#endif
#if ENABLE(SERVICE_WORKER)
    auto serviceWorkerRegistrationIdentifier = decoder.decode<std::optional<WebCore::ServiceWorkerRegistrationIdentifier>>();
#endif
#if ENABLE(SERVICE_WORKER)
    auto httpHeadersToKeep = decoder.decode<OptionSet<WebCore::HTTPHeadersToKeepFromCleaning>>();
#endif
#if ENABLE(SERVICE_WORKER)
    auto navigationPreloadIdentifier = decoder.decode<std::optional<WebCore::FetchIdentifier>>();
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    auto mainDocumentURL = decoder.decode<URL>();
#endif
#if ENABLE(CONTENT_EXTENSIONS)
    auto userContentControllerIdentifier = decoder.decode<std::optional<WebKit::UserContentControllerIdentifier>>();
#endif
    auto linkPreconnectEarlyHintsEnabled = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::NetworkResourceLoadParameters {
            WebKit::NetworkLoadParameters {
                WTFMove(*webPageProxyID),
                WTFMove(*webPageID),
                WTFMove(*webFrameID),
                WTFMove(*topOrigin),
                WTFMove(*sourceOrigin),
                WTFMove(*parentPID),
                WTFMove(*request),
                WTFMove(*contentSniffingPolicy),
                WTFMove(*contentEncodingSniffingPolicy),
                WTFMove(*storedCredentialsPolicy),
                WTFMove(*clientCredentialPolicy),
                WTFMove(*shouldClearReferrerOnHTTPSToHTTPRedirect),
                WTFMove(*needsCertificateInfo),
                WTFMove(*isMainFrameNavigation),
                WTFMove(*isMainResourceNavigationForAnyFrame),
                WTFMove(*shouldRelaxThirdPartyCookieBlocking),
                WTFMove(*shouldPreconnectOnly),
                WTFMove(*isNavigatingToAppBoundDomain),
                WTFMove(*hadMainFrameMainResourcePrivateRelayed),
                WTFMove(*allowPrivacyProxy),
                WTFMove(*advancedPrivacyProtections)
            },
            WTFMove(*identifier),
            WTFMove(*requesthttpBody),
            WTFMove(*sandboxExtensionsIfHttpBody),
            WTFMove(*sandboxExtensionIflocalFile),
            WTFMove(*maximumBufferingTime),
            WTFMove(*options),
            WTFMove(*cspResponseHeaders),
            WTFMove(*parentFrameURL),
            WTFMove(*frameURL),
            WTFMove(*parentCrossOriginEmbedderPolicy),
            WTFMove(*crossOriginEmbedderPolicy),
            WTFMove(*originalRequestHeaders),
            WTFMove(*shouldRestrictHTTPResponseAccess),
            WTFMove(*preflightPolicy),
            WTFMove(*shouldEnableCrossOriginResourcePolicy),
            WTFMove(*frameAncestorOrigins),
            WTFMove(*pageHasResourceLoadClient),
            WTFMove(*parentFrameID),
            WTFMove(*crossOriginAccessControlCheckEnabled),
            WTFMove(*documentURL),
            WTFMove(*isCrossOriginOpenerPolicyEnabled),
            WTFMove(*isClearSiteDataHeaderEnabled),
            WTFMove(*isDisplayingInitialEmptyDocument),
            WTFMove(*effectiveSandboxFlags),
            WTFMove(*openerURL),
            WTFMove(*sourceCrossOriginOpenerPolicy),
            WTFMove(*navigationID),
            WTFMove(*navigationRequester),
#if ENABLE(SERVICE_WORKER)
            WTFMove(*serviceWorkersMode),
#endif
#if ENABLE(SERVICE_WORKER)
            WTFMove(*serviceWorkerRegistrationIdentifier),
#endif
#if ENABLE(SERVICE_WORKER)
            WTFMove(*httpHeadersToKeep),
#endif
#if ENABLE(SERVICE_WORKER)
            WTFMove(*navigationPreloadIdentifier),
#endif
#if ENABLE(CONTENT_EXTENSIONS)
            WTFMove(*mainDocumentURL),
#endif
#if ENABLE(CONTENT_EXTENSIONS)
            WTFMove(*userContentControllerIdentifier),
#endif
            WTFMove(*linkPreconnectEarlyHintsEnabled)
        }
    };
}

#if ENABLE(SERVICE_WORKER)
void ArgumentCoder<WebKit::BackgroundFetchState>::encode(Encoder& encoder, const WebKit::BackgroundFetchState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scope)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, WebCore::BackgroundFetchOptions>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.downloadTotal)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.downloaded)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uploadTotal)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uploaded)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.result)>, WebCore::BackgroundFetchResult>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.failureReason)>, WebCore::BackgroundFetchFailureReason>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPaused)>, bool>);
    struct ShouldBeSameSizeAsBackgroundFetchState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::BackgroundFetchState>, false> {
        WebCore::SecurityOriginData topOrigin;
        URL scope;
        String identifier;
        WebCore::BackgroundFetchOptions options;
        uint64_t downloadTotal;
        uint64_t downloaded;
        uint64_t uploadTotal;
        uint64_t uploaded;
        WebCore::BackgroundFetchResult result;
        WebCore::BackgroundFetchFailureReason failureReason;
        bool isPaused;
    };
    static_assert(sizeof(ShouldBeSameSizeAsBackgroundFetchState) == sizeof(WebKit::BackgroundFetchState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::BackgroundFetchState, topOrigin)
        , offsetof(WebKit::BackgroundFetchState, scope)
        , offsetof(WebKit::BackgroundFetchState, identifier)
        , offsetof(WebKit::BackgroundFetchState, options)
        , offsetof(WebKit::BackgroundFetchState, downloadTotal)
        , offsetof(WebKit::BackgroundFetchState, downloaded)
        , offsetof(WebKit::BackgroundFetchState, uploadTotal)
        , offsetof(WebKit::BackgroundFetchState, uploaded)
        , offsetof(WebKit::BackgroundFetchState, result)
        , offsetof(WebKit::BackgroundFetchState, failureReason)
        , offsetof(WebKit::BackgroundFetchState, isPaused)
    >::value);
    encoder << instance.topOrigin;
    encoder << instance.scope;
    encoder << instance.identifier;
    encoder << instance.options;
    encoder << instance.downloadTotal;
    encoder << instance.downloaded;
    encoder << instance.uploadTotal;
    encoder << instance.uploaded;
    encoder << instance.result;
    encoder << instance.failureReason;
    encoder << instance.isPaused;
}

std::optional<WebKit::BackgroundFetchState> ArgumentCoder<WebKit::BackgroundFetchState>::decode(Decoder& decoder)
{
    auto topOrigin = decoder.decode<WebCore::SecurityOriginData>();
    auto scope = decoder.decode<URL>();
    auto identifier = decoder.decode<String>();
    auto options = decoder.decode<WebCore::BackgroundFetchOptions>();
    auto downloadTotal = decoder.decode<uint64_t>();
    auto downloaded = decoder.decode<uint64_t>();
    auto uploadTotal = decoder.decode<uint64_t>();
    auto uploaded = decoder.decode<uint64_t>();
    auto result = decoder.decode<WebCore::BackgroundFetchResult>();
    auto failureReason = decoder.decode<WebCore::BackgroundFetchFailureReason>();
    auto isPaused = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::BackgroundFetchState {
            WTFMove(*topOrigin),
            WTFMove(*scope),
            WTFMove(*identifier),
            WTFMove(*options),
            WTFMove(*downloadTotal),
            WTFMove(*downloaded),
            WTFMove(*uploadTotal),
            WTFMove(*uploaded),
            WTFMove(*result),
            WTFMove(*failureReason),
            WTFMove(*isPaused)
        }
    };
}

#endif

void ArgumentCoder<WebKit::CallbackID>::encode(Encoder& encoder, const WebKit::CallbackID& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_id)>, uint64_t>);
    struct ShouldBeSameSizeAsCallbackID : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::CallbackID>, false> {
        uint64_t m_id;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCallbackID) == sizeof(WebKit::CallbackID));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::CallbackID, m_id)
    >::value);
    encoder << instance.m_id;
}

std::optional<WebKit::CallbackID> ArgumentCoder<WebKit::CallbackID>::decode(Decoder& decoder)
{
    auto m_id = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(WebKit::CallbackID::isValidCallbackID(*m_id)))
        return std::nullopt;
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::CallbackID {
            WTFMove(*m_id)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::SetState>::encode(Encoder& encoder, const WebCore::DisplayList::SetState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.state())>, WebCore::GraphicsContextState>);
    encoder << instance.state();
}

void ArgumentCoder<WebCore::DisplayList::SetState>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::SetState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.state())>, WebCore::GraphicsContextState>);
    encoder << instance.state();
}

std::optional<WebCore::DisplayList::SetState> ArgumentCoder<WebCore::DisplayList::SetState>::decode(Decoder& decoder)
{
    auto state = decoder.decode<WebCore::GraphicsContextState>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::SetState {
            WTFMove(*state)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::SetLineDash>::encode(Encoder& encoder, const WebCore::DisplayList::SetLineDash& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dashArray())>, WebCore::DashArray>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dashOffset())>, float>);
    encoder << instance.dashArray();
    encoder << instance.dashOffset();
}

void ArgumentCoder<WebCore::DisplayList::SetLineDash>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::SetLineDash& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dashArray())>, WebCore::DashArray>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dashOffset())>, float>);
    encoder << instance.dashArray();
    encoder << instance.dashOffset();
}

std::optional<WebCore::DisplayList::SetLineDash> ArgumentCoder<WebCore::DisplayList::SetLineDash>::decode(Decoder& decoder)
{
    auto dashArray = decoder.decode<WebCore::DashArray>();
    auto dashOffset = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::SetLineDash {
            WTFMove(*dashArray),
            WTFMove(*dashOffset)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::ClipOutToPath>::encode(Encoder& encoder, const WebCore::DisplayList::ClipOutToPath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    encoder << instance.path();
}

void ArgumentCoder<WebCore::DisplayList::ClipOutToPath>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::ClipOutToPath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    encoder << instance.path();
}

std::optional<WebCore::DisplayList::ClipOutToPath> ArgumentCoder<WebCore::DisplayList::ClipOutToPath>::decode(Decoder& decoder)
{
    auto path = decoder.decode<WebCore::Path>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::ClipOutToPath {
            WTFMove(*path)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::ClipPath>::encode(Encoder& encoder, const WebCore::DisplayList::ClipPath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.windRule())>, WebCore::WindRule>);
    encoder << instance.path();
    encoder << instance.windRule();
}

void ArgumentCoder<WebCore::DisplayList::ClipPath>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::ClipPath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.windRule())>, WebCore::WindRule>);
    encoder << instance.path();
    encoder << instance.windRule();
}

std::optional<WebCore::DisplayList::ClipPath> ArgumentCoder<WebCore::DisplayList::ClipPath>::decode(Decoder& decoder)
{
    auto path = decoder.decode<WebCore::Path>();
    auto windRule = decoder.decode<WebCore::WindRule>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::ClipPath {
            WTFMove(*path),
            WTFMove(*windRule)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::DrawGlyphs>::encode(Encoder& encoder, const WebCore::DisplayList::DrawGlyphs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontIdentifier())>, WebCore::RenderingResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.positionedGlyphs())>, WebCore::PositionedGlyphs>);
    encoder << instance.fontIdentifier();
    encoder << instance.positionedGlyphs();
}

void ArgumentCoder<WebCore::DisplayList::DrawGlyphs>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::DrawGlyphs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontIdentifier())>, WebCore::RenderingResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.positionedGlyphs())>, WebCore::PositionedGlyphs>);
    encoder << instance.fontIdentifier();
    encoder << instance.positionedGlyphs();
}

std::optional<WebCore::DisplayList::DrawGlyphs> ArgumentCoder<WebCore::DisplayList::DrawGlyphs>::decode(Decoder& decoder)
{
    auto fontIdentifier = decoder.decode<WebCore::RenderingResourceIdentifier>();
    auto positionedGlyphs = decoder.decode<WebCore::PositionedGlyphs>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::DrawGlyphs {
            WTFMove(*fontIdentifier),
            WTFMove(*positionedGlyphs)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::DrawSystemImage>::encode(Encoder& encoder, const WebCore::DisplayList::DrawSystemImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.systemImage())>, Ref<WebCore::SystemImage>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationRect())>, WebCore::FloatRect>);
    encoder << instance.systemImage();
    encoder << instance.destinationRect();
}

void ArgumentCoder<WebCore::DisplayList::DrawSystemImage>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::DrawSystemImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.systemImage())>, Ref<WebCore::SystemImage>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationRect())>, WebCore::FloatRect>);
    encoder << instance.systemImage();
    encoder << instance.destinationRect();
}

std::optional<WebCore::DisplayList::DrawSystemImage> ArgumentCoder<WebCore::DisplayList::DrawSystemImage>::decode(Decoder& decoder)
{
    auto systemImage = decoder.decode<Ref<WebCore::SystemImage>>();
    auto destinationRect = decoder.decode<WebCore::FloatRect>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::DrawSystemImage {
            WTFMove(*systemImage),
            WTFMove(*destinationRect)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::DrawLinesForText>::encode(Encoder& encoder, const WebCore::DisplayList::DrawLinesForText& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blockLocation())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.localAnchor())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.widths())>, WebCore::DashArray>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.thickness())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPrinting())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.doubleLines())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.style())>, WebCore::StrokeStyle>);
    encoder << instance.blockLocation();
    encoder << instance.localAnchor();
    encoder << instance.widths();
    encoder << instance.thickness();
    encoder << instance.isPrinting();
    encoder << instance.doubleLines();
    encoder << instance.style();
}

void ArgumentCoder<WebCore::DisplayList::DrawLinesForText>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::DrawLinesForText& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blockLocation())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.localAnchor())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.widths())>, WebCore::DashArray>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.thickness())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPrinting())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.doubleLines())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.style())>, WebCore::StrokeStyle>);
    encoder << instance.blockLocation();
    encoder << instance.localAnchor();
    encoder << instance.widths();
    encoder << instance.thickness();
    encoder << instance.isPrinting();
    encoder << instance.doubleLines();
    encoder << instance.style();
}

std::optional<WebCore::DisplayList::DrawLinesForText> ArgumentCoder<WebCore::DisplayList::DrawLinesForText>::decode(Decoder& decoder)
{
    auto blockLocation = decoder.decode<WebCore::FloatPoint>();
    auto localAnchor = decoder.decode<WebCore::FloatSize>();
    auto widths = decoder.decode<WebCore::DashArray>();
    auto thickness = decoder.decode<float>();
    auto isPrinting = decoder.decode<bool>();
    auto doubleLines = decoder.decode<bool>();
    auto style = decoder.decode<WebCore::StrokeStyle>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::DrawLinesForText {
            WTFMove(*blockLocation),
            WTFMove(*localAnchor),
            WTFMove(*widths),
            WTFMove(*thickness),
            WTFMove(*isPrinting),
            WTFMove(*doubleLines),
            WTFMove(*style)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::DrawPath>::encode(Encoder& encoder, const WebCore::DisplayList::DrawPath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    encoder << instance.path();
}

void ArgumentCoder<WebCore::DisplayList::DrawPath>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::DrawPath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    encoder << instance.path();
}

std::optional<WebCore::DisplayList::DrawPath> ArgumentCoder<WebCore::DisplayList::DrawPath>::decode(Decoder& decoder)
{
    auto path = decoder.decode<WebCore::Path>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::DrawPath {
            WTFMove(*path)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::DrawFocusRingPath>::encode(Encoder& encoder, const WebCore::DisplayList::DrawFocusRingPath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.outlineWidth())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    encoder << instance.path();
    encoder << instance.outlineWidth();
    encoder << instance.color();
}

void ArgumentCoder<WebCore::DisplayList::DrawFocusRingPath>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::DrawFocusRingPath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.outlineWidth())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    encoder << instance.path();
    encoder << instance.outlineWidth();
    encoder << instance.color();
}

std::optional<WebCore::DisplayList::DrawFocusRingPath> ArgumentCoder<WebCore::DisplayList::DrawFocusRingPath>::decode(Decoder& decoder)
{
    auto path = decoder.decode<WebCore::Path>();
    auto outlineWidth = decoder.decode<float>();
    auto color = decoder.decode<WebCore::Color>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::DrawFocusRingPath {
            WTFMove(*path),
            WTFMove(*outlineWidth),
            WTFMove(*color)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::DrawFocusRingRects>::encode(Encoder& encoder, const WebCore::DisplayList::DrawFocusRingRects& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rects())>, Vector<WebCore::FloatRect>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.outlineOffset())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.outlineWidth())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    encoder << instance.rects();
    encoder << instance.outlineOffset();
    encoder << instance.outlineWidth();
    encoder << instance.color();
}

void ArgumentCoder<WebCore::DisplayList::DrawFocusRingRects>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::DrawFocusRingRects& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rects())>, Vector<WebCore::FloatRect>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.outlineOffset())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.outlineWidth())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    encoder << instance.rects();
    encoder << instance.outlineOffset();
    encoder << instance.outlineWidth();
    encoder << instance.color();
}

std::optional<WebCore::DisplayList::DrawFocusRingRects> ArgumentCoder<WebCore::DisplayList::DrawFocusRingRects>::decode(Decoder& decoder)
{
    auto rects = decoder.decode<Vector<WebCore::FloatRect>>();
    auto outlineOffset = decoder.decode<float>();
    auto outlineWidth = decoder.decode<float>();
    auto color = decoder.decode<WebCore::Color>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::DrawFocusRingRects {
            WTFMove(*rects),
            WTFMove(*outlineOffset),
            WTFMove(*outlineWidth),
            WTFMove(*color)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::FillRectWithColor>::encode(Encoder& encoder, const WebCore::DisplayList::FillRectWithColor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    encoder << instance.rect();
    encoder << instance.color();
}

void ArgumentCoder<WebCore::DisplayList::FillRectWithColor>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::FillRectWithColor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    encoder << instance.rect();
    encoder << instance.color();
}

std::optional<WebCore::DisplayList::FillRectWithColor> ArgumentCoder<WebCore::DisplayList::FillRectWithColor>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    auto color = decoder.decode<WebCore::Color>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::FillRectWithColor {
            WTFMove(*rect),
            WTFMove(*color)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::FillRectWithGradient>::encode(Encoder& encoder, const WebCore::DisplayList::FillRectWithGradient& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gradient())>, Ref<WebCore::Gradient>>);
    encoder << instance.rect();
    encoder << instance.gradient();
}

void ArgumentCoder<WebCore::DisplayList::FillRectWithGradient>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::FillRectWithGradient& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gradient())>, Ref<WebCore::Gradient>>);
    encoder << instance.rect();
    encoder << instance.gradient();
}

std::optional<WebCore::DisplayList::FillRectWithGradient> ArgumentCoder<WebCore::DisplayList::FillRectWithGradient>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    auto gradient = decoder.decode<Ref<WebCore::Gradient>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::FillRectWithGradient {
            WTFMove(*rect),
            WTFMove(*gradient)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::FillCompositedRect>::encode(Encoder& encoder, const WebCore::DisplayList::FillCompositedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.compositeOperator())>, WebCore::CompositeOperator>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blendMode())>, WebCore::BlendMode>);
    encoder << instance.rect();
    encoder << instance.color();
    encoder << instance.compositeOperator();
    encoder << instance.blendMode();
}

void ArgumentCoder<WebCore::DisplayList::FillCompositedRect>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::FillCompositedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.compositeOperator())>, WebCore::CompositeOperator>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blendMode())>, WebCore::BlendMode>);
    encoder << instance.rect();
    encoder << instance.color();
    encoder << instance.compositeOperator();
    encoder << instance.blendMode();
}

std::optional<WebCore::DisplayList::FillCompositedRect> ArgumentCoder<WebCore::DisplayList::FillCompositedRect>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    auto color = decoder.decode<WebCore::Color>();
    auto compositeOperator = decoder.decode<WebCore::CompositeOperator>();
    auto blendMode = decoder.decode<WebCore::BlendMode>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::FillCompositedRect {
            WTFMove(*rect),
            WTFMove(*color),
            WTFMove(*compositeOperator),
            WTFMove(*blendMode)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::FillRoundedRect>::encode(Encoder& encoder, const WebCore::DisplayList::FillRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.roundedRect())>, WebCore::FloatRoundedRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blendMode())>, WebCore::BlendMode>);
    encoder << instance.roundedRect();
    encoder << instance.color();
    encoder << instance.blendMode();
}

std::optional<WebCore::DisplayList::FillRoundedRect> ArgumentCoder<WebCore::DisplayList::FillRoundedRect>::decode(Decoder& decoder)
{
    auto roundedRect = decoder.decode<WebCore::FloatRoundedRect>();
    auto color = decoder.decode<WebCore::Color>();
    auto blendMode = decoder.decode<WebCore::BlendMode>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::FillRoundedRect {
            WTFMove(*roundedRect),
            WTFMove(*color),
            WTFMove(*blendMode)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::FillRectWithRoundedHole>::encode(Encoder& encoder, const WebCore::DisplayList::FillRectWithRoundedHole& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.roundedHoleRect())>, WebCore::FloatRoundedRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    encoder << instance.rect();
    encoder << instance.roundedHoleRect();
    encoder << instance.color();
}

std::optional<WebCore::DisplayList::FillRectWithRoundedHole> ArgumentCoder<WebCore::DisplayList::FillRectWithRoundedHole>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    auto roundedHoleRect = decoder.decode<WebCore::FloatRoundedRect>();
    auto color = decoder.decode<WebCore::Color>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::FillRectWithRoundedHole {
            WTFMove(*rect),
            WTFMove(*roundedHoleRect),
            WTFMove(*color)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::FillPath>::encode(Encoder& encoder, const WebCore::DisplayList::FillPath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    encoder << instance.path();
}

std::optional<WebCore::DisplayList::FillPath> ArgumentCoder<WebCore::DisplayList::FillPath>::decode(Decoder& decoder)
{
    auto path = decoder.decode<WebCore::Path>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::FillPath {
            WTFMove(*path)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::StrokePath>::encode(Encoder& encoder, const WebCore::DisplayList::StrokePath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    encoder << instance.path();
}

std::optional<WebCore::DisplayList::StrokePath> ArgumentCoder<WebCore::DisplayList::StrokePath>::decode(Decoder& decoder)
{
    auto path = decoder.decode<WebCore::Path>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::StrokePath {
            WTFMove(*path)
        }
    };
}

void ArgumentCoder<WebKit::EditorState>::encode(Encoder& encoder, const WebKit::EditorState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebKit::EditorStateIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldIgnoreSelectionChanges)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsNone)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsRange)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsRangeInsideImageOverlay)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionIsRangeInAutoFilledAndViewableField)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isContentEditable)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isContentRichlyEditable)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isInPasswordField)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isInPlugin)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasComposition)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.triggeredByAccessibilitySelectionChange)>, bool>);
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canEnableAutomaticSpellingCorrection)>, bool>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.postLayoutData)>, std::optional<WebKit::EditorState::PostLayoutData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.visualData)>, std::optional<WebKit::EditorState::VisualData>>);
    struct ShouldBeSameSizeAsEditorState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::EditorState>, false> {
        WebKit::EditorStateIdentifier identifier;
        bool shouldIgnoreSelectionChanges;
        bool selectionIsNone;
        bool selectionIsRange;
        bool selectionIsRangeInsideImageOverlay;
        bool selectionIsRangeInAutoFilledAndViewableField;
        bool isContentEditable;
        bool isContentRichlyEditable;
        bool isInPasswordField;
        bool isInPlugin;
        bool hasComposition;
        bool triggeredByAccessibilitySelectionChange;
#if PLATFORM(MAC)
        bool canEnableAutomaticSpellingCorrection;
#endif
        std::optional<WebKit::EditorState::PostLayoutData> postLayoutData;
        std::optional<WebKit::EditorState::VisualData> visualData;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEditorState) == sizeof(WebKit::EditorState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::EditorState, identifier)
        , offsetof(WebKit::EditorState, shouldIgnoreSelectionChanges)
        , offsetof(WebKit::EditorState, selectionIsNone)
        , offsetof(WebKit::EditorState, selectionIsRange)
        , offsetof(WebKit::EditorState, selectionIsRangeInsideImageOverlay)
        , offsetof(WebKit::EditorState, selectionIsRangeInAutoFilledAndViewableField)
        , offsetof(WebKit::EditorState, isContentEditable)
        , offsetof(WebKit::EditorState, isContentRichlyEditable)
        , offsetof(WebKit::EditorState, isInPasswordField)
        , offsetof(WebKit::EditorState, isInPlugin)
        , offsetof(WebKit::EditorState, hasComposition)
        , offsetof(WebKit::EditorState, triggeredByAccessibilitySelectionChange)
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState, canEnableAutomaticSpellingCorrection)
#endif
        , offsetof(WebKit::EditorState, postLayoutData)
        , offsetof(WebKit::EditorState, visualData)
    >::value);
    encoder << instance.identifier;
    encoder << instance.shouldIgnoreSelectionChanges;
    encoder << instance.selectionIsNone;
    encoder << instance.selectionIsRange;
    encoder << instance.selectionIsRangeInsideImageOverlay;
    encoder << instance.selectionIsRangeInAutoFilledAndViewableField;
    encoder << instance.isContentEditable;
    encoder << instance.isContentRichlyEditable;
    encoder << instance.isInPasswordField;
    encoder << instance.isInPlugin;
    encoder << instance.hasComposition;
    encoder << instance.triggeredByAccessibilitySelectionChange;
#if PLATFORM(MAC)
    encoder << instance.canEnableAutomaticSpellingCorrection;
#endif
    encoder << instance.postLayoutData;
    encoder << instance.visualData;
}

std::optional<WebKit::EditorState> ArgumentCoder<WebKit::EditorState>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebKit::EditorStateIdentifier>();
    auto shouldIgnoreSelectionChanges = decoder.decode<bool>();
    auto selectionIsNone = decoder.decode<bool>();
    auto selectionIsRange = decoder.decode<bool>();
    auto selectionIsRangeInsideImageOverlay = decoder.decode<bool>();
    auto selectionIsRangeInAutoFilledAndViewableField = decoder.decode<bool>();
    auto isContentEditable = decoder.decode<bool>();
    auto isContentRichlyEditable = decoder.decode<bool>();
    auto isInPasswordField = decoder.decode<bool>();
    auto isInPlugin = decoder.decode<bool>();
    auto hasComposition = decoder.decode<bool>();
    auto triggeredByAccessibilitySelectionChange = decoder.decode<bool>();
#if PLATFORM(MAC)
    auto canEnableAutomaticSpellingCorrection = decoder.decode<bool>();
#endif
    auto postLayoutData = decoder.decode<std::optional<WebKit::EditorState::PostLayoutData>>();
    auto visualData = decoder.decode<std::optional<WebKit::EditorState::VisualData>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::EditorState {
            WTFMove(*identifier),
            WTFMove(*shouldIgnoreSelectionChanges),
            WTFMove(*selectionIsNone),
            WTFMove(*selectionIsRange),
            WTFMove(*selectionIsRangeInsideImageOverlay),
            WTFMove(*selectionIsRangeInAutoFilledAndViewableField),
            WTFMove(*isContentEditable),
            WTFMove(*isContentRichlyEditable),
            WTFMove(*isInPasswordField),
            WTFMove(*isInPlugin),
            WTFMove(*hasComposition),
            WTFMove(*triggeredByAccessibilitySelectionChange),
#if PLATFORM(MAC)
            WTFMove(*canEnableAutomaticSpellingCorrection),
#endif
            WTFMove(*postLayoutData),
            WTFMove(*visualData)
        }
    };
}

void ArgumentCoder<WebKit::EditorState::PostLayoutData>::encode(Encoder& encoder, const WebKit::EditorState::PostLayoutData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.typingAttributes)>, OptionSet<WebKit::TypingAttribute>>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedTextLength)>, uint64_t>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textAlignment)>, WebKit::TextAlignment>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textColor)>, WebCore::Color>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enclosingListType)>, WebKit::ListType>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseWritingDirection)>, WebCore::WritingDirection>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.editableRootIsTransparentOrFullyClipped)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markedText)>, String>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.wordAtSelection)>, String>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.characterAfterSelection)>, UChar32>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.characterBeforeSelection)>, UChar32>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.twoCharacterBeforeSelection)>, UChar32>);
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dictationContextsForSelection)>, Vector<WebCore::DictationContext>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isReplaceAllowed)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasContent)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isStableStateUpdate)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.insideFixedPosition)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasPlainText)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.caretColor)>, WebCore::Color>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.atStartOfSentence)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionStartIsAtParagraphBoundary)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionEndIsAtParagraphBoundary)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasGrammarDocumentMarkers)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedEditableImage)>, std::optional<WebCore::ElementContext>>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionBoundingRect)>, WebCore::IntRect>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.candidateRequestStartPosition)>, uint64_t>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paragraphContextForCandidateRequest)>, String>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stringForCandidateRequest)>, String>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surroundingContext)>, String>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surroundingContextCursorPosition)>, uint64_t>);
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surroundingContextSelectionPosition)>, uint64_t>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontAttributes)>, std::optional<WebCore::FontAttributes>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canCut)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canCopy)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canPaste)>, bool>);
    struct ShouldBeSameSizeAsPostLayoutData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::EditorState::PostLayoutData>, false> {
        OptionSet<WebKit::TypingAttribute> typingAttributes;
#if PLATFORM(COCOA)
        uint64_t selectedTextLength;
#endif
#if PLATFORM(COCOA)
        WebKit::TextAlignment textAlignment;
#endif
#if PLATFORM(COCOA)
        WebCore::Color textColor;
#endif
#if PLATFORM(COCOA)
        WebKit::ListType enclosingListType;
#endif
#if PLATFORM(COCOA)
        WebCore::WritingDirection baseWritingDirection;
#endif
#if PLATFORM(COCOA)
        bool editableRootIsTransparentOrFullyClipped;
#endif
#if PLATFORM(IOS_FAMILY)
        String markedText;
#endif
#if PLATFORM(IOS_FAMILY)
        String wordAtSelection;
#endif
#if PLATFORM(IOS_FAMILY)
        UChar32 characterAfterSelection;
#endif
#if PLATFORM(IOS_FAMILY)
        UChar32 characterBeforeSelection;
#endif
#if PLATFORM(IOS_FAMILY)
        UChar32 twoCharacterBeforeSelection;
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
        Vector<WebCore::DictationContext> dictationContextsForSelection;
#endif
#if PLATFORM(IOS_FAMILY)
        bool isReplaceAllowed;
#endif
#if PLATFORM(IOS_FAMILY)
        bool hasContent;
#endif
#if PLATFORM(IOS_FAMILY)
        bool isStableStateUpdate;
#endif
#if PLATFORM(IOS_FAMILY)
        bool insideFixedPosition;
#endif
#if PLATFORM(IOS_FAMILY)
        bool hasPlainText;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::Color caretColor;
#endif
#if PLATFORM(IOS_FAMILY)
        bool atStartOfSentence;
#endif
#if PLATFORM(IOS_FAMILY)
        bool selectionStartIsAtParagraphBoundary;
#endif
#if PLATFORM(IOS_FAMILY)
        bool selectionEndIsAtParagraphBoundary;
#endif
#if PLATFORM(IOS_FAMILY)
        bool hasGrammarDocumentMarkers;
#endif
#if PLATFORM(IOS_FAMILY)
        std::optional<WebCore::ElementContext> selectedEditableImage;
#endif
#if PLATFORM(MAC)
        WebCore::IntRect selectionBoundingRect;
#endif
#if PLATFORM(MAC)
        uint64_t candidateRequestStartPosition;
#endif
#if PLATFORM(MAC)
        String paragraphContextForCandidateRequest;
#endif
#if PLATFORM(MAC)
        String stringForCandidateRequest;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        String surroundingContext;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        uint64_t surroundingContextCursorPosition;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        uint64_t surroundingContextSelectionPosition;
#endif
        std::optional<WebCore::FontAttributes> fontAttributes;
        bool canCut;
        bool canCopy;
        bool canPaste;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPostLayoutData) == sizeof(WebKit::EditorState::PostLayoutData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::EditorState::PostLayoutData, typingAttributes)
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, selectedTextLength)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, textAlignment)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, textColor)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, enclosingListType)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, baseWritingDirection)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::EditorState::PostLayoutData, editableRootIsTransparentOrFullyClipped)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, markedText)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, wordAtSelection)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, characterAfterSelection)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, characterBeforeSelection)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, twoCharacterBeforeSelection)
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
        , offsetof(WebKit::EditorState::PostLayoutData, dictationContextsForSelection)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, isReplaceAllowed)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, hasContent)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, isStableStateUpdate)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, insideFixedPosition)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, hasPlainText)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, caretColor)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, atStartOfSentence)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, selectionStartIsAtParagraphBoundary)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, selectionEndIsAtParagraphBoundary)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, hasGrammarDocumentMarkers)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::PostLayoutData, selectedEditableImage)
#endif
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState::PostLayoutData, selectionBoundingRect)
#endif
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState::PostLayoutData, candidateRequestStartPosition)
#endif
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState::PostLayoutData, paragraphContextForCandidateRequest)
#endif
#if PLATFORM(MAC)
        , offsetof(WebKit::EditorState::PostLayoutData, stringForCandidateRequest)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebKit::EditorState::PostLayoutData, surroundingContext)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebKit::EditorState::PostLayoutData, surroundingContextCursorPosition)
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebKit::EditorState::PostLayoutData, surroundingContextSelectionPosition)
#endif
        , offsetof(WebKit::EditorState::PostLayoutData, fontAttributes)
        , offsetof(WebKit::EditorState::PostLayoutData, canCut)
        , offsetof(WebKit::EditorState::PostLayoutData, canCopy)
        , offsetof(WebKit::EditorState::PostLayoutData, canPaste)
    >::value);
    encoder << instance.typingAttributes;
#if PLATFORM(COCOA)
    encoder << instance.selectedTextLength;
#endif
#if PLATFORM(COCOA)
    encoder << instance.textAlignment;
#endif
#if PLATFORM(COCOA)
    encoder << instance.textColor;
#endif
#if PLATFORM(COCOA)
    encoder << instance.enclosingListType;
#endif
#if PLATFORM(COCOA)
    encoder << instance.baseWritingDirection;
#endif
#if PLATFORM(COCOA)
    encoder << instance.editableRootIsTransparentOrFullyClipped;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.markedText;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.wordAtSelection;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.characterAfterSelection;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.characterBeforeSelection;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.twoCharacterBeforeSelection;
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
    encoder << instance.dictationContextsForSelection;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.isReplaceAllowed;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.hasContent;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.isStableStateUpdate;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.insideFixedPosition;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.hasPlainText;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.caretColor;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.atStartOfSentence;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectionStartIsAtParagraphBoundary;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectionEndIsAtParagraphBoundary;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.hasGrammarDocumentMarkers;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectedEditableImage;
#endif
#if PLATFORM(MAC)
    encoder << instance.selectionBoundingRect;
#endif
#if PLATFORM(MAC)
    encoder << instance.candidateRequestStartPosition;
#endif
#if PLATFORM(MAC)
    encoder << instance.paragraphContextForCandidateRequest;
#endif
#if PLATFORM(MAC)
    encoder << instance.stringForCandidateRequest;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.surroundingContext;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.surroundingContextCursorPosition;
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.surroundingContextSelectionPosition;
#endif
    encoder << instance.fontAttributes;
    encoder << instance.canCut;
    encoder << instance.canCopy;
    encoder << instance.canPaste;
}

std::optional<WebKit::EditorState::PostLayoutData> ArgumentCoder<WebKit::EditorState::PostLayoutData>::decode(Decoder& decoder)
{
    auto typingAttributes = decoder.decode<OptionSet<WebKit::TypingAttribute>>();
#if PLATFORM(COCOA)
    auto selectedTextLength = decoder.decode<uint64_t>();
#endif
#if PLATFORM(COCOA)
    auto textAlignment = decoder.decode<WebKit::TextAlignment>();
#endif
#if PLATFORM(COCOA)
    auto textColor = decoder.decode<WebCore::Color>();
#endif
#if PLATFORM(COCOA)
    auto enclosingListType = decoder.decode<WebKit::ListType>();
#endif
#if PLATFORM(COCOA)
    auto baseWritingDirection = decoder.decode<WebCore::WritingDirection>();
#endif
#if PLATFORM(COCOA)
    auto editableRootIsTransparentOrFullyClipped = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto markedText = decoder.decode<String>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto wordAtSelection = decoder.decode<String>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto characterAfterSelection = decoder.decode<UChar32>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto characterBeforeSelection = decoder.decode<UChar32>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto twoCharacterBeforeSelection = decoder.decode<UChar32>();
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
    auto dictationContextsForSelection = decoder.decode<Vector<WebCore::DictationContext>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto isReplaceAllowed = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto hasContent = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto isStableStateUpdate = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto insideFixedPosition = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto hasPlainText = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto caretColor = decoder.decode<WebCore::Color>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto atStartOfSentence = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectionStartIsAtParagraphBoundary = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectionEndIsAtParagraphBoundary = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto hasGrammarDocumentMarkers = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectedEditableImage = decoder.decode<std::optional<WebCore::ElementContext>>();
#endif
#if PLATFORM(MAC)
    auto selectionBoundingRect = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(MAC)
    auto candidateRequestStartPosition = decoder.decode<uint64_t>();
#endif
#if PLATFORM(MAC)
    auto paragraphContextForCandidateRequest = decoder.decode<String>();
#endif
#if PLATFORM(MAC)
    auto stringForCandidateRequest = decoder.decode<String>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto surroundingContext = decoder.decode<String>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto surroundingContextCursorPosition = decoder.decode<uint64_t>();
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
    auto surroundingContextSelectionPosition = decoder.decode<uint64_t>();
#endif
    auto fontAttributes = decoder.decode<std::optional<WebCore::FontAttributes>>();
    auto canCut = decoder.decode<bool>();
    auto canCopy = decoder.decode<bool>();
    auto canPaste = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::EditorState::PostLayoutData {
            WTFMove(*typingAttributes),
#if PLATFORM(COCOA)
            WTFMove(*selectedTextLength),
#endif
#if PLATFORM(COCOA)
            WTFMove(*textAlignment),
#endif
#if PLATFORM(COCOA)
            WTFMove(*textColor),
#endif
#if PLATFORM(COCOA)
            WTFMove(*enclosingListType),
#endif
#if PLATFORM(COCOA)
            WTFMove(*baseWritingDirection),
#endif
#if PLATFORM(COCOA)
            WTFMove(*editableRootIsTransparentOrFullyClipped),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*markedText),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*wordAtSelection),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*characterAfterSelection),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*characterBeforeSelection),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*twoCharacterBeforeSelection),
#endif
#if PLATFORM(IOS_FAMILY) && USE(DICTATION_ALTERNATIVES)
            WTFMove(*dictationContextsForSelection),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*isReplaceAllowed),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*hasContent),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*isStableStateUpdate),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*insideFixedPosition),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*hasPlainText),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*caretColor),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*atStartOfSentence),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectionStartIsAtParagraphBoundary),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectionEndIsAtParagraphBoundary),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*hasGrammarDocumentMarkers),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectedEditableImage),
#endif
#if PLATFORM(MAC)
            WTFMove(*selectionBoundingRect),
#endif
#if PLATFORM(MAC)
            WTFMove(*candidateRequestStartPosition),
#endif
#if PLATFORM(MAC)
            WTFMove(*paragraphContextForCandidateRequest),
#endif
#if PLATFORM(MAC)
            WTFMove(*stringForCandidateRequest),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*surroundingContext),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*surroundingContextCursorPosition),
#endif
#if PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*surroundingContextSelectionPosition),
#endif
            WTFMove(*fontAttributes),
            WTFMove(*canCut),
            WTFMove(*canCopy),
            WTFMove(*canPaste)
        }
    };
}

void ArgumentCoder<WebKit::EditorState::VisualData>::encode(Encoder& encoder, const WebKit::EditorState::VisualData& instance)
{
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.caretRectAtStart)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionClipRect)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.caretRectAtEnd)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionGeometries)>, Vector<WebCore::SelectionGeometry>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markedTextRects)>, Vector<WebCore::SelectionGeometry>>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markedTextCaretRectAtStart)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markedTextCaretRectAtEnd)>, WebCore::IntRect>);
#endif
    struct ShouldBeSameSizeAsVisualData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::EditorState::VisualData>, false> {
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
        WebCore::IntRect caretRectAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect selectionClipRect;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect caretRectAtEnd;
#endif
#if PLATFORM(IOS_FAMILY)
        Vector<WebCore::SelectionGeometry> selectionGeometries;
#endif
#if PLATFORM(IOS_FAMILY)
        Vector<WebCore::SelectionGeometry> markedTextRects;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect markedTextCaretRectAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect markedTextCaretRectAtEnd;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsVisualData) == sizeof(WebKit::EditorState::VisualData));
    static_assert(MembersInCorrectOrder < 0
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
        , offsetof(WebKit::EditorState::VisualData, caretRectAtStart)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, selectionClipRect)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, caretRectAtEnd)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, selectionGeometries)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, markedTextRects)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, markedTextCaretRectAtStart)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::EditorState::VisualData, markedTextCaretRectAtEnd)
#endif
    >::value);
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
    encoder << instance.caretRectAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectionClipRect;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.caretRectAtEnd;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.selectionGeometries;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.markedTextRects;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.markedTextCaretRectAtStart;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.markedTextCaretRectAtEnd;
#endif
}

std::optional<WebKit::EditorState::VisualData> ArgumentCoder<WebKit::EditorState::VisualData>::decode(Decoder& decoder)
{
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
    auto caretRectAtStart = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectionClipRect = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto caretRectAtEnd = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto selectionGeometries = decoder.decode<Vector<WebCore::SelectionGeometry>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto markedTextRects = decoder.decode<Vector<WebCore::SelectionGeometry>>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto markedTextCaretRectAtStart = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto markedTextCaretRectAtEnd = decoder.decode<WebCore::IntRect>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::EditorState::VisualData {
#if PLATFORM(IOS_FAMILY) || PLATFORM(GTK) || PLATFORM(WPE)
            WTFMove(*caretRectAtStart),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectionClipRect),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*caretRectAtEnd),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*selectionGeometries),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*markedTextRects),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*markedTextCaretRectAtStart),
#endif
#if PLATFORM(IOS_FAMILY)
            WTFMove(*markedTextCaretRectAtEnd)
#endif
        }
    };
}

void ArgumentCoder<WebKit::FileSystemSyncAccessHandleInfo>::encode(Encoder& encoder, const WebKit::FileSystemSyncAccessHandleInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::FileSystemSyncAccessHandleIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.handle)>, IPC::SharedFileHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.capacity)>, uint64_t>);
    struct ShouldBeSameSizeAsFileSystemSyncAccessHandleInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FileSystemSyncAccessHandleInfo>, false> {
        WebCore::FileSystemSyncAccessHandleIdentifier identifier;
        IPC::SharedFileHandle handle;
        uint64_t capacity;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFileSystemSyncAccessHandleInfo) == sizeof(WebKit::FileSystemSyncAccessHandleInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FileSystemSyncAccessHandleInfo, identifier)
        , offsetof(WebKit::FileSystemSyncAccessHandleInfo, handle)
        , offsetof(WebKit::FileSystemSyncAccessHandleInfo, capacity)
    >::value);
    encoder << instance.identifier;
    encoder << instance.handle;
    encoder << instance.capacity;
}

std::optional<WebKit::FileSystemSyncAccessHandleInfo> ArgumentCoder<WebKit::FileSystemSyncAccessHandleInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::FileSystemSyncAccessHandleIdentifier>();
    auto handle = decoder.decode<IPC::SharedFileHandle>();
    auto capacity = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::FileSystemSyncAccessHandleInfo {
            WTFMove(*identifier),
            WTFMove(*handle),
            WTFMove(*capacity)
        }
    };
}

#if PLATFORM(IOS_FAMILY)
void ArgumentCoder<WebKit::OptionItem>::encode(Encoder& encoder, const WebKit::OptionItem& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isGroup)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSelected)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.disabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentGroupID)>, int>);
    struct ShouldBeSameSizeAsOptionItem : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::OptionItem>, false> {
        String text;
        bool isGroup;
        bool isSelected;
        bool disabled;
        int parentGroupID;
    };
    static_assert(sizeof(ShouldBeSameSizeAsOptionItem) == sizeof(WebKit::OptionItem));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::OptionItem, text)
        , offsetof(WebKit::OptionItem, isGroup)
        , offsetof(WebKit::OptionItem, isSelected)
        , offsetof(WebKit::OptionItem, disabled)
        , offsetof(WebKit::OptionItem, parentGroupID)
    >::value);
    encoder << instance.text;
    encoder << instance.isGroup;
    encoder << instance.isSelected;
    encoder << instance.disabled;
    encoder << instance.parentGroupID;
}

std::optional<WebKit::OptionItem> ArgumentCoder<WebKit::OptionItem>::decode(Decoder& decoder)
{
    auto text = decoder.decode<String>();
    auto isGroup = decoder.decode<bool>();
    auto isSelected = decoder.decode<bool>();
    auto disabled = decoder.decode<bool>();
    auto parentGroupID = decoder.decode<int>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::OptionItem {
            WTFMove(*text),
            WTFMove(*isGroup),
            WTFMove(*isSelected),
            WTFMove(*disabled),
            WTFMove(*parentGroupID)
        }
    };
}

#endif

#if PLATFORM(IOS_FAMILY)
void ArgumentCoder<WebKit::FocusedElementInformation>::encode(Encoder& encoder, const WebKit::FocusedElementInformation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.interactionRect)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elementContext)>, WebCore::ElementContext>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lastInteractionLocation)>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.minimumScaleFactor)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximumScaleFactor)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximumScaleFactorIgnoringAlwaysScalable)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nodeFontSize)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasNextNode)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nextNodeRect)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasPreviousNode)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.previousNodeRect)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isAutocorrect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isRTL)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMultiSelect)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isReadOnly)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsUserScaling)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsUserScalingIgnoringAlwaysScalable)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.insideFixedPosition)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.autocapitalizeType)>, WebCore::AutocapitalizeType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elementType)>, WebKit::InputType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.inputMode)>, WebCore::InputMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enterKeyHint)>, WebCore::EnterKeyHint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.formAction)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectOptions)>, Vector<WebKit::OptionItem>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedIndex)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.valueAsNumber)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.acceptsAutofilledLoginCredentials)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isAutofillableUsernameField)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.representingPageURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.autofillFieldName)>, WebCore::AutofillFieldName>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nonAutofillCredentialType)>, WebCore::NonAutofillCredentialType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.placeholder)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ariaLabel)>, String>);
#if ENABLE(DATALIST_ELEMENT)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasSuggestions)>, bool>);
#endif
#if ENABLE(DATALIST_ELEMENT)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFocusingWithDataListDropdown)>, bool>);
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorValue)>, WebCore::Color>);
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.suggestedColors)>, Vector<WebCore::Color>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasEverBeenPasswordField)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldSynthesizeKeyEventsForEditing)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSpellCheckingEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldAvoidResizingWhenInputViewBoundsChange)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldAvoidScrollingWhenFocusedContentIsVisible)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFocusingWithValidationMessage)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preventScroll)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebKit::FocusedElementInformationIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containerScrollingNodeID)>, WebCore::ScrollingNodeID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, WebCore::FrameIdentifier>);
    struct ShouldBeSameSizeAsFocusedElementInformation : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FocusedElementInformation>, false> {
        WebCore::IntRect interactionRect;
        WebCore::ElementContext elementContext;
        WebCore::IntPoint lastInteractionLocation;
        double minimumScaleFactor;
        double maximumScaleFactor;
        double maximumScaleFactorIgnoringAlwaysScalable;
        double nodeFontSize;
        bool hasNextNode;
        WebCore::IntRect nextNodeRect;
        bool hasPreviousNode;
        WebCore::IntRect previousNodeRect;
        bool isAutocorrect;
        bool isRTL;
        bool isMultiSelect;
        bool isReadOnly;
        bool allowsUserScaling;
        bool allowsUserScalingIgnoringAlwaysScalable;
        bool insideFixedPosition;
        WebCore::AutocapitalizeType autocapitalizeType;
        WebKit::InputType elementType;
        WebCore::InputMode inputMode;
        WebCore::EnterKeyHint enterKeyHint;
        String formAction;
        Vector<WebKit::OptionItem> selectOptions;
        int selectedIndex;
        String value;
        double valueAsNumber;
        String title;
        bool acceptsAutofilledLoginCredentials;
        bool isAutofillableUsernameField;
        URL representingPageURL;
        WebCore::AutofillFieldName autofillFieldName;
        WebCore::NonAutofillCredentialType nonAutofillCredentialType;
        String placeholder;
        String label;
        String ariaLabel;
#if ENABLE(DATALIST_ELEMENT)
        bool hasSuggestions;
#endif
#if ENABLE(DATALIST_ELEMENT)
        bool isFocusingWithDataListDropdown;
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        WebCore::Color colorValue;
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        Vector<WebCore::Color> suggestedColors;
#endif
        bool hasEverBeenPasswordField;
        bool shouldSynthesizeKeyEventsForEditing;
        bool isSpellCheckingEnabled;
        bool shouldAvoidResizingWhenInputViewBoundsChange;
        bool shouldAvoidScrollingWhenFocusedContentIsVisible;
        bool shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation;
        bool isFocusingWithValidationMessage;
        bool preventScroll;
        WebKit::FocusedElementInformationIdentifier identifier;
        WebCore::ScrollingNodeID containerScrollingNodeID;
        WebCore::FrameIdentifier frameID;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFocusedElementInformation) == sizeof(WebKit::FocusedElementInformation));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FocusedElementInformation, interactionRect)
        , offsetof(WebKit::FocusedElementInformation, elementContext)
        , offsetof(WebKit::FocusedElementInformation, lastInteractionLocation)
        , offsetof(WebKit::FocusedElementInformation, minimumScaleFactor)
        , offsetof(WebKit::FocusedElementInformation, maximumScaleFactor)
        , offsetof(WebKit::FocusedElementInformation, maximumScaleFactorIgnoringAlwaysScalable)
        , offsetof(WebKit::FocusedElementInformation, nodeFontSize)
        , offsetof(WebKit::FocusedElementInformation, hasNextNode)
        , offsetof(WebKit::FocusedElementInformation, nextNodeRect)
        , offsetof(WebKit::FocusedElementInformation, hasPreviousNode)
        , offsetof(WebKit::FocusedElementInformation, previousNodeRect)
        , offsetof(WebKit::FocusedElementInformation, isAutocorrect)
        , offsetof(WebKit::FocusedElementInformation, isRTL)
        , offsetof(WebKit::FocusedElementInformation, isMultiSelect)
        , offsetof(WebKit::FocusedElementInformation, isReadOnly)
        , offsetof(WebKit::FocusedElementInformation, allowsUserScaling)
        , offsetof(WebKit::FocusedElementInformation, allowsUserScalingIgnoringAlwaysScalable)
        , offsetof(WebKit::FocusedElementInformation, insideFixedPosition)
        , offsetof(WebKit::FocusedElementInformation, autocapitalizeType)
        , offsetof(WebKit::FocusedElementInformation, elementType)
        , offsetof(WebKit::FocusedElementInformation, inputMode)
        , offsetof(WebKit::FocusedElementInformation, enterKeyHint)
        , offsetof(WebKit::FocusedElementInformation, formAction)
        , offsetof(WebKit::FocusedElementInformation, selectOptions)
        , offsetof(WebKit::FocusedElementInformation, selectedIndex)
        , offsetof(WebKit::FocusedElementInformation, value)
        , offsetof(WebKit::FocusedElementInformation, valueAsNumber)
        , offsetof(WebKit::FocusedElementInformation, title)
        , offsetof(WebKit::FocusedElementInformation, acceptsAutofilledLoginCredentials)
        , offsetof(WebKit::FocusedElementInformation, isAutofillableUsernameField)
        , offsetof(WebKit::FocusedElementInformation, representingPageURL)
        , offsetof(WebKit::FocusedElementInformation, autofillFieldName)
        , offsetof(WebKit::FocusedElementInformation, nonAutofillCredentialType)
        , offsetof(WebKit::FocusedElementInformation, placeholder)
        , offsetof(WebKit::FocusedElementInformation, label)
        , offsetof(WebKit::FocusedElementInformation, ariaLabel)
#if ENABLE(DATALIST_ELEMENT)
        , offsetof(WebKit::FocusedElementInformation, hasSuggestions)
#endif
#if ENABLE(DATALIST_ELEMENT)
        , offsetof(WebKit::FocusedElementInformation, isFocusingWithDataListDropdown)
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        , offsetof(WebKit::FocusedElementInformation, colorValue)
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        , offsetof(WebKit::FocusedElementInformation, suggestedColors)
#endif
        , offsetof(WebKit::FocusedElementInformation, hasEverBeenPasswordField)
        , offsetof(WebKit::FocusedElementInformation, shouldSynthesizeKeyEventsForEditing)
        , offsetof(WebKit::FocusedElementInformation, isSpellCheckingEnabled)
        , offsetof(WebKit::FocusedElementInformation, shouldAvoidResizingWhenInputViewBoundsChange)
        , offsetof(WebKit::FocusedElementInformation, shouldAvoidScrollingWhenFocusedContentIsVisible)
        , offsetof(WebKit::FocusedElementInformation, shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation)
        , offsetof(WebKit::FocusedElementInformation, isFocusingWithValidationMessage)
        , offsetof(WebKit::FocusedElementInformation, preventScroll)
        , offsetof(WebKit::FocusedElementInformation, identifier)
        , offsetof(WebKit::FocusedElementInformation, containerScrollingNodeID)
        , offsetof(WebKit::FocusedElementInformation, frameID)
    >::value);
    encoder << instance.interactionRect;
    encoder << instance.elementContext;
    encoder << instance.lastInteractionLocation;
    encoder << instance.minimumScaleFactor;
    encoder << instance.maximumScaleFactor;
    encoder << instance.maximumScaleFactorIgnoringAlwaysScalable;
    encoder << instance.nodeFontSize;
    encoder << instance.hasNextNode;
    encoder << instance.nextNodeRect;
    encoder << instance.hasPreviousNode;
    encoder << instance.previousNodeRect;
    encoder << instance.isAutocorrect;
    encoder << instance.isRTL;
    encoder << instance.isMultiSelect;
    encoder << instance.isReadOnly;
    encoder << instance.allowsUserScaling;
    encoder << instance.allowsUserScalingIgnoringAlwaysScalable;
    encoder << instance.insideFixedPosition;
    encoder << instance.autocapitalizeType;
    encoder << instance.elementType;
    encoder << instance.inputMode;
    encoder << instance.enterKeyHint;
    encoder << instance.formAction;
    encoder << instance.selectOptions;
    encoder << instance.selectedIndex;
    encoder << instance.value;
    encoder << instance.valueAsNumber;
    encoder << instance.title;
    encoder << instance.acceptsAutofilledLoginCredentials;
    encoder << instance.isAutofillableUsernameField;
    encoder << instance.representingPageURL;
    encoder << instance.autofillFieldName;
    encoder << instance.nonAutofillCredentialType;
    encoder << instance.placeholder;
    encoder << instance.label;
    encoder << instance.ariaLabel;
#if ENABLE(DATALIST_ELEMENT)
    encoder << instance.hasSuggestions;
#endif
#if ENABLE(DATALIST_ELEMENT)
    encoder << instance.isFocusingWithDataListDropdown;
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    encoder << instance.colorValue;
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    encoder << instance.suggestedColors;
#endif
    encoder << instance.hasEverBeenPasswordField;
    encoder << instance.shouldSynthesizeKeyEventsForEditing;
    encoder << instance.isSpellCheckingEnabled;
    encoder << instance.shouldAvoidResizingWhenInputViewBoundsChange;
    encoder << instance.shouldAvoidScrollingWhenFocusedContentIsVisible;
    encoder << instance.shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation;
    encoder << instance.isFocusingWithValidationMessage;
    encoder << instance.preventScroll;
    encoder << instance.identifier;
    encoder << instance.containerScrollingNodeID;
    encoder << instance.frameID;
}

std::optional<WebKit::FocusedElementInformation> ArgumentCoder<WebKit::FocusedElementInformation>::decode(Decoder& decoder)
{
    auto interactionRect = decoder.decode<WebCore::IntRect>();
    auto elementContext = decoder.decode<WebCore::ElementContext>();
    auto lastInteractionLocation = decoder.decode<WebCore::IntPoint>();
    auto minimumScaleFactor = decoder.decode<double>();
    auto maximumScaleFactor = decoder.decode<double>();
    auto maximumScaleFactorIgnoringAlwaysScalable = decoder.decode<double>();
    auto nodeFontSize = decoder.decode<double>();
    auto hasNextNode = decoder.decode<bool>();
    auto nextNodeRect = decoder.decode<WebCore::IntRect>();
    auto hasPreviousNode = decoder.decode<bool>();
    auto previousNodeRect = decoder.decode<WebCore::IntRect>();
    auto isAutocorrect = decoder.decode<bool>();
    auto isRTL = decoder.decode<bool>();
    auto isMultiSelect = decoder.decode<bool>();
    auto isReadOnly = decoder.decode<bool>();
    auto allowsUserScaling = decoder.decode<bool>();
    auto allowsUserScalingIgnoringAlwaysScalable = decoder.decode<bool>();
    auto insideFixedPosition = decoder.decode<bool>();
    auto autocapitalizeType = decoder.decode<WebCore::AutocapitalizeType>();
    auto elementType = decoder.decode<WebKit::InputType>();
    auto inputMode = decoder.decode<WebCore::InputMode>();
    auto enterKeyHint = decoder.decode<WebCore::EnterKeyHint>();
    auto formAction = decoder.decode<String>();
    auto selectOptions = decoder.decode<Vector<WebKit::OptionItem>>();
    auto selectedIndex = decoder.decode<int>();
    auto value = decoder.decode<String>();
    auto valueAsNumber = decoder.decode<double>();
    auto title = decoder.decode<String>();
    auto acceptsAutofilledLoginCredentials = decoder.decode<bool>();
    auto isAutofillableUsernameField = decoder.decode<bool>();
    auto representingPageURL = decoder.decode<URL>();
    auto autofillFieldName = decoder.decode<WebCore::AutofillFieldName>();
    auto nonAutofillCredentialType = decoder.decode<WebCore::NonAutofillCredentialType>();
    auto placeholder = decoder.decode<String>();
    auto label = decoder.decode<String>();
    auto ariaLabel = decoder.decode<String>();
#if ENABLE(DATALIST_ELEMENT)
    auto hasSuggestions = decoder.decode<bool>();
#endif
#if ENABLE(DATALIST_ELEMENT)
    auto isFocusingWithDataListDropdown = decoder.decode<bool>();
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    auto colorValue = decoder.decode<WebCore::Color>();
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    auto suggestedColors = decoder.decode<Vector<WebCore::Color>>();
#endif
    auto hasEverBeenPasswordField = decoder.decode<bool>();
    auto shouldSynthesizeKeyEventsForEditing = decoder.decode<bool>();
    auto isSpellCheckingEnabled = decoder.decode<bool>();
    auto shouldAvoidResizingWhenInputViewBoundsChange = decoder.decode<bool>();
    auto shouldAvoidScrollingWhenFocusedContentIsVisible = decoder.decode<bool>();
    auto shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation = decoder.decode<bool>();
    auto isFocusingWithValidationMessage = decoder.decode<bool>();
    auto preventScroll = decoder.decode<bool>();
    auto identifier = decoder.decode<WebKit::FocusedElementInformationIdentifier>();
    auto containerScrollingNodeID = decoder.decode<WebCore::ScrollingNodeID>();
    auto frameID = decoder.decode<WebCore::FrameIdentifier>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::FocusedElementInformation {
            WTFMove(*interactionRect),
            WTFMove(*elementContext),
            WTFMove(*lastInteractionLocation),
            WTFMove(*minimumScaleFactor),
            WTFMove(*maximumScaleFactor),
            WTFMove(*maximumScaleFactorIgnoringAlwaysScalable),
            WTFMove(*nodeFontSize),
            WTFMove(*hasNextNode),
            WTFMove(*nextNodeRect),
            WTFMove(*hasPreviousNode),
            WTFMove(*previousNodeRect),
            WTFMove(*isAutocorrect),
            WTFMove(*isRTL),
            WTFMove(*isMultiSelect),
            WTFMove(*isReadOnly),
            WTFMove(*allowsUserScaling),
            WTFMove(*allowsUserScalingIgnoringAlwaysScalable),
            WTFMove(*insideFixedPosition),
            WTFMove(*autocapitalizeType),
            WTFMove(*elementType),
            WTFMove(*inputMode),
            WTFMove(*enterKeyHint),
            WTFMove(*formAction),
            WTFMove(*selectOptions),
            WTFMove(*selectedIndex),
            WTFMove(*value),
            WTFMove(*valueAsNumber),
            WTFMove(*title),
            WTFMove(*acceptsAutofilledLoginCredentials),
            WTFMove(*isAutofillableUsernameField),
            WTFMove(*representingPageURL),
            WTFMove(*autofillFieldName),
            WTFMove(*nonAutofillCredentialType),
            WTFMove(*placeholder),
            WTFMove(*label),
            WTFMove(*ariaLabel),
#if ENABLE(DATALIST_ELEMENT)
            WTFMove(*hasSuggestions),
#endif
#if ENABLE(DATALIST_ELEMENT)
            WTFMove(*isFocusingWithDataListDropdown),
#endif
#if ENABLE(INPUT_TYPE_COLOR)
            WTFMove(*colorValue),
#endif
#if ENABLE(INPUT_TYPE_COLOR)
            WTFMove(*suggestedColors),
#endif
            WTFMove(*hasEverBeenPasswordField),
            WTFMove(*shouldSynthesizeKeyEventsForEditing),
            WTFMove(*isSpellCheckingEnabled),
            WTFMove(*shouldAvoidResizingWhenInputViewBoundsChange),
            WTFMove(*shouldAvoidScrollingWhenFocusedContentIsVisible),
            WTFMove(*shouldUseLegacySelectPopoverDismissalBehaviorInDataActivation),
            WTFMove(*isFocusingWithValidationMessage),
            WTFMove(*preventScroll),
            WTFMove(*identifier),
            WTFMove(*containerScrollingNodeID),
            WTFMove(*frameID)
        }
    };
}

#endif

void ArgumentCoder<WebKit::FrameInfoData>::encode(Encoder& encoder, const WebKit::FrameInfoData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isMainFrame)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameType)>, WebKit::FrameType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.securityOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parentFrameID)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processID)>, WTF::ProcessID>);
    struct ShouldBeSameSizeAsFrameInfoData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FrameInfoData>, false> {
        bool isMainFrame;
        WebKit::FrameType frameType;
        WebCore::ResourceRequest request;
        WebCore::SecurityOriginData securityOrigin;
        String frameName;
        WebCore::FrameIdentifier frameID;
        std::optional<WebCore::FrameIdentifier> parentFrameID;
        WTF::ProcessID processID;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFrameInfoData) == sizeof(WebKit::FrameInfoData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FrameInfoData, isMainFrame)
        , offsetof(WebKit::FrameInfoData, frameType)
        , offsetof(WebKit::FrameInfoData, request)
        , offsetof(WebKit::FrameInfoData, securityOrigin)
        , offsetof(WebKit::FrameInfoData, frameName)
        , offsetof(WebKit::FrameInfoData, frameID)
        , offsetof(WebKit::FrameInfoData, parentFrameID)
        , offsetof(WebKit::FrameInfoData, processID)
    >::value);
    encoder << instance.isMainFrame;
    encoder << instance.frameType;
    encoder << instance.request;
    encoder << instance.securityOrigin;
    encoder << instance.frameName;
    encoder << instance.frameID;
    encoder << instance.parentFrameID;
    encoder << instance.processID;
}

std::optional<WebKit::FrameInfoData> ArgumentCoder<WebKit::FrameInfoData>::decode(Decoder& decoder)
{
    auto isMainFrame = decoder.decode<bool>();
    auto frameType = decoder.decode<WebKit::FrameType>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    auto securityOrigin = decoder.decode<WebCore::SecurityOriginData>();
    auto frameName = decoder.decode<String>();
    auto frameID = decoder.decode<WebCore::FrameIdentifier>();
    auto parentFrameID = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto processID = decoder.decode<WTF::ProcessID>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::FrameInfoData {
            WTFMove(*isMainFrame),
            WTFMove(*frameType),
            WTFMove(*request),
            WTFMove(*securityOrigin),
            WTFMove(*frameName),
            WTFMove(*frameID),
            WTFMove(*parentFrameID),
            WTFMove(*processID)
        }
    };
}

void ArgumentCoder<WebKit::FrameTreeCreationParameters>::encode(Encoder& encoder, const WebKit::FrameTreeCreationParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebKit::FrameTreeCreationParameters>>);
    struct ShouldBeSameSizeAsFrameTreeCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FrameTreeCreationParameters>, false> {
        WebCore::FrameIdentifier frameID;
        Vector<WebKit::FrameTreeCreationParameters> children;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFrameTreeCreationParameters) == sizeof(WebKit::FrameTreeCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FrameTreeCreationParameters, frameID)
        , offsetof(WebKit::FrameTreeCreationParameters, children)
    >::value);
    encoder << instance.frameID;
    encoder << instance.children;
}

std::optional<WebKit::FrameTreeCreationParameters> ArgumentCoder<WebKit::FrameTreeCreationParameters>::decode(Decoder& decoder)
{
    auto frameID = decoder.decode<WebCore::FrameIdentifier>();
    auto children = decoder.decode<Vector<WebKit::FrameTreeCreationParameters>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::FrameTreeCreationParameters {
            WTFMove(*frameID),
            WTFMove(*children)
        }
    };
}

void ArgumentCoder<WebKit::FrameTreeNodeData>::encode(Encoder& encoder, const WebKit::FrameTreeNodeData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.info)>, WebKit::FrameInfoData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebKit::FrameTreeNodeData>>);
    struct ShouldBeSameSizeAsFrameTreeNodeData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FrameTreeNodeData>, false> {
        WebKit::FrameInfoData info;
        Vector<WebKit::FrameTreeNodeData> children;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFrameTreeNodeData) == sizeof(WebKit::FrameTreeNodeData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FrameTreeNodeData, info)
        , offsetof(WebKit::FrameTreeNodeData, children)
    >::value);
    encoder << instance.info;
    encoder << instance.children;
}

std::optional<WebKit::FrameTreeNodeData> ArgumentCoder<WebKit::FrameTreeNodeData>::decode(Decoder& decoder)
{
    auto info = decoder.decode<WebKit::FrameInfoData>();
    auto children = decoder.decode<Vector<WebKit::FrameTreeNodeData>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::FrameTreeNodeData {
            WTFMove(*info),
            WTFMove(*children)
        }
    };
}

#if ENABLE(GPU_PROCESS)
void ArgumentCoder<WebKit::GPUProcessConnectionParameters>::encode(Encoder& encoder, WebKit::GPUProcessConnectionParameters&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webProcessIdentity)>, WebCore::ProcessIdentity>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isDOMRenderingEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isLockdownModeEnabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isWebGPUEnabled)>, bool>);
#if ENABLE(IPC_TESTING_API)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreInvalidMessageForTesting)>, bool>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowTestOnlyIPC)>, bool>);
#if HAVE(AUDIT_TOKEN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.presentingApplicationAuditToken)>, std::optional<audit_token_t>>);
#endif
#if ENABLE(VP9)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasVP9HardwareDecoder)>, std::optional<bool>>);
#endif
#if ENABLE(VP9)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasVP9ExtensionSupport)>, std::optional<bool>>);
#endif
    struct ShouldBeSameSizeAsGPUProcessConnectionParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::GPUProcessConnectionParameters>, false> {
        WebCore::ProcessIdentity webProcessIdentity;
        bool isDOMRenderingEnabled;
        bool isLockdownModeEnabled;
        bool isWebGPUEnabled;
#if ENABLE(IPC_TESTING_API)
        bool ignoreInvalidMessageForTesting;
#endif
        bool allowTestOnlyIPC;
#if HAVE(AUDIT_TOKEN)
        std::optional<audit_token_t> presentingApplicationAuditToken;
#endif
#if ENABLE(VP9)
        std::optional<bool> hasVP9HardwareDecoder;
#endif
#if ENABLE(VP9)
        std::optional<bool> hasVP9ExtensionSupport;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsGPUProcessConnectionParameters) == sizeof(WebKit::GPUProcessConnectionParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::GPUProcessConnectionParameters, webProcessIdentity)
        , offsetof(WebKit::GPUProcessConnectionParameters, isDOMRenderingEnabled)
        , offsetof(WebKit::GPUProcessConnectionParameters, isLockdownModeEnabled)
        , offsetof(WebKit::GPUProcessConnectionParameters, isWebGPUEnabled)
#if ENABLE(IPC_TESTING_API)
        , offsetof(WebKit::GPUProcessConnectionParameters, ignoreInvalidMessageForTesting)
#endif
        , offsetof(WebKit::GPUProcessConnectionParameters, allowTestOnlyIPC)
#if HAVE(AUDIT_TOKEN)
        , offsetof(WebKit::GPUProcessConnectionParameters, presentingApplicationAuditToken)
#endif
#if ENABLE(VP9)
        , offsetof(WebKit::GPUProcessConnectionParameters, hasVP9HardwareDecoder)
#endif
#if ENABLE(VP9)
        , offsetof(WebKit::GPUProcessConnectionParameters, hasVP9ExtensionSupport)
#endif
    >::value);
    encoder << WTFMove(instance.webProcessIdentity);
    encoder << WTFMove(instance.isDOMRenderingEnabled);
    encoder << WTFMove(instance.isLockdownModeEnabled);
    encoder << WTFMove(instance.isWebGPUEnabled);
#if ENABLE(IPC_TESTING_API)
    encoder << WTFMove(instance.ignoreInvalidMessageForTesting);
#endif
    encoder << WTFMove(instance.allowTestOnlyIPC);
#if HAVE(AUDIT_TOKEN)
    encoder << WTFMove(instance.presentingApplicationAuditToken);
#endif
#if ENABLE(VP9)
    encoder << WTFMove(instance.hasVP9HardwareDecoder);
#endif
#if ENABLE(VP9)
    encoder << WTFMove(instance.hasVP9ExtensionSupport);
#endif
}

std::optional<WebKit::GPUProcessConnectionParameters> ArgumentCoder<WebKit::GPUProcessConnectionParameters>::decode(Decoder& decoder)
{
    auto webProcessIdentity = decoder.decode<WebCore::ProcessIdentity>();
    auto isDOMRenderingEnabled = decoder.decode<bool>();
    auto isLockdownModeEnabled = decoder.decode<bool>();
    auto isWebGPUEnabled = decoder.decode<bool>();
#if ENABLE(IPC_TESTING_API)
    auto ignoreInvalidMessageForTesting = decoder.decode<bool>();
#endif
    auto allowTestOnlyIPC = decoder.decode<bool>();
#if HAVE(AUDIT_TOKEN)
    auto presentingApplicationAuditToken = decoder.decode<std::optional<audit_token_t>>();
#endif
#if ENABLE(VP9)
    auto hasVP9HardwareDecoder = decoder.decode<std::optional<bool>>();
#endif
#if ENABLE(VP9)
    auto hasVP9ExtensionSupport = decoder.decode<std::optional<bool>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::GPUProcessConnectionParameters {
            WTFMove(*webProcessIdentity),
            WTFMove(*isDOMRenderingEnabled),
            WTFMove(*isLockdownModeEnabled),
            WTFMove(*isWebGPUEnabled),
#if ENABLE(IPC_TESTING_API)
            WTFMove(*ignoreInvalidMessageForTesting),
#endif
            WTFMove(*allowTestOnlyIPC),
#if HAVE(AUDIT_TOKEN)
            WTFMove(*presentingApplicationAuditToken),
#endif
#if ENABLE(VP9)
            WTFMove(*hasVP9HardwareDecoder),
#endif
#if ENABLE(VP9)
            WTFMove(*hasVP9ExtensionSupport)
#endif
        }
    };
}

#endif

void ArgumentCoder<WebKit::LayerTreeContext>::encode(Encoder& encoder, const WebKit::LayerTreeContext& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contextID)>, uint64_t>);
    struct ShouldBeSameSizeAsLayerTreeContext : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::LayerTreeContext>, false> {
        uint64_t contextID;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLayerTreeContext) == sizeof(WebKit::LayerTreeContext));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::LayerTreeContext, contextID)
    >::value);
    encoder << instance.contextID;
}

std::optional<WebKit::LayerTreeContext> ArgumentCoder<WebKit::LayerTreeContext>::decode(Decoder& decoder)
{
    auto contextID = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::LayerTreeContext {
            WTFMove(*contextID)
        }
    };
}

void ArgumentCoder<WebKit::LocalFrameCreationParameters>::encode(Encoder& encoder, const WebKit::LocalFrameCreationParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.layerHostingContextIdentifier)>, std::optional<WebCore::LayerHostingContextIdentifier>>);
    struct ShouldBeSameSizeAsLocalFrameCreationParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::LocalFrameCreationParameters>, false> {
        std::optional<WebCore::LayerHostingContextIdentifier> layerHostingContextIdentifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLocalFrameCreationParameters) == sizeof(WebKit::LocalFrameCreationParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::LocalFrameCreationParameters, layerHostingContextIdentifier)
    >::value);
    encoder << instance.layerHostingContextIdentifier;
}

std::optional<WebKit::LocalFrameCreationParameters> ArgumentCoder<WebKit::LocalFrameCreationParameters>::decode(Decoder& decoder)
{
    auto layerHostingContextIdentifier = decoder.decode<std::optional<WebCore::LayerHostingContextIdentifier>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::LocalFrameCreationParameters {
            WTFMove(*layerHostingContextIdentifier)
        }
    };
}

#if ENABLE(ARKIT_INLINE_PREVIEW)
void ArgumentCoder<WebKit::ModelIdentifier>::encode(Encoder& encoder, const WebKit::ModelIdentifier& instance)
{
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uuid)>, String>);
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.layerIdentifier)>, WebCore::PlatformLayerIdentifier>);
#endif
    struct ShouldBeSameSizeAsModelIdentifier : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ModelIdentifier>, false> {
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
        String uuid;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
        WebCore::PlatformLayerIdentifier layerIdentifier;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsModelIdentifier) == sizeof(WebKit::ModelIdentifier));
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
        , offsetof(WebKit::ModelIdentifier, uuid)
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
        , offsetof(WebKit::ModelIdentifier, layerIdentifier)
#endif
    >::value);
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    encoder << instance.uuid;
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    encoder << instance.layerIdentifier;
#endif
}

std::optional<WebKit::ModelIdentifier> ArgumentCoder<WebKit::ModelIdentifier>::decode(Decoder& decoder)
{
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
    auto uuid = decoder.decode<String>();
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
    auto layerIdentifier = decoder.decode<WebCore::PlatformLayerIdentifier>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::ModelIdentifier {
#if ENABLE(ARKIT_INLINE_PREVIEW_MAC)
            WTFMove(*uuid),
#endif
#if ENABLE(ARKIT_INLINE_PREVIEW_IOS)
            WTFMove(*layerIdentifier)
#endif
        }
    };
}

#endif

void ArgumentCoder<WebKit::NavigationActionData>::encode(Encoder& encoder, const WebKit::NavigationActionData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationType)>, WebCore::NavigationType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.modifiers)>, OptionSet<WebKit::WebEventModifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mouseButton)>, WebKit::WebMouseEventButton>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.syntheticClickType)>, WebKit::WebMouseEventSyntheticClickType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userGestureTokenIdentifier)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userGestureAuthorizationToken)>, std::optional<WTF::UUID>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canHandleRequest)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldOpenExternalURLsPolicy)>, WebCore::ShouldOpenExternalURLsPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.downloadAttribute)>, WTF::String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clickLocationInRootViewCoordinates)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.redirectResponse)>, WebCore::ResourceResponse>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.treatAsSameOriginNavigation)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasOpenedFrames)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.openedByDOMWithOpener)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasOpener)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requesterOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.targetBackForwardItemIdentifier)>, std::optional<WebCore::BackForwardItemIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceBackForwardItemIdentifier)>, std::optional<WebCore::BackForwardItemIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lockHistory)>, WebCore::LockHistory>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lockBackForwardList)>, WebCore::LockBackForwardList>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientRedirectSourceForHistory)>, WTF::String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.effectiveSandboxFlags)>, WebCore::SandboxFlags>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.privateClickMeasurement)>, std::optional<WebCore::PrivateClickMeasurement>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.advancedPrivacyProtections)>, OptionSet<WebCore::AdvancedPrivacyProtections>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originatorAdvancedPrivacyProtections)>, OptionSet<WebCore::AdvancedPrivacyProtections>>);
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webHitTestResultData)>, std::optional<WebKit::WebHitTestResultData>>);
#endif
    struct ShouldBeSameSizeAsNavigationActionData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NavigationActionData>, false> {
        WebCore::NavigationType navigationType;
        OptionSet<WebKit::WebEventModifier> modifiers;
        WebKit::WebMouseEventButton mouseButton;
        WebKit::WebMouseEventSyntheticClickType syntheticClickType;
        uint64_t userGestureTokenIdentifier;
        std::optional<WTF::UUID> userGestureAuthorizationToken;
        bool canHandleRequest;
        WebCore::ShouldOpenExternalURLsPolicy shouldOpenExternalURLsPolicy;
        WTF::String downloadAttribute;
        WebCore::FloatPoint clickLocationInRootViewCoordinates;
        WebCore::ResourceResponse redirectResponse;
        bool treatAsSameOriginNavigation;
        bool hasOpenedFrames;
        bool openedByDOMWithOpener;
        bool hasOpener;
        WebCore::SecurityOriginData requesterOrigin;
        std::optional<WebCore::BackForwardItemIdentifier> targetBackForwardItemIdentifier;
        std::optional<WebCore::BackForwardItemIdentifier> sourceBackForwardItemIdentifier;
        WebCore::LockHistory lockHistory;
        WebCore::LockBackForwardList lockBackForwardList;
        WTF::String clientRedirectSourceForHistory;
        WebCore::SandboxFlags effectiveSandboxFlags;
        std::optional<WebCore::PrivateClickMeasurement> privateClickMeasurement;
        OptionSet<WebCore::AdvancedPrivacyProtections> advancedPrivacyProtections;
        OptionSet<WebCore::AdvancedPrivacyProtections> originatorAdvancedPrivacyProtections;
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
        std::optional<WebKit::WebHitTestResultData> webHitTestResultData;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsNavigationActionData) == sizeof(WebKit::NavigationActionData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NavigationActionData, navigationType)
        , offsetof(WebKit::NavigationActionData, modifiers)
        , offsetof(WebKit::NavigationActionData, mouseButton)
        , offsetof(WebKit::NavigationActionData, syntheticClickType)
        , offsetof(WebKit::NavigationActionData, userGestureTokenIdentifier)
        , offsetof(WebKit::NavigationActionData, userGestureAuthorizationToken)
        , offsetof(WebKit::NavigationActionData, canHandleRequest)
        , offsetof(WebKit::NavigationActionData, shouldOpenExternalURLsPolicy)
        , offsetof(WebKit::NavigationActionData, downloadAttribute)
        , offsetof(WebKit::NavigationActionData, clickLocationInRootViewCoordinates)
        , offsetof(WebKit::NavigationActionData, redirectResponse)
        , offsetof(WebKit::NavigationActionData, treatAsSameOriginNavigation)
        , offsetof(WebKit::NavigationActionData, hasOpenedFrames)
        , offsetof(WebKit::NavigationActionData, openedByDOMWithOpener)
        , offsetof(WebKit::NavigationActionData, hasOpener)
        , offsetof(WebKit::NavigationActionData, requesterOrigin)
        , offsetof(WebKit::NavigationActionData, targetBackForwardItemIdentifier)
        , offsetof(WebKit::NavigationActionData, sourceBackForwardItemIdentifier)
        , offsetof(WebKit::NavigationActionData, lockHistory)
        , offsetof(WebKit::NavigationActionData, lockBackForwardList)
        , offsetof(WebKit::NavigationActionData, clientRedirectSourceForHistory)
        , offsetof(WebKit::NavigationActionData, effectiveSandboxFlags)
        , offsetof(WebKit::NavigationActionData, privateClickMeasurement)
        , offsetof(WebKit::NavigationActionData, advancedPrivacyProtections)
        , offsetof(WebKit::NavigationActionData, originatorAdvancedPrivacyProtections)
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
        , offsetof(WebKit::NavigationActionData, webHitTestResultData)
#endif
    >::value);
    encoder << instance.navigationType;
    encoder << instance.modifiers;
    encoder << instance.mouseButton;
    encoder << instance.syntheticClickType;
    encoder << instance.userGestureTokenIdentifier;
    encoder << instance.userGestureAuthorizationToken;
    encoder << instance.canHandleRequest;
    encoder << instance.shouldOpenExternalURLsPolicy;
    encoder << instance.downloadAttribute;
    encoder << instance.clickLocationInRootViewCoordinates;
    encoder << instance.redirectResponse;
    encoder << instance.treatAsSameOriginNavigation;
    encoder << instance.hasOpenedFrames;
    encoder << instance.openedByDOMWithOpener;
    encoder << instance.hasOpener;
    encoder << instance.requesterOrigin;
    encoder << instance.targetBackForwardItemIdentifier;
    encoder << instance.sourceBackForwardItemIdentifier;
    encoder << instance.lockHistory;
    encoder << instance.lockBackForwardList;
    encoder << instance.clientRedirectSourceForHistory;
    encoder << instance.effectiveSandboxFlags;
    encoder << instance.privateClickMeasurement;
    encoder << instance.advancedPrivacyProtections;
    encoder << instance.originatorAdvancedPrivacyProtections;
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
    encoder << instance.webHitTestResultData;
#endif
}

std::optional<WebKit::NavigationActionData> ArgumentCoder<WebKit::NavigationActionData>::decode(Decoder& decoder)
{
    auto navigationType = decoder.decode<WebCore::NavigationType>();
    auto modifiers = decoder.decode<OptionSet<WebKit::WebEventModifier>>();
    auto mouseButton = decoder.decode<WebKit::WebMouseEventButton>();
    auto syntheticClickType = decoder.decode<WebKit::WebMouseEventSyntheticClickType>();
    auto userGestureTokenIdentifier = decoder.decode<uint64_t>();
    auto userGestureAuthorizationToken = decoder.decode<std::optional<WTF::UUID>>();
    auto canHandleRequest = decoder.decode<bool>();
    auto shouldOpenExternalURLsPolicy = decoder.decode<WebCore::ShouldOpenExternalURLsPolicy>();
    auto downloadAttribute = decoder.decode<WTF::String>();
    auto clickLocationInRootViewCoordinates = decoder.decode<WebCore::FloatPoint>();
    auto redirectResponse = decoder.decode<WebCore::ResourceResponse>();
    auto treatAsSameOriginNavigation = decoder.decode<bool>();
    auto hasOpenedFrames = decoder.decode<bool>();
    auto openedByDOMWithOpener = decoder.decode<bool>();
    auto hasOpener = decoder.decode<bool>();
    auto requesterOrigin = decoder.decode<WebCore::SecurityOriginData>();
    auto targetBackForwardItemIdentifier = decoder.decode<std::optional<WebCore::BackForwardItemIdentifier>>();
    auto sourceBackForwardItemIdentifier = decoder.decode<std::optional<WebCore::BackForwardItemIdentifier>>();
    auto lockHistory = decoder.decode<WebCore::LockHistory>();
    auto lockBackForwardList = decoder.decode<WebCore::LockBackForwardList>();
    auto clientRedirectSourceForHistory = decoder.decode<WTF::String>();
    auto effectiveSandboxFlags = decoder.decode<WebCore::SandboxFlags>();
    auto privateClickMeasurement = decoder.decode<std::optional<WebCore::PrivateClickMeasurement>>();
    auto advancedPrivacyProtections = decoder.decode<OptionSet<WebCore::AdvancedPrivacyProtections>>();
    auto originatorAdvancedPrivacyProtections = decoder.decode<OptionSet<WebCore::AdvancedPrivacyProtections>>();
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
    auto webHitTestResultData = decoder.decode<std::optional<WebKit::WebHitTestResultData>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::NavigationActionData {
            WTFMove(*navigationType),
            WTFMove(*modifiers),
            WTFMove(*mouseButton),
            WTFMove(*syntheticClickType),
            WTFMove(*userGestureTokenIdentifier),
            WTFMove(*userGestureAuthorizationToken),
            WTFMove(*canHandleRequest),
            WTFMove(*shouldOpenExternalURLsPolicy),
            WTFMove(*downloadAttribute),
            WTFMove(*clickLocationInRootViewCoordinates),
            WTFMove(*redirectResponse),
            WTFMove(*treatAsSameOriginNavigation),
            WTFMove(*hasOpenedFrames),
            WTFMove(*openedByDOMWithOpener),
            WTFMove(*hasOpener),
            WTFMove(*requesterOrigin),
            WTFMove(*targetBackForwardItemIdentifier),
            WTFMove(*sourceBackForwardItemIdentifier),
            WTFMove(*lockHistory),
            WTFMove(*lockBackForwardList),
            WTFMove(*clientRedirectSourceForHistory),
            WTFMove(*effectiveSandboxFlags),
            WTFMove(*privateClickMeasurement),
            WTFMove(*advancedPrivacyProtections),
            WTFMove(*originatorAdvancedPrivacyProtections),
#if PLATFORM(MAC) || HAVE(UIKIT_WITH_MOUSE_SUPPORT)
            WTFMove(*webHitTestResultData)
#endif
        }
    };
}

void ArgumentCoder<WebKit::NetworkProcessConnectionParameters>::encode(Encoder& encoder, const WebKit::NetworkProcessConnectionParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowTestOnlyIPC)>, bool>);
    struct ShouldBeSameSizeAsNetworkProcessConnectionParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::NetworkProcessConnectionParameters>, false> {
        bool allowTestOnlyIPC;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNetworkProcessConnectionParameters) == sizeof(WebKit::NetworkProcessConnectionParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::NetworkProcessConnectionParameters, allowTestOnlyIPC)
    >::value);
    encoder << instance.allowTestOnlyIPC;
}

std::optional<WebKit::NetworkProcessConnectionParameters> ArgumentCoder<WebKit::NetworkProcessConnectionParameters>::decode(Decoder& decoder)
{
    auto allowTestOnlyIPC = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::NetworkProcessConnectionParameters {
            WTFMove(*allowTestOnlyIPC)
        }
    };
}

void ArgumentCoder<WebCore::PasteboardImage>::encode(Encoder& encoder, const WebCore::PasteboardImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.image)>, RefPtr<WebCore::Image>>);
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInWebArchiveFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInHTMLFormat)>, String>);
#endif
#if !PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, WebCore::PasteboardURL>);
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resourceData)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resourceMIMEType)>, String>);
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientTypes)>, Vector<String>>);
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientData)>, Vector<RefPtr<WebCore::SharedBuffer>>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.suggestedName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.imageSize)>, WebCore::FloatSize>);
    struct ShouldBeSameSizeAsPasteboardImage : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PasteboardImage>, false> {
        RefPtr<WebCore::Image> image;
#if PLATFORM(MAC)
        RefPtr<WebCore::SharedBuffer> dataInWebArchiveFormat;
#endif
#if PLATFORM(MAC)
        String dataInHTMLFormat;
#endif
#if !PLATFORM(WIN)
        WebCore::PasteboardURL url;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
        RefPtr<WebCore::SharedBuffer> resourceData;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
        String resourceMIMEType;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
        Vector<String> clientTypes;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
        Vector<RefPtr<WebCore::SharedBuffer>> clientData;
#endif
        String suggestedName;
        WebCore::FloatSize imageSize;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPasteboardImage) == sizeof(WebCore::PasteboardImage));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PasteboardImage, image)
#if PLATFORM(MAC)
        , offsetof(WebCore::PasteboardImage, dataInWebArchiveFormat)
#endif
#if PLATFORM(MAC)
        , offsetof(WebCore::PasteboardImage, dataInHTMLFormat)
#endif
#if !PLATFORM(WIN)
        , offsetof(WebCore::PasteboardImage, url)
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
        , offsetof(WebCore::PasteboardImage, resourceData)
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
        , offsetof(WebCore::PasteboardImage, resourceMIMEType)
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
        , offsetof(WebCore::PasteboardImage, clientTypes)
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
        , offsetof(WebCore::PasteboardImage, clientData)
#endif
        , offsetof(WebCore::PasteboardImage, suggestedName)
        , offsetof(WebCore::PasteboardImage, imageSize)
    >::value);
    encoder << instance.image;
#if PLATFORM(MAC)
    encoder << instance.dataInWebArchiveFormat;
#endif
#if PLATFORM(MAC)
    encoder << instance.dataInHTMLFormat;
#endif
#if !PLATFORM(WIN)
    encoder << instance.url;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    encoder << instance.resourceData;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    encoder << instance.resourceMIMEType;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    encoder << instance.clientTypes;
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    encoder << instance.clientData;
#endif
    encoder << instance.suggestedName;
    encoder << instance.imageSize;
}

std::optional<WebCore::PasteboardImage> ArgumentCoder<WebCore::PasteboardImage>::decode(Decoder& decoder)
{
    auto image = decoder.decode<RefPtr<WebCore::Image>>();
#if PLATFORM(MAC)
    auto dataInWebArchiveFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(MAC)
    auto dataInHTMLFormat = decoder.decode<String>();
#endif
#if !PLATFORM(WIN)
    auto url = decoder.decode<WebCore::PasteboardURL>();
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    auto resourceData = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    auto resourceMIMEType = decoder.decode<String>();
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    auto clientTypes = decoder.decode<Vector<String>>();
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
    auto clientData = decoder.decode<Vector<RefPtr<WebCore::SharedBuffer>>>();
#endif
    auto suggestedName = decoder.decode<String>();
    auto imageSize = decoder.decode<WebCore::FloatSize>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PasteboardImage {
            WTFMove(*image),
#if PLATFORM(MAC)
            WTFMove(*dataInWebArchiveFormat),
#endif
#if PLATFORM(MAC)
            WTFMove(*dataInHTMLFormat),
#endif
#if !PLATFORM(WIN)
            WTFMove(*url),
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
            WTFMove(*resourceData),
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
            WTFMove(*resourceMIMEType),
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
            WTFMove(*clientTypes),
#endif
#if !(PLATFORM(GTK) || PLATFORM(WIN))
            WTFMove(*clientData),
#endif
            WTFMove(*suggestedName),
            WTFMove(*imageSize)
        }
    };
}

void ArgumentCoder<WebCore::PasteboardWebContent>::encode(Encoder& encoder, const WebCore::PasteboardWebContent& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentOrigin)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canSmartCopyOrDelete)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInWebArchiveFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInRTFDFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInRTFFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInAttributedStringFormat)>, RefPtr<WebCore::SharedBuffer>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInHTMLFormat)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataInStringFormat)>, String>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientTypes)>, Vector<String>>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientData)>, Vector<RefPtr<WebCore::SharedBuffer>>>);
#endif
#if PLATFORM(GTK)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentOrigin)>, String>);
#endif
#if PLATFORM(GTK)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canSmartCopyOrDelete)>, bool>);
#endif
#if PLATFORM(GTK)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
#endif
#if PLATFORM(GTK)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markup)>, String>);
#endif
#if USE(LIBWPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
#endif
#if USE(LIBWPE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markup)>, String>);
#endif
    struct ShouldBeSameSizeAsPasteboardWebContent : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PasteboardWebContent>, false> {
#if PLATFORM(COCOA)
        String contentOrigin;
#endif
#if PLATFORM(COCOA)
        bool canSmartCopyOrDelete;
#endif
#if PLATFORM(COCOA)
        RefPtr<WebCore::SharedBuffer> dataInWebArchiveFormat;
#endif
#if PLATFORM(COCOA)
        RefPtr<WebCore::SharedBuffer> dataInRTFDFormat;
#endif
#if PLATFORM(COCOA)
        RefPtr<WebCore::SharedBuffer> dataInRTFFormat;
#endif
#if PLATFORM(COCOA)
        RefPtr<WebCore::SharedBuffer> dataInAttributedStringFormat;
#endif
#if PLATFORM(COCOA)
        String dataInHTMLFormat;
#endif
#if PLATFORM(COCOA)
        String dataInStringFormat;
#endif
#if PLATFORM(COCOA)
        Vector<String> clientTypes;
#endif
#if PLATFORM(COCOA)
        Vector<RefPtr<WebCore::SharedBuffer>> clientData;
#endif
#if PLATFORM(GTK)
        String contentOrigin;
#endif
#if PLATFORM(GTK)
        bool canSmartCopyOrDelete;
#endif
#if PLATFORM(GTK)
        String text;
#endif
#if PLATFORM(GTK)
        String markup;
#endif
#if USE(LIBWPE)
        String text;
#endif
#if USE(LIBWPE)
        String markup;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPasteboardWebContent) == sizeof(WebCore::PasteboardWebContent));
    static_assert(MembersInCorrectOrder < 0
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, contentOrigin)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, canSmartCopyOrDelete)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInWebArchiveFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInRTFDFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInRTFFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInAttributedStringFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInHTMLFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, dataInStringFormat)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, clientTypes)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardWebContent, clientData)
#endif
#if PLATFORM(GTK)
        , offsetof(WebCore::PasteboardWebContent, contentOrigin)
#endif
#if PLATFORM(GTK)
        , offsetof(WebCore::PasteboardWebContent, canSmartCopyOrDelete)
#endif
#if PLATFORM(GTK)
        , offsetof(WebCore::PasteboardWebContent, text)
#endif
#if PLATFORM(GTK)
        , offsetof(WebCore::PasteboardWebContent, markup)
#endif
#if USE(LIBWPE)
        , offsetof(WebCore::PasteboardWebContent, text)
#endif
#if USE(LIBWPE)
        , offsetof(WebCore::PasteboardWebContent, markup)
#endif
    >::value);
#if PLATFORM(COCOA)
    encoder << instance.contentOrigin;
#endif
#if PLATFORM(COCOA)
    encoder << instance.canSmartCopyOrDelete;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInWebArchiveFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInRTFDFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInRTFFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInAttributedStringFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInHTMLFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.dataInStringFormat;
#endif
#if PLATFORM(COCOA)
    encoder << instance.clientTypes;
#endif
#if PLATFORM(COCOA)
    encoder << instance.clientData;
#endif
#if PLATFORM(GTK)
    encoder << instance.contentOrigin;
#endif
#if PLATFORM(GTK)
    encoder << instance.canSmartCopyOrDelete;
#endif
#if PLATFORM(GTK)
    encoder << instance.text;
#endif
#if PLATFORM(GTK)
    encoder << instance.markup;
#endif
#if USE(LIBWPE)
    encoder << instance.text;
#endif
#if USE(LIBWPE)
    encoder << instance.markup;
#endif
}

std::optional<WebCore::PasteboardWebContent> ArgumentCoder<WebCore::PasteboardWebContent>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto contentOrigin = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto canSmartCopyOrDelete = decoder.decode<bool>();
#endif
#if PLATFORM(COCOA)
    auto dataInWebArchiveFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(COCOA)
    auto dataInRTFDFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(COCOA)
    auto dataInRTFFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(COCOA)
    auto dataInAttributedStringFormat = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
#endif
#if PLATFORM(COCOA)
    auto dataInHTMLFormat = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto dataInStringFormat = decoder.decode<String>();
#endif
#if PLATFORM(COCOA)
    auto clientTypes = decoder.decode<Vector<String>>();
#endif
#if PLATFORM(COCOA)
    auto clientData = decoder.decode<Vector<RefPtr<WebCore::SharedBuffer>>>();
#endif
#if PLATFORM(GTK)
    auto contentOrigin = decoder.decode<String>();
#endif
#if PLATFORM(GTK)
    auto canSmartCopyOrDelete = decoder.decode<bool>();
#endif
#if PLATFORM(GTK)
    auto text = decoder.decode<String>();
#endif
#if PLATFORM(GTK)
    auto markup = decoder.decode<String>();
#endif
#if USE(LIBWPE)
    auto text = decoder.decode<String>();
#endif
#if USE(LIBWPE)
    auto markup = decoder.decode<String>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PasteboardWebContent {
#if PLATFORM(COCOA)
            WTFMove(*contentOrigin),
#endif
#if PLATFORM(COCOA)
            WTFMove(*canSmartCopyOrDelete),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInWebArchiveFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInRTFDFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInRTFFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInAttributedStringFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInHTMLFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*dataInStringFormat),
#endif
#if PLATFORM(COCOA)
            WTFMove(*clientTypes),
#endif
#if PLATFORM(COCOA)
            WTFMove(*clientData),
#endif
#if PLATFORM(GTK)
            WTFMove(*contentOrigin),
#endif
#if PLATFORM(GTK)
            WTFMove(*canSmartCopyOrDelete),
#endif
#if PLATFORM(GTK)
            WTFMove(*text),
#endif
#if PLATFORM(GTK)
            WTFMove(*markup),
#endif
#if USE(LIBWPE)
            WTFMove(*text),
#endif
#if USE(LIBWPE)
            WTFMove(*markup)
#endif
        }
    };
}

void ArgumentCoder<WebCore::PasteboardURL>::encode(Encoder& encoder, const WebCore::PasteboardURL& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userVisibleForm)>, String>);
#endif
#if PLATFORM(GTK)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.markup)>, String>);
#endif
    struct ShouldBeSameSizeAsPasteboardURL : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PasteboardURL>, false> {
        URL url;
        String title;
#if PLATFORM(MAC)
        String userVisibleForm;
#endif
#if PLATFORM(GTK)
        String markup;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPasteboardURL) == sizeof(WebCore::PasteboardURL));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PasteboardURL, url)
        , offsetof(WebCore::PasteboardURL, title)
#if PLATFORM(MAC)
        , offsetof(WebCore::PasteboardURL, userVisibleForm)
#endif
#if PLATFORM(GTK)
        , offsetof(WebCore::PasteboardURL, markup)
#endif
    >::value);
    encoder << instance.url;
    encoder << instance.title;
#if PLATFORM(MAC)
    encoder << instance.userVisibleForm;
#endif
#if PLATFORM(GTK)
    encoder << instance.markup;
#endif
}

std::optional<WebCore::PasteboardURL> ArgumentCoder<WebCore::PasteboardURL>::decode(Decoder& decoder)
{
    auto url = decoder.decode<URL>();
    auto title = decoder.decode<String>();
#if PLATFORM(MAC)
    auto userVisibleForm = decoder.decode<String>();
#endif
#if PLATFORM(GTK)
    auto markup = decoder.decode<String>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PasteboardURL {
            WTFMove(*url),
            WTFMove(*title),
#if PLATFORM(MAC)
            WTFMove(*userVisibleForm),
#endif
#if PLATFORM(GTK)
            WTFMove(*markup)
#endif
        }
    };
}

void ArgumentCoder<WebCore::PasteboardBuffer>::encode(Encoder& encoder, const WebCore::PasteboardBuffer& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentOrigin)>, String>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, RefPtr<WebCore::SharedBuffer>>);
    struct ShouldBeSameSizeAsPasteboardBuffer : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PasteboardBuffer>, false> {
#if PLATFORM(COCOA)
        String contentOrigin;
#endif
        String type;
        RefPtr<WebCore::SharedBuffer> data;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPasteboardBuffer) == sizeof(WebCore::PasteboardBuffer));
    static_assert(MembersInCorrectOrder < 0
#if PLATFORM(COCOA)
        , offsetof(WebCore::PasteboardBuffer, contentOrigin)
#endif
        , offsetof(WebCore::PasteboardBuffer, type)
        , offsetof(WebCore::PasteboardBuffer, data)
    >::value);
#if PLATFORM(COCOA)
    encoder << instance.contentOrigin;
#endif
    encoder << instance.type;
    encoder << instance.data;
}

std::optional<WebCore::PasteboardBuffer> ArgumentCoder<WebCore::PasteboardBuffer>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto contentOrigin = decoder.decode<String>();
#endif
    auto type = decoder.decode<String>();
    auto data = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PasteboardBuffer {
#if PLATFORM(COCOA)
            WTFMove(*contentOrigin),
#endif
            WTFMove(*type),
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebKit::PlatformPopupMenuData>::encode(Encoder& encoder, const WebKit::PlatformPopupMenuData& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontInfo)>, WebKit::FontInfo>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldPopOver)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hideArrows)>, bool>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.menuSize)>, WebCore::PopupMenuStyle::PopupMenuSize>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_clientPaddingLeft)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_clientPaddingRight)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_clientInsetLeft)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_clientInsetRight)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_popupWidth)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_itemHeight)>, int>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_notSelectedBackingStore)>, RefPtr<WebKit::ShareableBitmap>>);
#endif
#if PLATFORM(WIN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_selectedBackingStore)>, RefPtr<WebKit::ShareableBitmap>>);
#endif
    struct ShouldBeSameSizeAsPlatformPopupMenuData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::PlatformPopupMenuData>, false> {
#if PLATFORM(COCOA)
        WebKit::FontInfo fontInfo;
#endif
#if PLATFORM(COCOA)
        bool shouldPopOver;
#endif
#if PLATFORM(COCOA)
        bool hideArrows;
#endif
#if PLATFORM(COCOA)
        WebCore::PopupMenuStyle::PopupMenuSize menuSize;
#endif
#if PLATFORM(WIN)
        int m_clientPaddingLeft;
#endif
#if PLATFORM(WIN)
        int m_clientPaddingRight;
#endif
#if PLATFORM(WIN)
        int m_clientInsetLeft;
#endif
#if PLATFORM(WIN)
        int m_clientInsetRight;
#endif
#if PLATFORM(WIN)
        int m_popupWidth;
#endif
#if PLATFORM(WIN)
        int m_itemHeight;
#endif
#if PLATFORM(WIN)
        RefPtr<WebKit::ShareableBitmap> m_notSelectedBackingStore;
#endif
#if PLATFORM(WIN)
        RefPtr<WebKit::ShareableBitmap> m_selectedBackingStore;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPlatformPopupMenuData) == sizeof(WebKit::PlatformPopupMenuData));
    static_assert(MembersInCorrectOrder < 0
#if PLATFORM(COCOA)
        , offsetof(WebKit::PlatformPopupMenuData, fontInfo)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::PlatformPopupMenuData, shouldPopOver)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::PlatformPopupMenuData, hideArrows)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebKit::PlatformPopupMenuData, menuSize)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_clientPaddingLeft)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_clientPaddingRight)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_clientInsetLeft)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_clientInsetRight)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_popupWidth)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_itemHeight)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_notSelectedBackingStore)
#endif
#if PLATFORM(WIN)
        , offsetof(WebKit::PlatformPopupMenuData, m_selectedBackingStore)
#endif
    >::value);
#if PLATFORM(COCOA)
    encoder << instance.fontInfo;
#endif
#if PLATFORM(COCOA)
    encoder << instance.shouldPopOver;
#endif
#if PLATFORM(COCOA)
    encoder << instance.hideArrows;
#endif
#if PLATFORM(COCOA)
    encoder << instance.menuSize;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_clientPaddingLeft;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_clientPaddingRight;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_clientInsetLeft;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_clientInsetRight;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_popupWidth;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_itemHeight;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_notSelectedBackingStore;
#endif
#if PLATFORM(WIN)
    encoder << instance.m_selectedBackingStore;
#endif
}

std::optional<WebKit::PlatformPopupMenuData> ArgumentCoder<WebKit::PlatformPopupMenuData>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto fontInfo = decoder.decode<WebKit::FontInfo>();
#endif
#if PLATFORM(COCOA)
    auto shouldPopOver = decoder.decode<bool>();
#endif
#if PLATFORM(COCOA)
    auto hideArrows = decoder.decode<bool>();
#endif
#if PLATFORM(COCOA)
    auto menuSize = decoder.decode<WebCore::PopupMenuStyle::PopupMenuSize>();
#endif
#if PLATFORM(WIN)
    auto m_clientPaddingLeft = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_clientPaddingRight = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_clientInsetLeft = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_clientInsetRight = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_popupWidth = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_itemHeight = decoder.decode<int>();
#endif
#if PLATFORM(WIN)
    auto m_notSelectedBackingStore = decoder.decode<RefPtr<WebKit::ShareableBitmap>>();
#endif
#if PLATFORM(WIN)
    auto m_selectedBackingStore = decoder.decode<RefPtr<WebKit::ShareableBitmap>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::PlatformPopupMenuData {
#if PLATFORM(COCOA)
            WTFMove(*fontInfo),
#endif
#if PLATFORM(COCOA)
            WTFMove(*shouldPopOver),
#endif
#if PLATFORM(COCOA)
            WTFMove(*hideArrows),
#endif
#if PLATFORM(COCOA)
            WTFMove(*menuSize),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_clientPaddingLeft),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_clientPaddingRight),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_clientInsetLeft),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_clientInsetRight),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_popupWidth),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_itemHeight),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_notSelectedBackingStore),
#endif
#if PLATFORM(WIN)
            WTFMove(*m_selectedBackingStore)
#endif
        }
    };
}

void ArgumentCoder<WebKit::PolicyDecision>::encode(Encoder& encoder, const WebKit::PolicyDecision& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isNavigatingToAppBoundDomain)>, std::optional<WebKit::NavigatingToAppBoundDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.policyAction)>, WebCore::PolicyAction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigationID)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.downloadID)>, std::optional<WebKit::DownloadID>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.websitePoliciesData)>, std::optional<WebKit::WebsitePoliciesData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sandboxExtensionHandle)>, std::optional<WebKit::SandboxExtension::Handle>>);
    struct ShouldBeSameSizeAsPolicyDecision : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::PolicyDecision>, false> {
        std::optional<WebKit::NavigatingToAppBoundDomain> isNavigatingToAppBoundDomain;
        WebCore::PolicyAction policyAction;
        uint64_t navigationID;
        std::optional<WebKit::DownloadID> downloadID;
        std::optional<WebKit::WebsitePoliciesData> websitePoliciesData;
        std::optional<WebKit::SandboxExtension::Handle> sandboxExtensionHandle;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPolicyDecision) == sizeof(WebKit::PolicyDecision));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::PolicyDecision, isNavigatingToAppBoundDomain)
        , offsetof(WebKit::PolicyDecision, policyAction)
        , offsetof(WebKit::PolicyDecision, navigationID)
        , offsetof(WebKit::PolicyDecision, downloadID)
        , offsetof(WebKit::PolicyDecision, websitePoliciesData)
        , offsetof(WebKit::PolicyDecision, sandboxExtensionHandle)
    >::value);
    encoder << instance.isNavigatingToAppBoundDomain;
    encoder << instance.policyAction;
    encoder << instance.navigationID;
    encoder << instance.downloadID;
    encoder << instance.websitePoliciesData;
    encoder << instance.sandboxExtensionHandle;
}

std::optional<WebKit::PolicyDecision> ArgumentCoder<WebKit::PolicyDecision>::decode(Decoder& decoder)
{
    auto isNavigatingToAppBoundDomain = decoder.decode<std::optional<WebKit::NavigatingToAppBoundDomain>>();
    auto policyAction = decoder.decode<WebCore::PolicyAction>();
    auto navigationID = decoder.decode<uint64_t>();
    auto downloadID = decoder.decode<std::optional<WebKit::DownloadID>>();
    auto websitePoliciesData = decoder.decode<std::optional<WebKit::WebsitePoliciesData>>();
    auto sandboxExtensionHandle = decoder.decode<std::optional<WebKit::SandboxExtension::Handle>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::PolicyDecision {
            WTFMove(*isNavigatingToAppBoundDomain),
            WTFMove(*policyAction),
            WTFMove(*navigationID),
            WTFMove(*downloadID),
            WTFMove(*websitePoliciesData),
            WTFMove(*sandboxExtensionHandle)
        }
    };
}

void ArgumentCoder<WebKit::HTTPBody>::encode(Encoder& encoder, const WebKit::HTTPBody& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elements)>, Vector<WebKit::HTTPBody::Element>>);
    struct ShouldBeSameSizeAsHTTPBody : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::HTTPBody>, false> {
        String contentType;
        Vector<WebKit::HTTPBody::Element> elements;
    };
    static_assert(sizeof(ShouldBeSameSizeAsHTTPBody) == sizeof(WebKit::HTTPBody));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::HTTPBody, contentType)
        , offsetof(WebKit::HTTPBody, elements)
    >::value);
    encoder << instance.contentType;
    encoder << instance.elements;
}

std::optional<WebKit::HTTPBody> ArgumentCoder<WebKit::HTTPBody>::decode(Decoder& decoder)
{
    auto contentType = decoder.decode<String>();
    auto elements = decoder.decode<Vector<WebKit::HTTPBody::Element>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::HTTPBody {
            WTFMove(*contentType),
            WTFMove(*elements)
        }
    };
}

void ArgumentCoder<WebKit::HTTPBody::Element>::encode(Encoder& encoder, const WebKit::HTTPBody::Element& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, std::variant<Vector<uint8_t>, WebKit::HTTPBody::Element::FileData, String>>);
    struct ShouldBeSameSizeAsElement : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::HTTPBody::Element>, false> {
        std::variant<Vector<uint8_t>, WebKit::HTTPBody::Element::FileData, String> data;
    };
    static_assert(sizeof(ShouldBeSameSizeAsElement) == sizeof(WebKit::HTTPBody::Element));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::HTTPBody::Element, data)
    >::value);
    encoder << instance.data;
}

std::optional<WebKit::HTTPBody::Element> ArgumentCoder<WebKit::HTTPBody::Element>::decode(Decoder& decoder)
{
    auto data = decoder.decode<std::variant<Vector<uint8_t>, WebKit::HTTPBody::Element::FileData, String>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::HTTPBody::Element {
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebKit::HTTPBody::Element::FileData>::encode(Encoder& encoder, const WebKit::HTTPBody::Element::FileData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.filePath)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileStart)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileLength)>, std::optional<int64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expectedFileModificationTime)>, std::optional<WallTime>>);
    struct ShouldBeSameSizeAsFileData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::HTTPBody::Element::FileData>, false> {
        String filePath;
        int64_t fileStart;
        std::optional<int64_t> fileLength;
        std::optional<WallTime> expectedFileModificationTime;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFileData) == sizeof(WebKit::HTTPBody::Element::FileData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::HTTPBody::Element::FileData, filePath)
        , offsetof(WebKit::HTTPBody::Element::FileData, fileStart)
        , offsetof(WebKit::HTTPBody::Element::FileData, fileLength)
        , offsetof(WebKit::HTTPBody::Element::FileData, expectedFileModificationTime)
    >::value);
    encoder << instance.filePath;
    encoder << instance.fileStart;
    encoder << instance.fileLength;
    encoder << instance.expectedFileModificationTime;
}

std::optional<WebKit::HTTPBody::Element::FileData> ArgumentCoder<WebKit::HTTPBody::Element::FileData>::decode(Decoder& decoder)
{
    auto filePath = decoder.decode<String>();
    auto fileStart = decoder.decode<int64_t>();
    auto fileLength = decoder.decode<std::optional<int64_t>>();
    auto expectedFileModificationTime = decoder.decode<std::optional<WallTime>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::HTTPBody::Element::FileData {
            WTFMove(*filePath),
            WTFMove(*fileStart),
            WTFMove(*fileLength),
            WTFMove(*expectedFileModificationTime)
        }
    };
}

void ArgumentCoder<WebKit::FrameState>::encode(Encoder& encoder, const WebKit::FrameState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.urlString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originalURLString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrer)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.target)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stateObjectData)>, std::optional<Vector<uint8_t>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentSequenceNumber)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.itemSequenceNumber)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollPosition)>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldRestoreScrollPosition)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageScaleFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpBody)>, std::optional<WebKit::HTTPBody>>);
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.exposedContentRect)>, WebCore::FloatRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unobscuredContentRect)>, WebCore::IntRect>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.minimumLayoutSizeInScrollViewCoordinates)>, WebCore::FloatSize>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentSize)>, WebCore::IntSize>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scaleIsInitial)>, bool>);
#endif
#if PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.obscuredInsets)>, WebCore::FloatBoxExtent>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebKit::FrameState>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_documentState)>, Vector<AtomString>>);
    struct ShouldBeSameSizeAsFrameState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::FrameState>, false> {
        String urlString;
        String originalURLString;
        String referrer;
        AtomString target;
        std::optional<Vector<uint8_t>> stateObjectData;
        int64_t documentSequenceNumber;
        int64_t itemSequenceNumber;
        WebCore::IntPoint scrollPosition;
        bool shouldRestoreScrollPosition;
        float pageScaleFactor;
        std::optional<WebKit::HTTPBody> httpBody;
#if PLATFORM(IOS_FAMILY)
        WebCore::FloatRect exposedContentRect;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntRect unobscuredContentRect;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::FloatSize minimumLayoutSizeInScrollViewCoordinates;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::IntSize contentSize;
#endif
#if PLATFORM(IOS_FAMILY)
        bool scaleIsInitial;
#endif
#if PLATFORM(IOS_FAMILY)
        WebCore::FloatBoxExtent obscuredInsets;
#endif
        Vector<WebKit::FrameState> children;
        Vector<AtomString> m_documentState;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFrameState) == sizeof(WebKit::FrameState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::FrameState, urlString)
        , offsetof(WebKit::FrameState, originalURLString)
        , offsetof(WebKit::FrameState, referrer)
        , offsetof(WebKit::FrameState, target)
        , offsetof(WebKit::FrameState, stateObjectData)
        , offsetof(WebKit::FrameState, documentSequenceNumber)
        , offsetof(WebKit::FrameState, itemSequenceNumber)
        , offsetof(WebKit::FrameState, scrollPosition)
        , offsetof(WebKit::FrameState, shouldRestoreScrollPosition)
        , offsetof(WebKit::FrameState, pageScaleFactor)
        , offsetof(WebKit::FrameState, httpBody)
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::FrameState, exposedContentRect)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::FrameState, unobscuredContentRect)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::FrameState, minimumLayoutSizeInScrollViewCoordinates)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::FrameState, contentSize)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::FrameState, scaleIsInitial)
#endif
#if PLATFORM(IOS_FAMILY)
        , offsetof(WebKit::FrameState, obscuredInsets)
#endif
        , offsetof(WebKit::FrameState, children)
        , offsetof(WebKit::FrameState, m_documentState)
    >::value);
    encoder << instance.urlString;
    encoder << instance.originalURLString;
    encoder << instance.referrer;
    encoder << instance.target;
    encoder << instance.stateObjectData;
    encoder << instance.documentSequenceNumber;
    encoder << instance.itemSequenceNumber;
    encoder << instance.scrollPosition;
    encoder << instance.shouldRestoreScrollPosition;
    encoder << instance.pageScaleFactor;
    encoder << instance.httpBody;
#if PLATFORM(IOS_FAMILY)
    encoder << instance.exposedContentRect;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.unobscuredContentRect;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.minimumLayoutSizeInScrollViewCoordinates;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.contentSize;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.scaleIsInitial;
#endif
#if PLATFORM(IOS_FAMILY)
    encoder << instance.obscuredInsets;
#endif
    encoder << instance.children;
    encoder << instance.m_documentState;
}

std::optional<WebKit::FrameState> ArgumentCoder<WebKit::FrameState>::decode(Decoder& decoder)
{
    auto urlString = decoder.decode<String>();
    auto originalURLString = decoder.decode<String>();
    auto referrer = decoder.decode<String>();
    auto target = decoder.decode<AtomString>();
    auto stateObjectData = decoder.decode<std::optional<Vector<uint8_t>>>();
    auto documentSequenceNumber = decoder.decode<int64_t>();
    auto itemSequenceNumber = decoder.decode<int64_t>();
    auto scrollPosition = decoder.decode<WebCore::IntPoint>();
    auto shouldRestoreScrollPosition = decoder.decode<bool>();
    auto pageScaleFactor = decoder.decode<float>();
    auto httpBody = decoder.decode<std::optional<WebKit::HTTPBody>>();
#if PLATFORM(IOS_FAMILY)
    auto exposedContentRect = decoder.decode<WebCore::FloatRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto unobscuredContentRect = decoder.decode<WebCore::IntRect>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto minimumLayoutSizeInScrollViewCoordinates = decoder.decode<WebCore::FloatSize>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto contentSize = decoder.decode<WebCore::IntSize>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto scaleIsInitial = decoder.decode<bool>();
#endif
#if PLATFORM(IOS_FAMILY)
    auto obscuredInsets = decoder.decode<WebCore::FloatBoxExtent>();
#endif
    auto children = decoder.decode<Vector<WebKit::FrameState>>();
    auto m_documentState = decoder.decode<Vector<AtomString>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(WebKit::FrameState::validateDocumentState(*m_documentState)))
        return std::nullopt;
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    WebKit::FrameState result;
    result.urlString = WTFMove(*urlString);
    result.originalURLString = WTFMove(*originalURLString);
    result.referrer = WTFMove(*referrer);
    result.target = WTFMove(*target);
    result.stateObjectData = WTFMove(*stateObjectData);
    result.documentSequenceNumber = WTFMove(*documentSequenceNumber);
    result.itemSequenceNumber = WTFMove(*itemSequenceNumber);
    result.scrollPosition = WTFMove(*scrollPosition);
    result.shouldRestoreScrollPosition = WTFMove(*shouldRestoreScrollPosition);
    result.pageScaleFactor = WTFMove(*pageScaleFactor);
    result.httpBody = WTFMove(*httpBody);
#if PLATFORM(IOS_FAMILY)
    result.exposedContentRect = WTFMove(*exposedContentRect);
#endif
#if PLATFORM(IOS_FAMILY)
    result.unobscuredContentRect = WTFMove(*unobscuredContentRect);
#endif
#if PLATFORM(IOS_FAMILY)
    result.minimumLayoutSizeInScrollViewCoordinates = WTFMove(*minimumLayoutSizeInScrollViewCoordinates);
#endif
#if PLATFORM(IOS_FAMILY)
    result.contentSize = WTFMove(*contentSize);
#endif
#if PLATFORM(IOS_FAMILY)
    result.scaleIsInitial = WTFMove(*scaleIsInitial);
#endif
#if PLATFORM(IOS_FAMILY)
    result.obscuredInsets = WTFMove(*obscuredInsets);
#endif
    result.children = WTFMove(*children);
    result.m_documentState = WTFMove(*m_documentState);
    return { WTFMove(result) };
}

void ArgumentCoder<WebKit::PageState>::encode(Encoder& encoder, const WebKit::PageState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mainFrameState)>, WebKit::FrameState>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldOpenExternalURLsPolicy)>, WebCore::ShouldOpenExternalURLsPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sessionStateObject)>, RefPtr<WebCore::SerializedScriptValue>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.wasCreatedByJSWithoutUserInteraction)>, bool>);
    struct ShouldBeSameSizeAsPageState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::PageState>, false> {
        String title;
        WebKit::FrameState mainFrameState;
        WebCore::ShouldOpenExternalURLsPolicy shouldOpenExternalURLsPolicy;
        RefPtr<WebCore::SerializedScriptValue> sessionStateObject;
        bool wasCreatedByJSWithoutUserInteraction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPageState) == sizeof(WebKit::PageState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::PageState, title)
        , offsetof(WebKit::PageState, mainFrameState)
        , offsetof(WebKit::PageState, shouldOpenExternalURLsPolicy)
        , offsetof(WebKit::PageState, sessionStateObject)
        , offsetof(WebKit::PageState, wasCreatedByJSWithoutUserInteraction)
    >::value);
    encoder << instance.title;
    encoder << instance.mainFrameState;
    encoder << instance.shouldOpenExternalURLsPolicy;
    encoder << instance.sessionStateObject;
    encoder << instance.wasCreatedByJSWithoutUserInteraction;
}

std::optional<WebKit::PageState> ArgumentCoder<WebKit::PageState>::decode(Decoder& decoder)
{
    auto title = decoder.decode<String>();
    auto mainFrameState = decoder.decode<WebKit::FrameState>();
    auto shouldOpenExternalURLsPolicy = decoder.decode<WebCore::ShouldOpenExternalURLsPolicy>();
    auto sessionStateObject = decoder.decode<RefPtr<WebCore::SerializedScriptValue>>();
    auto wasCreatedByJSWithoutUserInteraction = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::PageState {
            WTFMove(*title),
            WTFMove(*mainFrameState),
            WTFMove(*shouldOpenExternalURLsPolicy),
            WTFMove(*sessionStateObject),
            WTFMove(*wasCreatedByJSWithoutUserInteraction)
        }
    };
}

void ArgumentCoder<WebKit::BackForwardListItemState>::encode(Encoder& encoder, const WebKit::BackForwardListItemState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::BackForwardItemIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageState)>, WebKit::PageState>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasCachedPage)>, bool>);
#if PLATFORM(COCOA) || PLATFORM(GTK)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.snapshot)>, RefPtr<WebKit::ViewSnapshot>>);
#endif
    struct ShouldBeSameSizeAsBackForwardListItemState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::BackForwardListItemState>, false> {
        WebCore::BackForwardItemIdentifier identifier;
        WebKit::PageState pageState;
        bool hasCachedPage;
#if PLATFORM(COCOA) || PLATFORM(GTK)
        RefPtr<WebKit::ViewSnapshot> snapshot;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsBackForwardListItemState) == sizeof(WebKit::BackForwardListItemState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::BackForwardListItemState, identifier)
        , offsetof(WebKit::BackForwardListItemState, pageState)
        , offsetof(WebKit::BackForwardListItemState, hasCachedPage)
#if PLATFORM(COCOA) || PLATFORM(GTK)
        , offsetof(WebKit::BackForwardListItemState, snapshot)
#endif
    >::value);
    encoder << instance.identifier;
    encoder << instance.pageState;
    encoder << instance.hasCachedPage;
}

std::optional<WebKit::BackForwardListItemState> ArgumentCoder<WebKit::BackForwardListItemState>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::BackForwardItemIdentifier>();
    auto pageState = decoder.decode<WebKit::PageState>();
    auto hasCachedPage = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::BackForwardListItemState {
            WTFMove(*identifier),
            WTFMove(*pageState),
            WTFMove(*hasCachedPage)
        }
    };
}

void ArgumentCoder<WebKit::BackForwardListState>::encode(Encoder& encoder, const WebKit::BackForwardListState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.items)>, Vector<WebKit::BackForwardListItemState>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.currentIndex)>, std::optional<uint32_t>>);
    struct ShouldBeSameSizeAsBackForwardListState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::BackForwardListState>, false> {
        Vector<WebKit::BackForwardListItemState> items;
        std::optional<uint32_t> currentIndex;
    };
    static_assert(sizeof(ShouldBeSameSizeAsBackForwardListState) == sizeof(WebKit::BackForwardListState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::BackForwardListState, items)
        , offsetof(WebKit::BackForwardListState, currentIndex)
    >::value);
    encoder << instance.items;
    encoder << instance.currentIndex;
}

std::optional<WebKit::BackForwardListState> ArgumentCoder<WebKit::BackForwardListState>::decode(Decoder& decoder)
{
    auto items = decoder.decode<Vector<WebKit::BackForwardListItemState>>();
    auto currentIndex = decoder.decode<std::optional<uint32_t>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::BackForwardListState {
            WTFMove(*items),
            WTFMove(*currentIndex)
        }
    };
}

void ArgumentCoder<WebKit::ShareableBitmapConfiguration>::encode(Encoder& encoder, const WebKit::ShareableBitmapConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_size)>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_colorSpace)>, std::optional<WebCore::DestinationColorSpace>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isOpaque)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bytesPerPixel())>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bytesPerRow())>, unsigned>);
#if USE(CG)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_bitmapInfo)>, CGBitmapInfo>);
#endif
    encoder << instance.m_size;
    encoder << instance.m_colorSpace;
    encoder << instance.m_isOpaque;
    encoder << instance.bytesPerPixel();
    encoder << instance.bytesPerRow();
#if USE(CG)
    encoder << instance.m_bitmapInfo;
#endif
}

std::optional<WebKit::ShareableBitmapConfiguration> ArgumentCoder<WebKit::ShareableBitmapConfiguration>::decode(Decoder& decoder)
{
    auto m_size = decoder.decode<WebCore::IntSize>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(m_size->width() >= 0 && m_size->height() >= 0))
        return std::nullopt;
    auto m_colorSpace = decoder.decode<std::optional<WebCore::DestinationColorSpace>>();
    auto m_isOpaque = decoder.decode<bool>();
    auto bytesPerPixel = decoder.decode<unsigned>();
    auto bytesPerRow = decoder.decode<unsigned>();
#if USE(CG)
    auto m_bitmapInfo = decoder.decode<CGBitmapInfo>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::ShareableBitmapConfiguration {
            WTFMove(*m_size),
            WTFMove(*m_colorSpace),
            WTFMove(*m_isOpaque),
            WTFMove(*bytesPerPixel),
            WTFMove(*bytesPerRow),
#if USE(CG)
            WTFMove(*m_bitmapInfo)
#endif
        }
    };
}

void ArgumentCoder<WebKit::ShareableBitmapHandle>::encode(Encoder& encoder, WebKit::ShareableBitmapHandle&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_handle)>, WebKit::SharedMemoryHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_configuration)>, WebKit::ShareableBitmapConfiguration>);
    struct ShouldBeSameSizeAsShareableBitmapHandle : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::ShareableBitmapHandle>, false> {
        WebKit::SharedMemoryHandle m_handle;
        WebKit::ShareableBitmapConfiguration m_configuration;
    };
    static_assert(sizeof(ShouldBeSameSizeAsShareableBitmapHandle) == sizeof(WebKit::ShareableBitmapHandle));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::ShareableBitmapHandle, m_handle)
        , offsetof(WebKit::ShareableBitmapHandle, m_configuration)
    >::value);
    encoder << WTFMove(instance.m_handle);
    encoder << WTFMove(instance.m_configuration);
}

std::optional<WebKit::ShareableBitmapHandle> ArgumentCoder<WebKit::ShareableBitmapHandle>::decode(Decoder& decoder)
{
    auto m_handle = decoder.decode<WebKit::SharedMemoryHandle>();
    auto m_configuration = decoder.decode<WebKit::ShareableBitmapConfiguration>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(!m_configuration->sizeInBytes().hasOverflowed() && m_handle->size() >= m_configuration->sizeInBytes()))
        return std::nullopt;
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::ShareableBitmapHandle {
            WTFMove(*m_handle),
            WTFMove(*m_configuration)
        }
    };
}

void ArgumentCoder<WebKit::ShareableBitmap>::encode(Encoder& encoder, const WebKit::ShareableBitmap& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.createReadOnlyHandle())>, std::optional<WebKit::ShareableBitmapHandle>>);
    encoder << instance.createReadOnlyHandle();
}

std::optional<Ref<WebKit::ShareableBitmap>> ArgumentCoder<WebKit::ShareableBitmap>::decode(Decoder& decoder)
{
    auto createReadOnlyHandle = decoder.decode<std::optional<WebKit::ShareableBitmapHandle>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::ShareableBitmap::createReadOnly(
            WTFMove(*createReadOnlyHandle)
        )
    };
}

#if ENABLE(IMAGE_ANALYSIS)
void ArgumentCoder<WebCore::TextRecognitionWordData>::encode(Encoder& encoder, const WebCore::TextRecognitionWordData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.normalizedQuad)>, WebCore::FloatQuad>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasLeadingWhitespace)>, bool>);
    struct ShouldBeSameSizeAsTextRecognitionWordData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextRecognitionWordData>, false> {
        String text;
        WebCore::FloatQuad normalizedQuad;
        bool hasLeadingWhitespace;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextRecognitionWordData) == sizeof(WebCore::TextRecognitionWordData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextRecognitionWordData, text)
        , offsetof(WebCore::TextRecognitionWordData, normalizedQuad)
        , offsetof(WebCore::TextRecognitionWordData, hasLeadingWhitespace)
    >::value);
    encoder << instance.text;
    encoder << instance.normalizedQuad;
    encoder << instance.hasLeadingWhitespace;
}

std::optional<WebCore::TextRecognitionWordData> ArgumentCoder<WebCore::TextRecognitionWordData>::decode(Decoder& decoder)
{
    auto text = decoder.decode<String>();
    auto normalizedQuad = decoder.decode<WebCore::FloatQuad>();
    auto hasLeadingWhitespace = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextRecognitionWordData {
            WTFMove(*text),
            WTFMove(*normalizedQuad),
            WTFMove(*hasLeadingWhitespace)
        }
    };
}

#endif

#if ENABLE(IMAGE_ANALYSIS)
void ArgumentCoder<WebCore::TextRecognitionLineData>::encode(Encoder& encoder, const WebCore::TextRecognitionLineData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.normalizedQuad)>, WebCore::FloatQuad>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.children)>, Vector<WebCore::TextRecognitionWordData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasTrailingNewline)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isVertical)>, bool>);
    struct ShouldBeSameSizeAsTextRecognitionLineData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextRecognitionLineData>, false> {
        WebCore::FloatQuad normalizedQuad;
        Vector<WebCore::TextRecognitionWordData> children;
        bool hasTrailingNewline;
        bool isVertical;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextRecognitionLineData) == sizeof(WebCore::TextRecognitionLineData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextRecognitionLineData, normalizedQuad)
        , offsetof(WebCore::TextRecognitionLineData, children)
        , offsetof(WebCore::TextRecognitionLineData, hasTrailingNewline)
        , offsetof(WebCore::TextRecognitionLineData, isVertical)
    >::value);
    encoder << instance.normalizedQuad;
    encoder << instance.children;
    encoder << instance.hasTrailingNewline;
    encoder << instance.isVertical;
}

std::optional<WebCore::TextRecognitionLineData> ArgumentCoder<WebCore::TextRecognitionLineData>::decode(Decoder& decoder)
{
    auto normalizedQuad = decoder.decode<WebCore::FloatQuad>();
    auto children = decoder.decode<Vector<WebCore::TextRecognitionWordData>>();
    auto hasTrailingNewline = decoder.decode<bool>();
    auto isVertical = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextRecognitionLineData {
            WTFMove(*normalizedQuad),
            WTFMove(*children),
            WTFMove(*hasTrailingNewline),
            WTFMove(*isVertical)
        }
    };
}

#endif

#if ENABLE(IMAGE_ANALYSIS)
void ArgumentCoder<WebCore::TextRecognitionBlockData>::encode(Encoder& encoder, const WebCore::TextRecognitionBlockData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.normalizedQuad)>, WebCore::FloatQuad>);
    struct ShouldBeSameSizeAsTextRecognitionBlockData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextRecognitionBlockData>, false> {
        String text;
        WebCore::FloatQuad normalizedQuad;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextRecognitionBlockData) == sizeof(WebCore::TextRecognitionBlockData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextRecognitionBlockData, text)
        , offsetof(WebCore::TextRecognitionBlockData, normalizedQuad)
    >::value);
    encoder << instance.text;
    encoder << instance.normalizedQuad;
}

std::optional<WebCore::TextRecognitionBlockData> ArgumentCoder<WebCore::TextRecognitionBlockData>::decode(Decoder& decoder)
{
    auto text = decoder.decode<String>();
    auto normalizedQuad = decoder.decode<WebCore::FloatQuad>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextRecognitionBlockData {
            WTFMove(*text),
            WTFMove(*normalizedQuad)
        }
    };
}

#endif

#if ENABLE(IMAGE_ANALYSIS)
void ArgumentCoder<WebCore::TextRecognitionResult>::encode(Encoder& encoder, const WebCore::TextRecognitionResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lines)>, Vector<WebCore::TextRecognitionLineData>>);
#if ENABLE(DATA_DETECTION)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataDetectors)>, Vector<WebCore::TextRecognitionDataDetector>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blocks)>, Vector<WebCore::TextRecognitionBlockData>>);
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.platformData)>, RetainPtr<VKCImageAnalysis>>);
#endif
    struct ShouldBeSameSizeAsTextRecognitionResult : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextRecognitionResult>, false> {
        Vector<WebCore::TextRecognitionLineData> lines;
#if ENABLE(DATA_DETECTION)
        Vector<WebCore::TextRecognitionDataDetector> dataDetectors;
#endif
        Vector<WebCore::TextRecognitionBlockData> blocks;
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        RetainPtr<VKCImageAnalysis> platformData;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextRecognitionResult) == sizeof(WebCore::TextRecognitionResult));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextRecognitionResult, lines)
#if ENABLE(DATA_DETECTION)
        , offsetof(WebCore::TextRecognitionResult, dataDetectors)
#endif
        , offsetof(WebCore::TextRecognitionResult, blocks)
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
        , offsetof(WebCore::TextRecognitionResult, platformData)
#endif
    >::value);
    encoder << instance.lines;
#if ENABLE(DATA_DETECTION)
    encoder << instance.dataDetectors;
#endif
    encoder << instance.blocks;
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    encoder << instance.platformData;
#endif
}

std::optional<WebCore::TextRecognitionResult> ArgumentCoder<WebCore::TextRecognitionResult>::decode(Decoder& decoder)
{
    auto lines = decoder.decode<Vector<WebCore::TextRecognitionLineData>>();
#if ENABLE(DATA_DETECTION)
    auto dataDetectors = decoder.decode<Vector<WebCore::TextRecognitionDataDetector>>();
#endif
    auto blocks = decoder.decode<Vector<WebCore::TextRecognitionBlockData>>();
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
    auto platformData = decoder.decode<RetainPtr<VKCImageAnalysis>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextRecognitionResult {
            WTFMove(*lines),
#if ENABLE(DATA_DETECTION)
            WTFMove(*dataDetectors),
#endif
            WTFMove(*blocks),
#if ENABLE(IMAGE_ANALYSIS_ENHANCEMENTS)
            WTFMove(*platformData)
#endif
        }
    };
}

#endif

#if USE(COORDINATED_GRAPHICS) || USE(TEXTURE_MAPPER)
void ArgumentCoder<WebKit::UpdateInfo>::encode(Encoder& encoder, WebKit::UpdateInfo&& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.viewSize)>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.deviceScaleFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollRect)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollOffset)>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateRectBounds)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateRects)>, Vector<WebCore::IntRect>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateScaleFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bitmapHandle)>, WebKit::ShareableBitmapHandle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bitmapOffset)>, WebCore::IntPoint>);
    struct ShouldBeSameSizeAsUpdateInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebKit::UpdateInfo>, false> {
        WebCore::IntSize viewSize;
        float deviceScaleFactor;
        WebCore::IntRect scrollRect;
        WebCore::IntSize scrollOffset;
        WebCore::IntRect updateRectBounds;
        Vector<WebCore::IntRect> updateRects;
        float updateScaleFactor;
        WebKit::ShareableBitmapHandle bitmapHandle;
        WebCore::IntPoint bitmapOffset;
    };
    static_assert(sizeof(ShouldBeSameSizeAsUpdateInfo) == sizeof(WebKit::UpdateInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebKit::UpdateInfo, viewSize)
        , offsetof(WebKit::UpdateInfo, deviceScaleFactor)
        , offsetof(WebKit::UpdateInfo, scrollRect)
        , offsetof(WebKit::UpdateInfo, scrollOffset)
        , offsetof(WebKit::UpdateInfo, updateRectBounds)
        , offsetof(WebKit::UpdateInfo, updateRects)
        , offsetof(WebKit::UpdateInfo, updateScaleFactor)
        , offsetof(WebKit::UpdateInfo, bitmapHandle)
        , offsetof(WebKit::UpdateInfo, bitmapOffset)
    >::value);
    encoder << WTFMove(instance.viewSize);
    encoder << WTFMove(instance.deviceScaleFactor);
    encoder << WTFMove(instance.scrollRect);
    encoder << WTFMove(instance.scrollOffset);
    encoder << WTFMove(instance.updateRectBounds);
    encoder << WTFMove(instance.updateRects);
    encoder << WTFMove(instance.updateScaleFactor);
    encoder << WTFMove(instance.bitmapHandle);
    encoder << WTFMove(instance.bitmapOffset);
}

std::optional<WebKit::UpdateInfo> ArgumentCoder<WebKit::UpdateInfo>::decode(Decoder& decoder)
{
    auto viewSize = decoder.decode<WebCore::IntSize>();
    auto deviceScaleFactor = decoder.decode<float>();
    auto scrollRect = decoder.decode<WebCore::IntRect>();
    auto scrollOffset = decoder.decode<WebCore::IntSize>();
    auto updateRectBounds = decoder.decode<WebCore::IntRect>();
    auto updateRects = decoder.decode<Vector<WebCore::IntRect>>();
    auto updateScaleFactor = decoder.decode<float>();
    auto bitmapHandle = decoder.decode<WebKit::ShareableBitmapHandle>();
    auto bitmapOffset = decoder.decode<WebCore::IntPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebKit::UpdateInfo {
            WTFMove(*viewSize),
            WTFMove(*deviceScaleFactor),
            WTFMove(*scrollRect),
            WTFMove(*scrollOffset),
            WTFMove(*updateRectBounds),
            WTFMove(*updateRects),
            WTFMove(*updateScaleFactor),
            WTFMove(*bitmapHandle),
            WTFMove(*bitmapOffset)
        }
    };
}

#endif

void ArgumentCoder<WTF::URL>::encode(Encoder& encoder, const WTF::URL& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.string())>, String>);
    encoder << instance.string();
}

std::optional<WTF::URL> ArgumentCoder<WTF::URL>::decode(Decoder& decoder)
{
    auto string = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WTF::URL {
            WTFMove(*string)
        }
    };
}

void ArgumentCoder<WTF::MediaTime>::encode(Encoder& encoder, const WTF::MediaTime& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeValue())>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeScale())>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeFlags())>, uint8_t>);
    encoder << instance.timeValue();
    encoder << instance.timeScale();
    encoder << instance.timeFlags();
}

void ArgumentCoder<WTF::MediaTime>::encode(StreamConnectionEncoder& encoder, const WTF::MediaTime& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeValue())>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeScale())>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeFlags())>, uint8_t>);
    encoder << instance.timeValue();
    encoder << instance.timeScale();
    encoder << instance.timeFlags();
}

std::optional<WTF::MediaTime> ArgumentCoder<WTF::MediaTime>::decode(Decoder& decoder)
{
    auto timeValue = decoder.decode<int64_t>();
    auto timeScale = decoder.decode<uint32_t>();
    auto timeFlags = decoder.decode<uint8_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WTF::MediaTime {
            WTFMove(*timeValue),
            WTFMove(*timeScale),
            WTFMove(*timeFlags)
        }
    };
}

void ArgumentCoder<WTF::Seconds>::encode(Encoder& encoder, const WTF::Seconds& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, double>);
    encoder << instance.value();
}

void ArgumentCoder<WTF::Seconds>::encode(StreamConnectionEncoder& encoder, const WTF::Seconds& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, double>);
    encoder << instance.value();
}

std::optional<WTF::Seconds> ArgumentCoder<WTF::Seconds>::decode(Decoder& decoder)
{
    auto value = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WTF::Seconds {
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WTF::MonotonicTime>::encode(Encoder& encoder, const WTF::MonotonicTime& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.secondsSinceEpoch().seconds())>, double>);
    encoder << instance.secondsSinceEpoch().seconds();
}

std::optional<WTF::MonotonicTime> ArgumentCoder<WTF::MonotonicTime>::decode(Decoder& decoder)
{
    auto secondsSinceEpochseconds = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WTF::MonotonicTime::fromRawSeconds(
            WTFMove(*secondsSinceEpochseconds)
        )
    };
}

void ArgumentCoder<WTF::WallTime>::encode(Encoder& encoder, const WTF::WallTime& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.secondsSinceEpoch().seconds())>, double>);
    encoder << instance.secondsSinceEpoch().seconds();
}

std::optional<WTF::WallTime> ArgumentCoder<WTF::WallTime>::decode(Decoder& decoder)
{
    auto secondsSinceEpochseconds = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WTF::WallTime::fromRawSeconds(
            WTFMove(*secondsSinceEpochseconds)
        )
    };
}

void ArgumentCoder<WTF::AtomString>::encode(Encoder& encoder, const WTF::AtomString& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.string())>, String>);
    encoder << instance.string();
}

void ArgumentCoder<WTF::AtomString>::encode(StreamConnectionEncoder& encoder, const WTF::AtomString& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.string())>, String>);
    encoder << instance.string();
}

std::optional<WTF::AtomString> ArgumentCoder<WTF::AtomString>::decode(Decoder& decoder)
{
    auto string = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WTF::AtomString {
            WTFMove(*string)
        }
    };
}

void ArgumentCoder<WebCore::DOMCacheEngine::CacheInfo>::encode(Encoder& encoder, const WebCore::DOMCacheEngine::CacheInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::DOMCacheIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    struct ShouldBeSameSizeAsCacheInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DOMCacheEngine::CacheInfo>, false> {
        WebCore::DOMCacheIdentifier identifier;
        String name;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCacheInfo) == sizeof(WebCore::DOMCacheEngine::CacheInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DOMCacheEngine::CacheInfo, identifier)
        , offsetof(WebCore::DOMCacheEngine::CacheInfo, name)
    >::value);
    encoder << instance.identifier;
    encoder << instance.name;
}

std::optional<WebCore::DOMCacheEngine::CacheInfo> ArgumentCoder<WebCore::DOMCacheEngine::CacheInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::DOMCacheIdentifier>();
    auto name = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DOMCacheEngine::CacheInfo {
            WTFMove(*identifier),
            WTFMove(*name)
        }
    };
}

void ArgumentCoder<WebCore::DOMCacheEngine::CacheInfos>::encode(Encoder& encoder, const WebCore::DOMCacheEngine::CacheInfos& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.infos)>, Vector<WebCore::DOMCacheEngine::CacheInfo>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateCounter)>, uint64_t>);
    struct ShouldBeSameSizeAsCacheInfos : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DOMCacheEngine::CacheInfos>, false> {
        Vector<WebCore::DOMCacheEngine::CacheInfo> infos;
        uint64_t updateCounter;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCacheInfos) == sizeof(WebCore::DOMCacheEngine::CacheInfos));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DOMCacheEngine::CacheInfos, infos)
        , offsetof(WebCore::DOMCacheEngine::CacheInfos, updateCounter)
    >::value);
    encoder << instance.infos;
    encoder << instance.updateCounter;
}

std::optional<WebCore::DOMCacheEngine::CacheInfos> ArgumentCoder<WebCore::DOMCacheEngine::CacheInfos>::decode(Decoder& decoder)
{
    auto infos = decoder.decode<Vector<WebCore::DOMCacheEngine::CacheInfo>>();
    auto updateCounter = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DOMCacheEngine::CacheInfos {
            WTFMove(*infos),
            WTFMove(*updateCounter)
        }
    };
}

void ArgumentCoder<WebCore::DOMCacheEngine::CacheIdentifierOperationResult>::encode(Encoder& encoder, const WebCore::DOMCacheEngine::CacheIdentifierOperationResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::DOMCacheIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hadStorageError)>, bool>);
    struct ShouldBeSameSizeAsCacheIdentifierOperationResult : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DOMCacheEngine::CacheIdentifierOperationResult>, false> {
        WebCore::DOMCacheIdentifier identifier;
        bool hadStorageError;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCacheIdentifierOperationResult) == sizeof(WebCore::DOMCacheEngine::CacheIdentifierOperationResult));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DOMCacheEngine::CacheIdentifierOperationResult, identifier)
        , offsetof(WebCore::DOMCacheEngine::CacheIdentifierOperationResult, hadStorageError)
    >::value);
    encoder << instance.identifier;
    encoder << instance.hadStorageError;
}

std::optional<WebCore::DOMCacheEngine::CacheIdentifierOperationResult> ArgumentCoder<WebCore::DOMCacheEngine::CacheIdentifierOperationResult>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::DOMCacheIdentifier>();
    auto hadStorageError = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DOMCacheEngine::CacheIdentifierOperationResult {
            WTFMove(*identifier),
            WTFMove(*hadStorageError)
        }
    };
}

#if HAVE(TRANSLATION_UI_SERVICES) && ENABLE(CONTEXT_MENUS)
void ArgumentCoder<WebCore::TranslationContextMenuInfo>::encode(Encoder& encoder, const WebCore::TranslationContextMenuInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionBoundsInRootView)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.locationInRootView)>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mode)>, WebCore::TranslationContextMenuMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.source)>, WebCore::TranslationContextMenuSource>);
    struct ShouldBeSameSizeAsTranslationContextMenuInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TranslationContextMenuInfo>, false> {
        String text;
        WebCore::IntRect selectionBoundsInRootView;
        WebCore::IntPoint locationInRootView;
        WebCore::TranslationContextMenuMode mode;
        WebCore::TranslationContextMenuSource source;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTranslationContextMenuInfo) == sizeof(WebCore::TranslationContextMenuInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TranslationContextMenuInfo, text)
        , offsetof(WebCore::TranslationContextMenuInfo, selectionBoundsInRootView)
        , offsetof(WebCore::TranslationContextMenuInfo, locationInRootView)
        , offsetof(WebCore::TranslationContextMenuInfo, mode)
        , offsetof(WebCore::TranslationContextMenuInfo, source)
    >::value);
    encoder << instance.text;
    encoder << instance.selectionBoundsInRootView;
    encoder << instance.locationInRootView;
    encoder << instance.mode;
    encoder << instance.source;
}

std::optional<WebCore::TranslationContextMenuInfo> ArgumentCoder<WebCore::TranslationContextMenuInfo>::decode(Decoder& decoder)
{
    auto text = decoder.decode<String>();
    auto selectionBoundsInRootView = decoder.decode<WebCore::IntRect>();
    auto locationInRootView = decoder.decode<WebCore::IntPoint>();
    auto mode = decoder.decode<WebCore::TranslationContextMenuMode>();
    auto source = decoder.decode<WebCore::TranslationContextMenuSource>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TranslationContextMenuInfo {
            WTFMove(*text),
            WTFMove(*selectionBoundsInRootView),
            WTFMove(*locationInRootView),
            WTFMove(*mode),
            WTFMove(*source)
        }
    };
}

#endif

void ArgumentCoder<WebCore::DOMCacheEngine::CrossThreadRecord>::encode(Encoder& encoder, const WebCore::DOMCacheEngine::CrossThreadRecord& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.updateResponseCounter)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requestHeadersGuard)>, WebCore::FetchHeadersGuard>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, WebCore::FetchOptions>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrer)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.responseHeadersGuard)>, WebCore::FetchHeadersGuard>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.response)>, WebCore::ResourceResponse::CrossThreadData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.responseBody)>, std::variant<std::nullptr_t, Ref<WebCore::FormData>, Ref<WebCore::SharedBuffer>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.responseBodySize)>, uint64_t>);
    struct ShouldBeSameSizeAsCrossThreadRecord : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DOMCacheEngine::CrossThreadRecord>, false> {
        uint64_t identifier;
        uint64_t updateResponseCounter;
        WebCore::FetchHeadersGuard requestHeadersGuard;
        WebCore::ResourceRequest request;
        WebCore::FetchOptions options;
        String referrer;
        WebCore::FetchHeadersGuard responseHeadersGuard;
        WebCore::ResourceResponse::CrossThreadData response;
        std::variant<std::nullptr_t, Ref<WebCore::FormData>, Ref<WebCore::SharedBuffer>> responseBody;
        uint64_t responseBodySize;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCrossThreadRecord) == sizeof(WebCore::DOMCacheEngine::CrossThreadRecord));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, identifier)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, updateResponseCounter)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, requestHeadersGuard)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, request)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, options)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, referrer)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, responseHeadersGuard)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, response)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, responseBody)
        , offsetof(WebCore::DOMCacheEngine::CrossThreadRecord, responseBodySize)
    >::value);
    encoder << instance.identifier;
    encoder << instance.updateResponseCounter;
    encoder << instance.requestHeadersGuard;
    encoder << instance.request;
    encoder << instance.options;
    encoder << instance.referrer;
    encoder << instance.responseHeadersGuard;
    encoder << instance.response;
    encoder << instance.responseBody;
    encoder << instance.responseBodySize;
}

std::optional<WebCore::DOMCacheEngine::CrossThreadRecord> ArgumentCoder<WebCore::DOMCacheEngine::CrossThreadRecord>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<uint64_t>();
    auto updateResponseCounter = decoder.decode<uint64_t>();
    auto requestHeadersGuard = decoder.decode<WebCore::FetchHeadersGuard>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    auto options = decoder.decode<WebCore::FetchOptions>();
    auto referrer = decoder.decode<String>();
    auto responseHeadersGuard = decoder.decode<WebCore::FetchHeadersGuard>();
    auto response = decoder.decode<WebCore::ResourceResponse::CrossThreadData>();
    auto responseBody = decoder.decode<std::variant<std::nullptr_t, Ref<WebCore::FormData>, Ref<WebCore::SharedBuffer>>>();
    auto responseBodySize = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DOMCacheEngine::CrossThreadRecord {
            WTFMove(*identifier),
            WTFMove(*updateResponseCounter),
            WTFMove(*requestHeadersGuard),
            WTFMove(*request),
            WTFMove(*options),
            WTFMove(*referrer),
            WTFMove(*responseHeadersGuard),
            WTFMove(*response),
            WTFMove(*responseBody),
            WTFMove(*responseBodySize)
        }
    };
}

void ArgumentCoder<WebCore::TransformationMatrix>::encode(Encoder& encoder, const WebCore::TransformationMatrix& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m11())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m12())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m13())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m14())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m21())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m22())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m23())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m24())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m31())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m32())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m33())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m34())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m41())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m42())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m43())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m44())>, double>);
    encoder << instance.m11();
    encoder << instance.m12();
    encoder << instance.m13();
    encoder << instance.m14();
    encoder << instance.m21();
    encoder << instance.m22();
    encoder << instance.m23();
    encoder << instance.m24();
    encoder << instance.m31();
    encoder << instance.m32();
    encoder << instance.m33();
    encoder << instance.m34();
    encoder << instance.m41();
    encoder << instance.m42();
    encoder << instance.m43();
    encoder << instance.m44();
}

void ArgumentCoder<WebCore::TransformationMatrix>::encode(StreamConnectionEncoder& encoder, const WebCore::TransformationMatrix& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m11())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m12())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m13())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m14())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m21())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m22())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m23())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m24())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m31())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m32())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m33())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m34())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m41())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m42())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m43())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m44())>, double>);
    encoder << instance.m11();
    encoder << instance.m12();
    encoder << instance.m13();
    encoder << instance.m14();
    encoder << instance.m21();
    encoder << instance.m22();
    encoder << instance.m23();
    encoder << instance.m24();
    encoder << instance.m31();
    encoder << instance.m32();
    encoder << instance.m33();
    encoder << instance.m34();
    encoder << instance.m41();
    encoder << instance.m42();
    encoder << instance.m43();
    encoder << instance.m44();
}

std::optional<WebCore::TransformationMatrix> ArgumentCoder<WebCore::TransformationMatrix>::decode(Decoder& decoder)
{
    auto m11 = decoder.decode<double>();
    auto m12 = decoder.decode<double>();
    auto m13 = decoder.decode<double>();
    auto m14 = decoder.decode<double>();
    auto m21 = decoder.decode<double>();
    auto m22 = decoder.decode<double>();
    auto m23 = decoder.decode<double>();
    auto m24 = decoder.decode<double>();
    auto m31 = decoder.decode<double>();
    auto m32 = decoder.decode<double>();
    auto m33 = decoder.decode<double>();
    auto m34 = decoder.decode<double>();
    auto m41 = decoder.decode<double>();
    auto m42 = decoder.decode<double>();
    auto m43 = decoder.decode<double>();
    auto m44 = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TransformationMatrix {
            WTFMove(*m11),
            WTFMove(*m12),
            WTFMove(*m13),
            WTFMove(*m14),
            WTFMove(*m21),
            WTFMove(*m22),
            WTFMove(*m23),
            WTFMove(*m24),
            WTFMove(*m31),
            WTFMove(*m32),
            WTFMove(*m33),
            WTFMove(*m34),
            WTFMove(*m41),
            WTFMove(*m42),
            WTFMove(*m43),
            WTFMove(*m44)
        }
    };
}

void ArgumentCoder<WebCore::CacheQueryOptions>::encode(Encoder& encoder, const WebCore::CacheQueryOptions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreSearch)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreMethod)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreVary)>, bool>);
    struct ShouldBeSameSizeAsCacheQueryOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CacheQueryOptions>, false> {
        bool ignoreSearch;
        bool ignoreMethod;
        bool ignoreVary;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCacheQueryOptions) == sizeof(WebCore::CacheQueryOptions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CacheQueryOptions, ignoreSearch)
        , offsetof(WebCore::CacheQueryOptions, ignoreMethod)
        , offsetof(WebCore::CacheQueryOptions, ignoreVary)
    >::value);
    encoder << instance.ignoreSearch;
    encoder << instance.ignoreMethod;
    encoder << instance.ignoreVary;
}

std::optional<WebCore::CacheQueryOptions> ArgumentCoder<WebCore::CacheQueryOptions>::decode(Decoder& decoder)
{
    auto ignoreSearch = decoder.decode<bool>();
    auto ignoreMethod = decoder.decode<bool>();
    auto ignoreVary = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CacheQueryOptions {
            WTFMove(*ignoreSearch),
            WTFMove(*ignoreMethod),
            WTFMove(*ignoreVary)
        }
    };
}

void ArgumentCoder<WebCore::CharacterRange>::encode(Encoder& encoder, const WebCore::CharacterRange& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.length)>, uint64_t>);
    struct ShouldBeSameSizeAsCharacterRange : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CharacterRange>, false> {
        uint64_t location;
        uint64_t length;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCharacterRange) == sizeof(WebCore::CharacterRange));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CharacterRange, location)
        , offsetof(WebCore::CharacterRange, length)
    >::value);
    encoder << instance.location;
    encoder << instance.length;
}

std::optional<WebCore::CharacterRange> ArgumentCoder<WebCore::CharacterRange>::decode(Decoder& decoder)
{
    auto location = decoder.decode<uint64_t>();
    auto length = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CharacterRange {
            WTFMove(*location),
            WTFMove(*length)
        }
    };
}

void ArgumentCoder<WebCore::AffineTransform>::encode(Encoder& encoder, const WebCore::AffineTransform& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.a())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.b())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.c())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.d())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.e())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.f())>, double>);
    encoder << instance.a();
    encoder << instance.b();
    encoder << instance.c();
    encoder << instance.d();
    encoder << instance.e();
    encoder << instance.f();
}

void ArgumentCoder<WebCore::AffineTransform>::encode(StreamConnectionEncoder& encoder, const WebCore::AffineTransform& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.a())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.b())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.c())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.d())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.e())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.f())>, double>);
    encoder << instance.a();
    encoder << instance.b();
    encoder << instance.c();
    encoder << instance.d();
    encoder << instance.e();
    encoder << instance.f();
}

std::optional<WebCore::AffineTransform> ArgumentCoder<WebCore::AffineTransform>::decode(Decoder& decoder)
{
    auto a = decoder.decode<double>();
    auto b = decoder.decode<double>();
    auto c = decoder.decode<double>();
    auto d = decoder.decode<double>();
    auto e = decoder.decode<double>();
    auto f = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::AffineTransform {
            WTFMove(*a),
            WTFMove(*b),
            WTFMove(*c),
            WTFMove(*d),
            WTFMove(*e),
            WTFMove(*f)
        }
    };
}

void ArgumentCoder<WebCore::FloatPoint>::encode(Encoder& encoder, const WebCore::FloatPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, float>);
    encoder << instance.x();
    encoder << instance.y();
}

void ArgumentCoder<WebCore::FloatPoint>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, float>);
    encoder << instance.x();
    encoder << instance.y();
}

std::optional<WebCore::FloatPoint> ArgumentCoder<WebCore::FloatPoint>::decode(Decoder& decoder)
{
    auto x = decoder.decode<float>();
    auto y = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FloatPoint {
            WTFMove(*x),
            WTFMove(*y)
        }
    };
}

void ArgumentCoder<WebCore::FloatPoint3D>::encode(Encoder& encoder, const WebCore::FloatPoint3D& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.z())>, float>);
    encoder << instance.x();
    encoder << instance.y();
    encoder << instance.z();
}

void ArgumentCoder<WebCore::FloatPoint3D>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatPoint3D& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.z())>, float>);
    encoder << instance.x();
    encoder << instance.y();
    encoder << instance.z();
}

std::optional<WebCore::FloatPoint3D> ArgumentCoder<WebCore::FloatPoint3D>::decode(Decoder& decoder)
{
    auto x = decoder.decode<float>();
    auto y = decoder.decode<float>();
    auto z = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FloatPoint3D {
            WTFMove(*x),
            WTFMove(*y),
            WTFMove(*z)
        }
    };
}

void ArgumentCoder<WebCore::FloatQuad>::encode(Encoder& encoder, const WebCore::FloatQuad& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.p1())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.p2())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.p3())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.p4())>, WebCore::FloatPoint>);
    encoder << instance.p1();
    encoder << instance.p2();
    encoder << instance.p3();
    encoder << instance.p4();
}

std::optional<WebCore::FloatQuad> ArgumentCoder<WebCore::FloatQuad>::decode(Decoder& decoder)
{
    auto p1 = decoder.decode<WebCore::FloatPoint>();
    auto p2 = decoder.decode<WebCore::FloatPoint>();
    auto p3 = decoder.decode<WebCore::FloatPoint>();
    auto p4 = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FloatQuad {
            WTFMove(*p1),
            WTFMove(*p2),
            WTFMove(*p3),
            WTFMove(*p4)
        }
    };
}

void ArgumentCoder<WebCore::IDBCursorRecord>::encode(Encoder& encoder, const WebCore::IDBCursorRecord& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.key)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.primaryKey)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, WebCore::IDBValue>);
    struct ShouldBeSameSizeAsIDBCursorRecord : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBCursorRecord>, false> {
        WebCore::IDBKeyData key;
        WebCore::IDBKeyData primaryKey;
        WebCore::IDBValue value;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBCursorRecord) == sizeof(WebCore::IDBCursorRecord));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBCursorRecord, key)
        , offsetof(WebCore::IDBCursorRecord, primaryKey)
        , offsetof(WebCore::IDBCursorRecord, value)
    >::value);
    encoder << instance.key;
    encoder << instance.primaryKey;
    encoder << instance.value;
}

std::optional<WebCore::IDBCursorRecord> ArgumentCoder<WebCore::IDBCursorRecord>::decode(Decoder& decoder)
{
    auto key = decoder.decode<WebCore::IDBKeyData>();
    auto primaryKey = decoder.decode<WebCore::IDBKeyData>();
    auto value = decoder.decode<WebCore::IDBValue>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBCursorRecord {
            WTFMove(*key),
            WTFMove(*primaryKey),
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WebCore::IDBCursorInfo>::encode(Encoder& encoder, const WebCore::IDBCursorInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.transactionIdentifier())>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.objectStoreIdentifier())>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceIdentifier())>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.range())>, WebCore::IDBKeyRangeData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cursorSource())>, WebCore::IndexedDB::CursorSource>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cursorDirection())>, WebCore::IndexedDB::CursorDirection>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cursorType())>, WebCore::IndexedDB::CursorType>);
    encoder << instance.identifier();
    encoder << instance.transactionIdentifier();
    encoder << instance.objectStoreIdentifier();
    encoder << instance.sourceIdentifier();
    encoder << instance.range();
    encoder << instance.cursorSource();
    encoder << instance.cursorDirection();
    encoder << instance.cursorType();
}

std::optional<WebCore::IDBCursorInfo> ArgumentCoder<WebCore::IDBCursorInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    auto transactionIdentifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    auto objectStoreIdentifier = decoder.decode<uint64_t>();
    auto sourceIdentifier = decoder.decode<uint64_t>();
    auto range = decoder.decode<WebCore::IDBKeyRangeData>();
    auto cursorSource = decoder.decode<WebCore::IndexedDB::CursorSource>();
    auto cursorDirection = decoder.decode<WebCore::IndexedDB::CursorDirection>();
    auto cursorType = decoder.decode<WebCore::IndexedDB::CursorType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBCursorInfo {
            WTFMove(*identifier),
            WTFMove(*transactionIdentifier),
            WTFMove(*objectStoreIdentifier),
            WTFMove(*sourceIdentifier),
            WTFMove(*range),
            WTFMove(*cursorSource),
            WTFMove(*cursorDirection),
            WTFMove(*cursorType)
        }
    };
}

void ArgumentCoder<WebCore::IDBError>::encode(Encoder& encoder, const WebCore::IDBError& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.code())>, std::optional<WebCore::ExceptionCode>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.messageForSerialization())>, String>);
    encoder << instance.code();
    encoder << instance.messageForSerialization();
}

std::optional<WebCore::IDBError> ArgumentCoder<WebCore::IDBError>::decode(Decoder& decoder)
{
    auto code = decoder.decode<std::optional<WebCore::ExceptionCode>>();
    auto messageForSerialization = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBError {
            WTFMove(*code),
            WTFMove(*messageForSerialization)
        }
    };
}

void ArgumentCoder<WebCore::IDBGetAllRecordsData>::encode(Encoder& encoder, const WebCore::IDBGetAllRecordsData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyRangeData)>, WebCore::IDBKeyRangeData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.getAllType)>, WebCore::IndexedDB::GetAllType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.count)>, std::optional<uint32_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.objectStoreIdentifier)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.indexIdentifier)>, uint64_t>);
    struct ShouldBeSameSizeAsIDBGetAllRecordsData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBGetAllRecordsData>, false> {
        WebCore::IDBKeyRangeData keyRangeData;
        WebCore::IndexedDB::GetAllType getAllType;
        std::optional<uint32_t> count;
        uint64_t objectStoreIdentifier;
        uint64_t indexIdentifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBGetAllRecordsData) == sizeof(WebCore::IDBGetAllRecordsData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBGetAllRecordsData, keyRangeData)
        , offsetof(WebCore::IDBGetAllRecordsData, getAllType)
        , offsetof(WebCore::IDBGetAllRecordsData, count)
        , offsetof(WebCore::IDBGetAllRecordsData, objectStoreIdentifier)
        , offsetof(WebCore::IDBGetAllRecordsData, indexIdentifier)
    >::value);
    encoder << instance.keyRangeData;
    encoder << instance.getAllType;
    encoder << instance.count;
    encoder << instance.objectStoreIdentifier;
    encoder << instance.indexIdentifier;
}

std::optional<WebCore::IDBGetAllRecordsData> ArgumentCoder<WebCore::IDBGetAllRecordsData>::decode(Decoder& decoder)
{
    auto keyRangeData = decoder.decode<WebCore::IDBKeyRangeData>();
    auto getAllType = decoder.decode<WebCore::IndexedDB::GetAllType>();
    auto count = decoder.decode<std::optional<uint32_t>>();
    auto objectStoreIdentifier = decoder.decode<uint64_t>();
    auto indexIdentifier = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBGetAllRecordsData {
            WTFMove(*keyRangeData),
            WTFMove(*getAllType),
            WTFMove(*count),
            WTFMove(*objectStoreIdentifier),
            WTFMove(*indexIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::IDBGetResult>::encode(Encoder& encoder, const WebCore::IDBGetResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyData())>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.primaryKeyData())>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, WebCore::IDBValue>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyPath())>, std::optional<WebCore::IDBKeyPath>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.prefetchedRecords())>, Vector<WebCore::IDBCursorRecord>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isDefined())>, bool>);
    encoder << instance.keyData();
    encoder << instance.primaryKeyData();
    encoder << instance.value();
    encoder << instance.keyPath();
    encoder << instance.prefetchedRecords();
    encoder << instance.isDefined();
}

std::optional<WebCore::IDBGetResult> ArgumentCoder<WebCore::IDBGetResult>::decode(Decoder& decoder)
{
    auto keyData = decoder.decode<WebCore::IDBKeyData>();
    auto primaryKeyData = decoder.decode<WebCore::IDBKeyData>();
    auto value = decoder.decode<WebCore::IDBValue>();
    auto keyPath = decoder.decode<std::optional<WebCore::IDBKeyPath>>();
    auto prefetchedRecords = decoder.decode<Vector<WebCore::IDBCursorRecord>>();
    auto isDefined = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBGetResult {
            WTFMove(*keyData),
            WTFMove(*primaryKeyData),
            WTFMove(*value),
            WTFMove(*keyPath),
            WTFMove(*prefetchedRecords),
            WTFMove(*isDefined)
        }
    };
}

void ArgumentCoder<WebCore::IDBGetAllResult>::encode(Encoder& encoder, const WebCore::IDBGetAllResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::IndexedDB::GetAllType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keys())>, Vector<WebCore::IDBKeyData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.values())>, Vector<WebCore::IDBValue>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyPath())>, std::optional<WebCore::IDBKeyPath>>);
    encoder << instance.type();
    encoder << instance.keys();
    encoder << instance.values();
    encoder << instance.keyPath();
}

std::optional<WebCore::IDBGetAllResult> ArgumentCoder<WebCore::IDBGetAllResult>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::IndexedDB::GetAllType>();
    auto keys = decoder.decode<Vector<WebCore::IDBKeyData>>();
    auto values = decoder.decode<Vector<WebCore::IDBValue>>();
    auto keyPath = decoder.decode<std::optional<WebCore::IDBKeyPath>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBGetAllResult {
            WTFMove(*type),
            WTFMove(*keys),
            WTFMove(*values),
            WTFMove(*keyPath)
        }
    };
}

void ArgumentCoder<WebCore::IDBDatabaseInfo>::encode(Encoder& encoder, const WebCore::IDBDatabaseInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_version)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_maxIndexID)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_maxObjectStoreID)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_objectStoreMap)>, HashMap<uint64_t, WebCore::IDBObjectStoreInfo>>);
    struct ShouldBeSameSizeAsIDBDatabaseInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBDatabaseInfo>, false> {
        String m_name;
        uint64_t m_version;
        uint64_t m_maxIndexID;
        uint64_t m_maxObjectStoreID;
        HashMap<uint64_t, WebCore::IDBObjectStoreInfo> m_objectStoreMap;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBDatabaseInfo) == sizeof(WebCore::IDBDatabaseInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBDatabaseInfo, m_name)
        , offsetof(WebCore::IDBDatabaseInfo, m_version)
        , offsetof(WebCore::IDBDatabaseInfo, m_maxIndexID)
        , offsetof(WebCore::IDBDatabaseInfo, m_maxObjectStoreID)
        , offsetof(WebCore::IDBDatabaseInfo, m_objectStoreMap)
    >::value);
    encoder << instance.m_name;
    encoder << instance.m_version;
    encoder << instance.m_maxIndexID;
    encoder << instance.m_maxObjectStoreID;
    encoder << instance.m_objectStoreMap;
}

std::optional<WebCore::IDBDatabaseInfo> ArgumentCoder<WebCore::IDBDatabaseInfo>::decode(Decoder& decoder)
{
    auto m_name = decoder.decode<String>();
    auto m_version = decoder.decode<uint64_t>();
    auto m_maxIndexID = decoder.decode<uint64_t>();
    auto m_maxObjectStoreID = decoder.decode<uint64_t>();
    auto m_objectStoreMap = decoder.decode<HashMap<uint64_t, WebCore::IDBObjectStoreInfo>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBDatabaseInfo {
            WTFMove(*m_name),
            WTFMove(*m_version),
            WTFMove(*m_maxIndexID),
            WTFMove(*m_maxObjectStoreID),
            WTFMove(*m_objectStoreMap)
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyRangeData>::encode(Encoder& encoder, const WebCore::IDBKeyRangeData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lowerKey)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.upperKey)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lowerOpen)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.upperOpen)>, bool>);
    struct ShouldBeSameSizeAsIDBKeyRangeData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyRangeData>, false> {
        WebCore::IDBKeyData lowerKey;
        WebCore::IDBKeyData upperKey;
        bool lowerOpen;
        bool upperOpen;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBKeyRangeData) == sizeof(WebCore::IDBKeyRangeData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBKeyRangeData, lowerKey)
        , offsetof(WebCore::IDBKeyRangeData, upperKey)
        , offsetof(WebCore::IDBKeyRangeData, lowerOpen)
        , offsetof(WebCore::IDBKeyRangeData, upperOpen)
    >::value);
    encoder << instance.lowerKey;
    encoder << instance.upperKey;
    encoder << instance.lowerOpen;
    encoder << instance.upperOpen;
}

std::optional<WebCore::IDBKeyRangeData> ArgumentCoder<WebCore::IDBKeyRangeData>::decode(Decoder& decoder)
{
    auto lowerKey = decoder.decode<WebCore::IDBKeyData>();
    auto upperKey = decoder.decode<WebCore::IDBKeyData>();
    auto lowerOpen = decoder.decode<bool>();
    auto upperOpen = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBKeyRangeData {
            WTFMove(*lowerKey),
            WTFMove(*upperKey),
            WTFMove(*lowerOpen),
            WTFMove(*upperOpen)
        }
    };
}

void ArgumentCoder<WebCore::IDBTransactionInfo>::encode(Encoder& encoder, const WebCore::IDBTransactionInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mode())>, WebCore::IDBTransactionMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.durability())>, WebCore::IDBTransactionDurability>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newVersion())>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.objectStores())>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originalDatabaseInfo())>, std::unique_ptr<WebCore::IDBDatabaseInfo>>);
    encoder << instance.identifier();
    encoder << instance.mode();
    encoder << instance.durability();
    encoder << instance.newVersion();
    encoder << instance.objectStores();
    encoder << instance.originalDatabaseInfo();
}

std::optional<WebCore::IDBTransactionInfo> ArgumentCoder<WebCore::IDBTransactionInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    auto mode = decoder.decode<WebCore::IDBTransactionMode>();
    auto durability = decoder.decode<WebCore::IDBTransactionDurability>();
    auto newVersion = decoder.decode<uint64_t>();
    auto objectStores = decoder.decode<Vector<String>>();
    auto originalDatabaseInfo = decoder.decode<std::unique_ptr<WebCore::IDBDatabaseInfo>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBTransactionInfo {
            WTFMove(*identifier),
            WTFMove(*mode),
            WTFMove(*durability),
            WTFMove(*newVersion),
            WTFMove(*objectStores),
            WTFMove(*originalDatabaseInfo)
        }
    };
}

void ArgumentCoder<WebCore::IDBGetRecordData>::encode(Encoder& encoder, const WebCore::IDBGetRecordData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyRangeData)>, WebCore::IDBKeyRangeData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::IDBGetRecordDataType>);
    struct ShouldBeSameSizeAsIDBGetRecordData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBGetRecordData>, false> {
        WebCore::IDBKeyRangeData keyRangeData;
        WebCore::IDBGetRecordDataType type;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBGetRecordData) == sizeof(WebCore::IDBGetRecordData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBGetRecordData, keyRangeData)
        , offsetof(WebCore::IDBGetRecordData, type)
    >::value);
    encoder << instance.keyRangeData;
    encoder << instance.type;
}

std::optional<WebCore::IDBGetRecordData> ArgumentCoder<WebCore::IDBGetRecordData>::decode(Decoder& decoder)
{
    auto keyRangeData = decoder.decode<WebCore::IDBKeyRangeData>();
    auto type = decoder.decode<WebCore::IDBGetRecordDataType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBGetRecordData {
            WTFMove(*keyRangeData),
            WTFMove(*type)
        }
    };
}

void ArgumentCoder<WebCore::IDBIndexInfo>::encode(Encoder& encoder, const WebCore::IDBIndexInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.objectStoreIdentifier())>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyPath())>, WebCore::IDBKeyPath>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.unique())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.multiEntry())>, bool>);
    encoder << instance.identifier();
    encoder << instance.objectStoreIdentifier();
    encoder << instance.name();
    encoder << instance.keyPath();
    encoder << instance.unique();
    encoder << instance.multiEntry();
}

std::optional<WebCore::IDBIndexInfo> ArgumentCoder<WebCore::IDBIndexInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<uint64_t>();
    auto objectStoreIdentifier = decoder.decode<uint64_t>();
    auto name = decoder.decode<String>();
    auto keyPath = decoder.decode<WebCore::IDBKeyPath>();
    auto unique = decoder.decode<bool>();
    auto multiEntry = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBIndexInfo {
            WTFMove(*identifier),
            WTFMove(*objectStoreIdentifier),
            WTFMove(*name),
            WTFMove(*keyPath),
            WTFMove(*unique),
            WTFMove(*multiEntry)
        }
    };
}

void ArgumentCoder<WebCore::IDBObjectStoreInfo>::encode(Encoder& encoder, const WebCore::IDBObjectStoreInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyPath())>, std::optional<WebCore::IDBKeyPath>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.autoIncrement())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.indexMap())>, HashMap<uint64_t, WebCore::IDBIndexInfo>>);
    encoder << instance.identifier();
    encoder << instance.name();
    encoder << instance.keyPath();
    encoder << instance.autoIncrement();
    encoder << instance.indexMap();
}

std::optional<WebCore::IDBObjectStoreInfo> ArgumentCoder<WebCore::IDBObjectStoreInfo>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<uint64_t>();
    auto name = decoder.decode<String>();
    auto keyPath = decoder.decode<std::optional<WebCore::IDBKeyPath>>();
    auto autoIncrement = decoder.decode<bool>();
    auto indexMap = decoder.decode<HashMap<uint64_t, WebCore::IDBIndexInfo>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBObjectStoreInfo {
            WTFMove(*identifier),
            WTFMove(*name),
            WTFMove(*keyPath),
            WTFMove(*autoIncrement),
            WTFMove(*indexMap)
        }
    };
}

void ArgumentCoder<WebCore::IDBIterateCursorData>::encode(Encoder& encoder, const WebCore::IDBIterateCursorData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyData)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.primaryKeyData)>, WebCore::IDBKeyData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.count)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.option)>, WebCore::IndexedDB::CursorIterateOption>);
    struct ShouldBeSameSizeAsIDBIterateCursorData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBIterateCursorData>, false> {
        WebCore::IDBKeyData keyData;
        WebCore::IDBKeyData primaryKeyData;
        unsigned count;
        WebCore::IndexedDB::CursorIterateOption option;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBIterateCursorData) == sizeof(WebCore::IDBIterateCursorData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBIterateCursorData, keyData)
        , offsetof(WebCore::IDBIterateCursorData, primaryKeyData)
        , offsetof(WebCore::IDBIterateCursorData, count)
        , offsetof(WebCore::IDBIterateCursorData, option)
    >::value);
    encoder << instance.keyData;
    encoder << instance.primaryKeyData;
    encoder << instance.count;
    encoder << instance.option;
}

std::optional<WebCore::IDBIterateCursorData> ArgumentCoder<WebCore::IDBIterateCursorData>::decode(Decoder& decoder)
{
    auto keyData = decoder.decode<WebCore::IDBKeyData>();
    auto primaryKeyData = decoder.decode<WebCore::IDBKeyData>();
    auto count = decoder.decode<unsigned>();
    auto option = decoder.decode<WebCore::IndexedDB::CursorIterateOption>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBIterateCursorData {
            WTFMove(*keyData),
            WTFMove(*primaryKeyData),
            WTFMove(*count),
            WTFMove(*option)
        }
    };
}

void ArgumentCoder<WebCore::IDBResourceIdentifier>::encode(Encoder& encoder, const WebCore::IDBResourceIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_idbConnectionIdentifier)>, WebCore::IDBConnectionIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_resourceNumber)>, uint64_t>);
    struct ShouldBeSameSizeAsIDBResourceIdentifier : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBResourceIdentifier>, false> {
        WebCore::IDBConnectionIdentifier m_idbConnectionIdentifier;
        uint64_t m_resourceNumber;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBResourceIdentifier) == sizeof(WebCore::IDBResourceIdentifier));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBResourceIdentifier, m_idbConnectionIdentifier)
        , offsetof(WebCore::IDBResourceIdentifier, m_resourceNumber)
    >::value);
    encoder << instance.m_idbConnectionIdentifier;
    encoder << instance.m_resourceNumber;
}

std::optional<WebCore::IDBResourceIdentifier> ArgumentCoder<WebCore::IDBResourceIdentifier>::decode(Decoder& decoder)
{
    auto m_idbConnectionIdentifier = decoder.decode<WebCore::IDBConnectionIdentifier>();
    auto m_resourceNumber = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBResourceIdentifier {
            WTFMove(*m_idbConnectionIdentifier),
            WTFMove(*m_resourceNumber)
        }
    };
}

void ArgumentCoder<WebCore::IDBValue>::encode(Encoder& encoder, const WebCore::IDBValue& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, WebCore::ThreadSafeDataBuffer>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blobURLs())>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blobFilePaths())>, Vector<String>>);
    encoder << instance.data();
    encoder << instance.blobURLs();
    encoder << instance.blobFilePaths();
}

std::optional<WebCore::IDBValue> ArgumentCoder<WebCore::IDBValue>::decode(Decoder& decoder)
{
    auto data = decoder.decode<WebCore::ThreadSafeDataBuffer>();
    auto blobURLs = decoder.decode<Vector<String>>();
    auto blobFilePaths = decoder.decode<Vector<String>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBValue {
            WTFMove(*data),
            WTFMove(*blobURLs),
            WTFMove(*blobFilePaths)
        }
    };
}

void ArgumentCoder<WebCore::IDBRequestData>::encode(Encoder& encoder, const WebCore::IDBRequestData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_serverConnectionIdentifier)>, WebCore::IDBConnectionIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestIdentifier)>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_transactionIdentifier)>, std::optional<WebCore::IDBResourceIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_cursorIdentifier)>, std::optional<WebCore::IDBResourceIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_objectStoreIdentifier)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_indexIdentifier)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_indexRecordType)>, WebCore::IndexedDB::IndexRecordType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_databaseIdentifier)>, std::optional<WebCore::IDBDatabaseIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestedVersion)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestType)>, WebCore::IndexedDB::RequestType>);
    struct ShouldBeSameSizeAsIDBRequestData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBRequestData>, false> {
        WebCore::IDBConnectionIdentifier m_serverConnectionIdentifier;
        WebCore::IDBResourceIdentifier m_requestIdentifier;
        std::optional<WebCore::IDBResourceIdentifier> m_transactionIdentifier;
        std::optional<WebCore::IDBResourceIdentifier> m_cursorIdentifier;
        uint64_t m_objectStoreIdentifier;
        uint64_t m_indexIdentifier;
        WebCore::IndexedDB::IndexRecordType m_indexRecordType;
        std::optional<WebCore::IDBDatabaseIdentifier> m_databaseIdentifier;
        uint64_t m_requestedVersion;
        WebCore::IndexedDB::RequestType m_requestType;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBRequestData) == sizeof(WebCore::IDBRequestData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBRequestData, m_serverConnectionIdentifier)
        , offsetof(WebCore::IDBRequestData, m_requestIdentifier)
        , offsetof(WebCore::IDBRequestData, m_transactionIdentifier)
        , offsetof(WebCore::IDBRequestData, m_cursorIdentifier)
        , offsetof(WebCore::IDBRequestData, m_objectStoreIdentifier)
        , offsetof(WebCore::IDBRequestData, m_indexIdentifier)
        , offsetof(WebCore::IDBRequestData, m_indexRecordType)
        , offsetof(WebCore::IDBRequestData, m_databaseIdentifier)
        , offsetof(WebCore::IDBRequestData, m_requestedVersion)
        , offsetof(WebCore::IDBRequestData, m_requestType)
    >::value);
    encoder << instance.m_serverConnectionIdentifier;
    encoder << instance.m_requestIdentifier;
    encoder << instance.m_transactionIdentifier;
    encoder << instance.m_cursorIdentifier;
    encoder << instance.m_objectStoreIdentifier;
    encoder << instance.m_indexIdentifier;
    encoder << instance.m_indexRecordType;
    encoder << instance.m_databaseIdentifier;
    encoder << instance.m_requestedVersion;
    encoder << instance.m_requestType;
}

std::optional<WebCore::IDBRequestData> ArgumentCoder<WebCore::IDBRequestData>::decode(Decoder& decoder)
{
    auto m_serverConnectionIdentifier = decoder.decode<WebCore::IDBConnectionIdentifier>();
    auto m_requestIdentifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    auto m_transactionIdentifier = decoder.decode<std::optional<WebCore::IDBResourceIdentifier>>();
    auto m_cursorIdentifier = decoder.decode<std::optional<WebCore::IDBResourceIdentifier>>();
    auto m_objectStoreIdentifier = decoder.decode<uint64_t>();
    auto m_indexIdentifier = decoder.decode<uint64_t>();
    auto m_indexRecordType = decoder.decode<WebCore::IndexedDB::IndexRecordType>();
    auto m_databaseIdentifier = decoder.decode<std::optional<WebCore::IDBDatabaseIdentifier>>();
    auto m_requestedVersion = decoder.decode<uint64_t>();
    auto m_requestType = decoder.decode<WebCore::IndexedDB::RequestType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBRequestData {
            WTFMove(*m_serverConnectionIdentifier),
            WTFMove(*m_requestIdentifier),
            WTFMove(*m_transactionIdentifier),
            WTFMove(*m_cursorIdentifier),
            WTFMove(*m_objectStoreIdentifier),
            WTFMove(*m_indexIdentifier),
            WTFMove(*m_indexRecordType),
            WTFMove(*m_databaseIdentifier),
            WTFMove(*m_requestedVersion),
            WTFMove(*m_requestType)
        }
    };
}

void ArgumentCoder<WebCore::IDBDatabaseIdentifier>::encode(Encoder& encoder, const WebCore::IDBDatabaseIdentifier& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_databaseName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_origin)>, WebCore::ClientOrigin>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isTransient)>, bool>);
    struct ShouldBeSameSizeAsIDBDatabaseIdentifier : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBDatabaseIdentifier>, false> {
        String m_databaseName;
        WebCore::ClientOrigin m_origin;
        bool m_isTransient;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBDatabaseIdentifier) == sizeof(WebCore::IDBDatabaseIdentifier));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBDatabaseIdentifier, m_databaseName)
        , offsetof(WebCore::IDBDatabaseIdentifier, m_origin)
        , offsetof(WebCore::IDBDatabaseIdentifier, m_isTransient)
    >::value);
    encoder << instance.m_databaseName;
    encoder << instance.m_origin;
    encoder << instance.m_isTransient;
}

std::optional<WebCore::IDBDatabaseIdentifier> ArgumentCoder<WebCore::IDBDatabaseIdentifier>::decode(Decoder& decoder)
{
    auto m_databaseName = decoder.decode<String>();
    auto m_origin = decoder.decode<WebCore::ClientOrigin>();
    auto m_isTransient = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    WebCore::IDBDatabaseIdentifier result;
    result.m_databaseName = WTFMove(*m_databaseName);
    result.m_origin = WTFMove(*m_origin);
    result.m_isTransient = WTFMove(*m_isTransient);
    return { WTFMove(result) };
}

void ArgumentCoder<WebCore::IDBDatabaseNameAndVersion>::encode(Encoder& encoder, const WebCore::IDBDatabaseNameAndVersion& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.version)>, uint64_t>);
    struct ShouldBeSameSizeAsIDBDatabaseNameAndVersion : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBDatabaseNameAndVersion>, false> {
        String name;
        uint64_t version;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBDatabaseNameAndVersion) == sizeof(WebCore::IDBDatabaseNameAndVersion));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBDatabaseNameAndVersion, name)
        , offsetof(WebCore::IDBDatabaseNameAndVersion, version)
    >::value);
    encoder << instance.name;
    encoder << instance.version;
}

std::optional<WebCore::IDBDatabaseNameAndVersion> ArgumentCoder<WebCore::IDBDatabaseNameAndVersion>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto version = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBDatabaseNameAndVersion {
            WTFMove(*name),
            WTFMove(*version)
        }
    };
}

void ArgumentCoder<WebCore::IDBResultData>::encode(Encoder& encoder, const WebCore::IDBResultData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_type)>, WebCore::IDBResultType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requestIdentifier)>, WebCore::IDBResourceIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_error)>, WebCore::IDBError>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_databaseConnectionIdentifier)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_databaseInfo)>, std::unique_ptr<WebCore::IDBDatabaseInfo>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_transactionInfo)>, std::unique_ptr<WebCore::IDBTransactionInfo>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_resultKey)>, std::unique_ptr<WebCore::IDBKeyData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_getResult)>, std::unique_ptr<WebCore::IDBGetResult>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_getAllResult)>, std::unique_ptr<WebCore::IDBGetAllResult>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_resultInteger)>, uint64_t>);
    struct ShouldBeSameSizeAsIDBResultData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBResultData>, false> {
        WebCore::IDBResultType m_type;
        WebCore::IDBResourceIdentifier m_requestIdentifier;
        WebCore::IDBError m_error;
        uint64_t m_databaseConnectionIdentifier;
        std::unique_ptr<WebCore::IDBDatabaseInfo> m_databaseInfo;
        std::unique_ptr<WebCore::IDBTransactionInfo> m_transactionInfo;
        std::unique_ptr<WebCore::IDBKeyData> m_resultKey;
        std::unique_ptr<WebCore::IDBGetResult> m_getResult;
        std::unique_ptr<WebCore::IDBGetAllResult> m_getAllResult;
        uint64_t m_resultInteger;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIDBResultData) == sizeof(WebCore::IDBResultData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBResultData, m_type)
        , offsetof(WebCore::IDBResultData, m_requestIdentifier)
        , offsetof(WebCore::IDBResultData, m_error)
        , offsetof(WebCore::IDBResultData, m_databaseConnectionIdentifier)
        , offsetof(WebCore::IDBResultData, m_databaseInfo)
        , offsetof(WebCore::IDBResultData, m_transactionInfo)
        , offsetof(WebCore::IDBResultData, m_resultKey)
        , offsetof(WebCore::IDBResultData, m_getResult)
        , offsetof(WebCore::IDBResultData, m_getAllResult)
        , offsetof(WebCore::IDBResultData, m_resultInteger)
    >::value);
    encoder << instance.m_type;
    encoder << instance.m_requestIdentifier;
    encoder << instance.m_error;
    encoder << instance.m_databaseConnectionIdentifier;
    encoder << instance.m_databaseInfo;
    encoder << instance.m_transactionInfo;
    encoder << instance.m_resultKey;
    encoder << instance.m_getResult;
    encoder << instance.m_getAllResult;
    encoder << instance.m_resultInteger;
}

std::optional<WebCore::IDBResultData> ArgumentCoder<WebCore::IDBResultData>::decode(Decoder& decoder)
{
    auto m_type = decoder.decode<WebCore::IDBResultType>();
    auto m_requestIdentifier = decoder.decode<WebCore::IDBResourceIdentifier>();
    auto m_error = decoder.decode<WebCore::IDBError>();
    auto m_databaseConnectionIdentifier = decoder.decode<uint64_t>();
    auto m_databaseInfo = decoder.decode<std::unique_ptr<WebCore::IDBDatabaseInfo>>();
    auto m_transactionInfo = decoder.decode<std::unique_ptr<WebCore::IDBTransactionInfo>>();
    auto m_resultKey = decoder.decode<std::unique_ptr<WebCore::IDBKeyData>>();
    auto m_getResult = decoder.decode<std::unique_ptr<WebCore::IDBGetResult>>();
    auto m_getAllResult = decoder.decode<std::unique_ptr<WebCore::IDBGetAllResult>>();
    auto m_resultInteger = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    WebCore::IDBResultData result;
    result.m_type = WTFMove(*m_type);
    result.m_requestIdentifier = WTFMove(*m_requestIdentifier);
    result.m_error = WTFMove(*m_error);
    result.m_databaseConnectionIdentifier = WTFMove(*m_databaseConnectionIdentifier);
    result.m_databaseInfo = WTFMove(*m_databaseInfo);
    result.m_transactionInfo = WTFMove(*m_transactionInfo);
    result.m_resultKey = WTFMove(*m_resultKey);
    result.m_getResult = WTFMove(*m_getResult);
    result.m_getAllResult = WTFMove(*m_getAllResult);
    result.m_resultInteger = WTFMove(*m_resultInteger);
    return { WTFMove(result) };
}

void ArgumentCoder<WebCore::IDBKeyData>::encode(Encoder& encoder, const WebCore::IDBKeyData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, std::variant<std::nullptr_t, WebCore::IDBKeyData::Invalid, Vector<WebCore::IDBKeyData>, String, double, WebCore::IDBKeyData::Date, WebCore::ThreadSafeDataBuffer, WebCore::IDBKeyData::Min, WebCore::IDBKeyData::Max>>);
    encoder << instance.value();
}

std::optional<WebCore::IDBKeyData> ArgumentCoder<WebCore::IDBKeyData>::decode(Decoder& decoder)
{
    auto value = decoder.decode<std::variant<std::nullptr_t, WebCore::IDBKeyData::Invalid, Vector<WebCore::IDBKeyData>, String, double, WebCore::IDBKeyData::Date, WebCore::ThreadSafeDataBuffer, WebCore::IDBKeyData::Min, WebCore::IDBKeyData::Max>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBKeyData {
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyData::Invalid>::encode(Encoder& encoder, const WebCore::IDBKeyData::Invalid& instance)
{
    struct ShouldBeSameSizeAsInvalid : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyData::Invalid>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsInvalid) == sizeof(WebCore::IDBKeyData::Invalid));
    static_assert(MembersInCorrectOrder < 0
    >::value);
}

std::optional<WebCore::IDBKeyData::Invalid> ArgumentCoder<WebCore::IDBKeyData::Invalid>::decode(Decoder& decoder)
{
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBKeyData::Invalid {
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyData::Min>::encode(Encoder& encoder, const WebCore::IDBKeyData::Min& instance)
{
    struct ShouldBeSameSizeAsMin : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyData::Min>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsMin) == sizeof(WebCore::IDBKeyData::Min));
    static_assert(MembersInCorrectOrder < 0
    >::value);
}

std::optional<WebCore::IDBKeyData::Min> ArgumentCoder<WebCore::IDBKeyData::Min>::decode(Decoder& decoder)
{
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBKeyData::Min {
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyData::Max>::encode(Encoder& encoder, const WebCore::IDBKeyData::Max& instance)
{
    struct ShouldBeSameSizeAsMax : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyData::Max>, false> {
    };
    static_assert(sizeof(ShouldBeSameSizeAsMax) == sizeof(WebCore::IDBKeyData::Max));
    static_assert(MembersInCorrectOrder < 0
    >::value);
}

std::optional<WebCore::IDBKeyData::Max> ArgumentCoder<WebCore::IDBKeyData::Max>::decode(Decoder& decoder)
{
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBKeyData::Max {
        }
    };
}

void ArgumentCoder<WebCore::IDBKeyData::Date>::encode(Encoder& encoder, const WebCore::IDBKeyData::Date& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, double>);
    struct ShouldBeSameSizeAsDate : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::IDBKeyData::Date>, false> {
        double value;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDate) == sizeof(WebCore::IDBKeyData::Date));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::IDBKeyData::Date, value)
    >::value);
    encoder << instance.value;
}

std::optional<WebCore::IDBKeyData::Date> ArgumentCoder<WebCore::IDBKeyData::Date>::decode(Decoder& decoder)
{
    auto value = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IDBKeyData::Date {
            WTFMove(*value)
        }
    };
}

#if USE(CG)
void ArgumentCoder<CGSize>::encode(Encoder& encoder, const CGSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width)>, CGFloat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height)>, CGFloat>);
    struct ShouldBeSameSizeAsCGSize : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<CGSize>, false> {
        CGFloat width;
        CGFloat height;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCGSize) == sizeof(CGSize));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(CGSize, width)
        , offsetof(CGSize, height)
    >::value);
    encoder << instance.width;
    encoder << instance.height;
}

void ArgumentCoder<CGSize>::encode(StreamConnectionEncoder& encoder, const CGSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width)>, CGFloat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height)>, CGFloat>);
    struct ShouldBeSameSizeAsCGSize : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<CGSize>, false> {
        CGFloat width;
        CGFloat height;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCGSize) == sizeof(CGSize));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(CGSize, width)
        , offsetof(CGSize, height)
    >::value);
    encoder << instance.width;
    encoder << instance.height;
}

std::optional<CGSize> ArgumentCoder<CGSize>::decode(Decoder& decoder)
{
    auto width = decoder.decode<CGFloat>();
    auto height = decoder.decode<CGFloat>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        CGSize {
            WTFMove(*width),
            WTFMove(*height)
        }
    };
}

#endif

#if USE(CG)
void ArgumentCoder<CGPoint>::encode(Encoder& encoder, const CGPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x)>, CGFloat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y)>, CGFloat>);
    struct ShouldBeSameSizeAsCGPoint : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<CGPoint>, false> {
        CGFloat x;
        CGFloat y;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCGPoint) == sizeof(CGPoint));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(CGPoint, x)
        , offsetof(CGPoint, y)
    >::value);
    encoder << instance.x;
    encoder << instance.y;
}

std::optional<CGPoint> ArgumentCoder<CGPoint>::decode(Decoder& decoder)
{
    auto x = decoder.decode<CGFloat>();
    auto y = decoder.decode<CGFloat>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        CGPoint {
            WTFMove(*x),
            WTFMove(*y)
        }
    };
}

#endif

#if USE(CG)
void ArgumentCoder<CGRect>::encode(Encoder& encoder, const CGRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.origin)>, CGPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size)>, CGSize>);
    struct ShouldBeSameSizeAsCGRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<CGRect>, false> {
        CGPoint origin;
        CGSize size;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCGRect) == sizeof(CGRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(CGRect, origin)
        , offsetof(CGRect, size)
    >::value);
    encoder << instance.origin;
    encoder << instance.size;
}

std::optional<CGRect> ArgumentCoder<CGRect>::decode(Decoder& decoder)
{
    auto origin = decoder.decode<CGPoint>();
    auto size = decoder.decode<CGSize>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        CGRect {
            WTFMove(*origin),
            WTFMove(*size)
        }
    };
}

#endif

#if USE(CG)
void ArgumentCoder<CGAffineTransform>::encode(Encoder& encoder, const CGAffineTransform& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.a)>, CGFloat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.b)>, CGFloat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.c)>, CGFloat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.d)>, CGFloat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tx)>, CGFloat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ty)>, CGFloat>);
    struct ShouldBeSameSizeAsCGAffineTransform : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<CGAffineTransform>, false> {
        CGFloat a;
        CGFloat b;
        CGFloat c;
        CGFloat d;
        CGFloat tx;
        CGFloat ty;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCGAffineTransform) == sizeof(CGAffineTransform));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(CGAffineTransform, a)
        , offsetof(CGAffineTransform, b)
        , offsetof(CGAffineTransform, c)
        , offsetof(CGAffineTransform, d)
        , offsetof(CGAffineTransform, tx)
        , offsetof(CGAffineTransform, ty)
    >::value);
    encoder << instance.a;
    encoder << instance.b;
    encoder << instance.c;
    encoder << instance.d;
    encoder << instance.tx;
    encoder << instance.ty;
}

std::optional<CGAffineTransform> ArgumentCoder<CGAffineTransform>::decode(Decoder& decoder)
{
    auto a = decoder.decode<CGFloat>();
    auto b = decoder.decode<CGFloat>();
    auto c = decoder.decode<CGFloat>();
    auto d = decoder.decode<CGFloat>();
    auto tx = decoder.decode<CGFloat>();
    auto ty = decoder.decode<CGFloat>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        CGAffineTransform {
            WTFMove(*a),
            WTFMove(*b),
            WTFMove(*c),
            WTFMove(*d),
            WTFMove(*tx),
            WTFMove(*ty)
        }
    };
}

#endif

void ArgumentCoder<WebCore::FloatRect>::encode(Encoder& encoder, const WebCore::FloatRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size())>, WebCore::FloatSize>);
    encoder << instance.location();
    encoder << instance.size();
}

void ArgumentCoder<WebCore::FloatRect>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size())>, WebCore::FloatSize>);
    encoder << instance.location();
    encoder << instance.size();
}

std::optional<WebCore::FloatRect> ArgumentCoder<WebCore::FloatRect>::decode(Decoder& decoder)
{
    auto location = decoder.decode<WebCore::FloatPoint>();
    auto size = decoder.decode<WebCore::FloatSize>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FloatRect {
            WTFMove(*location),
            WTFMove(*size)
        }
    };
}

void ArgumentCoder<WebCore::LinearTimingFunction::Point>::encode(Encoder& encoder, const WebCore::LinearTimingFunction::Point& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.progress)>, double>);
    struct ShouldBeSameSizeAsPoint : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::LinearTimingFunction::Point>, false> {
        double value;
        double progress;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPoint) == sizeof(WebCore::LinearTimingFunction::Point));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::LinearTimingFunction::Point, value)
        , offsetof(WebCore::LinearTimingFunction::Point, progress)
    >::value);
    encoder << instance.value;
    encoder << instance.progress;
}

std::optional<WebCore::LinearTimingFunction::Point> ArgumentCoder<WebCore::LinearTimingFunction::Point>::decode(Decoder& decoder)
{
    auto value = decoder.decode<double>();
    auto progress = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::LinearTimingFunction::Point {
            WTFMove(*value),
            WTFMove(*progress)
        }
    };
}

void ArgumentCoder<WebCore::LinearTimingFunction>::encode(Encoder& encoder, const WebCore::LinearTimingFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.points())>, Vector<WebCore::LinearTimingFunction::Point>>);
    encoder << instance.points();
}

std::optional<Ref<WebCore::LinearTimingFunction>> ArgumentCoder<WebCore::LinearTimingFunction>::decode(Decoder& decoder)
{
    auto points = decoder.decode<Vector<WebCore::LinearTimingFunction::Point>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::LinearTimingFunction::create(
            WTFMove(*points)
        )
    };
}

void ArgumentCoder<WebCore::CubicBezierTimingFunction>::encode(Encoder& encoder, const WebCore::CubicBezierTimingFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timingFunctionPreset())>, WebCore::CubicBezierTimingFunction::TimingFunctionPreset>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x1())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y1())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x2())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y2())>, double>);
    encoder << instance.timingFunctionPreset();
    encoder << instance.x1();
    encoder << instance.y1();
    encoder << instance.x2();
    encoder << instance.y2();
}

std::optional<Ref<WebCore::CubicBezierTimingFunction>> ArgumentCoder<WebCore::CubicBezierTimingFunction>::decode(Decoder& decoder)
{
    auto timingFunctionPreset = decoder.decode<WebCore::CubicBezierTimingFunction::TimingFunctionPreset>();
    auto x1 = decoder.decode<double>();
    auto y1 = decoder.decode<double>();
    auto x2 = decoder.decode<double>();
    auto y2 = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CubicBezierTimingFunction::create(
            WTFMove(*timingFunctionPreset),
            WTFMove(*x1),
            WTFMove(*y1),
            WTFMove(*x2),
            WTFMove(*y2)
        )
    };
}

void ArgumentCoder<WebCore::StepsTimingFunction>::encode(Encoder& encoder, const WebCore::StepsTimingFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.numberOfSteps())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stepPosition())>, std::optional<WebCore::StepsTimingFunction::StepPosition>>);
    encoder << instance.numberOfSteps();
    encoder << instance.stepPosition();
}

std::optional<Ref<WebCore::StepsTimingFunction>> ArgumentCoder<WebCore::StepsTimingFunction>::decode(Decoder& decoder)
{
    auto numberOfSteps = decoder.decode<int>();
    auto stepPosition = decoder.decode<std::optional<WebCore::StepsTimingFunction::StepPosition>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::StepsTimingFunction::create(
            WTFMove(*numberOfSteps),
            WTFMove(*stepPosition)
        )
    };
}

void ArgumentCoder<WebCore::SpringTimingFunction>::encode(Encoder& encoder, const WebCore::SpringTimingFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mass())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stiffness())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.damping())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.initialVelocity())>, double>);
    encoder << instance.mass();
    encoder << instance.stiffness();
    encoder << instance.damping();
    encoder << instance.initialVelocity();
}

std::optional<Ref<WebCore::SpringTimingFunction>> ArgumentCoder<WebCore::SpringTimingFunction>::decode(Decoder& decoder)
{
    auto mass = decoder.decode<double>();
    auto stiffness = decoder.decode<double>();
    auto damping = decoder.decode<double>();
    auto initialVelocity = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SpringTimingFunction::create(
            WTFMove(*mass),
            WTFMove(*stiffness),
            WTFMove(*damping),
            WTFMove(*initialVelocity)
        )
    };
}

void ArgumentCoder<WebCore::ResourceLoadStatistics>::encode(Encoder& encoder, const WebCore::ResourceLoadStatistics& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.registrableDomain)>, WebCore::RegistrableDomain>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lastSeen)>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hadUserInteraction)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mostRecentUserInteractionTime)>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.grandfathered)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.storageAccessUnderTopFrameDomains)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameUniqueRedirectsTo)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameUniqueRedirectsFrom)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameLinkDecorationsFrom)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gotLinkDecorationFromPrevalentResource)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameLoadedThirdPartyScripts)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.subframeUnderTopFrameDomains)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.subresourceUnderTopFrameDomains)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.subresourceUniqueRedirectsTo)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.subresourceUniqueRedirectsFrom)>, HashSet<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPrevalentResource)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isVeryPrevalentResource)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dataRecordsRemoved)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timesAccessedAsFirstPartyDueToUserInteraction)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timesAccessedAsFirstPartyDueToStorageAccessAPI)>, unsigned>);
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topFrameRegistrableDomainsWhichAccessedWebAPIs)>, HashSet<WebCore::RegistrableDomain>>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontsFailedToLoad)>, HashSet<String>>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontsSuccessfullyLoaded)>, HashSet<String>>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canvasActivityRecord)>, WebCore::CanvasActivityRecord>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.navigatorFunctionsAccessed)>, OptionSet<WebCore::NavigatorAPIsAccessed>>);
#endif
#if ENABLE(WEB_API_STATISTICS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenFunctionsAccessed)>, OptionSet<WebCore::ScreenAPIsAccessed>>);
#endif
    struct ShouldBeSameSizeAsResourceLoadStatistics : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ResourceLoadStatistics>, false> {
        WebCore::RegistrableDomain registrableDomain;
        WallTime lastSeen;
        bool hadUserInteraction;
        WallTime mostRecentUserInteractionTime;
        bool grandfathered;
        HashSet<WebCore::RegistrableDomain> storageAccessUnderTopFrameDomains;
        HashSet<WebCore::RegistrableDomain> topFrameUniqueRedirectsTo;
        HashSet<WebCore::RegistrableDomain> topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement;
        HashSet<WebCore::RegistrableDomain> topFrameUniqueRedirectsFrom;
        HashSet<WebCore::RegistrableDomain> topFrameLinkDecorationsFrom;
        bool gotLinkDecorationFromPrevalentResource;
        HashSet<WebCore::RegistrableDomain> topFrameLoadedThirdPartyScripts;
        HashSet<WebCore::RegistrableDomain> subframeUnderTopFrameDomains;
        HashSet<WebCore::RegistrableDomain> subresourceUnderTopFrameDomains;
        HashSet<WebCore::RegistrableDomain> subresourceUniqueRedirectsTo;
        HashSet<WebCore::RegistrableDomain> subresourceUniqueRedirectsFrom;
        bool isPrevalentResource;
        bool isVeryPrevalentResource;
        unsigned dataRecordsRemoved;
        unsigned timesAccessedAsFirstPartyDueToUserInteraction;
        unsigned timesAccessedAsFirstPartyDueToStorageAccessAPI;
#if ENABLE(WEB_API_STATISTICS)
        HashSet<WebCore::RegistrableDomain> topFrameRegistrableDomainsWhichAccessedWebAPIs;
#endif
#if ENABLE(WEB_API_STATISTICS)
        HashSet<String> fontsFailedToLoad;
#endif
#if ENABLE(WEB_API_STATISTICS)
        HashSet<String> fontsSuccessfullyLoaded;
#endif
#if ENABLE(WEB_API_STATISTICS)
        WebCore::CanvasActivityRecord canvasActivityRecord;
#endif
#if ENABLE(WEB_API_STATISTICS)
        OptionSet<WebCore::NavigatorAPIsAccessed> navigatorFunctionsAccessed;
#endif
#if ENABLE(WEB_API_STATISTICS)
        OptionSet<WebCore::ScreenAPIsAccessed> screenFunctionsAccessed;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsResourceLoadStatistics) == sizeof(WebCore::ResourceLoadStatistics));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ResourceLoadStatistics, registrableDomain)
        , offsetof(WebCore::ResourceLoadStatistics, lastSeen)
        , offsetof(WebCore::ResourceLoadStatistics, hadUserInteraction)
        , offsetof(WebCore::ResourceLoadStatistics, mostRecentUserInteractionTime)
        , offsetof(WebCore::ResourceLoadStatistics, grandfathered)
        , offsetof(WebCore::ResourceLoadStatistics, storageAccessUnderTopFrameDomains)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameUniqueRedirectsTo)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameUniqueRedirectsFrom)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameLinkDecorationsFrom)
        , offsetof(WebCore::ResourceLoadStatistics, gotLinkDecorationFromPrevalentResource)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameLoadedThirdPartyScripts)
        , offsetof(WebCore::ResourceLoadStatistics, subframeUnderTopFrameDomains)
        , offsetof(WebCore::ResourceLoadStatistics, subresourceUnderTopFrameDomains)
        , offsetof(WebCore::ResourceLoadStatistics, subresourceUniqueRedirectsTo)
        , offsetof(WebCore::ResourceLoadStatistics, subresourceUniqueRedirectsFrom)
        , offsetof(WebCore::ResourceLoadStatistics, isPrevalentResource)
        , offsetof(WebCore::ResourceLoadStatistics, isVeryPrevalentResource)
        , offsetof(WebCore::ResourceLoadStatistics, dataRecordsRemoved)
        , offsetof(WebCore::ResourceLoadStatistics, timesAccessedAsFirstPartyDueToUserInteraction)
        , offsetof(WebCore::ResourceLoadStatistics, timesAccessedAsFirstPartyDueToStorageAccessAPI)
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, topFrameRegistrableDomainsWhichAccessedWebAPIs)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, fontsFailedToLoad)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, fontsSuccessfullyLoaded)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, canvasActivityRecord)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, navigatorFunctionsAccessed)
#endif
#if ENABLE(WEB_API_STATISTICS)
        , offsetof(WebCore::ResourceLoadStatistics, screenFunctionsAccessed)
#endif
    >::value);
    encoder << instance.registrableDomain;
    encoder << instance.lastSeen;
    encoder << instance.hadUserInteraction;
    encoder << instance.mostRecentUserInteractionTime;
    encoder << instance.grandfathered;
    encoder << instance.storageAccessUnderTopFrameDomains;
    encoder << instance.topFrameUniqueRedirectsTo;
    encoder << instance.topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement;
    encoder << instance.topFrameUniqueRedirectsFrom;
    encoder << instance.topFrameLinkDecorationsFrom;
    encoder << instance.gotLinkDecorationFromPrevalentResource;
    encoder << instance.topFrameLoadedThirdPartyScripts;
    encoder << instance.subframeUnderTopFrameDomains;
    encoder << instance.subresourceUnderTopFrameDomains;
    encoder << instance.subresourceUniqueRedirectsTo;
    encoder << instance.subresourceUniqueRedirectsFrom;
    encoder << instance.isPrevalentResource;
    encoder << instance.isVeryPrevalentResource;
    encoder << instance.dataRecordsRemoved;
    encoder << instance.timesAccessedAsFirstPartyDueToUserInteraction;
    encoder << instance.timesAccessedAsFirstPartyDueToStorageAccessAPI;
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.topFrameRegistrableDomainsWhichAccessedWebAPIs;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.fontsFailedToLoad;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.fontsSuccessfullyLoaded;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.canvasActivityRecord;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.navigatorFunctionsAccessed;
#endif
#if ENABLE(WEB_API_STATISTICS)
    encoder << instance.screenFunctionsAccessed;
#endif
}

std::optional<WebCore::ResourceLoadStatistics> ArgumentCoder<WebCore::ResourceLoadStatistics>::decode(Decoder& decoder)
{
    auto registrableDomain = decoder.decode<WebCore::RegistrableDomain>();
    auto lastSeen = decoder.decode<WallTime>();
    auto hadUserInteraction = decoder.decode<bool>();
    auto mostRecentUserInteractionTime = decoder.decode<WallTime>();
    auto grandfathered = decoder.decode<bool>();
    auto storageAccessUnderTopFrameDomains = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto topFrameUniqueRedirectsTo = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto topFrameUniqueRedirectsFrom = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto topFrameLinkDecorationsFrom = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto gotLinkDecorationFromPrevalentResource = decoder.decode<bool>();
    auto topFrameLoadedThirdPartyScripts = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto subframeUnderTopFrameDomains = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto subresourceUnderTopFrameDomains = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto subresourceUniqueRedirectsTo = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto subresourceUniqueRedirectsFrom = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
    auto isPrevalentResource = decoder.decode<bool>();
    auto isVeryPrevalentResource = decoder.decode<bool>();
    auto dataRecordsRemoved = decoder.decode<unsigned>();
    auto timesAccessedAsFirstPartyDueToUserInteraction = decoder.decode<unsigned>();
    auto timesAccessedAsFirstPartyDueToStorageAccessAPI = decoder.decode<unsigned>();
#if ENABLE(WEB_API_STATISTICS)
    auto topFrameRegistrableDomainsWhichAccessedWebAPIs = decoder.decode<HashSet<WebCore::RegistrableDomain>>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto fontsFailedToLoad = decoder.decode<HashSet<String>>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto fontsSuccessfullyLoaded = decoder.decode<HashSet<String>>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto canvasActivityRecord = decoder.decode<WebCore::CanvasActivityRecord>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto navigatorFunctionsAccessed = decoder.decode<OptionSet<WebCore::NavigatorAPIsAccessed>>();
#endif
#if ENABLE(WEB_API_STATISTICS)
    auto screenFunctionsAccessed = decoder.decode<OptionSet<WebCore::ScreenAPIsAccessed>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    WebCore::ResourceLoadStatistics result;
    result.registrableDomain = WTFMove(*registrableDomain);
    result.lastSeen = WTFMove(*lastSeen);
    result.hadUserInteraction = WTFMove(*hadUserInteraction);
    result.mostRecentUserInteractionTime = WTFMove(*mostRecentUserInteractionTime);
    result.grandfathered = WTFMove(*grandfathered);
    result.storageAccessUnderTopFrameDomains = WTFMove(*storageAccessUnderTopFrameDomains);
    result.topFrameUniqueRedirectsTo = WTFMove(*topFrameUniqueRedirectsTo);
    result.topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement = WTFMove(*topFrameUniqueRedirectsToSinceSameSiteStrictEnforcement);
    result.topFrameUniqueRedirectsFrom = WTFMove(*topFrameUniqueRedirectsFrom);
    result.topFrameLinkDecorationsFrom = WTFMove(*topFrameLinkDecorationsFrom);
    result.gotLinkDecorationFromPrevalentResource = WTFMove(*gotLinkDecorationFromPrevalentResource);
    result.topFrameLoadedThirdPartyScripts = WTFMove(*topFrameLoadedThirdPartyScripts);
    result.subframeUnderTopFrameDomains = WTFMove(*subframeUnderTopFrameDomains);
    result.subresourceUnderTopFrameDomains = WTFMove(*subresourceUnderTopFrameDomains);
    result.subresourceUniqueRedirectsTo = WTFMove(*subresourceUniqueRedirectsTo);
    result.subresourceUniqueRedirectsFrom = WTFMove(*subresourceUniqueRedirectsFrom);
    result.isPrevalentResource = WTFMove(*isPrevalentResource);
    result.isVeryPrevalentResource = WTFMove(*isVeryPrevalentResource);
    result.dataRecordsRemoved = WTFMove(*dataRecordsRemoved);
    result.timesAccessedAsFirstPartyDueToUserInteraction = WTFMove(*timesAccessedAsFirstPartyDueToUserInteraction);
    result.timesAccessedAsFirstPartyDueToStorageAccessAPI = WTFMove(*timesAccessedAsFirstPartyDueToStorageAccessAPI);
#if ENABLE(WEB_API_STATISTICS)
    result.topFrameRegistrableDomainsWhichAccessedWebAPIs = WTFMove(*topFrameRegistrableDomainsWhichAccessedWebAPIs);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.fontsFailedToLoad = WTFMove(*fontsFailedToLoad);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.fontsSuccessfullyLoaded = WTFMove(*fontsSuccessfullyLoaded);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.canvasActivityRecord = WTFMove(*canvasActivityRecord);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.navigatorFunctionsAccessed = WTFMove(*navigatorFunctionsAccessed);
#endif
#if ENABLE(WEB_API_STATISTICS)
    result.screenFunctionsAccessed = WTFMove(*screenFunctionsAccessed);
#endif
    return { WTFMove(result) };
}

#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
void ArgumentCoder<WebCore::GraphicsContextGLActiveInfo>::encode(Encoder& encoder, const WebCore::GraphicsContextGLActiveInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, GCGLenum>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size)>, GCGLint>);
    struct ShouldBeSameSizeAsGraphicsContextGLActiveInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::GraphicsContextGLActiveInfo>, false> {
        String name;
        GCGLenum type;
        GCGLint size;
    };
    static_assert(sizeof(ShouldBeSameSizeAsGraphicsContextGLActiveInfo) == sizeof(WebCore::GraphicsContextGLActiveInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::GraphicsContextGLActiveInfo, name)
        , offsetof(WebCore::GraphicsContextGLActiveInfo, type)
        , offsetof(WebCore::GraphicsContextGLActiveInfo, size)
    >::value);
    encoder << instance.name;
    encoder << instance.type;
    encoder << instance.size;
}

void ArgumentCoder<WebCore::GraphicsContextGLActiveInfo>::encode(StreamConnectionEncoder& encoder, const WebCore::GraphicsContextGLActiveInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, GCGLenum>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size)>, GCGLint>);
    struct ShouldBeSameSizeAsGraphicsContextGLActiveInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::GraphicsContextGLActiveInfo>, false> {
        String name;
        GCGLenum type;
        GCGLint size;
    };
    static_assert(sizeof(ShouldBeSameSizeAsGraphicsContextGLActiveInfo) == sizeof(WebCore::GraphicsContextGLActiveInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::GraphicsContextGLActiveInfo, name)
        , offsetof(WebCore::GraphicsContextGLActiveInfo, type)
        , offsetof(WebCore::GraphicsContextGLActiveInfo, size)
    >::value);
    encoder << instance.name;
    encoder << instance.type;
    encoder << instance.size;
}

std::optional<WebCore::GraphicsContextGLActiveInfo> ArgumentCoder<WebCore::GraphicsContextGLActiveInfo>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto type = decoder.decode<GCGLenum>();
    auto size = decoder.decode<GCGLint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::GraphicsContextGLActiveInfo {
            WTFMove(*name),
            WTFMove(*type),
            WTFMove(*size)
        }
    };
}

#endif

void ArgumentCoder<WebCore::ViewportAttributes>::encode(Encoder& encoder, const WebCore::ViewportAttributes& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.layoutSize)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.initialScale)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.minimumScale)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximumScale)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userScalable)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.orientation)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shrinkToFit)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.viewportFit)>, WebCore::ViewportFit>);
    struct ShouldBeSameSizeAsViewportAttributes : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ViewportAttributes>, false> {
        WebCore::FloatSize layoutSize;
        float initialScale;
        float minimumScale;
        float maximumScale;
        float userScalable;
        float orientation;
        float shrinkToFit;
        WebCore::ViewportFit viewportFit;
    };
    static_assert(sizeof(ShouldBeSameSizeAsViewportAttributes) == sizeof(WebCore::ViewportAttributes));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ViewportAttributes, layoutSize)
        , offsetof(WebCore::ViewportAttributes, initialScale)
        , offsetof(WebCore::ViewportAttributes, minimumScale)
        , offsetof(WebCore::ViewportAttributes, maximumScale)
        , offsetof(WebCore::ViewportAttributes, userScalable)
        , offsetof(WebCore::ViewportAttributes, orientation)
        , offsetof(WebCore::ViewportAttributes, shrinkToFit)
        , offsetof(WebCore::ViewportAttributes, viewportFit)
    >::value);
    encoder << instance.layoutSize;
    encoder << instance.initialScale;
    encoder << instance.minimumScale;
    encoder << instance.maximumScale;
    encoder << instance.userScalable;
    encoder << instance.orientation;
    encoder << instance.shrinkToFit;
    encoder << instance.viewportFit;
}

std::optional<WebCore::ViewportAttributes> ArgumentCoder<WebCore::ViewportAttributes>::decode(Decoder& decoder)
{
    auto layoutSize = decoder.decode<WebCore::FloatSize>();
    auto initialScale = decoder.decode<float>();
    auto minimumScale = decoder.decode<float>();
    auto maximumScale = decoder.decode<float>();
    auto userScalable = decoder.decode<float>();
    auto orientation = decoder.decode<float>();
    auto shrinkToFit = decoder.decode<float>();
    auto viewportFit = decoder.decode<WebCore::ViewportFit>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ViewportAttributes {
            WTFMove(*layoutSize),
            WTFMove(*initialScale),
            WTFMove(*minimumScale),
            WTFMove(*maximumScale),
            WTFMove(*userScalable),
            WTFMove(*orientation),
            WTFMove(*shrinkToFit),
            WTFMove(*viewportFit)
        }
    };
}

void ArgumentCoder<WebCore::ShareDataWithParsedURL>::encode(Encoder& encoder, const WebCore::ShareDataWithParsedURL& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shareData)>, WebCore::ShareData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, std::optional<URL>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.files)>, Vector<WebCore::RawFile>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originator)>, WebCore::ShareDataOriginator>);
    struct ShouldBeSameSizeAsShareDataWithParsedURL : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ShareDataWithParsedURL>, false> {
        WebCore::ShareData shareData;
        std::optional<URL> url;
        Vector<WebCore::RawFile> files;
        WebCore::ShareDataOriginator originator;
    };
    static_assert(sizeof(ShouldBeSameSizeAsShareDataWithParsedURL) == sizeof(WebCore::ShareDataWithParsedURL));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ShareDataWithParsedURL, shareData)
        , offsetof(WebCore::ShareDataWithParsedURL, url)
        , offsetof(WebCore::ShareDataWithParsedURL, files)
        , offsetof(WebCore::ShareDataWithParsedURL, originator)
    >::value);
    encoder << instance.shareData;
    encoder << instance.url;
    encoder << instance.files;
    encoder << instance.originator;
}

std::optional<WebCore::ShareDataWithParsedURL> ArgumentCoder<WebCore::ShareDataWithParsedURL>::decode(Decoder& decoder)
{
    auto shareData = decoder.decode<WebCore::ShareData>();
    auto url = decoder.decode<std::optional<URL>>();
    auto files = decoder.decode<Vector<WebCore::RawFile>>();
    auto originator = decoder.decode<WebCore::ShareDataOriginator>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ShareDataWithParsedURL {
            WTFMove(*shareData),
            WTFMove(*url),
            WTFMove(*files),
            WTFMove(*originator)
        }
    };
}

void ArgumentCoder<WebCore::ShareData>::encode(Encoder& encoder, const WebCore::ShareData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.files)>, Vector<RefPtr<WebCore::File>>>);
    struct ShouldBeSameSizeAsShareData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ShareData>, false> {
        String title;
        String text;
        String url;
        Vector<RefPtr<WebCore::File>> files;
    };
    static_assert(sizeof(ShouldBeSameSizeAsShareData) == sizeof(WebCore::ShareData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ShareData, title)
        , offsetof(WebCore::ShareData, text)
        , offsetof(WebCore::ShareData, url)
        , offsetof(WebCore::ShareData, files)
    >::value);
    encoder << instance.title;
    encoder << instance.text;
    encoder << instance.url;
}

std::optional<WebCore::ShareData> ArgumentCoder<WebCore::ShareData>::decode(Decoder& decoder)
{
    auto title = decoder.decode<String>();
    auto text = decoder.decode<String>();
    auto url = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ShareData {
            WTFMove(*title),
            WTFMove(*text),
            WTFMove(*url)
        }
    };
}

void ArgumentCoder<WebCore::RawFile>::encode(Encoder& encoder, const WebCore::RawFile& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileData)>, RefPtr<WebCore::SharedBuffer>>);
    struct ShouldBeSameSizeAsRawFile : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::RawFile>, false> {
        String fileName;
        RefPtr<WebCore::SharedBuffer> fileData;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRawFile) == sizeof(WebCore::RawFile));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::RawFile, fileName)
        , offsetof(WebCore::RawFile, fileData)
    >::value);
    encoder << instance.fileName;
    encoder << instance.fileData;
}

std::optional<WebCore::RawFile> ArgumentCoder<WebCore::RawFile>::decode(Decoder& decoder)
{
    auto fileName = decoder.decode<String>();
    auto fileData = decoder.decode<RefPtr<WebCore::SharedBuffer>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::RawFile {
            WTFMove(*fileName),
            WTFMove(*fileData)
        }
    };
}

void ArgumentCoder<WebCore::FloatRoundedRect>::encode(Encoder& encoder, const WebCore::FloatRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().topLeft())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().topRight())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().bottomLeft())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().bottomRight())>, WebCore::FloatSize>);
    encoder << instance.rect();
    encoder << instance.radii().topLeft();
    encoder << instance.radii().topRight();
    encoder << instance.radii().bottomLeft();
    encoder << instance.radii().bottomRight();
}

void ArgumentCoder<WebCore::FloatRoundedRect>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatRoundedRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().topLeft())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().topRight())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().bottomLeft())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radii().bottomRight())>, WebCore::FloatSize>);
    encoder << instance.rect();
    encoder << instance.radii().topLeft();
    encoder << instance.radii().topRight();
    encoder << instance.radii().bottomLeft();
    encoder << instance.radii().bottomRight();
}

std::optional<WebCore::FloatRoundedRect> ArgumentCoder<WebCore::FloatRoundedRect>::decode(Decoder& decoder)
{
    auto rect = decoder.decode<WebCore::FloatRect>();
    auto radiitopLeft = decoder.decode<WebCore::FloatSize>();
    auto radiitopRight = decoder.decode<WebCore::FloatSize>();
    auto radiibottomLeft = decoder.decode<WebCore::FloatSize>();
    auto radiibottomRight = decoder.decode<WebCore::FloatSize>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FloatRoundedRect {
            WTFMove(*rect),
            WTFMove(*radiitopLeft),
            WTFMove(*radiitopRight),
            WTFMove(*radiibottomLeft),
            WTFMove(*radiibottomRight)
        }
    };
}

void ArgumentCoder<WebCore::IntRect>::encode(Encoder& encoder, const WebCore::IntRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location())>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size())>, WebCore::IntSize>);
    encoder << instance.location();
    encoder << instance.size();
}

void ArgumentCoder<WebCore::IntRect>::encode(StreamConnectionEncoder& encoder, const WebCore::IntRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.location())>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size())>, WebCore::IntSize>);
    encoder << instance.location();
    encoder << instance.size();
}

std::optional<WebCore::IntRect> ArgumentCoder<WebCore::IntRect>::decode(Decoder& decoder)
{
    auto location = decoder.decode<WebCore::IntPoint>();
    auto size = decoder.decode<WebCore::IntSize>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(WebCore::IntRect { *location, *size }.isValid()))
        return std::nullopt;
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IntRect {
            WTFMove(*location),
            WTFMove(*size)
        }
    };
}

void ArgumentCoder<WebCore::IntPoint>::encode(Encoder& encoder, const WebCore::IntPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, int>);
    encoder << instance.x();
    encoder << instance.y();
}

void ArgumentCoder<WebCore::IntPoint>::encode(StreamConnectionEncoder& encoder, const WebCore::IntPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, int>);
    encoder << instance.x();
    encoder << instance.y();
}

std::optional<WebCore::IntPoint> ArgumentCoder<WebCore::IntPoint>::decode(Decoder& decoder)
{
    auto x = decoder.decode<int>();
    auto y = decoder.decode<int>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IntPoint {
            WTFMove(*x),
            WTFMove(*y)
        }
    };
}

void ArgumentCoder<WebCore::IntSize>::encode(Encoder& encoder, const WebCore::IntSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, int>);
    encoder << instance.width();
    encoder << instance.height();
}

void ArgumentCoder<WebCore::IntSize>::encode(StreamConnectionEncoder& encoder, const WebCore::IntSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, int>);
    encoder << instance.width();
    encoder << instance.height();
}

std::optional<WebCore::IntSize> ArgumentCoder<WebCore::IntSize>::decode(Decoder& decoder)
{
    auto width = decoder.decode<int>();
    auto height = decoder.decode<int>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IntSize {
            WTFMove(*width),
            WTFMove(*height)
        }
    };
}

void ArgumentCoder<WebCore::FloatSize>::encode(Encoder& encoder, const WebCore::FloatSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, float>);
    encoder << instance.width();
    encoder << instance.height();
}

void ArgumentCoder<WebCore::FloatSize>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, float>);
    encoder << instance.width();
    encoder << instance.height();
}

std::optional<WebCore::FloatSize> ArgumentCoder<WebCore::FloatSize>::decode(Decoder& decoder)
{
    auto width = decoder.decode<float>();
    auto height = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FloatSize {
            WTFMove(*width),
            WTFMove(*height)
        }
    };
}

void ArgumentCoder<WebCore::LayoutUnit>::encode(Encoder& encoder, const WebCore::LayoutUnit& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rawValue())>, int>);
    encoder << instance.rawValue();
}

void ArgumentCoder<WebCore::LayoutUnit>::encode(StreamConnectionEncoder& encoder, const WebCore::LayoutUnit& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rawValue())>, int>);
    encoder << instance.rawValue();
}

std::optional<WebCore::LayoutUnit> ArgumentCoder<WebCore::LayoutUnit>::decode(Decoder& decoder)
{
    auto rawValue = decoder.decode<int>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::LayoutUnit::fromRawValue(
            WTFMove(*rawValue)
        )
    };
}

void ArgumentCoder<WebCore::LayoutPoint>::encode(Encoder& encoder, const WebCore::LayoutPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, WebCore::LayoutUnit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, WebCore::LayoutUnit>);
    encoder << instance.x();
    encoder << instance.y();
}

void ArgumentCoder<WebCore::LayoutPoint>::encode(StreamConnectionEncoder& encoder, const WebCore::LayoutPoint& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, WebCore::LayoutUnit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, WebCore::LayoutUnit>);
    encoder << instance.x();
    encoder << instance.y();
}

std::optional<WebCore::LayoutPoint> ArgumentCoder<WebCore::LayoutPoint>::decode(Decoder& decoder)
{
    auto x = decoder.decode<WebCore::LayoutUnit>();
    auto y = decoder.decode<WebCore::LayoutUnit>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::LayoutPoint {
            WTFMove(*x),
            WTFMove(*y)
        }
    };
}

void ArgumentCoder<WebCore::LayoutSize>::encode(Encoder& encoder, const WebCore::LayoutSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, WebCore::LayoutUnit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, WebCore::LayoutUnit>);
    encoder << instance.width();
    encoder << instance.height();
}

void ArgumentCoder<WebCore::LayoutSize>::encode(StreamConnectionEncoder& encoder, const WebCore::LayoutSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width())>, WebCore::LayoutUnit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height())>, WebCore::LayoutUnit>);
    encoder << instance.width();
    encoder << instance.height();
}

std::optional<WebCore::LayoutSize> ArgumentCoder<WebCore::LayoutSize>::decode(Decoder& decoder)
{
    auto width = decoder.decode<WebCore::LayoutUnit>();
    auto height = decoder.decode<WebCore::LayoutUnit>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::LayoutSize {
            WTFMove(*width),
            WTFMove(*height)
        }
    };
}

void ArgumentCoder<WebCore::DictionaryPopupInfo>::encode(Encoder& encoder, const WebCore::DictionaryPopupInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.origin)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textIndicator)>, WebCore::TextIndicatorData>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.platformData)>, WebCore::DictionaryPopupInfoCocoa>);
#endif
    struct ShouldBeSameSizeAsDictionaryPopupInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DictionaryPopupInfo>, false> {
        WebCore::FloatPoint origin;
        WebCore::TextIndicatorData textIndicator;
#if PLATFORM(COCOA)
        WebCore::DictionaryPopupInfoCocoa platformData;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsDictionaryPopupInfo) == sizeof(WebCore::DictionaryPopupInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DictionaryPopupInfo, origin)
        , offsetof(WebCore::DictionaryPopupInfo, textIndicator)
#if PLATFORM(COCOA)
        , offsetof(WebCore::DictionaryPopupInfo, platformData)
#endif
    >::value);
    encoder << instance.origin;
    encoder << instance.textIndicator;
#if PLATFORM(COCOA)
    encoder << instance.platformData;
#endif
}

std::optional<WebCore::DictionaryPopupInfo> ArgumentCoder<WebCore::DictionaryPopupInfo>::decode(Decoder& decoder)
{
    auto origin = decoder.decode<WebCore::FloatPoint>();
    auto textIndicator = decoder.decode<WebCore::TextIndicatorData>();
#if PLATFORM(COCOA)
    auto platformData = decoder.decode<WebCore::DictionaryPopupInfoCocoa>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DictionaryPopupInfo {
            WTFMove(*origin),
            WTFMove(*textIndicator),
#if PLATFORM(COCOA)
            WTFMove(*platformData)
#endif
        }
    };
}

void ArgumentCoder<WebCore::PrivateClickMeasurement>::encode(Encoder& encoder, const WebCore::PrivateClickMeasurement& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceID())>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceSite())>, WebCore::PCM::SourceSite>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationSite())>, WebCore::PCM::AttributionDestinationSite>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeOfAdClick())>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isEphemeral())>, WebCore::PCM::AttributionEphemeral>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.adamID())>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.attributionTriggerData())>, std::optional<WebCore::PCM::AttributionTriggerData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timesToSend())>, WebCore::PCM::AttributionTimeToSendData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ephemeralSourceNonce())>, std::optional<WebCore::PCM::EphemeralNonce>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceApplicationBundleID())>, String>);
    encoder << instance.sourceID();
    encoder << instance.sourceSite();
    encoder << instance.destinationSite();
    encoder << instance.timeOfAdClick();
    encoder << instance.isEphemeral();
    encoder << instance.adamID();
    encoder << instance.attributionTriggerData();
    encoder << instance.timesToSend();
    encoder << instance.ephemeralSourceNonce();
    encoder << instance.sourceApplicationBundleID();
}

std::optional<WebCore::PrivateClickMeasurement> ArgumentCoder<WebCore::PrivateClickMeasurement>::decode(Decoder& decoder)
{
    auto sourceID = decoder.decode<uint8_t>();
    auto sourceSite = decoder.decode<WebCore::PCM::SourceSite>();
    auto destinationSite = decoder.decode<WebCore::PCM::AttributionDestinationSite>();
    auto timeOfAdClick = decoder.decode<WallTime>();
    auto isEphemeral = decoder.decode<WebCore::PCM::AttributionEphemeral>();
    auto adamID = decoder.decode<std::optional<uint64_t>>();
    auto attributionTriggerData = decoder.decode<std::optional<WebCore::PCM::AttributionTriggerData>>();
    auto timesToSend = decoder.decode<WebCore::PCM::AttributionTimeToSendData>();
    auto ephemeralSourceNonce = decoder.decode<std::optional<WebCore::PCM::EphemeralNonce>>();
    auto sourceApplicationBundleID = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PrivateClickMeasurement {
            WTFMove(*sourceID),
            WTFMove(*sourceSite),
            WTFMove(*destinationSite),
            WTFMove(*timeOfAdClick),
            WTFMove(*isEphemeral),
            WTFMove(*adamID),
            WTFMove(*attributionTriggerData),
            WTFMove(*timesToSend),
            WTFMove(*ephemeralSourceNonce),
            WTFMove(*sourceApplicationBundleID)
        }
    };
}

void ArgumentCoder<WebCore::PCM::SourceSite>::encode(Encoder& encoder, const WebCore::PCM::SourceSite& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.registrableDomain)>, WebCore::RegistrableDomain>);
    struct ShouldBeSameSizeAsSourceSite : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::SourceSite>, false> {
        WebCore::RegistrableDomain registrableDomain;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSourceSite) == sizeof(WebCore::PCM::SourceSite));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::SourceSite, registrableDomain)
    >::value);
    encoder << instance.registrableDomain;
}

std::optional<WebCore::PCM::SourceSite> ArgumentCoder<WebCore::PCM::SourceSite>::decode(Decoder& decoder)
{
    auto registrableDomain = decoder.decode<WebCore::RegistrableDomain>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PCM::SourceSite {
            WTFMove(*registrableDomain)
        }
    };
}

void ArgumentCoder<WebCore::PCM::AttributionDestinationSite>::encode(Encoder& encoder, const WebCore::PCM::AttributionDestinationSite& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.registrableDomain)>, WebCore::RegistrableDomain>);
    struct ShouldBeSameSizeAsAttributionDestinationSite : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::AttributionDestinationSite>, false> {
        WebCore::RegistrableDomain registrableDomain;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAttributionDestinationSite) == sizeof(WebCore::PCM::AttributionDestinationSite));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::AttributionDestinationSite, registrableDomain)
    >::value);
    encoder << instance.registrableDomain;
}

std::optional<WebCore::PCM::AttributionDestinationSite> ArgumentCoder<WebCore::PCM::AttributionDestinationSite>::decode(Decoder& decoder)
{
    auto registrableDomain = decoder.decode<WebCore::RegistrableDomain>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PCM::AttributionDestinationSite {
            WTFMove(*registrableDomain)
        }
    };
}

void ArgumentCoder<WebCore::PCM::EphemeralNonce>::encode(Encoder& encoder, const WebCore::PCM::EphemeralNonce& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.nonce)>, String>);
    struct ShouldBeSameSizeAsEphemeralNonce : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::EphemeralNonce>, false> {
        String nonce;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEphemeralNonce) == sizeof(WebCore::PCM::EphemeralNonce));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::EphemeralNonce, nonce)
    >::value);
    encoder << instance.nonce;
}

std::optional<WebCore::PCM::EphemeralNonce> ArgumentCoder<WebCore::PCM::EphemeralNonce>::decode(Decoder& decoder)
{
    auto nonce = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PCM::EphemeralNonce {
            WTFMove(*nonce)
        }
    };
}

void ArgumentCoder<WebCore::PCM::AttributionTriggerData>::encode(Encoder& encoder, const WebCore::PCM::AttributionTriggerData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.priority)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.wasSent)>, WebCore::PCM::WasSent>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceRegistrableDomain)>, std::optional<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ephemeralDestinationNonce)>, std::optional<WebCore::PCM::EphemeralNonce>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationSite)>, std::optional<WebCore::RegistrableDomain>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationUnlinkableToken)>, std::optional<WebCore::PCM::DestinationUnlinkableToken>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationSecretToken)>, std::optional<WebCore::PCM::DestinationSecretToken>>);
    struct ShouldBeSameSizeAsAttributionTriggerData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::AttributionTriggerData>, false> {
        uint8_t data;
        uint8_t priority;
        WebCore::PCM::WasSent wasSent;
        std::optional<WebCore::RegistrableDomain> sourceRegistrableDomain;
        std::optional<WebCore::PCM::EphemeralNonce> ephemeralDestinationNonce;
        std::optional<WebCore::RegistrableDomain> destinationSite;
        std::optional<WebCore::PCM::DestinationUnlinkableToken> destinationUnlinkableToken;
        std::optional<WebCore::PCM::DestinationSecretToken> destinationSecretToken;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAttributionTriggerData) == sizeof(WebCore::PCM::AttributionTriggerData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::AttributionTriggerData, data)
        , offsetof(WebCore::PCM::AttributionTriggerData, priority)
        , offsetof(WebCore::PCM::AttributionTriggerData, wasSent)
        , offsetof(WebCore::PCM::AttributionTriggerData, sourceRegistrableDomain)
        , offsetof(WebCore::PCM::AttributionTriggerData, ephemeralDestinationNonce)
        , offsetof(WebCore::PCM::AttributionTriggerData, destinationSite)
        , offsetof(WebCore::PCM::AttributionTriggerData, destinationUnlinkableToken)
        , offsetof(WebCore::PCM::AttributionTriggerData, destinationSecretToken)
    >::value);
    encoder << instance.data;
    encoder << instance.priority;
    encoder << instance.wasSent;
    encoder << instance.sourceRegistrableDomain;
    encoder << instance.ephemeralDestinationNonce;
    encoder << instance.destinationSite;
}

std::optional<WebCore::PCM::AttributionTriggerData> ArgumentCoder<WebCore::PCM::AttributionTriggerData>::decode(Decoder& decoder)
{
    auto data = decoder.decode<uint8_t>();
    auto priority = decoder.decode<uint8_t>();
    auto wasSent = decoder.decode<WebCore::PCM::WasSent>();
    auto sourceRegistrableDomain = decoder.decode<std::optional<WebCore::RegistrableDomain>>();
    auto ephemeralDestinationNonce = decoder.decode<std::optional<WebCore::PCM::EphemeralNonce>>();
    auto destinationSite = decoder.decode<std::optional<WebCore::RegistrableDomain>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PCM::AttributionTriggerData {
            WTFMove(*data),
            WTFMove(*priority),
            WTFMove(*wasSent),
            WTFMove(*sourceRegistrableDomain),
            WTFMove(*ephemeralDestinationNonce),
            WTFMove(*destinationSite)
        }
    };
}

void ArgumentCoder<WebCore::PCM::AttributionTimeToSendData>::encode(Encoder& encoder, const WebCore::PCM::AttributionTimeToSendData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceEarliestTimeToSend)>, std::optional<WallTime>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destinationEarliestTimeToSend)>, std::optional<WallTime>>);
    struct ShouldBeSameSizeAsAttributionTimeToSendData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PCM::AttributionTimeToSendData>, false> {
        std::optional<WallTime> sourceEarliestTimeToSend;
        std::optional<WallTime> destinationEarliestTimeToSend;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAttributionTimeToSendData) == sizeof(WebCore::PCM::AttributionTimeToSendData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PCM::AttributionTimeToSendData, sourceEarliestTimeToSend)
        , offsetof(WebCore::PCM::AttributionTimeToSendData, destinationEarliestTimeToSend)
    >::value);
    encoder << instance.sourceEarliestTimeToSend;
    encoder << instance.destinationEarliestTimeToSend;
}

std::optional<WebCore::PCM::AttributionTimeToSendData> ArgumentCoder<WebCore::PCM::AttributionTimeToSendData>::decode(Decoder& decoder)
{
    auto sourceEarliestTimeToSend = decoder.decode<std::optional<WallTime>>();
    auto destinationEarliestTimeToSend = decoder.decode<std::optional<WallTime>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PCM::AttributionTimeToSendData {
            WTFMove(*sourceEarliestTimeToSend),
            WTFMove(*destinationEarliestTimeToSend)
        }
    };
}

#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
void ArgumentCoder<WebCore::ApplePayRecurringPaymentRequest>::encode(Encoder& encoder, const WebCore::ApplePayRecurringPaymentRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paymentDescription)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.regularBilling)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trialBilling)>, std::optional<WebCore::ApplePayLineItem>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.billingAgreement)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.managementURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tokenNotificationURL)>, String>);
    struct ShouldBeSameSizeAsApplePayRecurringPaymentRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayRecurringPaymentRequest>, false> {
        String paymentDescription;
        WebCore::ApplePayLineItem regularBilling;
        std::optional<WebCore::ApplePayLineItem> trialBilling;
        String billingAgreement;
        String managementURL;
        String tokenNotificationURL;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayRecurringPaymentRequest) == sizeof(WebCore::ApplePayRecurringPaymentRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, paymentDescription)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, regularBilling)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, trialBilling)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, billingAgreement)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, managementURL)
        , offsetof(WebCore::ApplePayRecurringPaymentRequest, tokenNotificationURL)
    >::value);
    encoder << instance.paymentDescription;
    encoder << instance.regularBilling;
    encoder << instance.trialBilling;
    encoder << instance.billingAgreement;
    encoder << instance.managementURL;
    encoder << instance.tokenNotificationURL;
}

std::optional<WebCore::ApplePayRecurringPaymentRequest> ArgumentCoder<WebCore::ApplePayRecurringPaymentRequest>::decode(Decoder& decoder)
{
    auto paymentDescription = decoder.decode<String>();
    auto regularBilling = decoder.decode<WebCore::ApplePayLineItem>();
    auto trialBilling = decoder.decode<std::optional<WebCore::ApplePayLineItem>>();
    auto billingAgreement = decoder.decode<String>();
    auto managementURL = decoder.decode<String>();
    auto tokenNotificationURL = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayRecurringPaymentRequest {
            WTFMove(*paymentDescription),
            WTFMove(*regularBilling),
            WTFMove(*trialBilling),
            WTFMove(*billingAgreement),
            WTFMove(*managementURL),
            WTFMove(*tokenNotificationURL)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
void ArgumentCoder<WebCore::ApplePayPaymentTokenContext>::encode(Encoder& encoder, const WebCore::ApplePayPaymentTokenContext& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.externalIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantDomain)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amount)>, String>);
    struct ShouldBeSameSizeAsApplePayPaymentTokenContext : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayPaymentTokenContext>, false> {
        String merchantIdentifier;
        String externalIdentifier;
        String merchantName;
        String merchantDomain;
        String amount;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayPaymentTokenContext) == sizeof(WebCore::ApplePayPaymentTokenContext));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayPaymentTokenContext, merchantIdentifier)
        , offsetof(WebCore::ApplePayPaymentTokenContext, externalIdentifier)
        , offsetof(WebCore::ApplePayPaymentTokenContext, merchantName)
        , offsetof(WebCore::ApplePayPaymentTokenContext, merchantDomain)
        , offsetof(WebCore::ApplePayPaymentTokenContext, amount)
    >::value);
    encoder << instance.merchantIdentifier;
    encoder << instance.externalIdentifier;
    encoder << instance.merchantName;
    encoder << instance.merchantDomain;
    encoder << instance.amount;
}

std::optional<WebCore::ApplePayPaymentTokenContext> ArgumentCoder<WebCore::ApplePayPaymentTokenContext>::decode(Decoder& decoder)
{
    auto merchantIdentifier = decoder.decode<String>();
    auto externalIdentifier = decoder.decode<String>();
    auto merchantName = decoder.decode<String>();
    auto merchantDomain = decoder.decode<String>();
    auto amount = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayPaymentTokenContext {
            WTFMove(*merchantIdentifier),
            WTFMove(*externalIdentifier),
            WTFMove(*merchantName),
            WTFMove(*merchantDomain),
            WTFMove(*amount)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
void ArgumentCoder<WebCore::ApplePayDeferredPaymentRequest>::encode(Encoder& encoder, const WebCore::ApplePayDeferredPaymentRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.billingAgreement)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.deferredBilling)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.freeCancellationDate)>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.freeCancellationDateTimeZone)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.managementURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paymentDescription)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tokenNotificationURL)>, String>);
    struct ShouldBeSameSizeAsApplePayDeferredPaymentRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayDeferredPaymentRequest>, false> {
        String billingAgreement;
        WebCore::ApplePayLineItem deferredBilling;
        WallTime freeCancellationDate;
        String freeCancellationDateTimeZone;
        String managementURL;
        String paymentDescription;
        String tokenNotificationURL;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayDeferredPaymentRequest) == sizeof(WebCore::ApplePayDeferredPaymentRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, billingAgreement)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, deferredBilling)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, freeCancellationDate)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, freeCancellationDateTimeZone)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, managementURL)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, paymentDescription)
        , offsetof(WebCore::ApplePayDeferredPaymentRequest, tokenNotificationURL)
    >::value);
    encoder << instance.billingAgreement;
    encoder << instance.deferredBilling;
    encoder << instance.freeCancellationDate;
    encoder << instance.freeCancellationDateTimeZone;
    encoder << instance.managementURL;
    encoder << instance.paymentDescription;
    encoder << instance.tokenNotificationURL;
}

std::optional<WebCore::ApplePayDeferredPaymentRequest> ArgumentCoder<WebCore::ApplePayDeferredPaymentRequest>::decode(Decoder& decoder)
{
    auto billingAgreement = decoder.decode<String>();
    auto deferredBilling = decoder.decode<WebCore::ApplePayLineItem>();
    auto freeCancellationDate = decoder.decode<WallTime>();
    auto freeCancellationDateTimeZone = decoder.decode<String>();
    auto managementURL = decoder.decode<String>();
    auto paymentDescription = decoder.decode<String>();
    auto tokenNotificationURL = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayDeferredPaymentRequest {
            WTFMove(*billingAgreement),
            WTFMove(*deferredBilling),
            WTFMove(*freeCancellationDate),
            WTFMove(*freeCancellationDateTimeZone),
            WTFMove(*managementURL),
            WTFMove(*paymentDescription),
            WTFMove(*tokenNotificationURL)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
void ArgumentCoder<WebCore::ApplePayPaymentOrderDetails>::encode(Encoder& encoder, const WebCore::ApplePayPaymentOrderDetails& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.orderTypeIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.orderIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webServiceURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.authenticationToken)>, String>);
    struct ShouldBeSameSizeAsApplePayPaymentOrderDetails : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayPaymentOrderDetails>, false> {
        String orderTypeIdentifier;
        String orderIdentifier;
        String webServiceURL;
        String authenticationToken;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayPaymentOrderDetails) == sizeof(WebCore::ApplePayPaymentOrderDetails));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayPaymentOrderDetails, orderTypeIdentifier)
        , offsetof(WebCore::ApplePayPaymentOrderDetails, orderIdentifier)
        , offsetof(WebCore::ApplePayPaymentOrderDetails, webServiceURL)
        , offsetof(WebCore::ApplePayPaymentOrderDetails, authenticationToken)
    >::value);
    encoder << instance.orderTypeIdentifier;
    encoder << instance.orderIdentifier;
    encoder << instance.webServiceURL;
    encoder << instance.authenticationToken;
}

std::optional<WebCore::ApplePayPaymentOrderDetails> ArgumentCoder<WebCore::ApplePayPaymentOrderDetails>::decode(Decoder& decoder)
{
    auto orderTypeIdentifier = decoder.decode<String>();
    auto orderIdentifier = decoder.decode<String>();
    auto webServiceURL = decoder.decode<String>();
    auto authenticationToken = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayPaymentOrderDetails {
            WTFMove(*orderTypeIdentifier),
            WTFMove(*orderIdentifier),
            WTFMove(*webServiceURL),
            WTFMove(*authenticationToken)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_AMS_UI) && ENABLE(PAYMENT_REQUEST)
void ArgumentCoder<WebCore::ApplePayAMSUIRequest>::encode(Encoder& encoder, const WebCore::ApplePayAMSUIRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.engagementRequest)>, String>);
    struct ShouldBeSameSizeAsApplePayAMSUIRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayAMSUIRequest>, false> {
        String engagementRequest;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayAMSUIRequest) == sizeof(WebCore::ApplePayAMSUIRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayAMSUIRequest, engagementRequest)
    >::value);
    encoder << instance.engagementRequest;
}

std::optional<WebCore::ApplePayAMSUIRequest> ArgumentCoder<WebCore::ApplePayAMSUIRequest>::decode(Decoder& decoder)
{
    auto engagementRequest = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayAMSUIRequest {
            WTFMove(*engagementRequest)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
void ArgumentCoder<WebCore::ApplePayAutomaticReloadPaymentRequest>::encode(Encoder& encoder, const WebCore::ApplePayAutomaticReloadPaymentRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paymentDescription)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.automaticReloadBilling)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.billingAgreement)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.managementURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tokenNotificationURL)>, String>);
    struct ShouldBeSameSizeAsApplePayAutomaticReloadPaymentRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayAutomaticReloadPaymentRequest>, false> {
        String paymentDescription;
        WebCore::ApplePayLineItem automaticReloadBilling;
        String billingAgreement;
        String managementURL;
        String tokenNotificationURL;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayAutomaticReloadPaymentRequest) == sizeof(WebCore::ApplePayAutomaticReloadPaymentRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, paymentDescription)
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, automaticReloadBilling)
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, billingAgreement)
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, managementURL)
        , offsetof(WebCore::ApplePayAutomaticReloadPaymentRequest, tokenNotificationURL)
    >::value);
    encoder << instance.paymentDescription;
    encoder << instance.automaticReloadBilling;
    encoder << instance.billingAgreement;
    encoder << instance.managementURL;
    encoder << instance.tokenNotificationURL;
}

std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest> ArgumentCoder<WebCore::ApplePayAutomaticReloadPaymentRequest>::decode(Decoder& decoder)
{
    auto paymentDescription = decoder.decode<String>();
    auto automaticReloadBilling = decoder.decode<WebCore::ApplePayLineItem>();
    auto billingAgreement = decoder.decode<String>();
    auto managementURL = decoder.decode<String>();
    auto tokenNotificationURL = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayAutomaticReloadPaymentRequest {
            WTFMove(*paymentDescription),
            WTFMove(*automaticReloadBilling),
            WTFMove(*billingAgreement),
            WTFMove(*managementURL),
            WTFMove(*tokenNotificationURL)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
void ArgumentCoder<WebCore::ApplePayDateComponents>::encode(Encoder& encoder, const WebCore::ApplePayDateComponents& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.years)>, std::optional<unsigned>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.months)>, std::optional<unsigned>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.days)>, std::optional<unsigned>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hours)>, std::optional<unsigned>>);
    struct ShouldBeSameSizeAsApplePayDateComponents : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayDateComponents>, false> {
        std::optional<unsigned> years;
        std::optional<unsigned> months;
        std::optional<unsigned> days;
        std::optional<unsigned> hours;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayDateComponents) == sizeof(WebCore::ApplePayDateComponents));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDateComponents, years)
        , offsetof(WebCore::ApplePayDateComponents, months)
        , offsetof(WebCore::ApplePayDateComponents, days)
        , offsetof(WebCore::ApplePayDateComponents, hours)
    >::value);
    encoder << instance.years;
    encoder << instance.months;
    encoder << instance.days;
    encoder << instance.hours;
}

std::optional<WebCore::ApplePayDateComponents> ArgumentCoder<WebCore::ApplePayDateComponents>::decode(Decoder& decoder)
{
    auto years = decoder.decode<std::optional<unsigned>>();
    auto months = decoder.decode<std::optional<unsigned>>();
    auto days = decoder.decode<std::optional<unsigned>>();
    auto hours = decoder.decode<std::optional<unsigned>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayDateComponents {
            WTFMove(*years),
            WTFMove(*months),
            WTFMove(*days),
            WTFMove(*hours)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
void ArgumentCoder<WebCore::ApplePayDateComponentsRange>::encode(Encoder& encoder, const WebCore::ApplePayDateComponentsRange& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startDateComponents)>, WebCore::ApplePayDateComponents>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endDateComponents)>, WebCore::ApplePayDateComponents>);
    struct ShouldBeSameSizeAsApplePayDateComponentsRange : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayDateComponentsRange>, false> {
        WebCore::ApplePayDateComponents startDateComponents;
        WebCore::ApplePayDateComponents endDateComponents;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayDateComponentsRange) == sizeof(WebCore::ApplePayDateComponentsRange));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDateComponentsRange, startDateComponents)
        , offsetof(WebCore::ApplePayDateComponentsRange, endDateComponents)
    >::value);
    encoder << instance.startDateComponents;
    encoder << instance.endDateComponents;
}

std::optional<WebCore::ApplePayDateComponentsRange> ArgumentCoder<WebCore::ApplePayDateComponentsRange>::decode(Decoder& decoder)
{
    auto startDateComponents = decoder.decode<WebCore::ApplePayDateComponents>();
    auto endDateComponents = decoder.decode<WebCore::ApplePayDateComponents>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayDateComponentsRange {
            WTFMove(*startDateComponents),
            WTFMove(*endDateComponents)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePaySetupConfiguration>::encode(Encoder& encoder, const WebCore::ApplePaySetupConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrerIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.signature)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.signedFields)>, Vector<String>>);
    struct ShouldBeSameSizeAsApplePaySetupConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePaySetupConfiguration>, false> {
        String merchantIdentifier;
        String referrerIdentifier;
        String signature;
        Vector<String> signedFields;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePaySetupConfiguration) == sizeof(WebCore::ApplePaySetupConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePaySetupConfiguration, merchantIdentifier)
        , offsetof(WebCore::ApplePaySetupConfiguration, referrerIdentifier)
        , offsetof(WebCore::ApplePaySetupConfiguration, signature)
        , offsetof(WebCore::ApplePaySetupConfiguration, signedFields)
    >::value);
    encoder << instance.merchantIdentifier;
    encoder << instance.referrerIdentifier;
    encoder << instance.signature;
    encoder << instance.signedFields;
}

std::optional<WebCore::ApplePaySetupConfiguration> ArgumentCoder<WebCore::ApplePaySetupConfiguration>::decode(Decoder& decoder)
{
    auto merchantIdentifier = decoder.decode<String>();
    auto referrerIdentifier = decoder.decode<String>();
    auto signature = decoder.decode<String>();
    auto signedFields = decoder.decode<Vector<String>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePaySetupConfiguration {
            WTFMove(*merchantIdentifier),
            WTFMove(*referrerIdentifier),
            WTFMove(*signature),
            WTFMove(*signedFields)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayLineItem>::encode(Encoder& encoder, const WebCore::ApplePayLineItem& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ApplePayLineItem::Type>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.paymentTiming)>, WebCore::ApplePayPaymentTiming>);
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.recurringPaymentStartDate)>, WallTime>);
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.recurringPaymentIntervalUnit)>, WebCore::ApplePayRecurringPaymentDateUnit>);
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.recurringPaymentIntervalCount)>, unsigned>);
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.recurringPaymentEndDate)>, WallTime>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.deferredPaymentDate)>, WallTime>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.automaticReloadPaymentThresholdAmount)>, String>);
#endif
    struct ShouldBeSameSizeAsApplePayLineItem : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayLineItem>, false> {
        WebCore::ApplePayLineItem::Type type;
        String label;
        String amount;
        WebCore::ApplePayPaymentTiming paymentTiming;
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        WallTime recurringPaymentStartDate;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        WebCore::ApplePayRecurringPaymentDateUnit recurringPaymentIntervalUnit;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        unsigned recurringPaymentIntervalCount;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        WallTime recurringPaymentEndDate;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
        WallTime deferredPaymentDate;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
        String automaticReloadPaymentThresholdAmount;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayLineItem) == sizeof(WebCore::ApplePayLineItem));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayLineItem, type)
        , offsetof(WebCore::ApplePayLineItem, label)
        , offsetof(WebCore::ApplePayLineItem, amount)
        , offsetof(WebCore::ApplePayLineItem, paymentTiming)
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, recurringPaymentStartDate)
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, recurringPaymentIntervalUnit)
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, recurringPaymentIntervalCount)
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, recurringPaymentEndDate)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, deferredPaymentDate)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
        , offsetof(WebCore::ApplePayLineItem, automaticReloadPaymentThresholdAmount)
#endif
    >::value);
    encoder << instance.type;
    encoder << instance.label;
    encoder << instance.amount;
    encoder << instance.paymentTiming;
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    encoder << instance.recurringPaymentStartDate;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    encoder << instance.recurringPaymentIntervalUnit;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    encoder << instance.recurringPaymentIntervalCount;
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    encoder << instance.recurringPaymentEndDate;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
    encoder << instance.deferredPaymentDate;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
    encoder << instance.automaticReloadPaymentThresholdAmount;
#endif
}

std::optional<WebCore::ApplePayLineItem> ArgumentCoder<WebCore::ApplePayLineItem>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::ApplePayLineItem::Type>();
    auto label = decoder.decode<String>();
    auto amount = decoder.decode<String>();
    auto paymentTiming = decoder.decode<WebCore::ApplePayPaymentTiming>();
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    auto recurringPaymentStartDate = decoder.decode<WallTime>();
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    auto recurringPaymentIntervalUnit = decoder.decode<WebCore::ApplePayRecurringPaymentDateUnit>();
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    auto recurringPaymentIntervalCount = decoder.decode<unsigned>();
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
    auto recurringPaymentEndDate = decoder.decode<WallTime>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
    auto deferredPaymentDate = decoder.decode<WallTime>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
    auto automaticReloadPaymentThresholdAmount = decoder.decode<String>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayLineItem {
            WTFMove(*type),
            WTFMove(*label),
            WTFMove(*amount),
            WTFMove(*paymentTiming),
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            WTFMove(*recurringPaymentStartDate),
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            WTFMove(*recurringPaymentIntervalUnit),
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            WTFMove(*recurringPaymentIntervalCount),
#endif
#if ENABLE(APPLE_PAY_RECURRING_LINE_ITEM)
            WTFMove(*recurringPaymentEndDate),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_LINE_ITEM)
            WTFMove(*deferredPaymentDate),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_LINE_ITEM)
            WTFMove(*automaticReloadPaymentThresholdAmount)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayShippingMethod>::encode(Encoder& encoder, const WebCore::ApplePayShippingMethod& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.detail)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, String>);
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dateComponentsRange)>, std::optional<WebCore::ApplePayDateComponentsRange>>);
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selected)>, bool>);
#endif
    struct ShouldBeSameSizeAsApplePayShippingMethod : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayShippingMethod>, false> {
        String label;
        String detail;
        String amount;
        String identifier;
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
        std::optional<WebCore::ApplePayDateComponentsRange> dateComponentsRange;
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
        bool selected;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayShippingMethod) == sizeof(WebCore::ApplePayShippingMethod));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayShippingMethod, label)
        , offsetof(WebCore::ApplePayShippingMethod, detail)
        , offsetof(WebCore::ApplePayShippingMethod, amount)
        , offsetof(WebCore::ApplePayShippingMethod, identifier)
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
        , offsetof(WebCore::ApplePayShippingMethod, dateComponentsRange)
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
        , offsetof(WebCore::ApplePayShippingMethod, selected)
#endif
    >::value);
    encoder << instance.label;
    encoder << instance.detail;
    encoder << instance.amount;
    encoder << instance.identifier;
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
    encoder << instance.dateComponentsRange;
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
    encoder << instance.selected;
#endif
}

std::optional<WebCore::ApplePayShippingMethod> ArgumentCoder<WebCore::ApplePayShippingMethod>::decode(Decoder& decoder)
{
    auto label = decoder.decode<String>();
    auto detail = decoder.decode<String>();
    auto amount = decoder.decode<String>();
    auto identifier = decoder.decode<String>();
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
    auto dateComponentsRange = decoder.decode<std::optional<WebCore::ApplePayDateComponentsRange>>();
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
    auto selected = decoder.decode<bool>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayShippingMethod {
            WTFMove(*label),
            WTFMove(*detail),
            WTFMove(*amount),
            WTFMove(*identifier),
#if ENABLE(APPLE_PAY_SHIPPING_METHOD_DATE_COMPONENTS_RANGE)
            WTFMove(*dateComponentsRange),
#endif
#if ENABLE(APPLE_PAY_SELECTED_SHIPPING_METHOD)
            WTFMove(*selected)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayError>::encode(Encoder& encoder, const WebCore::ApplePayError& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.code())>, WebCore::ApplePayErrorCode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contactField())>, std::optional<WebCore::ApplePayErrorContactField>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message())>, String>);
    encoder << instance.code();
    encoder << instance.contactField();
    encoder << instance.message();
}

std::optional<Ref<WebCore::ApplePayError>> ArgumentCoder<WebCore::ApplePayError>::decode(Decoder& decoder)
{
    auto code = decoder.decode<WebCore::ApplePayErrorCode>();
    auto contactField = decoder.decode<std::optional<WebCore::ApplePayErrorContactField>>();
    auto message = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayError::create(
            WTFMove(*code),
            WTFMove(*contactField),
            WTFMove(*message)
        )
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayLogoSystemImage>::encode(Encoder& encoder, const WebCore::ApplePayLogoSystemImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applePayLogoStyle())>, WebCore::ApplePayLogoStyle>);
    encoder << instance.applePayLogoStyle();
}

void ArgumentCoder<WebCore::ApplePayLogoSystemImage>::encode(StreamConnectionEncoder& encoder, const WebCore::ApplePayLogoSystemImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applePayLogoStyle())>, WebCore::ApplePayLogoStyle>);
    encoder << instance.applePayLogoStyle();
}

std::optional<Ref<WebCore::ApplePayLogoSystemImage>> ArgumentCoder<WebCore::ApplePayLogoSystemImage>::decode(Decoder& decoder)
{
    auto applePayLogoStyle = decoder.decode<WebCore::ApplePayLogoStyle>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayLogoSystemImage::create(
            WTFMove(*applePayLogoStyle)
        )
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayDetailsUpdateBase>::encode(Encoder& encoder, const WebCore::ApplePayDetailsUpdateBase& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
    struct ShouldBeSameSizeAsApplePayDetailsUpdateBase : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayDetailsUpdateBase>, false> {
        WebCore::ApplePayLineItem newTotal;
        Vector<WebCore::ApplePayLineItem> newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        std::optional<WebCore::ApplePayRecurringPaymentRequest> newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest> newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        std::optional<Vector<WebCore::ApplePayPaymentTokenContext>> newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        std::optional<WebCore::ApplePayDeferredPaymentRequest> newDeferredPaymentRequest;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayDetailsUpdateBase) == sizeof(WebCore::ApplePayDetailsUpdateBase));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
    >::value);
    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
}

std::optional<WebCore::ApplePayDetailsUpdateBase> ArgumentCoder<WebCore::ApplePayDetailsUpdateBase>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayDetailsUpdateBase {
            WTFMove(*newTotal),
            WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
            WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
            WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
            WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
            WTFMove(*newDeferredPaymentRequest)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayPaymentMethodUpdate>::encode(Encoder& encoder, const WebCore::ApplePayPaymentMethodUpdate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
    >::value);
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.errors)>, Vector<RefPtr<WebCore::ApplePayError>>>);
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newShippingMethods)>, Vector<WebCore::ApplePayShippingMethod>>);
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.installmentGroupIdentifier)>, String>);
#endif
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
        , offsetof(WebCore::ApplePayPaymentMethodUpdate, errors)
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
        , offsetof(WebCore::ApplePayPaymentMethodUpdate, newShippingMethods)
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
        , offsetof(WebCore::ApplePayPaymentMethodUpdate, installmentGroupIdentifier)
#endif
    >::value);
    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    encoder << instance.errors;
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    encoder << instance.newShippingMethods;
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
    encoder << instance.installmentGroupIdentifier;
#endif
}

std::optional<WebCore::ApplePayPaymentMethodUpdate> ArgumentCoder<WebCore::ApplePayPaymentMethodUpdate>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    auto errors = decoder.decode<Vector<RefPtr<WebCore::ApplePayError>>>();
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    auto newShippingMethods = decoder.decode<Vector<WebCore::ApplePayShippingMethod>>();
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
    auto installmentGroupIdentifier = decoder.decode<String>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayPaymentMethodUpdate {
            WebCore::ApplePayDetailsUpdateBase {
                WTFMove(*newTotal),
                WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
                WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
                WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
                WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
                WTFMove(*newDeferredPaymentRequest)
#endif
            },
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
            WTFMove(*errors),
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
            WTFMove(*newShippingMethods),
#endif
#if ENABLE(APPLE_PAY_INSTALLMENTS)
            WTFMove(*installmentGroupIdentifier)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayShippingContactUpdate>::encode(Encoder& encoder, const WebCore::ApplePayShippingContactUpdate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.errors)>, Vector<RefPtr<WebCore::ApplePayError>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newShippingMethods)>, Vector<WebCore::ApplePayShippingMethod>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayShippingContactUpdate, errors)
        , offsetof(WebCore::ApplePayShippingContactUpdate, newShippingMethods)
    >::value);
    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
    encoder << instance.errors;
    encoder << instance.newShippingMethods;
}

std::optional<WebCore::ApplePayShippingContactUpdate> ArgumentCoder<WebCore::ApplePayShippingContactUpdate>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
    auto errors = decoder.decode<Vector<RefPtr<WebCore::ApplePayError>>>();
    auto newShippingMethods = decoder.decode<Vector<WebCore::ApplePayShippingMethod>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayShippingContactUpdate {
            WebCore::ApplePayDetailsUpdateBase {
                WTFMove(*newTotal),
                WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
                WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
                WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
                WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
                WTFMove(*newDeferredPaymentRequest)
#endif
            },
            WTFMove(*errors),
            WTFMove(*newShippingMethods)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayShippingMethodUpdate>::encode(Encoder& encoder, const WebCore::ApplePayShippingMethodUpdate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
    >::value);
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newShippingMethods)>, Vector<WebCore::ApplePayShippingMethod>>);
#endif
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
        , offsetof(WebCore::ApplePayShippingMethodUpdate, newShippingMethods)
#endif
    >::value);
    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    encoder << instance.newShippingMethods;
#endif
}

std::optional<WebCore::ApplePayShippingMethodUpdate> ArgumentCoder<WebCore::ApplePayShippingMethodUpdate>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
    auto newShippingMethods = decoder.decode<Vector<WebCore::ApplePayShippingMethod>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayShippingMethodUpdate {
            WebCore::ApplePayDetailsUpdateBase {
                WTFMove(*newTotal),
                WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
                WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
                WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
                WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
                WTFMove(*newDeferredPaymentRequest)
#endif
            },
#if ENABLE(APPLE_PAY_UPDATE_SHIPPING_METHODS_WHEN_CHANGING_LINE_ITEMS)
            WTFMove(*newShippingMethods)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayPaymentAuthorizationResult>::encode(Encoder& encoder, const WebCore::ApplePayPaymentAuthorizationResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.status)>, unsigned short>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.errors)>, Vector<RefPtr<WebCore::ApplePayError>>>);
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.orderDetails)>, std::optional<WebCore::ApplePayPaymentOrderDetails>>);
#endif
    struct ShouldBeSameSizeAsApplePayPaymentAuthorizationResult : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayPaymentAuthorizationResult>, false> {
        unsigned short status;
        Vector<RefPtr<WebCore::ApplePayError>> errors;
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
        std::optional<WebCore::ApplePayPaymentOrderDetails> orderDetails;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayPaymentAuthorizationResult) == sizeof(WebCore::ApplePayPaymentAuthorizationResult));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayPaymentAuthorizationResult, status)
        , offsetof(WebCore::ApplePayPaymentAuthorizationResult, errors)
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
        , offsetof(WebCore::ApplePayPaymentAuthorizationResult, orderDetails)
#endif
    >::value);
    encoder << instance.status;
    encoder << instance.errors;
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
    encoder << instance.orderDetails;
#endif
}

std::optional<WebCore::ApplePayPaymentAuthorizationResult> ArgumentCoder<WebCore::ApplePayPaymentAuthorizationResult>::decode(Decoder& decoder)
{
    auto status = decoder.decode<unsigned short>();
    auto errors = decoder.decode<Vector<RefPtr<WebCore::ApplePayError>>>();
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
    auto orderDetails = decoder.decode<std::optional<WebCore::ApplePayPaymentOrderDetails>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayPaymentAuthorizationResult {
            WTFMove(*status),
            WTFMove(*errors),
#if ENABLE(APPLE_PAY_PAYMENT_ORDER_DETAILS)
            WTFMove(*orderDetails)
#endif
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_INSTALLMENTS)
void ArgumentCoder<WebCore::ApplePayInstallmentConfiguration>::encode(Encoder& encoder, const WebCore::ApplePayInstallmentConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.featureType)>, WebCore::ApplePaySetupFeatureType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchandisingImageData)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.openToBuyThresholdAmount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bindingTotalAmount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.currencyCode)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isInStorePurchase)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.merchantIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrerIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.items)>, Vector<WebCore::ApplePayInstallmentItem>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applicationMetadata)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.retailChannel)>, WebCore::ApplePayInstallmentRetailChannel>);
    struct ShouldBeSameSizeAsApplePayInstallmentConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayInstallmentConfiguration>, false> {
        WebCore::ApplePaySetupFeatureType featureType;
        String merchandisingImageData;
        String openToBuyThresholdAmount;
        String bindingTotalAmount;
        String currencyCode;
        bool isInStorePurchase;
        String merchantIdentifier;
        String referrerIdentifier;
        Vector<WebCore::ApplePayInstallmentItem> items;
        String applicationMetadata;
        WebCore::ApplePayInstallmentRetailChannel retailChannel;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayInstallmentConfiguration) == sizeof(WebCore::ApplePayInstallmentConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayInstallmentConfiguration, featureType)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, merchandisingImageData)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, openToBuyThresholdAmount)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, bindingTotalAmount)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, currencyCode)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, isInStorePurchase)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, merchantIdentifier)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, referrerIdentifier)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, items)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, applicationMetadata)
        , offsetof(WebCore::ApplePayInstallmentConfiguration, retailChannel)
    >::value);
    encoder << instance.featureType;
    encoder << instance.merchandisingImageData;
    encoder << instance.openToBuyThresholdAmount;
    encoder << instance.bindingTotalAmount;
    encoder << instance.currencyCode;
    encoder << instance.isInStorePurchase;
    encoder << instance.merchantIdentifier;
    encoder << instance.referrerIdentifier;
    encoder << instance.items;
    encoder << instance.applicationMetadata;
    encoder << instance.retailChannel;
}

std::optional<WebCore::ApplePayInstallmentConfiguration> ArgumentCoder<WebCore::ApplePayInstallmentConfiguration>::decode(Decoder& decoder)
{
    auto featureType = decoder.decode<WebCore::ApplePaySetupFeatureType>();
    auto merchandisingImageData = decoder.decode<String>();
    auto openToBuyThresholdAmount = decoder.decode<String>();
    auto bindingTotalAmount = decoder.decode<String>();
    auto currencyCode = decoder.decode<String>();
    auto isInStorePurchase = decoder.decode<bool>();
    auto merchantIdentifier = decoder.decode<String>();
    auto referrerIdentifier = decoder.decode<String>();
    auto items = decoder.decode<Vector<WebCore::ApplePayInstallmentItem>>();
    auto applicationMetadata = decoder.decode<String>();
    auto retailChannel = decoder.decode<WebCore::ApplePayInstallmentRetailChannel>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayInstallmentConfiguration {
            WTFMove(*featureType),
            WTFMove(*merchandisingImageData),
            WTFMove(*openToBuyThresholdAmount),
            WTFMove(*bindingTotalAmount),
            WTFMove(*currencyCode),
            WTFMove(*isInStorePurchase),
            WTFMove(*merchantIdentifier),
            WTFMove(*referrerIdentifier),
            WTFMove(*items),
            WTFMove(*applicationMetadata),
            WTFMove(*retailChannel)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_INSTALLMENTS)
void ArgumentCoder<WebCore::PaymentInstallmentConfiguration>::encode(Encoder& encoder, const WebCore::PaymentInstallmentConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.applePayInstallmentConfiguration())>, std::optional<WebCore::ApplePayInstallmentConfiguration>>);
    encoder << instance.applePayInstallmentConfiguration();
}

std::optional<WebCore::PaymentInstallmentConfiguration> ArgumentCoder<WebCore::PaymentInstallmentConfiguration>::decode(Decoder& decoder)
{
    auto applePayInstallmentConfiguration = decoder.decode<std::optional<WebCore::ApplePayInstallmentConfiguration>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PaymentInstallmentConfiguration {
            WTFMove(*applePayInstallmentConfiguration)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_INSTALLMENTS)
void ArgumentCoder<WebCore::ApplePayInstallmentItem>::encode(Encoder& encoder, const WebCore::ApplePayInstallmentItem& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ApplePayInstallmentItemType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amount)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.currencyCode)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.programIdentifier)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.apr)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.programTerms)>, String>);
    struct ShouldBeSameSizeAsApplePayInstallmentItem : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplePayInstallmentItem>, false> {
        WebCore::ApplePayInstallmentItemType type;
        String amount;
        String currencyCode;
        String programIdentifier;
        String apr;
        String programTerms;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplePayInstallmentItem) == sizeof(WebCore::ApplePayInstallmentItem));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayInstallmentItem, type)
        , offsetof(WebCore::ApplePayInstallmentItem, amount)
        , offsetof(WebCore::ApplePayInstallmentItem, currencyCode)
        , offsetof(WebCore::ApplePayInstallmentItem, programIdentifier)
        , offsetof(WebCore::ApplePayInstallmentItem, apr)
        , offsetof(WebCore::ApplePayInstallmentItem, programTerms)
    >::value);
    encoder << instance.type;
    encoder << instance.amount;
    encoder << instance.currencyCode;
    encoder << instance.programIdentifier;
    encoder << instance.apr;
    encoder << instance.programTerms;
}

std::optional<WebCore::ApplePayInstallmentItem> ArgumentCoder<WebCore::ApplePayInstallmentItem>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::ApplePayInstallmentItemType>();
    auto amount = decoder.decode<String>();
    auto currencyCode = decoder.decode<String>();
    auto programIdentifier = decoder.decode<String>();
    auto apr = decoder.decode<String>();
    auto programTerms = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayInstallmentItem {
            WTFMove(*type),
            WTFMove(*amount),
            WTFMove(*currencyCode),
            WTFMove(*programIdentifier),
            WTFMove(*apr),
            WTFMove(*programTerms)
        }
    };
}

#endif

#if ENABLE(APPLE_PAY_COUPON_CODE)
void ArgumentCoder<WebCore::ApplePayCouponCodeUpdate>::encode(Encoder& encoder, const WebCore::ApplePayCouponCodeUpdate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newTotal)>, WebCore::ApplePayLineItem>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newLineItems)>, Vector<WebCore::ApplePayLineItem>>);
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newRecurringPaymentRequest)>, std::optional<WebCore::ApplePayRecurringPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newAutomaticReloadPaymentRequest)>, std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>);
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newMultiTokenContexts)>, std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>);
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newDeferredPaymentRequest)>, std::optional<WebCore::ApplePayDeferredPaymentRequest>>);
#endif
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newTotal)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newLineItems)
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newRecurringPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newAutomaticReloadPaymentRequest)
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newMultiTokenContexts)
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
        , offsetof(WebCore::ApplePayDetailsUpdateBase, newDeferredPaymentRequest)
#endif
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.errors)>, Vector<RefPtr<WebCore::ApplePayError>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.newShippingMethods)>, Vector<WebCore::ApplePayShippingMethod>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplePayCouponCodeUpdate, errors)
        , offsetof(WebCore::ApplePayCouponCodeUpdate, newShippingMethods)
    >::value);
    encoder << instance.newTotal;
    encoder << instance.newLineItems;
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    encoder << instance.newRecurringPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    encoder << instance.newAutomaticReloadPaymentRequest;
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    encoder << instance.newMultiTokenContexts;
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    encoder << instance.newDeferredPaymentRequest;
#endif
    encoder << instance.errors;
    encoder << instance.newShippingMethods;
}

std::optional<WebCore::ApplePayCouponCodeUpdate> ArgumentCoder<WebCore::ApplePayCouponCodeUpdate>::decode(Decoder& decoder)
{
    auto newTotal = decoder.decode<WebCore::ApplePayLineItem>();
    auto newLineItems = decoder.decode<Vector<WebCore::ApplePayLineItem>>();
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
    auto newRecurringPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayRecurringPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
    auto newAutomaticReloadPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayAutomaticReloadPaymentRequest>>();
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
    auto newMultiTokenContexts = decoder.decode<std::optional<Vector<WebCore::ApplePayPaymentTokenContext>>>();
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
    auto newDeferredPaymentRequest = decoder.decode<std::optional<WebCore::ApplePayDeferredPaymentRequest>>();
#endif
    auto errors = decoder.decode<Vector<RefPtr<WebCore::ApplePayError>>>();
    auto newShippingMethods = decoder.decode<Vector<WebCore::ApplePayShippingMethod>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayCouponCodeUpdate {
            WebCore::ApplePayDetailsUpdateBase {
                WTFMove(*newTotal),
                WTFMove(*newLineItems),
#if ENABLE(APPLE_PAY_RECURRING_PAYMENTS)
                WTFMove(*newRecurringPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_AUTOMATIC_RELOAD_PAYMENTS)
                WTFMove(*newAutomaticReloadPaymentRequest),
#endif
#if ENABLE(APPLE_PAY_MULTI_MERCHANT_PAYMENTS)
                WTFMove(*newMultiTokenContexts),
#endif
#if ENABLE(APPLE_PAY_DEFERRED_PAYMENTS)
                WTFMove(*newDeferredPaymentRequest)
#endif
            },
            WTFMove(*errors),
            WTFMove(*newShippingMethods)
        }
    };
}

#endif

#if ENABLE(APPLICATION_MANIFEST)
void ArgumentCoder<WebCore::ApplicationManifest::Icon>::encode(Encoder& encoder, const WebCore::ApplicationManifest::Icon& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.src)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sizes)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.purposes)>, OptionSet<WebCore::ApplicationManifest::Icon::Purpose>>);
    struct ShouldBeSameSizeAsIcon : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplicationManifest::Icon>, false> {
        URL src;
        Vector<String> sizes;
        String type;
        OptionSet<WebCore::ApplicationManifest::Icon::Purpose> purposes;
    };
    static_assert(sizeof(ShouldBeSameSizeAsIcon) == sizeof(WebCore::ApplicationManifest::Icon));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplicationManifest::Icon, src)
        , offsetof(WebCore::ApplicationManifest::Icon, sizes)
        , offsetof(WebCore::ApplicationManifest::Icon, type)
        , offsetof(WebCore::ApplicationManifest::Icon, purposes)
    >::value);
    encoder << instance.src;
    encoder << instance.sizes;
    encoder << instance.type;
    encoder << instance.purposes;
}

std::optional<WebCore::ApplicationManifest::Icon> ArgumentCoder<WebCore::ApplicationManifest::Icon>::decode(Decoder& decoder)
{
    auto src = decoder.decode<URL>();
    auto sizes = decoder.decode<Vector<String>>();
    auto type = decoder.decode<String>();
    auto purposes = decoder.decode<OptionSet<WebCore::ApplicationManifest::Icon::Purpose>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplicationManifest::Icon {
            WTFMove(*src),
            WTFMove(*sizes),
            WTFMove(*type),
            WTFMove(*purposes)
        }
    };
}

#endif

#if ENABLE(APPLICATION_MANIFEST)
void ArgumentCoder<WebCore::ApplicationManifest>::encode(Encoder& encoder, const WebCore::ApplicationManifest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shortName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.description)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scope)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.display)>, WebCore::ApplicationManifest::Display>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.orientation)>, std::optional<WebCore::ScreenOrientationLockType>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.backgroundColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.themeColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icons)>, Vector<WebCore::ApplicationManifest::Icon>>);
    struct ShouldBeSameSizeAsApplicationManifest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ApplicationManifest>, false> {
        String name;
        String shortName;
        String description;
        URL scope;
        WebCore::ApplicationManifest::Display display;
        std::optional<WebCore::ScreenOrientationLockType> orientation;
        URL startURL;
        URL id;
        WebCore::Color backgroundColor;
        WebCore::Color themeColor;
        Vector<WebCore::ApplicationManifest::Icon> icons;
    };
    static_assert(sizeof(ShouldBeSameSizeAsApplicationManifest) == sizeof(WebCore::ApplicationManifest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ApplicationManifest, name)
        , offsetof(WebCore::ApplicationManifest, shortName)
        , offsetof(WebCore::ApplicationManifest, description)
        , offsetof(WebCore::ApplicationManifest, scope)
        , offsetof(WebCore::ApplicationManifest, display)
        , offsetof(WebCore::ApplicationManifest, orientation)
        , offsetof(WebCore::ApplicationManifest, startURL)
        , offsetof(WebCore::ApplicationManifest, id)
        , offsetof(WebCore::ApplicationManifest, backgroundColor)
        , offsetof(WebCore::ApplicationManifest, themeColor)
        , offsetof(WebCore::ApplicationManifest, icons)
    >::value);
    encoder << instance.name;
    encoder << instance.shortName;
    encoder << instance.description;
    encoder << instance.scope;
    encoder << instance.display;
    encoder << instance.orientation;
    encoder << instance.startURL;
    encoder << instance.id;
    encoder << instance.backgroundColor;
    encoder << instance.themeColor;
    encoder << instance.icons;
}

std::optional<WebCore::ApplicationManifest> ArgumentCoder<WebCore::ApplicationManifest>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto shortName = decoder.decode<String>();
    auto description = decoder.decode<String>();
    auto scope = decoder.decode<URL>();
    auto display = decoder.decode<WebCore::ApplicationManifest::Display>();
    auto orientation = decoder.decode<std::optional<WebCore::ScreenOrientationLockType>>();
    auto startURL = decoder.decode<URL>();
    auto id = decoder.decode<URL>();
    auto backgroundColor = decoder.decode<WebCore::Color>();
    auto themeColor = decoder.decode<WebCore::Color>();
    auto icons = decoder.decode<Vector<WebCore::ApplicationManifest::Icon>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplicationManifest {
            WTFMove(*name),
            WTFMove(*shortName),
            WTFMove(*description),
            WTFMove(*scope),
            WTFMove(*display),
            WTFMove(*orientation),
            WTFMove(*startURL),
            WTFMove(*id),
            WTFMove(*backgroundColor),
            WTFMove(*themeColor),
            WTFMove(*icons)
        }
    };
}

#endif

void ArgumentCoder<WebCore::RetrieveRecordsOptions>::encode(Encoder& encoder, const WebCore::RetrieveRecordsOptions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.crossOriginEmbedderPolicy)>, WebCore::CrossOriginEmbedderPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceOrigin)>, Ref<WebCore::SecurityOrigin>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreSearch)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreMethod)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ignoreVary)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shouldProvideResponse)>, bool>);
    struct ShouldBeSameSizeAsRetrieveRecordsOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::RetrieveRecordsOptions>, false> {
        WebCore::ResourceRequest request;
        WebCore::CrossOriginEmbedderPolicy crossOriginEmbedderPolicy;
        Ref<WebCore::SecurityOrigin> sourceOrigin;
        bool ignoreSearch;
        bool ignoreMethod;
        bool ignoreVary;
        bool shouldProvideResponse;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRetrieveRecordsOptions) == sizeof(WebCore::RetrieveRecordsOptions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::RetrieveRecordsOptions, request)
        , offsetof(WebCore::RetrieveRecordsOptions, crossOriginEmbedderPolicy)
        , offsetof(WebCore::RetrieveRecordsOptions, sourceOrigin)
        , offsetof(WebCore::RetrieveRecordsOptions, ignoreSearch)
        , offsetof(WebCore::RetrieveRecordsOptions, ignoreMethod)
        , offsetof(WebCore::RetrieveRecordsOptions, ignoreVary)
        , offsetof(WebCore::RetrieveRecordsOptions, shouldProvideResponse)
    >::value);
    encoder << instance.request;
    encoder << instance.crossOriginEmbedderPolicy;
    encoder << instance.sourceOrigin;
    encoder << instance.ignoreSearch;
    encoder << instance.ignoreMethod;
    encoder << instance.ignoreVary;
    encoder << instance.shouldProvideResponse;
}

std::optional<WebCore::RetrieveRecordsOptions> ArgumentCoder<WebCore::RetrieveRecordsOptions>::decode(Decoder& decoder)
{
    auto request = decoder.decode<WebCore::ResourceRequest>();
    auto crossOriginEmbedderPolicy = decoder.decode<WebCore::CrossOriginEmbedderPolicy>();
    auto sourceOrigin = decoder.decode<Ref<WebCore::SecurityOrigin>>();
    auto ignoreSearch = decoder.decode<bool>();
    auto ignoreMethod = decoder.decode<bool>();
    auto ignoreVary = decoder.decode<bool>();
    auto shouldProvideResponse = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::RetrieveRecordsOptions {
            WTFMove(*request),
            WTFMove(*crossOriginEmbedderPolicy),
            WTFMove(*sourceOrigin),
            WTFMove(*ignoreSearch),
            WTFMove(*ignoreMethod),
            WTFMove(*ignoreVary),
            WTFMove(*shouldProvideResponse)
        }
    };
}

void ArgumentCoder<WebCore::ContactInfo>::encode(Encoder& encoder, const WebCore::ContactInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.email)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tel)>, Vector<String>>);
    struct ShouldBeSameSizeAsContactInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ContactInfo>, false> {
        Vector<String> name;
        Vector<String> email;
        Vector<String> tel;
    };
    static_assert(sizeof(ShouldBeSameSizeAsContactInfo) == sizeof(WebCore::ContactInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ContactInfo, name)
        , offsetof(WebCore::ContactInfo, email)
        , offsetof(WebCore::ContactInfo, tel)
    >::value);
    encoder << instance.name;
    encoder << instance.email;
    encoder << instance.tel;
}

std::optional<WebCore::ContactInfo> ArgumentCoder<WebCore::ContactInfo>::decode(Decoder& decoder)
{
    auto name = decoder.decode<Vector<String>>();
    auto email = decoder.decode<Vector<String>>();
    auto tel = decoder.decode<Vector<String>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ContactInfo {
            WTFMove(*name),
            WTFMove(*email),
            WTFMove(*tel)
        }
    };
}

void ArgumentCoder<WebCore::ContactsRequestData>::encode(Encoder& encoder, const WebCore::ContactsRequestData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.properties)>, Vector<WebCore::ContactProperty>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.multiple)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, String>);
    struct ShouldBeSameSizeAsContactsRequestData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ContactsRequestData>, false> {
        Vector<WebCore::ContactProperty> properties;
        bool multiple;
        String url;
    };
    static_assert(sizeof(ShouldBeSameSizeAsContactsRequestData) == sizeof(WebCore::ContactsRequestData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ContactsRequestData, properties)
        , offsetof(WebCore::ContactsRequestData, multiple)
        , offsetof(WebCore::ContactsRequestData, url)
    >::value);
    encoder << instance.properties;
    encoder << instance.multiple;
    encoder << instance.url;
}

std::optional<WebCore::ContactsRequestData> ArgumentCoder<WebCore::ContactsRequestData>::decode(Decoder& decoder)
{
    auto properties = decoder.decode<Vector<WebCore::ContactProperty>>();
    auto multiple = decoder.decode<bool>();
    auto url = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ContactsRequestData {
            WTFMove(*properties),
            WTFMove(*multiple),
            WTFMove(*url)
        }
    };
}

#if ENABLE(MEDIA_SESSION)
void ArgumentCoder<WebCore::MediaPositionState>::encode(Encoder& encoder, const WebCore::MediaPositionState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.duration)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.playbackRate)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.position)>, double>);
    struct ShouldBeSameSizeAsMediaPositionState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MediaPositionState>, false> {
        double duration;
        double playbackRate;
        double position;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaPositionState) == sizeof(WebCore::MediaPositionState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaPositionState, duration)
        , offsetof(WebCore::MediaPositionState, playbackRate)
        , offsetof(WebCore::MediaPositionState, position)
    >::value);
    encoder << instance.duration;
    encoder << instance.playbackRate;
    encoder << instance.position;
}

std::optional<WebCore::MediaPositionState> ArgumentCoder<WebCore::MediaPositionState>::decode(Decoder& decoder)
{
    auto duration = decoder.decode<double>();
    auto playbackRate = decoder.decode<double>();
    auto position = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaPositionState {
            WTFMove(*duration),
            WTFMove(*playbackRate),
            WTFMove(*position)
        }
    };
}

#endif

#if ENABLE(WEB_RTC)
void ArgumentCoder<WebCore::DetachedRTCDataChannel>::encode(Encoder& encoder, const WebCore::DetachedRTCDataChannel& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::RTCDataChannelIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, WebCore::RTCDataChannelInit>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.state)>, WebCore::RTCDataChannelState>);
    struct ShouldBeSameSizeAsDetachedRTCDataChannel : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DetachedRTCDataChannel>, false> {
        WebCore::RTCDataChannelIdentifier identifier;
        String label;
        WebCore::RTCDataChannelInit options;
        WebCore::RTCDataChannelState state;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDetachedRTCDataChannel) == sizeof(WebCore::DetachedRTCDataChannel));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DetachedRTCDataChannel, identifier)
        , offsetof(WebCore::DetachedRTCDataChannel, label)
        , offsetof(WebCore::DetachedRTCDataChannel, options)
        , offsetof(WebCore::DetachedRTCDataChannel, state)
    >::value);
    encoder << instance.identifier;
    encoder << instance.label;
    encoder << instance.options;
    encoder << instance.state;
}

std::optional<WebCore::DetachedRTCDataChannel> ArgumentCoder<WebCore::DetachedRTCDataChannel>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::RTCDataChannelIdentifier>();
    auto label = decoder.decode<String>();
    auto options = decoder.decode<WebCore::RTCDataChannelInit>();
    auto state = decoder.decode<WebCore::RTCDataChannelState>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DetachedRTCDataChannel {
            WTFMove(*identifier),
            WTFMove(*label),
            WTFMove(*options),
            WTFMove(*state)
        }
    };
}

#endif

#if ENABLE(WEB_CODECS)
void ArgumentCoder<WebCore::WebCodecsEncodedVideoChunkData>::encode(Encoder& encoder, const WebCore::WebCodecsEncodedVideoChunkData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::WebCodecsEncodedVideoChunkType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timestamp)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.duration)>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.buffer)>, Vector<uint8_t>>);
    struct ShouldBeSameSizeAsWebCodecsEncodedVideoChunkData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::WebCodecsEncodedVideoChunkData>, false> {
        WebCore::WebCodecsEncodedVideoChunkType type;
        int64_t timestamp;
        std::optional<uint64_t> duration;
        Vector<uint8_t> buffer;
    };
    static_assert(sizeof(ShouldBeSameSizeAsWebCodecsEncodedVideoChunkData) == sizeof(WebCore::WebCodecsEncodedVideoChunkData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::WebCodecsEncodedVideoChunkData, type)
        , offsetof(WebCore::WebCodecsEncodedVideoChunkData, timestamp)
        , offsetof(WebCore::WebCodecsEncodedVideoChunkData, duration)
        , offsetof(WebCore::WebCodecsEncodedVideoChunkData, buffer)
    >::value);
    encoder << instance.type;
    encoder << instance.timestamp;
    encoder << instance.duration;
    encoder << instance.buffer;
}

std::optional<WebCore::WebCodecsEncodedVideoChunkData> ArgumentCoder<WebCore::WebCodecsEncodedVideoChunkData>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::WebCodecsEncodedVideoChunkType>();
    auto timestamp = decoder.decode<int64_t>();
    auto duration = decoder.decode<std::optional<uint64_t>>();
    auto buffer = decoder.decode<Vector<uint8_t>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::WebCodecsEncodedVideoChunkData {
            WTFMove(*type),
            WTFMove(*timestamp),
            WTFMove(*duration),
            WTFMove(*buffer)
        }
    };
}

#endif

void ArgumentCoder<WebCore::HTMLModelElementCamera>::encode(Encoder& encoder, const WebCore::HTMLModelElementCamera& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pitch)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.yaw)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scale)>, double>);
    struct ShouldBeSameSizeAsHTMLModelElementCamera : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::HTMLModelElementCamera>, false> {
        double pitch;
        double yaw;
        double scale;
    };
    static_assert(sizeof(ShouldBeSameSizeAsHTMLModelElementCamera) == sizeof(WebCore::HTMLModelElementCamera));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::HTMLModelElementCamera, pitch)
        , offsetof(WebCore::HTMLModelElementCamera, yaw)
        , offsetof(WebCore::HTMLModelElementCamera, scale)
    >::value);
    encoder << instance.pitch;
    encoder << instance.yaw;
    encoder << instance.scale;
}

std::optional<WebCore::HTMLModelElementCamera> ArgumentCoder<WebCore::HTMLModelElementCamera>::decode(Decoder& decoder)
{
    auto pitch = decoder.decode<double>();
    auto yaw = decoder.decode<double>();
    auto scale = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::HTMLModelElementCamera {
            WTFMove(*pitch),
            WTFMove(*yaw),
            WTFMove(*scale)
        }
    };
}

void ArgumentCoder<WebCore::NotificationData>::encode(Encoder& encoder, const WebCore::NotificationData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.title)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.body)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.iconURL)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tag)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.language)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::NotificationDirection>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.originString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serviceWorkerRegistrationURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.notificationID)>, WTF::UUID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contextIdentifier)>, WebCore::ScriptExecutionContextIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceSession)>, PAL::SessionID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.creationTime)>, MonotonicTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, Vector<uint8_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.silent)>, std::optional<bool>>);
    struct ShouldBeSameSizeAsNotificationData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::NotificationData>, false> {
        String title;
        String body;
        String iconURL;
        String tag;
        String language;
        WebCore::NotificationDirection direction;
        String originString;
        URL serviceWorkerRegistrationURL;
        WTF::UUID notificationID;
        WebCore::ScriptExecutionContextIdentifier contextIdentifier;
        PAL::SessionID sourceSession;
        MonotonicTime creationTime;
        Vector<uint8_t> data;
        std::optional<bool> silent;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNotificationData) == sizeof(WebCore::NotificationData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::NotificationData, title)
        , offsetof(WebCore::NotificationData, body)
        , offsetof(WebCore::NotificationData, iconURL)
        , offsetof(WebCore::NotificationData, tag)
        , offsetof(WebCore::NotificationData, language)
        , offsetof(WebCore::NotificationData, direction)
        , offsetof(WebCore::NotificationData, originString)
        , offsetof(WebCore::NotificationData, serviceWorkerRegistrationURL)
        , offsetof(WebCore::NotificationData, notificationID)
        , offsetof(WebCore::NotificationData, contextIdentifier)
        , offsetof(WebCore::NotificationData, sourceSession)
        , offsetof(WebCore::NotificationData, creationTime)
        , offsetof(WebCore::NotificationData, data)
        , offsetof(WebCore::NotificationData, silent)
    >::value);
    encoder << instance.title;
    encoder << instance.body;
    encoder << instance.iconURL;
    encoder << instance.tag;
    encoder << instance.language;
    encoder << instance.direction;
    encoder << instance.originString;
    encoder << instance.serviceWorkerRegistrationURL;
    encoder << instance.notificationID;
    encoder << instance.contextIdentifier;
    encoder << instance.sourceSession;
    encoder << instance.creationTime;
    encoder << instance.data;
    encoder << instance.silent;
}

std::optional<WebCore::NotificationData> ArgumentCoder<WebCore::NotificationData>::decode(Decoder& decoder)
{
    auto title = decoder.decode<String>();
    auto body = decoder.decode<String>();
    auto iconURL = decoder.decode<String>();
    auto tag = decoder.decode<String>();
    auto language = decoder.decode<String>();
    auto direction = decoder.decode<WebCore::NotificationDirection>();
    auto originString = decoder.decode<String>();
    auto serviceWorkerRegistrationURL = decoder.decode<URL>();
    auto notificationID = decoder.decode<WTF::UUID>();
    auto contextIdentifier = decoder.decode<WebCore::ScriptExecutionContextIdentifier>();
    auto sourceSession = decoder.decode<PAL::SessionID>();
    auto creationTime = decoder.decode<MonotonicTime>();
    auto data = decoder.decode<Vector<uint8_t>>();
    auto silent = decoder.decode<std::optional<bool>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::NotificationData {
            WTFMove(*title),
            WTFMove(*body),
            WTFMove(*iconURL),
            WTFMove(*tag),
            WTFMove(*language),
            WTFMove(*direction),
            WTFMove(*originString),
            WTFMove(*serviceWorkerRegistrationURL),
            WTFMove(*notificationID),
            WTFMove(*contextIdentifier),
            WTFMove(*sourceSession),
            WTFMove(*creationTime),
            WTFMove(*data),
            WTFMove(*silent)
        }
    };
}

void ArgumentCoder<WebCore::PermissionDescriptor>::encode(Encoder& encoder, const WebCore::PermissionDescriptor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, WebCore::PermissionName>);
    struct ShouldBeSameSizeAsPermissionDescriptor : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PermissionDescriptor>, false> {
        WebCore::PermissionName name;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPermissionDescriptor) == sizeof(WebCore::PermissionDescriptor));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PermissionDescriptor, name)
    >::value);
    encoder << instance.name;
}

std::optional<WebCore::PermissionDescriptor> ArgumentCoder<WebCore::PermissionDescriptor>::decode(Decoder& decoder)
{
    auto name = decoder.decode<WebCore::PermissionName>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PermissionDescriptor {
            WTFMove(*name)
        }
    };
}

#if ENABLE(SERVICE_WORKER)
void ArgumentCoder<WebCore::PushSubscriptionData>::encode(Encoder& encoder, const WebCore::PushSubscriptionData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::PushSubscriptionIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endpoint)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expirationTime)>, std::optional<WebCore::EpochTimeStamp>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serverVAPIDPublicKey)>, Vector<uint8_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientECDHPublicKey)>, Vector<uint8_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sharedAuthenticationSecret)>, Vector<uint8_t>>);
    struct ShouldBeSameSizeAsPushSubscriptionData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PushSubscriptionData>, false> {
        WebCore::PushSubscriptionIdentifier identifier;
        String endpoint;
        std::optional<WebCore::EpochTimeStamp> expirationTime;
        Vector<uint8_t> serverVAPIDPublicKey;
        Vector<uint8_t> clientECDHPublicKey;
        Vector<uint8_t> sharedAuthenticationSecret;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPushSubscriptionData) == sizeof(WebCore::PushSubscriptionData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PushSubscriptionData, identifier)
        , offsetof(WebCore::PushSubscriptionData, endpoint)
        , offsetof(WebCore::PushSubscriptionData, expirationTime)
        , offsetof(WebCore::PushSubscriptionData, serverVAPIDPublicKey)
        , offsetof(WebCore::PushSubscriptionData, clientECDHPublicKey)
        , offsetof(WebCore::PushSubscriptionData, sharedAuthenticationSecret)
    >::value);
    encoder << instance.identifier;
    encoder << instance.endpoint;
    encoder << instance.expirationTime;
    encoder << instance.serverVAPIDPublicKey;
    encoder << instance.clientECDHPublicKey;
    encoder << instance.sharedAuthenticationSecret;
}

std::optional<WebCore::PushSubscriptionData> ArgumentCoder<WebCore::PushSubscriptionData>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::PushSubscriptionIdentifier>();
    auto endpoint = decoder.decode<String>();
    auto expirationTime = decoder.decode<std::optional<WebCore::EpochTimeStamp>>();
    auto serverVAPIDPublicKey = decoder.decode<Vector<uint8_t>>();
    auto clientECDHPublicKey = decoder.decode<Vector<uint8_t>>();
    auto sharedAuthenticationSecret = decoder.decode<Vector<uint8_t>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PushSubscriptionData {
            WTFMove(*identifier),
            WTFMove(*endpoint),
            WTFMove(*expirationTime),
            WTFMove(*serverVAPIDPublicKey),
            WTFMove(*clientECDHPublicKey),
            WTFMove(*sharedAuthenticationSecret)
        }
    };
}

#endif

void ArgumentCoder<WebCore::DeprecationReportBody>::encode(Encoder& encoder, const WebCore::DeprecationReportBody& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.anticipatedRemoval())>, WallTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceFile())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lineNumber())>, std::optional<unsigned>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.columnNumber())>, std::optional<unsigned>>);
    encoder << instance.id();
    encoder << instance.anticipatedRemoval();
    encoder << instance.message();
    encoder << instance.sourceFile();
    encoder << instance.lineNumber();
    encoder << instance.columnNumber();
}

std::optional<Ref<WebCore::DeprecationReportBody>> ArgumentCoder<WebCore::DeprecationReportBody>::decode(Decoder& decoder)
{
    auto id = decoder.decode<String>();
    auto anticipatedRemoval = decoder.decode<WallTime>();
    auto message = decoder.decode<String>();
    auto sourceFile = decoder.decode<String>();
    auto lineNumber = decoder.decode<std::optional<unsigned>>();
    auto columnNumber = decoder.decode<std::optional<unsigned>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DeprecationReportBody::create(
            WTFMove(*id),
            WTFMove(*anticipatedRemoval),
            WTFMove(*message),
            WTFMove(*sourceFile),
            WTFMove(*lineNumber),
            WTFMove(*columnNumber)
        )
    };
}

void ArgumentCoder<WebCore::Report>::encode(Encoder& encoder, const WebCore::Report& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.body())>, RefPtr<WebCore::ReportBody>>);
    encoder << instance.type();
    encoder << instance.url();
    encoder << instance.body();
}

std::optional<Ref<WebCore::Report>> ArgumentCoder<WebCore::Report>::decode(Decoder& decoder)
{
    auto type = decoder.decode<String>();
    auto url = decoder.decode<String>();
    auto body = decoder.decode<RefPtr<WebCore::ReportBody>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::Report::create(
            WTFMove(*type),
            WTFMove(*url),
            WTFMove(*body)
        )
    };
}

void ArgumentCoder<WebCore::TestReportBody>::encode(Encoder& encoder, const WebCore::TestReportBody& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message())>, String>);
    encoder << instance.message();
}

std::optional<Ref<WebCore::TestReportBody>> ArgumentCoder<WebCore::TestReportBody>::decode(Decoder& decoder)
{
    auto message = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TestReportBody::create(
            WTFMove(*message)
        )
    };
}

void ArgumentCoder<WebCore::SpeechRecognitionError>::encode(Encoder& encoder, const WebCore::SpeechRecognitionError& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::SpeechRecognitionErrorType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message)>, String>);
    struct ShouldBeSameSizeAsSpeechRecognitionError : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SpeechRecognitionError>, false> {
        WebCore::SpeechRecognitionErrorType type;
        String message;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSpeechRecognitionError) == sizeof(WebCore::SpeechRecognitionError));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SpeechRecognitionError, type)
        , offsetof(WebCore::SpeechRecognitionError, message)
    >::value);
    encoder << instance.type;
    encoder << instance.message;
}

std::optional<WebCore::SpeechRecognitionError> ArgumentCoder<WebCore::SpeechRecognitionError>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::SpeechRecognitionErrorType>();
    auto message = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SpeechRecognitionError {
            WTFMove(*type),
            WTFMove(*message)
        }
    };
}

void ArgumentCoder<WebCore::SpeechRecognitionRequestInfo>::encode(Encoder& encoder, const WebCore::SpeechRecognitionRequestInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientIdentifier)>, WebCore::SpeechRecognitionConnectionClientIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lang)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.continuous)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.interimResults)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maxAlternatives)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientOrigin)>, WebCore::ClientOrigin>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameIdentifier)>, WebCore::FrameIdentifier>);
    struct ShouldBeSameSizeAsSpeechRecognitionRequestInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SpeechRecognitionRequestInfo>, false> {
        WebCore::SpeechRecognitionConnectionClientIdentifier clientIdentifier;
        String lang;
        bool continuous;
        bool interimResults;
        uint64_t maxAlternatives;
        WebCore::ClientOrigin clientOrigin;
        WebCore::FrameIdentifier frameIdentifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSpeechRecognitionRequestInfo) == sizeof(WebCore::SpeechRecognitionRequestInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SpeechRecognitionRequestInfo, clientIdentifier)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, lang)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, continuous)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, interimResults)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, maxAlternatives)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, clientOrigin)
        , offsetof(WebCore::SpeechRecognitionRequestInfo, frameIdentifier)
    >::value);
    encoder << instance.clientIdentifier;
    encoder << instance.lang;
    encoder << instance.continuous;
    encoder << instance.interimResults;
    encoder << instance.maxAlternatives;
    encoder << instance.clientOrigin;
    encoder << instance.frameIdentifier;
}

std::optional<WebCore::SpeechRecognitionRequestInfo> ArgumentCoder<WebCore::SpeechRecognitionRequestInfo>::decode(Decoder& decoder)
{
    auto clientIdentifier = decoder.decode<WebCore::SpeechRecognitionConnectionClientIdentifier>();
    auto lang = decoder.decode<String>();
    auto continuous = decoder.decode<bool>();
    auto interimResults = decoder.decode<bool>();
    auto maxAlternatives = decoder.decode<uint64_t>();
    auto clientOrigin = decoder.decode<WebCore::ClientOrigin>();
    auto frameIdentifier = decoder.decode<WebCore::FrameIdentifier>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SpeechRecognitionRequestInfo {
            WTFMove(*clientIdentifier),
            WTFMove(*lang),
            WTFMove(*continuous),
            WTFMove(*interimResults),
            WTFMove(*maxAlternatives),
            WTFMove(*clientOrigin),
            WTFMove(*frameIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::SpeechRecognitionAlternativeData>::encode(Encoder& encoder, const WebCore::SpeechRecognitionAlternativeData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.transcript)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.confidence)>, double>);
    struct ShouldBeSameSizeAsSpeechRecognitionAlternativeData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SpeechRecognitionAlternativeData>, false> {
        String transcript;
        double confidence;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSpeechRecognitionAlternativeData) == sizeof(WebCore::SpeechRecognitionAlternativeData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SpeechRecognitionAlternativeData, transcript)
        , offsetof(WebCore::SpeechRecognitionAlternativeData, confidence)
    >::value);
    encoder << instance.transcript;
    encoder << instance.confidence;
}

std::optional<WebCore::SpeechRecognitionAlternativeData> ArgumentCoder<WebCore::SpeechRecognitionAlternativeData>::decode(Decoder& decoder)
{
    auto transcript = decoder.decode<String>();
    auto confidence = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SpeechRecognitionAlternativeData {
            WTFMove(*transcript),
            WTFMove(*confidence)
        }
    };
}

void ArgumentCoder<WebCore::SpeechRecognitionResultData>::encode(Encoder& encoder, const WebCore::SpeechRecognitionResultData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alternatives)>, Vector<WebCore::SpeechRecognitionAlternativeData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFinal)>, bool>);
    struct ShouldBeSameSizeAsSpeechRecognitionResultData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SpeechRecognitionResultData>, false> {
        Vector<WebCore::SpeechRecognitionAlternativeData> alternatives;
        bool isFinal;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSpeechRecognitionResultData) == sizeof(WebCore::SpeechRecognitionResultData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SpeechRecognitionResultData, alternatives)
        , offsetof(WebCore::SpeechRecognitionResultData, isFinal)
    >::value);
    encoder << instance.alternatives;
    encoder << instance.isFinal;
}

std::optional<WebCore::SpeechRecognitionResultData> ArgumentCoder<WebCore::SpeechRecognitionResultData>::decode(Decoder& decoder)
{
    auto alternatives = decoder.decode<Vector<WebCore::SpeechRecognitionAlternativeData>>();
    auto isFinal = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SpeechRecognitionResultData {
            WTFMove(*alternatives),
            WTFMove(*isFinal)
        }
    };
}

void ArgumentCoder<WebCore::WebLockManagerSnapshot>::encode(Encoder& encoder, const WebCore::WebLockManagerSnapshot& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.held)>, Vector<WebCore::WebLockManagerSnapshot::Info>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pending)>, Vector<WebCore::WebLockManagerSnapshot::Info>>);
    struct ShouldBeSameSizeAsWebLockManagerSnapshot : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::WebLockManagerSnapshot>, false> {
        Vector<WebCore::WebLockManagerSnapshot::Info> held;
        Vector<WebCore::WebLockManagerSnapshot::Info> pending;
    };
    static_assert(sizeof(ShouldBeSameSizeAsWebLockManagerSnapshot) == sizeof(WebCore::WebLockManagerSnapshot));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::WebLockManagerSnapshot, held)
        , offsetof(WebCore::WebLockManagerSnapshot, pending)
    >::value);
    encoder << instance.held;
    encoder << instance.pending;
}

std::optional<WebCore::WebLockManagerSnapshot> ArgumentCoder<WebCore::WebLockManagerSnapshot>::decode(Decoder& decoder)
{
    auto held = decoder.decode<Vector<WebCore::WebLockManagerSnapshot::Info>>();
    auto pending = decoder.decode<Vector<WebCore::WebLockManagerSnapshot::Info>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::WebLockManagerSnapshot {
            WTFMove(*held),
            WTFMove(*pending)
        }
    };
}

void ArgumentCoder<WebCore::WebLockManagerSnapshot::Info>::encode(Encoder& encoder, const WebCore::WebLockManagerSnapshot::Info& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mode)>, WebCore::WebLockMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientId)>, String>);
    struct ShouldBeSameSizeAsInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::WebLockManagerSnapshot::Info>, false> {
        String name;
        WebCore::WebLockMode mode;
        String clientId;
    };
    static_assert(sizeof(ShouldBeSameSizeAsInfo) == sizeof(WebCore::WebLockManagerSnapshot::Info));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::WebLockManagerSnapshot::Info, name)
        , offsetof(WebCore::WebLockManagerSnapshot::Info, mode)
        , offsetof(WebCore::WebLockManagerSnapshot::Info, clientId)
    >::value);
    encoder << instance.name;
    encoder << instance.mode;
    encoder << instance.clientId;
}

std::optional<WebCore::WebLockManagerSnapshot::Info> ArgumentCoder<WebCore::WebLockManagerSnapshot::Info>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto mode = decoder.decode<WebCore::WebLockMode>();
    auto clientId = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::WebLockManagerSnapshot::Info {
            WTFMove(*name),
            WTFMove(*mode),
            WTFMove(*clientId)
        }
    };
}

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.support)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.read)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.write)>, std::optional<WebCore::BufferSource>>);
    struct ShouldBeSameSizeAsLargeBlobInputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>, false> {
        String support;
        std::optional<bool> read;
        std::optional<WebCore::BufferSource> write;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLargeBlobInputs) == sizeof(WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs, support)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs, read)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs, write)
    >::value);
    encoder << instance.support;
    encoder << instance.read;
    encoder << instance.write;
}

std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>::decode(Decoder& decoder)
{
    auto support = decoder.decode<String>();
    auto read = decoder.decode<std::optional<bool>>();
    auto write = decoder.decode<std::optional<WebCore::BufferSource>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs {
            WTFMove(*support),
            WTFMove(*read),
            WTFMove(*write)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientInputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.appid)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.credProps)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.largeBlob)>, std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>>);
    struct ShouldBeSameSizeAsAuthenticationExtensionsClientInputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientInputs>, false> {
        String appid;
        bool credProps;
        std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs> largeBlob;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuthenticationExtensionsClientInputs) == sizeof(WebCore::AuthenticationExtensionsClientInputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientInputs, appid)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs, credProps)
        , offsetof(WebCore::AuthenticationExtensionsClientInputs, largeBlob)
    >::value);
    encoder << instance.appid;
    encoder << instance.largeBlob;
}

std::optional<WebCore::AuthenticationExtensionsClientInputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientInputs>::decode(Decoder& decoder)
{
    auto appid = decoder.decode<String>();
    auto largeBlob = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientInputs::LargeBlobInputs>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    WebCore::AuthenticationExtensionsClientInputs result;
    result.appid = WTFMove(*appid);
    result.largeBlob = WTFMove(*largeBlob);
    return { WTFMove(result) };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rk)>, bool>);
    struct ShouldBeSameSizeAsCredentialPropertiesOutput : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput>, false> {
        bool rk;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCredentialPropertiesOutput) == sizeof(WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput, rk)
    >::value);
    encoder << instance.rk;
}

std::optional<WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput> ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput>::decode(Decoder& decoder)
{
    auto rk = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput {
            WTFMove(*rk)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.supported)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blob)>, RefPtr<JSC::ArrayBuffer>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.written)>, std::optional<bool>>);
    struct ShouldBeSameSizeAsLargeBlobOutputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>, false> {
        std::optional<bool> supported;
        RefPtr<JSC::ArrayBuffer> blob;
        std::optional<bool> written;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLargeBlobOutputs) == sizeof(WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs, supported)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs, blob)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs, written)
    >::value);
    encoder << instance.supported;
    encoder << instance.blob;
    encoder << instance.written;
}

std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>::decode(Decoder& decoder)
{
    auto supported = decoder.decode<std::optional<bool>>();
    auto blob = decoder.decode<RefPtr<JSC::ArrayBuffer>>();
    auto written = decoder.decode<std::optional<bool>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs {
            WTFMove(*supported),
            WTFMove(*blob),
            WTFMove(*written)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs>::encode(Encoder& encoder, const WebCore::AuthenticationExtensionsClientOutputs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.appid)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.credProps)>, std::optional<WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.largeBlob)>, std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>>);
    struct ShouldBeSameSizeAsAuthenticationExtensionsClientOutputs : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AuthenticationExtensionsClientOutputs>, false> {
        std::optional<bool> appid;
        std::optional<WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput> credProps;
        std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs> largeBlob;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuthenticationExtensionsClientOutputs) == sizeof(WebCore::AuthenticationExtensionsClientOutputs));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs, appid)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs, credProps)
        , offsetof(WebCore::AuthenticationExtensionsClientOutputs, largeBlob)
    >::value);
    encoder << instance.appid;
    encoder << instance.credProps;
    encoder << instance.largeBlob;
}

std::optional<WebCore::AuthenticationExtensionsClientOutputs> ArgumentCoder<WebCore::AuthenticationExtensionsClientOutputs>::decode(Decoder& decoder)
{
    auto appid = decoder.decode<std::optional<bool>>();
    auto credProps = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientOutputs::CredentialPropertiesOutput>>();
    auto largeBlob = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientOutputs::LargeBlobOutputs>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::AuthenticationExtensionsClientOutputs {
            WTFMove(*appid),
            WTFMove(*credProps),
            WTFMove(*largeBlob)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::Parameters>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialCreationOptions::Parameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::PublicKeyCredentialType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alg)>, int64_t>);
    struct ShouldBeSameSizeAsParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialCreationOptions::Parameters>, false> {
        WebCore::PublicKeyCredentialType type;
        int64_t alg;
    };
    static_assert(sizeof(ShouldBeSameSizeAsParameters) == sizeof(WebCore::PublicKeyCredentialCreationOptions::Parameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::Parameters, type)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::Parameters, alg)
    >::value);
    encoder << instance.type;
    encoder << instance.alg;
}

std::optional<WebCore::PublicKeyCredentialCreationOptions::Parameters> ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::Parameters>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::PublicKeyCredentialType>();
    auto alg = decoder.decode<int64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialCreationOptions::Parameters {
            WTFMove(*type),
            WTFMove(*alg)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.authenticatorAttachment)>, std::optional<WebCore::AuthenticatorAttachment>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.residentKey)>, std::optional<WebCore::ResidentKeyRequirement>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requireResidentKey)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userVerification)>, WebCore::UserVerificationRequirement>);
    struct ShouldBeSameSizeAsAuthenticatorSelectionCriteria : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria>, false> {
        std::optional<WebCore::AuthenticatorAttachment> authenticatorAttachment;
        std::optional<WebCore::ResidentKeyRequirement> residentKey;
        bool requireResidentKey;
        WebCore::UserVerificationRequirement userVerification;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAuthenticatorSelectionCriteria) == sizeof(WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria, authenticatorAttachment)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria, residentKey)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria, requireResidentKey)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria, userVerification)
    >::value);
    encoder << instance.authenticatorAttachment;
    encoder << instance.residentKey;
    encoder << instance.requireResidentKey;
    encoder << instance.userVerification;
}

std::optional<WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria> ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria>::decode(Decoder& decoder)
{
    auto authenticatorAttachment = decoder.decode<std::optional<WebCore::AuthenticatorAttachment>>();
    auto residentKey = decoder.decode<std::optional<WebCore::ResidentKeyRequirement>>();
    auto requireResidentKey = decoder.decode<bool>();
    auto userVerification = decoder.decode<WebCore::UserVerificationRequirement>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria {
            WTFMove(*authenticatorAttachment),
            WTFMove(*residentKey),
            WTFMove(*requireResidentKey),
            WTFMove(*userVerification)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::Entity>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialCreationOptions::Entity& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icon)>, String>);
    struct ShouldBeSameSizeAsEntity : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialCreationOptions::Entity>, false> {
        String name;
        String icon;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEntity) == sizeof(WebCore::PublicKeyCredentialCreationOptions::Entity));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::Entity, name)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::Entity, icon)
    >::value);
    encoder << instance.name;
    encoder << instance.icon;
}

std::optional<WebCore::PublicKeyCredentialCreationOptions::Entity> ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::Entity>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto icon = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialCreationOptions::Entity {
            WTFMove(*name),
            WTFMove(*icon)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::RpEntity>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialCreationOptions::RpEntity& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icon)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::Entity, name)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::Entity, icon)
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, std::optional<String>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::RpEntity, id)
    >::value);
    encoder << instance.name;
    encoder << instance.icon;
    encoder << instance.id;
}

std::optional<WebCore::PublicKeyCredentialCreationOptions::RpEntity> ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::RpEntity>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto icon = decoder.decode<String>();
    auto id = decoder.decode<std::optional<String>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialCreationOptions::RpEntity {
            WebCore::PublicKeyCredentialCreationOptions::Entity {
                WTFMove(*name),
                WTFMove(*icon)
            },
            WTFMove(*id)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::UserEntity>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialCreationOptions::UserEntity& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icon)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::Entity, name)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::Entity, icon)
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, WebCore::BufferSource>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.displayName)>, String>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::UserEntity, id)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions::UserEntity, displayName)
    >::value);
    encoder << instance.name;
    encoder << instance.icon;
    encoder << instance.id;
    encoder << instance.displayName;
}

std::optional<WebCore::PublicKeyCredentialCreationOptions::UserEntity> ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions::UserEntity>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto icon = decoder.decode<String>();
    auto id = decoder.decode<WebCore::BufferSource>();
    auto displayName = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialCreationOptions::UserEntity {
            WebCore::PublicKeyCredentialCreationOptions::Entity {
                WTFMove(*name),
                WTFMove(*icon)
            },
            WTFMove(*id),
            WTFMove(*displayName)
        }
    };
}

#endif

#if ENABLE(WEB_AUTHN)
void ArgumentCoder<WebCore::PublicKeyCredentialDescriptor>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialDescriptor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::PublicKeyCredentialType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.id)>, WebCore::BufferSource>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.transports)>, Vector<WebCore::AuthenticatorTransport>>);
    struct ShouldBeSameSizeAsPublicKeyCredentialDescriptor : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialDescriptor>, false> {
        WebCore::PublicKeyCredentialType type;
        WebCore::BufferSource id;
        Vector<WebCore::AuthenticatorTransport> transports;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPublicKeyCredentialDescriptor) == sizeof(WebCore::PublicKeyCredentialDescriptor));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PublicKeyCredentialDescriptor, type)
        , offsetof(WebCore::PublicKeyCredentialDescriptor, id)
        , offsetof(WebCore::PublicKeyCredentialDescriptor, transports)
    >::value);
    encoder << instance.type;
    encoder << instance.id;
    encoder << instance.transports;
}

std::optional<WebCore::PublicKeyCredentialDescriptor> ArgumentCoder<WebCore::PublicKeyCredentialDescriptor>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::PublicKeyCredentialType>();
    auto id = decoder.decode<WebCore::BufferSource>();
    auto transports = decoder.decode<Vector<WebCore::AuthenticatorTransport>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialDescriptor {
            WTFMove(*type),
            WTFMove(*id),
            WTFMove(*transports)
        }
    };
}

#endif

void ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialCreationOptions& instance)
{
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rp)>, WebCore::PublicKeyCredentialCreationOptions::RpEntity>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.user)>, WebCore::PublicKeyCredentialCreationOptions::UserEntity>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.challenge)>, WebCore::BufferSource>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pubKeyCredParams)>, Vector<WebCore::PublicKeyCredentialCreationOptions::Parameters>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeout)>, std::optional<unsigned>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.excludeCredentials)>, Vector<WebCore::PublicKeyCredentialDescriptor>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.authenticatorSelection)>, std::optional<WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.attestation)>, WebCore::AttestationConveyancePreference>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.extensions)>, std::optional<WebCore::AuthenticationExtensionsClientInputs>>);
#endif
    struct ShouldBeSameSizeAsPublicKeyCredentialCreationOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialCreationOptions>, false> {
#if ENABLE(WEB_AUTHN)
        WebCore::PublicKeyCredentialCreationOptions::RpEntity rp;
#endif
#if ENABLE(WEB_AUTHN)
        WebCore::PublicKeyCredentialCreationOptions::UserEntity user;
#endif
#if ENABLE(WEB_AUTHN)
        WebCore::BufferSource challenge;
#endif
#if ENABLE(WEB_AUTHN)
        Vector<WebCore::PublicKeyCredentialCreationOptions::Parameters> pubKeyCredParams;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<unsigned> timeout;
#endif
#if ENABLE(WEB_AUTHN)
        Vector<WebCore::PublicKeyCredentialDescriptor> excludeCredentials;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria> authenticatorSelection;
#endif
#if ENABLE(WEB_AUTHN)
        WebCore::AttestationConveyancePreference attestation;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<WebCore::AuthenticationExtensionsClientInputs> extensions;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPublicKeyCredentialCreationOptions) == sizeof(WebCore::PublicKeyCredentialCreationOptions));
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, rp)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, user)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, challenge)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, pubKeyCredParams)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, timeout)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, excludeCredentials)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, authenticatorSelection)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, attestation)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialCreationOptions, extensions)
#endif
    >::value);
#if ENABLE(WEB_AUTHN)
    encoder << instance.rp;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.user;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.challenge;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.pubKeyCredParams;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.timeout;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.excludeCredentials;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.authenticatorSelection;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.attestation;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.extensions;
#endif
}

std::optional<WebCore::PublicKeyCredentialCreationOptions> ArgumentCoder<WebCore::PublicKeyCredentialCreationOptions>::decode(Decoder& decoder)
{
#if ENABLE(WEB_AUTHN)
    auto rp = decoder.decode<WebCore::PublicKeyCredentialCreationOptions::RpEntity>();
#endif
#if ENABLE(WEB_AUTHN)
    auto user = decoder.decode<WebCore::PublicKeyCredentialCreationOptions::UserEntity>();
#endif
#if ENABLE(WEB_AUTHN)
    auto challenge = decoder.decode<WebCore::BufferSource>();
#endif
#if ENABLE(WEB_AUTHN)
    auto pubKeyCredParams = decoder.decode<Vector<WebCore::PublicKeyCredentialCreationOptions::Parameters>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto timeout = decoder.decode<std::optional<unsigned>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto excludeCredentials = decoder.decode<Vector<WebCore::PublicKeyCredentialDescriptor>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto authenticatorSelection = decoder.decode<std::optional<WebCore::PublicKeyCredentialCreationOptions::AuthenticatorSelectionCriteria>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto attestation = decoder.decode<WebCore::AttestationConveyancePreference>();
#endif
#if ENABLE(WEB_AUTHN)
    auto extensions = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientInputs>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialCreationOptions {
#if ENABLE(WEB_AUTHN)
            WTFMove(*rp),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*user),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*challenge),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*pubKeyCredParams),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*timeout),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*excludeCredentials),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*authenticatorSelection),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*attestation),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*extensions)
#endif
        }
    };
}

void ArgumentCoder<WebCore::PublicKeyCredentialRequestOptions>::encode(Encoder& encoder, const WebCore::PublicKeyCredentialRequestOptions& instance)
{
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.challenge)>, WebCore::BufferSource>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.timeout)>, std::optional<unsigned>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rpId)>, String>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowCredentials)>, Vector<WebCore::PublicKeyCredentialDescriptor>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userVerification)>, WebCore::UserVerificationRequirement>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.extensions)>, std::optional<WebCore::AuthenticationExtensionsClientInputs>>);
#endif
#if ENABLE(WEB_AUTHN)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.authenticatorAttachment)>, std::optional<WebCore::AuthenticatorAttachment>>);
#endif
    struct ShouldBeSameSizeAsPublicKeyCredentialRequestOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PublicKeyCredentialRequestOptions>, false> {
#if ENABLE(WEB_AUTHN)
        WebCore::BufferSource challenge;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<unsigned> timeout;
#endif
#if ENABLE(WEB_AUTHN)
        String rpId;
#endif
#if ENABLE(WEB_AUTHN)
        Vector<WebCore::PublicKeyCredentialDescriptor> allowCredentials;
#endif
#if ENABLE(WEB_AUTHN)
        WebCore::UserVerificationRequirement userVerification;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<WebCore::AuthenticationExtensionsClientInputs> extensions;
#endif
#if ENABLE(WEB_AUTHN)
        std::optional<WebCore::AuthenticatorAttachment> authenticatorAttachment;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsPublicKeyCredentialRequestOptions) == sizeof(WebCore::PublicKeyCredentialRequestOptions));
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, challenge)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, timeout)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, rpId)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, allowCredentials)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, userVerification)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, extensions)
#endif
#if ENABLE(WEB_AUTHN)
        , offsetof(WebCore::PublicKeyCredentialRequestOptions, authenticatorAttachment)
#endif
    >::value);
#if ENABLE(WEB_AUTHN)
    encoder << instance.challenge;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.timeout;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.rpId;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.allowCredentials;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.userVerification;
#endif
#if ENABLE(WEB_AUTHN)
    encoder << instance.extensions;
#endif
}

std::optional<WebCore::PublicKeyCredentialRequestOptions> ArgumentCoder<WebCore::PublicKeyCredentialRequestOptions>::decode(Decoder& decoder)
{
#if ENABLE(WEB_AUTHN)
    auto challenge = decoder.decode<WebCore::BufferSource>();
#endif
#if ENABLE(WEB_AUTHN)
    auto timeout = decoder.decode<std::optional<unsigned>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto rpId = decoder.decode<String>();
#endif
#if ENABLE(WEB_AUTHN)
    auto allowCredentials = decoder.decode<Vector<WebCore::PublicKeyCredentialDescriptor>>();
#endif
#if ENABLE(WEB_AUTHN)
    auto userVerification = decoder.decode<WebCore::UserVerificationRequirement>();
#endif
#if ENABLE(WEB_AUTHN)
    auto extensions = decoder.decode<std::optional<WebCore::AuthenticationExtensionsClientInputs>>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PublicKeyCredentialRequestOptions {
#if ENABLE(WEB_AUTHN)
            WTFMove(*challenge),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*timeout),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*rpId),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*allowCredentials),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*userVerification),
#endif
#if ENABLE(WEB_AUTHN)
            WTFMove(*extensions)
#endif
        }
    };
}

void ArgumentCoder<WebCore::RegistrableDomain>::encode(Encoder& encoder, const WebCore::RegistrableDomain& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.string())>, String>);
    encoder << instance.string();
}

std::optional<WebCore::RegistrableDomain> ArgumentCoder<WebCore::RegistrableDomain>::decode(Decoder& decoder)
{
    auto string = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::RegistrableDomain::fromRawString(
            WTFMove(*string)
        )
    };
}

void ArgumentCoder<WebCore::AudioConfiguration>::encode(Encoder& encoder, const WebCore::AudioConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.channels)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bitrate)>, std::optional<uint64_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.samplerate)>, std::optional<uint32_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.spatialRendering)>, std::optional<bool>>);
    struct ShouldBeSameSizeAsAudioConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::AudioConfiguration>, false> {
        String contentType;
        String channels;
        std::optional<uint64_t> bitrate;
        std::optional<uint32_t> samplerate;
        std::optional<bool> spatialRendering;
    };
    static_assert(sizeof(ShouldBeSameSizeAsAudioConfiguration) == sizeof(WebCore::AudioConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::AudioConfiguration, contentType)
        , offsetof(WebCore::AudioConfiguration, channels)
        , offsetof(WebCore::AudioConfiguration, bitrate)
        , offsetof(WebCore::AudioConfiguration, samplerate)
        , offsetof(WebCore::AudioConfiguration, spatialRendering)
    >::value);
    encoder << instance.contentType;
    encoder << instance.channels;
    encoder << instance.bitrate;
    encoder << instance.samplerate;
    encoder << instance.spatialRendering;
}

std::optional<WebCore::AudioConfiguration> ArgumentCoder<WebCore::AudioConfiguration>::decode(Decoder& decoder)
{
    auto contentType = decoder.decode<String>();
    auto channels = decoder.decode<String>();
    auto bitrate = decoder.decode<std::optional<uint64_t>>();
    auto samplerate = decoder.decode<std::optional<uint32_t>>();
    auto spatialRendering = decoder.decode<std::optional<bool>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::AudioConfiguration {
            WTFMove(*contentType),
            WTFMove(*channels),
            WTFMove(*bitrate),
            WTFMove(*samplerate),
            WTFMove(*spatialRendering)
        }
    };
}

void ArgumentCoder<WebCore::Cookie>::encode(Encoder& encoder, const WebCore::Cookie& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.domain)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.created)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expires)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpOnly)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.secure)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.session)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.comment)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.commentURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ports)>, Vector<uint16_t>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sameSite)>, WebCore::Cookie::SameSitePolicy>);
    struct ShouldBeSameSizeAsCookie : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Cookie>, false> {
        String name;
        String value;
        String domain;
        String path;
        double created;
        std::optional<double> expires;
        bool httpOnly;
        bool secure;
        bool session;
        String comment;
        URL commentURL;
        Vector<uint16_t> ports;
        WebCore::Cookie::SameSitePolicy sameSite;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCookie) == sizeof(WebCore::Cookie));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Cookie, name)
        , offsetof(WebCore::Cookie, value)
        , offsetof(WebCore::Cookie, domain)
        , offsetof(WebCore::Cookie, path)
        , offsetof(WebCore::Cookie, created)
        , offsetof(WebCore::Cookie, expires)
        , offsetof(WebCore::Cookie, httpOnly)
        , offsetof(WebCore::Cookie, secure)
        , offsetof(WebCore::Cookie, session)
        , offsetof(WebCore::Cookie, comment)
        , offsetof(WebCore::Cookie, commentURL)
        , offsetof(WebCore::Cookie, ports)
        , offsetof(WebCore::Cookie, sameSite)
    >::value);
    encoder << instance.name;
    encoder << instance.value;
    encoder << instance.domain;
    encoder << instance.path;
    encoder << instance.created;
    encoder << instance.expires;
    encoder << instance.httpOnly;
    encoder << instance.secure;
    encoder << instance.session;
    encoder << instance.comment;
    encoder << instance.commentURL;
    encoder << instance.ports;
    encoder << instance.sameSite;
}

std::optional<WebCore::Cookie> ArgumentCoder<WebCore::Cookie>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto value = decoder.decode<String>();
    auto domain = decoder.decode<String>();
    auto path = decoder.decode<String>();
    auto created = decoder.decode<double>();
    auto expires = decoder.decode<std::optional<double>>();
    auto httpOnly = decoder.decode<bool>();
    auto secure = decoder.decode<bool>();
    auto session = decoder.decode<bool>();
    auto comment = decoder.decode<String>();
    auto commentURL = decoder.decode<URL>();
    auto ports = decoder.decode<Vector<uint16_t>>();
    auto sameSite = decoder.decode<WebCore::Cookie::SameSitePolicy>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::Cookie {
            WTFMove(*name),
            WTFMove(*value),
            WTFMove(*domain),
            WTFMove(*path),
            WTFMove(*created),
            WTFMove(*expires),
            WTFMove(*httpOnly),
            WTFMove(*secure),
            WTFMove(*session),
            WTFMove(*comment),
            WTFMove(*commentURL),
            WTFMove(*ports),
            WTFMove(*sameSite)
        }
    };
}

#if ENABLE(VIDEO)
void ArgumentCoder<WebCore::VideoFrameMetadata>::encode(Encoder& encoder, const WebCore::VideoFrameMetadata& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.presentationTime)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expectedDisplayTime)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaTime)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.presentedFrames)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processingDuration)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.captureTime)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.receiveTime)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rtpTimestamp)>, std::optional<unsigned>>);
    struct ShouldBeSameSizeAsVideoFrameMetadata : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::VideoFrameMetadata>, false> {
        double presentationTime;
        double expectedDisplayTime;
        unsigned width;
        unsigned height;
        double mediaTime;
        unsigned presentedFrames;
        std::optional<double> processingDuration;
        std::optional<double> captureTime;
        std::optional<double> receiveTime;
        std::optional<unsigned> rtpTimestamp;
    };
    static_assert(sizeof(ShouldBeSameSizeAsVideoFrameMetadata) == sizeof(WebCore::VideoFrameMetadata));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::VideoFrameMetadata, presentationTime)
        , offsetof(WebCore::VideoFrameMetadata, expectedDisplayTime)
        , offsetof(WebCore::VideoFrameMetadata, width)
        , offsetof(WebCore::VideoFrameMetadata, height)
        , offsetof(WebCore::VideoFrameMetadata, mediaTime)
        , offsetof(WebCore::VideoFrameMetadata, presentedFrames)
        , offsetof(WebCore::VideoFrameMetadata, processingDuration)
        , offsetof(WebCore::VideoFrameMetadata, captureTime)
        , offsetof(WebCore::VideoFrameMetadata, receiveTime)
        , offsetof(WebCore::VideoFrameMetadata, rtpTimestamp)
    >::value);
    encoder << instance.presentationTime;
    encoder << instance.expectedDisplayTime;
    encoder << instance.width;
    encoder << instance.height;
    encoder << instance.mediaTime;
    encoder << instance.presentedFrames;
    encoder << instance.processingDuration;
    encoder << instance.captureTime;
    encoder << instance.receiveTime;
    encoder << instance.rtpTimestamp;
}

std::optional<WebCore::VideoFrameMetadata> ArgumentCoder<WebCore::VideoFrameMetadata>::decode(Decoder& decoder)
{
    auto presentationTime = decoder.decode<double>();
    auto expectedDisplayTime = decoder.decode<double>();
    auto width = decoder.decode<unsigned>();
    auto height = decoder.decode<unsigned>();
    auto mediaTime = decoder.decode<double>();
    auto presentedFrames = decoder.decode<unsigned>();
    auto processingDuration = decoder.decode<std::optional<double>>();
    auto captureTime = decoder.decode<std::optional<double>>();
    auto receiveTime = decoder.decode<std::optional<double>>();
    auto rtpTimestamp = decoder.decode<std::optional<unsigned>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::VideoFrameMetadata {
            WTFMove(*presentationTime),
            WTFMove(*expectedDisplayTime),
            WTFMove(*width),
            WTFMove(*height),
            WTFMove(*mediaTime),
            WTFMove(*presentedFrames),
            WTFMove(*processingDuration),
            WTFMove(*captureTime),
            WTFMove(*receiveTime),
            WTFMove(*rtpTimestamp)
        }
    };
}

#endif

#if ENABLE(SERVICE_WORKER)
void ArgumentCoder<WebCore::NavigationPreloadState>::encode(Encoder& encoder, const WebCore::NavigationPreloadState& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.enabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.headerValue)>, String>);
    struct ShouldBeSameSizeAsNavigationPreloadState : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::NavigationPreloadState>, false> {
        bool enabled;
        String headerValue;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNavigationPreloadState) == sizeof(WebCore::NavigationPreloadState));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::NavigationPreloadState, enabled)
        , offsetof(WebCore::NavigationPreloadState, headerValue)
    >::value);
    encoder << instance.enabled;
    encoder << instance.headerValue;
}

std::optional<WebCore::NavigationPreloadState> ArgumentCoder<WebCore::NavigationPreloadState>::decode(Decoder& decoder)
{
    auto enabled = decoder.decode<bool>();
    auto headerValue = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::NavigationPreloadState {
            WTFMove(*enabled),
            WTFMove(*headerValue)
        }
    };
}

#endif

#if ENABLE(CONTENT_FILTERING)
void ArgumentCoder<WebCore::MockContentFilterSettings>::encode(Encoder& encoder, const WebCore::MockContentFilterSettings& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_enabled)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_decisionPoint)>, WebCore::MockContentFilterSettings::DecisionPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_decision)>, WebCore::MockContentFilterSettings::Decision>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_unblockRequestDecision)>, WebCore::MockContentFilterSettings::Decision>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_blockedString)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_modifiedRequestURL)>, String>);
    struct ShouldBeSameSizeAsMockContentFilterSettings : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MockContentFilterSettings>, false> {
        bool m_enabled;
        WebCore::MockContentFilterSettings::DecisionPoint m_decisionPoint;
        WebCore::MockContentFilterSettings::Decision m_decision;
        WebCore::MockContentFilterSettings::Decision m_unblockRequestDecision;
        String m_blockedString;
        String m_modifiedRequestURL;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMockContentFilterSettings) == sizeof(WebCore::MockContentFilterSettings));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MockContentFilterSettings, m_enabled)
        , offsetof(WebCore::MockContentFilterSettings, m_decisionPoint)
        , offsetof(WebCore::MockContentFilterSettings, m_decision)
        , offsetof(WebCore::MockContentFilterSettings, m_unblockRequestDecision)
        , offsetof(WebCore::MockContentFilterSettings, m_blockedString)
        , offsetof(WebCore::MockContentFilterSettings, m_modifiedRequestURL)
    >::value);
    encoder << instance.m_enabled;
    encoder << instance.m_decisionPoint;
    encoder << instance.m_decision;
    encoder << instance.m_unblockRequestDecision;
    encoder << instance.m_blockedString;
    encoder << instance.m_modifiedRequestURL;
}

std::optional<WebCore::MockContentFilterSettings> ArgumentCoder<WebCore::MockContentFilterSettings>::decode(Decoder& decoder)
{
    auto m_enabled = decoder.decode<bool>();
    auto m_decisionPoint = decoder.decode<WebCore::MockContentFilterSettings::DecisionPoint>();
    auto m_decision = decoder.decode<WebCore::MockContentFilterSettings::Decision>();
    auto m_unblockRequestDecision = decoder.decode<WebCore::MockContentFilterSettings::Decision>();
    auto m_blockedString = decoder.decode<String>();
    auto m_modifiedRequestURL = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    WebCore::MockContentFilterSettings result;
    result.m_enabled = WTFMove(*m_enabled);
    result.m_decisionPoint = WTFMove(*m_decisionPoint);
    result.m_decision = WTFMove(*m_decision);
    result.m_unblockRequestDecision = WTFMove(*m_unblockRequestDecision);
    result.m_blockedString = WTFMove(*m_blockedString);
    result.m_modifiedRequestURL = WTFMove(*m_modifiedRequestURL);
    return { WTFMove(result) };
}

#endif

void ArgumentCoder<WebCore::ExceptionDetails>::encode(Encoder& encoder, const WebCore::ExceptionDetails& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.message)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lineNumber)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.columnNumber)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ExceptionDetails::Type>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceURL)>, String>);
    struct ShouldBeSameSizeAsExceptionDetails : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ExceptionDetails>, false> {
        String message;
        int lineNumber;
        int columnNumber;
        WebCore::ExceptionDetails::Type type;
        String sourceURL;
    };
    static_assert(sizeof(ShouldBeSameSizeAsExceptionDetails) == sizeof(WebCore::ExceptionDetails));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ExceptionDetails, message)
        , offsetof(WebCore::ExceptionDetails, lineNumber)
        , offsetof(WebCore::ExceptionDetails, columnNumber)
        , offsetof(WebCore::ExceptionDetails, type)
        , offsetof(WebCore::ExceptionDetails, sourceURL)
    >::value);
    encoder << instance.message;
    encoder << instance.lineNumber;
    encoder << instance.columnNumber;
    encoder << instance.type;
    encoder << instance.sourceURL;
}

std::optional<WebCore::ExceptionDetails> ArgumentCoder<WebCore::ExceptionDetails>::decode(Decoder& decoder)
{
    auto message = decoder.decode<String>();
    auto lineNumber = decoder.decode<int>();
    auto columnNumber = decoder.decode<int>();
    auto type = decoder.decode<WebCore::ExceptionDetails::Type>();
    auto sourceURL = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ExceptionDetails {
            WTFMove(*message),
            WTFMove(*lineNumber),
            WTFMove(*columnNumber),
            WTFMove(*type),
            WTFMove(*sourceURL)
        }
    };
}

void ArgumentCoder<WebCore::FloatBoxExtent>::encode(Encoder& encoder, const WebCore::FloatBoxExtent& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.top())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.right())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bottom())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.left())>, float>);
    encoder << instance.top();
    encoder << instance.right();
    encoder << instance.bottom();
    encoder << instance.left();
}

void ArgumentCoder<WebCore::FloatBoxExtent>::encode(StreamConnectionEncoder& encoder, const WebCore::FloatBoxExtent& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.top())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.right())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bottom())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.left())>, float>);
    encoder << instance.top();
    encoder << instance.right();
    encoder << instance.bottom();
    encoder << instance.left();
}

std::optional<WebCore::FloatBoxExtent> ArgumentCoder<WebCore::FloatBoxExtent>::decode(Decoder& decoder)
{
    auto top = decoder.decode<float>();
    auto right = decoder.decode<float>();
    auto bottom = decoder.decode<float>();
    auto left = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FloatBoxExtent {
            WTFMove(*top),
            WTFMove(*right),
            WTFMove(*bottom),
            WTFMove(*left)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::SetInlineFillColor>::encode(Encoder& encoder, const WebCore::DisplayList::SetInlineFillColor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().red)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().green)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().blue)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().alpha)>, uint8_t>);
    encoder << instance.colorData().resolved().red;
    encoder << instance.colorData().resolved().green;
    encoder << instance.colorData().resolved().blue;
    encoder << instance.colorData().resolved().alpha;
}

void ArgumentCoder<WebCore::DisplayList::SetInlineFillColor>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::SetInlineFillColor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().red)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().green)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().blue)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().alpha)>, uint8_t>);
    encoder << instance.colorData().resolved().red;
    encoder << instance.colorData().resolved().green;
    encoder << instance.colorData().resolved().blue;
    encoder << instance.colorData().resolved().alpha;
}

std::optional<WebCore::DisplayList::SetInlineFillColor> ArgumentCoder<WebCore::DisplayList::SetInlineFillColor>::decode(Decoder& decoder)
{
    auto colorDataresolvedred = decoder.decode<uint8_t>();
    auto colorDataresolvedgreen = decoder.decode<uint8_t>();
    auto colorDataresolvedblue = decoder.decode<uint8_t>();
    auto colorDataresolvedalpha = decoder.decode<uint8_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::SetInlineFillColor {
            WTFMove(*colorDataresolvedred),
            WTFMove(*colorDataresolvedgreen),
            WTFMove(*colorDataresolvedblue),
            WTFMove(*colorDataresolvedalpha)
        }
    };
}

void ArgumentCoder<WebCore::DisplayList::SetInlineStrokeColor>::encode(Encoder& encoder, const WebCore::DisplayList::SetInlineStrokeColor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().red)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().green)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().blue)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().alpha)>, uint8_t>);
    encoder << instance.colorData().resolved().red;
    encoder << instance.colorData().resolved().green;
    encoder << instance.colorData().resolved().blue;
    encoder << instance.colorData().resolved().alpha;
}

void ArgumentCoder<WebCore::DisplayList::SetInlineStrokeColor>::encode(StreamConnectionEncoder& encoder, const WebCore::DisplayList::SetInlineStrokeColor& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().red)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().green)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().blue)>, uint8_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorData().resolved().alpha)>, uint8_t>);
    encoder << instance.colorData().resolved().red;
    encoder << instance.colorData().resolved().green;
    encoder << instance.colorData().resolved().blue;
    encoder << instance.colorData().resolved().alpha;
}

std::optional<WebCore::DisplayList::SetInlineStrokeColor> ArgumentCoder<WebCore::DisplayList::SetInlineStrokeColor>::decode(Decoder& decoder)
{
    auto colorDataresolvedred = decoder.decode<uint8_t>();
    auto colorDataresolvedgreen = decoder.decode<uint8_t>();
    auto colorDataresolvedblue = decoder.decode<uint8_t>();
    auto colorDataresolvedalpha = decoder.decode<uint8_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DisplayList::SetInlineStrokeColor {
            WTFMove(*colorDataresolvedred),
            WTFMove(*colorDataresolvedgreen),
            WTFMove(*colorDataresolvedblue),
            WTFMove(*colorDataresolvedalpha)
        }
    };
}

void ArgumentCoder<WebCore::HTTPHeaderMap::CommonHeader>::encode(Encoder& encoder, const WebCore::HTTPHeaderMap::CommonHeader& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.key)>, WebCore::HTTPHeaderName>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, String>);
    struct ShouldBeSameSizeAsCommonHeader : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::HTTPHeaderMap::CommonHeader>, false> {
        WebCore::HTTPHeaderName key;
        String value;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCommonHeader) == sizeof(WebCore::HTTPHeaderMap::CommonHeader));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::HTTPHeaderMap::CommonHeader, key)
        , offsetof(WebCore::HTTPHeaderMap::CommonHeader, value)
    >::value);
    encoder << instance.key;
    encoder << instance.value;
}

std::optional<WebCore::HTTPHeaderMap::CommonHeader> ArgumentCoder<WebCore::HTTPHeaderMap::CommonHeader>::decode(Decoder& decoder)
{
    auto key = decoder.decode<WebCore::HTTPHeaderName>();
    auto value = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::HTTPHeaderMap::CommonHeader {
            WTFMove(*key),
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WebCore::HTTPHeaderMap::UncommonHeader>::encode(Encoder& encoder, const WebCore::HTTPHeaderMap::UncommonHeader& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.key)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, String>);
    struct ShouldBeSameSizeAsUncommonHeader : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::HTTPHeaderMap::UncommonHeader>, false> {
        String key;
        String value;
    };
    static_assert(sizeof(ShouldBeSameSizeAsUncommonHeader) == sizeof(WebCore::HTTPHeaderMap::UncommonHeader));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::HTTPHeaderMap::UncommonHeader, key)
        , offsetof(WebCore::HTTPHeaderMap::UncommonHeader, value)
    >::value);
    encoder << instance.key;
    encoder << instance.value;
}

std::optional<WebCore::HTTPHeaderMap::UncommonHeader> ArgumentCoder<WebCore::HTTPHeaderMap::UncommonHeader>::decode(Decoder& decoder)
{
    auto key = decoder.decode<String>();
    auto value = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::HTTPHeaderMap::UncommonHeader {
            WTFMove(*key),
            WTFMove(*value)
        }
    };
}

void ArgumentCoder<WebCore::HTTPHeaderMap>::encode(Encoder& encoder, const WebCore::HTTPHeaderMap& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.commonHeaders())>, Vector<WebCore::HTTPHeaderMap::CommonHeader, 0, CrashOnOverflow, 6>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.uncommonHeaders())>, Vector<WebCore::HTTPHeaderMap::UncommonHeader, 0, CrashOnOverflow, 0>>);
    encoder << instance.commonHeaders();
    encoder << instance.uncommonHeaders();
}

std::optional<WebCore::HTTPHeaderMap> ArgumentCoder<WebCore::HTTPHeaderMap>::decode(Decoder& decoder)
{
    auto commonHeaders = decoder.decode<Vector<WebCore::HTTPHeaderMap::CommonHeader, 0, CrashOnOverflow, 6>>();
    auto uncommonHeaders = decoder.decode<Vector<WebCore::HTTPHeaderMap::UncommonHeader, 0, CrashOnOverflow, 0>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::HTTPHeaderMap {
            WTFMove(*commonHeaders),
            WTFMove(*uncommonHeaders)
        }
    };
}

void ArgumentCoder<WebCore::ElementContext>::encode(Encoder& encoder, const WebCore::ElementContext& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.boundingRect)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webPageIdentifier)>, WebCore::PageIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentIdentifier)>, WebCore::ScriptExecutionContextIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elementIdentifier)>, WebCore::ElementIdentifier>);
    struct ShouldBeSameSizeAsElementContext : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ElementContext>, false> {
        WebCore::FloatRect boundingRect;
        WebCore::PageIdentifier webPageIdentifier;
        WebCore::ScriptExecutionContextIdentifier documentIdentifier;
        WebCore::ElementIdentifier elementIdentifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsElementContext) == sizeof(WebCore::ElementContext));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ElementContext, boundingRect)
        , offsetof(WebCore::ElementContext, webPageIdentifier)
        , offsetof(WebCore::ElementContext, documentIdentifier)
        , offsetof(WebCore::ElementContext, elementIdentifier)
    >::value);
    encoder << instance.boundingRect;
    encoder << instance.webPageIdentifier;
    encoder << instance.documentIdentifier;
    encoder << instance.elementIdentifier;
}

std::optional<WebCore::ElementContext> ArgumentCoder<WebCore::ElementContext>::decode(Decoder& decoder)
{
    auto boundingRect = decoder.decode<WebCore::FloatRect>();
    auto webPageIdentifier = decoder.decode<WebCore::PageIdentifier>();
    auto documentIdentifier = decoder.decode<WebCore::ScriptExecutionContextIdentifier>();
    auto elementIdentifier = decoder.decode<WebCore::ElementIdentifier>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ElementContext {
            WTFMove(*boundingRect),
            WTFMove(*webPageIdentifier),
            WTFMove(*documentIdentifier),
            WTFMove(*elementIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::ElementAnimationContext>::encode(Encoder& encoder, const WebCore::ElementAnimationContext& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.element)>, WebCore::ElementContext>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isAnimating)>, bool>);
    struct ShouldBeSameSizeAsElementAnimationContext : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ElementAnimationContext>, false> {
        WebCore::ElementContext element;
        bool isAnimating;
    };
    static_assert(sizeof(ShouldBeSameSizeAsElementAnimationContext) == sizeof(WebCore::ElementAnimationContext));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ElementAnimationContext, element)
        , offsetof(WebCore::ElementAnimationContext, isAnimating)
    >::value);
    encoder << instance.element;
    encoder << instance.isAnimating;
}

std::optional<WebCore::ElementAnimationContext> ArgumentCoder<WebCore::ElementAnimationContext>::decode(Decoder& decoder)
{
    auto element = decoder.decode<WebCore::ElementContext>();
    auto isAnimating = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ElementAnimationContext {
            WTFMove(*element),
            WTFMove(*isAnimating)
        }
    };
}

void ArgumentCoder<WebCore::SystemPreviewInfo>::encode(Encoder& encoder, const WebCore::SystemPreviewInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.element)>, WebCore::ElementContext>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.previewRect)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isPreview)>, bool>);
    struct ShouldBeSameSizeAsSystemPreviewInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SystemPreviewInfo>, false> {
        WebCore::ElementContext element;
        WebCore::IntRect previewRect;
        bool isPreview;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSystemPreviewInfo) == sizeof(WebCore::SystemPreviewInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SystemPreviewInfo, element)
        , offsetof(WebCore::SystemPreviewInfo, previewRect)
        , offsetof(WebCore::SystemPreviewInfo, isPreview)
    >::value);
    encoder << instance.element;
    encoder << instance.previewRect;
    encoder << instance.isPreview;
}

std::optional<WebCore::SystemPreviewInfo> ArgumentCoder<WebCore::SystemPreviewInfo>::decode(Decoder& decoder)
{
    auto element = decoder.decode<WebCore::ElementContext>();
    auto previewRect = decoder.decode<WebCore::IntRect>();
    auto isPreview = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SystemPreviewInfo {
            WTFMove(*element),
            WTFMove(*previewRect),
            WTFMove(*isPreview)
        }
    };
}

void ArgumentCoder<WebCore::ResourceRequest::RequestData>::encode(Encoder& encoder, const WebCore::ResourceRequest::RequestData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_url)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_firstPartyForCookies)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_timeoutInterval)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_httpMethod)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_httpHeaderFields)>, WebCore::HTTPHeaderMap>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_responseContentDispositionEncodingFallbackArray)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_cachePolicy)>, WebCore::ResourceRequestCachePolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_sameSiteDisposition)>, WebCore::ResourceRequestBase::SameSiteDisposition>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_priority)>, WebCore::ResourceLoadPriority>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_requester)>, WebCore::ResourceRequestRequester>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_allowCookies)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isTopSite)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isAppInitiated)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_privacyProxyFailClosedForUnreachableNonMainHosts)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_useAdvancedPrivacyProtections)>, bool>);
    struct ShouldBeSameSizeAsRequestData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ResourceRequest::RequestData>, false> {
        URL m_url;
        URL m_firstPartyForCookies;
        double m_timeoutInterval;
        String m_httpMethod;
        WebCore::HTTPHeaderMap m_httpHeaderFields;
        Vector<String> m_responseContentDispositionEncodingFallbackArray;
        WebCore::ResourceRequestCachePolicy m_cachePolicy;
        WebCore::ResourceRequestBase::SameSiteDisposition m_sameSiteDisposition;
        WebCore::ResourceLoadPriority m_priority;
        WebCore::ResourceRequestRequester m_requester;
        bool m_allowCookies : 1;
        bool m_isTopSite : 1;
        bool m_isAppInitiated : 1;
        bool m_privacyProxyFailClosedForUnreachableNonMainHosts : 1;
        bool m_useAdvancedPrivacyProtections : 1;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRequestData) == sizeof(WebCore::ResourceRequest::RequestData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ResourceRequest::RequestData, m_url)
        , offsetof(WebCore::ResourceRequest::RequestData, m_firstPartyForCookies)
        , offsetof(WebCore::ResourceRequest::RequestData, m_timeoutInterval)
        , offsetof(WebCore::ResourceRequest::RequestData, m_httpMethod)
        , offsetof(WebCore::ResourceRequest::RequestData, m_httpHeaderFields)
        , offsetof(WebCore::ResourceRequest::RequestData, m_responseContentDispositionEncodingFallbackArray)
        , offsetof(WebCore::ResourceRequest::RequestData, m_cachePolicy)
        , offsetof(WebCore::ResourceRequest::RequestData, m_sameSiteDisposition)
        , offsetof(WebCore::ResourceRequest::RequestData, m_priority)
        , offsetof(WebCore::ResourceRequest::RequestData, m_requester)
    >::value);
    encoder << instance.m_url;
    encoder << instance.m_firstPartyForCookies;
    encoder << instance.m_timeoutInterval;
    encoder << instance.m_httpMethod;
    encoder << instance.m_httpHeaderFields;
    encoder << instance.m_responseContentDispositionEncodingFallbackArray;
    encoder << instance.m_cachePolicy;
    encoder << instance.m_sameSiteDisposition;
    encoder << instance.m_priority;
    encoder << instance.m_requester;
    encoder << instance.m_allowCookies;
    encoder << instance.m_isTopSite;
    encoder << instance.m_isAppInitiated;
    encoder << instance.m_privacyProxyFailClosedForUnreachableNonMainHosts;
    encoder << instance.m_useAdvancedPrivacyProtections;
}

std::optional<WebCore::ResourceRequest::RequestData> ArgumentCoder<WebCore::ResourceRequest::RequestData>::decode(Decoder& decoder)
{
    auto m_url = decoder.decode<URL>();
    auto m_firstPartyForCookies = decoder.decode<URL>();
    auto m_timeoutInterval = decoder.decode<double>();
    auto m_httpMethod = decoder.decode<String>();
    auto m_httpHeaderFields = decoder.decode<WebCore::HTTPHeaderMap>();
    auto m_responseContentDispositionEncodingFallbackArray = decoder.decode<Vector<String>>();
    auto m_cachePolicy = decoder.decode<WebCore::ResourceRequestCachePolicy>();
    auto m_sameSiteDisposition = decoder.decode<WebCore::ResourceRequestBase::SameSiteDisposition>();
    auto m_priority = decoder.decode<WebCore::ResourceLoadPriority>();
    auto m_requester = decoder.decode<WebCore::ResourceRequestRequester>();
    auto m_allowCookies = decoder.decode<bool>();
    auto m_isTopSite = decoder.decode<bool>();
    auto m_isAppInitiated = decoder.decode<bool>();
    auto m_privacyProxyFailClosedForUnreachableNonMainHosts = decoder.decode<bool>();
    auto m_useAdvancedPrivacyProtections = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ResourceRequest::RequestData {
            WTFMove(*m_url),
            WTFMove(*m_firstPartyForCookies),
            WTFMove(*m_timeoutInterval),
            WTFMove(*m_httpMethod),
            WTFMove(*m_httpHeaderFields),
            WTFMove(*m_responseContentDispositionEncodingFallbackArray),
            WTFMove(*m_cachePolicy),
            WTFMove(*m_sameSiteDisposition),
            WTFMove(*m_priority),
            WTFMove(*m_requester),
            WTFMove(*m_allowCookies),
            WTFMove(*m_isTopSite),
            WTFMove(*m_isAppInitiated),
            WTFMove(*m_privacyProxyFailClosedForUnreachableNonMainHosts),
            WTFMove(*m_useAdvancedPrivacyProtections)
        }
    };
}

#if USE(SOUP)
void ArgumentCoder<WebCore::ResourceRequestPlatformData>::encode(Encoder& encoder, const WebCore::ResourceRequestPlatformData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requestData)>, WebCore::ResourceRequest::RequestData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.acceptEncoding)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.redirectCount)>, uint16_t>);
    struct ShouldBeSameSizeAsResourceRequestPlatformData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ResourceRequestPlatformData>, false> {
        WebCore::ResourceRequest::RequestData requestData;
        bool acceptEncoding;
        uint16_t redirectCount;
    };
    static_assert(sizeof(ShouldBeSameSizeAsResourceRequestPlatformData) == sizeof(WebCore::ResourceRequestPlatformData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ResourceRequestPlatformData, requestData)
        , offsetof(WebCore::ResourceRequestPlatformData, acceptEncoding)
        , offsetof(WebCore::ResourceRequestPlatformData, redirectCount)
    >::value);
    encoder << instance.requestData;
    encoder << instance.acceptEncoding;
    encoder << instance.redirectCount;
}

std::optional<WebCore::ResourceRequestPlatformData> ArgumentCoder<WebCore::ResourceRequestPlatformData>::decode(Decoder& decoder)
{
    auto requestData = decoder.decode<WebCore::ResourceRequest::RequestData>();
    auto acceptEncoding = decoder.decode<bool>();
    auto redirectCount = decoder.decode<uint16_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ResourceRequestPlatformData {
            WTFMove(*requestData),
            WTFMove(*acceptEncoding),
            WTFMove(*redirectCount)
        }
    };
}

#endif

#if PLATFORM(COCOA)
void ArgumentCoder<WebCore::ResourceRequest>::encode(Encoder& encoder, const WebCore::ResourceRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.getRequestDataToSerialize())>, std::variant<WebCore::ResourceRequest::RequestData, WebCore::ResourceRequestPlatformData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cachePartition())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hiddenFromInspector())>, bool>);
    encoder << instance.getRequestDataToSerialize();
    encoder << instance.cachePartition();
    encoder << instance.hiddenFromInspector();
}

std::optional<WebCore::ResourceRequest> ArgumentCoder<WebCore::ResourceRequest>::decode(Decoder& decoder)
{
    auto getRequestDataToSerialize = decoder.decode<std::variant<WebCore::ResourceRequest::RequestData, WebCore::ResourceRequestPlatformData>>();
    auto cachePartition = decoder.decode<String>();
    auto hiddenFromInspector = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ResourceRequest::fromResourceRequestData(
            WTFMove(*getRequestDataToSerialize),
            WTFMove(*cachePartition),
            WTFMove(*hiddenFromInspector)
        )
    };
}

#endif

#if USE(CURL)
void ArgumentCoder<WebCore::ResourceRequest>::encode(Encoder& encoder, const WebCore::ResourceRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.getRequestDataToSerialize())>, WebCore::ResourceRequest::RequestData>);
    encoder << instance.getRequestDataToSerialize();
}

std::optional<WebCore::ResourceRequest> ArgumentCoder<WebCore::ResourceRequest>::decode(Decoder& decoder)
{
    auto getRequestDataToSerialize = decoder.decode<WebCore::ResourceRequest::RequestData>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ResourceRequest::fromResourceRequestData(
            WTFMove(*getRequestDataToSerialize)
        )
    };
}

#endif

#if !USE(CURL) && !PLATFORM(COCOA)
void ArgumentCoder<WebCore::ResourceRequest>::encode(Encoder& encoder, const WebCore::ResourceRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.getRequestDataToSerialize())>, std::variant<WebCore::ResourceRequest::RequestData, WebCore::ResourceRequestPlatformData>>);
    encoder << instance.getRequestDataToSerialize();
}

std::optional<WebCore::ResourceRequest> ArgumentCoder<WebCore::ResourceRequest>::decode(Decoder& decoder)
{
    auto getRequestDataToSerialize = decoder.decode<std::variant<WebCore::ResourceRequest::RequestData, WebCore::ResourceRequestPlatformData>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ResourceRequest::fromResourceRequestData(
            WTFMove(*getRequestDataToSerialize)
        )
    };
}

#endif

#if !USE(CG)
void ArgumentCoder<WebCore::PlatformColorSpace>::encode(Encoder& encoder, const WebCore::PlatformColorSpace& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.get())>, WebCore::PlatformColorSpace::Name>);
    encoder << instance.get();
}

void ArgumentCoder<WebCore::PlatformColorSpace>::encode(StreamConnectionEncoder& encoder, const WebCore::PlatformColorSpace& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.get())>, WebCore::PlatformColorSpace::Name>);
    encoder << instance.get();
}

std::optional<WebCore::PlatformColorSpace> ArgumentCoder<WebCore::PlatformColorSpace>::decode(Decoder& decoder)
{
    auto get = decoder.decode<WebCore::PlatformColorSpace::Name>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PlatformColorSpace {
            WTFMove(*get)
        }
    };
}

#endif

void ArgumentCoder<WebCore::DestinationColorSpace>::encode(Encoder& encoder, const WebCore::DestinationColorSpace& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serializableColorSpace())>, WebCore::PlatformColorSpace>);
    encoder << instance.serializableColorSpace();
}

void ArgumentCoder<WebCore::DestinationColorSpace>::encode(StreamConnectionEncoder& encoder, const WebCore::DestinationColorSpace& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.serializableColorSpace())>, WebCore::PlatformColorSpace>);
    encoder << instance.serializableColorSpace();
}

std::optional<WebCore::DestinationColorSpace> ArgumentCoder<WebCore::DestinationColorSpace>::decode(Decoder& decoder)
{
    auto serializableColorSpace = decoder.decode<WebCore::PlatformColorSpace>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DestinationColorSpace {
            WTFMove(*serializableColorSpace)
        }
    };
}

void ArgumentCoder<WebCore::WindowFeatures>::encode(Encoder& encoder, const WebCore::WindowFeatures& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x)>, std::optional<float>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y)>, std::optional<float>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width)>, std::optional<float>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height)>, std::optional<float>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.menuBarVisible)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.statusBarVisible)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.toolBarVisible)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.locationBarVisible)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollbarsVisible)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resizable)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fullscreen)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dialog)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.noopener)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.noreferrer)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.additionalFeatures)>, Vector<String>>);
    struct ShouldBeSameSizeAsWindowFeatures : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::WindowFeatures>, false> {
        std::optional<float> x;
        std::optional<float> y;
        std::optional<float> width;
        std::optional<float> height;
        bool menuBarVisible;
        bool statusBarVisible;
        bool toolBarVisible;
        bool locationBarVisible;
        bool scrollbarsVisible;
        bool resizable;
        bool fullscreen;
        bool dialog;
        bool noopener;
        bool noreferrer;
        Vector<String> additionalFeatures;
    };
    static_assert(sizeof(ShouldBeSameSizeAsWindowFeatures) == sizeof(WebCore::WindowFeatures));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::WindowFeatures, x)
        , offsetof(WebCore::WindowFeatures, y)
        , offsetof(WebCore::WindowFeatures, width)
        , offsetof(WebCore::WindowFeatures, height)
        , offsetof(WebCore::WindowFeatures, menuBarVisible)
        , offsetof(WebCore::WindowFeatures, statusBarVisible)
        , offsetof(WebCore::WindowFeatures, toolBarVisible)
        , offsetof(WebCore::WindowFeatures, locationBarVisible)
        , offsetof(WebCore::WindowFeatures, scrollbarsVisible)
        , offsetof(WebCore::WindowFeatures, resizable)
        , offsetof(WebCore::WindowFeatures, fullscreen)
        , offsetof(WebCore::WindowFeatures, dialog)
        , offsetof(WebCore::WindowFeatures, noopener)
        , offsetof(WebCore::WindowFeatures, noreferrer)
        , offsetof(WebCore::WindowFeatures, additionalFeatures)
    >::value);
    encoder << instance.x;
    encoder << instance.y;
    encoder << instance.width;
    encoder << instance.height;
    encoder << instance.menuBarVisible;
    encoder << instance.statusBarVisible;
    encoder << instance.toolBarVisible;
    encoder << instance.locationBarVisible;
    encoder << instance.scrollbarsVisible;
    encoder << instance.resizable;
    encoder << instance.fullscreen;
    encoder << instance.dialog;
}

std::optional<WebCore::WindowFeatures> ArgumentCoder<WebCore::WindowFeatures>::decode(Decoder& decoder)
{
    auto x = decoder.decode<std::optional<float>>();
    auto y = decoder.decode<std::optional<float>>();
    auto width = decoder.decode<std::optional<float>>();
    auto height = decoder.decode<std::optional<float>>();
    auto menuBarVisible = decoder.decode<bool>();
    auto statusBarVisible = decoder.decode<bool>();
    auto toolBarVisible = decoder.decode<bool>();
    auto locationBarVisible = decoder.decode<bool>();
    auto scrollbarsVisible = decoder.decode<bool>();
    auto resizable = decoder.decode<bool>();
    auto fullscreen = decoder.decode<bool>();
    auto dialog = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::WindowFeatures {
            WTFMove(*x),
            WTFMove(*y),
            WTFMove(*width),
            WTFMove(*height),
            WTFMove(*menuBarVisible),
            WTFMove(*statusBarVisible),
            WTFMove(*toolBarVisible),
            WTFMove(*locationBarVisible),
            WTFMove(*scrollbarsVisible),
            WTFMove(*resizable),
            WTFMove(*fullscreen),
            WTFMove(*dialog)
        }
    };
}

void ArgumentCoder<WebCore::CompositionUnderline>::encode(Encoder& encoder, const WebCore::CompositionUnderline& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startOffset)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endOffset)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.compositionUnderlineColor)>, WebCore::CompositionUnderlineColor>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.thick)>, bool>);
    struct ShouldBeSameSizeAsCompositionUnderline : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CompositionUnderline>, false> {
        unsigned startOffset;
        unsigned endOffset;
        WebCore::CompositionUnderlineColor compositionUnderlineColor;
        WebCore::Color color;
        bool thick;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCompositionUnderline) == sizeof(WebCore::CompositionUnderline));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CompositionUnderline, startOffset)
        , offsetof(WebCore::CompositionUnderline, endOffset)
        , offsetof(WebCore::CompositionUnderline, compositionUnderlineColor)
        , offsetof(WebCore::CompositionUnderline, color)
        , offsetof(WebCore::CompositionUnderline, thick)
    >::value);
    encoder << instance.startOffset;
    encoder << instance.endOffset;
    encoder << instance.compositionUnderlineColor;
    encoder << instance.color;
    encoder << instance.thick;
}

std::optional<WebCore::CompositionUnderline> ArgumentCoder<WebCore::CompositionUnderline>::decode(Decoder& decoder)
{
    auto startOffset = decoder.decode<unsigned>();
    auto endOffset = decoder.decode<unsigned>();
    auto compositionUnderlineColor = decoder.decode<WebCore::CompositionUnderlineColor>();
    auto color = decoder.decode<WebCore::Color>();
    auto thick = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CompositionUnderline {
            WTFMove(*startOffset),
            WTFMove(*endOffset),
            WTFMove(*compositionUnderlineColor),
            WTFMove(*color),
            WTFMove(*thick)
        }
    };
}

void ArgumentCoder<WebCore::FileChooserSettings>::encode(Encoder& encoder, const WebCore::FileChooserSettings& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsDirectories)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsMultipleFiles)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.acceptMIMETypes)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.acceptFileExtensions)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectedFiles)>, Vector<String>>);
#if ENABLE(MEDIA_CAPTURE)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaCaptureType)>, WebCore::MediaCaptureType>);
#endif
    struct ShouldBeSameSizeAsFileChooserSettings : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FileChooserSettings>, false> {
        bool allowsDirectories;
        bool allowsMultipleFiles;
        Vector<String> acceptMIMETypes;
        Vector<String> acceptFileExtensions;
        Vector<String> selectedFiles;
#if ENABLE(MEDIA_CAPTURE)
        WebCore::MediaCaptureType mediaCaptureType;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsFileChooserSettings) == sizeof(WebCore::FileChooserSettings));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FileChooserSettings, allowsDirectories)
        , offsetof(WebCore::FileChooserSettings, allowsMultipleFiles)
        , offsetof(WebCore::FileChooserSettings, acceptMIMETypes)
        , offsetof(WebCore::FileChooserSettings, acceptFileExtensions)
        , offsetof(WebCore::FileChooserSettings, selectedFiles)
#if ENABLE(MEDIA_CAPTURE)
        , offsetof(WebCore::FileChooserSettings, mediaCaptureType)
#endif
    >::value);
    encoder << instance.allowsDirectories;
    encoder << instance.allowsMultipleFiles;
    encoder << instance.acceptMIMETypes;
    encoder << instance.acceptFileExtensions;
    encoder << instance.selectedFiles;
#if ENABLE(MEDIA_CAPTURE)
    encoder << instance.mediaCaptureType;
#endif
}

std::optional<WebCore::FileChooserSettings> ArgumentCoder<WebCore::FileChooserSettings>::decode(Decoder& decoder)
{
    auto allowsDirectories = decoder.decode<bool>();
    auto allowsMultipleFiles = decoder.decode<bool>();
    auto acceptMIMETypes = decoder.decode<Vector<String>>();
    auto acceptFileExtensions = decoder.decode<Vector<String>>();
    auto selectedFiles = decoder.decode<Vector<String>>();
#if ENABLE(MEDIA_CAPTURE)
    auto mediaCaptureType = decoder.decode<WebCore::MediaCaptureType>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FileChooserSettings {
            WTFMove(*allowsDirectories),
            WTFMove(*allowsMultipleFiles),
            WTFMove(*acceptMIMETypes),
            WTFMove(*acceptFileExtensions),
            WTFMove(*selectedFiles),
#if ENABLE(MEDIA_CAPTURE)
            WTFMove(*mediaCaptureType)
#endif
        }
    };
}

void ArgumentCoder<WebCore::GrammarDetail>::encode(Encoder& encoder, const WebCore::GrammarDetail& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.range)>, WebCore::CharacterRange>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.guesses)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.userDescription)>, String>);
    struct ShouldBeSameSizeAsGrammarDetail : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::GrammarDetail>, false> {
        WebCore::CharacterRange range;
        Vector<String> guesses;
        String userDescription;
    };
    static_assert(sizeof(ShouldBeSameSizeAsGrammarDetail) == sizeof(WebCore::GrammarDetail));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::GrammarDetail, range)
        , offsetof(WebCore::GrammarDetail, guesses)
        , offsetof(WebCore::GrammarDetail, userDescription)
    >::value);
    encoder << instance.range;
    encoder << instance.guesses;
    encoder << instance.userDescription;
}

std::optional<WebCore::GrammarDetail> ArgumentCoder<WebCore::GrammarDetail>::decode(Decoder& decoder)
{
    auto range = decoder.decode<WebCore::CharacterRange>();
    auto guesses = decoder.decode<Vector<String>>();
    auto userDescription = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::GrammarDetail {
            WTFMove(*range),
            WTFMove(*guesses),
            WTFMove(*userDescription)
        }
    };
}

void ArgumentCoder<WebCore::TextCheckingResult>::encode(Encoder& encoder, const WebCore::TextCheckingResult& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, OptionSet<WebCore::TextCheckingType>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.range)>, WebCore::CharacterRange>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.details)>, Vector<WebCore::GrammarDetail>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.replacement)>, String>);
    struct ShouldBeSameSizeAsTextCheckingResult : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextCheckingResult>, false> {
        OptionSet<WebCore::TextCheckingType> type;
        WebCore::CharacterRange range;
        Vector<WebCore::GrammarDetail> details;
        String replacement;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextCheckingResult) == sizeof(WebCore::TextCheckingResult));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextCheckingResult, type)
        , offsetof(WebCore::TextCheckingResult, range)
        , offsetof(WebCore::TextCheckingResult, details)
        , offsetof(WebCore::TextCheckingResult, replacement)
    >::value);
    encoder << instance.type;
    encoder << instance.range;
    encoder << instance.details;
    encoder << instance.replacement;
}

std::optional<WebCore::TextCheckingResult> ArgumentCoder<WebCore::TextCheckingResult>::decode(Decoder& decoder)
{
    auto type = decoder.decode<OptionSet<WebCore::TextCheckingType>>();
    auto range = decoder.decode<WebCore::CharacterRange>();
    auto details = decoder.decode<Vector<WebCore::GrammarDetail>>();
    auto replacement = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextCheckingResult {
            WTFMove(*type),
            WTFMove(*range),
            WTFMove(*details),
            WTFMove(*replacement)
        }
    };
}

void ArgumentCoder<WebCore::TextCheckingRequestData>::encode(Encoder& encoder, const WebCore::TextCheckingRequestData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier())>, std::optional<WebCore::TextCheckingRequestIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.text())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.checkingTypes())>, OptionSet<WebCore::TextCheckingType>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.processType())>, WebCore::TextCheckingProcessType>);
    encoder << instance.identifier();
    encoder << instance.text();
    encoder << instance.checkingTypes();
    encoder << instance.processType();
}

std::optional<WebCore::TextCheckingRequestData> ArgumentCoder<WebCore::TextCheckingRequestData>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<std::optional<WebCore::TextCheckingRequestIdentifier>>();
    auto text = decoder.decode<String>();
    auto checkingTypes = decoder.decode<OptionSet<WebCore::TextCheckingType>>();
    auto processType = decoder.decode<WebCore::TextCheckingProcessType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextCheckingRequestData {
            WTFMove(*identifier),
            WTFMove(*text),
            WTFMove(*checkingTypes),
            WTFMove(*processType)
        }
    };
}

void ArgumentCoder<WebCore::LayoutRect>::encode(Encoder& encoder, const WebCore::LayoutRect& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_location)>, WebCore::LayoutPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_size)>, WebCore::LayoutSize>);
    struct ShouldBeSameSizeAsLayoutRect : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::LayoutRect>, false> {
        WebCore::LayoutPoint m_location;
        WebCore::LayoutSize m_size;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLayoutRect) == sizeof(WebCore::LayoutRect));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::LayoutRect, m_location)
        , offsetof(WebCore::LayoutRect, m_size)
    >::value);
    encoder << instance.m_location;
    encoder << instance.m_size;
}

std::optional<WebCore::LayoutRect> ArgumentCoder<WebCore::LayoutRect>::decode(Decoder& decoder)
{
    auto m_location = decoder.decode<WebCore::LayoutPoint>();
    auto m_size = decoder.decode<WebCore::LayoutSize>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::LayoutRect {
            WTFMove(*m_location),
            WTFMove(*m_size)
        }
    };
}

void ArgumentCoder<WebCore::ScreenDataOverrides>::encode(Encoder& encoder, const WebCore::ScreenDataOverrides& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scale)>, double>);
    struct ShouldBeSameSizeAsScreenDataOverrides : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ScreenDataOverrides>, false> {
        double width;
        double height;
        double scale;
    };
    static_assert(sizeof(ShouldBeSameSizeAsScreenDataOverrides) == sizeof(WebCore::ScreenDataOverrides));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ScreenDataOverrides, width)
        , offsetof(WebCore::ScreenDataOverrides, height)
        , offsetof(WebCore::ScreenDataOverrides, scale)
    >::value);
    encoder << instance.width;
    encoder << instance.height;
    encoder << instance.scale;
}

std::optional<WebCore::ScreenDataOverrides> ArgumentCoder<WebCore::ScreenDataOverrides>::decode(Decoder& decoder)
{
    auto width = decoder.decode<double>();
    auto height = decoder.decode<double>();
    auto scale = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ScreenDataOverrides {
            WTFMove(*width),
            WTFMove(*height),
            WTFMove(*scale)
        }
    };
}

void ArgumentCoder<WebCore::MediaCapabilitiesInfo>::encode(Encoder& encoder, const WebCore::MediaCapabilitiesInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.supported)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.smooth)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.powerEfficient)>, bool>);
    struct ShouldBeSameSizeAsMediaCapabilitiesInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MediaCapabilitiesInfo>, false> {
        bool supported;
        bool smooth;
        bool powerEfficient;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaCapabilitiesInfo) == sizeof(WebCore::MediaCapabilitiesInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaCapabilitiesInfo, supported)
        , offsetof(WebCore::MediaCapabilitiesInfo, smooth)
        , offsetof(WebCore::MediaCapabilitiesInfo, powerEfficient)
    >::value);
    encoder << instance.supported;
    encoder << instance.smooth;
    encoder << instance.powerEfficient;
}

std::optional<WebCore::MediaCapabilitiesInfo> ArgumentCoder<WebCore::MediaCapabilitiesInfo>::decode(Decoder& decoder)
{
    auto supported = decoder.decode<bool>();
    auto smooth = decoder.decode<bool>();
    auto powerEfficient = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaCapabilitiesInfo {
            WTFMove(*supported),
            WTFMove(*smooth),
            WTFMove(*powerEfficient)
        }
    };
}

#if ENABLE(MEDIA_STREAM)
void ArgumentCoder<WebCore::MediaStreamRequest>::encode(Encoder& encoder, const WebCore::MediaStreamRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::MediaStreamRequest::Type>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.audioConstraints)>, WebCore::MediaConstraints>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.videoConstraints)>, WebCore::MediaConstraints>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isUserGesturePriviledged)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageIdentifier)>, WebCore::PageIdentifier>);
    struct ShouldBeSameSizeAsMediaStreamRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MediaStreamRequest>, false> {
        WebCore::MediaStreamRequest::Type type;
        WebCore::MediaConstraints audioConstraints;
        WebCore::MediaConstraints videoConstraints;
        bool isUserGesturePriviledged;
        WebCore::PageIdentifier pageIdentifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaStreamRequest) == sizeof(WebCore::MediaStreamRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaStreamRequest, type)
        , offsetof(WebCore::MediaStreamRequest, audioConstraints)
        , offsetof(WebCore::MediaStreamRequest, videoConstraints)
        , offsetof(WebCore::MediaStreamRequest, isUserGesturePriviledged)
        , offsetof(WebCore::MediaStreamRequest, pageIdentifier)
    >::value);
    encoder << instance.type;
    encoder << instance.audioConstraints;
    encoder << instance.videoConstraints;
    encoder << instance.isUserGesturePriviledged;
    encoder << instance.pageIdentifier;
}

std::optional<WebCore::MediaStreamRequest> ArgumentCoder<WebCore::MediaStreamRequest>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::MediaStreamRequest::Type>();
    auto audioConstraints = decoder.decode<WebCore::MediaConstraints>();
    auto videoConstraints = decoder.decode<WebCore::MediaConstraints>();
    auto isUserGesturePriviledged = decoder.decode<bool>();
    auto pageIdentifier = decoder.decode<WebCore::PageIdentifier>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaStreamRequest {
            WTFMove(*type),
            WTFMove(*audioConstraints),
            WTFMove(*videoConstraints),
            WTFMove(*isUserGesturePriviledged),
            WTFMove(*pageIdentifier)
        }
    };
}

#endif

#if ENABLE(MEDIA_STREAM)
void ArgumentCoder<WebCore::MediaTrackConstraintSetMap>::encode(Encoder& encoder, const WebCore::MediaTrackConstraintSetMap& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_width)>, std::optional<WebCore::IntConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_height)>, std::optional<WebCore::IntConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_sampleRate)>, std::optional<WebCore::IntConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_sampleSize)>, std::optional<WebCore::IntConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_aspectRatio)>, std::optional<WebCore::DoubleConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_zoom)>, std::optional<WebCore::DoubleConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_frameRate)>, std::optional<WebCore::DoubleConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_volume)>, std::optional<WebCore::DoubleConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_echoCancellation)>, std::optional<WebCore::BooleanConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_displaySurface)>, std::optional<WebCore::BooleanConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_logicalSurface)>, std::optional<WebCore::BooleanConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_facingMode)>, std::optional<WebCore::StringConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_deviceId)>, std::optional<WebCore::StringConstraint>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_groupId)>, std::optional<WebCore::StringConstraint>>);
    struct ShouldBeSameSizeAsMediaTrackConstraintSetMap : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MediaTrackConstraintSetMap>, false> {
        std::optional<WebCore::IntConstraint> m_width;
        std::optional<WebCore::IntConstraint> m_height;
        std::optional<WebCore::IntConstraint> m_sampleRate;
        std::optional<WebCore::IntConstraint> m_sampleSize;
        std::optional<WebCore::DoubleConstraint> m_aspectRatio;
        std::optional<WebCore::DoubleConstraint> m_zoom;
        std::optional<WebCore::DoubleConstraint> m_frameRate;
        std::optional<WebCore::DoubleConstraint> m_volume;
        std::optional<WebCore::BooleanConstraint> m_echoCancellation;
        std::optional<WebCore::BooleanConstraint> m_displaySurface;
        std::optional<WebCore::BooleanConstraint> m_logicalSurface;
        std::optional<WebCore::StringConstraint> m_facingMode;
        std::optional<WebCore::StringConstraint> m_deviceId;
        std::optional<WebCore::StringConstraint> m_groupId;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaTrackConstraintSetMap) == sizeof(WebCore::MediaTrackConstraintSetMap));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_width)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_height)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_sampleRate)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_sampleSize)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_aspectRatio)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_zoom)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_frameRate)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_volume)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_echoCancellation)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_displaySurface)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_logicalSurface)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_facingMode)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_deviceId)
        , offsetof(WebCore::MediaTrackConstraintSetMap, m_groupId)
    >::value);
    encoder << instance.m_width;
    encoder << instance.m_height;
    encoder << instance.m_sampleRate;
    encoder << instance.m_sampleSize;
    encoder << instance.m_aspectRatio;
    encoder << instance.m_zoom;
    encoder << instance.m_frameRate;
    encoder << instance.m_volume;
    encoder << instance.m_echoCancellation;
    encoder << instance.m_displaySurface;
    encoder << instance.m_logicalSurface;
    encoder << instance.m_facingMode;
    encoder << instance.m_deviceId;
    encoder << instance.m_groupId;
}

std::optional<WebCore::MediaTrackConstraintSetMap> ArgumentCoder<WebCore::MediaTrackConstraintSetMap>::decode(Decoder& decoder)
{
    auto m_width = decoder.decode<std::optional<WebCore::IntConstraint>>();
    auto m_height = decoder.decode<std::optional<WebCore::IntConstraint>>();
    auto m_sampleRate = decoder.decode<std::optional<WebCore::IntConstraint>>();
    auto m_sampleSize = decoder.decode<std::optional<WebCore::IntConstraint>>();
    auto m_aspectRatio = decoder.decode<std::optional<WebCore::DoubleConstraint>>();
    auto m_zoom = decoder.decode<std::optional<WebCore::DoubleConstraint>>();
    auto m_frameRate = decoder.decode<std::optional<WebCore::DoubleConstraint>>();
    auto m_volume = decoder.decode<std::optional<WebCore::DoubleConstraint>>();
    auto m_echoCancellation = decoder.decode<std::optional<WebCore::BooleanConstraint>>();
    auto m_displaySurface = decoder.decode<std::optional<WebCore::BooleanConstraint>>();
    auto m_logicalSurface = decoder.decode<std::optional<WebCore::BooleanConstraint>>();
    auto m_facingMode = decoder.decode<std::optional<WebCore::StringConstraint>>();
    auto m_deviceId = decoder.decode<std::optional<WebCore::StringConstraint>>();
    auto m_groupId = decoder.decode<std::optional<WebCore::StringConstraint>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    WebCore::MediaTrackConstraintSetMap result;
    result.m_width = WTFMove(*m_width);
    result.m_height = WTFMove(*m_height);
    result.m_sampleRate = WTFMove(*m_sampleRate);
    result.m_sampleSize = WTFMove(*m_sampleSize);
    result.m_aspectRatio = WTFMove(*m_aspectRatio);
    result.m_zoom = WTFMove(*m_zoom);
    result.m_frameRate = WTFMove(*m_frameRate);
    result.m_volume = WTFMove(*m_volume);
    result.m_echoCancellation = WTFMove(*m_echoCancellation);
    result.m_displaySurface = WTFMove(*m_displaySurface);
    result.m_logicalSurface = WTFMove(*m_logicalSurface);
    result.m_facingMode = WTFMove(*m_facingMode);
    result.m_deviceId = WTFMove(*m_deviceId);
    result.m_groupId = WTFMove(*m_groupId);
    return { WTFMove(result) };
}

#endif

#if ! ENABLE(MEDIA_STREAM)
void ArgumentCoder<WebCore::MediaStreamRequest>::encode(Encoder& encoder, const WebCore::MediaStreamRequest& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::MediaStreamRequest::Type>);
    struct ShouldBeSameSizeAsMediaStreamRequest : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MediaStreamRequest>, false> {
        WebCore::MediaStreamRequest::Type type;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaStreamRequest) == sizeof(WebCore::MediaStreamRequest));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaStreamRequest, type)
    >::value);
    encoder << instance.type;
}

std::optional<WebCore::MediaStreamRequest> ArgumentCoder<WebCore::MediaStreamRequest>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::MediaStreamRequest::Type>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaStreamRequest {
            WTFMove(*type)
        }
    };
}

#endif

void ArgumentCoder<WebCore::MediaCapabilitiesDecodingInfo>::encode(Encoder& encoder, const WebCore::MediaCapabilitiesDecodingInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.supported)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.smooth)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.powerEfficient)>, bool>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaCapabilitiesInfo, supported)
        , offsetof(WebCore::MediaCapabilitiesInfo, smooth)
        , offsetof(WebCore::MediaCapabilitiesInfo, powerEfficient)
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.supportedConfiguration)>, WebCore::MediaDecodingConfiguration>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaCapabilitiesDecodingInfo, supportedConfiguration)
    >::value);
    encoder << instance.supported;
    encoder << instance.smooth;
    encoder << instance.powerEfficient;
    encoder << instance.supportedConfiguration;
}

std::optional<WebCore::MediaCapabilitiesDecodingInfo> ArgumentCoder<WebCore::MediaCapabilitiesDecodingInfo>::decode(Decoder& decoder)
{
    auto supported = decoder.decode<bool>();
    auto smooth = decoder.decode<bool>();
    auto powerEfficient = decoder.decode<bool>();
    auto supportedConfiguration = decoder.decode<WebCore::MediaDecodingConfiguration>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaCapabilitiesDecodingInfo {
            WebCore::MediaCapabilitiesInfo {
                WTFMove(*supported),
                WTFMove(*smooth),
                WTFMove(*powerEfficient)
            },
            WTFMove(*supportedConfiguration)
        }
    };
}

void ArgumentCoder<WebCore::MediaCapabilitiesEncodingInfo>::encode(Encoder& encoder, const WebCore::MediaCapabilitiesEncodingInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.supported)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.smooth)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.powerEfficient)>, bool>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaCapabilitiesInfo, supported)
        , offsetof(WebCore::MediaCapabilitiesInfo, smooth)
        , offsetof(WebCore::MediaCapabilitiesInfo, powerEfficient)
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.supportedConfiguration)>, WebCore::MediaEncodingConfiguration>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaCapabilitiesEncodingInfo, supportedConfiguration)
    >::value);
    encoder << instance.supported;
    encoder << instance.smooth;
    encoder << instance.powerEfficient;
    encoder << instance.supportedConfiguration;
}

std::optional<WebCore::MediaCapabilitiesEncodingInfo> ArgumentCoder<WebCore::MediaCapabilitiesEncodingInfo>::decode(Decoder& decoder)
{
    auto supported = decoder.decode<bool>();
    auto smooth = decoder.decode<bool>();
    auto powerEfficient = decoder.decode<bool>();
    auto supportedConfiguration = decoder.decode<WebCore::MediaEncodingConfiguration>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaCapabilitiesEncodingInfo {
            WebCore::MediaCapabilitiesInfo {
                WTFMove(*supported),
                WTFMove(*smooth),
                WTFMove(*powerEfficient)
            },
            WTFMove(*supportedConfiguration)
        }
    };
}

void ArgumentCoder<WebCore::FormDataElement>::encode(Encoder& encoder, const WebCore::FormDataElement& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data)>, std::variant<Vector<uint8_t>, WebCore::FormDataElement::EncodedFileData, WebCore::FormDataElement::EncodedBlobData>>);
    struct ShouldBeSameSizeAsFormDataElement : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FormDataElement>, false> {
        std::variant<Vector<uint8_t>, WebCore::FormDataElement::EncodedFileData, WebCore::FormDataElement::EncodedBlobData> data;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFormDataElement) == sizeof(WebCore::FormDataElement));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FormDataElement, data)
    >::value);
    encoder << instance.data;
}

std::optional<WebCore::FormDataElement> ArgumentCoder<WebCore::FormDataElement>::decode(Decoder& decoder)
{
    auto data = decoder.decode<std::variant<Vector<uint8_t>, WebCore::FormDataElement::EncodedFileData, WebCore::FormDataElement::EncodedBlobData>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FormDataElement {
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebCore::FormDataElement::EncodedFileData>::encode(Encoder& encoder, const WebCore::FormDataElement::EncodedFileData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.filename)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileStart)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileLength)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expectedFileModificationTime)>, std::optional<WallTime>>);
    struct ShouldBeSameSizeAsEncodedFileData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FormDataElement::EncodedFileData>, false> {
        String filename;
        int64_t fileStart;
        int64_t fileLength;
        std::optional<WallTime> expectedFileModificationTime;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEncodedFileData) == sizeof(WebCore::FormDataElement::EncodedFileData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FormDataElement::EncodedFileData, filename)
        , offsetof(WebCore::FormDataElement::EncodedFileData, fileStart)
        , offsetof(WebCore::FormDataElement::EncodedFileData, fileLength)
        , offsetof(WebCore::FormDataElement::EncodedFileData, expectedFileModificationTime)
    >::value);
    encoder << instance.filename;
    encoder << instance.fileStart;
    encoder << instance.fileLength;
    encoder << instance.expectedFileModificationTime;
}

std::optional<WebCore::FormDataElement::EncodedFileData> ArgumentCoder<WebCore::FormDataElement::EncodedFileData>::decode(Decoder& decoder)
{
    auto filename = decoder.decode<String>();
    auto fileStart = decoder.decode<int64_t>();
    auto fileLength = decoder.decode<int64_t>();
    auto expectedFileModificationTime = decoder.decode<std::optional<WallTime>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FormDataElement::EncodedFileData {
            WTFMove(*filename),
            WTFMove(*fileStart),
            WTFMove(*fileLength),
            WTFMove(*expectedFileModificationTime)
        }
    };
}

void ArgumentCoder<WebCore::FormDataElement::EncodedBlobData>::encode(Encoder& encoder, const WebCore::FormDataElement::EncodedBlobData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, URL>);
    struct ShouldBeSameSizeAsEncodedBlobData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FormDataElement::EncodedBlobData>, false> {
        URL url;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEncodedBlobData) == sizeof(WebCore::FormDataElement::EncodedBlobData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FormDataElement::EncodedBlobData, url)
    >::value);
    encoder << instance.url;
}

std::optional<WebCore::FormDataElement::EncodedBlobData> ArgumentCoder<WebCore::FormDataElement::EncodedBlobData>::decode(Decoder& decoder)
{
    auto url = decoder.decode<URL>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FormDataElement::EncodedBlobData {
            WTFMove(*url)
        }
    };
}

void ArgumentCoder<WebCore::NetworkTransactionInformation>::encode(Encoder& encoder, const WebCore::NetworkTransactionInformation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::NetworkTransactionInformation::Type>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.request)>, WebCore::ResourceRequest>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.response)>, WebCore::ResourceResponse>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.metrics)>, WebCore::NetworkLoadMetrics>);
    struct ShouldBeSameSizeAsNetworkTransactionInformation : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::NetworkTransactionInformation>, false> {
        WebCore::NetworkTransactionInformation::Type type;
        WebCore::ResourceRequest request;
        WebCore::ResourceResponse response;
        WebCore::NetworkLoadMetrics metrics;
    };
    static_assert(sizeof(ShouldBeSameSizeAsNetworkTransactionInformation) == sizeof(WebCore::NetworkTransactionInformation));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::NetworkTransactionInformation, type)
        , offsetof(WebCore::NetworkTransactionInformation, request)
        , offsetof(WebCore::NetworkTransactionInformation, response)
        , offsetof(WebCore::NetworkTransactionInformation, metrics)
    >::value);
    encoder << instance.type;
    encoder << instance.request;
    encoder << instance.response;
    encoder << instance.metrics;
}

std::optional<WebCore::NetworkTransactionInformation> ArgumentCoder<WebCore::NetworkTransactionInformation>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::NetworkTransactionInformation::Type>();
    auto request = decoder.decode<WebCore::ResourceRequest>();
    auto response = decoder.decode<WebCore::ResourceResponse>();
    auto metrics = decoder.decode<WebCore::NetworkLoadMetrics>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::NetworkTransactionInformation {
            WTFMove(*type),
            WTFMove(*request),
            WTFMove(*response),
            WTFMove(*metrics)
        }
    };
}

void ArgumentCoder<WebCore::ContentType>::encode(Encoder& encoder, const WebCore::ContentType& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.raw())>, String>);
    encoder << instance.raw();
}

std::optional<WebCore::ContentType> ArgumentCoder<WebCore::ContentType>::decode(Decoder& decoder)
{
    auto raw = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ContentType {
            WTFMove(*raw)
        }
    };
}

#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
void ArgumentCoder<WebCore::DateTimeChooserParameters>::encode(Encoder& encoder, const WebCore::DateTimeChooserParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.anchorRectInRootView)>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.locale)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.currentValue)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.suggestionValues)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.localizedSuggestionValues)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.suggestionLabels)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.minimum)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximum)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.step)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stepBase)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.required)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isAnchorElementRTL)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.useDarkAppearance)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasSecondField)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasMillisecondField)>, bool>);
    struct ShouldBeSameSizeAsDateTimeChooserParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DateTimeChooserParameters>, false> {
        AtomString type;
        WebCore::IntRect anchorRectInRootView;
        AtomString locale;
        String currentValue;
        Vector<String> suggestionValues;
        Vector<String> localizedSuggestionValues;
        Vector<String> suggestionLabels;
        double minimum;
        double maximum;
        double step;
        double stepBase;
        bool required;
        bool isAnchorElementRTL;
        bool useDarkAppearance;
        bool hasSecondField;
        bool hasMillisecondField;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDateTimeChooserParameters) == sizeof(WebCore::DateTimeChooserParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DateTimeChooserParameters, type)
        , offsetof(WebCore::DateTimeChooserParameters, anchorRectInRootView)
        , offsetof(WebCore::DateTimeChooserParameters, locale)
        , offsetof(WebCore::DateTimeChooserParameters, currentValue)
        , offsetof(WebCore::DateTimeChooserParameters, suggestionValues)
        , offsetof(WebCore::DateTimeChooserParameters, localizedSuggestionValues)
        , offsetof(WebCore::DateTimeChooserParameters, suggestionLabels)
        , offsetof(WebCore::DateTimeChooserParameters, minimum)
        , offsetof(WebCore::DateTimeChooserParameters, maximum)
        , offsetof(WebCore::DateTimeChooserParameters, step)
        , offsetof(WebCore::DateTimeChooserParameters, stepBase)
        , offsetof(WebCore::DateTimeChooserParameters, required)
        , offsetof(WebCore::DateTimeChooserParameters, isAnchorElementRTL)
        , offsetof(WebCore::DateTimeChooserParameters, useDarkAppearance)
        , offsetof(WebCore::DateTimeChooserParameters, hasSecondField)
        , offsetof(WebCore::DateTimeChooserParameters, hasMillisecondField)
    >::value);
    encoder << instance.type;
    encoder << instance.anchorRectInRootView;
    encoder << instance.locale;
    encoder << instance.currentValue;
    encoder << instance.suggestionValues;
    encoder << instance.localizedSuggestionValues;
    encoder << instance.suggestionLabels;
    encoder << instance.minimum;
    encoder << instance.maximum;
    encoder << instance.step;
    encoder << instance.stepBase;
    encoder << instance.required;
    encoder << instance.isAnchorElementRTL;
    encoder << instance.useDarkAppearance;
    encoder << instance.hasSecondField;
    encoder << instance.hasMillisecondField;
}

std::optional<WebCore::DateTimeChooserParameters> ArgumentCoder<WebCore::DateTimeChooserParameters>::decode(Decoder& decoder)
{
    auto type = decoder.decode<AtomString>();
    auto anchorRectInRootView = decoder.decode<WebCore::IntRect>();
    auto locale = decoder.decode<AtomString>();
    auto currentValue = decoder.decode<String>();
    auto suggestionValues = decoder.decode<Vector<String>>();
    auto localizedSuggestionValues = decoder.decode<Vector<String>>();
    auto suggestionLabels = decoder.decode<Vector<String>>();
    auto minimum = decoder.decode<double>();
    auto maximum = decoder.decode<double>();
    auto step = decoder.decode<double>();
    auto stepBase = decoder.decode<double>();
    auto required = decoder.decode<bool>();
    auto isAnchorElementRTL = decoder.decode<bool>();
    auto useDarkAppearance = decoder.decode<bool>();
    auto hasSecondField = decoder.decode<bool>();
    auto hasMillisecondField = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DateTimeChooserParameters {
            WTFMove(*type),
            WTFMove(*anchorRectInRootView),
            WTFMove(*locale),
            WTFMove(*currentValue),
            WTFMove(*suggestionValues),
            WTFMove(*localizedSuggestionValues),
            WTFMove(*suggestionLabels),
            WTFMove(*minimum),
            WTFMove(*maximum),
            WTFMove(*step),
            WTFMove(*stepBase),
            WTFMove(*required),
            WTFMove(*isAnchorElementRTL),
            WTFMove(*useDarkAppearance),
            WTFMove(*hasSecondField),
            WTFMove(*hasMillisecondField)
        }
    };
}

#endif

void ArgumentCoder<WebCore::ScreenData>::encode(Encoder& encoder, const WebCore::ScreenData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenAvailableRect)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenRect)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorSpace)>, WebCore::DestinationColorSpace>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenDepth)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenDepthPerComponent)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenSupportsExtendedColor)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenHasInvertedColors)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenSupportsHighDynamicRange)>, bool>);
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenIsMonochrome)>, bool>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.displayMask)>, uint32_t>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gpuID)>, WebCore::PlatformGPUID>);
#endif
#if PLATFORM(MAC)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preferredDynamicRangeMode)>, WebCore::DynamicRangeMode>);
#endif
#if PLATFORM(MAC) || PLATFORM(IOS_FAMILY)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scaleFactor)>, float>);
#endif
    struct ShouldBeSameSizeAsScreenData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ScreenData>, false> {
        WebCore::FloatRect screenAvailableRect;
        WebCore::FloatRect screenRect;
        WebCore::DestinationColorSpace colorSpace;
        int screenDepth;
        int screenDepthPerComponent;
        bool screenSupportsExtendedColor;
        bool screenHasInvertedColors;
        bool screenSupportsHighDynamicRange;
#if PLATFORM(MAC)
        bool screenIsMonochrome;
#endif
#if PLATFORM(MAC)
        uint32_t displayMask;
#endif
#if PLATFORM(MAC)
        WebCore::PlatformGPUID gpuID;
#endif
#if PLATFORM(MAC)
        WebCore::DynamicRangeMode preferredDynamicRangeMode;
#endif
#if PLATFORM(MAC) || PLATFORM(IOS_FAMILY)
        float scaleFactor;
#endif
    };
    static_assert(sizeof(ShouldBeSameSizeAsScreenData) == sizeof(WebCore::ScreenData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ScreenData, screenAvailableRect)
        , offsetof(WebCore::ScreenData, screenRect)
        , offsetof(WebCore::ScreenData, colorSpace)
        , offsetof(WebCore::ScreenData, screenDepth)
        , offsetof(WebCore::ScreenData, screenDepthPerComponent)
        , offsetof(WebCore::ScreenData, screenSupportsExtendedColor)
        , offsetof(WebCore::ScreenData, screenHasInvertedColors)
        , offsetof(WebCore::ScreenData, screenSupportsHighDynamicRange)
#if PLATFORM(MAC)
        , offsetof(WebCore::ScreenData, screenIsMonochrome)
#endif
#if PLATFORM(MAC)
        , offsetof(WebCore::ScreenData, displayMask)
#endif
#if PLATFORM(MAC)
        , offsetof(WebCore::ScreenData, gpuID)
#endif
#if PLATFORM(MAC)
        , offsetof(WebCore::ScreenData, preferredDynamicRangeMode)
#endif
#if PLATFORM(MAC) || PLATFORM(IOS_FAMILY)
        , offsetof(WebCore::ScreenData, scaleFactor)
#endif
    >::value);
    encoder << instance.screenAvailableRect;
    encoder << instance.screenRect;
    encoder << instance.colorSpace;
    encoder << instance.screenDepth;
    encoder << instance.screenDepthPerComponent;
    encoder << instance.screenSupportsExtendedColor;
    encoder << instance.screenHasInvertedColors;
    encoder << instance.screenSupportsHighDynamicRange;
#if PLATFORM(MAC)
    encoder << instance.screenIsMonochrome;
#endif
#if PLATFORM(MAC)
    encoder << instance.displayMask;
#endif
#if PLATFORM(MAC)
    encoder << instance.gpuID;
#endif
#if PLATFORM(MAC)
    encoder << instance.preferredDynamicRangeMode;
#endif
#if PLATFORM(MAC) || PLATFORM(IOS_FAMILY)
    encoder << instance.scaleFactor;
#endif
}

std::optional<WebCore::ScreenData> ArgumentCoder<WebCore::ScreenData>::decode(Decoder& decoder)
{
    auto screenAvailableRect = decoder.decode<WebCore::FloatRect>();
    auto screenRect = decoder.decode<WebCore::FloatRect>();
    auto colorSpace = decoder.decode<WebCore::DestinationColorSpace>();
    auto screenDepth = decoder.decode<int>();
    auto screenDepthPerComponent = decoder.decode<int>();
    auto screenSupportsExtendedColor = decoder.decode<bool>();
    auto screenHasInvertedColors = decoder.decode<bool>();
    auto screenSupportsHighDynamicRange = decoder.decode<bool>();
#if PLATFORM(MAC)
    auto screenIsMonochrome = decoder.decode<bool>();
#endif
#if PLATFORM(MAC)
    auto displayMask = decoder.decode<uint32_t>();
#endif
#if PLATFORM(MAC)
    auto gpuID = decoder.decode<WebCore::PlatformGPUID>();
#endif
#if PLATFORM(MAC)
    auto preferredDynamicRangeMode = decoder.decode<WebCore::DynamicRangeMode>();
#endif
#if PLATFORM(MAC) || PLATFORM(IOS_FAMILY)
    auto scaleFactor = decoder.decode<float>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ScreenData {
            WTFMove(*screenAvailableRect),
            WTFMove(*screenRect),
            WTFMove(*colorSpace),
            WTFMove(*screenDepth),
            WTFMove(*screenDepthPerComponent),
            WTFMove(*screenSupportsExtendedColor),
            WTFMove(*screenHasInvertedColors),
            WTFMove(*screenSupportsHighDynamicRange),
#if PLATFORM(MAC)
            WTFMove(*screenIsMonochrome),
#endif
#if PLATFORM(MAC)
            WTFMove(*displayMask),
#endif
#if PLATFORM(MAC)
            WTFMove(*gpuID),
#endif
#if PLATFORM(MAC)
            WTFMove(*preferredDynamicRangeMode),
#endif
#if PLATFORM(MAC) || PLATFORM(IOS_FAMILY)
            WTFMove(*scaleFactor)
#endif
        }
    };
}

void ArgumentCoder<WebCore::ScreenProperties>::encode(Encoder& encoder, const WebCore::ScreenProperties& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.primaryDisplayID)>, WebCore::PlatformDisplayID>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.screenDataMap)>, HashMap<WebCore::PlatformDisplayID, WebCore::ScreenData>>);
    struct ShouldBeSameSizeAsScreenProperties : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ScreenProperties>, false> {
        WebCore::PlatformDisplayID primaryDisplayID;
        HashMap<WebCore::PlatformDisplayID, WebCore::ScreenData> screenDataMap;
    };
    static_assert(sizeof(ShouldBeSameSizeAsScreenProperties) == sizeof(WebCore::ScreenProperties));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ScreenProperties, primaryDisplayID)
        , offsetof(WebCore::ScreenProperties, screenDataMap)
    >::value);
    encoder << instance.primaryDisplayID;
    encoder << instance.screenDataMap;
}

std::optional<WebCore::ScreenProperties> ArgumentCoder<WebCore::ScreenProperties>::decode(Decoder& decoder)
{
    auto primaryDisplayID = decoder.decode<WebCore::PlatformDisplayID>();
    auto screenDataMap = decoder.decode<HashMap<WebCore::PlatformDisplayID, WebCore::ScreenData>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ScreenProperties {
            WTFMove(*primaryDisplayID),
            WTFMove(*screenDataMap)
        }
    };
}

void ArgumentCoder<WebCore::PlatformTimeRanges>::encode(Encoder& encoder, const WebCore::PlatformTimeRanges& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_ranges)>, Vector<WebCore::PlatformTimeRanges::Range>>);
    struct ShouldBeSameSizeAsPlatformTimeRanges : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PlatformTimeRanges>, false> {
        Vector<WebCore::PlatformTimeRanges::Range> m_ranges;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPlatformTimeRanges) == sizeof(WebCore::PlatformTimeRanges));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PlatformTimeRanges, m_ranges)
    >::value);
    encoder << instance.m_ranges;
}

std::optional<WebCore::PlatformTimeRanges> ArgumentCoder<WebCore::PlatformTimeRanges>::decode(Decoder& decoder)
{
    auto m_ranges = decoder.decode<Vector<WebCore::PlatformTimeRanges::Range>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PlatformTimeRanges {
            WTFMove(*m_ranges)
        }
    };
}

void ArgumentCoder<WebCore::PlatformTimeRanges::Range>::encode(Encoder& encoder, const WebCore::PlatformTimeRanges::Range& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.start)>, MediaTime>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.end)>, MediaTime>);
    struct ShouldBeSameSizeAsRange : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PlatformTimeRanges::Range>, false> {
        MediaTime start;
        MediaTime end;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRange) == sizeof(WebCore::PlatformTimeRanges::Range));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PlatformTimeRanges::Range, start)
        , offsetof(WebCore::PlatformTimeRanges::Range, end)
    >::value);
    encoder << instance.start;
    encoder << instance.end;
}

std::optional<WebCore::PlatformTimeRanges::Range> ArgumentCoder<WebCore::PlatformTimeRanges::Range>::decode(Decoder& decoder)
{
    auto start = decoder.decode<MediaTime>();
    auto end = decoder.decode<MediaTime>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PlatformTimeRanges::Range {
            WTFMove(*start),
            WTFMove(*end)
        }
    };
}

#if ENABLE(VIDEO)
void ArgumentCoder<WebCore::VideoPlaybackQualityMetrics>::encode(Encoder& encoder, const WebCore::VideoPlaybackQualityMetrics& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.totalVideoFrames)>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.droppedVideoFrames)>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.corruptedVideoFrames)>, uint32_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.totalFrameDelay)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.displayCompositedVideoFrames)>, uint32_t>);
    struct ShouldBeSameSizeAsVideoPlaybackQualityMetrics : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::VideoPlaybackQualityMetrics>, false> {
        uint32_t totalVideoFrames;
        uint32_t droppedVideoFrames;
        uint32_t corruptedVideoFrames;
        double totalFrameDelay;
        uint32_t displayCompositedVideoFrames;
    };
    static_assert(sizeof(ShouldBeSameSizeAsVideoPlaybackQualityMetrics) == sizeof(WebCore::VideoPlaybackQualityMetrics));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::VideoPlaybackQualityMetrics, totalVideoFrames)
        , offsetof(WebCore::VideoPlaybackQualityMetrics, droppedVideoFrames)
        , offsetof(WebCore::VideoPlaybackQualityMetrics, corruptedVideoFrames)
        , offsetof(WebCore::VideoPlaybackQualityMetrics, totalFrameDelay)
        , offsetof(WebCore::VideoPlaybackQualityMetrics, displayCompositedVideoFrames)
    >::value);
    encoder << instance.totalVideoFrames;
    encoder << instance.droppedVideoFrames;
    encoder << instance.corruptedVideoFrames;
    encoder << instance.totalFrameDelay;
    encoder << instance.displayCompositedVideoFrames;
}

std::optional<WebCore::VideoPlaybackQualityMetrics> ArgumentCoder<WebCore::VideoPlaybackQualityMetrics>::decode(Decoder& decoder)
{
    auto totalVideoFrames = decoder.decode<uint32_t>();
    auto droppedVideoFrames = decoder.decode<uint32_t>();
    auto corruptedVideoFrames = decoder.decode<uint32_t>();
    auto totalFrameDelay = decoder.decode<double>();
    auto displayCompositedVideoFrames = decoder.decode<uint32_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::VideoPlaybackQualityMetrics {
            WTFMove(*totalVideoFrames),
            WTFMove(*droppedVideoFrames),
            WTFMove(*corruptedVideoFrames),
            WTFMove(*totalFrameDelay),
            WTFMove(*displayCompositedVideoFrames)
        }
    };
}

#endif

#if PLATFORM(IOS_FAMILY)
void ArgumentCoder<WebCore::SelectionGeometry>::encode(Encoder& encoder, const WebCore::SelectionGeometry& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.quad())>, WebCore::FloatQuad>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.behavior())>, WebCore::SelectionRenderingBehavior>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction())>, WebCore::TextDirection>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.minX())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maxX())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maxY())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lineNumber())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isLineBreak())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFirstOnLine())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isLastOnLine())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containsStart())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containsEnd())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isHorizontal())>, bool>);
    encoder << instance.quad();
    encoder << instance.behavior();
    encoder << instance.direction();
    encoder << instance.minX();
    encoder << instance.maxX();
    encoder << instance.maxY();
    encoder << instance.lineNumber();
    encoder << instance.isLineBreak();
    encoder << instance.isFirstOnLine();
    encoder << instance.isLastOnLine();
    encoder << instance.containsStart();
    encoder << instance.containsEnd();
    encoder << instance.isHorizontal();
}

std::optional<WebCore::SelectionGeometry> ArgumentCoder<WebCore::SelectionGeometry>::decode(Decoder& decoder)
{
    auto quad = decoder.decode<WebCore::FloatQuad>();
    auto behavior = decoder.decode<WebCore::SelectionRenderingBehavior>();
    auto direction = decoder.decode<WebCore::TextDirection>();
    auto minX = decoder.decode<int>();
    auto maxX = decoder.decode<int>();
    auto maxY = decoder.decode<int>();
    auto lineNumber = decoder.decode<int>();
    auto isLineBreak = decoder.decode<bool>();
    auto isFirstOnLine = decoder.decode<bool>();
    auto isLastOnLine = decoder.decode<bool>();
    auto containsStart = decoder.decode<bool>();
    auto containsEnd = decoder.decode<bool>();
    auto isHorizontal = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SelectionGeometry {
            WTFMove(*quad),
            WTFMove(*behavior),
            WTFMove(*direction),
            WTFMove(*minX),
            WTFMove(*maxX),
            WTFMove(*maxY),
            WTFMove(*lineNumber),
            WTFMove(*isLineBreak),
            WTFMove(*isFirstOnLine),
            WTFMove(*isLastOnLine),
            WTFMove(*containsStart),
            WTFMove(*containsEnd),
            WTFMove(*isHorizontal)
        }
    };
}

#endif

#if ENABLE(DATALIST_ELEMENT)
void ArgumentCoder<WebCore::DataListSuggestion>::encode(Encoder& encoder, const WebCore::DataListSuggestion& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    struct ShouldBeSameSizeAsDataListSuggestion : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DataListSuggestion>, false> {
        String value;
        String label;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDataListSuggestion) == sizeof(WebCore::DataListSuggestion));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DataListSuggestion, value)
        , offsetof(WebCore::DataListSuggestion, label)
    >::value);
    encoder << instance.value;
    encoder << instance.label;
}

std::optional<WebCore::DataListSuggestion> ArgumentCoder<WebCore::DataListSuggestion>::decode(Decoder& decoder)
{
    auto value = decoder.decode<String>();
    auto label = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DataListSuggestion {
            WTFMove(*value),
            WTFMove(*label)
        }
    };
}

#endif

#if ENABLE(DATALIST_ELEMENT)
void ArgumentCoder<WebCore::DataListSuggestionInformation>::encode(Encoder& encoder, const WebCore::DataListSuggestionInformation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.activationType)>, WebCore::DataListSuggestionActivationType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.suggestions)>, Vector<WebCore::DataListSuggestion>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elementRect)>, WebCore::IntRect>);
    struct ShouldBeSameSizeAsDataListSuggestionInformation : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DataListSuggestionInformation>, false> {
        WebCore::DataListSuggestionActivationType activationType;
        Vector<WebCore::DataListSuggestion> suggestions;
        WebCore::IntRect elementRect;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDataListSuggestionInformation) == sizeof(WebCore::DataListSuggestionInformation));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DataListSuggestionInformation, activationType)
        , offsetof(WebCore::DataListSuggestionInformation, suggestions)
        , offsetof(WebCore::DataListSuggestionInformation, elementRect)
    >::value);
    encoder << instance.activationType;
    encoder << instance.suggestions;
    encoder << instance.elementRect;
}

std::optional<WebCore::DataListSuggestionInformation> ArgumentCoder<WebCore::DataListSuggestionInformation>::decode(Decoder& decoder)
{
    auto activationType = decoder.decode<WebCore::DataListSuggestionActivationType>();
    auto suggestions = decoder.decode<Vector<WebCore::DataListSuggestion>>();
    auto elementRect = decoder.decode<WebCore::IntRect>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DataListSuggestionInformation {
            WTFMove(*activationType),
            WTFMove(*suggestions),
            WTFMove(*elementRect)
        }
    };
}

#endif

void ArgumentCoder<WebCore::ClientOrigin>::encode(Encoder& encoder, const WebCore::ClientOrigin& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topOrigin)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientOrigin)>, WebCore::SecurityOriginData>);
    struct ShouldBeSameSizeAsClientOrigin : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ClientOrigin>, false> {
        WebCore::SecurityOriginData topOrigin;
        WebCore::SecurityOriginData clientOrigin;
    };
    static_assert(sizeof(ShouldBeSameSizeAsClientOrigin) == sizeof(WebCore::ClientOrigin));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ClientOrigin, topOrigin)
        , offsetof(WebCore::ClientOrigin, clientOrigin)
    >::value);
    encoder << instance.topOrigin;
    encoder << instance.clientOrigin;
}

std::optional<WebCore::ClientOrigin> ArgumentCoder<WebCore::ClientOrigin>::decode(Decoder& decoder)
{
    auto topOrigin = decoder.decode<WebCore::SecurityOriginData>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(!topOrigin->isNull()))
        return std::nullopt;
    auto clientOrigin = decoder.decode<WebCore::SecurityOriginData>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(!clientOrigin->isNull()))
        return std::nullopt;
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ClientOrigin {
            WTFMove(*topOrigin),
            WTFMove(*clientOrigin)
        }
    };
}

void ArgumentCoder<WebCore::PixelBufferFormat>::encode(Encoder& encoder, const WebCore::PixelBufferFormat& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alphaFormat)>, WebCore::AlphaPremultiplication>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pixelFormat)>, WebCore::PixelFormat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorSpace)>, WebCore::DestinationColorSpace>);
    struct ShouldBeSameSizeAsPixelBufferFormat : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PixelBufferFormat>, false> {
        WebCore::AlphaPremultiplication alphaFormat;
        WebCore::PixelFormat pixelFormat;
        WebCore::DestinationColorSpace colorSpace;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPixelBufferFormat) == sizeof(WebCore::PixelBufferFormat));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PixelBufferFormat, alphaFormat)
        , offsetof(WebCore::PixelBufferFormat, pixelFormat)
        , offsetof(WebCore::PixelBufferFormat, colorSpace)
    >::value);
    encoder << instance.alphaFormat;
    encoder << instance.pixelFormat;
    encoder << instance.colorSpace;
}

void ArgumentCoder<WebCore::PixelBufferFormat>::encode(StreamConnectionEncoder& encoder, const WebCore::PixelBufferFormat& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alphaFormat)>, WebCore::AlphaPremultiplication>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pixelFormat)>, WebCore::PixelFormat>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorSpace)>, WebCore::DestinationColorSpace>);
    struct ShouldBeSameSizeAsPixelBufferFormat : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PixelBufferFormat>, false> {
        WebCore::AlphaPremultiplication alphaFormat;
        WebCore::PixelFormat pixelFormat;
        WebCore::DestinationColorSpace colorSpace;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPixelBufferFormat) == sizeof(WebCore::PixelBufferFormat));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PixelBufferFormat, alphaFormat)
        , offsetof(WebCore::PixelBufferFormat, pixelFormat)
        , offsetof(WebCore::PixelBufferFormat, colorSpace)
    >::value);
    encoder << instance.alphaFormat;
    encoder << instance.pixelFormat;
    encoder << instance.colorSpace;
}

std::optional<WebCore::PixelBufferFormat> ArgumentCoder<WebCore::PixelBufferFormat>::decode(Decoder& decoder)
{
    auto alphaFormat = decoder.decode<WebCore::AlphaPremultiplication>();
    auto pixelFormat = decoder.decode<WebCore::PixelFormat>();
    auto colorSpace = decoder.decode<WebCore::DestinationColorSpace>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PixelBufferFormat {
            WTFMove(*alphaFormat),
            WTFMove(*pixelFormat),
            WTFMove(*colorSpace)
        }
    };
}

void ArgumentCoder<WebCore::TextIndicator>::encode(Encoder& encoder, const WebCore::TextIndicator& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, WebCore::TextIndicatorData>);
    encoder << instance.data();
}

std::optional<Ref<WebCore::TextIndicator>> ArgumentCoder<WebCore::TextIndicator>::decode(Decoder& decoder)
{
    auto data = decoder.decode<WebCore::TextIndicatorData>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextIndicator::create(
            WTFMove(*data)
        )
    };
}

void ArgumentCoder<WebCore::CertificateInfo>::encode(Encoder& encoder, const WebCore::CertificateInfo& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trust())>, RetainPtr<SecTrustRef>>);
#endif
#if USE(CURL)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.verificationError())>, int>);
#endif
#if USE(CURL)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.certificateChain())>, Vector<Vector<uint8_t>>>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.certificate())>, GRefPtr<GTlsCertificate>>);
#endif
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tlsErrors())>, GTlsCertificateFlags>);
#endif
#if PLATFORM(COCOA)
    encoder << instance.trust();
#endif
#if USE(CURL)
    encoder << instance.verificationError();
#endif
#if USE(CURL)
    encoder << instance.certificateChain();
#endif
#if USE(SOUP)
    encoder << instance.certificate();
#endif
#if USE(SOUP)
    encoder << instance.tlsErrors();
#endif
}

std::optional<WebCore::CertificateInfo> ArgumentCoder<WebCore::CertificateInfo>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto trust = decoder.decode<RetainPtr<SecTrustRef>>();
#endif
#if USE(CURL)
    auto verificationError = decoder.decode<int>();
#endif
#if USE(CURL)
    auto certificateChain = decoder.decode<Vector<Vector<uint8_t>>>();
#endif
#if USE(SOUP)
    auto certificate = decoder.decode<GRefPtr<GTlsCertificate>>();
#endif
#if USE(SOUP)
    auto tlsErrors = decoder.decode<GTlsCertificateFlags>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CertificateInfo {
#if PLATFORM(COCOA)
            WTFMove(*trust),
#endif
#if USE(CURL)
            WTFMove(*verificationError),
#endif
#if USE(CURL)
            WTFMove(*certificateChain),
#endif
#if USE(SOUP)
            WTFMove(*certificate),
#endif
#if USE(SOUP)
            WTFMove(*tlsErrors)
#endif
        }
    };
}

void ArgumentCoder<WebCore::PasteboardCustomData::Entry>::encode(Encoder& encoder, const WebCore::PasteboardCustomData::Entry& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.customData)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.platformData)>, std::variant<String, Ref<WebCore::SharedBuffer>>>);
    struct ShouldBeSameSizeAsEntry : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PasteboardCustomData::Entry>, false> {
        String type;
        String customData;
        std::variant<String, Ref<WebCore::SharedBuffer>> platformData;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEntry) == sizeof(WebCore::PasteboardCustomData::Entry));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::PasteboardCustomData::Entry, type)
        , offsetof(WebCore::PasteboardCustomData::Entry, customData)
        , offsetof(WebCore::PasteboardCustomData::Entry, platformData)
    >::value);
    encoder << instance.type;
    encoder << instance.customData;
    encoder << instance.platformData;
}

std::optional<WebCore::PasteboardCustomData::Entry> ArgumentCoder<WebCore::PasteboardCustomData::Entry>::decode(Decoder& decoder)
{
    auto type = decoder.decode<String>();
    auto customData = decoder.decode<String>();
    auto platformData = decoder.decode<std::variant<String, Ref<WebCore::SharedBuffer>>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PasteboardCustomData::Entry {
            WTFMove(*type),
            WTFMove(*customData),
            WTFMove(*platformData)
        }
    };
}

void ArgumentCoder<WebCore::PasteboardCustomData>::encode(Encoder& encoder, const WebCore::PasteboardCustomData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.origin())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, Vector<WebCore::PasteboardCustomData::Entry>>);
    encoder << instance.origin();
    encoder << instance.data();
}

std::optional<WebCore::PasteboardCustomData> ArgumentCoder<WebCore::PasteboardCustomData>::decode(Decoder& decoder)
{
    auto origin = decoder.decode<String>();
    auto data = decoder.decode<Vector<WebCore::PasteboardCustomData::Entry>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PasteboardCustomData {
            WTFMove(*origin),
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebCore::DatabaseDetails>::encode(Encoder& encoder, const WebCore::DatabaseDetails& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.displayName())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expectedUsage())>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.currentUsage())>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.creationTime())>, std::optional<WallTime>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.modificationTime())>, std::optional<WallTime>>);
    encoder << instance.name();
    encoder << instance.displayName();
    encoder << instance.expectedUsage();
    encoder << instance.currentUsage();
    encoder << instance.creationTime();
    encoder << instance.modificationTime();
}

std::optional<WebCore::DatabaseDetails> ArgumentCoder<WebCore::DatabaseDetails>::decode(Decoder& decoder)
{
    auto name = decoder.decode<String>();
    auto displayName = decoder.decode<String>();
    auto expectedUsage = decoder.decode<uint64_t>();
    auto currentUsage = decoder.decode<uint64_t>();
    auto creationTime = decoder.decode<std::optional<WallTime>>();
    auto modificationTime = decoder.decode<std::optional<WallTime>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DatabaseDetails {
            WTFMove(*name),
            WTFMove(*displayName),
            WTFMove(*expectedUsage),
            WTFMove(*currentUsage),
            WTFMove(*creationTime),
            WTFMove(*modificationTime)
        }
    };
}

void ArgumentCoder<WebCore::DecomposedGlyphs>::encode(Encoder& encoder, const WebCore::DecomposedGlyphs& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.positionedGlyphs())>, WebCore::PositionedGlyphs>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.renderingResourceIdentifier())>, WebCore::RenderingResourceIdentifier>);
    encoder << instance.positionedGlyphs();
    encoder << instance.renderingResourceIdentifier();
}

std::optional<Ref<WebCore::DecomposedGlyphs>> ArgumentCoder<WebCore::DecomposedGlyphs>::decode(Decoder& decoder)
{
    auto positionedGlyphs = decoder.decode<WebCore::PositionedGlyphs>();
    auto renderingResourceIdentifier = decoder.decode<WebCore::RenderingResourceIdentifier>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DecomposedGlyphs::create(
            WTFMove(*positionedGlyphs),
            WTFMove(*renderingResourceIdentifier)
        )
    };
}

void ArgumentCoder<WebCore::TextIndicatorData>::encode(Encoder& encoder, const WebCore::TextIndicatorData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.selectionRectInRootViewCoordinates)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textBoundingRectInRootViewCoordinates)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentImageWithoutSelectionRectInRootViewCoordinates)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textRectsInBoundingRectCoordinates)>, Vector<WebCore::FloatRect>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentImageScaleFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentImageWithHighlight)>, RefPtr<WebCore::Image>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentImageWithoutSelection)>, RefPtr<WebCore::Image>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentImage)>, RefPtr<WebCore::Image>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.estimatedBackgroundColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.presentationTransition)>, WebCore::TextIndicatorPresentationTransition>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.options)>, OptionSet<WebCore::TextIndicatorOption>>);
    struct ShouldBeSameSizeAsTextIndicatorData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextIndicatorData>, false> {
        WebCore::FloatRect selectionRectInRootViewCoordinates;
        WebCore::FloatRect textBoundingRectInRootViewCoordinates;
        WebCore::FloatRect contentImageWithoutSelectionRectInRootViewCoordinates;
        Vector<WebCore::FloatRect> textRectsInBoundingRectCoordinates;
        float contentImageScaleFactor;
        RefPtr<WebCore::Image> contentImageWithHighlight;
        RefPtr<WebCore::Image> contentImageWithoutSelection;
        RefPtr<WebCore::Image> contentImage;
        WebCore::Color estimatedBackgroundColor;
        WebCore::TextIndicatorPresentationTransition presentationTransition;
        OptionSet<WebCore::TextIndicatorOption> options;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextIndicatorData) == sizeof(WebCore::TextIndicatorData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextIndicatorData, selectionRectInRootViewCoordinates)
        , offsetof(WebCore::TextIndicatorData, textBoundingRectInRootViewCoordinates)
        , offsetof(WebCore::TextIndicatorData, contentImageWithoutSelectionRectInRootViewCoordinates)
        , offsetof(WebCore::TextIndicatorData, textRectsInBoundingRectCoordinates)
        , offsetof(WebCore::TextIndicatorData, contentImageScaleFactor)
        , offsetof(WebCore::TextIndicatorData, contentImageWithHighlight)
        , offsetof(WebCore::TextIndicatorData, contentImageWithoutSelection)
        , offsetof(WebCore::TextIndicatorData, contentImage)
        , offsetof(WebCore::TextIndicatorData, estimatedBackgroundColor)
        , offsetof(WebCore::TextIndicatorData, presentationTransition)
        , offsetof(WebCore::TextIndicatorData, options)
    >::value);
    encoder << instance.selectionRectInRootViewCoordinates;
    encoder << instance.textBoundingRectInRootViewCoordinates;
    encoder << instance.contentImageWithoutSelectionRectInRootViewCoordinates;
    encoder << instance.textRectsInBoundingRectCoordinates;
    encoder << instance.contentImageScaleFactor;
    encoder << instance.contentImageWithHighlight;
    encoder << instance.contentImageWithoutSelection;
    encoder << instance.contentImage;
    encoder << instance.estimatedBackgroundColor;
    encoder << instance.presentationTransition;
    encoder << instance.options;
}

std::optional<WebCore::TextIndicatorData> ArgumentCoder<WebCore::TextIndicatorData>::decode(Decoder& decoder)
{
    auto selectionRectInRootViewCoordinates = decoder.decode<WebCore::FloatRect>();
    auto textBoundingRectInRootViewCoordinates = decoder.decode<WebCore::FloatRect>();
    auto contentImageWithoutSelectionRectInRootViewCoordinates = decoder.decode<WebCore::FloatRect>();
    auto textRectsInBoundingRectCoordinates = decoder.decode<Vector<WebCore::FloatRect>>();
    auto contentImageScaleFactor = decoder.decode<float>();
    auto contentImageWithHighlight = decoder.decode<RefPtr<WebCore::Image>>();
    auto contentImageWithoutSelection = decoder.decode<RefPtr<WebCore::Image>>();
    auto contentImage = decoder.decode<RefPtr<WebCore::Image>>();
    auto estimatedBackgroundColor = decoder.decode<WebCore::Color>();
    auto presentationTransition = decoder.decode<WebCore::TextIndicatorPresentationTransition>();
    auto options = decoder.decode<OptionSet<WebCore::TextIndicatorOption>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextIndicatorData {
            WTFMove(*selectionRectInRootViewCoordinates),
            WTFMove(*textBoundingRectInRootViewCoordinates),
            WTFMove(*contentImageWithoutSelectionRectInRootViewCoordinates),
            WTFMove(*textRectsInBoundingRectCoordinates),
            WTFMove(*contentImageScaleFactor),
            WTFMove(*contentImageWithHighlight),
            WTFMove(*contentImageWithoutSelection),
            WTFMove(*contentImage),
            WTFMove(*estimatedBackgroundColor),
            WTFMove(*presentationTransition),
            WTFMove(*options)
        }
    };
}

#if ENABLE(MEDIA_STREAM)
void ArgumentCoder<WebCore::MediaConstraints>::encode(Encoder& encoder, const WebCore::MediaConstraints& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mandatoryConstraints)>, WebCore::MediaTrackConstraintSetMap>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.advancedConstraints)>, Vector<WebCore::MediaTrackConstraintSetMap>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isValid)>, bool>);
    struct ShouldBeSameSizeAsMediaConstraints : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MediaConstraints>, false> {
        WebCore::MediaTrackConstraintSetMap mandatoryConstraints;
        Vector<WebCore::MediaTrackConstraintSetMap> advancedConstraints;
        bool isValid;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaConstraints) == sizeof(WebCore::MediaConstraints));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaConstraints, mandatoryConstraints)
        , offsetof(WebCore::MediaConstraints, advancedConstraints)
        , offsetof(WebCore::MediaConstraints, isValid)
    >::value);
    encoder << instance.mandatoryConstraints;
    encoder << instance.advancedConstraints;
    encoder << instance.isValid;
}

std::optional<WebCore::MediaConstraints> ArgumentCoder<WebCore::MediaConstraints>::decode(Decoder& decoder)
{
    auto mandatoryConstraints = decoder.decode<WebCore::MediaTrackConstraintSetMap>();
    auto advancedConstraints = decoder.decode<Vector<WebCore::MediaTrackConstraintSetMap>>();
    auto isValid = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaConstraints {
            WTFMove(*mandatoryConstraints),
            WTFMove(*advancedConstraints),
            WTFMove(*isValid)
        }
    };
}

#endif

void ArgumentCoder<WebCore::PromisedAttachmentInfo>::encode(Encoder& encoder, const WebCore::PromisedAttachmentInfo& instance)
{
#if ENABLE(ATTACHMENT_ELEMENT)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.attachmentIdentifier)>, String>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.additionalTypes)>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.additionalData)>, Vector<RefPtr<WebCore::SharedBuffer>>>);
    struct ShouldBeSameSizeAsPromisedAttachmentInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::PromisedAttachmentInfo>, false> {
#if ENABLE(ATTACHMENT_ELEMENT)
        String attachmentIdentifier;
#endif
        Vector<String> additionalTypes;
        Vector<RefPtr<WebCore::SharedBuffer>> additionalData;
    };
    static_assert(sizeof(ShouldBeSameSizeAsPromisedAttachmentInfo) == sizeof(WebCore::PromisedAttachmentInfo));
    static_assert(MembersInCorrectOrder < 0
#if ENABLE(ATTACHMENT_ELEMENT)
        , offsetof(WebCore::PromisedAttachmentInfo, attachmentIdentifier)
#endif
        , offsetof(WebCore::PromisedAttachmentInfo, additionalTypes)
        , offsetof(WebCore::PromisedAttachmentInfo, additionalData)
    >::value);
#if ENABLE(ATTACHMENT_ELEMENT)
    encoder << instance.attachmentIdentifier;
#endif
    encoder << instance.additionalTypes;
    encoder << instance.additionalData;
}

std::optional<WebCore::PromisedAttachmentInfo> ArgumentCoder<WebCore::PromisedAttachmentInfo>::decode(Decoder& decoder)
{
#if ENABLE(ATTACHMENT_ELEMENT)
    auto attachmentIdentifier = decoder.decode<String>();
#endif
    auto additionalTypes = decoder.decode<Vector<String>>();
    auto additionalData = decoder.decode<Vector<RefPtr<WebCore::SharedBuffer>>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PromisedAttachmentInfo {
#if ENABLE(ATTACHMENT_ELEMENT)
            WTFMove(*attachmentIdentifier),
#endif
            WTFMove(*additionalTypes),
            WTFMove(*additionalData)
        }
    };
}

void ArgumentCoder<WebCore::RecentSearch>::encode(Encoder& encoder, const WebCore::RecentSearch& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.string)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.time)>, WallTime>);
    struct ShouldBeSameSizeAsRecentSearch : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::RecentSearch>, false> {
        String string;
        WallTime time;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRecentSearch) == sizeof(WebCore::RecentSearch));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::RecentSearch, string)
        , offsetof(WebCore::RecentSearch, time)
    >::value);
    encoder << instance.string;
    encoder << instance.time;
}

std::optional<WebCore::RecentSearch> ArgumentCoder<WebCore::RecentSearch>::decode(Decoder& decoder)
{
    auto string = decoder.decode<String>();
    auto time = decoder.decode<WallTime>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::RecentSearch {
            WTFMove(*string),
            WTFMove(*time)
        }
    };
}

void ArgumentCoder<WebCore::EventTrackingRegions>::encode(Encoder& encoder, const WebCore::EventTrackingRegions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.asynchronousDispatchRegion)>, WebCore::Region>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.eventSpecificSynchronousDispatchRegions)>, HashMap<WebCore::EventTrackingRegions::EventType, WebCore::Region, WTF::IntHash<WebCore::EventTrackingRegions::EventType>, WTF::StrongEnumHashTraits<WebCore::EventTrackingRegions::EventType>>>);
    struct ShouldBeSameSizeAsEventTrackingRegions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::EventTrackingRegions>, false> {
        WebCore::Region asynchronousDispatchRegion;
        HashMap<WebCore::EventTrackingRegions::EventType, WebCore::Region, WTF::IntHash<WebCore::EventTrackingRegions::EventType>, WTF::StrongEnumHashTraits<WebCore::EventTrackingRegions::EventType>> eventSpecificSynchronousDispatchRegions;
    };
    static_assert(sizeof(ShouldBeSameSizeAsEventTrackingRegions) == sizeof(WebCore::EventTrackingRegions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::EventTrackingRegions, asynchronousDispatchRegion)
        , offsetof(WebCore::EventTrackingRegions, eventSpecificSynchronousDispatchRegions)
    >::value);
    encoder << instance.asynchronousDispatchRegion;
    encoder << instance.eventSpecificSynchronousDispatchRegions;
}

std::optional<WebCore::EventTrackingRegions> ArgumentCoder<WebCore::EventTrackingRegions>::decode(Decoder& decoder)
{
    auto asynchronousDispatchRegion = decoder.decode<WebCore::Region>();
    auto eventSpecificSynchronousDispatchRegions = decoder.decode<HashMap<WebCore::EventTrackingRegions::EventType, WebCore::Region, WTF::IntHash<WebCore::EventTrackingRegions::EventType>, WTF::StrongEnumHashTraits<WebCore::EventTrackingRegions::EventType>>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::EventTrackingRegions {
            WTFMove(*asynchronousDispatchRegion),
            WTFMove(*eventSpecificSynchronousDispatchRegions)
        }
    };
}

void ArgumentCoder<WebCore::TextManipulationItem>::encode(Encoder& encoder, const WebCore::TextManipulationItem& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, WebCore::FrameIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSubframe)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isCrossSiteSubframe)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::TextManipulationItemIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tokens)>, Vector<WebCore::TextManipulationToken>>);
    struct ShouldBeSameSizeAsTextManipulationItem : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextManipulationItem>, false> {
        WebCore::FrameIdentifier frameID;
        bool isSubframe;
        bool isCrossSiteSubframe;
        WebCore::TextManipulationItemIdentifier identifier;
        Vector<WebCore::TextManipulationToken> tokens;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextManipulationItem) == sizeof(WebCore::TextManipulationItem));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextManipulationItem, frameID)
        , offsetof(WebCore::TextManipulationItem, isSubframe)
        , offsetof(WebCore::TextManipulationItem, isCrossSiteSubframe)
        , offsetof(WebCore::TextManipulationItem, identifier)
        , offsetof(WebCore::TextManipulationItem, tokens)
    >::value);
    encoder << instance.frameID;
    encoder << instance.isSubframe;
    encoder << instance.isCrossSiteSubframe;
    encoder << instance.identifier;
    encoder << instance.tokens;
}

std::optional<WebCore::TextManipulationItem> ArgumentCoder<WebCore::TextManipulationItem>::decode(Decoder& decoder)
{
    auto frameID = decoder.decode<WebCore::FrameIdentifier>();
    auto isSubframe = decoder.decode<bool>();
    auto isCrossSiteSubframe = decoder.decode<bool>();
    auto identifier = decoder.decode<WebCore::TextManipulationItemIdentifier>();
    auto tokens = decoder.decode<Vector<WebCore::TextManipulationToken>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextManipulationItem {
            WTFMove(*frameID),
            WTFMove(*isSubframe),
            WTFMove(*isCrossSiteSubframe),
            WTFMove(*identifier),
            WTFMove(*tokens)
        }
    };
}

void ArgumentCoder<WebCore::TextManipulationToken>::encode(Encoder& encoder, const WebCore::TextManipulationToken& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, WebCore::TextManipulationTokenIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.content)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.info)>, std::optional<WebCore::TextManipulationTokenInfo>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isExcluded)>, bool>);
    struct ShouldBeSameSizeAsTextManipulationToken : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextManipulationToken>, false> {
        WebCore::TextManipulationTokenIdentifier identifier;
        String content;
        std::optional<WebCore::TextManipulationTokenInfo> info;
        bool isExcluded;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextManipulationToken) == sizeof(WebCore::TextManipulationToken));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextManipulationToken, identifier)
        , offsetof(WebCore::TextManipulationToken, content)
        , offsetof(WebCore::TextManipulationToken, info)
        , offsetof(WebCore::TextManipulationToken, isExcluded)
    >::value);
    encoder << instance.identifier;
    encoder << instance.content;
    encoder << instance.info;
    encoder << instance.isExcluded;
}

std::optional<WebCore::TextManipulationToken> ArgumentCoder<WebCore::TextManipulationToken>::decode(Decoder& decoder)
{
    auto identifier = decoder.decode<WebCore::TextManipulationTokenIdentifier>();
    auto content = decoder.decode<String>();
    auto info = decoder.decode<std::optional<WebCore::TextManipulationTokenInfo>>();
    auto isExcluded = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextManipulationToken {
            WTFMove(*identifier),
            WTFMove(*content),
            WTFMove(*info),
            WTFMove(*isExcluded)
        }
    };
}

void ArgumentCoder<WebCore::TextManipulationTokenInfo>::encode(Encoder& encoder, const WebCore::TextManipulationTokenInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tagName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.roleAttribute)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.documentURL)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isVisible)>, bool>);
    struct ShouldBeSameSizeAsTextManipulationTokenInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextManipulationTokenInfo>, false> {
        String tagName;
        String roleAttribute;
        URL documentURL;
        bool isVisible;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextManipulationTokenInfo) == sizeof(WebCore::TextManipulationTokenInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextManipulationTokenInfo, tagName)
        , offsetof(WebCore::TextManipulationTokenInfo, roleAttribute)
        , offsetof(WebCore::TextManipulationTokenInfo, documentURL)
        , offsetof(WebCore::TextManipulationTokenInfo, isVisible)
    >::value);
    encoder << instance.tagName;
    encoder << instance.roleAttribute;
    encoder << instance.documentURL;
    encoder << instance.isVisible;
}

std::optional<WebCore::TextManipulationTokenInfo> ArgumentCoder<WebCore::TextManipulationTokenInfo>::decode(Decoder& decoder)
{
    auto tagName = decoder.decode<String>();
    auto roleAttribute = decoder.decode<String>();
    auto documentURL = decoder.decode<URL>();
    auto isVisible = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextManipulationTokenInfo {
            WTFMove(*tagName),
            WTFMove(*roleAttribute),
            WTFMove(*documentURL),
            WTFMove(*isVisible)
        }
    };
}

void ArgumentCoder<WebCore::VelocityData>::encode(Encoder& encoder, const WebCore::VelocityData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.horizontalVelocity)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.verticalVelocity)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scaleChangeRate)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lastUpdateTime)>, MonotonicTime>);
    struct ShouldBeSameSizeAsVelocityData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::VelocityData>, false> {
        float horizontalVelocity;
        float verticalVelocity;
        float scaleChangeRate;
        MonotonicTime lastUpdateTime;
    };
    static_assert(sizeof(ShouldBeSameSizeAsVelocityData) == sizeof(WebCore::VelocityData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::VelocityData, horizontalVelocity)
        , offsetof(WebCore::VelocityData, verticalVelocity)
        , offsetof(WebCore::VelocityData, scaleChangeRate)
        , offsetof(WebCore::VelocityData, lastUpdateTime)
    >::value);
    encoder << instance.horizontalVelocity;
    encoder << instance.verticalVelocity;
    encoder << instance.scaleChangeRate;
    encoder << instance.lastUpdateTime;
}

std::optional<WebCore::VelocityData> ArgumentCoder<WebCore::VelocityData>::decode(Decoder& decoder)
{
    auto horizontalVelocity = decoder.decode<float>();
    auto verticalVelocity = decoder.decode<float>();
    auto scaleChangeRate = decoder.decode<float>();
    auto lastUpdateTime = decoder.decode<MonotonicTime>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::VelocityData {
            WTFMove(*horizontalVelocity),
            WTFMove(*verticalVelocity),
            WTFMove(*scaleChangeRate),
            WTFMove(*lastUpdateTime)
        }
    };
}

void ArgumentCoder<WebCore::MimeClassInfo>::encode(Encoder& encoder, const WebCore::MimeClassInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.desc)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.extensions)>, Vector<String>>);
    struct ShouldBeSameSizeAsMimeClassInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MimeClassInfo>, false> {
        AtomString type;
        String desc;
        Vector<String> extensions;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMimeClassInfo) == sizeof(WebCore::MimeClassInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MimeClassInfo, type)
        , offsetof(WebCore::MimeClassInfo, desc)
        , offsetof(WebCore::MimeClassInfo, extensions)
    >::value);
    encoder << instance.type;
    encoder << instance.desc;
    encoder << instance.extensions;
}

std::optional<WebCore::MimeClassInfo> ArgumentCoder<WebCore::MimeClassInfo>::decode(Decoder& decoder)
{
    auto type = decoder.decode<AtomString>();
    auto desc = decoder.decode<String>();
    auto extensions = decoder.decode<Vector<String>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MimeClassInfo {
            WTFMove(*type),
            WTFMove(*desc),
            WTFMove(*extensions)
        }
    };
}

void ArgumentCoder<WebCore::AuthenticationChallenge>::encode(Encoder& encoder, const WebCore::AuthenticationChallenge& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.protectionSpace())>, WebCore::ProtectionSpace>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.proposedCredential())>, WebCore::Credential>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.previousFailureCount())>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.failureResponse())>, WebCore::ResourceResponse>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.error())>, WebCore::ResourceError>);
#if USE(SOUP)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tlsPasswordFlags())>, uint32_t>);
#endif
    encoder << instance.protectionSpace();
    encoder << instance.proposedCredential();
    encoder << instance.previousFailureCount();
    encoder << instance.failureResponse();
    encoder << instance.error();
#if USE(SOUP)
    encoder << instance.tlsPasswordFlags();
#endif
}

std::optional<WebCore::AuthenticationChallenge> ArgumentCoder<WebCore::AuthenticationChallenge>::decode(Decoder& decoder)
{
    auto protectionSpace = decoder.decode<WebCore::ProtectionSpace>();
    auto proposedCredential = decoder.decode<WebCore::Credential>();
    auto previousFailureCount = decoder.decode<unsigned>();
    auto failureResponse = decoder.decode<WebCore::ResourceResponse>();
    auto error = decoder.decode<WebCore::ResourceError>();
#if USE(SOUP)
    auto tlsPasswordFlags = decoder.decode<uint32_t>();
#endif
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::AuthenticationChallenge {
            WTFMove(*protectionSpace),
            WTFMove(*proposedCredential),
            WTFMove(*previousFailureCount),
            WTFMove(*failureResponse),
            WTFMove(*error),
#if USE(SOUP)
            WTFMove(*tlsPasswordFlags)
#endif
        }
    };
}

#if ENABLE(DRAG_SUPPORT)
void ArgumentCoder<WebCore::DragData>::encode(Encoder& encoder, const WebCore::DragData& instance)
{
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pasteboardName())>, String>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientPosition())>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.globalPosition())>, WebCore::IntPoint>);
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fileNames())>, Vector<String>>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.draggingSourceOperationMask())>, OptionSet<WebCore::DragOperation>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.flags())>, OptionSet<WebCore::DragApplicationFlags>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dragDestinationActionMask())>, OptionSet<WebCore::DragDestinationAction>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageID())>, std::optional<WebCore::PageIdentifier>>);
#if PLATFORM(COCOA)
    encoder << instance.pasteboardName();
#endif
    encoder << instance.clientPosition();
    encoder << instance.globalPosition();
#if PLATFORM(COCOA)
    encoder << instance.fileNames();
#endif
    encoder << instance.draggingSourceOperationMask();
    encoder << instance.flags();
    encoder << instance.dragDestinationActionMask();
    encoder << instance.pageID();
}

std::optional<WebCore::DragData> ArgumentCoder<WebCore::DragData>::decode(Decoder& decoder)
{
#if PLATFORM(COCOA)
    auto pasteboardName = decoder.decode<String>();
#endif
    auto clientPosition = decoder.decode<WebCore::IntPoint>();
    auto globalPosition = decoder.decode<WebCore::IntPoint>();
#if PLATFORM(COCOA)
    auto fileNames = decoder.decode<Vector<String>>();
#endif
    auto draggingSourceOperationMask = decoder.decode<OptionSet<WebCore::DragOperation>>();
    auto flags = decoder.decode<OptionSet<WebCore::DragApplicationFlags>>();
    auto dragDestinationActionMask = decoder.decode<OptionSet<WebCore::DragDestinationAction>>();
    auto pageID = decoder.decode<std::optional<WebCore::PageIdentifier>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DragData {
#if PLATFORM(COCOA)
            WTFMove(*pasteboardName),
#endif
            WTFMove(*clientPosition),
            WTFMove(*globalPosition),
#if PLATFORM(COCOA)
            WTFMove(*fileNames),
#endif
            WTFMove(*draggingSourceOperationMask),
            WTFMove(*flags),
            WTFMove(*dragDestinationActionMask),
            WTFMove(*pageID)
        }
    };
}

#endif

void ArgumentCoder<WebCore::DictationAlternative>::encode(Encoder& encoder, const WebCore::DictationAlternative& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.range)>, WebCore::CharacterRange>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.context)>, WebCore::DictationContext>);
    struct ShouldBeSameSizeAsDictationAlternative : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::DictationAlternative>, false> {
        WebCore::CharacterRange range;
        WebCore::DictationContext context;
    };
    static_assert(sizeof(ShouldBeSameSizeAsDictationAlternative) == sizeof(WebCore::DictationAlternative));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::DictationAlternative, range)
        , offsetof(WebCore::DictationAlternative, context)
    >::value);
    encoder << instance.range;
    encoder << instance.context;
}

std::optional<WebCore::DictationAlternative> ArgumentCoder<WebCore::DictationAlternative>::decode(Decoder& decoder)
{
    auto range = decoder.decode<WebCore::CharacterRange>();
    auto context = decoder.decode<WebCore::DictationContext>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DictationAlternative {
            WTFMove(*range),
            WTFMove(*context)
        }
    };
}

void ArgumentCoder<WebCore::UserStyleSheet>::encode(Encoder& encoder, const WebCore::UserStyleSheet& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.source())>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url())>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowlist())>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blocklist())>, Vector<String>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.injectedFrames())>, WebCore::UserContentInjectedFrames>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.level())>, WebCore::UserStyleLevel>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageID())>, std::optional<WebCore::PageIdentifier>>);
    encoder << instance.source();
    encoder << instance.url();
    encoder << instance.allowlist();
    encoder << instance.blocklist();
    encoder << instance.injectedFrames();
    encoder << instance.level();
    encoder << instance.pageID();
}

std::optional<WebCore::UserStyleSheet> ArgumentCoder<WebCore::UserStyleSheet>::decode(Decoder& decoder)
{
    auto source = decoder.decode<String>();
    auto url = decoder.decode<URL>();
    auto allowlist = decoder.decode<Vector<String>>();
    auto blocklist = decoder.decode<Vector<String>>();
    auto injectedFrames = decoder.decode<WebCore::UserContentInjectedFrames>();
    auto level = decoder.decode<WebCore::UserStyleLevel>();
    auto pageID = decoder.decode<std::optional<WebCore::PageIdentifier>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::UserStyleSheet {
            WTFMove(*source),
            WTFMove(*url),
            WTFMove(*allowlist),
            WTFMove(*blocklist),
            WTFMove(*injectedFrames),
            WTFMove(*level),
            WTFMove(*pageID)
        }
    };
}

void ArgumentCoder<WebCore::ScrollableAreaParameters>::encode(Encoder& encoder, const WebCore::ScrollableAreaParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.horizontalScrollElasticity)>, WebCore::ScrollElasticity>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.verticalScrollElasticity)>, WebCore::ScrollElasticity>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.horizontalScrollbarMode)>, WebCore::ScrollbarMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.verticalScrollbarMode)>, WebCore::ScrollbarMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.horizontalOverscrollBehavior)>, WebCore::OverscrollBehavior>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.verticalOverscrollBehavior)>, WebCore::OverscrollBehavior>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsHorizontalScrolling)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowsVerticalScrolling)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.horizontalNativeScrollbarVisibility)>, WebCore::NativeScrollbarVisibility>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.verticalNativeScrollbarVisibility)>, WebCore::NativeScrollbarVisibility>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.useDarkAppearanceForScrollbars)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollbarWidthStyle)>, WebCore::ScrollbarWidth>);
    struct ShouldBeSameSizeAsScrollableAreaParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ScrollableAreaParameters>, false> {
        WebCore::ScrollElasticity horizontalScrollElasticity;
        WebCore::ScrollElasticity verticalScrollElasticity;
        WebCore::ScrollbarMode horizontalScrollbarMode;
        WebCore::ScrollbarMode verticalScrollbarMode;
        WebCore::OverscrollBehavior horizontalOverscrollBehavior;
        WebCore::OverscrollBehavior verticalOverscrollBehavior;
        bool allowsHorizontalScrolling;
        bool allowsVerticalScrolling;
        WebCore::NativeScrollbarVisibility horizontalNativeScrollbarVisibility;
        WebCore::NativeScrollbarVisibility verticalNativeScrollbarVisibility;
        bool useDarkAppearanceForScrollbars;
        WebCore::ScrollbarWidth scrollbarWidthStyle;
    };
    static_assert(sizeof(ShouldBeSameSizeAsScrollableAreaParameters) == sizeof(WebCore::ScrollableAreaParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ScrollableAreaParameters, horizontalScrollElasticity)
        , offsetof(WebCore::ScrollableAreaParameters, verticalScrollElasticity)
        , offsetof(WebCore::ScrollableAreaParameters, horizontalScrollbarMode)
        , offsetof(WebCore::ScrollableAreaParameters, verticalScrollbarMode)
        , offsetof(WebCore::ScrollableAreaParameters, horizontalOverscrollBehavior)
        , offsetof(WebCore::ScrollableAreaParameters, verticalOverscrollBehavior)
        , offsetof(WebCore::ScrollableAreaParameters, allowsHorizontalScrolling)
        , offsetof(WebCore::ScrollableAreaParameters, allowsVerticalScrolling)
        , offsetof(WebCore::ScrollableAreaParameters, horizontalNativeScrollbarVisibility)
        , offsetof(WebCore::ScrollableAreaParameters, verticalNativeScrollbarVisibility)
        , offsetof(WebCore::ScrollableAreaParameters, useDarkAppearanceForScrollbars)
        , offsetof(WebCore::ScrollableAreaParameters, scrollbarWidthStyle)
    >::value);
    encoder << instance.horizontalScrollElasticity;
    encoder << instance.verticalScrollElasticity;
    encoder << instance.horizontalScrollbarMode;
    encoder << instance.verticalScrollbarMode;
    encoder << instance.horizontalOverscrollBehavior;
    encoder << instance.verticalOverscrollBehavior;
    encoder << instance.allowsHorizontalScrolling;
    encoder << instance.allowsVerticalScrolling;
    encoder << instance.horizontalNativeScrollbarVisibility;
    encoder << instance.verticalNativeScrollbarVisibility;
    encoder << instance.useDarkAppearanceForScrollbars;
    encoder << instance.scrollbarWidthStyle;
}

std::optional<WebCore::ScrollableAreaParameters> ArgumentCoder<WebCore::ScrollableAreaParameters>::decode(Decoder& decoder)
{
    auto horizontalScrollElasticity = decoder.decode<WebCore::ScrollElasticity>();
    auto verticalScrollElasticity = decoder.decode<WebCore::ScrollElasticity>();
    auto horizontalScrollbarMode = decoder.decode<WebCore::ScrollbarMode>();
    auto verticalScrollbarMode = decoder.decode<WebCore::ScrollbarMode>();
    auto horizontalOverscrollBehavior = decoder.decode<WebCore::OverscrollBehavior>();
    auto verticalOverscrollBehavior = decoder.decode<WebCore::OverscrollBehavior>();
    auto allowsHorizontalScrolling = decoder.decode<bool>();
    auto allowsVerticalScrolling = decoder.decode<bool>();
    auto horizontalNativeScrollbarVisibility = decoder.decode<WebCore::NativeScrollbarVisibility>();
    auto verticalNativeScrollbarVisibility = decoder.decode<WebCore::NativeScrollbarVisibility>();
    auto useDarkAppearanceForScrollbars = decoder.decode<bool>();
    auto scrollbarWidthStyle = decoder.decode<WebCore::ScrollbarWidth>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ScrollableAreaParameters {
            WTFMove(*horizontalScrollElasticity),
            WTFMove(*verticalScrollElasticity),
            WTFMove(*horizontalScrollbarMode),
            WTFMove(*verticalScrollbarMode),
            WTFMove(*horizontalOverscrollBehavior),
            WTFMove(*verticalOverscrollBehavior),
            WTFMove(*allowsHorizontalScrolling),
            WTFMove(*allowsVerticalScrolling),
            WTFMove(*horizontalNativeScrollbarVisibility),
            WTFMove(*verticalNativeScrollbarVisibility),
            WTFMove(*useDarkAppearanceForScrollbars),
            WTFMove(*scrollbarWidthStyle)
        }
    };
}

void ArgumentCoder<WebCore::RequestedKeyboardScrollData>::encode(Encoder& encoder, const WebCore::RequestedKeyboardScrollData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.action)>, WebCore::KeyboardScrollAction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keyboardScroll)>, std::optional<WebCore::KeyboardScroll>>);
    struct ShouldBeSameSizeAsRequestedKeyboardScrollData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::RequestedKeyboardScrollData>, false> {
        WebCore::KeyboardScrollAction action;
        std::optional<WebCore::KeyboardScroll> keyboardScroll;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRequestedKeyboardScrollData) == sizeof(WebCore::RequestedKeyboardScrollData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::RequestedKeyboardScrollData, action)
        , offsetof(WebCore::RequestedKeyboardScrollData, keyboardScroll)
    >::value);
    encoder << instance.action;
    encoder << instance.keyboardScroll;
}

std::optional<WebCore::RequestedKeyboardScrollData> ArgumentCoder<WebCore::RequestedKeyboardScrollData>::decode(Decoder& decoder)
{
    auto action = decoder.decode<WebCore::KeyboardScrollAction>();
    auto keyboardScroll = decoder.decode<std::optional<WebCore::KeyboardScroll>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::RequestedKeyboardScrollData {
            WTFMove(*action),
            WTFMove(*keyboardScroll)
        }
    };
}

void ArgumentCoder<WebCore::AbsolutePositionConstraints>::encode(Encoder& encoder, const WebCore::AbsolutePositionConstraints& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alignmentOffset())>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.layerPositionAtLastLayout())>, WebCore::FloatPoint>);
    encoder << instance.alignmentOffset();
    encoder << instance.layerPositionAtLastLayout();
}

std::optional<WebCore::AbsolutePositionConstraints> ArgumentCoder<WebCore::AbsolutePositionConstraints>::decode(Decoder& decoder)
{
    auto alignmentOffset = decoder.decode<WebCore::FloatSize>();
    auto layerPositionAtLastLayout = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::AbsolutePositionConstraints {
            WTFMove(*alignmentOffset),
            WTFMove(*layerPositionAtLastLayout)
        }
    };
}

void ArgumentCoder<WebCore::KeyboardScroll>::encode(Encoder& encoder, const WebCore::KeyboardScroll& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.offset)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximumVelocity)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.force)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.granularity)>, WebCore::ScrollGranularity>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction)>, WebCore::ScrollDirection>);
    struct ShouldBeSameSizeAsKeyboardScroll : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::KeyboardScroll>, false> {
        WebCore::FloatSize offset;
        WebCore::FloatSize maximumVelocity;
        WebCore::FloatSize force;
        WebCore::ScrollGranularity granularity;
        WebCore::ScrollDirection direction;
    };
    static_assert(sizeof(ShouldBeSameSizeAsKeyboardScroll) == sizeof(WebCore::KeyboardScroll));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::KeyboardScroll, offset)
        , offsetof(WebCore::KeyboardScroll, maximumVelocity)
        , offsetof(WebCore::KeyboardScroll, force)
        , offsetof(WebCore::KeyboardScroll, granularity)
        , offsetof(WebCore::KeyboardScroll, direction)
    >::value);
    encoder << instance.offset;
    encoder << instance.maximumVelocity;
    encoder << instance.force;
    encoder << instance.granularity;
    encoder << instance.direction;
}

std::optional<WebCore::KeyboardScroll> ArgumentCoder<WebCore::KeyboardScroll>::decode(Decoder& decoder)
{
    auto offset = decoder.decode<WebCore::FloatSize>();
    auto maximumVelocity = decoder.decode<WebCore::FloatSize>();
    auto force = decoder.decode<WebCore::FloatSize>();
    auto granularity = decoder.decode<WebCore::ScrollGranularity>();
    auto direction = decoder.decode<WebCore::ScrollDirection>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::KeyboardScroll {
            WTFMove(*offset),
            WTFMove(*maximumVelocity),
            WTFMove(*force),
            WTFMove(*granularity),
            WTFMove(*direction)
        }
    };
}

void ArgumentCoder<WebCore::NotificationResources>::encode(Encoder& encoder, const WebCore::NotificationResources& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.icon())>, RefPtr<WebCore::Image>>);
    encoder << instance.icon();
}

std::optional<Ref<WebCore::NotificationResources>> ArgumentCoder<WebCore::NotificationResources>::decode(Decoder& decoder)
{
    auto icon = decoder.decode<RefPtr<WebCore::Image>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::NotificationResources::create(
            WTFMove(*icon)
        )
    };
}

void ArgumentCoder<WebCore::IdentityTransformOperation>::encode(Encoder& encoder, const WebCore::IdentityTransformOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::TransformOperation::Type>);
}

std::optional<Ref<WebCore::IdentityTransformOperation>> ArgumentCoder<WebCore::IdentityTransformOperation>::decode(Decoder& decoder)
{
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::IdentityTransformOperation::create(
        )
    };
}

void ArgumentCoder<WebCore::TranslateTransformOperation>::encode(Encoder& encoder, const WebCore::TranslateTransformOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, WebCore::Length>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, WebCore::Length>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.z())>, WebCore::Length>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::TransformOperation::Type>);
    encoder << instance.x();
    encoder << instance.y();
    encoder << instance.z();
    encoder << instance.type();
}

std::optional<Ref<WebCore::TranslateTransformOperation>> ArgumentCoder<WebCore::TranslateTransformOperation>::decode(Decoder& decoder)
{
    auto x = decoder.decode<WebCore::Length>();
    auto y = decoder.decode<WebCore::Length>();
    auto z = decoder.decode<WebCore::Length>();
    auto type = decoder.decode<WebCore::TransformOperation::Type>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(WebCore::TransformOperation::isTranslateTransformOperationType(*type)))
        return std::nullopt;
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TranslateTransformOperation::create(
            WTFMove(*x),
            WTFMove(*y),
            WTFMove(*z),
            WTFMove(*type)
        )
    };
}

void ArgumentCoder<WebCore::RotateTransformOperation>::encode(Encoder& encoder, const WebCore::RotateTransformOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.z())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.angle())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::TransformOperation::Type>);
    encoder << instance.x();
    encoder << instance.y();
    encoder << instance.z();
    encoder << instance.angle();
    encoder << instance.type();
}

std::optional<Ref<WebCore::RotateTransformOperation>> ArgumentCoder<WebCore::RotateTransformOperation>::decode(Decoder& decoder)
{
    auto x = decoder.decode<double>();
    auto y = decoder.decode<double>();
    auto z = decoder.decode<double>();
    auto angle = decoder.decode<double>();
    auto type = decoder.decode<WebCore::TransformOperation::Type>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(WebCore::TransformOperation::isRotateTransformOperationType(*type)))
        return std::nullopt;
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::RotateTransformOperation::create(
            WTFMove(*x),
            WTFMove(*y),
            WTFMove(*z),
            WTFMove(*angle),
            WTFMove(*type)
        )
    };
}

void ArgumentCoder<WebCore::ScaleTransformOperation>::encode(Encoder& encoder, const WebCore::ScaleTransformOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.x())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.y())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.z())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::TransformOperation::Type>);
    encoder << instance.x();
    encoder << instance.y();
    encoder << instance.z();
    encoder << instance.type();
}

std::optional<Ref<WebCore::ScaleTransformOperation>> ArgumentCoder<WebCore::ScaleTransformOperation>::decode(Decoder& decoder)
{
    auto x = decoder.decode<double>();
    auto y = decoder.decode<double>();
    auto z = decoder.decode<double>();
    auto type = decoder.decode<WebCore::TransformOperation::Type>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(WebCore::TransformOperation::isScaleTransformOperationType(*type)))
        return std::nullopt;
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ScaleTransformOperation::create(
            WTFMove(*x),
            WTFMove(*y),
            WTFMove(*z),
            WTFMove(*type)
        )
    };
}

void ArgumentCoder<WebCore::SkewTransformOperation>::encode(Encoder& encoder, const WebCore::SkewTransformOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.angleX())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.angleY())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::TransformOperation::Type>);
    encoder << instance.angleX();
    encoder << instance.angleY();
    encoder << instance.type();
}

std::optional<Ref<WebCore::SkewTransformOperation>> ArgumentCoder<WebCore::SkewTransformOperation>::decode(Decoder& decoder)
{
    auto angleX = decoder.decode<double>();
    auto angleY = decoder.decode<double>();
    auto type = decoder.decode<WebCore::TransformOperation::Type>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(WebCore::TransformOperation::isSkewTransformOperationType(*type)))
        return std::nullopt;
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SkewTransformOperation::create(
            WTFMove(*angleX),
            WTFMove(*angleY),
            WTFMove(*type)
        )
    };
}

void ArgumentCoder<WebCore::PerspectiveTransformOperation>::encode(Encoder& encoder, const WebCore::PerspectiveTransformOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.perspective())>, std::optional<WebCore::Length>>);
    encoder << instance.perspective();
}

std::optional<Ref<WebCore::PerspectiveTransformOperation>> ArgumentCoder<WebCore::PerspectiveTransformOperation>::decode(Decoder& decoder)
{
    auto perspective = decoder.decode<std::optional<WebCore::Length>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PerspectiveTransformOperation::create(
            WTFMove(*perspective)
        )
    };
}

void ArgumentCoder<WebCore::MatrixTransformOperation>::encode(Encoder& encoder, const WebCore::MatrixTransformOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.matrix())>, WebCore::TransformationMatrix>);
    encoder << instance.matrix();
}

std::optional<Ref<WebCore::MatrixTransformOperation>> ArgumentCoder<WebCore::MatrixTransformOperation>::decode(Decoder& decoder)
{
    auto matrix = decoder.decode<WebCore::TransformationMatrix>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MatrixTransformOperation::create(
            WTFMove(*matrix)
        )
    };
}

void ArgumentCoder<WebCore::Matrix3DTransformOperation>::encode(Encoder& encoder, const WebCore::Matrix3DTransformOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.matrix())>, WebCore::TransformationMatrix>);
    encoder << instance.matrix();
}

std::optional<Ref<WebCore::Matrix3DTransformOperation>> ArgumentCoder<WebCore::Matrix3DTransformOperation>::decode(Decoder& decoder)
{
    auto matrix = decoder.decode<WebCore::TransformationMatrix>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::Matrix3DTransformOperation::create(
            WTFMove(*matrix)
        )
    };
}

void ArgumentCoder<WebCore::TransformOperations>::encode(Encoder& encoder, const WebCore::TransformOperations& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.operations())>, Vector<RefPtr<WebCore::TransformOperation>>>);
    encoder << instance.operations();
}

std::optional<WebCore::TransformOperations> ArgumentCoder<WebCore::TransformOperations>::decode(Decoder& decoder)
{
    auto operations = decoder.decode<Vector<RefPtr<WebCore::TransformOperation>>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TransformOperations {
            WTFMove(*operations)
        }
    };
}

void ArgumentCoder<WebCore::Gradient::LinearData>::encode(Encoder& encoder, const WebCore::Gradient::LinearData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point0)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point1)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsLinearData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Gradient::LinearData>, false> {
        WebCore::FloatPoint point0;
        WebCore::FloatPoint point1;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLinearData) == sizeof(WebCore::Gradient::LinearData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Gradient::LinearData, point0)
        , offsetof(WebCore::Gradient::LinearData, point1)
    >::value);
    encoder << instance.point0;
    encoder << instance.point1;
}

void ArgumentCoder<WebCore::Gradient::LinearData>::encode(StreamConnectionEncoder& encoder, const WebCore::Gradient::LinearData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point0)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point1)>, WebCore::FloatPoint>);
    struct ShouldBeSameSizeAsLinearData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Gradient::LinearData>, false> {
        WebCore::FloatPoint point0;
        WebCore::FloatPoint point1;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLinearData) == sizeof(WebCore::Gradient::LinearData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Gradient::LinearData, point0)
        , offsetof(WebCore::Gradient::LinearData, point1)
    >::value);
    encoder << instance.point0;
    encoder << instance.point1;
}

std::optional<WebCore::Gradient::LinearData> ArgumentCoder<WebCore::Gradient::LinearData>::decode(Decoder& decoder)
{
    auto point0 = decoder.decode<WebCore::FloatPoint>();
    auto point1 = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::Gradient::LinearData {
            WTFMove(*point0),
            WTFMove(*point1)
        }
    };
}

void ArgumentCoder<WebCore::Gradient::RadialData>::encode(Encoder& encoder, const WebCore::Gradient::RadialData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point0)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startRadius)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endRadius)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.aspectRatio)>, float>);
    struct ShouldBeSameSizeAsRadialData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Gradient::RadialData>, false> {
        WebCore::FloatPoint point0;
        WebCore::FloatPoint point1;
        float startRadius;
        float endRadius;
        float aspectRatio;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRadialData) == sizeof(WebCore::Gradient::RadialData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Gradient::RadialData, point0)
        , offsetof(WebCore::Gradient::RadialData, point1)
        , offsetof(WebCore::Gradient::RadialData, startRadius)
        , offsetof(WebCore::Gradient::RadialData, endRadius)
        , offsetof(WebCore::Gradient::RadialData, aspectRatio)
    >::value);
    encoder << instance.point0;
    encoder << instance.point1;
    encoder << instance.startRadius;
    encoder << instance.endRadius;
    encoder << instance.aspectRatio;
}

void ArgumentCoder<WebCore::Gradient::RadialData>::encode(StreamConnectionEncoder& encoder, const WebCore::Gradient::RadialData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point0)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point1)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startRadius)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endRadius)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.aspectRatio)>, float>);
    struct ShouldBeSameSizeAsRadialData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Gradient::RadialData>, false> {
        WebCore::FloatPoint point0;
        WebCore::FloatPoint point1;
        float startRadius;
        float endRadius;
        float aspectRatio;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRadialData) == sizeof(WebCore::Gradient::RadialData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Gradient::RadialData, point0)
        , offsetof(WebCore::Gradient::RadialData, point1)
        , offsetof(WebCore::Gradient::RadialData, startRadius)
        , offsetof(WebCore::Gradient::RadialData, endRadius)
        , offsetof(WebCore::Gradient::RadialData, aspectRatio)
    >::value);
    encoder << instance.point0;
    encoder << instance.point1;
    encoder << instance.startRadius;
    encoder << instance.endRadius;
    encoder << instance.aspectRatio;
}

std::optional<WebCore::Gradient::RadialData> ArgumentCoder<WebCore::Gradient::RadialData>::decode(Decoder& decoder)
{
    auto point0 = decoder.decode<WebCore::FloatPoint>();
    auto point1 = decoder.decode<WebCore::FloatPoint>();
    auto startRadius = decoder.decode<float>();
    auto endRadius = decoder.decode<float>();
    auto aspectRatio = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::Gradient::RadialData {
            WTFMove(*point0),
            WTFMove(*point1),
            WTFMove(*startRadius),
            WTFMove(*endRadius),
            WTFMove(*aspectRatio)
        }
    };
}

void ArgumentCoder<WebCore::Gradient::ConicData>::encode(Encoder& encoder, const WebCore::Gradient::ConicData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point0)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.angleRadians)>, float>);
    struct ShouldBeSameSizeAsConicData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Gradient::ConicData>, false> {
        WebCore::FloatPoint point0;
        float angleRadians;
    };
    static_assert(sizeof(ShouldBeSameSizeAsConicData) == sizeof(WebCore::Gradient::ConicData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Gradient::ConicData, point0)
        , offsetof(WebCore::Gradient::ConicData, angleRadians)
    >::value);
    encoder << instance.point0;
    encoder << instance.angleRadians;
}

void ArgumentCoder<WebCore::Gradient::ConicData>::encode(StreamConnectionEncoder& encoder, const WebCore::Gradient::ConicData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.point0)>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.angleRadians)>, float>);
    struct ShouldBeSameSizeAsConicData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Gradient::ConicData>, false> {
        WebCore::FloatPoint point0;
        float angleRadians;
    };
    static_assert(sizeof(ShouldBeSameSizeAsConicData) == sizeof(WebCore::Gradient::ConicData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Gradient::ConicData, point0)
        , offsetof(WebCore::Gradient::ConicData, angleRadians)
    >::value);
    encoder << instance.point0;
    encoder << instance.angleRadians;
}

std::optional<WebCore::Gradient::ConicData> ArgumentCoder<WebCore::Gradient::ConicData>::decode(Decoder& decoder)
{
    auto point0 = decoder.decode<WebCore::FloatPoint>();
    auto angleRadians = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::Gradient::ConicData {
            WTFMove(*point0),
            WTFMove(*angleRadians)
        }
    };
}

void ArgumentCoder<WebCore::Gradient>::encode(Encoder& encoder, const WebCore::Gradient& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, std::variant<WebCore::Gradient::LinearData, WebCore::Gradient::RadialData, WebCore::Gradient::ConicData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorInterpolationMethod())>, WebCore::ColorInterpolationMethod>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.spreadMethod())>, WebCore::GradientSpreadMethod>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stops())>, WebCore::GradientColorStops>);
    encoder << instance.data();
    encoder << instance.colorInterpolationMethod();
    encoder << instance.spreadMethod();
    encoder << instance.stops();
}

void ArgumentCoder<WebCore::Gradient>::encode(StreamConnectionEncoder& encoder, const WebCore::Gradient& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, std::variant<WebCore::Gradient::LinearData, WebCore::Gradient::RadialData, WebCore::Gradient::ConicData>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.colorInterpolationMethod())>, WebCore::ColorInterpolationMethod>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.spreadMethod())>, WebCore::GradientSpreadMethod>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stops())>, WebCore::GradientColorStops>);
    encoder << instance.data();
    encoder << instance.colorInterpolationMethod();
    encoder << instance.spreadMethod();
    encoder << instance.stops();
}

std::optional<Ref<WebCore::Gradient>> ArgumentCoder<WebCore::Gradient>::decode(Decoder& decoder)
{
    auto data = decoder.decode<std::variant<WebCore::Gradient::LinearData, WebCore::Gradient::RadialData, WebCore::Gradient::ConicData>>();
    auto colorInterpolationMethod = decoder.decode<WebCore::ColorInterpolationMethod>();
    auto spreadMethod = decoder.decode<WebCore::GradientSpreadMethod>();
    auto stops = decoder.decode<WebCore::GradientColorStops>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::Gradient::create(
            WTFMove(*data),
            WTFMove(*colorInterpolationMethod),
            WTFMove(*spreadMethod),
            WTFMove(*stops)
        )
    };
}

void ArgumentCoder<WebCore::Pattern::Parameters>::encode(Encoder& encoder, const WebCore::Pattern::Parameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.repeatX)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.repeatY)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.patternSpaceTransform)>, WebCore::AffineTransform>);
    struct ShouldBeSameSizeAsParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Pattern::Parameters>, false> {
        bool repeatX;
        bool repeatY;
        WebCore::AffineTransform patternSpaceTransform;
    };
    static_assert(sizeof(ShouldBeSameSizeAsParameters) == sizeof(WebCore::Pattern::Parameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Pattern::Parameters, repeatX)
        , offsetof(WebCore::Pattern::Parameters, repeatY)
        , offsetof(WebCore::Pattern::Parameters, patternSpaceTransform)
    >::value);
    encoder << instance.repeatX;
    encoder << instance.repeatY;
    encoder << instance.patternSpaceTransform;
}

void ArgumentCoder<WebCore::Pattern::Parameters>::encode(StreamConnectionEncoder& encoder, const WebCore::Pattern::Parameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.repeatX)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.repeatY)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.patternSpaceTransform)>, WebCore::AffineTransform>);
    struct ShouldBeSameSizeAsParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::Pattern::Parameters>, false> {
        bool repeatX;
        bool repeatY;
        WebCore::AffineTransform patternSpaceTransform;
    };
    static_assert(sizeof(ShouldBeSameSizeAsParameters) == sizeof(WebCore::Pattern::Parameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::Pattern::Parameters, repeatX)
        , offsetof(WebCore::Pattern::Parameters, repeatY)
        , offsetof(WebCore::Pattern::Parameters, patternSpaceTransform)
    >::value);
    encoder << instance.repeatX;
    encoder << instance.repeatY;
    encoder << instance.patternSpaceTransform;
}

std::optional<WebCore::Pattern::Parameters> ArgumentCoder<WebCore::Pattern::Parameters>::decode(Decoder& decoder)
{
    auto repeatX = decoder.decode<bool>();
    auto repeatY = decoder.decode<bool>();
    auto patternSpaceTransform = decoder.decode<WebCore::AffineTransform>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::Pattern::Parameters {
            WTFMove(*repeatX),
            WTFMove(*repeatY),
            WTFMove(*patternSpaceTransform)
        }
    };
}

void ArgumentCoder<WebCore::Pattern>::encode(Encoder& encoder, const WebCore::Pattern& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tileImage())>, WebCore::SourceImage>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parameters())>, WebCore::Pattern::Parameters>);
    encoder << instance.tileImage();
    encoder << instance.parameters();
}

void ArgumentCoder<WebCore::Pattern>::encode(StreamConnectionEncoder& encoder, const WebCore::Pattern& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tileImage())>, WebCore::SourceImage>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.parameters())>, WebCore::Pattern::Parameters>);
    encoder << instance.tileImage();
    encoder << instance.parameters();
}

std::optional<Ref<WebCore::Pattern>> ArgumentCoder<WebCore::Pattern>::decode(Decoder& decoder)
{
    auto tileImage = decoder.decode<WebCore::SourceImage>();
    auto parameters = decoder.decode<WebCore::Pattern::Parameters>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::Pattern::create(
            WTFMove(*tileImage),
            WTFMove(*parameters)
        )
    };
}

void ArgumentCoder<WebCore::SourceBrush::Brush>::encode(Encoder& encoder, const WebCore::SourceBrush::Brush& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.brush)>, std::variant<WebCore::SourceBrush::Brush::LogicalGradient, Ref<WebCore::Pattern>>>);
    struct ShouldBeSameSizeAsBrush : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SourceBrush::Brush>, false> {
        std::variant<WebCore::SourceBrush::Brush::LogicalGradient, Ref<WebCore::Pattern>> brush;
    };
    static_assert(sizeof(ShouldBeSameSizeAsBrush) == sizeof(WebCore::SourceBrush::Brush));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SourceBrush::Brush, brush)
    >::value);
    encoder << instance.brush;
}

void ArgumentCoder<WebCore::SourceBrush::Brush>::encode(StreamConnectionEncoder& encoder, const WebCore::SourceBrush::Brush& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.brush)>, std::variant<WebCore::SourceBrush::Brush::LogicalGradient, Ref<WebCore::Pattern>>>);
    struct ShouldBeSameSizeAsBrush : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SourceBrush::Brush>, false> {
        std::variant<WebCore::SourceBrush::Brush::LogicalGradient, Ref<WebCore::Pattern>> brush;
    };
    static_assert(sizeof(ShouldBeSameSizeAsBrush) == sizeof(WebCore::SourceBrush::Brush));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SourceBrush::Brush, brush)
    >::value);
    encoder << instance.brush;
}

std::optional<WebCore::SourceBrush::Brush> ArgumentCoder<WebCore::SourceBrush::Brush>::decode(Decoder& decoder)
{
    auto brush = decoder.decode<std::variant<WebCore::SourceBrush::Brush::LogicalGradient, Ref<WebCore::Pattern>>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SourceBrush::Brush {
            WTFMove(*brush)
        }
    };
}

void ArgumentCoder<WebCore::SourceBrush>::encode(Encoder& encoder, const WebCore::SourceBrush& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.brush())>, std::optional<WebCore::SourceBrush::Brush>>);
    encoder << instance.color();
    encoder << instance.brush();
}

void ArgumentCoder<WebCore::SourceBrush>::encode(StreamConnectionEncoder& encoder, const WebCore::SourceBrush& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.brush())>, std::optional<WebCore::SourceBrush::Brush>>);
    encoder << instance.color();
    encoder << instance.brush();
}

std::optional<WebCore::SourceBrush> ArgumentCoder<WebCore::SourceBrush>::decode(Decoder& decoder)
{
    auto color = decoder.decode<WebCore::Color>();
    auto brush = decoder.decode<std::optional<WebCore::SourceBrush::Brush>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SourceBrush {
            WTFMove(*color),
            WTFMove(*brush)
        }
    };
}

#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL)
void ArgumentCoder<WebCore::GraphicsContextGLAttributes>::encode(Encoder& encoder, const WebCore::GraphicsContextGLAttributes& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alpha)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.depth)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stencil)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.antialias)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.premultipliedAlpha)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preserveDrawingBuffer)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.failIfMajorPerformanceCaveat)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.powerPreference)>, WebCore::GraphicsContextGLPowerPreference>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shareResources)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.noExtensions)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.devicePixelRatio)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.initialPowerPreference)>, WebCore::GraphicsContextGLPowerPreference>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.webGLVersion)>, WebCore::GraphicsContextGLWebGLVersion>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.forceRequestForHighPerformanceGPU)>, bool>);
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.windowGPUID)>, uint64_t>);
#endif
#if PLATFORM(COCOA)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.useMetal)>, bool>);
#endif
#if ENABLE(WEBXR)
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.xrCompatible)>, bool>);
#endif
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.failPlatformContextCreationForTesting)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.remoteIPCBufferSizeLog2ForTesting)>, unsigned>);
    struct ShouldBeSameSizeAsGraphicsContextGLAttributes : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::GraphicsContextGLAttributes>, false> {
        bool alpha;
        bool depth;
        bool stencil;
        bool antialias;
        bool premultipliedAlpha;
        bool preserveDrawingBuffer;
        bool failIfMajorPerformanceCaveat;
        WebCore::GraphicsContextGLPowerPreference powerPreference;
        bool shareResources;
        bool noExtensions;
        float devicePixelRatio;
        WebCore::GraphicsContextGLPowerPreference initialPowerPreference;
        WebCore::GraphicsContextGLWebGLVersion webGLVersion;
        bool forceRequestForHighPerformanceGPU;
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
        uint64_t windowGPUID;
#endif
#if PLATFORM(COCOA)
        bool useMetal;
#endif
#if ENABLE(WEBXR)
        bool xrCompatible;
#endif
        bool failPlatformContextCreationForTesting;
        unsigned remoteIPCBufferSizeLog2ForTesting;
    };
    static_assert(sizeof(ShouldBeSameSizeAsGraphicsContextGLAttributes) == sizeof(WebCore::GraphicsContextGLAttributes));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::GraphicsContextGLAttributes, alpha)
        , offsetof(WebCore::GraphicsContextGLAttributes, depth)
        , offsetof(WebCore::GraphicsContextGLAttributes, stencil)
        , offsetof(WebCore::GraphicsContextGLAttributes, antialias)
        , offsetof(WebCore::GraphicsContextGLAttributes, premultipliedAlpha)
        , offsetof(WebCore::GraphicsContextGLAttributes, preserveDrawingBuffer)
        , offsetof(WebCore::GraphicsContextGLAttributes, failIfMajorPerformanceCaveat)
        , offsetof(WebCore::GraphicsContextGLAttributes, powerPreference)
        , offsetof(WebCore::GraphicsContextGLAttributes, shareResources)
        , offsetof(WebCore::GraphicsContextGLAttributes, noExtensions)
        , offsetof(WebCore::GraphicsContextGLAttributes, devicePixelRatio)
        , offsetof(WebCore::GraphicsContextGLAttributes, initialPowerPreference)
        , offsetof(WebCore::GraphicsContextGLAttributes, webGLVersion)
        , offsetof(WebCore::GraphicsContextGLAttributes, forceRequestForHighPerformanceGPU)
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
        , offsetof(WebCore::GraphicsContextGLAttributes, windowGPUID)
#endif
#if PLATFORM(COCOA)
        , offsetof(WebCore::GraphicsContextGLAttributes, useMetal)
#endif
#if ENABLE(WEBXR)
        , offsetof(WebCore::GraphicsContextGLAttributes, xrCompatible)
#endif
        , offsetof(WebCore::GraphicsContextGLAttributes, failPlatformContextCreationForTesting)
        , offsetof(WebCore::GraphicsContextGLAttributes, remoteIPCBufferSizeLog2ForTesting)
    >::value);
    encoder << instance.alpha;
    encoder << instance.depth;
    encoder << instance.stencil;
    encoder << instance.antialias;
    encoder << instance.premultipliedAlpha;
    encoder << instance.preserveDrawingBuffer;
    encoder << instance.failIfMajorPerformanceCaveat;
    encoder << instance.powerPreference;
    encoder << instance.shareResources;
    encoder << instance.noExtensions;
    encoder << instance.devicePixelRatio;
    encoder << instance.initialPowerPreference;
    encoder << instance.webGLVersion;
    encoder << instance.forceRequestForHighPerformanceGPU;
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    encoder << instance.windowGPUID;
#endif
#if PLATFORM(COCOA)
    encoder << instance.useMetal;
#endif
#if ENABLE(WEBXR)
    encoder << instance.xrCompatible;
#endif
    encoder << instance.failPlatformContextCreationForTesting;
}

std::optional<WebCore::GraphicsContextGLAttributes> ArgumentCoder<WebCore::GraphicsContextGLAttributes>::decode(Decoder& decoder)
{
    auto alpha = decoder.decode<bool>();
    auto depth = decoder.decode<bool>();
    auto stencil = decoder.decode<bool>();
    auto antialias = decoder.decode<bool>();
    auto premultipliedAlpha = decoder.decode<bool>();
    auto preserveDrawingBuffer = decoder.decode<bool>();
    auto failIfMajorPerformanceCaveat = decoder.decode<bool>();
    auto powerPreference = decoder.decode<WebCore::GraphicsContextGLPowerPreference>();
    auto shareResources = decoder.decode<bool>();
    auto noExtensions = decoder.decode<bool>();
    auto devicePixelRatio = decoder.decode<float>();
    auto initialPowerPreference = decoder.decode<WebCore::GraphicsContextGLPowerPreference>();
    auto webGLVersion = decoder.decode<WebCore::GraphicsContextGLWebGLVersion>();
    auto forceRequestForHighPerformanceGPU = decoder.decode<bool>();
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
    auto windowGPUID = decoder.decode<uint64_t>();
#endif
#if PLATFORM(COCOA)
    auto useMetal = decoder.decode<bool>();
#endif
#if ENABLE(WEBXR)
    auto xrCompatible = decoder.decode<bool>();
#endif
    auto failPlatformContextCreationForTesting = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::GraphicsContextGLAttributes {
            WTFMove(*alpha),
            WTFMove(*depth),
            WTFMove(*stencil),
            WTFMove(*antialias),
            WTFMove(*premultipliedAlpha),
            WTFMove(*preserveDrawingBuffer),
            WTFMove(*failIfMajorPerformanceCaveat),
            WTFMove(*powerPreference),
            WTFMove(*shareResources),
            WTFMove(*noExtensions),
            WTFMove(*devicePixelRatio),
            WTFMove(*initialPowerPreference),
            WTFMove(*webGLVersion),
            WTFMove(*forceRequestForHighPerformanceGPU),
#if PLATFORM(MAC) || PLATFORM(MACCATALYST)
            WTFMove(*windowGPUID),
#endif
#if PLATFORM(COCOA)
            WTFMove(*useMetal),
#endif
#if ENABLE(WEBXR)
            WTFMove(*xrCompatible),
#endif
            WTFMove(*failPlatformContextCreationForTesting)
        }
    };
}

#endif

enum class WebCore_TimingFunction_Subclass : IPC::EncodedVariantIndex {
    LinearTimingFunction,
    CubicBezierTimingFunction,
    StepsTimingFunction,
    SpringTimingFunction
};

void ArgumentCoder<WebCore::TimingFunction>::encode(Encoder& encoder, const WebCore::TimingFunction& instance)
{
    if (auto* subclass = dynamicDowncast<WebCore::LinearTimingFunction>(instance)) {
        encoder << WebCore_TimingFunction_Subclass::LinearTimingFunction;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::CubicBezierTimingFunction>(instance)) {
        encoder << WebCore_TimingFunction_Subclass::CubicBezierTimingFunction;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::StepsTimingFunction>(instance)) {
        encoder << WebCore_TimingFunction_Subclass::StepsTimingFunction;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::SpringTimingFunction>(instance)) {
        encoder << WebCore_TimingFunction_Subclass::SpringTimingFunction;
        encoder << *subclass;
        return;
    }
    ASSERT_NOT_REACHED();
}

std::optional<Ref<WebCore::TimingFunction>> ArgumentCoder<WebCore::TimingFunction>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore_TimingFunction_Subclass>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (type == WebCore_TimingFunction_Subclass::LinearTimingFunction) {
        auto result = decoder.decode<Ref<WebCore::LinearTimingFunction>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TimingFunction_Subclass::CubicBezierTimingFunction) {
        auto result = decoder.decode<Ref<WebCore::CubicBezierTimingFunction>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TimingFunction_Subclass::StepsTimingFunction) {
        auto result = decoder.decode<Ref<WebCore::StepsTimingFunction>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TimingFunction_Subclass::SpringTimingFunction) {
        auto result = decoder.decode<Ref<WebCore::SpringTimingFunction>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    ASSERT_NOT_REACHED();
    return std::nullopt;
}

enum class WebCore_TransformOperation_Subclass : IPC::EncodedVariantIndex {
    TranslateTransformOperation,
    ScaleTransformOperation,
    RotateTransformOperation,
    SkewTransformOperation,
    MatrixTransformOperation,
    Matrix3DTransformOperation,
    PerspectiveTransformOperation,
    IdentityTransformOperation
};

void ArgumentCoder<WebCore::TransformOperation>::encode(Encoder& encoder, const WebCore::TransformOperation& instance)
{
    if (auto* subclass = dynamicDowncast<WebCore::TranslateTransformOperation>(instance)) {
        encoder << WebCore_TransformOperation_Subclass::TranslateTransformOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::ScaleTransformOperation>(instance)) {
        encoder << WebCore_TransformOperation_Subclass::ScaleTransformOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::RotateTransformOperation>(instance)) {
        encoder << WebCore_TransformOperation_Subclass::RotateTransformOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::SkewTransformOperation>(instance)) {
        encoder << WebCore_TransformOperation_Subclass::SkewTransformOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::MatrixTransformOperation>(instance)) {
        encoder << WebCore_TransformOperation_Subclass::MatrixTransformOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::Matrix3DTransformOperation>(instance)) {
        encoder << WebCore_TransformOperation_Subclass::Matrix3DTransformOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::PerspectiveTransformOperation>(instance)) {
        encoder << WebCore_TransformOperation_Subclass::PerspectiveTransformOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::IdentityTransformOperation>(instance)) {
        encoder << WebCore_TransformOperation_Subclass::IdentityTransformOperation;
        encoder << *subclass;
        return;
    }
    ASSERT_NOT_REACHED();
}

std::optional<Ref<WebCore::TransformOperation>> ArgumentCoder<WebCore::TransformOperation>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore_TransformOperation_Subclass>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (type == WebCore_TransformOperation_Subclass::TranslateTransformOperation) {
        auto result = decoder.decode<Ref<WebCore::TranslateTransformOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TransformOperation_Subclass::ScaleTransformOperation) {
        auto result = decoder.decode<Ref<WebCore::ScaleTransformOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TransformOperation_Subclass::RotateTransformOperation) {
        auto result = decoder.decode<Ref<WebCore::RotateTransformOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TransformOperation_Subclass::SkewTransformOperation) {
        auto result = decoder.decode<Ref<WebCore::SkewTransformOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TransformOperation_Subclass::MatrixTransformOperation) {
        auto result = decoder.decode<Ref<WebCore::MatrixTransformOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TransformOperation_Subclass::Matrix3DTransformOperation) {
        auto result = decoder.decode<Ref<WebCore::Matrix3DTransformOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TransformOperation_Subclass::PerspectiveTransformOperation) {
        auto result = decoder.decode<Ref<WebCore::PerspectiveTransformOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_TransformOperation_Subclass::IdentityTransformOperation) {
        auto result = decoder.decode<Ref<WebCore::IdentityTransformOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    ASSERT_NOT_REACHED();
    return std::nullopt;
}

void ArgumentCoder<WebCore::LengthSize>::encode(Encoder& encoder, const WebCore::LengthSize& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.width)>, WebCore::Length>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.height)>, WebCore::Length>);
    struct ShouldBeSameSizeAsLengthSize : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::LengthSize>, false> {
        WebCore::Length width;
        WebCore::Length height;
    };
    static_assert(sizeof(ShouldBeSameSizeAsLengthSize) == sizeof(WebCore::LengthSize));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::LengthSize, width)
        , offsetof(WebCore::LengthSize, height)
    >::value);
    encoder << instance.width;
    encoder << instance.height;
}

std::optional<WebCore::LengthSize> ArgumentCoder<WebCore::LengthSize>::decode(Decoder& decoder)
{
    auto width = decoder.decode<WebCore::Length>();
    auto height = decoder.decode<WebCore::Length>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::LengthSize {
            WTFMove(*width),
            WTFMove(*height)
        }
    };
}

void ArgumentCoder<WebCore::SVGPathByteStream>::encode(Encoder& encoder, const WebCore::SVGPathByteStream& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.data())>, Vector<unsigned char>>);
    encoder << instance.data();
}

std::optional<WebCore::SVGPathByteStream> ArgumentCoder<WebCore::SVGPathByteStream>::decode(Decoder& decoder)
{
    auto data = decoder.decode<Vector<unsigned char>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SVGPathByteStream {
            WTFMove(*data)
        }
    };
}

void ArgumentCoder<WebCore::BasicShapeCenterCoordinate>::encode(Encoder& encoder, const WebCore::BasicShapeCenterCoordinate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction())>, WebCore::BasicShapeCenterCoordinate::Direction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.length())>, WebCore::Length>);
    encoder << instance.direction();
    encoder << instance.length();
}

std::optional<WebCore::BasicShapeCenterCoordinate> ArgumentCoder<WebCore::BasicShapeCenterCoordinate>::decode(Decoder& decoder)
{
    auto direction = decoder.decode<WebCore::BasicShapeCenterCoordinate::Direction>();
    auto length = decoder.decode<WebCore::Length>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::BasicShapeCenterCoordinate {
            WTFMove(*direction),
            WTFMove(*length)
        }
    };
}

void ArgumentCoder<WebCore::BasicShapeRadius>::encode(Encoder& encoder, const WebCore::BasicShapeRadius& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, WebCore::Length>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::BasicShapeRadius::Type>);
    encoder << instance.value();
    encoder << instance.type();
}

std::optional<WebCore::BasicShapeRadius> ArgumentCoder<WebCore::BasicShapeRadius>::decode(Decoder& decoder)
{
    auto value = decoder.decode<WebCore::Length>();
    auto type = decoder.decode<WebCore::BasicShapeRadius::Type>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::BasicShapeRadius {
            WTFMove(*value),
            WTFMove(*type)
        }
    };
}

void ArgumentCoder<WebCore::BasicShapeCircle>::encode(Encoder& encoder, const WebCore::BasicShapeCircle& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.centerX())>, WebCore::BasicShapeCenterCoordinate>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.centerY())>, WebCore::BasicShapeCenterCoordinate>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radius())>, WebCore::BasicShapeRadius>);
    encoder << instance.centerX();
    encoder << instance.centerY();
    encoder << instance.radius();
}

std::optional<Ref<WebCore::BasicShapeCircle>> ArgumentCoder<WebCore::BasicShapeCircle>::decode(Decoder& decoder)
{
    auto centerX = decoder.decode<WebCore::BasicShapeCenterCoordinate>();
    auto centerY = decoder.decode<WebCore::BasicShapeCenterCoordinate>();
    auto radius = decoder.decode<WebCore::BasicShapeRadius>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::BasicShapeCircle::create(
            WTFMove(*centerX),
            WTFMove(*centerY),
            WTFMove(*radius)
        )
    };
}

void ArgumentCoder<WebCore::BasicShapeEllipse>::encode(Encoder& encoder, const WebCore::BasicShapeEllipse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.centerX())>, WebCore::BasicShapeCenterCoordinate>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.centerY())>, WebCore::BasicShapeCenterCoordinate>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusX())>, WebCore::BasicShapeRadius>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusY())>, WebCore::BasicShapeRadius>);
    encoder << instance.centerX();
    encoder << instance.centerY();
    encoder << instance.radiusX();
    encoder << instance.radiusY();
}

std::optional<Ref<WebCore::BasicShapeEllipse>> ArgumentCoder<WebCore::BasicShapeEllipse>::decode(Decoder& decoder)
{
    auto centerX = decoder.decode<WebCore::BasicShapeCenterCoordinate>();
    auto centerY = decoder.decode<WebCore::BasicShapeCenterCoordinate>();
    auto radiusX = decoder.decode<WebCore::BasicShapeRadius>();
    auto radiusY = decoder.decode<WebCore::BasicShapeRadius>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::BasicShapeEllipse::create(
            WTFMove(*centerX),
            WTFMove(*centerY),
            WTFMove(*radiusX),
            WTFMove(*radiusY)
        )
    };
}

void ArgumentCoder<WebCore::BasicShapePolygon>::encode(Encoder& encoder, const WebCore::BasicShapePolygon& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.windRule())>, WebCore::WindRule>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.values())>, Vector<WebCore::Length>>);
    encoder << instance.windRule();
    encoder << instance.values();
}

std::optional<Ref<WebCore::BasicShapePolygon>> ArgumentCoder<WebCore::BasicShapePolygon>::decode(Decoder& decoder)
{
    auto windRule = decoder.decode<WebCore::WindRule>();
    auto values = decoder.decode<Vector<WebCore::Length>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::BasicShapePolygon::create(
            WTFMove(*windRule),
            WTFMove(*values)
        )
    };
}

void ArgumentCoder<WebCore::BasicShapePath>::encode(Encoder& encoder, const WebCore::BasicShapePath& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.byteStream())>, std::unique_ptr<WebCore::SVGPathByteStream>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.zoom())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.windRule())>, WebCore::WindRule>);
    encoder << instance.byteStream();
    encoder << instance.zoom();
    encoder << instance.windRule();
}

std::optional<Ref<WebCore::BasicShapePath>> ArgumentCoder<WebCore::BasicShapePath>::decode(Decoder& decoder)
{
    auto byteStream = decoder.decode<std::unique_ptr<WebCore::SVGPathByteStream>>();
    auto zoom = decoder.decode<float>();
    auto windRule = decoder.decode<WebCore::WindRule>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::BasicShapePath::create(
            WTFMove(*byteStream),
            WTFMove(*zoom),
            WTFMove(*windRule)
        )
    };
}

void ArgumentCoder<WebCore::BasicShapeInset>::encode(Encoder& encoder, const WebCore::BasicShapeInset& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.right())>, WebCore::Length>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.top())>, WebCore::Length>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bottom())>, WebCore::Length>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.left())>, WebCore::Length>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topLeftRadius())>, WebCore::LengthSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.topRightRadius())>, WebCore::LengthSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bottomRightRadius())>, WebCore::LengthSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bottomLeftRadius())>, WebCore::LengthSize>);
    encoder << instance.right();
    encoder << instance.top();
    encoder << instance.bottom();
    encoder << instance.left();
    encoder << instance.topLeftRadius();
    encoder << instance.topRightRadius();
    encoder << instance.bottomRightRadius();
    encoder << instance.bottomLeftRadius();
}

std::optional<Ref<WebCore::BasicShapeInset>> ArgumentCoder<WebCore::BasicShapeInset>::decode(Decoder& decoder)
{
    auto right = decoder.decode<WebCore::Length>();
    auto top = decoder.decode<WebCore::Length>();
    auto bottom = decoder.decode<WebCore::Length>();
    auto left = decoder.decode<WebCore::Length>();
    auto topLeftRadius = decoder.decode<WebCore::LengthSize>();
    auto topRightRadius = decoder.decode<WebCore::LengthSize>();
    auto bottomRightRadius = decoder.decode<WebCore::LengthSize>();
    auto bottomLeftRadius = decoder.decode<WebCore::LengthSize>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::BasicShapeInset::create(
            WTFMove(*right),
            WTFMove(*top),
            WTFMove(*bottom),
            WTFMove(*left),
            WTFMove(*topLeftRadius),
            WTFMove(*topRightRadius),
            WTFMove(*bottomRightRadius),
            WTFMove(*bottomLeftRadius)
        )
    };
}

enum class WebCore_BasicShape_Subclass : IPC::EncodedVariantIndex {
    BasicShapeCircle,
    BasicShapeEllipse,
    BasicShapePolygon,
    BasicShapePath,
    BasicShapeInset
};

void ArgumentCoder<WebCore::BasicShape>::encode(Encoder& encoder, const WebCore::BasicShape& instance)
{
    if (auto* subclass = dynamicDowncast<WebCore::BasicShapeCircle>(instance)) {
        encoder << WebCore_BasicShape_Subclass::BasicShapeCircle;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::BasicShapeEllipse>(instance)) {
        encoder << WebCore_BasicShape_Subclass::BasicShapeEllipse;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::BasicShapePolygon>(instance)) {
        encoder << WebCore_BasicShape_Subclass::BasicShapePolygon;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::BasicShapePath>(instance)) {
        encoder << WebCore_BasicShape_Subclass::BasicShapePath;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::BasicShapeInset>(instance)) {
        encoder << WebCore_BasicShape_Subclass::BasicShapeInset;
        encoder << *subclass;
        return;
    }
    ASSERT_NOT_REACHED();
}

std::optional<Ref<WebCore::BasicShape>> ArgumentCoder<WebCore::BasicShape>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore_BasicShape_Subclass>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (type == WebCore_BasicShape_Subclass::BasicShapeCircle) {
        auto result = decoder.decode<Ref<WebCore::BasicShapeCircle>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_BasicShape_Subclass::BasicShapeEllipse) {
        auto result = decoder.decode<Ref<WebCore::BasicShapeEllipse>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_BasicShape_Subclass::BasicShapePolygon) {
        auto result = decoder.decode<Ref<WebCore::BasicShapePolygon>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_BasicShape_Subclass::BasicShapePath) {
        auto result = decoder.decode<Ref<WebCore::BasicShapePath>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_BasicShape_Subclass::BasicShapeInset) {
        auto result = decoder.decode<Ref<WebCore::BasicShapeInset>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    ASSERT_NOT_REACHED();
    return std::nullopt;
}

void ArgumentCoder<WebCore::ReferencePathOperation>::encode(Encoder& encoder, const WebCore::ReferencePathOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, std::optional<WebCore::Path>>);
    encoder << instance.path();
}

std::optional<Ref<WebCore::ReferencePathOperation>> ArgumentCoder<WebCore::ReferencePathOperation>::decode(Decoder& decoder)
{
    auto path = decoder.decode<std::optional<WebCore::Path>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ReferencePathOperation::create(
            WTFMove(*path)
        )
    };
}

void ArgumentCoder<WebCore::ShapePathOperation>::encode(Encoder& encoder, const WebCore::ShapePathOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shape())>, Ref<WebCore::BasicShape>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referenceBox())>, WebCore::CSSBoxType>);
    encoder << instance.shape();
    encoder << instance.referenceBox();
}

std::optional<Ref<WebCore::ShapePathOperation>> ArgumentCoder<WebCore::ShapePathOperation>::decode(Decoder& decoder)
{
    auto shape = decoder.decode<Ref<WebCore::BasicShape>>();
    auto referenceBox = decoder.decode<WebCore::CSSBoxType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ShapePathOperation::create(
            WTFMove(*shape),
            WTFMove(*referenceBox)
        )
    };
}

void ArgumentCoder<WebCore::BoxPathOperation>::encode(Encoder& encoder, const WebCore::BoxPathOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.path())>, WebCore::Path>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referenceBox())>, WebCore::CSSBoxType>);
    encoder << instance.path();
    encoder << instance.referenceBox();
}

std::optional<Ref<WebCore::BoxPathOperation>> ArgumentCoder<WebCore::BoxPathOperation>::decode(Decoder& decoder)
{
    auto path = decoder.decode<WebCore::Path>();
    auto referenceBox = decoder.decode<WebCore::CSSBoxType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::BoxPathOperation::create(
            WTFMove(*path),
            WTFMove(*referenceBox)
        )
    };
}

void ArgumentCoder<WebCore::RayPathOperation>::encode(Encoder& encoder, const WebCore::RayPathOperation& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.angle())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.size())>, WebCore::RayPathOperation::Size>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isContaining())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.containingBlockBoundingRect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.position())>, WebCore::FloatPoint>);
    encoder << instance.angle();
    encoder << instance.size();
    encoder << instance.isContaining();
    encoder << instance.containingBlockBoundingRect();
    encoder << instance.position();
}

std::optional<Ref<WebCore::RayPathOperation>> ArgumentCoder<WebCore::RayPathOperation>::decode(Decoder& decoder)
{
    auto angle = decoder.decode<float>();
    auto size = decoder.decode<WebCore::RayPathOperation::Size>();
    auto isContaining = decoder.decode<bool>();
    auto containingBlockBoundingRect = decoder.decode<WebCore::FloatRect>();
    auto position = decoder.decode<WebCore::FloatPoint>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::RayPathOperation::create(
            WTFMove(*angle),
            WTFMove(*size),
            WTFMove(*isContaining),
            WTFMove(*containingBlockBoundingRect),
            WTFMove(*position)
        )
    };
}

enum class WebCore_PathOperation_Subclass : IPC::EncodedVariantIndex {
    ReferencePathOperation,
    ShapePathOperation,
    BoxPathOperation,
    RayPathOperation
};

void ArgumentCoder<WebCore::PathOperation>::encode(Encoder& encoder, const WebCore::PathOperation& instance)
{
    if (auto* subclass = dynamicDowncast<WebCore::ReferencePathOperation>(instance)) {
        encoder << WebCore_PathOperation_Subclass::ReferencePathOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::ShapePathOperation>(instance)) {
        encoder << WebCore_PathOperation_Subclass::ShapePathOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::BoxPathOperation>(instance)) {
        encoder << WebCore_PathOperation_Subclass::BoxPathOperation;
        encoder << *subclass;
        return;
    }
    if (auto* subclass = dynamicDowncast<WebCore::RayPathOperation>(instance)) {
        encoder << WebCore_PathOperation_Subclass::RayPathOperation;
        encoder << *subclass;
        return;
    }
    ASSERT_NOT_REACHED();
}

std::optional<Ref<WebCore::PathOperation>> ArgumentCoder<WebCore::PathOperation>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore_PathOperation_Subclass>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (type == WebCore_PathOperation_Subclass::ReferencePathOperation) {
        auto result = decoder.decode<Ref<WebCore::ReferencePathOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_PathOperation_Subclass::ShapePathOperation) {
        auto result = decoder.decode<Ref<WebCore::ShapePathOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_PathOperation_Subclass::BoxPathOperation) {
        auto result = decoder.decode<Ref<WebCore::BoxPathOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    if (type == WebCore_PathOperation_Subclass::RayPathOperation) {
        auto result = decoder.decode<Ref<WebCore::RayPathOperation>>();
        if (UNLIKELY(!decoder.isValid()))
            return std::nullopt;
        return WTFMove(*result);
    }
    ASSERT_NOT_REACHED();
    return std::nullopt;
}

#if ENABLE(ENCRYPTED_MEDIA)
void ArgumentCoder<WebCore::CDMKeySystemConfiguration>::encode(Encoder& encoder, const WebCore::CDMKeySystemConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.label)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.initDataTypes)>, Vector<AtomString>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.audioCapabilities)>, Vector<WebCore::CDMMediaCapability>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.videoCapabilities)>, Vector<WebCore::CDMMediaCapability>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.distinctiveIdentifier)>, WebCore::CDMRequirement>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.persistentState)>, WebCore::CDMRequirement>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sessionTypes)>, Vector<WebCore::CDMSessionType>>);
    struct ShouldBeSameSizeAsCDMKeySystemConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CDMKeySystemConfiguration>, false> {
        String label;
        Vector<AtomString> initDataTypes;
        Vector<WebCore::CDMMediaCapability> audioCapabilities;
        Vector<WebCore::CDMMediaCapability> videoCapabilities;
        WebCore::CDMRequirement distinctiveIdentifier;
        WebCore::CDMRequirement persistentState;
        Vector<WebCore::CDMSessionType> sessionTypes;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCDMKeySystemConfiguration) == sizeof(WebCore::CDMKeySystemConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CDMKeySystemConfiguration, label)
        , offsetof(WebCore::CDMKeySystemConfiguration, initDataTypes)
        , offsetof(WebCore::CDMKeySystemConfiguration, audioCapabilities)
        , offsetof(WebCore::CDMKeySystemConfiguration, videoCapabilities)
        , offsetof(WebCore::CDMKeySystemConfiguration, distinctiveIdentifier)
        , offsetof(WebCore::CDMKeySystemConfiguration, persistentState)
        , offsetof(WebCore::CDMKeySystemConfiguration, sessionTypes)
    >::value);
    encoder << instance.label;
    encoder << instance.initDataTypes;
    encoder << instance.audioCapabilities;
    encoder << instance.videoCapabilities;
    encoder << instance.distinctiveIdentifier;
    encoder << instance.persistentState;
    encoder << instance.sessionTypes;
}

std::optional<WebCore::CDMKeySystemConfiguration> ArgumentCoder<WebCore::CDMKeySystemConfiguration>::decode(Decoder& decoder)
{
    auto label = decoder.decode<String>();
    auto initDataTypes = decoder.decode<Vector<AtomString>>();
    auto audioCapabilities = decoder.decode<Vector<WebCore::CDMMediaCapability>>();
    auto videoCapabilities = decoder.decode<Vector<WebCore::CDMMediaCapability>>();
    auto distinctiveIdentifier = decoder.decode<WebCore::CDMRequirement>();
    auto persistentState = decoder.decode<WebCore::CDMRequirement>();
    auto sessionTypes = decoder.decode<Vector<WebCore::CDMSessionType>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CDMKeySystemConfiguration {
            WTFMove(*label),
            WTFMove(*initDataTypes),
            WTFMove(*audioCapabilities),
            WTFMove(*videoCapabilities),
            WTFMove(*distinctiveIdentifier),
            WTFMove(*persistentState),
            WTFMove(*sessionTypes)
        }
    };
}

#endif

void ArgumentCoder<WebCore::MediaConfiguration>::encode(Encoder& encoder, const WebCore::MediaConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.video)>, std::optional<WebCore::VideoConfiguration>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.audio)>, std::optional<WebCore::AudioConfiguration>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaContainerTypes)>, std::optional<Vector<String>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaCodecTypes)>, std::optional<Vector<String>>>);
    struct ShouldBeSameSizeAsMediaConfiguration : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MediaConfiguration>, false> {
        std::optional<WebCore::VideoConfiguration> video;
        std::optional<WebCore::AudioConfiguration> audio;
        std::optional<Vector<String>> allowedMediaContainerTypes;
        std::optional<Vector<String>> allowedMediaCodecTypes;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaConfiguration) == sizeof(WebCore::MediaConfiguration));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaConfiguration, video)
        , offsetof(WebCore::MediaConfiguration, audio)
        , offsetof(WebCore::MediaConfiguration, allowedMediaContainerTypes)
        , offsetof(WebCore::MediaConfiguration, allowedMediaCodecTypes)
    >::value);
    encoder << instance.video;
    encoder << instance.audio;
    encoder << instance.allowedMediaContainerTypes;
    encoder << instance.allowedMediaCodecTypes;
}

std::optional<WebCore::MediaConfiguration> ArgumentCoder<WebCore::MediaConfiguration>::decode(Decoder& decoder)
{
    auto video = decoder.decode<std::optional<WebCore::VideoConfiguration>>();
    auto audio = decoder.decode<std::optional<WebCore::AudioConfiguration>>();
    auto allowedMediaContainerTypes = decoder.decode<std::optional<Vector<String>>>();
    auto allowedMediaCodecTypes = decoder.decode<std::optional<Vector<String>>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaConfiguration {
            WTFMove(*video),
            WTFMove(*audio),
            WTFMove(*allowedMediaContainerTypes),
            WTFMove(*allowedMediaCodecTypes)
        }
    };
}

void ArgumentCoder<WebCore::MediaEncodingConfiguration>::encode(Encoder& encoder, const WebCore::MediaEncodingConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.video)>, std::optional<WebCore::VideoConfiguration>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.audio)>, std::optional<WebCore::AudioConfiguration>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaContainerTypes)>, std::optional<Vector<String>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaCodecTypes)>, std::optional<Vector<String>>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaConfiguration, video)
        , offsetof(WebCore::MediaConfiguration, audio)
        , offsetof(WebCore::MediaConfiguration, allowedMediaContainerTypes)
        , offsetof(WebCore::MediaConfiguration, allowedMediaCodecTypes)
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::MediaEncodingType>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaEncodingConfiguration, type)
    >::value);
    encoder << instance.video;
    encoder << instance.audio;
    encoder << instance.allowedMediaContainerTypes;
    encoder << instance.allowedMediaCodecTypes;
    encoder << instance.type;
}

std::optional<WebCore::MediaEncodingConfiguration> ArgumentCoder<WebCore::MediaEncodingConfiguration>::decode(Decoder& decoder)
{
    auto video = decoder.decode<std::optional<WebCore::VideoConfiguration>>();
    auto audio = decoder.decode<std::optional<WebCore::AudioConfiguration>>();
    auto allowedMediaContainerTypes = decoder.decode<std::optional<Vector<String>>>();
    auto allowedMediaCodecTypes = decoder.decode<std::optional<Vector<String>>>();
    auto type = decoder.decode<WebCore::MediaEncodingType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaEncodingConfiguration {
            WebCore::MediaConfiguration {
                WTFMove(*video),
                WTFMove(*audio),
                WTFMove(*allowedMediaContainerTypes),
                WTFMove(*allowedMediaCodecTypes)
            },
            WTFMove(*type)
        }
    };
}

void ArgumentCoder<WebCore::MediaDecodingConfiguration>::encode(Encoder& encoder, const WebCore::MediaDecodingConfiguration& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.video)>, std::optional<WebCore::VideoConfiguration>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.audio)>, std::optional<WebCore::AudioConfiguration>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaContainerTypes)>, std::optional<Vector<String>>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.allowedMediaCodecTypes)>, std::optional<Vector<String>>>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaConfiguration, video)
        , offsetof(WebCore::MediaConfiguration, audio)
        , offsetof(WebCore::MediaConfiguration, allowedMediaContainerTypes)
        , offsetof(WebCore::MediaConfiguration, allowedMediaCodecTypes)
    >::value);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::MediaDecodingType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.canExposeVP9)>, bool>);
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaDecodingConfiguration, type)
        , offsetof(WebCore::MediaDecodingConfiguration, canExposeVP9)
    >::value);
    encoder << instance.video;
    encoder << instance.audio;
    encoder << instance.allowedMediaContainerTypes;
    encoder << instance.allowedMediaCodecTypes;
    encoder << instance.type;
    encoder << instance.canExposeVP9;
}

std::optional<WebCore::MediaDecodingConfiguration> ArgumentCoder<WebCore::MediaDecodingConfiguration>::decode(Decoder& decoder)
{
    auto video = decoder.decode<std::optional<WebCore::VideoConfiguration>>();
    auto audio = decoder.decode<std::optional<WebCore::AudioConfiguration>>();
    auto allowedMediaContainerTypes = decoder.decode<std::optional<Vector<String>>>();
    auto allowedMediaCodecTypes = decoder.decode<std::optional<Vector<String>>>();
    auto type = decoder.decode<WebCore::MediaDecodingType>();
    auto canExposeVP9 = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaDecodingConfiguration {
            WebCore::MediaConfiguration {
                WTFMove(*video),
                WTFMove(*audio),
                WTFMove(*allowedMediaContainerTypes),
                WTFMove(*allowedMediaCodecTypes)
            },
            WTFMove(*type),
            WTFMove(*canExposeVP9)
        }
    };
}

void ArgumentCoder<WebCore::ResourceResponseBase::ResponseData>::encode(Encoder& encoder, const WebCore::ResourceResponseBase::ResponseData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_url)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_mimeType)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_expectedContentLength)>, long long>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_textEncodingName)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_httpStatusText)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_httpVersion)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_httpHeaderFields)>, WebCore::HTTPHeaderMap>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_networkLoadMetrics)>, Box<WebCore::NetworkLoadMetrics>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_httpStatusCode)>, short>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_certificateInfo)>, std::optional<WebCore::CertificateInfo>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_source)>, WebCore::ResourceResponseBase::Source>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_type)>, WebCore::ResourceResponseBase::Type>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_tainting)>, WebCore::ResourceResponseBase::Tainting>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isRedirected)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_usedLegacyTLS)>, WebCore::UsedLegacyTLS>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_wasPrivateRelayed)>, WebCore::WasPrivateRelayed>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isRangeRequested)>, bool>);
    struct ShouldBeSameSizeAsResponseData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ResourceResponseBase::ResponseData>, false> {
        URL m_url;
        AtomString m_mimeType;
        long long m_expectedContentLength;
        AtomString m_textEncodingName;
        AtomString m_httpStatusText;
        AtomString m_httpVersion;
        WebCore::HTTPHeaderMap m_httpHeaderFields;
        Box<WebCore::NetworkLoadMetrics> m_networkLoadMetrics;
        short m_httpStatusCode;
        std::optional<WebCore::CertificateInfo> m_certificateInfo;
        WebCore::ResourceResponseBase::Source m_source;
        WebCore::ResourceResponseBase::Type m_type;
        WebCore::ResourceResponseBase::Tainting m_tainting;
        bool m_isRedirected;
        WebCore::UsedLegacyTLS m_usedLegacyTLS;
        WebCore::WasPrivateRelayed m_wasPrivateRelayed;
        bool m_isRangeRequested;
    };
    static_assert(sizeof(ShouldBeSameSizeAsResponseData) == sizeof(WebCore::ResourceResponseBase::ResponseData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_url)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_mimeType)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_expectedContentLength)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_textEncodingName)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_httpStatusText)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_httpVersion)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_httpHeaderFields)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_networkLoadMetrics)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_httpStatusCode)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_certificateInfo)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_source)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_type)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_tainting)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_isRedirected)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_usedLegacyTLS)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_wasPrivateRelayed)
        , offsetof(WebCore::ResourceResponseBase::ResponseData, m_isRangeRequested)
    >::value);
    encoder << instance.m_url;
    encoder << instance.m_mimeType;
    encoder << instance.m_expectedContentLength;
    encoder << instance.m_textEncodingName;
    encoder << instance.m_httpStatusText;
    encoder << instance.m_httpVersion;
    encoder << instance.m_httpHeaderFields;
    encoder << instance.m_networkLoadMetrics;
    encoder << instance.m_httpStatusCode;
    encoder << instance.m_certificateInfo;
    encoder << instance.m_source;
    encoder << instance.m_type;
    encoder << instance.m_tainting;
    encoder << instance.m_isRedirected;
    encoder << instance.m_usedLegacyTLS;
    encoder << instance.m_wasPrivateRelayed;
    encoder << instance.m_isRangeRequested;
}

std::optional<WebCore::ResourceResponseBase::ResponseData> ArgumentCoder<WebCore::ResourceResponseBase::ResponseData>::decode(Decoder& decoder)
{
    auto m_url = decoder.decode<URL>();
    auto m_mimeType = decoder.decode<AtomString>();
    auto m_expectedContentLength = decoder.decode<long long>();
    auto m_textEncodingName = decoder.decode<AtomString>();
    auto m_httpStatusText = decoder.decode<AtomString>();
    auto m_httpVersion = decoder.decode<AtomString>();
    auto m_httpHeaderFields = decoder.decode<WebCore::HTTPHeaderMap>();
    auto m_networkLoadMetrics = decoder.decode<Box<WebCore::NetworkLoadMetrics>>();
    auto m_httpStatusCode = decoder.decode<short>();
    auto m_certificateInfo = decoder.decode<std::optional<WebCore::CertificateInfo>>();
    auto m_source = decoder.decode<WebCore::ResourceResponseBase::Source>();
    auto m_type = decoder.decode<WebCore::ResourceResponseBase::Type>();
    auto m_tainting = decoder.decode<WebCore::ResourceResponseBase::Tainting>();
    auto m_isRedirected = decoder.decode<bool>();
    auto m_usedLegacyTLS = decoder.decode<WebCore::UsedLegacyTLS>();
    auto m_wasPrivateRelayed = decoder.decode<WebCore::WasPrivateRelayed>();
    auto m_isRangeRequested = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ResourceResponseBase::ResponseData {
            WTFMove(*m_url),
            WTFMove(*m_mimeType),
            WTFMove(*m_expectedContentLength),
            WTFMove(*m_textEncodingName),
            WTFMove(*m_httpStatusText),
            WTFMove(*m_httpVersion),
            WTFMove(*m_httpHeaderFields),
            WTFMove(*m_networkLoadMetrics),
            WTFMove(*m_httpStatusCode),
            WTFMove(*m_certificateInfo),
            WTFMove(*m_source),
            WTFMove(*m_type),
            WTFMove(*m_tainting),
            WTFMove(*m_isRedirected),
            WTFMove(*m_usedLegacyTLS),
            WTFMove(*m_wasPrivateRelayed),
            WTFMove(*m_isRangeRequested)
        }
    };
}

void ArgumentCoder<WebCore::ResourceResponseBase>::encode(Encoder& encoder, const WebCore::ResourceResponseBase& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.getResponseData())>, std::optional<WebCore::ResourceResponseBase::ResponseData>>);
    encoder << instance.getResponseData();
}

std::optional<WebCore::ResourceResponseBase> ArgumentCoder<WebCore::ResourceResponseBase>::decode(Decoder& decoder)
{
    auto getResponseData = decoder.decode<std::optional<WebCore::ResourceResponseBase::ResponseData>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ResourceResponseBase {
            WTFMove(*getResponseData)
        }
    };
}

void ArgumentCoder<WebCore::ResourceResponse>::encode(Encoder& encoder, const WebCore::ResourceResponse& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.getResponseData())>, std::optional<WebCore::ResourceResponseBase::ResponseData>>);
    static_assert(MembersInCorrectOrder < 0
    >::value);
    encoder << instance.getResponseData();
}

std::optional<WebCore::ResourceResponse> ArgumentCoder<WebCore::ResourceResponse>::decode(Decoder& decoder)
{
    auto getResponseData = decoder.decode<std::optional<WebCore::ResourceResponseBase::ResponseData>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ResourceResponse {
            WebCore::ResourceResponseBase {
                WTFMove(*getResponseData)
            }
        }
    };
}

void ArgumentCoder<WebCore::ResourceResponseBase::CrossThreadData>::encode(Encoder& encoder, const WebCore::ResourceResponseBase::CrossThreadData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mimeType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.expectedContentLength)>, long long>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textEncodingName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpStatusCode)>, short>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpStatusText)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpVersion)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.httpHeaderFields)>, WebCore::HTTPHeaderMap>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.networkLoadMetrics)>, std::optional<WebCore::NetworkLoadMetrics>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.source)>, WebCore::ResourceResponseBase::Source>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ResourceResponseBase::Type>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tainting)>, WebCore::ResourceResponseBase::Tainting>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isRedirected)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.usedLegacyTLS)>, WebCore::UsedLegacyTLS>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.wasPrivateRelayed)>, WebCore::WasPrivateRelayed>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isRangeRequested)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.certificateInfo)>, std::optional<WebCore::CertificateInfo>>);
    struct ShouldBeSameSizeAsCrossThreadData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ResourceResponseBase::CrossThreadData>, false> {
        URL url;
        String mimeType;
        long long expectedContentLength;
        String textEncodingName;
        short httpStatusCode;
        String httpStatusText;
        String httpVersion;
        WebCore::HTTPHeaderMap httpHeaderFields;
        std::optional<WebCore::NetworkLoadMetrics> networkLoadMetrics;
        WebCore::ResourceResponseBase::Source source;
        WebCore::ResourceResponseBase::Type type;
        WebCore::ResourceResponseBase::Tainting tainting;
        bool isRedirected;
        WebCore::UsedLegacyTLS usedLegacyTLS;
        WebCore::WasPrivateRelayed wasPrivateRelayed;
        bool isRangeRequested;
        std::optional<WebCore::CertificateInfo> certificateInfo;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCrossThreadData) == sizeof(WebCore::ResourceResponseBase::CrossThreadData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, url)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, mimeType)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, expectedContentLength)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, textEncodingName)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, httpStatusCode)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, httpStatusText)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, httpVersion)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, httpHeaderFields)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, networkLoadMetrics)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, source)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, type)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, tainting)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, isRedirected)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, usedLegacyTLS)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, wasPrivateRelayed)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, isRangeRequested)
        , offsetof(WebCore::ResourceResponseBase::CrossThreadData, certificateInfo)
    >::value);
    encoder << instance.url;
    encoder << instance.mimeType;
    encoder << instance.expectedContentLength;
    encoder << instance.textEncodingName;
    encoder << instance.httpStatusCode;
    encoder << instance.httpStatusText;
    encoder << instance.httpVersion;
    encoder << instance.httpHeaderFields;
    encoder << instance.networkLoadMetrics;
    encoder << instance.source;
    encoder << instance.type;
    encoder << instance.tainting;
    encoder << instance.isRedirected;
    encoder << instance.usedLegacyTLS;
    encoder << instance.wasPrivateRelayed;
    encoder << instance.isRangeRequested;
    encoder << instance.certificateInfo;
}

std::optional<WebCore::ResourceResponseBase::CrossThreadData> ArgumentCoder<WebCore::ResourceResponseBase::CrossThreadData>::decode(Decoder& decoder)
{
    auto url = decoder.decode<URL>();
    auto mimeType = decoder.decode<String>();
    auto expectedContentLength = decoder.decode<long long>();
    auto textEncodingName = decoder.decode<String>();
    auto httpStatusCode = decoder.decode<short>();
    auto httpStatusText = decoder.decode<String>();
    auto httpVersion = decoder.decode<String>();
    auto httpHeaderFields = decoder.decode<WebCore::HTTPHeaderMap>();
    auto networkLoadMetrics = decoder.decode<std::optional<WebCore::NetworkLoadMetrics>>();
    auto source = decoder.decode<WebCore::ResourceResponseBase::Source>();
    auto type = decoder.decode<WebCore::ResourceResponseBase::Type>();
    auto tainting = decoder.decode<WebCore::ResourceResponseBase::Tainting>();
    auto isRedirected = decoder.decode<bool>();
    auto usedLegacyTLS = decoder.decode<WebCore::UsedLegacyTLS>();
    auto wasPrivateRelayed = decoder.decode<WebCore::WasPrivateRelayed>();
    auto isRangeRequested = decoder.decode<bool>();
    auto certificateInfo = decoder.decode<std::optional<WebCore::CertificateInfo>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ResourceResponseBase::CrossThreadData {
            WTFMove(*url),
            WTFMove(*mimeType),
            WTFMove(*expectedContentLength),
            WTFMove(*textEncodingName),
            WTFMove(*httpStatusCode),
            WTFMove(*httpStatusText),
            WTFMove(*httpVersion),
            WTFMove(*httpHeaderFields),
            WTFMove(*networkLoadMetrics),
            WTFMove(*source),
            WTFMove(*type),
            WTFMove(*tainting),
            WTFMove(*isRedirected),
            WTFMove(*usedLegacyTLS),
            WTFMove(*wasPrivateRelayed),
            WTFMove(*isRangeRequested),
            WTFMove(*certificateInfo)
        }
    };
}

void ArgumentCoder<WebCore::FetchOptions>::encode(Encoder& encoder, const WebCore::FetchOptions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.destination)>, WebCore::FetchOptionsDestination>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mode)>, WebCore::FetchOptionsMode>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.credentials)>, WebCore::FetchOptionsCredentials>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.cache)>, WebCore::FetchOptionsCache>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.redirect)>, WebCore::FetchOptionsRedirect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.referrerPolicy)>, WebCore::ReferrerPolicy>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.keepAlive)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.integrity)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clientIdentifier)>, Markable<WTF::UUID>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.resultingClientIdentifier)>, Markable<WTF::UUID>>);
    struct ShouldBeSameSizeAsFetchOptions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FetchOptions>, false> {
        WebCore::FetchOptionsDestination destination;
        WebCore::FetchOptionsMode mode;
        WebCore::FetchOptionsCredentials credentials;
        WebCore::FetchOptionsCache cache;
        WebCore::FetchOptionsRedirect redirect;
        WebCore::ReferrerPolicy referrerPolicy;
        bool keepAlive;
        String integrity;
        Markable<WTF::UUID> clientIdentifier;
        Markable<WTF::UUID> resultingClientIdentifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFetchOptions) == sizeof(WebCore::FetchOptions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FetchOptions, destination)
        , offsetof(WebCore::FetchOptions, mode)
        , offsetof(WebCore::FetchOptions, credentials)
        , offsetof(WebCore::FetchOptions, cache)
        , offsetof(WebCore::FetchOptions, redirect)
        , offsetof(WebCore::FetchOptions, referrerPolicy)
        , offsetof(WebCore::FetchOptions, keepAlive)
        , offsetof(WebCore::FetchOptions, integrity)
        , offsetof(WebCore::FetchOptions, clientIdentifier)
        , offsetof(WebCore::FetchOptions, resultingClientIdentifier)
    >::value);
    encoder << instance.destination;
    encoder << instance.mode;
    encoder << instance.credentials;
    encoder << instance.cache;
    encoder << instance.redirect;
    encoder << instance.referrerPolicy;
    encoder << instance.keepAlive;
    encoder << instance.integrity;
    encoder << instance.clientIdentifier;
    encoder << instance.resultingClientIdentifier;
}

std::optional<WebCore::FetchOptions> ArgumentCoder<WebCore::FetchOptions>::decode(Decoder& decoder)
{
    auto destination = decoder.decode<WebCore::FetchOptionsDestination>();
    auto mode = decoder.decode<WebCore::FetchOptionsMode>();
    auto credentials = decoder.decode<WebCore::FetchOptionsCredentials>();
    auto cache = decoder.decode<WebCore::FetchOptionsCache>();
    auto redirect = decoder.decode<WebCore::FetchOptionsRedirect>();
    auto referrerPolicy = decoder.decode<WebCore::ReferrerPolicy>();
    auto keepAlive = decoder.decode<bool>();
    auto integrity = decoder.decode<String>();
    auto clientIdentifier = decoder.decode<Markable<WTF::UUID>>();
    auto resultingClientIdentifier = decoder.decode<Markable<WTF::UUID>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FetchOptions {
            WTFMove(*destination),
            WTFMove(*mode),
            WTFMove(*credentials),
            WTFMove(*cache),
            WTFMove(*redirect),
            WTFMove(*referrerPolicy),
            WTFMove(*keepAlive),
            WTFMove(*integrity),
            WTFMove(*clientIdentifier),
            WTFMove(*resultingClientIdentifier)
        }
    };
}

void ArgumentCoder<WebCore::ControlStyle>::encode(Encoder& encoder, const WebCore::ControlStyle& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.states)>, OptionSet<WebCore::ControlStyle::State>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontSize)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.zoomFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.accentColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.borderWidth)>, WebCore::FloatBoxExtent>);
    struct ShouldBeSameSizeAsControlStyle : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ControlStyle>, false> {
        OptionSet<WebCore::ControlStyle::State> states;
        float fontSize;
        float zoomFactor;
        WebCore::Color accentColor;
        WebCore::Color textColor;
        WebCore::FloatBoxExtent borderWidth;
    };
    static_assert(sizeof(ShouldBeSameSizeAsControlStyle) == sizeof(WebCore::ControlStyle));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ControlStyle, states)
        , offsetof(WebCore::ControlStyle, fontSize)
        , offsetof(WebCore::ControlStyle, zoomFactor)
        , offsetof(WebCore::ControlStyle, accentColor)
        , offsetof(WebCore::ControlStyle, textColor)
        , offsetof(WebCore::ControlStyle, borderWidth)
    >::value);
    encoder << instance.states;
    encoder << instance.fontSize;
    encoder << instance.zoomFactor;
    encoder << instance.accentColor;
    encoder << instance.textColor;
    encoder << instance.borderWidth;
}

void ArgumentCoder<WebCore::ControlStyle>::encode(StreamConnectionEncoder& encoder, const WebCore::ControlStyle& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.states)>, OptionSet<WebCore::ControlStyle::State>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontSize)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.zoomFactor)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.accentColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.borderWidth)>, WebCore::FloatBoxExtent>);
    struct ShouldBeSameSizeAsControlStyle : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ControlStyle>, false> {
        OptionSet<WebCore::ControlStyle::State> states;
        float fontSize;
        float zoomFactor;
        WebCore::Color accentColor;
        WebCore::Color textColor;
        WebCore::FloatBoxExtent borderWidth;
    };
    static_assert(sizeof(ShouldBeSameSizeAsControlStyle) == sizeof(WebCore::ControlStyle));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ControlStyle, states)
        , offsetof(WebCore::ControlStyle, fontSize)
        , offsetof(WebCore::ControlStyle, zoomFactor)
        , offsetof(WebCore::ControlStyle, accentColor)
        , offsetof(WebCore::ControlStyle, textColor)
        , offsetof(WebCore::ControlStyle, borderWidth)
    >::value);
    encoder << instance.states;
    encoder << instance.fontSize;
    encoder << instance.zoomFactor;
    encoder << instance.accentColor;
    encoder << instance.textColor;
    encoder << instance.borderWidth;
}

std::optional<WebCore::ControlStyle> ArgumentCoder<WebCore::ControlStyle>::decode(Decoder& decoder)
{
    auto states = decoder.decode<OptionSet<WebCore::ControlStyle::State>>();
    auto fontSize = decoder.decode<float>();
    auto zoomFactor = decoder.decode<float>();
    auto accentColor = decoder.decode<WebCore::Color>();
    auto textColor = decoder.decode<WebCore::Color>();
    auto borderWidth = decoder.decode<WebCore::FloatBoxExtent>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ControlStyle {
            WTFMove(*states),
            WTFMove(*fontSize),
            WTFMove(*zoomFactor),
            WTFMove(*accentColor),
            WTFMove(*textColor),
            WTFMove(*borderWidth)
        }
    };
}

#if ENABLE(APPLE_PAY)
void ArgumentCoder<WebCore::ApplePayButtonPart>::encode(Encoder& encoder, const WebCore::ApplePayButtonPart& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.buttonType())>, WebCore::ApplePayButtonType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.buttonStyle())>, WebCore::ApplePayButtonStyle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.locale())>, String>);
    encoder << instance.buttonType();
    encoder << instance.buttonStyle();
    encoder << instance.locale();
}

void ArgumentCoder<WebCore::ApplePayButtonPart>::encode(StreamConnectionEncoder& encoder, const WebCore::ApplePayButtonPart& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.buttonType())>, WebCore::ApplePayButtonType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.buttonStyle())>, WebCore::ApplePayButtonStyle>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.locale())>, String>);
    encoder << instance.buttonType();
    encoder << instance.buttonStyle();
    encoder << instance.locale();
}

std::optional<Ref<WebCore::ApplePayButtonPart>> ArgumentCoder<WebCore::ApplePayButtonPart>::decode(Decoder& decoder)
{
    auto buttonType = decoder.decode<WebCore::ApplePayButtonType>();
    auto buttonStyle = decoder.decode<WebCore::ApplePayButtonStyle>();
    auto locale = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ApplePayButtonPart::create(
            WTFMove(*buttonType),
            WTFMove(*buttonStyle),
            WTFMove(*locale)
        )
    };
}

#endif

void ArgumentCoder<WebCore::MeterPart>::encode(Encoder& encoder, const WebCore::MeterPart& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gaugeRegion())>, WebCore::MeterPart::GaugeRegion>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.minimum())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximum())>, double>);
    encoder << instance.gaugeRegion();
    encoder << instance.value();
    encoder << instance.minimum();
    encoder << instance.maximum();
}

void ArgumentCoder<WebCore::MeterPart>::encode(StreamConnectionEncoder& encoder, const WebCore::MeterPart& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.gaugeRegion())>, WebCore::MeterPart::GaugeRegion>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.minimum())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.maximum())>, double>);
    encoder << instance.gaugeRegion();
    encoder << instance.value();
    encoder << instance.minimum();
    encoder << instance.maximum();
}

std::optional<Ref<WebCore::MeterPart>> ArgumentCoder<WebCore::MeterPart>::decode(Decoder& decoder)
{
    auto gaugeRegion = decoder.decode<WebCore::MeterPart::GaugeRegion>();
    auto value = decoder.decode<double>();
    auto minimum = decoder.decode<double>();
    auto maximum = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MeterPart::create(
            WTFMove(*gaugeRegion),
            WTFMove(*value),
            WTFMove(*minimum),
            WTFMove(*maximum)
        )
    };
}

void ArgumentCoder<WebCore::ProgressBarPart>::encode(Encoder& encoder, const WebCore::ProgressBarPart& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.position())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.animationStartTime())>, Seconds>);
    encoder << instance.position();
    encoder << instance.animationStartTime();
}

void ArgumentCoder<WebCore::ProgressBarPart>::encode(StreamConnectionEncoder& encoder, const WebCore::ProgressBarPart& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.position())>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.animationStartTime())>, Seconds>);
    encoder << instance.position();
    encoder << instance.animationStartTime();
}

std::optional<Ref<WebCore::ProgressBarPart>> ArgumentCoder<WebCore::ProgressBarPart>::decode(Decoder& decoder)
{
    auto position = decoder.decode<double>();
    auto animationStartTime = decoder.decode<Seconds>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ProgressBarPart::create(
            WTFMove(*position),
            WTFMove(*animationStartTime)
        )
    };
}

void ArgumentCoder<WebCore::SliderTrackPart>::encode(Encoder& encoder, const WebCore::SliderTrackPart& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::StyleAppearance>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.thumbSize())>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackBounds())>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tickRatios())>, Vector<double>>);
    encoder << instance.type();
    encoder << instance.thumbSize();
    encoder << instance.trackBounds();
    encoder << instance.tickRatios();
}

void ArgumentCoder<WebCore::SliderTrackPart>::encode(StreamConnectionEncoder& encoder, const WebCore::SliderTrackPart& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::StyleAppearance>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.thumbSize())>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.trackBounds())>, WebCore::IntRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tickRatios())>, Vector<double>>);
    encoder << instance.type();
    encoder << instance.thumbSize();
    encoder << instance.trackBounds();
    encoder << instance.tickRatios();
}

std::optional<Ref<WebCore::SliderTrackPart>> ArgumentCoder<WebCore::SliderTrackPart>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::StyleAppearance>();
    auto thumbSize = decoder.decode<WebCore::IntSize>();
    auto trackBounds = decoder.decode<WebCore::IntRect>();
    auto tickRatios = decoder.decode<Vector<double>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SliderTrackPart::create(
            WTFMove(*type),
            WTFMove(*thumbSize),
            WTFMove(*trackBounds),
            WTFMove(*tickRatios)
        )
    };
}

void ArgumentCoder<WebCore::DistantLightSource>::encode(Encoder& encoder, const WebCore::DistantLightSource& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.azimuth())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elevation())>, float>);
    encoder << instance.azimuth();
    encoder << instance.elevation();
}

void ArgumentCoder<WebCore::DistantLightSource>::encode(StreamConnectionEncoder& encoder, const WebCore::DistantLightSource& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.azimuth())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.elevation())>, float>);
    encoder << instance.azimuth();
    encoder << instance.elevation();
}

std::optional<Ref<WebCore::DistantLightSource>> ArgumentCoder<WebCore::DistantLightSource>::decode(Decoder& decoder)
{
    auto azimuth = decoder.decode<float>();
    auto elevation = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::DistantLightSource::create(
            WTFMove(*azimuth),
            WTFMove(*elevation)
        )
    };
}

void ArgumentCoder<WebCore::PointLightSource>::encode(Encoder& encoder, const WebCore::PointLightSource& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.position())>, WebCore::FloatPoint3D>);
    encoder << instance.position();
}

void ArgumentCoder<WebCore::PointLightSource>::encode(StreamConnectionEncoder& encoder, const WebCore::PointLightSource& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.position())>, WebCore::FloatPoint3D>);
    encoder << instance.position();
}

std::optional<Ref<WebCore::PointLightSource>> ArgumentCoder<WebCore::PointLightSource>::decode(Decoder& decoder)
{
    auto position = decoder.decode<WebCore::FloatPoint3D>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::PointLightSource::create(
            WTFMove(*position)
        )
    };
}

void ArgumentCoder<WebCore::SpotLightSource>::encode(Encoder& encoder, const WebCore::SpotLightSource& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.position())>, WebCore::FloatPoint3D>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction())>, WebCore::FloatPoint3D>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.specularExponent())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.limitingConeAngle())>, float>);
    encoder << instance.position();
    encoder << instance.direction();
    encoder << instance.specularExponent();
    encoder << instance.limitingConeAngle();
}

void ArgumentCoder<WebCore::SpotLightSource>::encode(StreamConnectionEncoder& encoder, const WebCore::SpotLightSource& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.position())>, WebCore::FloatPoint3D>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.direction())>, WebCore::FloatPoint3D>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.specularExponent())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.limitingConeAngle())>, float>);
    encoder << instance.position();
    encoder << instance.direction();
    encoder << instance.specularExponent();
    encoder << instance.limitingConeAngle();
}

std::optional<Ref<WebCore::SpotLightSource>> ArgumentCoder<WebCore::SpotLightSource>::decode(Decoder& decoder)
{
    auto position = decoder.decode<WebCore::FloatPoint3D>();
    auto direction = decoder.decode<WebCore::FloatPoint3D>();
    auto specularExponent = decoder.decode<float>();
    auto limitingConeAngle = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SpotLightSource::create(
            WTFMove(*position),
            WTFMove(*direction),
            WTFMove(*specularExponent),
            WTFMove(*limitingConeAngle)
        )
    };
}

void ArgumentCoder<WebCore::FEBlend>::encode(Encoder& encoder, const WebCore::FEBlend& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blendMode())>, WebCore::BlendMode>);
    encoder << instance.blendMode();
}

void ArgumentCoder<WebCore::FEBlend>::encode(StreamConnectionEncoder& encoder, const WebCore::FEBlend& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blendMode())>, WebCore::BlendMode>);
    encoder << instance.blendMode();
}

std::optional<Ref<WebCore::FEBlend>> ArgumentCoder<WebCore::FEBlend>::decode(Decoder& decoder)
{
    auto blendMode = decoder.decode<WebCore::BlendMode>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEBlend::create(
            WTFMove(*blendMode)
        )
    };
}

void ArgumentCoder<WebCore::FEColorMatrix>::encode(Encoder& encoder, const WebCore::FEColorMatrix& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::ColorMatrixType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.values())>, Vector<float>>);
    encoder << instance.type();
    encoder << instance.values();
}

void ArgumentCoder<WebCore::FEColorMatrix>::encode(StreamConnectionEncoder& encoder, const WebCore::FEColorMatrix& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::ColorMatrixType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.values())>, Vector<float>>);
    encoder << instance.type();
    encoder << instance.values();
}

std::optional<Ref<WebCore::FEColorMatrix>> ArgumentCoder<WebCore::FEColorMatrix>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::ColorMatrixType>();
    auto values = decoder.decode<Vector<float>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEColorMatrix::create(
            WTFMove(*type),
            WTFMove(*values)
        )
    };
}

void ArgumentCoder<WebCore::ComponentTransferFunction>::encode(Encoder& encoder, const WebCore::ComponentTransferFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ComponentTransferType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.slope)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.intercept)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amplitude)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.exponent)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.offset)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tableValues)>, Vector<float>>);
    struct ShouldBeSameSizeAsComponentTransferFunction : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ComponentTransferFunction>, false> {
        WebCore::ComponentTransferType type;
        float slope;
        float intercept;
        float amplitude;
        float exponent;
        float offset;
        Vector<float> tableValues;
    };
    static_assert(sizeof(ShouldBeSameSizeAsComponentTransferFunction) == sizeof(WebCore::ComponentTransferFunction));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ComponentTransferFunction, type)
        , offsetof(WebCore::ComponentTransferFunction, slope)
        , offsetof(WebCore::ComponentTransferFunction, intercept)
        , offsetof(WebCore::ComponentTransferFunction, amplitude)
        , offsetof(WebCore::ComponentTransferFunction, exponent)
        , offsetof(WebCore::ComponentTransferFunction, offset)
        , offsetof(WebCore::ComponentTransferFunction, tableValues)
    >::value);
    encoder << instance.type;
    encoder << instance.slope;
    encoder << instance.intercept;
    encoder << instance.amplitude;
    encoder << instance.exponent;
    encoder << instance.offset;
    encoder << instance.tableValues;
}

void ArgumentCoder<WebCore::ComponentTransferFunction>::encode(StreamConnectionEncoder& encoder, const WebCore::ComponentTransferFunction& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ComponentTransferType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.slope)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.intercept)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.amplitude)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.exponent)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.offset)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.tableValues)>, Vector<float>>);
    struct ShouldBeSameSizeAsComponentTransferFunction : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ComponentTransferFunction>, false> {
        WebCore::ComponentTransferType type;
        float slope;
        float intercept;
        float amplitude;
        float exponent;
        float offset;
        Vector<float> tableValues;
    };
    static_assert(sizeof(ShouldBeSameSizeAsComponentTransferFunction) == sizeof(WebCore::ComponentTransferFunction));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ComponentTransferFunction, type)
        , offsetof(WebCore::ComponentTransferFunction, slope)
        , offsetof(WebCore::ComponentTransferFunction, intercept)
        , offsetof(WebCore::ComponentTransferFunction, amplitude)
        , offsetof(WebCore::ComponentTransferFunction, exponent)
        , offsetof(WebCore::ComponentTransferFunction, offset)
        , offsetof(WebCore::ComponentTransferFunction, tableValues)
    >::value);
    encoder << instance.type;
    encoder << instance.slope;
    encoder << instance.intercept;
    encoder << instance.amplitude;
    encoder << instance.exponent;
    encoder << instance.offset;
    encoder << instance.tableValues;
}

std::optional<WebCore::ComponentTransferFunction> ArgumentCoder<WebCore::ComponentTransferFunction>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::ComponentTransferType>();
    auto slope = decoder.decode<float>();
    auto intercept = decoder.decode<float>();
    auto amplitude = decoder.decode<float>();
    auto exponent = decoder.decode<float>();
    auto offset = decoder.decode<float>();
    auto tableValues = decoder.decode<Vector<float>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ComponentTransferFunction {
            WTFMove(*type),
            WTFMove(*slope),
            WTFMove(*intercept),
            WTFMove(*amplitude),
            WTFMove(*exponent),
            WTFMove(*offset),
            WTFMove(*tableValues)
        }
    };
}

void ArgumentCoder<WebCore::FEComponentTransfer>::encode(Encoder& encoder, const WebCore::FEComponentTransfer& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.redFunction())>, WebCore::ComponentTransferFunction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.greenFunction())>, WebCore::ComponentTransferFunction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blueFunction())>, WebCore::ComponentTransferFunction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alphaFunction())>, WebCore::ComponentTransferFunction>);
    encoder << instance.redFunction();
    encoder << instance.greenFunction();
    encoder << instance.blueFunction();
    encoder << instance.alphaFunction();
}

void ArgumentCoder<WebCore::FEComponentTransfer>::encode(StreamConnectionEncoder& encoder, const WebCore::FEComponentTransfer& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.redFunction())>, WebCore::ComponentTransferFunction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.greenFunction())>, WebCore::ComponentTransferFunction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blueFunction())>, WebCore::ComponentTransferFunction>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.alphaFunction())>, WebCore::ComponentTransferFunction>);
    encoder << instance.redFunction();
    encoder << instance.greenFunction();
    encoder << instance.blueFunction();
    encoder << instance.alphaFunction();
}

std::optional<Ref<WebCore::FEComponentTransfer>> ArgumentCoder<WebCore::FEComponentTransfer>::decode(Decoder& decoder)
{
    auto redFunction = decoder.decode<WebCore::ComponentTransferFunction>();
    auto greenFunction = decoder.decode<WebCore::ComponentTransferFunction>();
    auto blueFunction = decoder.decode<WebCore::ComponentTransferFunction>();
    auto alphaFunction = decoder.decode<WebCore::ComponentTransferFunction>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEComponentTransfer::create(
            WTFMove(*redFunction),
            WTFMove(*greenFunction),
            WTFMove(*blueFunction),
            WTFMove(*alphaFunction)
        )
    };
}

void ArgumentCoder<WebCore::FEComposite>::encode(Encoder& encoder, const WebCore::FEComposite& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.operation())>, WebCore::CompositeOperationType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.k1())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.k2())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.k3())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.k4())>, float>);
    encoder << instance.operation();
    encoder << instance.k1();
    encoder << instance.k2();
    encoder << instance.k3();
    encoder << instance.k4();
}

void ArgumentCoder<WebCore::FEComposite>::encode(StreamConnectionEncoder& encoder, const WebCore::FEComposite& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.operation())>, WebCore::CompositeOperationType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.k1())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.k2())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.k3())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.k4())>, float>);
    encoder << instance.operation();
    encoder << instance.k1();
    encoder << instance.k2();
    encoder << instance.k3();
    encoder << instance.k4();
}

std::optional<Ref<WebCore::FEComposite>> ArgumentCoder<WebCore::FEComposite>::decode(Decoder& decoder)
{
    auto operation = decoder.decode<WebCore::CompositeOperationType>();
    auto k1 = decoder.decode<float>();
    auto k2 = decoder.decode<float>();
    auto k3 = decoder.decode<float>();
    auto k4 = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEComposite::create(
            WTFMove(*operation),
            WTFMove(*k1),
            WTFMove(*k2),
            WTFMove(*k3),
            WTFMove(*k4)
        )
    };
}

void ArgumentCoder<WebCore::FEConvolveMatrix>::encode(Encoder& encoder, const WebCore::FEConvolveMatrix& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelSize())>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.divisor())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bias())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.targetOffset())>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.edgeMode())>, WebCore::EdgeModeType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLength())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preserveAlpha())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernel())>, Vector<float>>);
    encoder << instance.kernelSize();
    encoder << instance.divisor();
    encoder << instance.bias();
    encoder << instance.targetOffset();
    encoder << instance.edgeMode();
    encoder << instance.kernelUnitLength();
    encoder << instance.preserveAlpha();
    encoder << instance.kernel();
}

void ArgumentCoder<WebCore::FEConvolveMatrix>::encode(StreamConnectionEncoder& encoder, const WebCore::FEConvolveMatrix& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelSize())>, WebCore::IntSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.divisor())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.bias())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.targetOffset())>, WebCore::IntPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.edgeMode())>, WebCore::EdgeModeType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLength())>, WebCore::FloatPoint>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preserveAlpha())>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernel())>, Vector<float>>);
    encoder << instance.kernelSize();
    encoder << instance.divisor();
    encoder << instance.bias();
    encoder << instance.targetOffset();
    encoder << instance.edgeMode();
    encoder << instance.kernelUnitLength();
    encoder << instance.preserveAlpha();
    encoder << instance.kernel();
}

std::optional<Ref<WebCore::FEConvolveMatrix>> ArgumentCoder<WebCore::FEConvolveMatrix>::decode(Decoder& decoder)
{
    auto kernelSize = decoder.decode<WebCore::IntSize>();
    auto divisor = decoder.decode<float>();
    auto bias = decoder.decode<float>();
    auto targetOffset = decoder.decode<WebCore::IntPoint>();
    auto edgeMode = decoder.decode<WebCore::EdgeModeType>();
    auto kernelUnitLength = decoder.decode<WebCore::FloatPoint>();
    auto preserveAlpha = decoder.decode<bool>();
    auto kernel = decoder.decode<Vector<float>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEConvolveMatrix::create(
            WTFMove(*kernelSize),
            WTFMove(*divisor),
            WTFMove(*bias),
            WTFMove(*targetOffset),
            WTFMove(*edgeMode),
            WTFMove(*kernelUnitLength),
            WTFMove(*preserveAlpha),
            WTFMove(*kernel)
        )
    };
}

void ArgumentCoder<WebCore::FEDiffuseLighting>::encode(Encoder& encoder, const WebCore::FEDiffuseLighting& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lightingColor())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surfaceScale())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.diffuseConstant())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLengthX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLengthY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lightSource())>, Ref<WebCore::LightSource>>);
    encoder << instance.lightingColor();
    encoder << instance.surfaceScale();
    encoder << instance.diffuseConstant();
    encoder << instance.kernelUnitLengthX();
    encoder << instance.kernelUnitLengthY();
    encoder << instance.lightSource();
}

void ArgumentCoder<WebCore::FEDiffuseLighting>::encode(StreamConnectionEncoder& encoder, const WebCore::FEDiffuseLighting& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lightingColor())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surfaceScale())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.diffuseConstant())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLengthX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLengthY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lightSource())>, Ref<WebCore::LightSource>>);
    encoder << instance.lightingColor();
    encoder << instance.surfaceScale();
    encoder << instance.diffuseConstant();
    encoder << instance.kernelUnitLengthX();
    encoder << instance.kernelUnitLengthY();
    encoder << instance.lightSource();
}

std::optional<Ref<WebCore::FEDiffuseLighting>> ArgumentCoder<WebCore::FEDiffuseLighting>::decode(Decoder& decoder)
{
    auto lightingColor = decoder.decode<WebCore::Color>();
    auto surfaceScale = decoder.decode<float>();
    auto diffuseConstant = decoder.decode<float>();
    auto kernelUnitLengthX = decoder.decode<float>();
    auto kernelUnitLengthY = decoder.decode<float>();
    auto lightSource = decoder.decode<Ref<WebCore::LightSource>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEDiffuseLighting::create(
            WTFMove(*lightingColor),
            WTFMove(*surfaceScale),
            WTFMove(*diffuseConstant),
            WTFMove(*kernelUnitLengthX),
            WTFMove(*kernelUnitLengthY),
            WTFMove(*lightSource)
        )
    };
}

void ArgumentCoder<WebCore::FEDisplacementMap>::encode(Encoder& encoder, const WebCore::FEDisplacementMap& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.xChannelSelector())>, WebCore::ChannelSelectorType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.yChannelSelector())>, WebCore::ChannelSelectorType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scale())>, float>);
    encoder << instance.xChannelSelector();
    encoder << instance.yChannelSelector();
    encoder << instance.scale();
}

void ArgumentCoder<WebCore::FEDisplacementMap>::encode(StreamConnectionEncoder& encoder, const WebCore::FEDisplacementMap& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.xChannelSelector())>, WebCore::ChannelSelectorType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.yChannelSelector())>, WebCore::ChannelSelectorType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scale())>, float>);
    encoder << instance.xChannelSelector();
    encoder << instance.yChannelSelector();
    encoder << instance.scale();
}

std::optional<Ref<WebCore::FEDisplacementMap>> ArgumentCoder<WebCore::FEDisplacementMap>::decode(Decoder& decoder)
{
    auto xChannelSelector = decoder.decode<WebCore::ChannelSelectorType>();
    auto yChannelSelector = decoder.decode<WebCore::ChannelSelectorType>();
    auto scale = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEDisplacementMap::create(
            WTFMove(*xChannelSelector),
            WTFMove(*yChannelSelector),
            WTFMove(*scale)
        )
    };
}

void ArgumentCoder<WebCore::FEDropShadow>::encode(Encoder& encoder, const WebCore::FEDropShadow& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stdDeviationX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stdDeviationY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dx())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dy())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shadowColor())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shadowOpacity())>, float>);
    encoder << instance.stdDeviationX();
    encoder << instance.stdDeviationY();
    encoder << instance.dx();
    encoder << instance.dy();
    encoder << instance.shadowColor();
    encoder << instance.shadowOpacity();
}

void ArgumentCoder<WebCore::FEDropShadow>::encode(StreamConnectionEncoder& encoder, const WebCore::FEDropShadow& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stdDeviationX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stdDeviationY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dx())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dy())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shadowColor())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.shadowOpacity())>, float>);
    encoder << instance.stdDeviationX();
    encoder << instance.stdDeviationY();
    encoder << instance.dx();
    encoder << instance.dy();
    encoder << instance.shadowColor();
    encoder << instance.shadowOpacity();
}

std::optional<Ref<WebCore::FEDropShadow>> ArgumentCoder<WebCore::FEDropShadow>::decode(Decoder& decoder)
{
    auto stdDeviationX = decoder.decode<float>();
    auto stdDeviationY = decoder.decode<float>();
    auto dx = decoder.decode<float>();
    auto dy = decoder.decode<float>();
    auto shadowColor = decoder.decode<WebCore::Color>();
    auto shadowOpacity = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEDropShadow::create(
            WTFMove(*stdDeviationX),
            WTFMove(*stdDeviationY),
            WTFMove(*dx),
            WTFMove(*dy),
            WTFMove(*shadowColor),
            WTFMove(*shadowOpacity)
        )
    };
}

void ArgumentCoder<WebCore::FEFlood>::encode(Encoder& encoder, const WebCore::FEFlood& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.floodColor())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.floodOpacity())>, float>);
    encoder << instance.floodColor();
    encoder << instance.floodOpacity();
}

void ArgumentCoder<WebCore::FEFlood>::encode(StreamConnectionEncoder& encoder, const WebCore::FEFlood& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.floodColor())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.floodOpacity())>, float>);
    encoder << instance.floodColor();
    encoder << instance.floodOpacity();
}

std::optional<Ref<WebCore::FEFlood>> ArgumentCoder<WebCore::FEFlood>::decode(Decoder& decoder)
{
    auto floodColor = decoder.decode<WebCore::Color>();
    auto floodOpacity = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEFlood::create(
            WTFMove(*floodColor),
            WTFMove(*floodOpacity)
        )
    };
}

void ArgumentCoder<WebCore::FEGaussianBlur>::encode(Encoder& encoder, const WebCore::FEGaussianBlur& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stdDeviationX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stdDeviationY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.edgeMode())>, WebCore::EdgeModeType>);
    encoder << instance.stdDeviationX();
    encoder << instance.stdDeviationY();
    encoder << instance.edgeMode();
}

void ArgumentCoder<WebCore::FEGaussianBlur>::encode(StreamConnectionEncoder& encoder, const WebCore::FEGaussianBlur& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stdDeviationX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stdDeviationY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.edgeMode())>, WebCore::EdgeModeType>);
    encoder << instance.stdDeviationX();
    encoder << instance.stdDeviationY();
    encoder << instance.edgeMode();
}

std::optional<Ref<WebCore::FEGaussianBlur>> ArgumentCoder<WebCore::FEGaussianBlur>::decode(Decoder& decoder)
{
    auto stdDeviationX = decoder.decode<float>();
    auto stdDeviationY = decoder.decode<float>();
    auto edgeMode = decoder.decode<WebCore::EdgeModeType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEGaussianBlur::create(
            WTFMove(*stdDeviationX),
            WTFMove(*stdDeviationY),
            WTFMove(*edgeMode)
        )
    };
}

void ArgumentCoder<WebCore::FEImage>::encode(Encoder& encoder, const WebCore::FEImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceImage())>, WebCore::SourceImage>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceImageRect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preserveAspectRatio())>, WebCore::SVGPreserveAspectRatioValue>);
    encoder << instance.sourceImage();
    encoder << instance.sourceImageRect();
    encoder << instance.preserveAspectRatio();
}

void ArgumentCoder<WebCore::FEImage>::encode(StreamConnectionEncoder& encoder, const WebCore::FEImage& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceImage())>, WebCore::SourceImage>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sourceImageRect())>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.preserveAspectRatio())>, WebCore::SVGPreserveAspectRatioValue>);
    encoder << instance.sourceImage();
    encoder << instance.sourceImageRect();
    encoder << instance.preserveAspectRatio();
}

std::optional<Ref<WebCore::FEImage>> ArgumentCoder<WebCore::FEImage>::decode(Decoder& decoder)
{
    auto sourceImage = decoder.decode<WebCore::SourceImage>();
    auto sourceImageRect = decoder.decode<WebCore::FloatRect>();
    auto preserveAspectRatio = decoder.decode<WebCore::SVGPreserveAspectRatioValue>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEImage::create(
            WTFMove(*sourceImage),
            WTFMove(*sourceImageRect),
            WTFMove(*preserveAspectRatio)
        )
    };
}

void ArgumentCoder<WebCore::FEMerge>::encode(Encoder& encoder, const WebCore::FEMerge& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.numberOfEffectInputs())>, unsigned>);
    encoder << instance.numberOfEffectInputs();
}

void ArgumentCoder<WebCore::FEMerge>::encode(StreamConnectionEncoder& encoder, const WebCore::FEMerge& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.numberOfEffectInputs())>, unsigned>);
    encoder << instance.numberOfEffectInputs();
}

std::optional<Ref<WebCore::FEMerge>> ArgumentCoder<WebCore::FEMerge>::decode(Decoder& decoder)
{
    auto numberOfEffectInputs = decoder.decode<unsigned>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEMerge::create(
            WTFMove(*numberOfEffectInputs)
        )
    };
}

void ArgumentCoder<WebCore::FEMorphology>::encode(Encoder& encoder, const WebCore::FEMorphology& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.morphologyOperator())>, WebCore::MorphologyOperatorType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusY())>, float>);
    encoder << instance.morphologyOperator();
    encoder << instance.radiusX();
    encoder << instance.radiusY();
}

void ArgumentCoder<WebCore::FEMorphology>::encode(StreamConnectionEncoder& encoder, const WebCore::FEMorphology& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.morphologyOperator())>, WebCore::MorphologyOperatorType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.radiusY())>, float>);
    encoder << instance.morphologyOperator();
    encoder << instance.radiusX();
    encoder << instance.radiusY();
}

std::optional<Ref<WebCore::FEMorphology>> ArgumentCoder<WebCore::FEMorphology>::decode(Decoder& decoder)
{
    auto morphologyOperator = decoder.decode<WebCore::MorphologyOperatorType>();
    auto radiusX = decoder.decode<float>();
    auto radiusY = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEMorphology::create(
            WTFMove(*morphologyOperator),
            WTFMove(*radiusX),
            WTFMove(*radiusY)
        )
    };
}

void ArgumentCoder<WebCore::FEOffset>::encode(Encoder& encoder, const WebCore::FEOffset& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dx())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dy())>, float>);
    encoder << instance.dx();
    encoder << instance.dy();
}

void ArgumentCoder<WebCore::FEOffset>::encode(StreamConnectionEncoder& encoder, const WebCore::FEOffset& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dx())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.dy())>, float>);
    encoder << instance.dx();
    encoder << instance.dy();
}

std::optional<Ref<WebCore::FEOffset>> ArgumentCoder<WebCore::FEOffset>::decode(Decoder& decoder)
{
    auto dx = decoder.decode<float>();
    auto dy = decoder.decode<float>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FEOffset::create(
            WTFMove(*dx),
            WTFMove(*dy)
        )
    };
}

void ArgumentCoder<WebCore::FESpecularLighting>::encode(Encoder& encoder, const WebCore::FESpecularLighting& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lightingColor())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surfaceScale())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.specularConstant())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.specularExponent())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLengthX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLengthY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lightSource())>, Ref<WebCore::LightSource>>);
    encoder << instance.lightingColor();
    encoder << instance.surfaceScale();
    encoder << instance.specularConstant();
    encoder << instance.specularExponent();
    encoder << instance.kernelUnitLengthX();
    encoder << instance.kernelUnitLengthY();
    encoder << instance.lightSource();
}

void ArgumentCoder<WebCore::FESpecularLighting>::encode(StreamConnectionEncoder& encoder, const WebCore::FESpecularLighting& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lightingColor())>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.surfaceScale())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.specularConstant())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.specularExponent())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLengthX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.kernelUnitLengthY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.lightSource())>, Ref<WebCore::LightSource>>);
    encoder << instance.lightingColor();
    encoder << instance.surfaceScale();
    encoder << instance.specularConstant();
    encoder << instance.specularExponent();
    encoder << instance.kernelUnitLengthX();
    encoder << instance.kernelUnitLengthY();
    encoder << instance.lightSource();
}

std::optional<Ref<WebCore::FESpecularLighting>> ArgumentCoder<WebCore::FESpecularLighting>::decode(Decoder& decoder)
{
    auto lightingColor = decoder.decode<WebCore::Color>();
    auto surfaceScale = decoder.decode<float>();
    auto specularConstant = decoder.decode<float>();
    auto specularExponent = decoder.decode<float>();
    auto kernelUnitLengthX = decoder.decode<float>();
    auto kernelUnitLengthY = decoder.decode<float>();
    auto lightSource = decoder.decode<Ref<WebCore::LightSource>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FESpecularLighting::create(
            WTFMove(*lightingColor),
            WTFMove(*surfaceScale),
            WTFMove(*specularConstant),
            WTFMove(*specularExponent),
            WTFMove(*kernelUnitLengthX),
            WTFMove(*kernelUnitLengthY),
            WTFMove(*lightSource)
        )
    };
}

void ArgumentCoder<WebCore::FETurbulence>::encode(Encoder& encoder, const WebCore::FETurbulence& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::TurbulenceType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseFrequencyX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseFrequencyY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.numOctaves())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.seed())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stitchTiles())>, bool>);
    encoder << instance.type();
    encoder << instance.baseFrequencyX();
    encoder << instance.baseFrequencyY();
    encoder << instance.numOctaves();
    encoder << instance.seed();
    encoder << instance.stitchTiles();
}

void ArgumentCoder<WebCore::FETurbulence>::encode(StreamConnectionEncoder& encoder, const WebCore::FETurbulence& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type())>, WebCore::TurbulenceType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseFrequencyX())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.baseFrequencyY())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.numOctaves())>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.seed())>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stitchTiles())>, bool>);
    encoder << instance.type();
    encoder << instance.baseFrequencyX();
    encoder << instance.baseFrequencyY();
    encoder << instance.numOctaves();
    encoder << instance.seed();
    encoder << instance.stitchTiles();
}

std::optional<Ref<WebCore::FETurbulence>> ArgumentCoder<WebCore::FETurbulence>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::TurbulenceType>();
    auto baseFrequencyX = decoder.decode<float>();
    auto baseFrequencyY = decoder.decode<float>();
    auto numOctaves = decoder.decode<int>();
    auto seed = decoder.decode<float>();
    auto stitchTiles = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FETurbulence::create(
            WTFMove(*type),
            WTFMove(*baseFrequencyX),
            WTFMove(*baseFrequencyY),
            WTFMove(*numOctaves),
            WTFMove(*seed),
            WTFMove(*stitchTiles)
        )
    };
}

void ArgumentCoder<WebCore::FilterEffectGeometry>::encode(Encoder& encoder, const WebCore::FilterEffectGeometry& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_boundaries)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_flags)>, OptionSet<WebCore::FilterEffectGeometry::Flags>>);
    struct ShouldBeSameSizeAsFilterEffectGeometry : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FilterEffectGeometry>, false> {
        WebCore::FloatRect m_boundaries;
        OptionSet<WebCore::FilterEffectGeometry::Flags> m_flags;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFilterEffectGeometry) == sizeof(WebCore::FilterEffectGeometry));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FilterEffectGeometry, m_boundaries)
        , offsetof(WebCore::FilterEffectGeometry, m_flags)
    >::value);
    encoder << instance.m_boundaries;
    encoder << instance.m_flags;
}

void ArgumentCoder<WebCore::FilterEffectGeometry>::encode(StreamConnectionEncoder& encoder, const WebCore::FilterEffectGeometry& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_boundaries)>, WebCore::FloatRect>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_flags)>, OptionSet<WebCore::FilterEffectGeometry::Flags>>);
    struct ShouldBeSameSizeAsFilterEffectGeometry : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FilterEffectGeometry>, false> {
        WebCore::FloatRect m_boundaries;
        OptionSet<WebCore::FilterEffectGeometry::Flags> m_flags;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFilterEffectGeometry) == sizeof(WebCore::FilterEffectGeometry));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FilterEffectGeometry, m_boundaries)
        , offsetof(WebCore::FilterEffectGeometry, m_flags)
    >::value);
    encoder << instance.m_boundaries;
    encoder << instance.m_flags;
}

std::optional<WebCore::FilterEffectGeometry> ArgumentCoder<WebCore::FilterEffectGeometry>::decode(Decoder& decoder)
{
    auto m_boundaries = decoder.decode<WebCore::FloatRect>();
    auto m_flags = decoder.decode<OptionSet<WebCore::FilterEffectGeometry::Flags>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FilterEffectGeometry {
            WTFMove(*m_boundaries),
            WTFMove(*m_flags)
        }
    };
}

void ArgumentCoder<WebCore::SVGFilterExpressionTerm>::encode(Encoder& encoder, const WebCore::SVGFilterExpressionTerm& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.index)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.level)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.geometry)>, std::optional<WebCore::FilterEffectGeometry>>);
    struct ShouldBeSameSizeAsSVGFilterExpressionTerm : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SVGFilterExpressionTerm>, false> {
        unsigned index;
        unsigned level;
        std::optional<WebCore::FilterEffectGeometry> geometry;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSVGFilterExpressionTerm) == sizeof(WebCore::SVGFilterExpressionTerm));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SVGFilterExpressionTerm, index)
        , offsetof(WebCore::SVGFilterExpressionTerm, level)
        , offsetof(WebCore::SVGFilterExpressionTerm, geometry)
    >::value);
    encoder << instance.index;
    encoder << instance.level;
    encoder << instance.geometry;
}

void ArgumentCoder<WebCore::SVGFilterExpressionTerm>::encode(StreamConnectionEncoder& encoder, const WebCore::SVGFilterExpressionTerm& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.index)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.level)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.geometry)>, std::optional<WebCore::FilterEffectGeometry>>);
    struct ShouldBeSameSizeAsSVGFilterExpressionTerm : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SVGFilterExpressionTerm>, false> {
        unsigned index;
        unsigned level;
        std::optional<WebCore::FilterEffectGeometry> geometry;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSVGFilterExpressionTerm) == sizeof(WebCore::SVGFilterExpressionTerm));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SVGFilterExpressionTerm, index)
        , offsetof(WebCore::SVGFilterExpressionTerm, level)
        , offsetof(WebCore::SVGFilterExpressionTerm, geometry)
    >::value);
    encoder << instance.index;
    encoder << instance.level;
    encoder << instance.geometry;
}

std::optional<WebCore::SVGFilterExpressionTerm> ArgumentCoder<WebCore::SVGFilterExpressionTerm>::decode(Decoder& decoder)
{
    auto index = decoder.decode<unsigned>();
    auto level = decoder.decode<unsigned>();
    auto geometry = decoder.decode<std::optional<WebCore::FilterEffectGeometry>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SVGFilterExpressionTerm {
            WTFMove(*index),
            WTFMove(*level),
            WTFMove(*geometry)
        }
    };
}

void ArgumentCoder<WebCore::SVGPreserveAspectRatioValue>::encode(Encoder& encoder, const WebCore::SVGPreserveAspectRatioValue& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_align)>, WebCore::SVGPreserveAspectRatioValue::SVGPreserveAspectRatioType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_meetOrSlice)>, WebCore::SVGPreserveAspectRatioValue::SVGMeetOrSliceType>);
    struct ShouldBeSameSizeAsSVGPreserveAspectRatioValue : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SVGPreserveAspectRatioValue>, false> {
        WebCore::SVGPreserveAspectRatioValue::SVGPreserveAspectRatioType m_align;
        WebCore::SVGPreserveAspectRatioValue::SVGMeetOrSliceType m_meetOrSlice;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSVGPreserveAspectRatioValue) == sizeof(WebCore::SVGPreserveAspectRatioValue));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SVGPreserveAspectRatioValue, m_align)
        , offsetof(WebCore::SVGPreserveAspectRatioValue, m_meetOrSlice)
    >::value);
    encoder << instance.m_align;
    encoder << instance.m_meetOrSlice;
}

void ArgumentCoder<WebCore::SVGPreserveAspectRatioValue>::encode(StreamConnectionEncoder& encoder, const WebCore::SVGPreserveAspectRatioValue& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_align)>, WebCore::SVGPreserveAspectRatioValue::SVGPreserveAspectRatioType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_meetOrSlice)>, WebCore::SVGPreserveAspectRatioValue::SVGMeetOrSliceType>);
    struct ShouldBeSameSizeAsSVGPreserveAspectRatioValue : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SVGPreserveAspectRatioValue>, false> {
        WebCore::SVGPreserveAspectRatioValue::SVGPreserveAspectRatioType m_align;
        WebCore::SVGPreserveAspectRatioValue::SVGMeetOrSliceType m_meetOrSlice;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSVGPreserveAspectRatioValue) == sizeof(WebCore::SVGPreserveAspectRatioValue));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SVGPreserveAspectRatioValue, m_align)
        , offsetof(WebCore::SVGPreserveAspectRatioValue, m_meetOrSlice)
    >::value);
    encoder << instance.m_align;
    encoder << instance.m_meetOrSlice;
}

std::optional<WebCore::SVGPreserveAspectRatioValue> ArgumentCoder<WebCore::SVGPreserveAspectRatioValue>::decode(Decoder& decoder)
{
    auto m_align = decoder.decode<WebCore::SVGPreserveAspectRatioValue::SVGPreserveAspectRatioType>();
    auto m_meetOrSlice = decoder.decode<WebCore::SVGPreserveAspectRatioValue::SVGMeetOrSliceType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SVGPreserveAspectRatioValue {
            WTFMove(*m_align),
            WTFMove(*m_meetOrSlice)
        }
    };
}

#if ENABLE(GAMEPAD)
void ArgumentCoder<WebCore::GamepadEffectParameters>::encode(Encoder& encoder, const WebCore::GamepadEffectParameters& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.duration)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startDelay)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.strongMagnitude)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.weakMagnitude)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.leftTrigger)>, double>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.rightTrigger)>, double>);
    struct ShouldBeSameSizeAsGamepadEffectParameters : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::GamepadEffectParameters>, false> {
        double duration;
        double startDelay;
        double strongMagnitude;
        double weakMagnitude;
        double leftTrigger;
        double rightTrigger;
    };
    static_assert(sizeof(ShouldBeSameSizeAsGamepadEffectParameters) == sizeof(WebCore::GamepadEffectParameters));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::GamepadEffectParameters, duration)
        , offsetof(WebCore::GamepadEffectParameters, startDelay)
        , offsetof(WebCore::GamepadEffectParameters, strongMagnitude)
        , offsetof(WebCore::GamepadEffectParameters, weakMagnitude)
        , offsetof(WebCore::GamepadEffectParameters, leftTrigger)
        , offsetof(WebCore::GamepadEffectParameters, rightTrigger)
    >::value);
    encoder << instance.duration;
    encoder << instance.startDelay;
    encoder << instance.strongMagnitude;
    encoder << instance.weakMagnitude;
    encoder << instance.leftTrigger;
    encoder << instance.rightTrigger;
}

std::optional<WebCore::GamepadEffectParameters> ArgumentCoder<WebCore::GamepadEffectParameters>::decode(Decoder& decoder)
{
    auto duration = decoder.decode<double>();
    auto startDelay = decoder.decode<double>();
    auto strongMagnitude = decoder.decode<double>();
    auto weakMagnitude = decoder.decode<double>();
    auto leftTrigger = decoder.decode<double>();
    auto rightTrigger = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::GamepadEffectParameters {
            WTFMove(*duration),
            WTFMove(*startDelay),
            WTFMove(*strongMagnitude),
            WTFMove(*weakMagnitude),
            WTFMove(*leftTrigger),
            WTFMove(*rightTrigger)
        }
    };
}

#endif

void ArgumentCoder<WebCore::StorageEstimate>::encode(Encoder& encoder, const WebCore::StorageEstimate& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.usage)>, uint64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.quota)>, uint64_t>);
    struct ShouldBeSameSizeAsStorageEstimate : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::StorageEstimate>, false> {
        uint64_t usage;
        uint64_t quota;
    };
    static_assert(sizeof(ShouldBeSameSizeAsStorageEstimate) == sizeof(WebCore::StorageEstimate));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::StorageEstimate, usage)
        , offsetof(WebCore::StorageEstimate, quota)
    >::value);
    encoder << instance.usage;
    encoder << instance.quota;
}

std::optional<WebCore::StorageEstimate> ArgumentCoder<WebCore::StorageEstimate>::decode(Decoder& decoder)
{
    auto usage = decoder.decode<uint64_t>();
    auto quota = decoder.decode<uint64_t>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::StorageEstimate {
            WTFMove(*usage),
            WTFMove(*quota)
        }
    };
}

void ArgumentCoder<WebCore::ListStyleType>::encode(Encoder& encoder, const WebCore::ListStyleType& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.type)>, WebCore::ListStyleType::Type>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.identifier)>, AtomString>);
    struct ShouldBeSameSizeAsListStyleType : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::ListStyleType>, false> {
        WebCore::ListStyleType::Type type;
        AtomString identifier;
    };
    static_assert(sizeof(ShouldBeSameSizeAsListStyleType) == sizeof(WebCore::ListStyleType));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::ListStyleType, type)
        , offsetof(WebCore::ListStyleType, identifier)
    >::value);
    encoder << instance.type;
    encoder << instance.identifier;
}

std::optional<WebCore::ListStyleType> ArgumentCoder<WebCore::ListStyleType>::decode(Decoder& decoder)
{
    auto type = decoder.decode<WebCore::ListStyleType::Type>();
    auto identifier = decoder.decode<AtomString>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::ListStyleType {
            WTFMove(*type),
            WTFMove(*identifier)
        }
    };
}

void ArgumentCoder<WebCore::TextList>::encode(Encoder& encoder, const WebCore::TextList& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.styleType)>, WebCore::ListStyleType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startingItemNumber)>, int>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.ordered)>, bool>);
    struct ShouldBeSameSizeAsTextList : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextList>, false> {
        WebCore::ListStyleType styleType;
        int startingItemNumber;
        bool ordered;
    };
    static_assert(sizeof(ShouldBeSameSizeAsTextList) == sizeof(WebCore::TextList));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextList, styleType)
        , offsetof(WebCore::TextList, startingItemNumber)
        , offsetof(WebCore::TextList, ordered)
    >::value);
    encoder << instance.styleType;
    encoder << instance.startingItemNumber;
    encoder << instance.ordered;
}

std::optional<WebCore::TextList> ArgumentCoder<WebCore::TextList>::decode(Decoder& decoder)
{
    auto styleType = decoder.decode<WebCore::ListStyleType>();
    auto startingItemNumber = decoder.decode<int>();
    auto ordered = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextList {
            WTFMove(*styleType),
            WTFMove(*startingItemNumber),
            WTFMove(*ordered)
        }
    };
}

void ArgumentCoder<WebCore::FontAttributes>::encode(Encoder& encoder, const WebCore::FontAttributes& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.font)>, RefPtr<WebCore::Font>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.backgroundColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.foregroundColor)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.fontShadow)>, WebCore::FontShadow>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.subscriptOrSuperscript)>, WebCore::FontAttributes::SubscriptOrSuperscript>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.horizontalAlignment)>, WebCore::FontAttributes::HorizontalAlignment>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.textLists)>, Vector<WebCore::TextList>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasUnderline)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasStrikeThrough)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasMultipleFonts)>, bool>);
    struct ShouldBeSameSizeAsFontAttributes : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FontAttributes>, false> {
        RefPtr<WebCore::Font> font;
        WebCore::Color backgroundColor;
        WebCore::Color foregroundColor;
        WebCore::FontShadow fontShadow;
        WebCore::FontAttributes::SubscriptOrSuperscript subscriptOrSuperscript;
        WebCore::FontAttributes::HorizontalAlignment horizontalAlignment;
        Vector<WebCore::TextList> textLists;
        bool hasUnderline;
        bool hasStrikeThrough;
        bool hasMultipleFonts;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFontAttributes) == sizeof(WebCore::FontAttributes));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FontAttributes, font)
        , offsetof(WebCore::FontAttributes, backgroundColor)
        , offsetof(WebCore::FontAttributes, foregroundColor)
        , offsetof(WebCore::FontAttributes, fontShadow)
        , offsetof(WebCore::FontAttributes, subscriptOrSuperscript)
        , offsetof(WebCore::FontAttributes, horizontalAlignment)
        , offsetof(WebCore::FontAttributes, textLists)
        , offsetof(WebCore::FontAttributes, hasUnderline)
        , offsetof(WebCore::FontAttributes, hasStrikeThrough)
        , offsetof(WebCore::FontAttributes, hasMultipleFonts)
    >::value);
    encoder << instance.font;
    encoder << instance.backgroundColor;
    encoder << instance.foregroundColor;
    encoder << instance.fontShadow;
    encoder << instance.subscriptOrSuperscript;
    encoder << instance.horizontalAlignment;
    encoder << instance.textLists;
    encoder << instance.hasUnderline;
    encoder << instance.hasStrikeThrough;
    encoder << instance.hasMultipleFonts;
}

std::optional<WebCore::FontAttributes> ArgumentCoder<WebCore::FontAttributes>::decode(Decoder& decoder)
{
    auto font = decoder.decode<RefPtr<WebCore::Font>>();
    auto backgroundColor = decoder.decode<WebCore::Color>();
    auto foregroundColor = decoder.decode<WebCore::Color>();
    auto fontShadow = decoder.decode<WebCore::FontShadow>();
    auto subscriptOrSuperscript = decoder.decode<WebCore::FontAttributes::SubscriptOrSuperscript>();
    auto horizontalAlignment = decoder.decode<WebCore::FontAttributes::HorizontalAlignment>();
    auto textLists = decoder.decode<Vector<WebCore::TextList>>();
    auto hasUnderline = decoder.decode<bool>();
    auto hasStrikeThrough = decoder.decode<bool>();
    auto hasMultipleFonts = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FontAttributes {
            WTFMove(*font),
            WTFMove(*backgroundColor),
            WTFMove(*foregroundColor),
            WTFMove(*fontShadow),
            WTFMove(*subscriptOrSuperscript),
            WTFMove(*horizontalAlignment),
            WTFMove(*textLists),
            WTFMove(*hasUnderline),
            WTFMove(*hasStrikeThrough),
            WTFMove(*hasMultipleFonts)
        }
    };
}

void ArgumentCoder<WebCore::CrossOriginEmbedderPolicy>::encode(Encoder& encoder, const WebCore::CrossOriginEmbedderPolicy& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, WebCore::CrossOriginEmbedderPolicyValue>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reportOnlyValue)>, WebCore::CrossOriginEmbedderPolicyValue>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reportingEndpoint)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.reportOnlyReportingEndpoint)>, String>);
    struct ShouldBeSameSizeAsCrossOriginEmbedderPolicy : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CrossOriginEmbedderPolicy>, false> {
        WebCore::CrossOriginEmbedderPolicyValue value;
        WebCore::CrossOriginEmbedderPolicyValue reportOnlyValue;
        String reportingEndpoint;
        String reportOnlyReportingEndpoint;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCrossOriginEmbedderPolicy) == sizeof(WebCore::CrossOriginEmbedderPolicy));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CrossOriginEmbedderPolicy, value)
        , offsetof(WebCore::CrossOriginEmbedderPolicy, reportOnlyValue)
        , offsetof(WebCore::CrossOriginEmbedderPolicy, reportingEndpoint)
        , offsetof(WebCore::CrossOriginEmbedderPolicy, reportOnlyReportingEndpoint)
    >::value);
    encoder << instance.value;
    encoder << instance.reportOnlyValue;
    encoder << instance.reportingEndpoint;
    encoder << instance.reportOnlyReportingEndpoint;
}

std::optional<WebCore::CrossOriginEmbedderPolicy> ArgumentCoder<WebCore::CrossOriginEmbedderPolicy>::decode(Decoder& decoder)
{
    auto value = decoder.decode<WebCore::CrossOriginEmbedderPolicyValue>();
    auto reportOnlyValue = decoder.decode<WebCore::CrossOriginEmbedderPolicyValue>();
    auto reportingEndpoint = decoder.decode<String>();
    auto reportOnlyReportingEndpoint = decoder.decode<String>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CrossOriginEmbedderPolicy {
            WTFMove(*value),
            WTFMove(*reportOnlyValue),
            WTFMove(*reportingEndpoint),
            WTFMove(*reportOnlyReportingEndpoint)
        }
    };
}

void ArgumentCoder<WebCore::SameSiteInfo>::encode(Encoder& encoder, const WebCore::SameSiteInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSameSite)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isTopSite)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isSafeHTTPMethod)>, bool>);
    struct ShouldBeSameSizeAsSameSiteInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SameSiteInfo>, false> {
        bool isSameSite;
        bool isTopSite;
        bool isSafeHTTPMethod;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSameSiteInfo) == sizeof(WebCore::SameSiteInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SameSiteInfo, isSameSite)
        , offsetof(WebCore::SameSiteInfo, isTopSite)
        , offsetof(WebCore::SameSiteInfo, isSafeHTTPMethod)
    >::value);
    encoder << instance.isSameSite;
    encoder << instance.isTopSite;
    encoder << instance.isSafeHTTPMethod;
}

std::optional<WebCore::SameSiteInfo> ArgumentCoder<WebCore::SameSiteInfo>::decode(Decoder& decoder)
{
    auto isSameSite = decoder.decode<bool>();
    auto isTopSite = decoder.decode<bool>();
    auto isSafeHTTPMethod = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SameSiteInfo {
            WTFMove(*isSameSite),
            WTFMove(*isTopSite),
            WTFMove(*isSafeHTTPMethod)
        }
    };
}

void ArgumentCoder<WebCore::SecurityOrigin>::encode(Encoder& encoder, const WebCore::SecurityOrigin& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_data)>, WebCore::SecurityOriginData>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_domain)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_filePath)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_universalAccess)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_domainWasSetInDOM)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_canLoadLocalResources)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_enforcesFilePathSeparation)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_needsStorageAccessFromFileURLsQuirk)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isPotentiallyTrustworthy)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_isLocal)>, bool>);
    struct ShouldBeSameSizeAsSecurityOrigin : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::SecurityOrigin>, true> {
        WebCore::SecurityOriginData m_data;
        String m_domain;
        String m_filePath;
        bool m_universalAccess;
        bool m_domainWasSetInDOM;
        bool m_canLoadLocalResources;
        bool m_enforcesFilePathSeparation;
        bool m_needsStorageAccessFromFileURLsQuirk;
        std::optional<bool> m_isPotentiallyTrustworthy;
        bool m_isLocal;
    };
    static_assert(sizeof(ShouldBeSameSizeAsSecurityOrigin) == sizeof(WebCore::SecurityOrigin));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::SecurityOrigin, m_data)
        , offsetof(WebCore::SecurityOrigin, m_domain)
        , offsetof(WebCore::SecurityOrigin, m_filePath)
        , offsetof(WebCore::SecurityOrigin, m_universalAccess)
        , offsetof(WebCore::SecurityOrigin, m_domainWasSetInDOM)
        , offsetof(WebCore::SecurityOrigin, m_canLoadLocalResources)
        , offsetof(WebCore::SecurityOrigin, m_enforcesFilePathSeparation)
        , offsetof(WebCore::SecurityOrigin, m_needsStorageAccessFromFileURLsQuirk)
        , offsetof(WebCore::SecurityOrigin, m_isPotentiallyTrustworthy)
        , offsetof(WebCore::SecurityOrigin, m_isLocal)
    >::value);
    encoder << instance.m_data;
    encoder << instance.m_domain;
    encoder << instance.m_filePath;
    encoder << instance.m_universalAccess;
    encoder << instance.m_domainWasSetInDOM;
    encoder << instance.m_canLoadLocalResources;
    encoder << instance.m_enforcesFilePathSeparation;
    encoder << instance.m_needsStorageAccessFromFileURLsQuirk;
    encoder << instance.m_isPotentiallyTrustworthy;
    encoder << instance.m_isLocal;
}

std::optional<Ref<WebCore::SecurityOrigin>> ArgumentCoder<WebCore::SecurityOrigin>::decode(Decoder& decoder)
{
    auto m_data = decoder.decode<WebCore::SecurityOriginData>();
    auto m_domain = decoder.decode<String>();
    auto m_filePath = decoder.decode<String>();
    auto m_universalAccess = decoder.decode<bool>();
    auto m_domainWasSetInDOM = decoder.decode<bool>();
    auto m_canLoadLocalResources = decoder.decode<bool>();
    auto m_enforcesFilePathSeparation = decoder.decode<bool>();
    auto m_needsStorageAccessFromFileURLsQuirk = decoder.decode<bool>();
    auto m_isPotentiallyTrustworthy = decoder.decode<std::optional<bool>>();
    auto m_isLocal = decoder.decode<bool>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::SecurityOrigin::create(
            WTFMove(*m_data),
            WTFMove(*m_domain),
            WTFMove(*m_filePath),
            WTFMove(*m_universalAccess),
            WTFMove(*m_domainWasSetInDOM),
            WTFMove(*m_canLoadLocalResources),
            WTFMove(*m_enforcesFilePathSeparation),
            WTFMove(*m_needsStorageAccessFromFileURLsQuirk),
            WTFMove(*m_isPotentiallyTrustworthy),
            WTFMove(*m_isLocal)
        )
    };
}

void ArgumentCoder<WebCore::CookieRequestHeaderFieldProxy>::encode(Encoder& encoder, const WebCore::CookieRequestHeaderFieldProxy& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.firstParty)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.sameSiteInfo)>, WebCore::SameSiteInfo>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.url)>, URL>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.frameID)>, std::optional<WebCore::FrameIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.pageID)>, std::optional<WebCore::PageIdentifier>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.includeSecureCookies)>, WebCore::IncludeSecureCookies>);
    struct ShouldBeSameSizeAsCookieRequestHeaderFieldProxy : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CookieRequestHeaderFieldProxy>, false> {
        URL firstParty;
        WebCore::SameSiteInfo sameSiteInfo;
        URL url;
        std::optional<WebCore::FrameIdentifier> frameID;
        std::optional<WebCore::PageIdentifier> pageID;
        WebCore::IncludeSecureCookies includeSecureCookies;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCookieRequestHeaderFieldProxy) == sizeof(WebCore::CookieRequestHeaderFieldProxy));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CookieRequestHeaderFieldProxy, firstParty)
        , offsetof(WebCore::CookieRequestHeaderFieldProxy, sameSiteInfo)
        , offsetof(WebCore::CookieRequestHeaderFieldProxy, url)
        , offsetof(WebCore::CookieRequestHeaderFieldProxy, frameID)
        , offsetof(WebCore::CookieRequestHeaderFieldProxy, pageID)
        , offsetof(WebCore::CookieRequestHeaderFieldProxy, includeSecureCookies)
    >::value);
    encoder << instance.firstParty;
    encoder << instance.sameSiteInfo;
    encoder << instance.url;
    encoder << instance.frameID;
    encoder << instance.pageID;
    encoder << instance.includeSecureCookies;
}

std::optional<WebCore::CookieRequestHeaderFieldProxy> ArgumentCoder<WebCore::CookieRequestHeaderFieldProxy>::decode(Decoder& decoder)
{
    auto firstParty = decoder.decode<URL>();
    auto sameSiteInfo = decoder.decode<WebCore::SameSiteInfo>();
    auto url = decoder.decode<URL>();
    auto frameID = decoder.decode<std::optional<WebCore::FrameIdentifier>>();
    auto pageID = decoder.decode<std::optional<WebCore::PageIdentifier>>();
    auto includeSecureCookies = decoder.decode<WebCore::IncludeSecureCookies>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CookieRequestHeaderFieldProxy {
            WTFMove(*firstParty),
            WTFMove(*sameSiteInfo),
            WTFMove(*url),
            WTFMove(*frameID),
            WTFMove(*pageID),
            WTFMove(*includeSecureCookies)
        }
    };
}

void ArgumentCoder<WebCore::FormData>::encode(Encoder& encoder, const WebCore::FormData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_elements)>, Vector<WebCore::FormDataElement>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_identifier)>, int64_t>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_alwaysStream)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_boundary)>, Vector<char>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_lengthInBytes)>, std::optional<uint64_t>>);
    struct ShouldBeSameSizeAsFormData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FormData>, true> {
        Vector<WebCore::FormDataElement> m_elements;
        int64_t m_identifier;
        bool m_alwaysStream;
        Vector<char> m_boundary;
        std::optional<uint64_t> m_lengthInBytes;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFormData) == sizeof(WebCore::FormData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FormData, m_elements)
        , offsetof(WebCore::FormData, m_identifier)
        , offsetof(WebCore::FormData, m_alwaysStream)
        , offsetof(WebCore::FormData, m_boundary)
        , offsetof(WebCore::FormData, m_lengthInBytes)
    >::value);
    encoder << instance.m_elements;
    encoder << instance.m_identifier;
    encoder << instance.m_alwaysStream;
    encoder << instance.m_boundary;
}

std::optional<Ref<WebCore::FormData>> ArgumentCoder<WebCore::FormData>::decode(Decoder& decoder)
{
    auto m_elements = decoder.decode<Vector<WebCore::FormDataElement>>();
    auto m_identifier = decoder.decode<int64_t>();
    auto m_alwaysStream = decoder.decode<bool>();
    auto m_boundary = decoder.decode<Vector<char>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FormData::create(
            WTFMove(*m_elements),
            WTFMove(*m_identifier),
            WTFMove(*m_alwaysStream),
            WTFMove(*m_boundary)
        )
    };
}

void ArgumentCoder<WebCore::RequestedScrollData>::encode(Encoder& encoder, const WebCore::RequestedScrollData& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requestType)>, WebCore::ScrollRequestType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollPositionOrDelta)>, std::variant<WebCore::FloatPoint, WebCore::FloatSize>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.scrollType)>, WebCore::ScrollType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.clamping)>, WebCore::ScrollClamping>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.animated)>, WebCore::ScrollIsAnimated>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.requestedDataBeforeAnimatedScroll)>, std::optional<std::tuple<WebCore::ScrollRequestType, std::variant<WebCore::FloatPoint, WebCore::FloatSize>, WebCore::ScrollType, WebCore::ScrollClamping>>>);
    struct ShouldBeSameSizeAsRequestedScrollData : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::RequestedScrollData>, false> {
        WebCore::ScrollRequestType requestType;
        std::variant<WebCore::FloatPoint, WebCore::FloatSize> scrollPositionOrDelta;
        WebCore::ScrollType scrollType;
        WebCore::ScrollClamping clamping;
        WebCore::ScrollIsAnimated animated;
        std::optional<std::tuple<WebCore::ScrollRequestType, std::variant<WebCore::FloatPoint, WebCore::FloatSize>, WebCore::ScrollType, WebCore::ScrollClamping>> requestedDataBeforeAnimatedScroll;
    };
    static_assert(sizeof(ShouldBeSameSizeAsRequestedScrollData) == sizeof(WebCore::RequestedScrollData));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::RequestedScrollData, requestType)
        , offsetof(WebCore::RequestedScrollData, scrollPositionOrDelta)
        , offsetof(WebCore::RequestedScrollData, scrollType)
        , offsetof(WebCore::RequestedScrollData, clamping)
        , offsetof(WebCore::RequestedScrollData, animated)
        , offsetof(WebCore::RequestedScrollData, requestedDataBeforeAnimatedScroll)
    >::value);
    encoder << instance.requestType;
    encoder << instance.scrollPositionOrDelta;
    encoder << instance.scrollType;
    encoder << instance.clamping;
    encoder << instance.animated;
    encoder << instance.requestedDataBeforeAnimatedScroll;
}

std::optional<WebCore::RequestedScrollData> ArgumentCoder<WebCore::RequestedScrollData>::decode(Decoder& decoder)
{
    auto requestType = decoder.decode<WebCore::ScrollRequestType>();
    auto scrollPositionOrDelta = decoder.decode<std::variant<WebCore::FloatPoint, WebCore::FloatSize>>();
    auto scrollType = decoder.decode<WebCore::ScrollType>();
    auto clamping = decoder.decode<WebCore::ScrollClamping>();
    auto animated = decoder.decode<WebCore::ScrollIsAnimated>();
    auto requestedDataBeforeAnimatedScroll = decoder.decode<std::optional<std::tuple<WebCore::ScrollRequestType, std::variant<WebCore::FloatPoint, WebCore::FloatSize>, WebCore::ScrollType, WebCore::ScrollClamping>>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::RequestedScrollData {
            WTFMove(*requestType),
            WTFMove(*scrollPositionOrDelta),
            WTFMove(*scrollType),
            WTFMove(*clamping),
            WTFMove(*animated),
            WTFMove(*requestedDataBeforeAnimatedScroll)
        }
    };
}

void ArgumentCoder<WebCore::FloatScrollSnapOffsetsInfo>::encode(Encoder& encoder, const WebCore::FloatScrollSnapOffsetsInfo& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.strictness)>, WebCore::ScrollSnapStrictness>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.horizontalSnapOffsets)>, Vector<WebCore::FloatSnapOffset>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.verticalSnapOffsets)>, Vector<WebCore::FloatSnapOffset>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.snapAreas)>, Vector<WebCore::FloatRect>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.snapAreasIDs)>, Vector<WebCore::ElementIdentifier>>);
    struct ShouldBeSameSizeAsFloatScrollSnapOffsetsInfo : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FloatScrollSnapOffsetsInfo>, false> {
        WebCore::ScrollSnapStrictness strictness;
        Vector<WebCore::FloatSnapOffset> horizontalSnapOffsets;
        Vector<WebCore::FloatSnapOffset> verticalSnapOffsets;
        Vector<WebCore::FloatRect> snapAreas;
        Vector<WebCore::ElementIdentifier> snapAreasIDs;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFloatScrollSnapOffsetsInfo) == sizeof(WebCore::FloatScrollSnapOffsetsInfo));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FloatScrollSnapOffsetsInfo, strictness)
        , offsetof(WebCore::FloatScrollSnapOffsetsInfo, horizontalSnapOffsets)
        , offsetof(WebCore::FloatScrollSnapOffsetsInfo, verticalSnapOffsets)
        , offsetof(WebCore::FloatScrollSnapOffsetsInfo, snapAreas)
        , offsetof(WebCore::FloatScrollSnapOffsetsInfo, snapAreasIDs)
    >::value);
    encoder << instance.strictness;
    encoder << instance.horizontalSnapOffsets;
    encoder << instance.verticalSnapOffsets;
    encoder << instance.snapAreas;
    encoder << instance.snapAreasIDs;
}

std::optional<WebCore::FloatScrollSnapOffsetsInfo> ArgumentCoder<WebCore::FloatScrollSnapOffsetsInfo>::decode(Decoder& decoder)
{
    auto strictness = decoder.decode<WebCore::ScrollSnapStrictness>();
    auto horizontalSnapOffsets = decoder.decode<Vector<WebCore::FloatSnapOffset>>();
    auto verticalSnapOffsets = decoder.decode<Vector<WebCore::FloatSnapOffset>>();
    auto snapAreas = decoder.decode<Vector<WebCore::FloatRect>>();
    auto snapAreasIDs = decoder.decode<Vector<WebCore::ElementIdentifier>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FloatScrollSnapOffsetsInfo {
            WTFMove(*strictness),
            WTFMove(*horizontalSnapOffsets),
            WTFMove(*verticalSnapOffsets),
            WTFMove(*snapAreas),
            WTFMove(*snapAreasIDs)
        }
    };
}

void ArgumentCoder<WebCore::FloatSnapOffset>::encode(Encoder& encoder, const WebCore::FloatSnapOffset& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.offset)>, float>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.stop)>, WebCore::ScrollSnapStop>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.hasSnapAreaLargerThanViewport)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.snapTargetID)>, WebCore::ElementIdentifier>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.isFocused)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.snapAreaIndices)>, Vector<size_t>>);
    struct ShouldBeSameSizeAsFloatSnapOffset : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FloatSnapOffset>, false> {
        float offset;
        WebCore::ScrollSnapStop stop;
        bool hasSnapAreaLargerThanViewport;
        WebCore::ElementIdentifier snapTargetID;
        bool isFocused;
        Vector<size_t> snapAreaIndices;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFloatSnapOffset) == sizeof(WebCore::FloatSnapOffset));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FloatSnapOffset, offset)
        , offsetof(WebCore::FloatSnapOffset, stop)
        , offsetof(WebCore::FloatSnapOffset, hasSnapAreaLargerThanViewport)
        , offsetof(WebCore::FloatSnapOffset, snapTargetID)
        , offsetof(WebCore::FloatSnapOffset, isFocused)
        , offsetof(WebCore::FloatSnapOffset, snapAreaIndices)
    >::value);
    encoder << instance.offset;
    encoder << instance.stop;
    encoder << instance.hasSnapAreaLargerThanViewport;
    encoder << instance.snapTargetID;
    encoder << instance.isFocused;
    encoder << instance.snapAreaIndices;
}

std::optional<WebCore::FloatSnapOffset> ArgumentCoder<WebCore::FloatSnapOffset>::decode(Decoder& decoder)
{
    auto offset = decoder.decode<float>();
    auto stop = decoder.decode<WebCore::ScrollSnapStop>();
    auto hasSnapAreaLargerThanViewport = decoder.decode<bool>();
    auto snapTargetID = decoder.decode<WebCore::ElementIdentifier>();
    auto isFocused = decoder.decode<bool>();
    auto snapAreaIndices = decoder.decode<Vector<size_t>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FloatSnapOffset {
            WTFMove(*offset),
            WTFMove(*stop),
            WTFMove(*hasSnapAreaLargerThanViewport),
            WTFMove(*snapTargetID),
            WTFMove(*isFocused),
            WTFMove(*snapAreaIndices)
        }
    };
}

#if ENABLE(ENCRYPTED_MEDIA)
void ArgumentCoder<WebCore::CDMMediaCapability>::encode(Encoder& encoder, const WebCore::CDMMediaCapability& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.contentType)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.robustness)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.encryptionScheme)>, std::optional<WebCore::CDMEncryptionScheme>>);
    struct ShouldBeSameSizeAsCDMMediaCapability : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CDMMediaCapability>, false> {
        String contentType;
        String robustness;
        std::optional<WebCore::CDMEncryptionScheme> encryptionScheme;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCDMMediaCapability) == sizeof(WebCore::CDMMediaCapability));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CDMMediaCapability, contentType)
        , offsetof(WebCore::CDMMediaCapability, robustness)
        , offsetof(WebCore::CDMMediaCapability, encryptionScheme)
    >::value);
    encoder << instance.contentType;
    encoder << instance.robustness;
    encoder << instance.encryptionScheme;
}

std::optional<WebCore::CDMMediaCapability> ArgumentCoder<WebCore::CDMMediaCapability>::decode(Decoder& decoder)
{
    auto contentType = decoder.decode<String>();
    auto robustness = decoder.decode<String>();
    auto encryptionScheme = decoder.decode<std::optional<WebCore::CDMEncryptionScheme>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CDMMediaCapability {
            WTFMove(*contentType),
            WTFMove(*robustness),
            WTFMove(*encryptionScheme)
        }
    };
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
void ArgumentCoder<WebCore::CDMRestrictions>::encode(Encoder& encoder, const WebCore::CDMRestrictions& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.distinctiveIdentifierDenied)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.persistentStateDenied)>, bool>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.deniedSessionTypes)>, HashSet<WebCore::CDMSessionType, IntHash<WebCore::CDMSessionType>, WTF::StrongEnumHashTraits<WebCore::CDMSessionType>>>);
    struct ShouldBeSameSizeAsCDMRestrictions : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CDMRestrictions>, false> {
        bool distinctiveIdentifierDenied;
        bool persistentStateDenied;
        HashSet<WebCore::CDMSessionType, IntHash<WebCore::CDMSessionType>, WTF::StrongEnumHashTraits<WebCore::CDMSessionType>> deniedSessionTypes;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCDMRestrictions) == sizeof(WebCore::CDMRestrictions));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CDMRestrictions, distinctiveIdentifierDenied)
        , offsetof(WebCore::CDMRestrictions, persistentStateDenied)
        , offsetof(WebCore::CDMRestrictions, deniedSessionTypes)
    >::value);
    encoder << instance.distinctiveIdentifierDenied;
    encoder << instance.persistentStateDenied;
    encoder << instance.deniedSessionTypes;
}

std::optional<WebCore::CDMRestrictions> ArgumentCoder<WebCore::CDMRestrictions>::decode(Decoder& decoder)
{
    auto distinctiveIdentifierDenied = decoder.decode<bool>();
    auto persistentStateDenied = decoder.decode<bool>();
    auto deniedSessionTypes = decoder.decode<HashSet<WebCore::CDMSessionType, IntHash<WebCore::CDMSessionType>, WTF::StrongEnumHashTraits<WebCore::CDMSessionType>>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CDMRestrictions {
            WTFMove(*distinctiveIdentifierDenied),
            WTFMove(*persistentStateDenied),
            WTFMove(*deniedSessionTypes)
        }
    };
}

#endif

void ArgumentCoder<WebCore::MediaSelectionOption>::encode(Encoder& encoder, const WebCore::MediaSelectionOption& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.mediaType)>, WebCore::MediaSelectionOption::MediaType>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.displayName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.legibleType)>, WebCore::MediaSelectionOption::LegibleType>);
    struct ShouldBeSameSizeAsMediaSelectionOption : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::MediaSelectionOption>, false> {
        WebCore::MediaSelectionOption::MediaType mediaType;
        String displayName;
        WebCore::MediaSelectionOption::LegibleType legibleType;
    };
    static_assert(sizeof(ShouldBeSameSizeAsMediaSelectionOption) == sizeof(WebCore::MediaSelectionOption));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::MediaSelectionOption, mediaType)
        , offsetof(WebCore::MediaSelectionOption, displayName)
        , offsetof(WebCore::MediaSelectionOption, legibleType)
    >::value);
    encoder << instance.mediaType;
    encoder << instance.displayName;
    encoder << instance.legibleType;
}

std::optional<WebCore::MediaSelectionOption> ArgumentCoder<WebCore::MediaSelectionOption>::decode(Decoder& decoder)
{
    auto mediaType = decoder.decode<WebCore::MediaSelectionOption::MediaType>();
    auto displayName = decoder.decode<String>();
    auto legibleType = decoder.decode<WebCore::MediaSelectionOption::LegibleType>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::MediaSelectionOption {
            WTFMove(*mediaType),
            WTFMove(*displayName),
            WTFMove(*legibleType)
        }
    };
}

void ArgumentCoder<WebCore::BufferSource>::encode(Encoder& encoder, const WebCore::BufferSource& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.span())>, std::span<const uint8_t>>);
    encoder << instance.span();
}

std::optional<WebCore::BufferSource> ArgumentCoder<WebCore::BufferSource>::decode(Decoder& decoder)
{
    auto span = decoder.decode<std::span<const uint8_t>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::BufferSource {
            WTFMove(*span)
        }
    };
}

void ArgumentCoder<WebCore::FontShadow>::encode(Encoder& encoder, const WebCore::FontShadow& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.color)>, WebCore::Color>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.offset)>, WebCore::FloatSize>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.blurRadius)>, double>);
    struct ShouldBeSameSizeAsFontShadow : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FontShadow>, false> {
        WebCore::Color color;
        WebCore::FloatSize offset;
        double blurRadius;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFontShadow) == sizeof(WebCore::FontShadow));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FontShadow, color)
        , offsetof(WebCore::FontShadow, offset)
        , offsetof(WebCore::FontShadow, blurRadius)
    >::value);
    encoder << instance.color;
    encoder << instance.offset;
    encoder << instance.blurRadius;
}

std::optional<WebCore::FontShadow> ArgumentCoder<WebCore::FontShadow>::decode(Decoder& decoder)
{
    auto color = decoder.decode<WebCore::Color>();
    auto offset = decoder.decode<WebCore::FloatSize>();
    auto blurRadius = decoder.decode<double>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FontShadow {
            WTFMove(*color),
            WTFMove(*offset),
            WTFMove(*blurRadius)
        }
    };
}

void ArgumentCoder<WebCore::CompositionHighlight>::encode(Encoder& encoder, const WebCore::CompositionHighlight& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.startOffset)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.endOffset)>, unsigned>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.backgroundColor)>, std::optional<WebCore::Color>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.foregroundColor)>, std::optional<WebCore::Color>>);
    struct ShouldBeSameSizeAsCompositionHighlight : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::CompositionHighlight>, false> {
        unsigned startOffset;
        unsigned endOffset;
        std::optional<WebCore::Color> backgroundColor;
        std::optional<WebCore::Color> foregroundColor;
    };
    static_assert(sizeof(ShouldBeSameSizeAsCompositionHighlight) == sizeof(WebCore::CompositionHighlight));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::CompositionHighlight, startOffset)
        , offsetof(WebCore::CompositionHighlight, endOffset)
        , offsetof(WebCore::CompositionHighlight, backgroundColor)
        , offsetof(WebCore::CompositionHighlight, foregroundColor)
    >::value);
    encoder << instance.startOffset;
    encoder << instance.endOffset;
    encoder << instance.backgroundColor;
    encoder << instance.foregroundColor;
}

std::optional<WebCore::CompositionHighlight> ArgumentCoder<WebCore::CompositionHighlight>::decode(Decoder& decoder)
{
    auto startOffset = decoder.decode<unsigned>();
    auto endOffset = decoder.decode<unsigned>();
    auto backgroundColor = decoder.decode<std::optional<WebCore::Color>>();
    auto foregroundColor = decoder.decode<std::optional<WebCore::Color>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::CompositionHighlight {
            WTFMove(*startOffset),
            WTFMove(*endOffset),
            WTFMove(*backgroundColor),
            WTFMove(*foregroundColor)
        }
    };
}

void ArgumentCoder<WebCore::FontChanges>::encode(Encoder& encoder, const WebCore::FontChanges& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_fontName)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_fontFamily)>, String>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_fontSize)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_fontSizeDelta)>, std::optional<double>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_bold)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_italic)>, std::optional<bool>>);
    struct ShouldBeSameSizeAsFontChanges : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FontChanges>, false> {
        String m_fontName;
        String m_fontFamily;
        std::optional<double> m_fontSize;
        std::optional<double> m_fontSizeDelta;
        std::optional<bool> m_bold;
        std::optional<bool> m_italic;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFontChanges) == sizeof(WebCore::FontChanges));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FontChanges, m_fontName)
        , offsetof(WebCore::FontChanges, m_fontFamily)
        , offsetof(WebCore::FontChanges, m_fontSize)
        , offsetof(WebCore::FontChanges, m_fontSizeDelta)
        , offsetof(WebCore::FontChanges, m_bold)
        , offsetof(WebCore::FontChanges, m_italic)
    >::value);
    encoder << instance.m_fontName;
    encoder << instance.m_fontFamily;
    encoder << instance.m_fontSize;
    encoder << instance.m_fontSizeDelta;
    encoder << instance.m_bold;
    encoder << instance.m_italic;
}

std::optional<WebCore::FontChanges> ArgumentCoder<WebCore::FontChanges>::decode(Decoder& decoder)
{
    auto m_fontName = decoder.decode<String>();
    auto m_fontFamily = decoder.decode<String>();
    auto m_fontSize = decoder.decode<std::optional<double>>();
    auto m_fontSizeDelta = decoder.decode<std::optional<double>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;

    if (!(!*m_fontSize || !*m_fontSizeDelta))
        return std::nullopt;
    auto m_bold = decoder.decode<std::optional<bool>>();
    auto m_italic = decoder.decode<std::optional<bool>>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FontChanges {
            WTFMove(*m_fontName),
            WTFMove(*m_fontFamily),
            WTFMove(*m_fontSize),
            WTFMove(*m_fontSizeDelta),
            WTFMove(*m_bold),
            WTFMove(*m_italic)
        }
    };
}

void ArgumentCoder<WebCore::FontAttributeChanges>::encode(Encoder& encoder, const WebCore::FontAttributeChanges& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_verticalAlign)>, std::optional<WebCore::VerticalAlignChange>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_backgroundColor)>, std::optional<WebCore::Color>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_foregroundColor)>, std::optional<WebCore::Color>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_shadow)>, std::optional<WebCore::FontShadow>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_strikeThrough)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_underline)>, std::optional<bool>>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.m_fontChanges)>, WebCore::FontChanges>);
    struct ShouldBeSameSizeAsFontAttributeChanges : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::FontAttributeChanges>, false> {
        std::optional<WebCore::VerticalAlignChange> m_verticalAlign;
        std::optional<WebCore::Color> m_backgroundColor;
        std::optional<WebCore::Color> m_foregroundColor;
        std::optional<WebCore::FontShadow> m_shadow;
        std::optional<bool> m_strikeThrough;
        std::optional<bool> m_underline;
        WebCore::FontChanges m_fontChanges;
    };
    static_assert(sizeof(ShouldBeSameSizeAsFontAttributeChanges) == sizeof(WebCore::FontAttributeChanges));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::FontAttributeChanges, m_verticalAlign)
        , offsetof(WebCore::FontAttributeChanges, m_backgroundColor)
        , offsetof(WebCore::FontAttributeChanges, m_foregroundColor)
        , offsetof(WebCore::FontAttributeChanges, m_shadow)
        , offsetof(WebCore::FontAttributeChanges, m_strikeThrough)
        , offsetof(WebCore::FontAttributeChanges, m_underline)
        , offsetof(WebCore::FontAttributeChanges, m_fontChanges)
    >::value);
    encoder << instance.m_verticalAlign;
    encoder << instance.m_backgroundColor;
    encoder << instance.m_foregroundColor;
    encoder << instance.m_shadow;
    encoder << instance.m_strikeThrough;
    encoder << instance.m_underline;
    encoder << instance.m_fontChanges;
}

std::optional<WebCore::FontAttributeChanges> ArgumentCoder<WebCore::FontAttributeChanges>::decode(Decoder& decoder)
{
    auto m_verticalAlign = decoder.decode<std::optional<WebCore::VerticalAlignChange>>();
    auto m_backgroundColor = decoder.decode<std::optional<WebCore::Color>>();
    auto m_foregroundColor = decoder.decode<std::optional<WebCore::Color>>();
    auto m_shadow = decoder.decode<std::optional<WebCore::FontShadow>>();
    auto m_strikeThrough = decoder.decode<std::optional<bool>>();
    auto m_underline = decoder.decode<std::optional<bool>>();
    auto m_fontChanges = decoder.decode<WebCore::FontChanges>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::FontAttributeChanges {
            WTFMove(*m_verticalAlign),
            WTFMove(*m_backgroundColor),
            WTFMove(*m_foregroundColor),
            WTFMove(*m_shadow),
            WTFMove(*m_strikeThrough),
            WTFMove(*m_underline),
            WTFMove(*m_fontChanges)
        }
    };
}

void ArgumentCoder<WebCore::TextManipulationControllerExclusionRule::ElementRule>::encode(Encoder& encoder, const WebCore::TextManipulationControllerExclusionRule::ElementRule& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.localName)>, AtomString>);
    struct ShouldBeSameSizeAsElementRule : public VirtualTableAndRefCountOverhead<std::is_polymorphic_v<WebCore::TextManipulationControllerExclusionRule::ElementRule>, false> {
        AtomString localName;
    };
    static_assert(sizeof(ShouldBeSameSizeAsElementRule) == sizeof(WebCore::TextManipulationControllerExclusionRule::ElementRule));
    static_assert(MembersInCorrectOrder < 0
        , offsetof(WebCore::TextManipulationControllerExclusionRule::ElementRule, localName)
    >::value);
    encoder << instance.localName;
}

std::optional<WebCore::TextManipulationControllerExclusionRule::ElementRule> ArgumentCoder<WebCore::TextManipulationControllerExclusionRule::ElementRule>::decode(Decoder& decoder)
{
    auto localName = decoder.decode<AtomString>();
    if (UNLIKELY(!decoder.isValid()))
        return std::nullopt;
    return {
        WebCore::TextManipulationControllerExclusionRule::ElementRule {
            WTFMove(*localName)
        }
    };
}

void ArgumentCoder<WebCore::TextManipulationControllerExclusionRule::AttributeRule>::encode(Encoder& encoder, const WebCore::TextManipulationControllerExclusionRule::AttributeRule& instance)
{
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.name)>, AtomString>);
    static_assert(std::is_same_v<std::remove_cvref_t<decltype(instance.value)>, St