/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.MethodInfo;
import java.lang.annotation.Annotation;
import java.util.Arrays;

public class MethodReference {
    private final Object base;
    private final MethodInfo methodInfo;
    private final Annotation[] annotations;
    private final Object[] evaluatedParameters;

    public MethodReference(Object object, MethodInfo methodInfo, Annotation[] annotationArray, Object[] objectArray) {
        this.base = object;
        this.methodInfo = methodInfo;
        this.annotations = annotationArray;
        this.evaluatedParameters = objectArray;
    }

    public Object getBase() {
        return this.base;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Object[] getEvaluatedParameters() {
        return this.evaluatedParameters;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.annotations);
        n = 31 * n + (this.base == null ? 0 : this.base.hashCode());
        n = 31 * n + Arrays.deepHashCode(this.evaluatedParameters);
        n = 31 * n + (this.methodInfo == null ? 0 : this.methodInfo.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MethodReference methodReference = (MethodReference)object;
        if (!Arrays.equals(this.annotations, methodReference.annotations)) {
            return false;
        }
        if (this.base == null ? methodReference.base != null : !this.base.equals(methodReference.base)) {
            return false;
        }
        if (!Arrays.deepEquals(this.evaluatedParameters, methodReference.evaluatedParameters)) {
            return false;
        }
        return !(this.methodInfo == null ? methodReference.methodInfo != null : !this.methodInfo.equals(methodReference.methodInfo));
    }
}

