/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.utils;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.Query;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.neuralsearch.highlight.SemanticHighlightingConstants;
import org.opensearch.neuralsearch.highlight.single.extractor.QueryTextExtractorRegistry;
import org.opensearch.neuralsearch.processor.util.ProcessorUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.highlight.FieldHighlightContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;

public class HighlightExtractorUtils {
    @Generated
    private static final Logger log = LogManager.getLogger(HighlightExtractorUtils.class);

    public static String getFieldText(FieldHighlightContext fieldContext) {
        if (fieldContext.hitContext == null || fieldContext.hitContext.sourceLookup() == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Field %s is not found in the hit", fieldContext.fieldName));
        }
        Object fieldTextObject = fieldContext.hitContext.sourceLookup().extractValue(fieldContext.fieldName, null);
        if (fieldTextObject == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Field %s is not found in the document", fieldContext.fieldName));
        }
        if (!(fieldTextObject instanceof String)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Field %s must be a string for highlighting, but was %s", fieldContext.fieldName, fieldTextObject.getClass().getSimpleName()));
        }
        String fieldTextString = (String)fieldTextObject;
        if (fieldTextString.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Field %s is empty", fieldContext.fieldName));
        }
        return fieldTextString;
    }

    public static String getModelId(Map<String, Object> options) {
        Object modelId = options.get("model_id");
        if (Objects.isNull(modelId) || !(modelId instanceof String)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "model_id must be a non-null string, but was %s", modelId == null ? "null" : modelId.getClass().getSimpleName()));
        }
        return (String)modelId;
    }

    public static String extractOriginalQuery(Query query, String fieldName, QueryTextExtractorRegistry queryTextExtractorRegistry) {
        if (fieldName == null) {
            log.warn("Field name is null, extraction may be less accurate");
        }
        return queryTextExtractorRegistry.extractQueryText(query, fieldName);
    }

    public static String extractSemanticField(HighlightBuilder highlighter) {
        List fields = Optional.ofNullable(highlighter.fields()).orElse(Collections.emptyList());
        return fields.stream().filter(field -> "semantic".equals(field.highlighterType())).findFirst().map(HighlightBuilder.Field::name).orElse(null);
    }

    public static String extractModelId(HighlightBuilder highlighter) {
        Object modelIdValue;
        Map options = highlighter.options();
        if (options != null && options.containsKey("model_id") && (modelIdValue = options.get("model_id")) instanceof String) {
            return (String)modelIdValue;
        }
        for (HighlightBuilder.Field field : highlighter.fields()) {
            Object modelIdValue2;
            Map fieldOptions;
            if (!"semantic".equals(field.highlighterType()) || (fieldOptions = field.options()) == null || !fieldOptions.containsKey("model_id") || !((modelIdValue2 = fieldOptions.get("model_id")) instanceof String)) continue;
            return (String)modelIdValue2;
        }
        return null;
    }

    public static String extractQueryText(SearchRequest request) {
        return Optional.ofNullable(request.source()).map(SearchSourceBuilder::query).map(ProcessorUtils::extractQueryTextFromBuilder).orElse(null);
    }

    public static String extractPreTag(HighlightBuilder highlighter) {
        String[] preTags = highlighter.preTags();
        if (preTags != null && preTags.length > 0) {
            return preTags[0];
        }
        return HighlightExtractorUtils.extractHighlightOption(highlighter, "pre_tag", "<em>");
    }

    public static String extractPostTag(HighlightBuilder highlighter) {
        String[] postTags = highlighter.postTags();
        if (postTags != null && postTags.length > 0) {
            return postTags[0];
        }
        return HighlightExtractorUtils.extractHighlightOption(highlighter, "post_tag", "</em>");
    }

    public static boolean extractBatchInference(HighlightBuilder highlighter) {
        Map options = highlighter.options();
        return HighlightExtractorUtils.extractBatchInferenceFromOptions(options);
    }

    public static boolean extractBatchInferenceFromOptions(Map<String, Object> options) {
        if (options != null && options.containsKey("batch_inference")) {
            Object value = options.get("batch_inference");
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
        }
        return SemanticHighlightingConstants.DEFAULT_BATCH_INFERENCE;
    }

    public static int extractMaxBatchSize(HighlightBuilder highlighter) {
        Map options = highlighter.options();
        if (options != null && options.containsKey("max_batch_size")) {
            Object value = options.get("max_batch_size");
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                try {
                    return Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    log.warn("Invalid {} value: {}, using default", (Object)"max_batch_size", value);
                }
            }
        }
        return 100;
    }

    private static String extractHighlightOption(HighlightBuilder highlighter, String optionKey, String defaultValue) {
        Object optionValue;
        Map options = highlighter.options();
        if (options != null && options.containsKey(optionKey) && (optionValue = options.get(optionKey)) instanceof String) {
            return (String)optionValue;
        }
        for (HighlightBuilder.Field field : highlighter.fields()) {
            Object optionValue2;
            Map fieldOptions;
            if (!"semantic".equals(field.highlighterType()) || (fieldOptions = field.options()) == null || !fieldOptions.containsKey(optionKey) || !((optionValue2 = fieldOptions.get(optionKey)) instanceof String)) continue;
            return (String)optionValue2;
        }
        return defaultValue;
    }
}

