/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Immediate;
import sun.jvm.hotspot.asm.ImmediateOrRegister;
import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.sparc.InstructionDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

class ShiftDecoder
extends InstructionDecoder {
    final int op3;
    final String name;
    final int rtlOperation;

    ShiftDecoder(int op3, String name, int rtlOperation) {
        this.op3 = op3;
        this.name = name;
        this.rtlOperation = rtlOperation;
    }

    private ImmediateOrRegister getShiftLength(int instruction) {
        boolean iBit = ShiftDecoder.isIBitSet(instruction);
        ImmediateOrRegister operand2 = null;
        if (iBit) {
            int value = instruction & 0x1F;
            operand2 = new Immediate(new Short((short)value));
        } else {
            operand2 = SPARCRegisters.getRegister(ShiftDecoder.getSourceRegister2(instruction));
        }
        return operand2;
    }

    @Override
    Instruction decode(int instruction, SPARCInstructionFactory factory) {
        SPARCRegister rs1 = SPARCRegisters.getRegister(ShiftDecoder.getSourceRegister1(instruction));
        SPARCRegister rd = SPARCRegisters.getRegister(ShiftDecoder.getDestinationRegister(instruction));
        ImmediateOrRegister operand2 = this.getShiftLength(instruction);
        return factory.newShiftInstruction(this.name, this.op3, this.rtlOperation, rs1, operand2, rd);
    }
}

