﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotanalytics/IoTAnalytics_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTAnalytics {
namespace Model {

/**
 * <p> A partition dimension defined by a timestamp attribute. </p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/TimestampPartition">AWS
 * API Reference</a></p>
 */
class TimestampPartition {
 public:
  AWS_IOTANALYTICS_API TimestampPartition() = default;
  AWS_IOTANALYTICS_API TimestampPartition(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTANALYTICS_API TimestampPartition& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTANALYTICS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The attribute name of the partition defined by a timestamp. </p>
   */
  inline const Aws::String& GetAttributeName() const { return m_attributeName; }
  inline bool AttributeNameHasBeenSet() const { return m_attributeNameHasBeenSet; }
  template <typename AttributeNameT = Aws::String>
  void SetAttributeName(AttributeNameT&& value) {
    m_attributeNameHasBeenSet = true;
    m_attributeName = std::forward<AttributeNameT>(value);
  }
  template <typename AttributeNameT = Aws::String>
  TimestampPartition& WithAttributeName(AttributeNameT&& value) {
    SetAttributeName(std::forward<AttributeNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The timestamp format of a partition defined by a timestamp. The default
   * format is seconds since epoch (January 1, 1970 at midnight UTC time). </p>
   */
  inline const Aws::String& GetTimestampFormat() const { return m_timestampFormat; }
  inline bool TimestampFormatHasBeenSet() const { return m_timestampFormatHasBeenSet; }
  template <typename TimestampFormatT = Aws::String>
  void SetTimestampFormat(TimestampFormatT&& value) {
    m_timestampFormatHasBeenSet = true;
    m_timestampFormat = std::forward<TimestampFormatT>(value);
  }
  template <typename TimestampFormatT = Aws::String>
  TimestampPartition& WithTimestampFormat(TimestampFormatT&& value) {
    SetTimestampFormat(std::forward<TimestampFormatT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_attributeName;

  Aws::String m_timestampFormat;
  bool m_attributeNameHasBeenSet = false;
  bool m_timestampFormatHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTAnalytics
}  // namespace Aws
