﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace SecurityHub
{
namespace Model
{

  /**
   * <p> Describes the configuration of scanning EBS volumes (Malware Protection) as
   * a data source. </p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails">AWS
   * API Reference</a></p>
   */
  class AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails
  {
  public:
    AWS_SECURITYHUB_API AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails();
    AWS_SECURITYHUB_API AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p> Specifies the reason why scanning EBS volumes (Malware Protection) isn’t
     * activated as a data source. </p>
     */
    inline const Aws::String& GetReason() const{ return m_reason; }

    /**
     * <p> Specifies the reason why scanning EBS volumes (Malware Protection) isn’t
     * activated as a data source. </p>
     */
    inline bool ReasonHasBeenSet() const { return m_reasonHasBeenSet; }

    /**
     * <p> Specifies the reason why scanning EBS volumes (Malware Protection) isn’t
     * activated as a data source. </p>
     */
    inline void SetReason(const Aws::String& value) { m_reasonHasBeenSet = true; m_reason = value; }

    /**
     * <p> Specifies the reason why scanning EBS volumes (Malware Protection) isn’t
     * activated as a data source. </p>
     */
    inline void SetReason(Aws::String&& value) { m_reasonHasBeenSet = true; m_reason = std::move(value); }

    /**
     * <p> Specifies the reason why scanning EBS volumes (Malware Protection) isn’t
     * activated as a data source. </p>
     */
    inline void SetReason(const char* value) { m_reasonHasBeenSet = true; m_reason.assign(value); }

    /**
     * <p> Specifies the reason why scanning EBS volumes (Malware Protection) isn’t
     * activated as a data source. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails& WithReason(const Aws::String& value) { SetReason(value); return *this;}

    /**
     * <p> Specifies the reason why scanning EBS volumes (Malware Protection) isn’t
     * activated as a data source. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails& WithReason(Aws::String&& value) { SetReason(std::move(value)); return *this;}

    /**
     * <p> Specifies the reason why scanning EBS volumes (Malware Protection) isn’t
     * activated as a data source. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails& WithReason(const char* value) { SetReason(value); return *this;}


    /**
     * <p> Describes whether scanning EBS volumes is activated as a data source for the
     * detector. </p>
     */
    inline const Aws::String& GetStatus() const{ return m_status; }

    /**
     * <p> Describes whether scanning EBS volumes is activated as a data source for the
     * detector. </p>
     */
    inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }

    /**
     * <p> Describes whether scanning EBS volumes is activated as a data source for the
     * detector. </p>
     */
    inline void SetStatus(const Aws::String& value) { m_statusHasBeenSet = true; m_status = value; }

    /**
     * <p> Describes whether scanning EBS volumes is activated as a data source for the
     * detector. </p>
     */
    inline void SetStatus(Aws::String&& value) { m_statusHasBeenSet = true; m_status = std::move(value); }

    /**
     * <p> Describes whether scanning EBS volumes is activated as a data source for the
     * detector. </p>
     */
    inline void SetStatus(const char* value) { m_statusHasBeenSet = true; m_status.assign(value); }

    /**
     * <p> Describes whether scanning EBS volumes is activated as a data source for the
     * detector. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails& WithStatus(const Aws::String& value) { SetStatus(value); return *this;}

    /**
     * <p> Describes whether scanning EBS volumes is activated as a data source for the
     * detector. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails& WithStatus(Aws::String&& value) { SetStatus(std::move(value)); return *this;}

    /**
     * <p> Describes whether scanning EBS volumes is activated as a data source for the
     * detector. </p>
     */
    inline AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails& WithStatus(const char* value) { SetStatus(value); return *this;}

  private:

    Aws::String m_reason;
    bool m_reasonHasBeenSet = false;

    Aws::String m_status;
    bool m_statusHasBeenSet = false;
  };

} // namespace Model
} // namespace SecurityHub
} // namespace Aws
