/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.InputStream;
import java.util.Set;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractFileResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResource;
import org.apache.catalina.webresources.VirtualResource;

public class FileResourceSet
extends AbstractFileResourceSet {
    public FileResourceSet() {
        super("/");
    }

    public FileResourceSet(WebResourceRoot webResourceRoot, String string, String string2, String string3) {
        super(string3);
        this.setRoot(webResourceRoot);
        this.setWebAppMount(string);
        this.setBase(string2);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException lifecycleException) {
                throw new IllegalStateException(lifecycleException);
            }
        }
    }

    @Override
    public WebResource getResource(String string) {
        this.checkPath(string);
        String string2 = this.getWebAppMount();
        WebResourceRoot webResourceRoot = this.getRoot();
        if (string.equals(string2)) {
            File file = this.file("", true);
            if (file == null) {
                return new EmptyResource(webResourceRoot, string);
            }
            return new FileResource(webResourceRoot, string, file, this.isReadOnly(), null);
        }
        if (string.charAt(string.length() - 1) != '/') {
            string = string + '/';
        }
        if (string2.startsWith(string)) {
            String string3 = string.substring(0, string.length() - 1);
            if ((string3 = string3.substring(string3.lastIndexOf(47) + 1)).length() > 0) {
                return new VirtualResource(webResourceRoot, string, string3);
            }
        }
        return new EmptyResource(webResourceRoot, string);
    }

    @Override
    public String[] list(String string) {
        String string2;
        this.checkPath(string);
        if (string.charAt(string.length() - 1) != '/') {
            string = string + '/';
        }
        if ((string2 = this.getWebAppMount()).startsWith(string)) {
            if ((string2 = string2.substring(string.length())).equals(this.getFileBase().getName())) {
                return new String[]{this.getFileBase().getName()};
            }
            int n = string2.indexOf(47);
            if (n > 0) {
                return new String[]{string2.substring(0, n)};
            }
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> listWebAppPaths(String string) {
        String string2;
        this.checkPath(string);
        ResourceSet<String> resourceSet = new ResourceSet<String>();
        if (string.charAt(string.length() - 1) != '/') {
            string = string + '/';
        }
        if ((string2 = this.getWebAppMount()).startsWith(string)) {
            if ((string2 = string2.substring(string.length())).equals(this.getFileBase().getName())) {
                resourceSet.add(string + this.getFileBase().getName());
            } else {
                int n = string2.indexOf(47);
                if (n > 0) {
                    resourceSet.add(string + string2.substring(0, n + 1));
                }
            }
        }
        resourceSet.setLocked(true);
        return resourceSet;
    }

    @Override
    public boolean mkdir(String string) {
        this.checkPath(string);
        return false;
    }

    @Override
    public boolean write(String string, InputStream inputStream, boolean bl) {
        this.checkPath(string);
        return false;
    }

    @Override
    protected void checkType(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(sm.getString("fileResourceSet.notFile", new Object[]{this.getBase(), File.separator, this.getInternalPath()}));
        }
    }
}

