/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Tag;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.StringTools;

public class LongSentenceRule
extends TextLevelRule {
    public static final String RULE_ID = "TOO_LONG_SENTENCE";
    private static final Pattern QUOTED_SENT_END = Pattern.compile("[?!.][\"\u201c\u201d\u201e\u00bb\u00ab]", 32);
    private static final Pattern SENT_END = Pattern.compile("[?!.]");
    private static List<String> OPENING_QUOTES = Arrays.asList("\"", "\u201c", "\u201e", "\u00ab", "(", "[", "{", "\u2014");
    private static List<String> CLOSING_QUOTES = Arrays.asList("\"", "\u201d", "\u201c", "\u00bb", ")", "]", "}", "\u2014");
    private final ResourceBundle messages;
    private final int maxWords;

    public LongSentenceRule(ResourceBundle messages, UserConfig userConfig, int maxWords) {
        int confWords;
        this.messages = messages;
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setTags(Collections.singletonList(Tag.picky));
        int tmpMaxWords = maxWords;
        if (userConfig != null && (confWords = userConfig.getConfigValueByID(this.getId())) > 0) {
            tmpMaxWords = confWords;
        }
        this.maxWords = tmpMaxWords;
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(this.messages.getString("long_sentence_rule_desc"), this.maxWords);
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    private boolean isWordCount(String tokenText) {
        if (tokenText.length() > 0) {
            return !StringTools.isNotWordCharacter(tokenText.substring(0, 1));
        }
        return false;
    }

    public String getMessage() {
        return MessageFormat.format(this.messages.getString("long_sentence_rule_msg2"), this.maxWords);
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokens();
            if (tokens.length < this.maxWords) {
                pos += sentence.getCorrectedTextLength();
                continue;
            }
            if (QUOTED_SENT_END.matcher(sentence.getText()).find()) {
                pos += sentence.getCorrectedTextLength();
                continue;
            }
            String msg = this.getMessage();
            ArrayList<Integer> fromPos = new ArrayList<Integer>();
            ArrayList<Integer> toPos = new ArrayList<Integer>();
            AnalyzedTokenReadings fromPosToken = null;
            AnalyzedTokenReadings toPosToken = null;
            int indexOfQuote = -1;
            block1: for (int i = 0; i < tokens.length; ++i) {
                int numWords = 0;
                while (!(i >= tokens.length || tokens[i].getToken().equals(":") || tokens[i].getToken().equals(";") || tokens[i].getToken().equals("\n") || tokens[i].getToken().equals("\r\n") || tokens[i].getToken().equals("\n\r"))) {
                    String token = tokens[i].getToken();
                    if (indexOfQuote == -1 && OPENING_QUOTES.indexOf(token) > -1) {
                        indexOfQuote = OPENING_QUOTES.indexOf(token);
                    } else if (indexOfQuote > -1 && CLOSING_QUOTES.indexOf(token) == indexOfQuote) {
                        indexOfQuote = -1;
                    }
                    if (this.isWordCount(token) && indexOfQuote == -1) {
                        if (fromPosToken == null) {
                            fromPosToken = tokens[i];
                        }
                        if (numWords == this.maxWords) {
                            if (toPosToken == null) {
                                for (int j = tokens.length - 1; j >= 0; --j) {
                                    if (!this.isWordCount(tokens[j].getToken())) continue;
                                    if (tokens.length > j + 1 && SENT_END.matcher(tokens[j + 1].getToken()).matches()) {
                                        toPosToken = tokens[j + 1];
                                        break;
                                    }
                                    toPosToken = tokens[j];
                                    break;
                                }
                            }
                            if (fromPosToken != null && toPosToken != null) {
                                fromPos.add(fromPosToken.getStartPos());
                                toPos.add(toPosToken.getEndPos());
                                continue block1;
                            }
                            fromPos.add(tokens[0].getStartPos());
                            toPos.add(tokens[tokens.length - 1].getEndPos());
                            continue block1;
                        }
                        ++numWords;
                    }
                    ++i;
                }
            }
            for (int j = 0; j < fromPos.size(); ++j) {
                RuleMatch ruleMatch = new RuleMatch(this, sentence, pos + (Integer)fromPos.get(j), pos + (Integer)toPos.get(j), msg);
                ruleMatches.add(ruleMatch);
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }

    @Override
    public int getDefaultValue() {
        return this.maxWords;
    }

    @Override
    public boolean hasConfigurableValue() {
        return true;
    }

    @Override
    public int getMinConfigurableValue() {
        return 5;
    }

    @Override
    public int getMaxConfigurableValue() {
        return 100;
    }

    @Override
    public String getConfigureText() {
        return this.messages.getString("guiLongSentencesText");
    }
}

