/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConnectionMetadata;
import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.RedisURI;
import io.lettuce.core.StaticCredentialsProvider;
import io.lettuce.core.protocol.ProtocolVersion;
import java.util.List;

public class ConnectionState {
    private volatile HandshakeResponse handshakeResponse;
    private volatile RedisCredentialsProvider credentialsProvider;
    private volatile int db;
    private volatile boolean readOnly;
    private volatile ConnectionMetadata connectionMetadata = new ConnectionMetadata();

    public void apply(RedisURI redisURI) {
        this.connectionMetadata.apply(redisURI);
        this.setCredentialsProvider(redisURI.getCredentialsProvider());
    }

    void apply(ConnectionMetadata metadata) {
        this.connectionMetadata.apply(metadata);
    }

    ConnectionMetadata getConnectionMetadata() {
        return this.connectionMetadata;
    }

    public ProtocolVersion getNegotiatedProtocolVersion() {
        return this.handshakeResponse != null ? this.handshakeResponse.getNegotiatedProtocolVersion() : null;
    }

    public Long getConnectionId() {
        return this.handshakeResponse != null ? this.handshakeResponse.getConnectionId() : null;
    }

    public String getRedisVersion() {
        return this.handshakeResponse != null ? this.handshakeResponse.getRedisVersion() : null;
    }

    public String getMode() {
        return this.handshakeResponse != null ? this.handshakeResponse.getMode() : null;
    }

    public String getRole() {
        return this.handshakeResponse != null ? this.handshakeResponse.getRole() : null;
    }

    void setHandshakeResponse(HandshakeResponse handshakeResponse) {
        this.handshakeResponse = handshakeResponse;
    }

    protected void setUserNamePassword(List<char[]> args) {
        if (args.isEmpty()) {
            return;
        }
        this.credentialsProvider = args.size() > 1 ? new StaticCredentialsProvider(new String(args.get(0)), args.get(1)) : new StaticCredentialsProvider(null, args.get(0));
    }

    protected void setCredentialsProvider(RedisCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public RedisCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    protected void setDb(int db) {
        this.db = db;
    }

    int getDb() {
        return this.db;
    }

    protected void setReadOnly(boolean readOnly2) {
        this.readOnly = readOnly2;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setClientName(String clientName) {
        this.connectionMetadata.setClientName(clientName);
    }

    String getClientName() {
        return this.connectionMetadata.getClientName();
    }

    static class HandshakeResponse {
        private final ProtocolVersion negotiatedProtocolVersion;
        private final Long connectionId;
        private final String redisVersion;
        private final String mode;
        private final String role;

        public HandshakeResponse(ProtocolVersion negotiatedProtocolVersion, Long connectionId, String redisVersion, String mode, String role) {
            this.negotiatedProtocolVersion = negotiatedProtocolVersion;
            this.connectionId = connectionId;
            this.redisVersion = redisVersion;
            this.role = role;
            this.mode = mode;
        }

        public ProtocolVersion getNegotiatedProtocolVersion() {
            return this.negotiatedProtocolVersion;
        }

        public Long getConnectionId() {
            return this.connectionId;
        }

        public String getRedisVersion() {
            return this.redisVersion;
        }

        public String getMode() {
            return this.mode;
        }

        public String getRole() {
            return this.role;
        }
    }
}

