/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Tile;
import org.jdesktop.swingx.mapviewer.TileFactory;
import org.jdesktop.swingx.mapviewer.TileFactoryInfo;
import org.jdesktop.swingx.mapviewer.empty.EmptyTileFactory;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXDefaultMapViewer
extends JXMapViewer {
    private static final Logger LOG = Logger.getLogger(JXDefaultMapViewer.class.getName());
    private final boolean isNegativeYAllowed = true;
    private int zoom = 1;
    private Point2D center = new Point2D.Double(0.0, 0.0);
    private boolean drawTileBorders = false;
    private TileFactory factory;
    private GeoPosition addressLocation;
    private boolean panEnabled = true;
    private boolean zoomEnabled = true;
    private boolean recenterOnClickEnabled = true;
    private Painter overlay;
    private boolean designTime;
    private Image loadingImage;
    private boolean restrictOutsidePanning = false;
    private boolean horizontalWrapped = true;
    private boolean drawMapTiles = true;
    private HashMap<String, Tile> currentTiles = new HashMap();
    private HashMap<String, Point> tileWindowCoords = new HashMap();
    private MapBackgroundPainter backgroundPainter;
    private boolean shownOnce = false;
    public int maxextrazoom = 2;
    private volatile boolean needToCalcMapTiles = false;
    private volatile int currentTilesZoom = -10;
    private Rectangle currentTilesBounds = new Rectangle(0, 0, 0, 0);
    private LinkedList<Tile> requiredTiles;
    private final Integer requiredTilesMutex = new Integer(5);
    private TileImageChangeListener tileImageChangeListener = new TileImageChangeListener();
    private volatile boolean ignoreImageUpdates = false;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    public JXDefaultMapViewer() {
        this.factory = new EmptyTileFactory();
        PanMouseInputListener mia = new PanMouseInputListener();
        this.setRecenterOnClickEnabled(false);
        this.addMouseListener(mia);
        this.addMouseMotionListener(mia);
        this.addMouseWheelListener(new ZoomMouseWheelListener());
        this.addKeyListener(new PanKeyListener());
        try {
            URL url = this.getClass().getResource("mapviewer/resources/loading.png");
            this.setLoadingImage(ImageIO.read(url));
        }
        catch (Throwable ex) {
            System.out.println("could not load 'loading.png'");
            BufferedImage img = new BufferedImage(16, 16, 2);
            Graphics2D g2 = img.createGraphics();
            g2.setColor(Color.black);
            g2.fillRect(0, 0, 16, 16);
            g2.dispose();
            this.setLoadingImage(img);
        }
        this.backgroundPainter = new MapBackgroundPainter();
        this.setBackgroundPainter((Painter)this.backgroundPainter);
    }

    @Override
    public final String getUniqueViewName() {
        return this.getName();
    }

    private void doPaintComponent(Graphics g) {
        if (!this.isDesignTime()) {
            int zoom = this.getZoom();
            Rectangle viewportBounds = this.getViewportBounds();
            this.drawMapTiles(g, zoom, viewportBounds);
            this.drawOverlays(zoom, g, viewportBounds);
        }
        super.paintBorder(g);
    }

    private void needsRepaint() {
        if (this.backgroundPainter != null) {
            this.backgroundPainter.needRepaint();
        }
        this.repaint(20L);
    }

    @Override
    public void setDesignTime(boolean b) {
        this.designTime = b;
    }

    @Override
    public boolean isDesignTime() {
        return this.designTime;
    }

    private int getTileSize(int zoom) {
        return this.getTileFactory().getTileSize(zoom);
    }

    private Point2D geoToPixel(GeoPosition pos, int zoom) {
        return this.getTileFactory().geoToPixel(pos, zoom);
    }

    public GeoPosition pixelToGeo(Point2D p, int zoom) {
        return this.getTileFactory().pixelToGeo(p, zoom);
    }

    private Dimension getMapSize(int zoom) {
        return this.getTileFactory().getMapSize(zoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawMapTiles(Graphics g, int zoom, Rectangle viewportBounds) {
        try {
            boolean hasTiles;
            if (!this.drawMapTiles) {
                return;
            }
            if (this.needToCalcMapTiles) {
                this.calcRequiredTiles();
            }
            Integer n = this.requiredTilesMutex;
            synchronized (n) {
                hasTiles = this.requiredTiles != null;
            }
            if (hasTiles) {
                this.requestMapTiles();
            }
            this.shownOnce = true;
            int tileSize = this.getTileSize(zoom);
            for (Tile tile : this.currentTiles.values()) {
                Point point;
                Integer n2 = this.requiredTilesMutex;
                synchronized (n2) {
                    point = this.tileWindowCoords.get(tile.getKey());
                }
                if (point == null) continue;
                BufferedImage tileImage = tile.getImage();
                if (tileImage == null) {
                    if (this.isOpaque()) {
                        g.setColor(this.getBackground());
                        g.fillRect(point.x, point.y, tileSize, tileSize);
                    }
                } else {
                    g.drawImage(tileImage, point.x, point.y, tileSize, tileSize, null);
                }
                if (!this.isDrawTileBorders()) continue;
                g.setColor(Color.black);
                g.drawRect(point.x, point.y, tileSize, tileSize);
                g.drawRect(point.x + tileSize / 2 - 5, point.y + tileSize / 2 - 5, 10, 10);
                g.setColor(Color.white);
                g.drawRect(point.x + 1, point.y + 1, tileSize, tileSize);
                String text = tile.getX() + ", " + tile.getY() + ", " + zoom;
                g.setColor(Color.black);
                g.drawString(text, point.x + 10, point.y + 30);
                g.drawString(text, point.x + 10 + 2, point.y + 30 + 2);
                g.setColor(Color.white);
                g.drawString(text, point.x + 10 + 1, point.y + 30 + 1);
            }
        }
        catch (ConcurrentModificationException e) {
            this.repaint();
        }
    }

    private void drawOverlays(int zoom, Graphics g, Rectangle viewportBounds) {
        if (this.overlay != null) {
            this.overlay.paint((Graphics2D)g, (Object)this, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void setOverlayPainter(Painter overlay) {
        Painter old = this.getOverlayPainter();
        this.overlay = overlay;
        this.firePropertyChange("mapOverlay", old, this.getOverlayPainter());
        this.needsRepaint();
    }

    @Override
    public Painter getOverlayPainter() {
        return this.overlay;
    }

    @Override
    public Rectangle getViewportBounds() {
        return this.calculateViewportBounds(this.getCenter());
    }

    private Rectangle calculateViewportBounds(Point2D center) {
        Insets insets = this.getInsets();
        int viewportWidth = this.getWidth() - insets.left - insets.right;
        int viewportHeight = this.getHeight() - insets.top - insets.bottom;
        double viewportX = center.getX() - (double)(viewportWidth / 2);
        double viewportY = center.getY() - (double)(viewportHeight / 2);
        return new Rectangle((int)viewportX, (int)viewportY, viewportWidth, viewportHeight);
    }

    @Override
    public void setRecenterOnClickEnabled(boolean b) {
        boolean old = this.isRecenterOnClickEnabled();
        this.recenterOnClickEnabled = b;
        this.firePropertyChange("recenterOnClickEnabled", old, this.isRecenterOnClickEnabled());
    }

    @Override
    public boolean isRecenterOnClickEnabled() {
        return this.recenterOnClickEnabled;
    }

    @Override
    public void setZoom(int newZoom) {
        this.setZoom(this.getCenter(), newZoom);
    }

    @Override
    public void setZoom(Point2D zoomCenter, int newZoom) {
        TileFactoryInfo info = this.getTileFactory().getInfo();
        if (info != null && (newZoom < info.getMinimumZoomLevel() - this.maxextrazoom || newZoom > info.getMaximumZoomLevel())) {
            if (newZoom > info.getMaximumZoomLevel()) {
                newZoom = info.getMaximumZoomLevel();
            } else if (newZoom < info.getMinimumZoomLevel() - this.maxextrazoom) {
                newZoom = info.getMinimumZoomLevel() - this.maxextrazoom;
            }
        }
        int oldZoom = this.zoom;
        Point2D oldCenter = this.getCenter();
        double xOffset = oldCenter.getX() - zoomCenter.getX();
        double yOffset = oldCenter.getY() - zoomCenter.getY();
        Dimension oldMapSize = this.getMapSize(oldZoom);
        Dimension mapSize = this.getMapSize(newZoom);
        this.setZoomAndCenter(new Point2D.Double(xOffset + zoomCenter.getX() * (mapSize.getWidth() / oldMapSize.getWidth()), yOffset + zoomCenter.getY() * (mapSize.getHeight() / oldMapSize.getHeight())), newZoom);
    }

    @Override
    public void setZoomAndCenter(Point2D center, int newZoom) {
        if (newZoom != this.zoom) {
            int oldZoom = this.zoom;
            this.zoom = newZoom;
            this.firePropertyChange("zoom", oldZoom, newZoom);
            this.needsRepaint();
        }
        this.setCenter(center);
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public GeoPosition getAddressLocation() {
        return this.addressLocation;
    }

    @Override
    public void setAddressLocation(GeoPosition addressLocation) {
        GeoPosition old = this.getAddressLocation();
        this.addressLocation = addressLocation;
        this.setCenter(this.geoToPixel(addressLocation, this.getZoom()));
        this.firePropertyChange("addressLocation", old, this.getAddressLocation());
    }

    @Override
    public void recenterToAddressLocation() {
        this.setCenter(this.geoToPixel(this.getAddressLocation(), this.getZoom()));
    }

    @Override
    public boolean isDrawTileBorders() {
        return this.drawTileBorders;
    }

    @Override
    public void setDrawTileBorders(boolean drawTileBorders) {
        boolean old = this.isDrawTileBorders();
        this.drawTileBorders = drawTileBorders;
        this.firePropertyChange("drawTileBorders", old, this.isDrawTileBorders());
        this.needsRepaint();
    }

    @Override
    public boolean isPanEnabled() {
        return this.panEnabled;
    }

    @Override
    public void setPanEnabled(boolean panEnabled) {
        boolean old = this.isPanEnabled();
        this.panEnabled = panEnabled;
        this.firePropertyChange("panEnabled", old, this.isPanEnabled());
    }

    @Override
    public boolean isZoomEnabled() {
        return this.zoomEnabled;
    }

    @Override
    public void setZoomEnabled(boolean zoomEnabled) {
        boolean old = this.isZoomEnabled();
        this.zoomEnabled = zoomEnabled;
        this.firePropertyChange("zoomEnabled", old, this.isZoomEnabled());
    }

    @Override
    public void setCenterPosition(GeoPosition geoPosition) {
        GeoPosition oldVal = this.getCenterPosition();
        this.setCenter(this.geoToPixel(geoPosition, this.zoom));
        GeoPosition newVal = this.getCenterPosition();
        this.firePropertyChange("centerPosition", oldVal, newVal);
    }

    @Override
    public GeoPosition getCenterPosition() {
        return this.pixelToGeo(this.getCenter(), this.zoom);
    }

    @Override
    public TileFactory getTileFactory() {
        return this.factory;
    }

    @Override
    public void setTileFactory(TileFactory factory) {
        if (this.factory != null) {
            this.factory.removeRequiredTiles(this.getUniqueViewName());
            this.factory = null;
        }
        this.factory = factory;
        this.setZoom(factory.getInfo().getDefaultZoomLevel());
    }

    @Override
    public Image getLoadingImage() {
        return this.loadingImage;
    }

    @Override
    public void setLoadingImage(Image loadingImage) {
        this.loadingImage = loadingImage;
    }

    @Override
    public Point2D getCenter() {
        return this.center;
    }

    @Override
    public void setCenter(Point2D newCenter) {
        if (newCenter.equals(this.center)) {
            return;
        }
        Point2D oldCenter = this.center;
        if (this.isRestrictOutsidePanning()) {
            double centerX;
            Insets insets = this.getInsets();
            int viewportHeight = this.getHeight() - insets.top - insets.bottom;
            int viewportWidth = this.getWidth() - insets.left - insets.right;
            Rectangle newVP = this.calculateViewportBounds(newCenter);
            if (newVP.getY() < 0.0) {
                double centerY = viewportHeight / 2;
                newCenter = new Point2D.Double(newCenter.getX(), centerY);
            }
            if (!this.isHorizontalWrapped() && newVP.getX() < 0.0) {
                double centerX2 = viewportWidth / 2;
                newCenter = new Point2D.Double(centerX2, newCenter.getY());
            }
            Dimension mapSize = this.getMapSize(this.getZoom());
            int mapHeight = (int)mapSize.getHeight() * this.getTileSize(this.getZoom());
            if (newVP.getY() + newVP.getHeight() > (double)mapHeight) {
                double centerY = mapHeight - viewportHeight / 2;
                newCenter = new Point2D.Double(newCenter.getX(), centerY);
            }
            int mapWidth = (int)mapSize.getWidth() * this.getTileSize(this.getZoom());
            if (!this.isHorizontalWrapped() && newVP.getX() + newVP.getWidth() > (double)mapWidth) {
                centerX = mapWidth - viewportWidth / 2;
                newCenter = new Point2D.Double(centerX, newCenter.getY());
            }
            if ((double)mapHeight < newVP.getHeight()) {
                double centerY = mapHeight / 2;
                newCenter = new Point2D.Double(newCenter.getX(), centerY);
            }
            if (!this.isHorizontalWrapped() && (double)mapWidth < newVP.getWidth()) {
                centerX = mapWidth / 2;
                newCenter = new Point2D.Double(centerX, newCenter.getY());
            }
        }
        GeoPosition oldGP = this.getCenterPosition();
        this.center = newCenter;
        this.firePropertyChange("center", oldCenter, this.center);
        this.firePropertyChange("centerPosition", oldGP, this.getCenterPosition());
        this.calcRequiredTiles();
        this.needsRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcRequiredTiles() {
        block17: {
            try {
                int z_zoom = this.getZoom();
                int tileSize = this.getTileSize(z_zoom);
                boolean sameTiles = false;
                this.needToCalcMapTiles = false;
                Rectangle viewportBounds = this.getViewportBounds();
                Integer n = this.requiredTilesMutex;
                synchronized (n) {
                    if (z_zoom == this.currentTilesZoom && this.currentTilesBounds.contains(viewportBounds)) {
                        sameTiles = true;
                    }
                    this.tileWindowCoords.clear();
                }
                this.ignoreImageUpdates = true;
                int topLeftTile_MapTileIndex_X = viewportBounds.x / tileSize;
                int topLeftTile_MapTileIndex_Y = viewportBounds.y / tileSize;
                int numWide = (viewportBounds.x + viewportBounds.width - topLeftTile_MapTileIndex_X * tileSize) / tileSize + 1;
                int numHigh = (viewportBounds.y + viewportBounds.height - topLeftTile_MapTileIndex_Y * tileSize) / tileSize + 1;
                this.currentTilesBounds = new Rectangle(topLeftTile_MapTileIndex_X * tileSize, topLeftTile_MapTileIndex_Y * tileSize, numWide * tileSize, numHigh * tileSize);
                LinkedList<Tile> newRequiredTiles = new LinkedList<Tile>();
                for (int currentTile_WindowTileIndex_X = 0; currentTile_WindowTileIndex_X < numWide; ++currentTile_WindowTileIndex_X) {
                    for (int currentTile_WindowTileIndex_Y = 0; currentTile_WindowTileIndex_Y < numHigh; ++currentTile_WindowTileIndex_Y) {
                        Tile tile;
                        int currentTile_MapTileIndex_X = currentTile_WindowTileIndex_X + topLeftTile_MapTileIndex_X;
                        int currentTile_MapTileIndex_Y = currentTile_WindowTileIndex_Y + topLeftTile_MapTileIndex_Y;
                        int currentTile_WindowCoordsX = currentTile_MapTileIndex_X * tileSize - viewportBounds.x;
                        int currentTile_WindowCoordsY = currentTile_MapTileIndex_Y * tileSize - viewportBounds.y;
                        Integer n2 = this.requiredTilesMutex;
                        synchronized (n2) {
                            tile = this.currentTiles.get(this.getTileFactory().getTileKey(currentTile_MapTileIndex_X, currentTile_MapTileIndex_Y, this.zoom));
                        }
                        if (tile == null) {
                            tile = this.getTileFactory().getTileInstance(currentTile_MapTileIndex_X, currentTile_MapTileIndex_Y, this.zoom);
                            tile.addPropertyChangeListener("image", this.tileImageChangeListener);
                        }
                        newRequiredTiles.add(tile);
                        Point pt = new Point(currentTile_WindowCoordsX, currentTile_WindowCoordsY);
                        this.tileWindowCoords.put(tile.getKey(), pt);
                    }
                }
                if (sameTiles) break block17;
                Integer n3 = this.requiredTilesMutex;
                synchronized (n3) {
                    this.currentTiles.clear();
                    for (Tile tile : newRequiredTiles) {
                        this.currentTiles.put(tile.getKey(), tile);
                    }
                    this.requiredTiles = newRequiredTiles;
                    this.currentTilesZoom = z_zoom;
                }
                if (this.shownOnce) {
                    this.requestMapTiles();
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "During update of needed tiles", e);
            }
        }
        this.ignoreImageUpdates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMapTiles() {
        Integer n = this.requiredTilesMutex;
        synchronized (n) {
            if (this.requiredTiles != null) {
                this.factory.setRequiredTiles(this.requiredTiles, this.getUniqueViewName());
                this.requiredTiles = null;
            }
        }
    }

    @Override
    public void calculateZoomFrom(Set<GeoPosition> positions) {
        Point2D.Double newCenter;
        if (positions.size() < 1) {
            return;
        }
        int newZoom = this.getTileFactory().getInfo().getMinimumZoomLevel() - this.maxextrazoom;
        Rectangle2D rect = this.generateBoundingRect(positions, newZoom);
        while (!this.calculateViewportBounds(newCenter = new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0)).contains(rect)) {
            if (++newZoom > this.getTileFactory().getInfo().getMaximumZoomLevel()) {
                newZoom = this.getTileFactory().getInfo().getMaximumZoomLevel();
                break;
            }
            rect = this.generateBoundingRect(positions, newZoom);
        }
        this.setZoomAndCenter(newCenter, newZoom);
    }

    private Rectangle2D generateBoundingRect(Set<GeoPosition> positions, int zoom) {
        Dimension mapSize = this.getMapSize(zoom);
        Rectangle2D rect = null;
        int ts = this.getTileSize(zoom);
        double mapHeight = mapSize.getHeight() * (double)ts;
        double mapWidth = mapSize.getWidth() * (double)ts;
        Rectangle2D.Double view = new Rectangle2D.Double(0.0, 0.0, mapWidth, mapHeight);
        for (GeoPosition pos : positions) {
            Point2D point = this.geoToPixel(pos, zoom);
            if (!view.contains(point)) continue;
            if (rect == null) {
                rect = new Rectangle2D.Double(point.getX(), point.getY(), 1.0, 1.0);
                continue;
            }
            rect.add(point);
        }
        if (rect == null) {
            return view;
        }
        return rect;
    }

    private Point2D convertPointToPoint2D(Point p) {
        Rectangle bounds = this.getViewportBounds();
        double x = bounds.getX() + p.getX();
        double y = bounds.getY() + p.getY();
        return new Point2D.Double(x, y);
    }

    @Override
    public boolean isRestrictOutsidePanning() {
        return this.restrictOutsidePanning;
    }

    @Override
    public void setRestrictOutsidePanning(boolean restrictOutsidePanning) {
        this.restrictOutsidePanning = restrictOutsidePanning;
    }

    @Override
    public boolean isHorizontalWrapped() {
        return this.horizontalWrapped;
    }

    @Override
    public void setHorizontalWrapped(boolean horizontalWrapped) {
        this.horizontalWrapped = horizontalWrapped;
    }

    @Override
    public void setDrawMapTiles(boolean drawMapTiles) {
        this.drawMapTiles = drawMapTiles;
    }

    @Override
    public boolean isDrawMapTiles() {
        return this.drawMapTiles;
    }

    @Override
    public Point2D convertGeoPositionToPoint(GeoPosition pos) {
        Point2D pt = this.geoToPixel(pos, this.getZoom());
        Rectangle bounds = this.getViewportBounds();
        return new Point2D.Double(pt.getX() - bounds.getX(), pt.getY() - bounds.getY());
    }

    @Override
    public GeoPosition convertPointToGeoPosition(Point2D pt) {
        Rectangle bounds = this.getViewportBounds();
        Point2D.Double pt2 = new Point2D.Double(pt.getX() + bounds.getX(), pt.getY() + bounds.getY());
        GeoPosition pos = this.getTileFactory().pixelToGeo(pt2, this.getZoom());
        return pos;
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.needToCalcMapTiles = true;
            this.needsRepaint();
        }
    }

    static {
        LOG.setLevel(Level.SEVERE);
    }

    private class ZoomMouseWheelListener
    implements MouseWheelListener {
        private ZoomMouseWheelListener() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (JXDefaultMapViewer.this.isZoomEnabled()) {
                JXDefaultMapViewer.this.setZoom(JXDefaultMapViewer.this.convertPointToPoint2D(e.getPoint()), JXDefaultMapViewer.this.getZoom() + e.getWheelRotation());
            }
        }
    }

    private class PanMouseInputListener
    implements MouseInputListener {
        Point prev;

        private PanMouseInputListener() {
        }

        public void mousePressed(MouseEvent evt) {
            this.prev = evt.getPoint();
            if (JXDefaultMapViewer.this.isRecenterOnClickEnabled() && (SwingUtilities.isMiddleMouseButton(evt) || SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2)) {
                this.recenterMap(evt);
            }
        }

        private void recenterMap(MouseEvent evt) {
            JXDefaultMapViewer.this.setCenter(JXDefaultMapViewer.this.convertPointToPoint2D(evt.getPoint()));
        }

        public void mouseDragged(MouseEvent evt) {
            if (JXDefaultMapViewer.this.isPanEnabled() && this.prev != null) {
                int maxHeight;
                Point current = evt.getPoint();
                double x = JXDefaultMapViewer.this.getCenter().getX() - (double)(current.x - this.prev.x);
                double y = JXDefaultMapViewer.this.getCenter().getY() - (double)(current.y - this.prev.y);
                if (y > (double)(maxHeight = (int)(JXDefaultMapViewer.this.getMapSize(JXDefaultMapViewer.this.getZoom()).getHeight() * (double)JXDefaultMapViewer.this.getTileSize(JXDefaultMapViewer.this.getZoom())))) {
                    y = maxHeight;
                }
                this.prev = current;
                JXDefaultMapViewer.this.setCenter(new Point2D.Double(x, y));
                JXDefaultMapViewer.this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }

        public void mouseReleased(MouseEvent evt) {
            this.prev = null;
            JXDefaultMapViewer.this.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseMoved(MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JXDefaultMapViewer.this.requestFocusInWindow();
                }
            });
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    private class PanKeyListener
    extends KeyAdapter {
        private static final int OFFSET = 10;
        private static final int MULTIPLIER = 10;

        private PanKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
            int oldzoom;
            super.keyTyped(e);
            int newzoom = oldzoom = JXDefaultMapViewer.this.getZoom();
            switch (e.getKeyChar()) {
                case '+': {
                    --newzoom;
                    break;
                }
                case '-': {
                    ++newzoom;
                }
            }
            if (newzoom != oldzoom) {
                JXDefaultMapViewer.this.setZoom(newzoom);
            }
        }

        public void keyPressed(KeyEvent e) {
            int delta_x = 0;
            int delta_y = 0;
            switch (e.getKeyCode()) {
                case 37: {
                    delta_x = -10;
                    break;
                }
                case 39: {
                    delta_x = 10;
                    break;
                }
                case 38: {
                    delta_y = -10;
                    break;
                }
                case 40: {
                    delta_y = 10;
                }
            }
            if (delta_x != 0 || delta_y != 0) {
                int mod = e.getModifiers();
                if ((mod & 2) != 0 || (mod & 0x80) != 0) {
                    delta_x *= 10;
                    delta_y *= 10;
                }
                if ((mod & 1) != 0 || (mod & 0x40) != 0) {
                    delta_x *= 10;
                    delta_y *= 10;
                }
                Rectangle bounds = JXDefaultMapViewer.this.getViewportBounds();
                double x = bounds.getCenterX() + (double)delta_x;
                double y = bounds.getCenterY() + (double)delta_y;
                JXDefaultMapViewer.this.setCenter(new Point2D.Double(x, y));
            }
        }
    }

    private final class TileImageChangeListener
    implements PropertyChangeListener {
        private TileImageChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!JXDefaultMapViewer.this.ignoreImageUpdates) {
                Tile tile = (Tile)((Object)evt.getSource());
                if (!JXDefaultMapViewer.this.currentTiles.containsKey(tile.getKey())) {
                    return;
                }
                JXDefaultMapViewer.this.needsRepaint();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapBackgroundPainter
    extends AbstractPainter<JXPanel> {
        private int prevWidth = 0;
        private int prevHeight = 0;

        private MapBackgroundPainter() {
        }

        protected void doPaint(Graphics2D g, JXPanel component, int width, int height) {
            if (this.prevWidth != width || this.prevHeight != height) {
                this.prevWidth = width;
                this.prevHeight = height;
                JXDefaultMapViewer.this.needToCalcMapTiles = true;
            }
            JXDefaultMapViewer.this.doPaintComponent(g);
        }

        public void needRepaint() {
            if (!this.isDirty()) {
                this.setDirty(true);
            }
        }
    }
}

