/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.db.DatabaseServer;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlDatabaseServer;

public class HsqldbDatabaseServer
extends SqlDatabaseServer
implements DatabaseServer {
    public static final int DEFAULT_SERVER_PORT = 9001;
    private static final Logger logger = LogManager.getLogger(HsqldbDatabaseServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqldbDatabaseServer(String dbname) throws ClassNotFoundException, Exception {
        super(dbname);
        dbname = dbname.replaceAll("\\\\", "/");
        boolean doCompact = false;
        File propsFile = new File(dbname + ".properties");
        if (propsFile.exists()) {
            Properties dbProps = new Properties();
            FileInputStream propsStream = null;
            try {
                propsStream = new FileInputStream(propsFile);
                dbProps.load(propsStream);
            }
            finally {
                block12: {
                    try {
                        if (propsStream != null) {
                            ((InputStream)propsStream).close();
                        }
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
            String version = (String)dbProps.get("version");
            if (version.charAt(0) < '2') {
                doCompact = true;
            }
        }
        this.setDbUrl("jdbc:hsqldb:file:" + dbname);
        this.setDbUser(DbSQL.getSingleton().getDbUser());
        this.setDbPassword(DbSQL.getSingleton().getDbPassword());
        if (doCompact) {
            this.shutdown(true);
        }
    }

    @Override
    void shutdown(boolean compact) throws SQLException {
        super.shutdown(compact);
        Connection conn = this.getNewConnection();
        CallableStatement psCompact = null;
        psCompact = compact ? conn.prepareCall("SHUTDOWN COMPACT") : conn.prepareCall("SHUTDOWN");
        psCompact.execute();
        psCompact.close();
        conn.close();
    }
}

