/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;

public class ProtocolDefaultsServiceConfigurator
extends SimpleServiceNameProvider
implements ServiceConfigurator,
ProtocolDefaults,
Supplier<ProtocolDefaults> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jgroups", "defaults"});
    private static final String DEFAULTS = "jgroups-defaults.xml";
    private final String resource;
    private final Map<Class<? extends Protocol>, Map<String, String>> map = new IdentityHashMap<Class<? extends Protocol>, Map<String, String>>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ProtocolStackConfigurator load(String resource) throws IllegalStateException {
        URL url = ProtocolDefaultsServiceConfigurator.find(resource, JGroupsExtension.class.getClassLoader());
        JGroupsLogger.ROOT_LOGGER.debugf("Loading JGroups protocol defaults from %s", url.toString());
        try (InputStream input = url.openStream();){
            XmlConfigurator xmlConfigurator = XmlConfigurator.getInstance((InputStream)input);
            return xmlConfigurator;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(JGroupsLogger.ROOT_LOGGER.parserFailure(url));
        }
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(JGroupsLogger.ROOT_LOGGER.notFound(resource));
    }

    public ProtocolDefaultsServiceConfigurator() {
        this(DEFAULTS);
    }

    public ProtocolDefaultsServiceConfigurator(String resource) {
        super(SERVICE_NAME);
        this.resource = resource;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(SERVICE_NAME).build(target);
        Consumer defaults = builder.provides(new ServiceName[]{SERVICE_NAME});
        FunctionalService service = new FunctionalService(defaults, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public ProtocolDefaults get() {
        ProtocolStackConfigurator configurator = ProtocolDefaultsServiceConfigurator.load(this.resource);
        try {
            for (ProtocolConfiguration config : configurator.getProtocolStack()) {
                String protocolClassName = String.join((CharSequence)".", "org.jgroups.protocols", config.getProtocolName());
                Class<Protocol> protocolClass = Protocol.class.getClassLoader().loadClass(protocolClassName).asSubclass(Protocol.class);
                this.map.put(protocolClass, Collections.unmodifiableMap(config.getProperties()));
            }
            return this;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Map<String, String> getProperties(Class<? extends Protocol> protocolClass) {
        Map<String, String> properties = this.map.get(protocolClass);
        return properties != null ? Collections.unmodifiableMap(properties) : Collections.emptyMap();
    }
}

