/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.callback.SocketAddressQueryCallbackHandler;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class SocketAddressCallbackSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final SocketAddress localAddress;
    private final SocketAddress peerAddress;

    public SocketAddressCallbackSaslClientFactory(SaslClientFactory delegate, SocketAddress localAddress, SocketAddress peerAddress) {
        super(delegate);
        this.localAddress = localAddress;
        this.peerAddress = peerAddress;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, (CallbackHandler)new SocketAddressQueryCallbackHandler(cbh, this.localAddress, this.peerAddress));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SocketAddressCallbackSaslClientFactory && this.equals((SocketAddressCallbackSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof SocketAddressCallbackSaslClientFactory && this.equals((SocketAddressCallbackSaslClientFactory)other);
    }

    public boolean equals(SocketAddressCallbackSaslClientFactory other) {
        return super.equals(other) && Objects.equals(this.localAddress, other.localAddress) && Objects.equals(this.peerAddress, other.peerAddress);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)super.calculateHashCode(), (int)this.getClass().hashCode()), (int)Objects.hashCode(this.localAddress)), (int)Objects.hashCode(this.peerAddress));
    }
}

