/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SignatureAlgorithm {
    public static final SignatureAlgorithm ES256 = new SignatureAlgorithm("SHA256withECDSA", "SHA-256");
    public static final SignatureAlgorithm ES384 = new SignatureAlgorithm("SHA384withECDSA", "SHA-384");
    public static final SignatureAlgorithm ES512 = new SignatureAlgorithm("SHA512withECDSA", "SHA-512");
    public static final SignatureAlgorithm RS1 = new SignatureAlgorithm("SHA1withRSA", "SHA-1");
    public static final SignatureAlgorithm RS256 = new SignatureAlgorithm("SHA256withRSA", "SHA-256");
    public static final SignatureAlgorithm RS384 = new SignatureAlgorithm("SHA384withRSA", "SHA-384");
    public static final SignatureAlgorithm RS512 = new SignatureAlgorithm("SHA512withRSA", "SHA-512");
    private static final Map<COSEAlgorithmIdentifier, SignatureAlgorithm> predefinedAlgorithmMap = new HashMap<COSEAlgorithmIdentifier, SignatureAlgorithm>();
    private final String jcaName;
    private final String messageDigestJcaName;

    private SignatureAlgorithm(String jcaName, String messageDigestJcaName) {
        this.jcaName = jcaName;
        this.messageDigestJcaName = messageDigestJcaName;
    }

    public static SignatureAlgorithm create(COSEAlgorithmIdentifier coseAlgorithmIdentifier) {
        SignatureAlgorithm signatureAlgorithm = predefinedAlgorithmMap.get(coseAlgorithmIdentifier);
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException("provided algorithm is not supported.");
        }
        return signatureAlgorithm;
    }

    public String getJcaName() {
        return this.jcaName;
    }

    public String getMessageDigestJcaName() {
        return this.messageDigestJcaName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureAlgorithm that = (SignatureAlgorithm)o;
        return Objects.equals(this.jcaName, that.jcaName) && Objects.equals(this.messageDigestJcaName, that.messageDigestJcaName);
    }

    public int hashCode() {
        return Objects.hash(this.jcaName, this.messageDigestJcaName);
    }

    static {
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.ES256, ES256);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.ES384, ES384);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.ES512, ES512);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.RS1, RS1);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.RS256, RS256);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.RS384, RS384);
        predefinedAlgorithmMap.put(COSEAlgorithmIdentifier.RS512, RS512);
    }
}

