/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.authorization.admin.AuthorizationService;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientregistration.ClientRegistrationTokenUtils;
import org.keycloak.services.clientregistration.policy.RegistrationAuth;
import org.keycloak.services.managers.ClientManager;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.ClientAttributeCertificateResource;
import org.keycloak.services.resources.admin.ClientScopeEvaluateResource;
import org.keycloak.services.resources.admin.ProtocolMappersResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.ScopeMappedResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.services.validation.ClientValidator;
import org.keycloak.services.validation.PairwiseClientValidator;
import org.keycloak.services.validation.ValidationMessages;
import org.keycloak.validation.ClientValidationUtil;

public class ClientResource {
    protected static final Logger logger = Logger.getLogger(ClientResource.class);
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;
    private AdminEventBuilder adminEvent;
    protected ClientModel client;
    protected KeycloakSession session;
    @Context
    protected KeycloakApplication keycloak;
    @Context
    protected ClientConnection clientConnection;

    protected KeycloakApplication getKeycloakApplication() {
        return this.keycloak;
    }

    public ClientResource(RealmModel realm, AdminPermissionEvaluator auth, ClientModel clientModel, KeycloakSession session, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.auth = auth;
        this.client = clientModel;
        this.session = session;
        this.adminEvent = adminEvent.resource(ResourceType.CLIENT);
    }

    @Path(value="protocol-mappers")
    public ProtocolMappersResource getProtocolMappers() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.client);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.client);
        ProtocolMappersResource mappers = new ProtocolMappersResource(this.realm, (ProtocolMapperContainerModel)this.client, this.auth, this.adminEvent, manageCheck, viewCheck);
        ResteasyProviderFactory.getInstance().injectProperties((Object)mappers);
        return mappers;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(ClientRepresentation rep) {
        this.auth.clients().requireConfigure(this.client);
        ValidationMessages validationMessages = new ValidationMessages();
        if (!ClientValidator.validate(rep, validationMessages) || !PairwiseClientValidator.validate(this.session, rep, validationMessages)) {
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(validationMessages.getStringMessages(), validationMessages.getStringMessages(messages), Response.Status.BAD_REQUEST);
        }
        try {
            this.updateClientFromRep(rep, this.client, this.session);
            ClientValidationUtil.validate((KeycloakSession)this.session, (ClientModel)this.client, (boolean)false, c -> {
                this.session.getTransactionManager().setRollbackOnly();
                throw new ErrorResponseException("invalid_input", c.getError(), Response.Status.BAD_REQUEST);
            });
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return ErrorResponse.exists("Client already exists");
        }
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public ClientRepresentation getClient() {
        this.auth.clients().requireView(this.client);
        ClientRepresentation representation = ModelToRepresentation.toRepresentation((ClientModel)this.client, (KeycloakSession)this.session);
        representation.setAccess(this.auth.clients().getAccess(this.client));
        return representation;
    }

    @Path(value="certificates/{attr}")
    public ClientAttributeCertificateResource getCertficateResource(@PathParam(value="attr") String attributePrefix) {
        return new ClientAttributeCertificateResource(this.realm, this.auth, this.client, this.session, attributePrefix, this.adminEvent);
    }

    @GET
    @NoCache
    @Path(value="installation/providers/{providerId}")
    public Response getInstallationProvider(@PathParam(value="providerId") String providerId) {
        this.auth.clients().requireView(this.client);
        ClientInstallationProvider provider = (ClientInstallationProvider)this.session.getProvider(ClientInstallationProvider.class, providerId);
        if (provider == null) {
            throw new NotFoundException("Unknown Provider");
        }
        return provider.generateInstallation(this.session, this.realm, this.client, this.session.getContext().getUri().getBaseUri());
    }

    @DELETE
    @NoCache
    public void deleteClient() {
        this.auth.clients().requireManage(this.client);
        if (this.client == null) {
            throw new NotFoundException("Could not find client");
        }
        new ClientManager(new RealmManager(this.session)).removeClient(this.realm, this.client);
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="client-secret")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public CredentialRepresentation regenerateSecret() {
        this.auth.clients().requireConfigure(this.client);
        logger.debug((Object)"regenerateSecret");
        UserCredentialModel cred = KeycloakModelUtils.generateSecret((ClientModel)this.client);
        CredentialRepresentation rep = ModelToRepresentation.toRepresentation((UserCredentialModel)cred);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        return rep;
    }

    @Path(value="registration-access-token")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ClientRepresentation regenerateRegistrationAccessToken() {
        this.auth.clients().requireManage(this.client);
        String token = ClientRegistrationTokenUtils.updateRegistrationAccessToken(this.session, this.realm, this.client, RegistrationAuth.AUTHENTICATED);
        ClientRepresentation rep = ModelToRepresentation.toRepresentation((ClientModel)this.client, (KeycloakSession)this.session);
        rep.setRegistrationAccessToken(token);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        return rep;
    }

    @Path(value="client-secret")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public CredentialRepresentation getClientSecret() {
        this.auth.clients().requireView(this.client);
        logger.debug((Object)"getClientSecret");
        UserCredentialModel model = UserCredentialModel.secret((String)this.client.getSecret());
        if (model == null) {
            throw new NotFoundException("Client does not have a secret");
        }
        return ModelToRepresentation.toRepresentation((UserCredentialModel)model);
    }

    @Path(value="scope-mappings")
    public ScopeMappedResource getScopeMappedResource() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.clients().requireManage(this.client);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.clients().requireView(this.client);
        return new ScopeMappedResource(this.realm, this.auth, (ScopeContainerModel)this.client, this.session, this.adminEvent, manageCheck, viewCheck);
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.session, (UriInfo)this.session.getContext().getUri(), this.realm, this.auth, (RoleContainerModel)this.client, this.adminEvent);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="default-client-scopes")
    public List<ClientScopeRepresentation> getDefaultClientScopes() {
        return this.getDefaultClientScopes(true);
    }

    private List<ClientScopeRepresentation> getDefaultClientScopes(boolean defaultScope) {
        this.auth.clients().requireView(this.client);
        LinkedList<ClientScopeRepresentation> defaults = new LinkedList<ClientScopeRepresentation>();
        for (ClientScopeModel clientScope : this.client.getClientScopes(defaultScope, true).values()) {
            ClientScopeRepresentation rep = new ClientScopeRepresentation();
            rep.setId(clientScope.getId());
            rep.setName(clientScope.getName());
            defaults.add(rep);
        }
        return defaults;
    }

    @PUT
    @NoCache
    @Path(value="default-client-scopes/{clientScopeId}")
    public void addDefaultClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.addDefaultClientScope(clientScopeId, true);
    }

    private void addDefaultClientScope(String clientScopeId, boolean defaultScope) {
        this.auth.clients().requireManage(this.client);
        ClientScopeModel clientScope = this.realm.getClientScopeById(clientScopeId);
        if (clientScope == null) {
            throw new NotFoundException("Client scope not found");
        }
        this.client.addClientScope(clientScope, defaultScope);
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.CLIENT).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @DELETE
    @NoCache
    @Path(value="default-client-scopes/{clientScopeId}")
    public void removeDefaultClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.auth.clients().requireManage(this.client);
        ClientScopeModel clientScope = this.realm.getClientScopeById(clientScopeId);
        if (clientScope == null) {
            throw new NotFoundException("Client scope not found");
        }
        this.client.removeClientScope(clientScope);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.CLIENT).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Path(value="optional-client-scopes")
    public List<ClientScopeRepresentation> getOptionalClientScopes() {
        return this.getDefaultClientScopes(false);
    }

    @PUT
    @NoCache
    @Path(value="optional-client-scopes/{clientScopeId}")
    public void addOptionalClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.addDefaultClientScope(clientScopeId, false);
    }

    @DELETE
    @NoCache
    @Path(value="optional-client-scopes/{clientScopeId}")
    public void removeOptionalClientScope(@PathParam(value="clientScopeId") String clientScopeId) {
        this.removeDefaultClientScope(clientScopeId);
    }

    @Path(value="evaluate-scopes")
    public ClientScopeEvaluateResource clientScopeEvaluateResource() {
        return new ClientScopeEvaluateResource(this.session, (UriInfo)this.session.getContext().getUri(), this.realm, this.auth, this.client, this.clientConnection);
    }

    @Path(value="service-account-user")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserRepresentation getServiceAccountUser() {
        this.auth.clients().requireView(this.client);
        UserModel user = this.session.users().getServiceAccount(this.client);
        if (user == null) {
            if (this.client.isServiceAccountsEnabled()) {
                new ClientManager(new RealmManager(this.session)).enableServiceAccount(this.client);
                user = this.session.users().getServiceAccount(this.client);
            } else {
                throw new BadRequestException("Service account not enabled for the client '" + this.client.getClientId() + "'");
            }
        }
        return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user);
    }

    @Path(value="push-revocation")
    @POST
    @Produces(value={"application/json"})
    public GlobalRequestResult pushRevocation() {
        this.auth.clients().requireConfigure(this.client);
        this.adminEvent.operation(OperationType.ACTION).resourcePath((UriInfo)this.session.getContext().getUri()).resource(ResourceType.CLIENT).success();
        return new ResourceAdminManager(this.session).pushClientRevocationPolicy(this.realm, this.client);
    }

    @Path(value="session-count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Long> getApplicationSessionCount() {
        this.auth.clients().requireView(this.client);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("count", this.session.sessions().getActiveUserSessions(this.client.getRealm(), this.client));
        return map;
    }

    @Path(value="user-sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getUserSessions(@QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.clients().requireView(this.client);
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : 100;
        ArrayList<UserSessionRepresentation> sessions = new ArrayList<UserSessionRepresentation>();
        for (UserSessionModel userSession : this.session.sessions().getUserSessions(this.client.getRealm(), this.client, firstResult.intValue(), maxResults.intValue())) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)userSession);
            sessions.add(rep);
        }
        return sessions;
    }

    @Path(value="offline-session-count")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Long> getOfflineSessionCount() {
        this.auth.clients().requireView(this.client);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("count", this.session.sessions().getOfflineSessionsCount(this.client.getRealm(), this.client));
        return map;
    }

    @Path(value="offline-sessions")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getOfflineUserSessions(@QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.clients().requireView(this.client);
        firstResult = firstResult != null ? firstResult : -1;
        maxResults = maxResults != null ? maxResults : 100;
        ArrayList<UserSessionRepresentation> sessions = new ArrayList<UserSessionRepresentation>();
        List userSessions = this.session.sessions().getOfflineUserSessions(this.client.getRealm(), this.client, firstResult.intValue(), maxResults.intValue());
        for (UserSessionModel userSession : userSessions) {
            UserSessionRepresentation rep = ModelToRepresentation.toRepresentation((UserSessionModel)userSession);
            for (Map.Entry csEntry : userSession.getAuthenticatedClientSessions().entrySet()) {
                String clientUuid = (String)csEntry.getKey();
                AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)csEntry.getValue();
                if (!this.client.getId().equals(clientUuid)) continue;
                rep.setLastAccess(Time.toMillis((int)clientSession.getTimestamp()));
                break;
            }
            sessions.add(rep);
        }
        return sessions;
    }

    @Path(value="nodes")
    @POST
    @Consumes(value={"application/json"})
    public void registerNode(Map<String, String> formParams) {
        this.auth.clients().requireConfigure(this.client);
        String node = formParams.get("node");
        if (node == null) {
            throw new BadRequestException("Node not found in params");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Register node: " + node));
        }
        this.client.registerNode(node, Time.currentTime());
        this.adminEvent.operation(OperationType.CREATE).resource(ResourceType.CLUSTER_NODE).resourcePath((UriInfo)this.session.getContext().getUri(), node).success();
    }

    @Path(value="nodes/{node}")
    @DELETE
    @NoCache
    public void unregisterNode(@PathParam(value="node") String node) {
        Integer time;
        this.auth.clients().requireConfigure(this.client);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unregister node: " + node));
        }
        if ((time = (Integer)this.client.getRegisteredNodes().get(node)) == null) {
            throw new NotFoundException("Client does not have node ");
        }
        this.client.unregisterNode(node);
        this.adminEvent.operation(OperationType.DELETE).resource(ResourceType.CLUSTER_NODE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @Path(value="test-nodes-available")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public GlobalRequestResult testNodesAvailable() {
        this.auth.clients().requireConfigure(this.client);
        logger.debug((Object)"Test availability of cluster nodes");
        GlobalRequestResult result = new ResourceAdminManager(this.session).testNodesAvailability(this.realm, this.client);
        this.adminEvent.operation(OperationType.ACTION).resource(ResourceType.CLUSTER_NODE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(result).success();
        return result;
    }

    @Path(value="/authz")
    public AuthorizationService authorization() {
        AuthorizationService resource = new AuthorizationService(this.session, this.client, this.auth, this.adminEvent);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public ManagementPermissionReference getManagementPermissions() {
        this.auth.roles().requireView((RoleContainerModel)this.client);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.clients().isPermissionsEnabled(this.client)) {
            return new ManagementPermissionReference();
        }
        return ClientResource.toMgmtRef(this.client, permissions);
    }

    public static ManagementPermissionReference toMgmtRef(ClientModel client, AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.clients().resource(client).getId());
        ref.setScopePermissions(permissions.clients().getPermissions(client));
        return ref;
    }

    @Path(value="management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    public ManagementPermissionReference setManagementPermissionsEnabled(ManagementPermissionReference ref) {
        this.auth.clients().requireManage(this.client);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.clients().setPermissionsEnabled(this.client, ref.isEnabled());
        if (ref.isEnabled()) {
            return ClientResource.toMgmtRef(this.client, permissions);
        }
        return new ManagementPermissionReference();
    }

    private void updateClientFromRep(ClientRepresentation rep, ClientModel client, KeycloakSession session) throws ModelDuplicateException {
        UserModel serviceAccount = this.session.users().getServiceAccount(client);
        if (Boolean.TRUE.equals(rep.isServiceAccountsEnabled())) {
            if (serviceAccount == null) {
                new ClientManager(new RealmManager(session)).enableServiceAccount(client);
            }
        } else if (serviceAccount != null) {
            new UserManager(session).removeUser(this.realm, serviceAccount);
        }
        if (!rep.getClientId().equals(client.getClientId())) {
            new ClientManager(new RealmManager(session)).clientIdChanged(client, rep.getClientId());
        }
        if (rep.isFullScopeAllowed() != null && rep.isFullScopeAllowed().booleanValue() != client.isFullScopeAllowed()) {
            this.auth.clients().requireManage(client);
        }
        if (rep.isBearerOnly() != null && rep.isBearerOnly().booleanValue() || rep.isPublicClient() != null && rep.isPublicClient().booleanValue()) {
            rep.setAuthorizationServicesEnabled(Boolean.valueOf(false));
        }
        RepresentationToModel.updateClient((ClientRepresentation)rep, (ClientModel)client);
        this.updateAuthorizationSettings(rep);
    }

    private void updateAuthorizationSettings(ClientRepresentation rep) {
        if (Boolean.TRUE.equals(rep.getAuthorizationServicesEnabled())) {
            this.authorization().enable(false);
        } else {
            this.authorization().disable();
        }
    }
}

