/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import org.keycloak.common.util.Base64Url;
import org.keycloak.credential.AttestationStatementSerializationContainer;

public class AttestationStatementConverter {
    private CborConverter converter;

    public AttestationStatementConverter(CborConverter converter) {
        this.converter = converter;
    }

    public String convertToDatabaseColumn(AttestationStatement attribute) {
        AttestationStatementSerializationContainer container = new AttestationStatementSerializationContainer(attribute);
        return Base64Url.encode((byte[])this.converter.writeValueAsBytes((Object)container));
    }

    public AttestationStatement convertToEntityAttribute(String dbData) {
        byte[] data = Base64Url.decode((String)dbData);
        AttestationStatementSerializationContainer container = (AttestationStatementSerializationContainer)this.converter.readValue(data, AttestationStatementSerializationContainer.class);
        return container.getAttestationStatement();
    }
}

