/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.models.Constants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class UserIdentityToModelMapper {
    public abstract UserModel find(AuthenticationFlowContext var1, Object var2) throws Exception;

    public static UserIdentityToModelMapper getUsernameOrEmailMapper() {
        return new UsernameOrEmailMapper();
    }

    public static UserIdentityToModelMapper getUserIdentityToCustomAttributeMapper(String attributeName) {
        return new UserIdentityToCustomAttributeMapper(attributeName);
    }

    static class UserIdentityToCustomAttributeMapper
    extends UserIdentityToModelMapper {
        private List<String> _customAttributes;

        UserIdentityToCustomAttributeMapper(String customAttributes) {
            this._customAttributes = Arrays.asList(Constants.CFG_DELIMITER_PATTERN.split(customAttributes));
        }

        @Override
        public UserModel find(AuthenticationFlowContext context, Object userIdentity) throws Exception {
            KeycloakSession session = context.getSession();
            List<String> userIdentityValues = Arrays.asList(Constants.CFG_DELIMITER_PATTERN.split(userIdentity.toString()));
            if (this._customAttributes.isEmpty() || userIdentityValues.isEmpty() || this._customAttributes.size() != userIdentityValues.size()) {
                return null;
            }
            List users = session.users().searchForUserByUserAttribute(this._customAttributes.get(0), userIdentityValues.get(0), context.getRealm());
            for (int i = 1; i < this._customAttributes.size(); ++i) {
                String customAttribute = this._customAttributes.get(i);
                String userIdentityValue = userIdentityValues.get(i);
                users = users.stream().filter(user -> user.getFirstAttribute(customAttribute).equals(userIdentityValue)).collect(Collectors.toList());
            }
            if (users != null && users.size() > 1) {
                throw new ModelDuplicateException();
            }
            return users != null && users.size() == 1 ? (UserModel)users.get(0) : null;
        }
    }

    static class UsernameOrEmailMapper
    extends UserIdentityToModelMapper {
        UsernameOrEmailMapper() {
        }

        @Override
        public UserModel find(AuthenticationFlowContext context, Object userIdentity) throws Exception {
            return KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (String)userIdentity.toString().trim());
        }
    }
}

