/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.httpclient.common.ContentType;
import org.wildfly.httpclient.common.HttpClientMessages;

public class HttpClientMessages_$logger
extends DelegatingBasicLogger
implements HttpClientMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = HttpClientMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public HttpClientMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String portValueOutOfRange$str() {
        return "WFHTTP000002: Port value %s out of range";
    }

    @Override
    public final ConfigXMLParseException portValueOutOfRange(int port) {
        ConfigXMLParseException result = new ConfigXMLParseException(String.format(this.getLoggingLocale(), this.portValueOutOfRange$str(), port));
        HttpClientMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void failedToAcquireSession(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.failedToAcquireSession$str(), new Object[0]);
    }

    protected String failedToAcquireSession$str() {
        return "WFHTTP000003: Failed to acquire session";
    }

    protected String invalidResponseType$str() {
        return "WFHTTP000004: Invalid response type %s";
    }

    @Override
    public final IOException invalidResponseType(ContentType type) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidResponseType$str(), type));
        HttpClientMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidResponseCode$str() {
        return "WFHTTP000005: Invalid response code %s (full response %s)";
    }

    @Override
    public final IOException invalidResponseCode(int responseCode, ClientResponse response) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidResponseCode$str(), responseCode, response));
        HttpClientMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToWriteException(Exception ex) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)ex, this.failedToWriteException$str(), new Object[0]);
    }

    protected String failedToWriteException$str() {
        return "WFHTTP000006: Failed to write exception";
    }

    protected String invalidContentEncoding$str() {
        return "WFHTTP000007: Invalid content encoding %s";
    }

    @Override
    public final IOException invalidContentEncoding(String encoding) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.invalidContentEncoding$str(), encoding));
        HttpClientMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String authenticationFailed$str() {
        return "WFHTTP000008: Authentication failed";
    }

    @Override
    public final SecurityException authenticationFailed() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.authenticationFailed$str(), new Object[0]));
        HttpClientMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedQopInDigest$str() {
        return "WFHTTP000009: Unsupported qop version in digest auth";
    }

    @Override
    public final RuntimeException unsupportedQopInDigest() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unsupportedQopInDigest$str(), new Object[0]));
        HttpClientMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToParseAuthenticationInfo(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.failedToParseAuthenticationInfo$str(), new Object[0]);
    }

    protected String failedToParseAuthenticationInfo$str() {
        return "WFHTTP000010: Error parsing authentication-info header";
    }

    protected String streamIsClosed$str() {
        return "WFHTTP000011: Stream is closed";
    }

    @Override
    public final IOException streamIsClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.streamIsClosed$str(), new Object[0]));
        HttpClientMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String blockingIoFromIOThread$str() {
        return "WFHTTP000012: Attempted to do blocking IO from the IO thread. This is prohibited as it may result in deadlocks";
    }

    @Override
    public final IllegalStateException blockingIoFromIOThread() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.blockingIoFromIOThread$str(), new Object[0]));
        HttpClientMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

