/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jgroups.util.Util;
import org.w3c.dom.Node;

public class ProtocolConfiguration {
    private final String protocol_name;
    private final ClassLoader loader;
    private String properties_str;
    private final Map<String, String> properties = new HashMap<String, String>();
    private List<Node> subtrees;
    public static final String protocol_prefix = "org.jgroups.protocols";

    public ProtocolConfiguration(String config_str) throws Exception {
        int index = config_str.indexOf(40);
        int end_index = config_str.lastIndexOf(41);
        if (index == -1) {
            this.protocol_name = config_str;
            this.properties_str = "";
        } else {
            if (end_index == -1) {
                throw new Exception("Configurator.ProtocolConfiguration(): closing ')' not found in " + config_str + ": properties cannot be set !");
            }
            this.properties_str = config_str.substring(index + 1, end_index);
            this.protocol_name = config_str.substring(0, index);
        }
        this.parsePropertiesString(this.properties);
        this.loader = ProtocolConfiguration.class.getClassLoader();
    }

    public ProtocolConfiguration(String protocol_name, Map<String, String> properties) {
        this(protocol_name, properties, ProtocolConfiguration.class.getClassLoader());
    }

    public ProtocolConfiguration(String protocol_name, Map<String, String> properties, ClassLoader loader) {
        this.protocol_name = protocol_name;
        this.loader = loader;
        if (!properties.isEmpty()) {
            this.properties.putAll(properties);
            this.properties_str = this.propertiesToString();
        }
    }

    public void addSubtree(Node node) {
        if (node == null) {
            return;
        }
        if (this.subtrees == null) {
            this.subtrees = new ArrayList<Node>();
        }
        this.subtrees.add(node);
    }

    public List<Node> getSubtrees() {
        return this.subtrees;
    }

    public String getProtocolName() {
        return this.protocol_name;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void substituteVariables() {
        Iterator<Map.Entry<String, String>> it = this.properties.entrySet().iterator();
        while (it.hasNext()) {
            String tmp;
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            String val = entry.getValue();
            if (!val.equals(tmp = Util.substituteVariable(val))) {
                this.properties.put(key, tmp);
                continue;
            }
            if (!tmp.contains("${")) continue;
            it.remove();
        }
        this.properties_str = this.propertiesToString();
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        if (this.protocol_name == null) {
            retval.append("<unknown>");
        } else {
            retval.append(this.protocol_name);
        }
        if (this.properties != null) {
            retval.append("(" + Util.print(this.properties) + ')');
        }
        return retval.toString();
    }

    public String propertiesToString() {
        return Util.printMapWithDelimiter(this.properties, ";");
    }

    public String getProtocolString(boolean new_format) {
        return new_format ? this.getProtocolStringNewXml() : this.getProtocolString();
    }

    public String getProtocolString() {
        StringBuilder buf = new StringBuilder(this.protocol_name);
        if (!this.properties.isEmpty()) {
            boolean first = true;
            buf.append('(');
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (first) {
                    first = false;
                } else {
                    buf.append(';');
                }
                buf.append(ProtocolConfiguration.getParameterString(key, val));
            }
            buf.append(')');
        }
        return buf.toString();
    }

    public String getProtocolStringNewXml() {
        StringBuilder buf = new StringBuilder(this.protocol_name + ' ');
        if (!this.properties.isEmpty()) {
            boolean first = true;
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (first) {
                    first = false;
                } else {
                    buf.append(' ');
                }
                buf.append(ProtocolConfiguration.getParameterStringXml(key, val));
            }
        }
        return buf.toString();
    }

    protected static String getParameterString(String name, String value) {
        StringBuilder buf = new StringBuilder(name);
        if (value != null) {
            buf.append('=').append(value);
        }
        return buf.toString();
    }

    protected static String getParameterStringXml(String name, String val) {
        StringBuilder buf = new StringBuilder(name);
        if (val != null) {
            buf.append("=\"").append(val).append('\"');
        }
        return buf.toString();
    }

    protected void parsePropertiesString(Map<String, String> properties) throws Exception {
        int index = 0;
        if (!this.properties_str.isEmpty()) {
            String[] components;
            for (String property : components = this.properties_str.split(";")) {
                index = property.indexOf(61);
                if (index == -1) {
                    throw new Exception("Configurator.ProtocolConfiguration(): '=' not found in " + property + " of " + this.protocol_name);
                }
                String name = property.substring(0, index);
                String value = property.substring(index + 1);
                properties.put(name, value);
            }
        }
    }
}

