/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.events.SessionClusterEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class ClientRemovedSessionEvent
extends SessionClusterEvent {
    private String clientUuid;

    public static ClientRemovedSessionEvent create(KeycloakSession session, String eventKey, String realmId, boolean resendingEvent, String clientUuid) {
        ClientRemovedSessionEvent event = ClientRemovedSessionEvent.createEvent(ClientRemovedSessionEvent.class, eventKey, session, realmId, resendingEvent);
        event.clientUuid = clientUuid;
        return event;
    }

    @Override
    public String toString() {
        return String.format("ClientRemovedSessionEvent [ realmId=%s , clientUuid=%s ]", this.getRealmId(), this.clientUuid);
    }

    public String getClientUuid() {
        return this.clientUuid;
    }

    public static class ExternalizerImpl
    implements Externalizer<ClientRemovedSessionEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, ClientRemovedSessionEvent obj) throws IOException {
            output.writeByte(1);
            obj.marshallTo(output);
            MarshallUtil.marshallString((String)obj.clientUuid, (ObjectOutput)output);
        }

        public ClientRemovedSessionEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public ClientRemovedSessionEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            ClientRemovedSessionEvent res = new ClientRemovedSessionEvent();
            res.unmarshallFrom(input);
            res.clientUuid = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

