/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew;

public class LibraryLoader {
    private static final String[] PATHS = new String[]{"/opt/rh/rh-sso7/root/lib/", "/opt/rh/rh-sso7/root/lib64/", "/usr/lib/", "/usr/lib64/", "/usr/local/lib/", "/opt/local/lib/"};
    private static final String LIBRARY_NAME = "libunix_dbus_java";
    private static final String VERSION = "0.0.8";
    private static boolean loadSucceeded;

    public static LibraryLoader load() {
        for (String path : PATHS) {
            try {
                System.load(String.format("%s/%s.so.%s", path, LIBRARY_NAME, VERSION));
                loadSucceeded = true;
                break;
            }
            catch (UnsatisfiedLinkError e) {
                loadSucceeded = false;
            }
        }
        return new LibraryLoader();
    }

    public boolean succeed() {
        return loadSucceeded;
    }
}

