/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.dtd.bindinfo;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CAdapter;
import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.TypeUse;
import com.sun.tools.xjc.model.TypeUseFactory;
import com.sun.tools.xjc.reader.dtd.bindinfo.BIConversion;
import com.sun.tools.xjc.reader.dtd.bindinfo.BindInfo;
import com.sun.tools.xjc.reader.dtd.bindinfo.DOMLocator;
import com.sun.tools.xjc.reader.dtd.bindinfo.DOMUtil;
import com.sun.xml.bind.v2.util.XmlFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BIUserConversion
implements BIConversion {
    private final BindInfo owner;
    private final Element e;

    BIUserConversion(BindInfo bi, Element _e) {
        this.owner = bi;
        this.e = _e;
    }

    private static void add(Map<String, BIConversion> m, BIConversion c) {
        m.put(c.name(), c);
    }

    static void addBuiltinConversions(BindInfo bi, Map<String, BIConversion> m) {
        BIUserConversion.add(m, new BIUserConversion(bi, BIUserConversion.parse("<conversion name='boolean' type='java.lang.Boolean' parse='getBoolean' />")));
        BIUserConversion.add(m, new BIUserConversion(bi, BIUserConversion.parse("<conversion name='byte' type='java.lang.Byte' parse='parseByte' />")));
        BIUserConversion.add(m, new BIUserConversion(bi, BIUserConversion.parse("<conversion name='short' type='java.lang.Short' parse='parseShort' />")));
        BIUserConversion.add(m, new BIUserConversion(bi, BIUserConversion.parse("<conversion name='int' type='java.lang.Integer' parse='parseInt' />")));
        BIUserConversion.add(m, new BIUserConversion(bi, BIUserConversion.parse("<conversion name='long' type='java.lang.Long' parse='parseLong' />")));
        BIUserConversion.add(m, new BIUserConversion(bi, BIUserConversion.parse("<conversion name='float' type='java.lang.Float' parse='parseFloat' />")));
        BIUserConversion.add(m, new BIUserConversion(bi, BIUserConversion.parse("<conversion name='double' type='java.lang.Double' parse='parseDouble' />")));
    }

    private static Element parse(String text) {
        try {
            DocumentBuilderFactory dbf = XmlFactory.createDocumentBuilderFactory(false);
            InputSource is = new InputSource(new StringReader(text));
            return dbf.newDocumentBuilder().parse(is).getDocumentElement();
        }
        catch (SAXException x) {
            throw new Error(x);
        }
        catch (IOException x) {
            throw new Error(x);
        }
        catch (ParserConfigurationException x) {
            throw new Error(x);
        }
    }

    public Locator getSourceLocation() {
        return DOMLocator.getLocationInfo(this.e);
    }

    @Override
    public String name() {
        return DOMUtil.getAttribute(this.e, "name");
    }

    @Override
    public TypeUse getTransducer() {
        String print;
        String parse;
        String type;
        String ws = DOMUtil.getAttribute(this.e, "whitespace");
        if (ws == null) {
            ws = "collapse";
        }
        if ((type = DOMUtil.getAttribute(this.e, "type")) == null) {
            type = this.name();
        }
        JPrimitiveType t = null;
        int idx = type.lastIndexOf(46);
        if (idx < 0) {
            try {
                t = JPrimitiveType.parse((JCodeModel)this.owner.codeModel, (String)type);
            }
            catch (IllegalArgumentException ex) {
                type = this.owner.getTargetPackage().name() + '.' + type;
            }
        }
        if (t == null) {
            try {
                JDefinedClass cls = this.owner.codeModel._class(type);
                cls.hide();
                t = cls;
            }
            catch (JClassAlreadyExistsException ex) {
                t = ex.getExistingClass();
            }
        }
        if ((parse = DOMUtil.getAttribute(this.e, "parse")) == null) {
            parse = "new";
        }
        if ((print = DOMUtil.getAttribute(this.e, "print")) == null) {
            print = "toString";
        }
        JDefinedClass adapter = this.generateAdapter(this.owner.codeModel, parse, print, t.boxify());
        return TypeUseFactory.adapt(CBuiltinLeafInfo.STRING, new CAdapter((JClass)adapter));
    }

    private JDefinedClass generateAdapter(JCodeModel cm, String parseMethod, String printMethod, JClass inMemoryType) {
        int idx;
        JDefinedClass adapter = null;
        int id = 1;
        while (adapter == null) {
            try {
                JPackage pkg = this.owner.getTargetPackage();
                adapter = pkg._class("Adapter" + id);
            }
            catch (JClassAlreadyExistsException ex) {
                ++id;
            }
        }
        adapter._extends(cm.ref(XmlAdapter.class).narrow(String.class).narrow(inMemoryType));
        JMethod unmarshal = adapter.method(1, (JType)inMemoryType, "unmarshal");
        JVar $value = unmarshal.param(String.class, "value");
        Object inv = parseMethod.equals("new") ? JExpr._new((JClass)inMemoryType).arg((JExpression)$value) : ((idx = parseMethod.lastIndexOf(46)) < 0 ? inMemoryType.staticInvoke(parseMethod).arg((JExpression)$value) : JExpr.direct((String)(parseMethod + "(value)")));
        unmarshal.body()._return((JExpression)inv);
        JMethod marshal = adapter.method(1, String.class, "marshal");
        $value = marshal.param((JType)inMemoryType, "value");
        int idx2 = printMethod.lastIndexOf(46);
        inv = idx2 < 0 ? $value.invoke(printMethod) : JExpr.direct((String)(printMethod + "(value)"));
        marshal.body()._return((JExpression)inv);
        return adapter;
    }
}

