/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.diff.Diff;
import com.github.fge.jsonpatch.diff.DiffOperation;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class DiffFactorizer {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    private DiffFactorizer() {
    }

    public static void factorizeDiffs(List<Diff> diffs) {
        DiffFactorizer.findPairs(diffs);
        DiffFactorizer.factorizePairs(diffs);
        ArrayList addDiffs = Lists.newArrayList();
        for (Diff diff : diffs) {
            if (diff.operation != DiffOperation.ADD || diff.value.size() == 0) continue;
            Diff addDiff = null;
            for (Diff testAddDiff : addDiffs) {
                if (!EQUIVALENCE.equivalent((Object)diff.value, (Object)testAddDiff.value)) continue;
                addDiff = testAddDiff;
                break;
            }
            if (addDiff == null) {
                if (diff.arrayPath != null && diff.secondArrayIndex == -1) continue;
                addDiffs.add(diff);
                continue;
            }
            diff.operation = DiffOperation.COPY;
            diff.fromPath = addDiff.arrayPath != null ? addDiff.getSecondArrayPath() : addDiff.path;
        }
    }

    private static void findPairs(List<Diff> diffs) {
        int diffsSize = diffs.size();
        block0: for (int addIndex = 0; addIndex < diffsSize; ++addIndex) {
            Diff addition = diffs.get(addIndex);
            if (addition.operation != DiffOperation.ADD) continue;
            for (int removeIndex = 0; removeIndex < diffsSize; ++removeIndex) {
                Diff removal = diffs.get(removeIndex);
                if (removal.operation != DiffOperation.REMOVE || !EQUIVALENCE.equivalent((Object)removal.value, (Object)addition.value)) continue;
                addition.pairedDiff = removal;
                addition.firstOfPair = addIndex < removeIndex;
                removal.pairedDiff = addition;
                removal.firstOfPair = removeIndex < addIndex;
                continue block0;
            }
        }
    }

    private static void factorizePairs(List<Diff> diffs) {
        ArrayList deferredArrayRemoves = Lists.newArrayList();
        ArrayList advancedArrayRemoves = Lists.newArrayList();
        Iterator<Diff> iterator = diffs.iterator();
        while (iterator.hasNext()) {
            Diff diff = iterator.next();
            if (diff.operation == DiffOperation.REMOVE && diff.pairedDiff != null) {
                if (diff.arrayPath != null && diff.firstOfPair) {
                    deferredArrayRemoves.add(diff);
                }
                iterator.remove();
                continue;
            }
            if (diff.operation == DiffOperation.ADD && diff.pairedDiff != null) {
                int removeIndex;
                Diff removal = diff.pairedDiff;
                diff.operation = DiffOperation.MOVE;
                diff.pairedDiff = null;
                if (removal.arrayPath == null) {
                    diff.fromPath = removal.path;
                } else if (diff.firstOfPair) {
                    removeIndex = removal.firstArrayIndex;
                    removeIndex = DiffFactorizer.adjustFirstArrayIndex(advancedArrayRemoves, removal.arrayPath, removeIndex);
                    if (removal.arrayPath.equals((Object)diff.arrayPath)) {
                        int moveSecondArrayIndex = DiffFactorizer.adjustSecondArrayIndex(deferredArrayRemoves, diff.arrayPath, diff.secondArrayIndex);
                        int moveFirstArrayIndex = DiffFactorizer.adjustFirstArrayIndex(advancedArrayRemoves, diff.arrayPath, diff.firstArrayIndex);
                        removeIndex += moveSecondArrayIndex - moveFirstArrayIndex;
                    }
                    diff.fromPath = removal.arrayPath.append(removeIndex);
                    advancedArrayRemoves.add(removal);
                } else {
                    deferredArrayRemoves.remove(removal);
                    removeIndex = removal.secondArrayIndex;
                    removeIndex = DiffFactorizer.adjustSecondArrayIndex(deferredArrayRemoves, removal.arrayPath, removeIndex);
                    diff.fromPath = removal.arrayPath.append(removeIndex);
                }
            }
            if (diff.arrayPath == null) continue;
            diff.secondArrayIndex = DiffFactorizer.adjustSecondArrayIndex(deferredArrayRemoves, diff.arrayPath, diff.secondArrayIndex);
        }
    }

    private static int adjustFirstArrayIndex(List<Diff> advancedArrayRemoves, JsonPointer arrayPath, int arrayIndex) {
        if (arrayIndex == -1) {
            return arrayIndex;
        }
        int arrayRemoves = 0;
        for (Diff advancedArrayRemove : advancedArrayRemoves) {
            if (!arrayPath.equals((Object)advancedArrayRemove.arrayPath) || arrayIndex <= advancedArrayRemove.firstArrayIndex) continue;
            ++arrayRemoves;
        }
        return arrayIndex - arrayRemoves;
    }

    private static int adjustSecondArrayIndex(List<Diff> deferredArrayRemoves, JsonPointer arrayPath, int arrayIndex) {
        if (arrayIndex == -1) {
            return arrayIndex;
        }
        int arrayRemoves = 0;
        for (Diff deferredArrayRemove : deferredArrayRemoves) {
            if (!arrayPath.equals((Object)deferredArrayRemove.arrayPath) || arrayIndex < deferredArrayRemove.secondArrayIndex) continue;
            ++arrayRemoves;
        }
        return arrayIndex + arrayRemoves;
    }
}

