/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.kubernetes;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import mjson.Json;
import org.jgroups.logging.Log;
import org.jgroups.protocols.kubernetes.Pod;
import org.jgroups.protocols.kubernetes.Utils;
import org.jgroups.protocols.kubernetes.stream.StreamProvider;
import org.jgroups.util.Util;

public class Client {
    protected final String masterUrl;
    protected final Map<String, String> headers;
    protected final int connectTimeout;
    protected final int readTimeout;
    protected final int operationAttempts;
    protected final long operationSleep;
    protected final StreamProvider streamProvider;
    protected final String info;
    protected final Log log;

    public Client(String masterUrl, Map<String, String> headers, int connectTimeout, int readTimeout, int operationAttempts, long operationSleep, StreamProvider streamProvider, Log log) {
        this.masterUrl = masterUrl;
        this.headers = headers;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.operationAttempts = operationAttempts;
        this.operationSleep = operationSleep;
        this.streamProvider = streamProvider;
        this.log = log;
        TreeMap<String, String> maskedHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                String key = header.getKey();
                String value = header.getValue();
                if ("Authorization".equalsIgnoreCase(key) && value != null) {
                    value = "#MASKED:" + value.length() + "#";
                }
                maskedHeaders.put(key, value);
            }
        }
        this.info = String.format("%s[masterUrl=%s, headers=%s, connectTimeout=%s, readTimeout=%s, operationAttempts=%s, operationSleep=%s, streamProvider=%s]", this.getClass().getSimpleName(), masterUrl, maskedHeaders, connectTimeout, readTimeout, operationAttempts, operationSleep, streamProvider);
    }

    public String info() {
        return this.info;
    }

    protected String fetchFromKubernetes(String op, String namespace, String labels, boolean dump_requests) throws Exception {
        String string;
        String url = this.masterUrl;
        if (namespace != null && !namespace.isEmpty()) {
            url = url + "/namespaces/" + Utils.urlencode(namespace);
        }
        url = url + "/" + op;
        if (labels != null && !labels.isEmpty()) {
            url = url + "?labelSelector=" + Utils.urlencode(labels);
        }
        InputStream stream = null;
        String retval = null;
        try {
            stream = Utils.openStream(url, this.headers, this.connectTimeout, this.readTimeout, this.operationAttempts, this.operationSleep, this.streamProvider);
            retval = Util.readContents((InputStream)stream);
            if (dump_requests) {
                System.out.printf("--> %s\n<-- %s\n", url, retval);
            }
            string = retval;
        }
        catch (Throwable t) {
            try {
                retval = t.getMessage();
                if (dump_requests) {
                    System.out.printf("--> %s\n<-- ERROR: %s\n", url, t.getMessage());
                }
                throw t;
            }
            catch (Throwable throwable) {
                Util.close(stream);
                throw throwable;
            }
        }
        Util.close((Closeable)stream);
        return string;
    }

    public List<Pod> getPods(String namespace, String labels, boolean dump_requests) throws Exception {
        String result = this.fetchFromKubernetes("pods", namespace, labels, dump_requests);
        if (result == null) {
            return Collections.emptyList();
        }
        return this.parseJsonResult(result, namespace, labels);
    }

    String getPodGroup(Json pod) {
        Json meta = Optional.ofNullable(pod.at("metadata")).orElse(null);
        Json labels = Optional.ofNullable(meta).map(podMetadata -> podMetadata.at("labels")).orElse(null);
        String group = Optional.ofNullable(labels).map(l -> l.at("pod-template-hash")).map(Json::asString).orElse(null);
        if (group == null) {
            this.log.warn("metadata.labels.pod-template-hash not found in pod json. Impossible to reliably determine pod group during Rolling Update");
            group = Optional.ofNullable(labels).map(l -> l.at("deployment")).map(Json::asString).orElse(null);
        }
        this.log.debug("pod %s, group %s", new Object[]{Optional.ofNullable(meta).map(m -> m.at("name")).map(Json::asString).orElse(null), group});
        return group;
    }

    protected List<Pod> parseJsonResult(String input, String namespace, String labels) {
        if (input == null) {
            return Collections.emptyList();
        }
        Json json = Json.read(input);
        if (json == null || !json.isObject()) {
            this.log.error("JSON is not a map: %s", new Object[]{json});
            return Collections.emptyList();
        }
        if (!json.has("items")) {
            this.log.error("JSON object is missing property \"items\": %s", new Object[]{json});
            return Collections.emptyList();
        }
        List<Json> items = json.at("items").asJsonList();
        ArrayList<Pod> pods = new ArrayList<Pod>();
        for (Json obj : items) {
            String parentDeployment = this.getPodGroup(obj);
            String name = Optional.ofNullable(obj.at("metadata")).map(podMetadata -> podMetadata.at("name")).map(Json::asString).orElse(null);
            Json podStatus = Optional.ofNullable(obj.at("status")).orElse(null);
            String podIP = null;
            if (podStatus != null) {
                podIP = Optional.ofNullable(podStatus.at("podIP")).map(Json::asString).orElse(null);
            }
            boolean running = this.podRunning(podStatus);
            if (podIP == null) {
                this.log.trace("Skipping pod %s since it's IP is %s", new Object[]{name, podIP});
                continue;
            }
            pods.add(new Pod(name, podIP, parentDeployment, running));
        }
        this.log.trace("getPods(%s, %s) = %s", new Object[]{namespace, labels, pods});
        return pods;
    }

    protected boolean podRunning(Json podStatus) {
        if (podStatus == null) {
            return false;
        }
        this.log.trace("Determining pod status");
        String phase = Optional.ofNullable(podStatus.at("phase")).map(Json::asString).orElse("not running");
        this.log.trace("  status.phase=%s", new Object[]{phase});
        if (!phase.equalsIgnoreCase("Running")) {
            return false;
        }
        String statusMessage = Optional.ofNullable(podStatus.at("message")).map(Json::asString).orElse(null);
        String statusReason = Optional.ofNullable(podStatus.at("reason")).map(Json::asString).orElse(null);
        this.log.trace("  status.message=%s and status.reason=%s", new Object[]{statusMessage, statusReason});
        if (statusMessage != null || statusReason != null) {
            return false;
        }
        List containerStatuses = Optional.ofNullable(podStatus.at("containerStatuses")).map(Json::asJsonList).orElse(Collections.emptyList());
        boolean ready = true;
        for (Json containerStatus : containerStatuses) {
            ready = ready && containerStatus.at("ready").asBoolean();
        }
        this.log.trace("  containerStatuses[].status of all container is %s", new Object[]{Boolean.toString(ready)});
        if (!ready) {
            return false;
        }
        Boolean readyCondition = Boolean.FALSE;
        List<Json> conditions = podStatus.at("conditions").asJsonList();
        for (Json condition : conditions) {
            String type = condition.at("type").asString();
            if (!type.equalsIgnoreCase("Ready")) continue;
            readyCondition = new Boolean(condition.at("status").asString());
        }
        this.log.trace("conditions with type==\"Ready\" has status property value = %s", new Object[]{readyCondition.toString()});
        return readyCondition != false;
    }
}

