/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class RoleUtils {
    public static boolean isMember(Set<GroupModel> groups, GroupModel targetGroup) {
        if (groups.contains(targetGroup)) {
            return true;
        }
        Iterator<GroupModel> iterator = groups.iterator();
        while (iterator.hasNext()) {
            GroupModel mapping;
            GroupModel child = mapping = iterator.next();
            while (child.getParent() != null) {
                if (child.getParent().equals(targetGroup)) {
                    return true;
                }
                child = child.getParent();
            }
        }
        return false;
    }

    public static boolean hasRole(Set<RoleModel> roles, RoleModel targetRole) {
        if (roles.contains(targetRole)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(targetRole)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasRoleFromGroup(GroupModel group, RoleModel targetRole, boolean checkParentGroup) {
        if (group.hasRole(targetRole)) {
            return true;
        }
        if (checkParentGroup) {
            GroupModel parent = group.getParent();
            return parent != null && RoleUtils.hasRoleFromGroup(parent, targetRole, true);
        }
        return false;
    }

    public static boolean hasRoleFromGroup(Iterable<GroupModel> groups, RoleModel targetRole, boolean checkParentGroup) {
        if (groups == null) {
            return false;
        }
        return StreamSupport.stream(groups.spliterator(), false).anyMatch(group -> RoleUtils.hasRoleFromGroup(group, targetRole, checkParentGroup));
    }

    private static Stream<RoleModel> expandCompositeRolesStream(RoleModel role, Set<RoleModel> visited) {
        Stream.Builder<RoleModel> sb = Stream.builder();
        if (!visited.contains(role)) {
            ArrayDeque<RoleModel> stack = new ArrayDeque<RoleModel>();
            stack.add(role);
            while (!stack.isEmpty()) {
                RoleModel current = (RoleModel)stack.pop();
                sb.add(current);
                if (!current.isComposite()) continue;
                current.getComposites().stream().filter(r -> !visited.contains(r)).forEach(r -> {
                    visited.add((RoleModel)r);
                    stack.add((RoleModel)r);
                });
            }
        }
        return sb.build();
    }

    public static Set<RoleModel> expandCompositeRoles(Set<RoleModel> roles) {
        HashSet visited = new HashSet();
        return roles.stream().flatMap(roleModel -> RoleUtils.expandCompositeRolesStream(roleModel, visited)).collect(Collectors.toSet());
    }

    public static Set<RoleModel> getDeepUserRoleMappings(UserModel user) {
        HashSet<RoleModel> roleMappings = new HashSet<RoleModel>(user.getRoleMappings());
        for (GroupModel group : user.getGroups()) {
            RoleUtils.addGroupRoles(group, roleMappings);
        }
        return RoleUtils.expandCompositeRoles(roleMappings);
    }

    private static void addGroupRoles(GroupModel group, Set<RoleModel> roleMappings) {
        roleMappings.addAll(group.getRoleMappings());
        if (group.getParentId() == null) {
            return;
        }
        RoleUtils.addGroupRoles(group.getParent(), roleMappings);
    }
}

