/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.Receiver;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.SHARED_LOOPBACK;
import org.jgroups.protocols.SHARED_LOOPBACK_PING;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.IpAddressUUID;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.AsciiString;
import org.jgroups.util.Bits;
import org.jgroups.util.Buffer;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Condition;
import org.jgroups.util.CustomRejectionPolicy;
import org.jgroups.util.InputStreamAdapter;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.ObjectInputStreamWithClassloader;
import org.jgroups.util.OutputStreamAdapter;
import org.jgroups.util.ProgressCheckRejectionPolicy;
import org.jgroups.util.Range;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.StackType;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler3;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;

public class Util {
    private static final Map<Class<? extends Object>, Byte> PRIMITIVE_TYPES;
    private static final byte TYPE_NULL = 0;
    private static final byte TYPE_STREAMABLE = 1;
    private static final byte TYPE_SERIALIZABLE = 2;
    private static final byte TYPE_BOOLEAN = 10;
    private static final byte TYPE_BYTE = 11;
    private static final byte TYPE_CHAR = 12;
    private static final byte TYPE_DOUBLE = 13;
    private static final byte TYPE_FLOAT = 14;
    private static final byte TYPE_INT = 15;
    private static final byte TYPE_LONG = 16;
    private static final byte TYPE_SHORT = 17;
    private static final byte TYPE_STRING = 18;
    private static final byte TYPE_BYTEARRAY = 19;
    private static final byte TYPE_UTF_STRING = 21;
    public static final int MAX_PORT = 65535;
    private static final Pattern METHOD_NAME_TO_ATTR_NAME_PATTERN;
    private static final Pattern ATTR_NAME_TO_METHOD_NAME_PATTERN;
    protected static int CCHM_INITIAL_CAPACITY;
    protected static float CCHM_LOAD_FACTOR;
    protected static int CCHM_CONCURRENCY_LEVEL;
    public static final int DEFAULT_HEADERS;
    public static int MAX_LIST_PRINT_SIZE;
    private static final byte[] TYPE_NULL_ARRAY;
    private static final byte[] TYPE_BOOLEAN_TRUE;
    private static final byte[] TYPE_BOOLEAN_FALSE;
    private static boolean ipv4_stack_available;
    private static boolean ipv6_stack_available;
    private static final StackType ip_stack_type;
    protected static ResourceBundle resource_bundle;

    public static final Class<? extends Protocol>[] getUnicastProtocols() {
        return new Class[]{UNICAST3.class};
    }

    public static void assertTrue(boolean condition) {
        assert (condition);
    }

    public static void assertTrue(String message, boolean condition) {
        if (message != null) {
            assert (condition) : message;
        } else assert (condition);
    }

    public static void assertFalse(boolean condition) {
        Util.assertFalse(null, condition);
    }

    public static void assertFalse(String message, boolean condition) {
        if (message != null) {
            assert (!condition) : message;
        } else assert (!condition);
    }

    public static void assertEquals(String message, Object val1, Object val2) {
        if (message != null) {
            assert (val1.equals(val2)) : message;
        } else assert (val1.equals(val2));
    }

    public static void assertEquals(Object val1, Object val2) {
        Util.assertEquals(null, val1, val2);
    }

    public static void assertNotNull(String message, Object val) {
        if (message != null) {
            assert (val != null) : message;
        } else assert (val != null);
    }

    public static void assertNotNull(Object val) {
        Util.assertNotNull(null, val);
    }

    public static void assertNull(String message, Object val) {
        if (message != null) {
            assert (val == null) : message;
        } else assert (val == null);
    }

    public static int getNextHigherPowerOfTwo(int num) {
        if (num <= 0) {
            return 1;
        }
        int highestBit = Integer.highestOneBit(num);
        return num <= highestBit ? highestBit : highestBit << 1;
    }

    public static String bold(String msg) {
        StringBuilder sb = new StringBuilder("\u001b[1m");
        sb.append(msg).append("\u001b[0m");
        return sb.toString();
    }

    public static String getMessage(String key) {
        return key != null ? resource_bundle.getString(key) : null;
    }

    public static Protocol[] getTestStack(Protocol ... additional_protocols) {
        Protocol[] protocols = new Protocol[]{new SHARED_LOOPBACK(), new SHARED_LOOPBACK_PING(), new NAKACK2(), new UNICAST3(), new STABLE(), new GMS().joinTimeout(1000L), new FRAG2().fragSize(8000)};
        if (additional_protocols == null) {
            return protocols;
        }
        Protocol[] tmp = Arrays.copyOf(protocols, protocols.length + additional_protocols.length);
        System.arraycopy(additional_protocols, 0, tmp, protocols.length, additional_protocols.length);
        return tmp;
    }

    public static void waitUntilAllChannelsHaveSameView(long timeout, long interval, JChannel ... channels) throws TimeoutException {
        if (interval >= timeout || timeout <= 0L) {
            throw new IllegalArgumentException("interval needs to be smaller than timeout or timeout needs to be > 0");
        }
        if (channels == null || channels.length == 0) {
            return;
        }
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= target_time) {
            boolean all_channels_have_correct_view = true;
            View first = channels[0].getView();
            for (JChannel ch : channels) {
                View view = ch.getView();
                if (Objects.equals(view, first) && view.size() == channels.length) continue;
                all_channels_have_correct_view = false;
                break;
            }
            if (all_channels_have_correct_view) {
                return;
            }
            Util.sleep(interval);
        }
        View[] views = new View[channels.length];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < channels.length; ++i) {
            views[i] = channels[i].getView();
            sb.append(channels[i].getName()).append(": ").append(views[i]).append("\n");
        }
        View first = channels[0].getView();
        for (View view : views) {
            if (Objects.equals(view, first) && view.size() == channels.length) continue;
            throw new TimeoutException("Timeout " + timeout + " kicked in, views are:\n" + sb);
        }
    }

    public static void waitUntilAllChannelsHaveSameView(long timeout, long interval, Collection<JChannel> channels) throws TimeoutException {
        JChannel[] tmp = new JChannel[channels != null ? channels.size() : 0];
        if (tmp == null) {
            return;
        }
        int index = 0;
        Iterator<JChannel> it = channels.iterator();
        while (it.hasNext()) {
            tmp[index++] = it.next();
        }
        Util.waitUntilAllChannelsHaveSameView(timeout, interval, tmp);
    }

    public static void waitUntil(long timeout, long interval, Condition condition) throws TimeoutException {
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() <= target_time) {
            if (condition.isMet()) {
                return;
            }
            Util.sleep(interval);
        }
        throw new TimeoutException("Timeout " + timeout + " kicked in");
    }

    public static boolean allChannelsHaveSameView(JChannel ... channels) {
        View first = channels[0].getView();
        for (JChannel ch : channels) {
            View view = ch.getView();
            if (Objects.equals(view, first) && view.size() == channels.length) continue;
            return false;
        }
        return true;
    }

    public static void assertAllChannelsHaveSameView(JChannel ... channels) {
        assert (Util.allChannelsHaveSameView(channels)) : String.format("channels have different views:\n%s\n", Util.printViews(channels));
    }

    public static String printViews(JChannel ... channels) {
        StringBuilder sb = new StringBuilder();
        for (JChannel ch : channels) {
            sb.append(String.format("%s: %s\n", ch.name(), ch.getView()));
        }
        return sb.toString();
    }

    public static <T> void waitUntilListHasSize(List<T> list, int expected_size, long timeout, long interval) {
        if (list == null) {
            throw new IllegalStateException("list is null");
        }
        long target_time = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < target_time && list.size() != expected_size) {
            Util.sleep(interval);
        }
        assert (list.size() == expected_size) : "list doesn't have the expected (" + expected_size + ") elements: " + list;
    }

    public static byte[] createAuthenticationDigest(String passcode, long t1, double q1) throws IOException, NoSuchAlgorithmException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(baos);
        byte[] digest = Util.createDigest(passcode, t1, q1);
        out.writeLong(t1);
        out.writeDouble(q1);
        out.writeInt(digest.length);
        out.write(digest);
        out.flush();
        return baos.toByteArray();
    }

    public static byte[] createDigest(String passcode, long t1, double q1) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(passcode.getBytes());
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(t1);
        bb.putDouble(q1);
        md.update(bb);
        return md.digest();
    }

    public static void connect(Socket sock, SocketAddress dest, int sock_conn_timeout) throws IOException {
        Inet6Address tmp;
        InetAddress addr;
        if (dest instanceof InetSocketAddress && (addr = ((InetSocketAddress)dest).getAddress()) instanceof Inet6Address && (tmp = (Inet6Address)addr).getScopeId() != 0) {
            dest = new InetSocketAddress(InetAddress.getByAddress(tmp.getAddress()), ((InetSocketAddress)dest).getPort());
        }
        sock.connect(dest, sock_conn_timeout);
    }

    public static boolean connect(SocketChannel ch, SocketAddress dest) throws IOException {
        Inet6Address tmp;
        InetAddress addr;
        if (dest instanceof InetSocketAddress && (addr = ((InetSocketAddress)dest).getAddress()) instanceof Inet6Address && (tmp = (Inet6Address)addr).getScopeId() != 0) {
            dest = new InetSocketAddress(InetAddress.getByAddress(tmp.getAddress()), ((InetSocketAddress)dest).getPort());
        }
        return ch.connect(dest);
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable ... closeables) {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                Util.close(closeable);
            }
        }
    }

    public static void closeReverse(Closeable ... closeables) {
        if (closeables != null) {
            for (int i = closeables.length - 1; i >= 0; --i) {
                Util.close(closeables[i]);
            }
        }
    }

    public static void shutdown(JChannel ch) throws Exception {
        View view;
        DISCARD discard = new DISCARD();
        discard.setLocalAddress(ch.getAddress());
        discard.setDiscardAll(true);
        ProtocolStack stack = ch.getProtocolStack();
        TP transport = stack.getTransport();
        stack.insertProtocol((Protocol)discard, ProtocolStack.Position.ABOVE, (Class<? extends Protocol>)transport.getClass());
        FD_SOCK fd = (FD_SOCK)ch.getProtocolStack().findProtocol((Class<? extends Protocol>)FD_SOCK.class);
        if (fd != null) {
            fd.stopServerSocket(false);
        }
        if ((view = ch.getView()) != null) {
            ViewId vid = view.getViewId();
            List<Address> members = Collections.singletonList(ch.getAddress());
            ViewId new_vid = new ViewId(ch.getAddress(), vid.getId() + 1L);
            View new_view = new View(new_vid, members);
            GMS gms = (GMS)stack.findProtocol((Class<? extends Protocol>)GMS.class);
            gms.installView(new_view);
        }
        Util.close((Closeable)ch);
    }

    public static byte setFlag(byte bits, byte flag) {
        bits = (byte)(bits | flag);
        return bits;
    }

    public static boolean isFlagSet(byte bits, byte flag) {
        return (bits & flag) == flag;
    }

    public static byte clearFlags(byte bits, byte flag) {
        bits = (byte)(bits & ~flag);
        return bits;
    }

    public static <T> T objectFromByteBuffer(byte[] buffer) throws IOException, ClassNotFoundException {
        if (buffer == null) {
            return null;
        }
        return Util.objectFromByteBuffer(buffer, 0, buffer.length);
    }

    public static <T> T objectFromByteBuffer(byte[] buffer, int offset, int length) throws IOException, ClassNotFoundException {
        return Util.objectFromByteBuffer(buffer, offset, length, null);
    }

    public static <T> T objectFromByteBuffer(byte[] buffer, int offset, int length, ClassLoader loader) throws IOException, ClassNotFoundException {
        if (buffer == null) {
            return null;
        }
        byte type = buffer[offset++];
        --length;
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
                return Util.readGenericStreamable(in, loader);
            }
            case 2: {
                ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer, offset, length);
                try (ObjectInputStreamWithClassloader oin = new ObjectInputStreamWithClassloader(in_stream, loader);){
                    Object object = oin.readObject();
                    return (T)object;
                }
            }
            case 10: {
                return (T)Boolean.valueOf(buffer[offset] == 1);
            }
            case 11: {
                return (T)Byte.valueOf(buffer[offset]);
            }
            case 12: {
                return (T)Character.valueOf(Bits.readChar(buffer, offset));
            }
            case 13: {
                return (T)Double.valueOf(Bits.readDouble(buffer, offset));
            }
            case 14: {
                return (T)Float.valueOf(Bits.readFloat(buffer, offset));
            }
            case 15: {
                return (T)Integer.valueOf(Bits.readInt(buffer, offset));
            }
            case 16: {
                return (T)Long.valueOf(Bits.readLong(buffer, offset));
            }
            case 17: {
                return (T)Short.valueOf(Bits.readShort(buffer, offset));
            }
            case 18: {
                return (T)new String(buffer, offset, length);
            }
            case 21: {
                ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
                return (T)in.readUTF();
            }
            case 19: {
                byte[] tmp = new byte[length];
                System.arraycopy(buffer, offset, tmp, 0, length);
                return (T)tmp;
            }
        }
        throw new IllegalArgumentException("type " + type + " is invalid");
    }

    public static byte[] objectToByteBuffer(Object obj) throws IOException {
        if (obj == null) {
            return TYPE_NULL_ARRAY;
        }
        if (obj instanceof Streamable) {
            int expected_size = obj instanceof SizeStreamable ? ((SizeStreamable)obj).serializedSize() : 512;
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(expected_size, true);
            out.write(1);
            Util.writeGenericStreamable((Streamable)obj, out);
            return Arrays.copyOf(out.buf, out.position());
        }
        Byte type = PRIMITIVE_TYPES.get(obj.getClass());
        if (type == null) {
            ByteArrayDataOutputStream out_stream = new ByteArrayDataOutputStream(512, true);
            out_stream.write(2);
            try (ObjectOutputStream out = new ObjectOutputStream(new OutputStreamAdapter(out_stream));){
                out.writeObject(obj);
                out.flush();
                byte[] byArray = Arrays.copyOf(out_stream.buffer(), out_stream.position());
                return byArray;
            }
        }
        return Util.marshalPrimitiveType(type, obj);
    }

    public static Buffer objectToBuffer(Object obj) throws IOException {
        if (obj == null) {
            return new Buffer(TYPE_NULL_ARRAY);
        }
        if (obj instanceof Streamable) {
            int expected_size = obj instanceof SizeStreamable ? ((SizeStreamable)obj).serializedSize() : 512;
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(expected_size, true);
            out.write(1);
            Util.writeGenericStreamable((Streamable)obj, out);
            return out.getBuffer();
        }
        Byte type = PRIMITIVE_TYPES.get(obj.getClass());
        if (type == null) {
            ByteArrayDataOutputStream out_stream = new ByteArrayDataOutputStream(512, true);
            out_stream.write(2);
            try (ObjectOutputStream out = new ObjectOutputStream(new OutputStreamAdapter(out_stream));){
                out.writeObject(obj);
                out.flush();
                Buffer buffer = out_stream.getBuffer();
                return buffer;
            }
        }
        return new Buffer(Util.marshalPrimitiveType(type, obj));
    }

    protected static byte[] marshalPrimitiveType(byte type, Object obj) {
        switch (type) {
            case 10: {
                return (Boolean)obj != false ? TYPE_BOOLEAN_TRUE : TYPE_BOOLEAN_FALSE;
            }
            case 11: {
                return new byte[]{11, (Byte)obj};
            }
            case 12: {
                byte[] buf = new byte[3];
                buf[0] = 12;
                Bits.writeChar(((Character)obj).charValue(), buf, 1);
                return buf;
            }
            case 13: {
                byte[] buf = new byte[9];
                buf[0] = 13;
                Bits.writeDouble((Double)obj, buf, 1);
                return buf;
            }
            case 14: {
                byte[] buf = new byte[5];
                buf[0] = 14;
                Bits.writeFloat(((Float)obj).floatValue(), buf, 1);
                return buf;
            }
            case 15: {
                byte[] buf = new byte[5];
                buf[0] = 15;
                Bits.writeInt((Integer)obj, buf, 1);
                return buf;
            }
            case 16: {
                byte[] buf = new byte[9];
                buf[0] = 16;
                Bits.writeLong((Long)obj, buf, 1);
                return buf;
            }
            case 17: {
                byte[] buf = new byte[3];
                buf[0] = 17;
                Bits.writeShort((Short)obj, buf, 1);
                return buf;
            }
            case 18: {
                String str = (String)obj;
                if (Util.isAsciiString(str)) {
                    int len = str.length();
                    ByteBuffer retval = ByteBuffer.allocate(1 + len).put((byte)18);
                    for (int i = 0; i < len; ++i) {
                        retval.put((byte)str.charAt(i));
                    }
                    return retval.array();
                }
                ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(str.length() * 2 + 3);
                out.write(21);
                out.writeUTF(str);
                byte[] ret = new byte[out.position()];
                System.arraycopy(out.buffer(), 0, ret, 0, ret.length);
                return ret;
            }
            case 19: {
                byte[] buf = (byte[])obj;
                byte[] buffer = new byte[1 + buf.length];
                buffer[0] = 19;
                System.arraycopy(buf, 0, buffer, 1, buf.length);
                return buffer;
            }
        }
        throw new IllegalArgumentException("type " + type + " is invalid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void objectToStream(Object obj, DataOutput out) throws IOException {
        block20: {
            block22: {
                block21: {
                    if (obj == null) {
                        out.write(0);
                        return;
                    }
                    if (!(obj instanceof Streamable)) break block21;
                    out.write(1);
                    Util.writeGenericStreamable((Streamable)obj, out);
                    break block20;
                }
                Byte type = PRIMITIVE_TYPES.get(obj.getClass());
                if (type == null) break block22;
                if (type != 18) {
                    out.write(type.byteValue());
                }
                switch (type) {
                    case 10: {
                        out.writeBoolean((Boolean)obj);
                        break block20;
                    }
                    case 11: {
                        out.writeByte(((Byte)obj).byteValue());
                        break block20;
                    }
                    case 12: {
                        out.writeChar(((Character)obj).charValue());
                        break block20;
                    }
                    case 13: {
                        out.writeDouble((Double)obj);
                        break block20;
                    }
                    case 14: {
                        out.writeFloat(((Float)obj).floatValue());
                        break block20;
                    }
                    case 15: {
                        out.writeInt((Integer)obj);
                        break block20;
                    }
                    case 16: {
                        out.writeLong((Long)obj);
                        break block20;
                    }
                    case 17: {
                        out.writeShort(((Short)obj).shortValue());
                        break block20;
                    }
                    case 18: {
                        String str = (String)obj;
                        if (Util.isAsciiString(str)) {
                            int len = str.length();
                            out.write(18);
                            out.writeInt(len);
                            for (int i = 0; i < len; ++i) {
                                out.write((byte)str.charAt(i));
                            }
                        } else {
                            out.write(21);
                            out.writeUTF(str);
                        }
                        break block20;
                    }
                    case 19: {
                        byte[] buf = (byte[])obj;
                        out.writeInt(buf.length);
                        out.write(buf, 0, buf.length);
                        break block20;
                    }
                    default: {
                        throw new IllegalArgumentException("type " + type + " is invalid");
                    }
                }
            }
            out.write(2);
            ObjectOutputStream tmp = new ObjectOutputStream(out instanceof ByteArrayDataOutputStream ? new OutputStreamAdapter((ByteArrayDataOutputStream)out) : (OutputStream)((Object)out));
            try {
                tmp.writeObject(obj);
            }
            finally {
                Util.close((Closeable)tmp);
            }
        }
    }

    public static <T> T objectFromStream(DataInput in) throws IOException, ClassNotFoundException {
        return Util.objectFromStream(in, null);
    }

    public static <T> T objectFromStream(DataInput in, ClassLoader loader) throws IOException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        byte b = in.readByte();
        switch (b) {
            case 0: {
                return null;
            }
            case 1: {
                return Util.readGenericStreamable(in, loader);
            }
            case 2: {
                InputStream is = in instanceof ByteArrayDataInputStream ? new InputStreamAdapter((ByteArrayDataInputStream)in) : (InputStream)((Object)in);
                try (ObjectInputStreamWithClassloader tmp = new ObjectInputStreamWithClassloader(is, loader);){
                    Object object = tmp.readObject();
                    return (T)object;
                }
            }
            case 10: {
                return (T)Boolean.valueOf(in.readBoolean());
            }
            case 11: {
                return (T)Byte.valueOf(in.readByte());
            }
            case 12: {
                return (T)Character.valueOf(in.readChar());
            }
            case 13: {
                return (T)Double.valueOf(in.readDouble());
            }
            case 14: {
                return (T)Float.valueOf(in.readFloat());
            }
            case 15: {
                return (T)Integer.valueOf(in.readInt());
            }
            case 16: {
                return (T)Long.valueOf(in.readLong());
            }
            case 17: {
                return (T)Short.valueOf(in.readShort());
            }
            case 18: {
                int str_len = in.readInt();
                if (str_len == 0) {
                    return (T)"";
                }
                byte[] tmp = new byte[str_len];
                for (int i = 0; i < str_len; ++i) {
                    tmp[i] = in.readByte();
                }
                return (T)new String(tmp);
            }
            case 21: {
                return (T)in.readUTF();
            }
            case 19: {
                int len = in.readInt();
                byte[] tmpbuf = new byte[len];
                in.readFully(tmpbuf, 0, tmpbuf.length);
                return (T)tmpbuf;
            }
        }
        throw new IllegalArgumentException("type " + b + " is invalid");
    }

    public static <T extends Streamable> T streamableFromByteBuffer(Class<? extends Streamable> cl, byte[] buffer) throws Exception {
        return Util.streamableFromByteBuffer(cl, buffer, 0, buffer.length);
    }

    public static <T extends Streamable> T streamableFromByteBuffer(Supplier<T> factory, byte[] buffer) throws Exception {
        return Util.streamableFromByteBuffer(factory, buffer, 0, buffer.length);
    }

    public static void exceptionToStream(Throwable t, DataOutput out) throws IOException {
        HashSet<Throwable> causes = new HashSet<Throwable>();
        Util.exceptionToStream(causes, t, out);
    }

    protected static void exceptionToStream(Set<Throwable> causes, Throwable t, DataOutput out) throws IOException {
        if (t == null) {
            out.writeBoolean(true);
            return;
        }
        out.writeBoolean(false);
        boolean invocation_target_ex = t instanceof InvocationTargetException;
        out.writeBoolean(invocation_target_ex);
        if (invocation_target_ex) {
            Util.writeException(causes, t.getCause(), out);
            return;
        }
        Util.writeException(causes, t, out);
    }

    public static Buffer exceptionToBuffer(Throwable t) throws IOException {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(512, true);
        Util.exceptionToStream(t, out);
        return out.getBuffer();
    }

    public static Throwable exceptionFromStream(DataInput in) throws IOException, ClassNotFoundException {
        return Util.exceptionFromStream(in, 0);
    }

    protected static Throwable exceptionFromStream(DataInput in, int recursion_count) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            return null;
        }
        if (in.readBoolean()) {
            return new InvocationTargetException(Util.readException(in, recursion_count));
        }
        return Util.readException(in, recursion_count);
    }

    protected static void writeException(Set<Throwable> causes, Throwable t, DataOutput out) throws IOException {
        Throwable cause;
        Bits.writeString(t.getClass().getName(), out);
        Bits.writeString(t.getMessage(), out);
        StackTraceElement[] stack_trace = t.getStackTrace();
        int depth = stack_trace == null ? 0 : stack_trace.length;
        out.writeShort(depth);
        if (depth > 0) {
            for (int i = 0; i < stack_trace.length; ++i) {
                StackTraceElement trace = stack_trace[i];
                Bits.writeString(trace.getClassName(), out);
                Bits.writeString(trace.getMethodName(), out);
                Bits.writeString(trace.getFileName(), out);
                Bits.writeInt(trace.getLineNumber(), out);
            }
        }
        boolean serialize_cause = (cause = t.getCause()) != null && causes.add(cause);
        out.writeBoolean(serialize_cause);
        if (serialize_cause) {
            Util.exceptionToStream(causes, cause, out);
        }
    }

    protected static Throwable readException(DataInput in, int recursion_count) throws IOException, ClassNotFoundException {
        int depth;
        String classname = Bits.readString(in);
        Class<?> clazz = Util.loadClass(classname, (ClassLoader)null);
        String message = Bits.readString(in);
        Throwable retval = null;
        Constructor<?> ctor = null;
        try {
            ctor = clazz.getDeclaredConstructor(String.class);
            if (ctor != null) {
                if (!ctor.isAccessible()) {
                    ctor.setAccessible(true);
                }
                retval = (Throwable)ctor.newInstance(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (retval == null) {
            try {
                retval = (Throwable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        if ((depth = in.readShort()) > 0) {
            StackTraceElement[] stack_trace = new StackTraceElement[depth];
            for (int i = 0; i < depth; ++i) {
                StackTraceElement trace;
                String class_name = Bits.readString(in);
                String method_name = Bits.readString(in);
                String filename = Bits.readString(in);
                int line_number = Bits.readInt(in);
                stack_trace[i] = trace = new StackTraceElement(class_name, method_name, filename, line_number);
            }
            retval.setStackTrace(stack_trace);
        }
        if (in.readBoolean()) {
            if (++recursion_count > 20) {
                throw new IllegalStateException(String.format("failed deserializing exception: recursion count=%d", recursion_count));
            }
            Throwable cause = Util.exceptionFromStream(in, recursion_count);
            try {
                retval.initCause(cause);
            }
            finally {
                return retval;
            }
        }
    }

    public static Throwable exceptionFromBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, offset, length);
        return Util.exceptionFromStream(in);
    }

    public static void bufferToArray(Address sender, ByteBuffer buf, Receiver target) {
        if (buf == null) {
            return;
        }
        int offset = buf.hasArray() ? buf.arrayOffset() + buf.position() : buf.position();
        int len = buf.remaining();
        if (!buf.isDirect()) {
            target.receive(sender, buf.array(), offset, len);
        } else {
            byte[] tmp = new byte[len];
            buf.get(tmp, 0, len);
            target.receive(sender, tmp, 0, len);
        }
    }

    public static <T extends Streamable> T streamableFromByteBuffer(Class<? extends Streamable> cl, byte[] buffer, int offset, int length) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
        Streamable retval = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        retval.readFrom(in);
        return (T)retval;
    }

    public static <T extends Streamable> T streamableFromByteBuffer(Supplier<T> factory, byte[] buffer, int offset, int length) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
        Streamable retval = (Streamable)factory.get();
        retval.readFrom(in);
        return (T)retval;
    }

    public static <T extends Streamable> T streamableFromBuffer(Supplier<T> factory, byte[] buf, int off, int len) throws IOException, ClassNotFoundException {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buf, off, len);
        return Util.readStreamable(factory, in);
    }

    public static byte[] streamableToByteBuffer(Streamable obj) throws IOException {
        int expected_size = obj instanceof SizeStreamable ? ((SizeStreamable)obj).serializedSize() : 512;
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(expected_size);
        obj.writeTo(out);
        return Arrays.copyOf(out.buffer(), out.position());
    }

    public static Buffer streamableToBuffer(Streamable obj) {
        int expected_size = obj instanceof SizeStreamable ? ((SizeStreamable)obj).serializedSize() + 1 : 512;
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(expected_size);
        try {
            Util.writeStreamable(obj, out);
            return out.getBuffer();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] collectionToByteBuffer(Collection<Address> c) throws IOException {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream((int)Util.size(c));
        Util.writeAddresses(c, (DataOutput)out);
        return Arrays.copyOf(out.buffer(), out.position());
    }

    public static byte[] stringToBytes(String str) {
        if (str == null) {
            return null;
        }
        byte[] retval = new byte[str.length()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (byte)str.charAt(i);
        }
        return retval;
    }

    public static String bytesToString(byte[] bytes) {
        return bytes != null ? new String(bytes) : null;
    }

    public static String byteArrayToHexString(byte[] b) {
        if (b == null) {
            return "null";
        }
        return Util.byteArrayToHexString(b, 0, b.length);
    }

    public static String byteArrayToHexString(byte[] b, int offset, int length) {
        if (b == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            int v = b[i + offset] & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase();
    }

    public static void binaryToAscii(InputStream in, OutputStream out) throws IOException {
        byte[] input = new byte[2];
        while (true) {
            input[0] = (byte)in.read();
            if (input[0] == 10 || input[0] == 13) continue;
            if (input[0] < 0) break;
            input[1] = (byte)in.read();
            if (input[1] == 10 || input[1] < 0) break;
            String tmp = new String(input);
            int val = Integer.parseInt(tmp, 16);
            char c = (char)val;
            out.write(c);
        }
    }

    public static boolean isAsciiString(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < '\u0080') continue;
            return false;
        }
        return true;
    }

    public static int compare(byte[] left, byte[] right) {
        int i = 0;
        for (int j = 0; i < left.length && j < right.length; ++i, ++j) {
            int a = left[i] & 0xFF;
            int b = right[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return left.length - right.length;
    }

    public static Object convert(String arg, Class<?> type) {
        if (type == String.class) {
            return arg;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.valueOf(arg);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.valueOf(arg);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.valueOf(arg);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.valueOf(arg);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.valueOf(arg);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(arg);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.valueOf(arg);
        }
        return arg;
    }

    public static void writeMessage(Message msg, DataOutput dos, boolean multicast) throws IOException {
        int flags = 0;
        dos.writeShort(Version.version);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        dos.writeByte(flags);
        msg.writeTo(dos);
    }

    public static Message readMessage(DataInput instream) throws IOException, ClassNotFoundException {
        Message msg = new Message(false);
        msg.readFrom(instream);
        return msg;
    }

    public static void writeMessageList(Address dest, Address src, byte[] cluster_name, List<Message> msgs, DataOutput dos, boolean multicast, short transport_id) throws IOException {
        Util.writeMessageListHeader(dest, src, cluster_name, msgs != null ? msgs.size() : 0, dos, multicast);
        if (msgs != null) {
            for (Message msg : msgs) {
                msg.writeToNoAddrs(src, dos, transport_id);
            }
        }
    }

    public static void writeMessageListHeader(Address dest, Address src, byte[] cluster_name, int numMsgs, DataOutput dos, boolean multicast) throws IOException {
        dos.writeShort(Version.version);
        int flags = 1;
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        dos.writeByte(flags);
        Util.writeAddress(dest, dos);
        Util.writeAddress(src, dos);
        dos.writeShort(cluster_name != null ? cluster_name.length : -1);
        if (cluster_name != null) {
            dos.write(cluster_name);
        }
        dos.writeInt(numMsgs);
    }

    public static List<Message> readMessageList(DataInput in, short transport_id) throws IOException, ClassNotFoundException {
        byte[] cluster_name;
        LinkedList<Message> list = new LinkedList<Message>();
        Address dest = Util.readAddress(in);
        Address src = Util.readAddress(in);
        short length = in.readShort();
        byte[] byArray = cluster_name = length >= 0 ? new byte[length] : null;
        if (cluster_name != null) {
            in.readFully(cluster_name, 0, cluster_name.length);
        }
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            Message msg = new Message(false);
            msg.readFrom(in);
            msg.setDest(dest);
            if (msg.getSrc() == null) {
                msg.setSrc(src);
            }
            msg.putHeader(transport_id, new TpHeader(cluster_name));
            list.add(msg);
        }
        return list;
    }

    public static MessageBatch[] readMessageBatch(DataInput in, boolean multicast) throws IOException, ClassNotFoundException {
        byte[] cluster_name;
        MessageBatch[] batches = new MessageBatch[4];
        Address dest = Util.readAddress(in);
        Address src = Util.readAddress(in);
        short length = in.readShort();
        byte[] byArray = cluster_name = length >= 0 ? new byte[length] : null;
        if (cluster_name != null) {
            in.readFully(cluster_name, 0, cluster_name.length);
        }
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            Message msg = new Message(false);
            msg.readFrom(in);
            msg.setDest(dest);
            if (msg.getSrc() == null) {
                msg.setSrc(src);
            }
            boolean oob = msg.isFlagSet(Message.Flag.OOB);
            boolean internal = msg.isFlagSet(Message.Flag.INTERNAL);
            int index = 0;
            MessageBatch.Mode mode = MessageBatch.Mode.REG;
            if (oob && !internal) {
                index = 1;
                mode = MessageBatch.Mode.OOB;
            } else if (oob && internal) {
                index = 2;
                mode = MessageBatch.Mode.OOB;
            } else if (!oob && internal) {
                index = 3;
                mode = MessageBatch.Mode.INTERNAL;
            }
            if (batches[index] == null) {
                batches[index] = new MessageBatch(dest, src, cluster_name != null ? new AsciiString(cluster_name) : null, multicast, mode, len);
            }
            batches[index].add(msg);
        }
        return batches;
    }

    public static void parse(byte[] buf, int offset, int length, BiConsumer<Short, Message> msg_consumer, BiConsumer<Short, MessageBatch> batch_consumer, boolean tcp) {
        Util.parse(new ByteArrayInputStream(buf, offset, length), msg_consumer, batch_consumer, tcp);
    }

    public static void parse(String filename, BiConsumer<Short, Message> msg_consumer, BiConsumer<Short, MessageBatch> batch_consumer, boolean tcp) throws FileNotFoundException {
        Util.parse(new FileInputStream(filename), msg_consumer, batch_consumer, tcp);
    }

    public static void parse(InputStream input, BiConsumer<Short, Message> msg_consumer, BiConsumer<Short, MessageBatch> batch_consumer, boolean tcp) {
        if (msg_consumer == null && batch_consumer == null) {
            return;
        }
        byte[] tmp = new byte[4];
        try {
            DataInputStream dis = new DataInputStream(input);
            Throwable throwable = null;
            try {
                try {
                    block9: while (true) {
                        boolean multicast;
                        if (tcp) {
                            dis.readFully(tmp);
                            if (Arrays.equals(Connection.cookie, tmp)) {
                                dis.readShort();
                                dis.readShort();
                                IpAddress peer = new IpAddress();
                                peer.readFrom(dis);
                                continue;
                            }
                        }
                        short version = dis.readShort();
                        byte flags = dis.readByte();
                        boolean is_message_list = (flags & 1) == 1;
                        boolean bl = multicast = (flags & 2) == 2;
                        if (is_message_list) {
                            MessageBatch[] batches;
                            MessageBatch[] messageBatchArray = batches = Util.readMessageBatch(dis, multicast);
                            int n = messageBatchArray.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) continue block9;
                                MessageBatch batch = messageBatchArray[n2];
                                if (batch != null) {
                                    if (batch_consumer != null) {
                                        batch_consumer.accept(version, batch);
                                    } else {
                                        for (Message msg : batch) {
                                            msg_consumer.accept(version, msg);
                                        }
                                    }
                                }
                                ++n2;
                            }
                        }
                        Message msg = Util.readMessage(dis);
                        if (msg_consumer == null) continue;
                        msg_consumer.accept(version, msg);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (dis != null) {
                    if (throwable != null) {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        dis.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (EOFException dis) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void writeView(View view, DataOutput out) throws IOException {
        if (view == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        out.writeBoolean(view instanceof MergeView);
        view.writeTo(out);
    }

    public static View readView(DataInput in) throws IOException, ClassNotFoundException {
        if (!in.readBoolean()) {
            return null;
        }
        boolean isMergeView = in.readBoolean();
        View view = isMergeView ? new MergeView() : new View();
        view.readFrom(in);
        return view;
    }

    public static void writeViewId(ViewId vid, DataOutput out) throws IOException {
        if (vid == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        vid.writeTo(out);
    }

    public static ViewId readViewId(DataInput in) throws IOException, ClassNotFoundException {
        if (!in.readBoolean()) {
            return null;
        }
        ViewId retval = new ViewId();
        retval.readFrom(in);
        return retval;
    }

    public static void writeAddress(Address addr, DataOutput out) throws IOException {
        byte flags = 0;
        boolean streamable_addr = true;
        if (addr == null) {
            flags = Util.setFlag(flags, (byte)1);
            out.writeByte(flags);
            return;
        }
        if (addr instanceof UUID) {
            Class<?> clazz = addr.getClass();
            if (clazz.equals(UUID.class)) {
                flags = Util.setFlag(flags, (byte)2);
            } else if (clazz.equals(SiteUUID.class)) {
                flags = Util.setFlag(flags, (byte)4);
            } else if (clazz.equals(SiteMaster.class)) {
                flags = Util.setFlag(flags, (byte)8);
            } else {
                streamable_addr = false;
            }
        } else if (addr.getClass().equals(IpAddress.class)) {
            flags = Util.setFlag(flags, (byte)16);
        } else if (addr.getClass().equals(IpAddressUUID.class)) {
            flags = Util.setFlag(flags, (byte)32);
        } else {
            streamable_addr = false;
        }
        out.writeByte(flags);
        if (streamable_addr) {
            addr.writeTo(out);
        } else {
            Util.writeOtherAddress(addr, out);
        }
    }

    public static Address readAddress(DataInput in) throws IOException, ClassNotFoundException {
        Address addr;
        byte flags = in.readByte();
        if (Util.isFlagSet(flags, (byte)1)) {
            return null;
        }
        if (Util.isFlagSet(flags, (byte)2)) {
            addr = new UUID();
            addr.readFrom(in);
        } else if (Util.isFlagSet(flags, (byte)4)) {
            addr = new SiteUUID();
            addr.readFrom(in);
        } else if (Util.isFlagSet(flags, (byte)8)) {
            addr = new SiteMaster();
            addr.readFrom(in);
        } else if (Util.isFlagSet(flags, (byte)16)) {
            addr = new IpAddress();
            addr.readFrom(in);
        } else if (Util.isFlagSet(flags, (byte)32)) {
            addr = new IpAddressUUID();
            addr.readFrom(in);
        } else {
            addr = Util.readOtherAddress(in);
        }
        return addr;
    }

    public static int size(Address addr) {
        Class<?> clazz;
        int retval = 1;
        if (addr == null) {
            return retval;
        }
        if (addr instanceof UUID && ((clazz = addr.getClass()).equals(UUID.class) || clazz.equals(SiteUUID.class) || clazz.equals(SiteMaster.class))) {
            return retval + addr.serializedSize();
        }
        if (addr instanceof IpAddress) {
            return retval + addr.serializedSize();
        }
        retval += 2;
        return retval += addr.serializedSize();
    }

    public static int size(View view) {
        int retval = 1;
        if (view != null) {
            retval += view.serializedSize() + 1;
        }
        return retval;
    }

    public static int size(ViewId vid) {
        int retval = 1;
        if (vid != null) {
            retval += vid.serializedSize();
        }
        return retval;
    }

    public static int size(String s) {
        int retval = 1;
        if (s != null) {
            retval += s.length() + 2;
        }
        return retval;
    }

    public static int size(byte[] buf) {
        return buf == null ? 1 : 5 + buf.length;
    }

    private static Address readOtherAddress(DataInput in) throws IOException, ClassNotFoundException {
        short magic_number = in.readShort();
        Address addr = (Address)ClassConfigurator.create(magic_number);
        addr.readFrom(in);
        return addr;
    }

    private static void writeOtherAddress(Address addr, DataOutput out) throws IOException {
        short magic_number = ClassConfigurator.getMagicNumber(addr.getClass());
        if (magic_number == -1) {
            throw new RuntimeException("magic number " + magic_number + " not found");
        }
        out.writeShort(magic_number);
        addr.writeTo(out);
    }

    public static void writeAddresses(Collection<? extends Address> v, DataOutput out) throws IOException {
        if (v == null) {
            out.writeShort(-1);
            return;
        }
        out.writeShort(v.size());
        for (Address address : v) {
            Util.writeAddress(address, out);
        }
    }

    public static void writeAddresses(Address[] addrs, DataOutput out) throws IOException {
        if (addrs == null) {
            out.writeShort(-1);
            return;
        }
        out.writeShort(addrs.length);
        for (Address addr : addrs) {
            Util.writeAddress(addr, out);
        }
    }

    public static <T extends Collection<Address>> T readAddresses(DataInput in, IntFunction<T> factory) throws IOException, ClassNotFoundException {
        int length = in.readShort();
        if (length < 0) {
            return null;
        }
        Collection retval = (Collection)factory.apply(length);
        for (int i = 0; i < length; ++i) {
            Address addr = Util.readAddress(in);
            retval.add(addr);
        }
        return (T)retval;
    }

    public static Address[] readAddresses(DataInput in) throws IOException, ClassNotFoundException {
        int length = in.readShort();
        if (length < 0) {
            return null;
        }
        Address[] retval = new Address[length];
        for (int i = 0; i < length; ++i) {
            Address addr;
            retval[i] = addr = Util.readAddress(in);
        }
        return retval;
    }

    public static long size(Collection<? extends Address> addrs) {
        int retval = 2;
        if (addrs != null && !addrs.isEmpty()) {
            Address addr = addrs.iterator().next();
            retval += Util.size(addr) * addrs.size();
        }
        return retval;
    }

    public static long size(Address[] addrs) {
        int retval = 2;
        if (addrs != null) {
            for (Address addr : addrs) {
                retval += Util.size(addr);
            }
        }
        return retval;
    }

    public static void writeStreamable(Streamable obj, DataOutput out) throws IOException {
        if (obj == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        obj.writeTo(out);
    }

    public static <T extends Streamable> T readStreamable(Supplier<T> factory, DataInput in) throws IOException, ClassNotFoundException {
        Streamable retval = null;
        if (!in.readBoolean()) {
            return null;
        }
        retval = (Streamable)factory.get();
        retval.readFrom(in);
        return (T)retval;
    }

    public static void writeGenericStreamable(Streamable obj, DataOutput out) throws IOException {
        if (obj == null) {
            out.write(0);
            return;
        }
        out.write(1);
        short magic_number = ClassConfigurator.getMagicNumber(obj.getClass());
        out.writeShort(magic_number);
        if (magic_number == -1) {
            String classname = obj.getClass().getName();
            out.writeUTF(classname);
        }
        obj.writeTo(out);
    }

    public static <T extends Streamable> T readGenericStreamable(DataInput in) throws IOException, ClassNotFoundException {
        return Util.readGenericStreamable(in, null);
    }

    public static <T extends Streamable> T readGenericStreamable(DataInput in, ClassLoader loader) throws IOException, ClassNotFoundException {
        Streamable retval = null;
        byte b = in.readByte();
        if (b == 0) {
            return null;
        }
        short magic_number = in.readShort();
        if (magic_number != -1) {
            retval = (Streamable)ClassConfigurator.create(magic_number);
        } else {
            String classname = in.readUTF();
            Class clazz = ClassConfigurator.get(classname, loader);
            try {
                retval = (Streamable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        retval.readFrom(in);
        return (T)retval;
    }

    public static <T extends Streamable> void write(T[] array, DataOutput out) throws IOException {
        Bits.writeInt(array != null ? array.length : 0, out);
        if (array == null) {
            return;
        }
        for (T el : array) {
            el.writeTo(out);
        }
    }

    public static <T extends Streamable> T[] read(Class<T> clazz, DataInput in) throws Exception {
        int size = Bits.readInt(in);
        if (size == 0) {
            return null;
        }
        Streamable[] retval = (Streamable[])Array.newInstance(clazz, size);
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (Streamable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            retval[i].readFrom(in);
        }
        return retval;
    }

    public static void writeObject(Object obj, DataOutput out) throws IOException {
        if (obj instanceof Streamable) {
            out.writeInt(-1);
            Util.writeGenericStreamable((Streamable)obj, out);
        } else {
            byte[] buf = Util.objectToByteBuffer(obj);
            out.writeInt(buf.length);
            out.write(buf, 0, buf.length);
        }
    }

    public static Object readObject(DataInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        if (len == -1) {
            return Util.readGenericStreamable(in);
        }
        byte[] buf = new byte[len];
        in.readFully(buf, 0, len);
        return Util.objectFromByteBuffer(buf);
    }

    public static String readFile(String filename) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(filename);
        try {
            String string = Util.readContents(in);
            return string;
        }
        finally {
            Util.close((Closeable)in);
        }
    }

    public static String readContents(InputStream input) {
        StringBuilder sb = new StringBuilder();
        try {
            int ch;
            while ((ch = input.read()) != -1) {
                sb.append((char)ch);
            }
        }
        catch (IOException e) {
        }
        return sb.toString();
    }

    public static byte[] readFileContents(InputStream input) throws IOException {
        int tmp;
        byte[] contents = new byte[10000];
        byte[] buf = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(input);
        int bytes_read = 0;
        while ((tmp = ((InputStream)in).read(buf, 0, buf.length)) != -1) {
            System.arraycopy(buf, 0, contents, bytes_read, tmp);
            bytes_read += tmp;
        }
        byte[] retval = new byte[bytes_read];
        System.arraycopy(contents, 0, retval, 0, bytes_read);
        return retval;
    }

    public static String readToken(InputStream in) {
        StringBuilder sb;
        block6: {
            sb = new StringBuilder();
            boolean first = true;
            try {
                while (true) {
                    int ch;
                    if ((ch = in.read()) == -1) {
                        return sb.length() > 0 ? sb.toString() : null;
                    }
                    if (Character.isWhitespace(ch)) {
                        if (first) {
                            continue;
                        }
                        break block6;
                    }
                    sb.append((char)ch);
                    first = false;
                }
            }
            catch (IOException e) {}
            {
            }
        }
        return sb.toString();
    }

    public static String readStringFromStdin(String message) throws Exception {
        System.out.print(message);
        System.out.flush();
        System.in.skip(System.in.available());
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String line = reader.readLine();
        return line != null ? line.trim() : null;
    }

    public static long readLongFromStdin(String message) throws Exception {
        String tmp = Util.readStringFromStdin(message);
        return Long.parseLong(tmp);
    }

    public static double readDoubleFromStdin(String message) throws Exception {
        String tmp = Util.readStringFromStdin(message);
        return Double.parseDouble(tmp);
    }

    public static int readIntFromStdin(String message) throws Exception {
        String tmp = Util.readStringFromStdin(message);
        return Integer.parseInt(tmp);
    }

    public static void writeByteBuffer(byte[] buf, DataOutput out) throws IOException {
        Util.writeByteBuffer(buf, 0, buf.length, out);
    }

    public static void writeByteBuffer(byte[] buf, int offset, int length, DataOutput out) throws IOException {
        if (buf != null) {
            out.write(1);
            out.writeInt(length);
            out.write(buf, offset, length);
        } else {
            out.write(0);
        }
    }

    public static byte[] readByteBuffer(DataInput in) throws IOException {
        int b = in.readByte();
        if (b == 1) {
            b = in.readInt();
            byte[] buf = new byte[b];
            in.readFully(buf, 0, buf.length);
            return buf;
        }
        return null;
    }

    public static Buffer messageToByteBuffer(Message msg) throws IOException {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream((int)msg.size() + 1);
        out.writeBoolean(msg != null);
        if (msg != null) {
            msg.writeTo(out);
        }
        return out.getBuffer();
    }

    public static Message byteBufferToMessage(byte[] buffer, int offset, int length) throws IOException, ClassNotFoundException {
        ByteArrayDataInputStream in = new ByteArrayDataInputStream(buffer, offset, length);
        if (!in.readBoolean()) {
            return null;
        }
        Message msg = new Message(false);
        msg.readFrom(in);
        return msg;
    }

    public static <T> boolean match(T obj1, T obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return obj2.equals(obj1);
    }

    public static boolean match(long[] a1, long[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.hashCode() == a2.hashCode()) {
            return true;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean patternMatch(String pattern, String str) {
        Pattern pat = Pattern.compile(pattern);
        Matcher matcher = pat.matcher(str);
        return matcher.matches();
    }

    public static boolean productGreaterThan(long n1, long n2, long val) {
        long div = (long)Math.floor((double)val / (double)n1);
        return div < n2;
    }

    public static <T> boolean different(T one, T two) {
        return !Util.match(one, two);
    }

    public static void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void sleep(long timeout, int nanos) {
        if (timeout > 0L || nanos > 900000) {
            try {
                Thread.sleep(timeout + (long)(nanos / 1000000), nanos % 1000000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            long initialTime = System.nanoTime() - 200L;
            while (System.nanoTime() < initialTime + (long)nanos) {
            }
        }
    }

    public static int keyPress(String msg) {
        System.out.println(msg);
        try {
            int ret = System.in.read();
            System.in.skip(System.in.available());
            return ret;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public static long micros() {
        return System.nanoTime() / 1000L;
    }

    public static int factorial(int n) {
        if (n == 1) {
            return n;
        }
        return n * Util.factorial(n - 1);
    }

    public static <E> void permute(List<E> list, List<List<E>> permutations) {
        if (list.size() == 1) {
            permutations.add(list);
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Util.permute(null, list, i, permutations);
        }
    }

    protected static <E> void permute(List<E> prefix, List<E> list, int index, List<List<E>> permutations) {
        if (list.size() <= 1) {
            permutations.add(Util.combine(prefix, list));
        } else {
            List<E> swapped = Util.swap(list, index);
            List<E> first = Util.car(swapped);
            List<E> rest = Util.cdr(swapped);
            for (int i = 0; i < rest.size(); ++i) {
                Util.permute(Util.combine(prefix, first), rest, i, permutations);
            }
        }
    }

    public static <E> List<E> car(List<E> l) {
        return l.isEmpty() ? Collections.emptyList() : Collections.singletonList(l.get(0));
    }

    public static <E> List<E> cdr(List<E> l) {
        return l.isEmpty() ? Collections.emptyList() : l.subList(1, l.size());
    }

    public static <E> List<E> combine(List<E> l1, List<E> l2) {
        ArrayList<E> retval = new ArrayList<E>();
        if (l1 != null) {
            retval.addAll(l1);
        }
        if (l2 != null) {
            retval.addAll(l2);
        }
        return retval;
    }

    protected static <E> List<E> swap(List<E> l, int index) {
        ArrayList<E> swapped = new ArrayList<E>();
        E el = l.get(index);
        swapped.add(el);
        for (int i = 0; i < l.size(); ++i) {
            el = l.get(i);
            if (i == index) continue;
            swapped.add(el);
        }
        return swapped;
    }

    public static <E> Collection<List<E>> orderedPermutation(List<E> a, List<E> b) {
        List<E> perm;
        ArrayList<E> l2;
        ArrayList<E> l1;
        int j;
        int i;
        LinkedHashSet<List<List<E>>> perms = new LinkedHashSet<List<List<E>>>();
        for (i = 0; i <= a.size(); ++i) {
            for (j = 0; j <= b.size(); ++j) {
                if (i == 0 && j == 0) continue;
                l1 = new ArrayList<E>(a);
                l2 = new ArrayList<E>(b);
                perm = Util.permute(l1, l2, i, j);
                perms.add(perm);
            }
        }
        for (i = 0; i <= b.size(); ++i) {
            for (j = 0; j <= a.size(); ++j) {
                if (i == 0 && j == 0) continue;
                l1 = new ArrayList<E>(b);
                l2 = new ArrayList<E>(a);
                perm = Util.permute(l1, l2, i, j);
                perms.add(perm);
            }
        }
        return perms;
    }

    protected static <E> List<E> permute(List<E> l1, List<E> l2, int remove_from_l1, int remove_from_l2) {
        ArrayList<E> retval = new ArrayList<E>();
        while (!l1.isEmpty() && !l2.isEmpty()) {
            int a = remove_from_l1;
            int b = remove_from_l2;
            while (a-- > 0 && !l1.isEmpty()) {
                retval.add(l1.remove(0));
            }
            while (b-- > 0 && !l2.isEmpty()) {
                retval.add(l2.remove(0));
            }
        }
        retval.addAll(l1);
        retval.addAll(l2);
        return retval;
    }

    @SafeVarargs
    public static <E> boolean checkOrder(Collection<E> perm, List<E> ... lists) {
        for (List<E> list : lists) {
            if (!perm.containsAll(list)) {
                return false;
            }
            int pos = 0;
            for (E el : list) {
                int index = Util.index(perm, el);
                if (index < pos) {
                    return false;
                }
                pos = index;
            }
        }
        return true;
    }

    protected static <E> int index(Collection<E> list, E el) {
        int index = 0;
        for (E element : list) {
            if (element.equals(el)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static <T> void shuffle(T[] array, int from, int to) {
        if (array == null) {
            return;
        }
        for (int i = from; i < to; ++i) {
            int random = (int)Util.random(to);
            int other = random - 1 + from;
            if (i == other) continue;
            T tmp = array[i];
            array[i] = array[other];
            array[other] = tmp;
        }
    }

    public static long random(long range) {
        return range == 0L ? 1L : ThreadLocalRandom.current().nextLong(range) + 1L;
    }

    public static void sleepRandom(long floor, long ceiling) {
        if (ceiling - floor <= 0L) {
            return;
        }
        long diff = ceiling - floor;
        long r = (long)((int)(Math.random() * 100000.0 % (double)diff)) + floor;
        Util.sleep(r);
    }

    public static boolean tossWeightedCoin(double probability) {
        long cutoff;
        if (probability >= 1.0) {
            return true;
        }
        if (probability <= 0.0) {
            return false;
        }
        long r = Util.random(100L);
        return r < (cutoff = (long)(probability * 100.0));
    }

    public static String dumpThreads() {
        StringBuilder sb = new StringBuilder();
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] ids = bean.getAllThreadIds();
        Util._printThreads(bean, ids, sb);
        long[] deadlocks = bean.findDeadlockedThreads();
        if (deadlocks != null && deadlocks.length > 0) {
            sb.append("deadlocked threads:\n");
            Util._printThreads(bean, deadlocks, sb);
        }
        if ((deadlocks = bean.findMonitorDeadlockedThreads()) != null && deadlocks.length > 0) {
            sb.append("monitor deadlocked threads:\n");
            Util._printThreads(bean, deadlocks, sb);
        }
        return sb.toString();
    }

    protected static void _printThreads(ThreadMXBean bean, long[] ids, StringBuilder sb) {
        ThreadInfo[] threads;
        for (ThreadInfo info : threads = bean.getThreadInfo(ids, 20)) {
            StackTraceElement[] stack_trace;
            if (info == null) continue;
            sb.append(info.getThreadName()).append(":\n");
            for (StackTraceElement el : stack_trace = info.getStackTrace()) {
                sb.append("    at ").append(el.getClassName()).append(".").append(el.getMethodName());
                sb.append("(").append(el.getFileName()).append(":").append(el.getLineNumber()).append(")");
                sb.append("\n");
            }
            sb.append("\n\n");
        }
    }

    public static boolean interruptAndWaitToDie(Thread t) {
        return Util.interruptAndWaitToDie(t, 300L);
    }

    public static boolean interruptAndWaitToDie(Thread t, long timeout) {
        if (t == null) {
            throw new IllegalArgumentException("Thread can not be null");
        }
        t.interrupt();
        try {
            t.join(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return t.isAlive();
    }

    public static String mapToString(Map<? extends Object, ? extends Object> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            sb.append(key).append("=");
            if (val == null) {
                sb.append("null");
            } else {
                sb.append(val);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String printNanos(long time_ns) {
        double us = (double)time_ns / 1000.0;
        return String.format("%d ns (%.2f us)", time_ns, us);
    }

    public static String printNanos(double time_ns) {
        double us = time_ns / 1000.0;
        return String.format("%.2f ns (%.2f us)", time_ns, us);
    }

    public static String printTime(long time, TimeUnit unit) {
        long ns = TimeUnit.NANOSECONDS.convert(time, unit);
        long us = TimeUnit.MICROSECONDS.convert(time, unit);
        long ms = TimeUnit.MILLISECONDS.convert(time, unit);
        long secs = TimeUnit.SECONDS.convert(time, unit);
        if (secs > 0L) {
            return secs + "s";
        }
        if (ms > 0L) {
            return ms + "ms";
        }
        if (us > 0L) {
            return us + " us";
        }
        return ns + "ns";
    }

    public static long readBytesLong(String input) {
        Tuple<String, Long> tuple = Util.readBytes(input);
        double num = Double.parseDouble(tuple.getVal1());
        return (long)(num * (double)tuple.getVal2().longValue());
    }

    public static int readBytesInteger(String input) {
        Tuple<String, Long> tuple = Util.readBytes(input);
        double num = Double.parseDouble(tuple.getVal1());
        return (int)(num * (double)tuple.getVal2().longValue());
    }

    public static double readBytesDouble(String input) {
        Tuple<String, Long> tuple = Util.readBytes(input);
        double num = Double.parseDouble(tuple.getVal1());
        return num * (double)tuple.getVal2().longValue();
    }

    private static Tuple<String, Long> readBytes(String input) {
        input = input.trim().toLowerCase();
        int index = -1;
        long factor = 1L;
        index = input.indexOf(107);
        if (index != -1) {
            factor = 1000L;
        } else {
            index = input.indexOf("kb");
            if (index != -1) {
                factor = 1000L;
            } else {
                index = input.indexOf(109);
                if (index != -1) {
                    factor = 1000000L;
                } else {
                    index = input.indexOf("mb");
                    if (index != -1) {
                        factor = 1000000L;
                    } else {
                        index = input.indexOf(103);
                        if (index != -1) {
                            factor = 1000000000L;
                        } else {
                            index = input.indexOf("gb");
                            if (index != -1) {
                                factor = 1000000000L;
                            }
                        }
                    }
                }
            }
        }
        String str = index != -1 ? input.substring(0, index) : input;
        return new Tuple<String, Long>(str, factor);
    }

    public static String printBytes(long bytes) {
        if (bytes < 1000L) {
            return String.format("%db", bytes);
        }
        if (bytes < 1000000L) {
            double tmp = (double)bytes / 1000.0;
            return String.format("%,.2fKB", tmp);
        }
        if (bytes < 1000000000L) {
            double tmp = (double)bytes / 1000000.0;
            return String.format("%,.2fMB", tmp);
        }
        double tmp = (double)bytes / 1.0E9;
        return String.format("%,.2fGB", tmp);
    }

    public static String printBytes(double bytes) {
        if (bytes < 1000.0) {
            return String.format("%.2fb", bytes);
        }
        if (bytes < 1000000.0) {
            double tmp = bytes / 1000.0;
            return String.format("%,.2fKB", tmp);
        }
        if (bytes < 1.0E9) {
            double tmp = bytes / 1000000.0;
            return String.format("%,.2fMB", tmp);
        }
        double tmp = bytes / 1.0E9;
        return String.format("%,.2fGB", tmp);
    }

    public static String[] components(String path, String separator) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        String[] tmp = path.split(separator + "+");
        if (tmp == null) {
            return null;
        }
        if (tmp.length == 0) {
            return null;
        }
        if (tmp[0].isEmpty()) {
            tmp[0] = separator;
        }
        return tmp;
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size, int length) {
        int tmp_size = 0;
        int index = 0;
        int num_frags = length % frag_size == 0 ? length / frag_size : length / frag_size + 1;
        byte[][] retval = new byte[num_frags][];
        for (int accumulated_size = 0; accumulated_size < length; accumulated_size += tmp_size) {
            tmp_size = accumulated_size + frag_size <= length ? frag_size : length - accumulated_size;
            byte[] fragment = new byte[tmp_size];
            System.arraycopy(buf, accumulated_size, fragment, 0, tmp_size);
            retval[index++] = fragment;
        }
        return retval;
    }

    public static List<Range> computeFragOffsets(int offset, int length, int frag_size) {
        int num_frags = (int)Math.ceil((double)length / (double)frag_size);
        ArrayList<Range> retval = new ArrayList<Range>(num_frags);
        long total_size = (long)length + (long)offset;
        int index = offset;
        int tmp_size = 0;
        while ((long)index < total_size) {
            tmp_size = (long)(index + frag_size) <= total_size ? frag_size : (int)(total_size - (long)index);
            Range r = new Range(index, tmp_size);
            retval.add(r);
            index += tmp_size;
        }
        return retval;
    }

    public static List<Range> computeFragOffsets(byte[] buf, int frag_size) {
        return Util.computeFragOffsets(0, buf.length, frag_size);
    }

    public static byte[] defragmentBuffer(byte[][] fragments) {
        int i;
        int total_length = 0;
        int index = 0;
        if (fragments == null) {
            return null;
        }
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            total_length += fragments[i].length;
        }
        byte[] ret = new byte[total_length];
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            System.arraycopy(fragments[i], 0, ret, index, fragments[i].length);
            index += fragments[i].length;
        }
        return ret;
    }

    public static <T> boolean allEqual(Collection<T> elements) {
        if (elements.isEmpty()) {
            return false;
        }
        Iterator<T> it = elements.iterator();
        T first = it.next();
        while (it.hasNext()) {
            T el = it.next();
            if (el.equals(first)) continue;
            return false;
        }
        return true;
    }

    public static <T> String printListWithDelimiter(Collection<T> list, String delimiter) {
        return Util.printListWithDelimiter(list, delimiter, MAX_LIST_PRINT_SIZE, true);
    }

    public static <T> String printListWithDelimiter(Collection<T> list, String delimiter, int limit) {
        return Util.printListWithDelimiter(list, delimiter, limit, true);
    }

    public static <T> String printListWithDelimiter(Collection<T> list, String delimiter, int limit, boolean print_size) {
        boolean first = true;
        int count = 0;
        int size = print_size ? list.size() : 0;
        StringBuilder sb = new StringBuilder(print_size ? "(" + size + ") " : "");
        for (T el : list) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(el);
            if (limit <= 0 || ++count < limit) continue;
            if (size <= count) break;
            sb.append(" ...");
            break;
        }
        return sb.toString();
    }

    public static <T> String printListWithDelimiter(T[] list, String delimiter, int limit) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int size = list.length;
        for (T el : list) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(el);
            if (limit <= 0 || ++count < limit) continue;
            if (size <= count) break;
            sb.append(" ...");
            break;
        }
        return sb.toString();
    }

    public static <T> String printMapWithDelimiter(Map<T, T> map, String delimiter) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<T, T> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public static List<Address> leftMembers(Collection<Address> old_list, Collection<Address> new_list) {
        if (old_list == null || new_list == null) {
            return null;
        }
        ArrayList<Address> retval = new ArrayList<Address>(old_list);
        retval.removeAll(new_list);
        return retval;
    }

    public static List<Address> newMembers(List<Address> old_list, List<Address> new_list) {
        if (old_list == null || new_list == null) {
            return null;
        }
        ArrayList<Address> retval = new ArrayList<Address>(new_list);
        retval.removeAll(old_list);
        return retval;
    }

    public static <T> List<T> newElements(List<T> old_list, List<T> new_list) {
        if (new_list == null) {
            return new ArrayList();
        }
        ArrayList<T> retval = new ArrayList<T>(new_list);
        if (old_list != null) {
            retval.removeAll(old_list);
        }
        return retval;
    }

    public static <T> boolean contains(T key, T[] list) {
        if (list == null) {
            return false;
        }
        for (T tmp : list) {
            if (tmp != key && !tmp.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsViewId(Collection<View> views, ViewId vid) {
        for (View view : views) {
            ViewId tmp = view.getViewId();
            if (!tmp.equals(vid)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsId(short id, short[] ids) {
        if (ids == null) {
            return false;
        }
        for (short tmp : ids) {
            if (tmp != id) continue;
            return true;
        }
        return false;
    }

    public static List<View> detectDifferentViews(Map<Address, View> map) {
        ArrayList<View> ret = new ArrayList<View>();
        for (View view : map.values()) {
            ViewId vid;
            if (view == null || Util.containsViewId(ret, vid = view.getViewId())) continue;
            ret.add(view);
        }
        return ret;
    }

    public static Collection<Address> determineMergeParticipants(Map<Address, View> map) {
        HashSet<Address> coords = new HashSet<Address>();
        HashSet<Address> all_addrs = new HashSet<Address>();
        if (map == null) {
            return Collections.emptyList();
        }
        for (View view : map.values()) {
            all_addrs.addAll(view.getMembers());
        }
        for (View view : map.values()) {
            Address coord = view.getCreator();
            if (coord == null) continue;
            coords.add(coord);
        }
        for (Address coord : coords) {
            View view = map.get(coord);
            List<Address> mbrs = view != null ? view.getMembers() : null;
            if (mbrs == null) continue;
            all_addrs.removeAll(mbrs);
        }
        coords.addAll(all_addrs);
        return coords;
    }

    public static Collection<Address> determineMergeCoords(Map<Address, View> map) {
        HashSet<Address> retval = new HashSet<Address>();
        if (map != null) {
            for (View view : map.values()) {
                Address coord = view.getCreator();
                if (coord == null) continue;
                retval.add(coord);
            }
        }
        return retval;
    }

    public static Collection<Address> determineActualMergeCoords(Map<Address, View> map) {
        HashSet<Address> retval = new HashSet<Address>();
        if (map != null) {
            for (Map.Entry<Address, View> entry : map.entrySet()) {
                List<Address> members;
                Address actual_coord;
                Address sender = entry.getKey();
                if (!sender.equals(actual_coord = (members = entry.getValue().getMembers()).isEmpty() ? null : members.get(0))) continue;
                retval.add(sender);
            }
        }
        return retval;
    }

    public static int getRank(View view, Address addr) {
        if (view == null || addr == null) {
            return 0;
        }
        List<Address> members = view.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            Address mbr = members.get(i);
            if (!mbr.equals(addr)) continue;
            return i + 1;
        }
        return 0;
    }

    public static int getRank(Collection<Address> members, Address addr) {
        if (members == null || addr == null) {
            return -1;
        }
        int index = 0;
        for (Address mbr : members) {
            if (mbr.equals(addr)) {
                return index + 1;
            }
            ++index;
        }
        return -1;
    }

    public static <T> T pickRandomElement(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int size = list.size();
        int index = (int)Util.random(size) - 1;
        return list.get(index);
    }

    public static <T> T pickRandomElement(Set<T> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        int size = set.size();
        int random = (int)Util.random(size) - 1;
        for (T el : set) {
            if (random-- > 0) continue;
            return el;
        }
        return null;
    }

    public static <T> T pickRandomElement(T[] array) {
        if (array == null) {
            return null;
        }
        int size = array.length;
        int index = (int)Util.random(size) - 1;
        return array[index];
    }

    public static <T> T pickNext(List<T> list, T obj) {
        if (list == null || obj == null) {
            return null;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            T tmp = list.get(i);
            if (!Objects.equals(tmp, obj)) continue;
            return list.get((i + 1) % size);
        }
        return null;
    }

    public static <T> List<T> pickNext(List<T> list, T obj, int num) {
        ArrayList<T> retval = new ArrayList<T>();
        if (list == null || list.size() < 2) {
            return retval;
        }
        int index = list.indexOf(obj);
        if (index != -1) {
            for (int i = 1; i <= num && i < list.size(); ++i) {
                T tmp = list.get((index + i) % list.size());
                if (retval.contains(tmp)) continue;
                retval.add(tmp);
            }
        }
        return retval;
    }

    public static byte[] generateArray(int size) {
        byte[] retval = new byte[size];
        for (int i = 0; i < retval.length; ++i) {
            byte b;
            retval[i] = b = (byte)Util.random(26L);
        }
        return retval;
    }

    public static Address createRandomAddress() {
        return Util.createRandomAddress(Util.generateLocalName());
    }

    public static Address[] createRandomAddresses(int num) {
        return Util.createRandomAddresses(num, false);
    }

    public static Address[] createRandomAddresses(int num, boolean use_numbers) {
        Address[] addresses = new Address[num];
        int number = 1;
        char c = 'A';
        for (int i = 0; i < addresses.length; ++i) {
            String string;
            if (use_numbers) {
                string = String.valueOf(number++);
            } else {
                char c2 = c;
                c = (char)(c + 1);
                string = String.valueOf(c2);
            }
            addresses[i] = Util.createRandomAddress(string);
        }
        return addresses;
    }

    public static Address createRandomAddress(String name) {
        UUID retval = UUID.randomUUID();
        NameCache.add(retval, name);
        return retval;
    }

    public static Object[][] createTimer() {
        return new Object[][]{{new TimeScheduler3()}};
    }

    public static List<Address> determineLeftMembers(List<Address> old_mbrs, List<Address> new_mbrs) {
        ArrayList<Address> retval = new ArrayList<Address>();
        if (old_mbrs == null || new_mbrs == null) {
            return retval;
        }
        for (int i = 0; i < old_mbrs.size(); ++i) {
            Address mbr = old_mbrs.get(i);
            if (new_mbrs.contains(mbr)) continue;
            retval.add(mbr);
        }
        return retval;
    }

    public static <T> String print(Collection<T> objs) {
        return objs == null ? "null" : objs.stream().map(Objects::toString).collect(Collectors.joining(", "));
    }

    public static <T> String print(Map<T, T> map) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<T, T> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return sb.toString();
    }

    public static String printPingData(List<PingData> rsps) {
        StringBuilder sb = new StringBuilder();
        if (rsps != null) {
            int total = rsps.size();
            int servers = 0;
            int clients = 0;
            int coords = 0;
            for (PingData rsp : rsps) {
                if (rsp.isCoord()) {
                    ++coords;
                }
                if (rsp.isServer()) {
                    ++servers;
                    continue;
                }
                ++clients;
            }
            sb.append(total + " total (" + servers + " servers (" + coords + " coord), " + clients + " clients)");
        }
        return sb.toString();
    }

    public static String print(ByteBuffer buf) {
        return buf == null ? "null" : String.format("[pos=%d lim=%d cap=%d]", buf.position(), buf.limit(), buf.capacity());
    }

    public static Class loadClass(String classname, Class clazz) throws ClassNotFoundException {
        return Util.loadClass(classname, clazz != null ? clazz.getClassLoader() : null);
    }

    public static Class<?> loadClass(String classname, ClassLoader preferredLoader) throws ClassNotFoundException {
        ClassNotFoundException exception = null;
        List<ClassLoader> list = preferredLoader != null ? Arrays.asList(preferredLoader, Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()) : Arrays.asList(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader());
        for (ClassLoader loader : list) {
            try {
                return loader.loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        throw exception;
    }

    @SafeVarargs
    public static Field[] getAllDeclaredFieldsWithAnnotations(Class clazz, Class<? extends Annotation> ... annotations) {
        ArrayList<Field> list = new ArrayList<Field>(30);
        for (Class curr = clazz; curr != null; curr = curr.getSuperclass()) {
            Field[] fields = curr.getDeclaredFields();
            if (fields == null) continue;
            for (Field field : fields) {
                if (annotations != null && annotations.length > 0) {
                    for (Class<? extends Annotation> annotation : annotations) {
                        if (!field.isAnnotationPresent(annotation)) continue;
                        list.add(field);
                    }
                    continue;
                }
                list.add(field);
            }
        }
        Field[] retval = new Field[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retval[i] = (Field)list.get(i);
        }
        return retval;
    }

    public static void forAllFieldsAndMethods(Object obj, Predicate<? super AccessibleObject> filter, BiConsumer<Field, Object> field_func, BiConsumer<Method, Object> method_func) {
        Objects.requireNonNull(obj, "target object cannot be null");
        if (field_func != null) {
            Stream.of(Util.getAllDeclaredFieldsWithAnnotations(obj.getClass(), new Class[0])).filter(f -> filter != null && filter.test((AccessibleObject)f)).forEach(f -> field_func.accept((Field)f, obj));
        }
        if (method_func != null) {
            Stream.of(Util.getAllDeclaredMethodsWithAnnotations(obj.getClass(), new Class[0])).filter(m -> filter != null && filter.test((AccessibleObject)m)).forEach(m -> method_func.accept((Method)m, obj));
        }
    }

    public static String getNameFromAnnotation(AccessibleObject obj) {
        String attr_name;
        ManagedAttribute attr_annotation = obj.getAnnotation(ManagedAttribute.class);
        Property prop = obj.getAnnotation(Property.class);
        String string = attr_annotation != null ? attr_annotation.name() : (attr_name = prop != null ? prop.name() : null);
        if (attr_name != null && !attr_name.trim().isEmpty()) {
            return attr_name.trim();
        }
        return ((Member)((Object)obj)).getName();
    }

    @SafeVarargs
    public static Method[] getAllDeclaredMethodsWithAnnotations(Class clazz, Class<? extends Annotation> ... annotations) {
        ArrayList<Method> list = new ArrayList<Method>(30);
        for (Class curr = clazz; curr != null; curr = curr.getSuperclass()) {
            Method[] methods = curr.getDeclaredMethods();
            if (methods == null) continue;
            for (Method method : methods) {
                if (annotations != null && annotations.length > 0) {
                    for (Class<? extends Annotation> annotation : annotations) {
                        if (!method.isAnnotationPresent(annotation)) continue;
                        list.add(method);
                    }
                    continue;
                }
                list.add(method);
            }
        }
        Method[] retval = new Method[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retval[i] = (Method)list.get(i);
        }
        return retval;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotationClass) {
        for (Class<?> curr = clazz; curr != null; curr = curr.getSuperclass()) {
            A ann = curr.getAnnotation(annotationClass);
            if (ann == null) continue;
            return ann;
        }
        return null;
    }

    public static Field getField(Class clazz, String field_name) {
        try {
            return Util.getField(clazz, field_name, false);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Field getField(Class clazz, String field_name, boolean throw_exception) throws NoSuchFieldException {
        if (clazz == null || field_name == null) {
            return null;
        }
        Field field = null;
        for (Class curr = clazz; curr != null; curr = curr.getSuperclass()) {
            try {
                return curr.getDeclaredField(field_name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        if (field == null && throw_exception) {
            throw new NoSuchFieldException(String.format("%s not found in %s or superclasses", field_name, clazz.getName()));
        }
        return field;
    }

    public static void setField(Field field, Object target, Object value) {
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not set field " + field, iae);
        }
    }

    public static Object getField(Field field, Object target) {
        if (!Modifier.isPublic(field.getModifiers())) {
            field.setAccessible(true);
        }
        try {
            return field.get(target);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Could not get field " + field, iae);
        }
    }

    public static Field findField(Object target, List<String> possible_names) {
        if (target == null) {
            return null;
        }
        for (Class<?> clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (String name : possible_names) {
                try {
                    return clazz.getDeclaredField(name);
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public static Method findMethod(Object target, List<String> possible_names, Class<?> ... parameter_types) {
        if (target == null) {
            return null;
        }
        return Util.findMethod(target.getClass(), possible_names, parameter_types);
    }

    public static Method findMethod(Class<?> root_class, List<String> possible_names, Class<?> ... parameter_types) {
        for (Class<?> clazz = root_class; clazz != null; clazz = clazz.getSuperclass()) {
            for (String name : possible_names) {
                try {
                    return clazz.getDeclaredMethod(name, parameter_types);
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public static <T> Set<Class<T>> findClassesAssignableFrom(String packageName, Class<T> assignableFrom) throws IOException, ClassNotFoundException {
        String filePath;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        String path = packageName.replace('.', '/');
        URL resource = loader.getResource(path);
        if (resource != null && (filePath = resource.getFile()) != null && new File(filePath).isDirectory()) {
            for (String file : new File(filePath).list()) {
                String name;
                Class<?> clazz;
                if (!file.endsWith(".class") || !assignableFrom.isAssignableFrom(clazz = Class.forName(name = packageName + '.' + file.substring(0, file.indexOf(".class"))))) continue;
                classes.add(clazz);
            }
        }
        return classes;
    }

    public static List<Class<?>> findClassesAnnotatedWith(String packageName, Class<? extends Annotation> a) throws IOException, ClassNotFoundException {
        ArrayList classes = new ArrayList();
        Util.recurse(classes, packageName, a);
        return classes;
    }

    private static void recurse(List<Class<?>> classes, String packageName, Class<? extends Annotation> a) throws ClassNotFoundException {
        String filePath;
        String path;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL resource = loader.getResource(path = packageName.replace('.', '/'));
        if (resource != null && (filePath = resource.getFile()) != null && new File(filePath).isDirectory()) {
            for (String file : new File(filePath).list()) {
                if (file.endsWith(".class")) {
                    String name = packageName + '.' + file.substring(0, file.indexOf(".class"));
                    Class<?> clazz = Class.forName(name);
                    if (!clazz.isAnnotationPresent(a)) continue;
                    classes.add(clazz);
                    continue;
                }
                if (!new File(filePath, file).isDirectory()) continue;
                Util.recurse(classes, packageName + "." + file, a);
            }
        }
    }

    public static InputStream getResourceAsStream(String name, Class clazz) {
        ClassLoader loader;
        InputStream retval = null;
        if (clazz != null) {
            try {
                loader = clazz.getClassLoader();
                if (loader != null && (retval = loader.getResourceAsStream(name)) != null) {
                    return retval;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader != null && (retval = loader.getResourceAsStream(name)) != null) {
                return retval;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            loader = ClassLoader.getSystemClassLoader();
            if (loader != null) {
                return loader.getResourceAsStream(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retval;
    }

    public static boolean sameHost(Address one, Address two) {
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof IpAddress) || !(two instanceof IpAddress)) {
            return false;
        }
        InetAddress a = ((IpAddress)one).getIpAddress();
        InetAddress b = ((IpAddress)two).getIpAddress();
        if (a == null || b == null) {
            return false;
        }
        String host_a = a.getHostAddress();
        String host_b = b.getHostAddress();
        return host_a.equals(host_b);
    }

    public static RejectedExecutionHandler parseRejectionPolicy(String rejection_policy) {
        if (rejection_policy == null) {
            throw new IllegalArgumentException("rejection policy is null");
        }
        if (rejection_policy.equalsIgnoreCase("abort")) {
            return new ThreadPoolExecutor.AbortPolicy();
        }
        if (rejection_policy.equalsIgnoreCase("discard")) {
            return new ThreadPoolExecutor.DiscardPolicy();
        }
        if (rejection_policy.equalsIgnoreCase("discardoldest")) {
            return new ThreadPoolExecutor.DiscardOldestPolicy();
        }
        if (rejection_policy.equalsIgnoreCase("run")) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        if (rejection_policy.toLowerCase().startsWith("custom")) {
            return new CustomRejectionPolicy(rejection_policy);
        }
        if (rejection_policy.toLowerCase().startsWith("progress_check")) {
            return new ProgressCheckRejectionPolicy(rejection_policy);
        }
        throw new IllegalArgumentException("rejection policy \"" + rejection_policy + "\" not known");
    }

    public static int[] parseCommaDelimitedInts(String s) {
        ArrayList<Integer> v = new ArrayList<Integer>();
        int[] retval = null;
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            Integer l = Integer.valueOf(tok.nextToken());
            v.add(l);
        }
        if (v.isEmpty()) {
            return null;
        }
        retval = new int[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retval[i] = (Integer)v.get(i);
        }
        return retval;
    }

    public static long[] parseCommaDelimitedLongs(String s) {
        ArrayList<Long> v = new ArrayList<Long>();
        long[] retval = null;
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            Long l = Long.valueOf(tok.nextToken());
            v.add(l);
        }
        if (v.isEmpty()) {
            return null;
        }
        retval = new long[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retval[i] = (Long)v.get(i);
        }
        return retval;
    }

    public static List<String> parseCommaDelimitedStrings(String l) {
        return Util.parseStringList(l, ",");
    }

    public static List<PhysicalAddress> parseCommaDelimitedHosts(String hosts, int port_range) throws UnknownHostException {
        StringTokenizer tok = hosts != null ? new StringTokenizer(hosts, ",") : null;
        HashSet<IpAddress> retval = new HashSet<IpAddress>();
        while (tok != null && tok.hasMoreTokens()) {
            String t = tok.nextToken().trim();
            String host = t.substring(0, t.indexOf(91));
            host = host.trim();
            int port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
            InetAddress[] resolvedAddresses = InetAddress.getAllByName(host);
            for (int i = 0; i < resolvedAddresses.length; ++i) {
                for (int p = port; p <= port + port_range; ++p) {
                    IpAddress addr = new IpAddress(resolvedAddresses[i], p);
                    retval.add(addr);
                }
            }
        }
        return new LinkedList<PhysicalAddress>(retval);
    }

    public static List<InetSocketAddress> parseCommaDelimitedHosts2(String hosts, int port_range) throws UnknownHostException {
        StringTokenizer tok = new StringTokenizer(hosts, ",");
        HashSet<InetSocketAddress> retval = new HashSet<InetSocketAddress>();
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken().trim();
            String host = t.substring(0, t.indexOf(91));
            host = host.trim();
            int port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
            InetAddress[] resolvedAddresses = InetAddress.getAllByName(host);
            for (int i = 0; i < resolvedAddresses.length; ++i) {
                for (int p = port; p <= port + port_range; ++p) {
                    InetSocketAddress addr = new InetSocketAddress(resolvedAddresses[i], p);
                    retval.add(addr);
                }
            }
        }
        return new LinkedList<InetSocketAddress>(retval);
    }

    public static List<String> parseStringList(String l, String separator) {
        LinkedList<String> tmp = new LinkedList<String>();
        StringTokenizer tok = new StringTokenizer(l, separator);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            tmp.add(t.trim());
        }
        return tmp;
    }

    public static Map<String, String> parseCommaDelimitedProps(String s) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        Pattern p = Pattern.compile("\\s*([^=\\s]+)\\s*=\\s*([^=\\s,]+)\\s*,?");
        Matcher matcher = p.matcher(s);
        while (matcher.find()) {
            props.put(matcher.group(1), matcher.group(2));
        }
        return props;
    }

    public static int discardUntilNewLine(InputStream in) {
        int num = 0;
        try {
            int ch;
            while ((ch = in.read()) != -1) {
                ++num;
                if (ch != 10) continue;
            }
        }
        catch (IOException e) {}
        return num;
    }

    public static String readLine(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder(35);
        while (true) {
            int ch;
            if ((ch = in.read()) == -1) {
                return sb.toString();
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static List<NetworkInterface> parseInterfaceList(String s) throws Exception {
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>(10);
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            String interface_name = tok.nextToken();
            NetworkInterface intf = NetworkInterface.getByName(interface_name);
            if (intf == null) {
                intf = NetworkInterface.getByInetAddress(InetAddress.getByName(interface_name));
            }
            if (intf == null) {
                throw new Exception("interface " + interface_name + " not found");
            }
            if (interfaces.contains(intf)) continue;
            interfaces.add(intf);
        }
        return interfaces;
    }

    public static String print(List<NetworkInterface> interfaces) {
        return interfaces == null ? "null" : interfaces.stream().map(NetworkInterface::getName).collect(Collectors.joining(", "));
    }

    public static String shortName(String hostname) {
        if (hostname == null) {
            return null;
        }
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            return hostname.substring(0, index);
        }
        return hostname;
    }

    public static boolean startFlush(JChannel c, List<Address> flushParticipants, int numberOfAttempts, long randomSleepTimeoutFloor, long randomSleepTimeoutCeiling) {
        for (int attemptCount = 0; attemptCount < numberOfAttempts; ++attemptCount) {
            try {
                c.startFlush(flushParticipants, false);
                return true;
            }
            catch (Exception e) {
                Util.sleepRandom(randomSleepTimeoutFloor, randomSleepTimeoutCeiling);
                continue;
            }
        }
        return false;
    }

    public static boolean startFlush(JChannel c, List<Address> flushParticipants) {
        return Util.startFlush(c, flushParticipants, 4, 1000L, 5000L);
    }

    public static boolean startFlush(JChannel c, int numberOfAttempts, long randomSleepTimeoutFloor, long randomSleepTimeoutCeiling) {
        for (int attemptCount = 0; attemptCount < numberOfAttempts; ++attemptCount) {
            try {
                c.startFlush(false);
                return true;
            }
            catch (Exception e) {
                Util.sleepRandom(randomSleepTimeoutFloor, randomSleepTimeoutCeiling);
                continue;
            }
        }
        return false;
    }

    public static boolean startFlush(JChannel c) {
        return Util.startFlush(c, 4, 1000L, 5000L);
    }

    public static String shortName(InetAddress hostname) {
        if (hostname == null) {
            return null;
        }
        return hostname.getHostAddress();
    }

    public static String generateLocalName() {
        String retval = null;
        try {
            retval = Util.shortName(InetAddress.getLocalHost().getHostName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (retval == null) {
            try {
                retval = Util.shortName(InetAddress.getByName(null).getHostName());
            }
            catch (Throwable e) {
                retval = "localhost";
            }
        }
        long counter = Util.random(65534L);
        return retval + "-" + counter;
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap(int initial_capacity, float load_factor, int concurrency_level) {
        return new ConcurrentHashMap(initial_capacity, load_factor, concurrency_level);
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap(int initial_capacity) {
        return new ConcurrentHashMap(initial_capacity);
    }

    public static <K, V> ConcurrentMap<K, V> createConcurrentMap() {
        return new ConcurrentHashMap(CCHM_INITIAL_CAPACITY, CCHM_LOAD_FACTOR, CCHM_CONCURRENCY_LEVEL);
    }

    public static ServerSocket createServerSocket(SocketFactory factory, String service_name, InetAddress bind_addr, int start_port) {
        ServerSocket ret = null;
        try {
            ret = factory.createServerSocket(service_name);
            Util.bind(ret, bind_addr, start_port, start_port + 1000, 50);
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ServerSocket createServerSocket(SocketFactory factory, String service_name, InetAddress bind_addr, int start_port, int end_port) throws Exception {
        int original_start_port = start_port;
        ServerSocket srv_sock = null;
        while (true) {
            try {
                if (srv_sock != null) {
                    // empty if block
                }
                Util.close(srv_sock);
                srv_sock = factory.createServerSocket(service_name);
                InetSocketAddress sock_addr = new InetSocketAddress(bind_addr, start_port);
                srv_sock.bind(sock_addr);
                return srv_sock;
            }
            catch (SocketException bind_ex) {
                NetworkInterface nic;
                if (start_port == end_port) {
                    throw new BindException(String.format("no port available in range [%d .. %d] (bind_addr=%s)", original_start_port, end_port, bind_addr));
                }
                if (bind_addr != null && !bind_addr.isLoopbackAddress() && !bind_addr.isAnyLocalAddress() && (nic = NetworkInterface.getByInetAddress(bind_addr)) == null) {
                    throw new BindException("bind_addr " + bind_addr + " is not a valid interface: " + bind_ex);
                }
                ++start_port;
                continue;
            }
            break;
        }
    }

    public static ServerSocket createServerSocketAndBind(SocketFactory factory, String service_name, InetAddress bind_addr, int start_port, int end_port) throws Exception {
        ServerSocket ret = factory.createServerSocket(service_name);
        Util.bind(ret, bind_addr, start_port, end_port);
        return ret;
    }

    public static void bind(ServerSocket srv_sock, InetAddress bind_addr, int start_port, int end_port) throws Exception {
        Util.bind(srv_sock, bind_addr, start_port, end_port, 50);
    }

    public static void bind(ServerSocket srv_sock, InetAddress bind_addr, int start_port, int end_port, int backlog) throws Exception {
        int original_start_port = start_port;
        while (true) {
            try {
                InetSocketAddress sock_addr = new InetSocketAddress(bind_addr, start_port);
                srv_sock.bind(sock_addr, backlog);
            }
            catch (SocketException bind_ex) {
                NetworkInterface nic;
                if (start_port == end_port) {
                    throw new BindException("No available port to bind to in range [" + original_start_port + " .. " + end_port + "]");
                }
                if (bind_addr != null && !bind_addr.isLoopbackAddress() && (nic = NetworkInterface.getByInetAddress(bind_addr)) == null) {
                    throw new BindException("bind_addr " + bind_addr + " is not a valid interface: " + bind_ex);
                }
                ++start_port;
                continue;
            }
            break;
        }
    }

    public static void bind(Socket sock, InetAddress bind_addr, int start_port, int end_port) throws Exception {
        int original_start_port = start_port;
        while (true) {
            try {
                InetSocketAddress sock_addr = new InetSocketAddress(bind_addr, start_port);
                sock.bind(sock_addr);
            }
            catch (SocketException bind_ex) {
                NetworkInterface nic;
                if (start_port == end_port) {
                    throw new BindException("No available port to bind to in range [" + original_start_port + " .. " + end_port + "]");
                }
                if (bind_addr != null && !bind_addr.isLoopbackAddress() && (nic = NetworkInterface.getByInetAddress(bind_addr)) == null) {
                    throw new BindException("bind_addr " + bind_addr + " is not a valid interface: " + bind_ex);
                }
                ++start_port;
                continue;
            }
            break;
        }
    }

    public static ServerSocketChannel createServerSocketChannelAndBind(InetAddress bind_addr, int start_port, int end_port) throws Exception {
        ServerSocketChannel channel = ServerSocketChannel.open();
        Util.bind(channel, bind_addr, start_port, end_port);
        return channel;
    }

    public static ServerSocketChannel createServerSocketChannel(SocketFactory factory, String service_name, InetAddress bind_addr, int start_port, int end_port) throws Exception {
        int original_start_port = start_port;
        ServerSocketChannel ch = null;
        while (true) {
            try {
                if (ch != null) {
                    Util.close(ch);
                }
                ch = factory.createServerSocketChannel(service_name);
                ch.bind(new InetSocketAddress(bind_addr, start_port), 50);
                return ch;
            }
            catch (SocketException bind_ex) {
                NetworkInterface nic;
                if (start_port == end_port) {
                    throw new BindException("No available port to bind to in range [" + original_start_port + " .. " + end_port + "]");
                }
                if (bind_addr != null && !bind_addr.isLoopbackAddress() && (nic = NetworkInterface.getByInetAddress(bind_addr)) == null) {
                    throw new BindException("bind_addr " + bind_addr + " is not a valid interface: " + bind_ex);
                }
                ++start_port;
                continue;
            }
            break;
        }
    }

    public static void bind(ServerSocketChannel ch, InetAddress bind_addr, int start_port, int end_port) throws Exception {
        Util.bind(ch, bind_addr, start_port, end_port, 50);
    }

    public static void bind(ServerSocketChannel ch, InetAddress bind_addr, int start_port, int end_port, int backlog) throws Exception {
        int original_start_port = start_port;
        while (true) {
            try {
                ch.bind(new InetSocketAddress(bind_addr, start_port), backlog);
            }
            catch (SocketException bind_ex) {
                NetworkInterface nic;
                if (start_port == end_port) {
                    throw new BindException("No available port to bind to in range [" + original_start_port + " .. " + end_port + "]");
                }
                if (bind_addr != null && !bind_addr.isLoopbackAddress() && (nic = NetworkInterface.getByInetAddress(bind_addr)) == null) {
                    throw new BindException("bind_addr " + bind_addr + " is not a valid interface: " + bind_ex);
                }
                ++start_port;
                continue;
            }
            break;
        }
    }

    public static DatagramSocket createDatagramSocket(SocketFactory factory, String service_name, InetAddress addr, int port) throws Exception {
        DatagramSocket sock = null;
        if (addr == null) {
            if (port == 0) {
                return factory.createDatagramSocket(service_name);
            }
            while (port < 65535) {
                try {
                    return factory.createDatagramSocket(service_name, port);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
            }
        } else {
            if (port == 0) {
                port = 1024;
            }
            while (port < 65535) {
                try {
                    return factory.createDatagramSocket(service_name, port, addr);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
            }
        }
        return sock;
    }

    public static MulticastSocket createMulticastSocket(SocketFactory factory, String service_name, InetAddress mcast_addr, int port, Log log) throws IOException {
        MulticastSocket retval;
        block4: {
            if (mcast_addr != null && !mcast_addr.isMulticastAddress()) {
                throw new IllegalArgumentException("mcast_addr (" + mcast_addr + ") is not a valid multicast address");
            }
            InetSocketAddress saddr = new InetSocketAddress(mcast_addr, port);
            retval = null;
            try {
                retval = factory.createMulticastSocket(service_name, saddr);
            }
            catch (IOException ex) {
                if (log == null || !log.isWarnEnabled()) break block4;
                StringBuilder sb = new StringBuilder();
                String type = mcast_addr != null ? (mcast_addr instanceof Inet4Address ? "IPv4" : "IPv6") : "n/a";
                sb.append("could not bind to ").append(mcast_addr).append(" (").append(type).append(" address)").append("; make sure your mcast_addr is of the same type as the preferred IP stack (IPv4 or IPv6)").append(" by checking the value of the system properties java.net.preferIPv4Stack and java.net.preferIPv6Addresses.").append("\nWill ignore mcast_addr, but this may lead to cross talking (see http://www.jboss.org/community/docs/DOC-9469 for details). ").append("\nException was: ").append(ex);
                log.warn(sb.toString());
            }
        }
        if (retval == null) {
            retval = factory.createMulticastSocket(service_name, port);
        }
        return retval;
    }

    public static InetAddress validateBindAddressFromInterface(InetAddress bind_addr, String bind_interface_str, StackType ip_version) throws UnknownHostException, SocketException {
        NetworkInterface bind_intf = null;
        if (bind_addr != null && bind_addr.isLoopbackAddress()) {
            return bind_addr;
        }
        if (bind_interface_str == null || bind_interface_str.trim().isEmpty()) {
            return bind_addr;
        }
        bind_intf = Util.getByName(bind_interface_str);
        if (bind_intf != null) {
            boolean supportsVersion = Util.interfaceHasIPAddresses(bind_intf, ip_version);
            if (!supportsVersion) {
                throw new IllegalArgumentException("bind_interface " + bind_interface_str + " has incorrect IP version");
            }
        } else {
            throw new UnknownHostException("network interface " + bind_interface_str + " not found");
        }
        if (bind_addr != null) {
            boolean hasAddress = false;
            Enumeration<InetAddress> addresses = bind_intf.getInetAddresses();
            while (addresses != null && addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!bind_addr.equals(address)) continue;
                hasAddress = true;
                break;
            }
            if (!hasAddress) {
                String bind_addr_str = bind_addr.getHostAddress();
                throw new IllegalArgumentException("network interface " + bind_interface_str + " does not contain address " + bind_addr_str);
            }
        } else {
            bind_addr = Util.getAddress(bind_intf, AddressScope.NON_LOOPBACK, ip_version);
        }
        if (bind_addr != null && NetworkInterface.getByInetAddress(bind_addr) == null) {
            throw new UnknownHostException("Invalid bind address " + bind_addr);
        }
        return bind_addr;
    }

    public static boolean checkForLinux() {
        return Util.checkForPresence("os.name", "linux");
    }

    public static boolean checkForHp() {
        return Util.checkForPresence("os.name", "hp");
    }

    public static boolean checkForSolaris() {
        return Util.checkForPresence("os.name", "sun");
    }

    public static boolean checkForWindows() {
        return Util.checkForPresence("os.name", "win");
    }

    public static boolean checkForAndroid() {
        return Util.contains("java.vm.vendor", "android");
    }

    public static boolean checkForMac() {
        return Util.checkForPresence("os.name", "mac");
    }

    private static boolean checkForPresence(String key, String value) {
        try {
            String tmp = System.getProperty(key);
            return tmp != null && tmp.trim().toLowerCase().startsWith(value);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean contains(String key, String value) {
        try {
            String tmp = System.getProperty(key);
            return tmp != null && tmp.trim().toLowerCase().contains(value.trim().toLowerCase());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static InetAddress getLoopback(StackType ip_version) throws UnknownHostException {
        if (ip_version == StackType.IPv6) {
            return InetAddress.getByName("::1");
        }
        return InetAddress.getLoopbackAddress();
    }

    public static InetAddress getLoopback() throws UnknownHostException {
        return Util.getLoopback(Util.getIpStackType());
    }

    public static InetAddress getLocalMulticastAddress(StackType ip_version) throws UnknownHostException {
        if (ip_version == StackType.IPv6) {
            return InetAddress.getByName("ff0e::5:5:5");
        }
        return InetAddress.getByName("225.5.5.5");
    }

    public static InetAddress getNonLoopbackAddress() throws SocketException {
        return Util.getAddress(AddressScope.NON_LOOPBACK, Util.getIpStackType());
    }

    public static InetAddress getNonLoopbackAddress(StackType ip_version) throws SocketException {
        return Util.getAddress(AddressScope.NON_LOOPBACK, ip_version);
    }

    public static NetworkInterface getByName(String name) throws SocketException {
        if (name == null) {
            return null;
        }
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface intf = en.nextElement();
            if (intf.getName().equals(name)) {
                return intf;
            }
            Enumeration<NetworkInterface> en2 = intf.getSubInterfaces();
            while (en2.hasMoreElements()) {
                NetworkInterface intf2 = en2.nextElement();
                if (!intf2.getName().equals(name)) continue;
                return intf2;
            }
        }
        return null;
    }

    public static InetAddress getByName(String host, StackType ip_version) throws UnknownHostException {
        if (ip_version == null || ip_version == StackType.Dual) {
            return InetAddress.getByName(host);
        }
        Class clazz = ip_version == StackType.IPv6 ? Inet6Address.class : Inet4Address.class;
        InetAddress[] addrs = InetAddress.getAllByName(host);
        return Stream.of(addrs).filter(a -> a != null && a.getClass() == clazz).findFirst().orElse(null);
    }

    public static InetAddress getAddress(String value, StackType ip_version) throws Exception {
        try {
            AddressScope addr_scope = AddressScope.valueOf(value.toUpperCase());
            return Util.getAddress(addr_scope, ip_version);
        }
        catch (Throwable throwable) {
            if (value.startsWith("match")) {
                return Util.getAddressByPatternMatch(value, ip_version);
            }
            if (value.startsWith("custom:")) {
                return Util.getAddressByCustomCode(value.substring("custom:".length()));
            }
            return Util.getByName(value, ip_version);
        }
    }

    public static InetAddress getAddress(AddressScope scope, StackType ip_version) throws SocketException {
        Collection<InetAddress> all_addrs = Util.getAllAvailableAddresses(scope != null ? a -> Util.match(a, scope) : null);
        if (scope != null) {
            switch (ip_version) {
                case IPv6: {
                    return all_addrs.stream().filter(a -> a instanceof Inet6Address).findFirst().orElse(null);
                }
                case IPv4: 
                case Dual: {
                    return all_addrs.stream().filter(a -> a instanceof Inet4Address).findFirst().orElse(null);
                }
            }
        }
        return all_addrs.stream().findFirst().orElse(null);
    }

    public static InetAddress getAddress(NetworkInterface intf, AddressScope scope, StackType ip_version) {
        InetAddress first = null;
        Enumeration<InetAddress> addresses = intf.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress addr = addresses.nextElement();
            if (scope != null && !Util.match(addr, scope)) continue;
            if (addr instanceof Inet4Address && (ip_version == StackType.IPv4 || ip_version == StackType.Dual) || addr instanceof Inet6Address && ip_version == StackType.IPv6) {
                return addr;
            }
            if (first != null) continue;
            first = addr;
        }
        return ip_version == StackType.Dual ? first : null;
    }

    public static boolean match(InetAddress addr, AddressScope scope) {
        if (scope == null) {
            return true;
        }
        switch (scope) {
            case GLOBAL: {
                return !addr.isLoopbackAddress() && !addr.isLinkLocalAddress() && !addr.isSiteLocalAddress();
            }
            case SITE_LOCAL: {
                return addr.isSiteLocalAddress();
            }
            case LINK_LOCAL: {
                return addr.isLinkLocalAddress();
            }
            case LOOPBACK: {
                return addr.isLoopbackAddress();
            }
            case NON_LOOPBACK: {
                return !addr.isLoopbackAddress();
            }
        }
        throw new IllegalArgumentException("scope " + (Object)((Object)scope) + " is unknown");
    }

    public static InetAddress getAddressByPatternMatch(String pattern, StackType ip_version) throws Exception {
        if (pattern == null) {
            return null;
        }
        String real_pattern = null;
        int type = 0;
        if (pattern.startsWith("match-interface")) {
            type = 1;
            real_pattern = pattern.substring("match-interface".length() + 1);
        } else if (pattern.startsWith("match-address")) {
            type = 2;
            real_pattern = pattern.substring("match-address".length() + 1);
        } else if (pattern.startsWith("match-host")) {
            type = 3;
            real_pattern = pattern.substring("match-host".length() + 1);
        }
        if (real_pattern == null) {
            throw new IllegalArgumentException("expected match-address:<pattern>, match-host:<pattern> or match-interface:<pattern>");
        }
        Pattern pat = Pattern.compile(real_pattern);
        Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
        while (intfs.hasMoreElements()) {
            NetworkInterface intf = intfs.nextElement();
            try {
                if (!Util.isUp(intf)) continue;
                switch (type) {
                    case 1: {
                        String interface_name = intf.getName();
                        Matcher matcher = pat.matcher(interface_name);
                        if (!matcher.matches()) break;
                        return Util.getAddress(intf, null, ip_version);
                    }
                    case 2: 
                    case 3: {
                        Matcher matcher;
                        InetAddress first = null;
                        Enumeration<InetAddress> en = intf.getInetAddresses();
                        while (en.hasMoreElements()) {
                            InetAddress addr = en.nextElement();
                            String name = type == 3 ? addr.getHostName() : addr.getHostAddress();
                            matcher = pat.matcher(name);
                            if (!matcher.matches()) continue;
                            if (addr instanceof Inet4Address && (ip_version == StackType.IPv4 || ip_version == StackType.Dual) || addr instanceof Inet6Address && ip_version == StackType.IPv6) {
                                return addr;
                            }
                            if (first != null) continue;
                            first = addr;
                        }
                        if (first == null) break;
                        return first;
                    }
                }
            }
            catch (SocketException socketException) {}
        }
        return null;
    }

    public static InetAddress getAddressByCustomCode(String value) throws Exception {
        Class<?> clazz = Util.loadClass(value, (ClassLoader)null);
        Supplier supplier = (Supplier)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return (InetAddress)supplier.get();
    }

    public static boolean isUp(NetworkInterface ni) throws SocketException {
        try {
            return ni.isUp();
        }
        catch (SocketException sock_ex) {
            throw sock_ex;
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean interfaceHasIPAddresses(NetworkInterface intf, StackType ip_version) throws UnknownHostException {
        boolean supportsVersion = false;
        if (intf != null) {
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            while (addresses != null && addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if ((!(address instanceof Inet4Address) || ip_version != StackType.IPv4) && (!(address instanceof Inet6Address) || ip_version != StackType.IPv6)) continue;
                supportsVersion = true;
                break;
            }
        } else {
            throw new UnknownHostException("network interface " + intf + " not found");
        }
        return supportsVersion;
    }

    public static StackType getIpStackType() {
        return ip_stack_type;
    }

    public static boolean isIpv4StackAvailable() {
        return ipv4_stack_available;
    }

    public static boolean isIpv6StackAvailable() {
        return ipv6_stack_available;
    }

    public static boolean isIpAddressPermissible(InetAddress addr) {
        if (ipv4_stack_available && !ipv6_stack_available) {
            return !(addr instanceof Inet6Address);
        }
        return true;
    }

    public static boolean sameAddresses(InetAddress one, InetAddress two) {
        return one == null || two == null || one instanceof Inet6Address && two instanceof Inet6Address || one instanceof Inet4Address && two instanceof Inet4Address;
    }

    private static StackType _getIpStackType() {
        Collection<InetAddress> all_addresses = Util.getAllAvailableAddresses(null);
        for (InetAddress addr : all_addresses) {
            if (addr instanceof Inet4Address) {
                ipv4_stack_available = true;
            } else if (addr instanceof Inet6Address) {
                ipv6_stack_available = true;
            }
            if (!ipv4_stack_available || !ipv6_stack_available) continue;
            break;
        }
        if (ipv4_stack_available && !ipv6_stack_available) {
            return StackType.IPv4;
        }
        if (ipv6_stack_available && !ipv4_stack_available) {
            return StackType.IPv6;
        }
        return Boolean.getBoolean("java.net.preferIPv4Stack") ? StackType.IPv4 : (Boolean.getBoolean("java.net.preferIPv6Addresses") ? StackType.IPv6 : StackType.Dual);
    }

    public static boolean isStackAvailable(boolean ipv4) {
        Collection<InetAddress> all_addrs = Util.getAllAvailableAddresses(null);
        for (InetAddress addr : all_addrs) {
            if ((!ipv4 || !(addr instanceof Inet4Address)) && (ipv4 || !(addr instanceof Inet6Address))) continue;
            return true;
        }
        return false;
    }

    public static List<NetworkInterface> getAllAvailableInterfaces() throws SocketException {
        ArrayList<NetworkInterface> retval = new ArrayList<NetworkInterface>(10);
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            retval.add(en.nextElement());
        }
        return retval;
    }

    public static Collection<InetAddress> getAllAvailableAddresses(Predicate<InetAddress> filter) {
        HashSet<InetAddress> retval = new HashSet<InetAddress>();
        try {
            List<NetworkInterface> interfaces = Util.getAllAvailableInterfaces();
            for (NetworkInterface intf : interfaces) {
                if (!Util.isUp(intf)) continue;
                Enumeration<InetAddress> addrs = intf.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (filter != null && !filter.test(addr)) continue;
                    retval.add(addr);
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return retval;
    }

    public static void checkIfValidAddress(InetAddress bind_addr, String prot_name) throws Exception {
        if (bind_addr.isLoopbackAddress()) {
            return;
        }
        Collection<InetAddress> addrs = Util.getAllAvailableAddresses(null);
        for (InetAddress addr : addrs) {
            if (!addr.equals(bind_addr)) continue;
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (prot_name != null) {
            sb.append('[').append(prot_name).append("] ");
        }
        sb.append(bind_addr).append(" is not a valid address on any local network interface");
        throw new BindException(sb.toString());
    }

    public static InetAddress convertToIPv6(InetAddress ipv4_addr) throws UnknownHostException {
        if (!(ipv4_addr instanceof Inet4Address)) {
            throw new IllegalArgumentException(String.format("address %s is not an IPv4 address", ipv4_addr));
        }
        byte[] bytes = ipv4_addr.getAddress();
        byte[] ipv4asIpV6addr = new byte[16];
        ipv4asIpV6addr[10] = -1;
        ipv4asIpV6addr[11] = -1;
        ipv4asIpV6addr[12] = bytes[0];
        ipv4asIpV6addr[13] = bytes[1];
        ipv4asIpV6addr[14] = bytes[2];
        ipv4asIpV6addr[15] = bytes[3];
        return InetAddress.getByAddress(ipv4asIpV6addr);
    }

    public static String getProperty(String[] system_props, Properties props, String prop_name, String default_value) {
        String retval = null;
        if (props != null && prop_name != null) {
            retval = props.getProperty(prop_name);
            props.remove(prop_name);
        }
        if (retval == null && system_props != null) {
            for (int i = 0; i < system_props.length; ++i) {
                String prop = system_props[i];
                if (prop == null) continue;
                try {
                    String tmp = System.getProperty(prop);
                    if (tmp != null) {
                        return tmp;
                    }
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        if (retval == null) {
            return default_value;
        }
        return retval;
    }

    public static boolean isCoordinator(JChannel ch) {
        return Util.isCoordinator(ch.getView(), ch.getAddress());
    }

    public static boolean isCoordinator(View view, Address local_addr) {
        if (view == null || local_addr == null) {
            return false;
        }
        Address coord = view.getCoord();
        return local_addr.equals(coord);
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers != null && !servers.isEmpty()) {
            for (int i = 0; i < servers.size(); ++i) {
                MBeanServer srv = (MBeanServer)servers.get(i);
                if (!"jboss".equalsIgnoreCase(srv.getDefaultDomain())) continue;
                return srv;
            }
            return (MBeanServer)servers.get(0);
        }
        return MBeanServerFactory.createMBeanServer();
    }

    public static void registerChannel(JChannel channel, String name) {
        MBeanServer server = Util.getMBeanServer();
        if (server != null) {
            try {
                JmxConfigurator.registerChannel(channel, server, name != null ? name : "jgroups", channel.getClusterName(), true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String replaceProperties(String string, Properties props) {
        String FILE_SEPARATOR = File.separator;
        String PATH_SEPARATOR = File.pathSeparator;
        String FILE_SEPARATOR_ALIAS = "/";
        String PATH_SEPARATOR_ALIAS = ":";
        boolean NORMAL = false;
        boolean SEEN_DOLLAR = true;
        int IN_BRACKET = 2;
        char[] chars = string.toCharArray();
        StringBuilder buffer = new StringBuilder();
        int state = 0;
        int start = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '$' && state != 2) {
                if (i <= 0 || chars[i - 1] == '\\') continue;
                state = 1;
                continue;
            }
            if (c == '{' && state == 1) {
                Util.append(buffer, string.substring(start, i - 1));
                state = 2;
                start = i - 1;
                continue;
            }
            if (state == 1) {
                state = 0;
                continue;
            }
            if (c != '}' || state != 2) continue;
            if (start + 2 == i) {
                buffer.append("${}");
            } else {
                String value;
                String key = string.substring(start + 2, i);
                if ("/".equals(key)) {
                    value = FILE_SEPARATOR;
                } else if (":".equals(key)) {
                    value = PATH_SEPARATOR;
                } else {
                    value = props != null ? props.getProperty(key) : System.getProperty(key);
                    if (value == null) {
                        int colon = key.indexOf(58);
                        if (colon > 0) {
                            String realKey = key.substring(0, colon);
                            value = props != null ? props.getProperty(realKey) : System.getProperty(realKey);
                            if (value == null && (value = Util.resolveCompositeKey(realKey, props)) == null) {
                                value = key.substring(colon + 1);
                            }
                        } else {
                            value = Util.resolveCompositeKey(key, props);
                        }
                    }
                }
                if (value != null) {
                    buffer.append(value);
                }
            }
            start = i + 1;
            state = 0;
        }
        if (start != chars.length) {
            Util.append(buffer, string.substring(start, chars.length));
        }
        return buffer.toString();
    }

    protected static void append(StringBuilder sb, String str) {
        if (sb == null || str == null) {
            return;
        }
        sb.append(str.replace("\\${", "${"));
    }

    private static String resolveCompositeKey(String key, Properties props) {
        String value = null;
        int comma = key.indexOf(44);
        if (comma > -1) {
            if (comma > 0) {
                String key1 = key.substring(0, comma);
                value = props != null ? props.getProperty(key1) : System.getProperty(key1);
            }
            if (value == null && comma < key.length() - 1) {
                String key2 = key.substring(comma + 1);
                value = props != null ? props.getProperty(key2) : System.getProperty(key2);
            }
        }
        return value;
    }

    public static String substituteVariable(String val) {
        if (val == null) {
            return val;
        }
        String retval = val;
        while (retval.contains("${")) {
            String prev = retval;
            if (!(retval = Util._substituteVar(retval)).equals(prev)) continue;
            break;
        }
        return retval;
    }

    private static String _substituteVar(String val) {
        int start_index = val.indexOf("${");
        if (start_index == -1) {
            return val;
        }
        int end_index = val.indexOf("}", start_index + 2);
        if (end_index == -1) {
            throw new IllegalArgumentException("missing \"}\" in " + val);
        }
        String tmp = Util.getProperty(val.substring(start_index + 2, end_index));
        if (tmp == null) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(val, 0, start_index).append(tmp).append(val.substring(end_index + 1));
        return sb.toString();
    }

    public static String getProperty(String s) {
        String retval = null;
        int index = s.indexOf(58);
        if (index >= 0) {
            String var = s.substring(0, index);
            String default_val = s.substring(index + 1);
            if (default_val != null && !default_val.isEmpty()) {
                default_val = default_val.trim();
            }
            retval = Util._getProperty(var, default_val);
        } else {
            String var = s;
            retval = Util._getProperty(var, null);
        }
        return retval;
    }

    private static String _getProperty(String var, String default_value) {
        if (var == null) {
            return null;
        }
        List<String> list = Util.parseCommaDelimitedStrings(var);
        if (list == null || list.isEmpty()) {
            list = new ArrayList<String>(1);
            list.add(var);
        }
        String retval = null;
        for (String prop : list) {
            try {
                retval = System.getProperty(prop);
                if (retval != null) {
                    return retval;
                }
                retval = System.getenv(prop);
                if (retval == null) continue;
                return retval;
            }
            catch (Throwable throwable) {
            }
        }
        return default_value;
    }

    private static String getString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public static String md5(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(source.getBytes());
            return Util.getString(bytes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String sha(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] bytes = md.digest(source.getBytes());
            return Util.getString(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String methodNameToAttributeName(String methodName) {
        String name = methodName;
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && methodName.length() > 3) {
            name = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2) {
            name = methodName.substring(2);
        }
        Matcher m = METHOD_NAME_TO_ATTR_NAME_PATTERN.matcher(name);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            int end;
            int start = m.start();
            String str = name.substring(start, end = m.end()).toLowerCase();
            if (str.length() > 1) {
                String tmp1 = str.substring(0, str.length() - 1);
                String tmp2 = str.substring(str.length() - 1);
                str = tmp1 + "_" + tmp2;
            }
            if (start == 0) {
                m.appendReplacement(sb, str);
                continue;
            }
            m.appendReplacement(sb, "_" + str);
        }
        m.appendTail(sb);
        return sb.length() > 0 ? sb.toString() : methodName;
    }

    public static String methodNameToJavaAttributeName(String methodName) {
        String name = methodName;
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && methodName.length() > 3) {
            name = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2) {
            name = methodName.substring(2);
        }
        if (Character.isUpperCase(name.charAt(0))) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static String attributeNameToMethodName(String attr_name) {
        if (attr_name.contains("_")) {
            Matcher m = ATTR_NAME_TO_METHOD_NAME_PATTERN.matcher(attr_name);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, attr_name.substring(m.end() - 1, m.end()).toUpperCase());
            }
            m.appendTail(sb);
            char first = sb.charAt(0);
            if (Character.isLowerCase(first)) {
                sb.setCharAt(0, Character.toUpperCase(first));
            }
            return sb.toString();
        }
        if (Character.isLowerCase(attr_name.charAt(0))) {
            return attr_name.substring(0, 1).toUpperCase() + attr_name.substring(1);
        }
        return attr_name;
    }

    static {
        String tmp;
        PRIMITIVE_TYPES = new HashMap<Class<? extends Object>, Byte>(15);
        METHOD_NAME_TO_ATTR_NAME_PATTERN = Pattern.compile("[A-Z]+");
        ATTR_NAME_TO_METHOD_NAME_PATTERN = Pattern.compile("_.");
        CCHM_INITIAL_CAPACITY = 16;
        CCHM_LOAD_FACTOR = 0.75f;
        CCHM_CONCURRENCY_LEVEL = 16;
        MAX_LIST_PRINT_SIZE = 20;
        TYPE_NULL_ARRAY = new byte[]{0};
        TYPE_BOOLEAN_TRUE = new byte[]{10, 1};
        TYPE_BOOLEAN_FALSE = new byte[]{10, 0};
        ipv4_stack_available = false;
        ipv6_stack_available = false;
        ip_stack_type = Util._getIpStackType();
        resource_bundle = ResourceBundle.getBundle("jg-messages", Locale.getDefault(), Util.class.getClassLoader());
        PRIMITIVE_TYPES.put(Boolean.class, (byte)10);
        PRIMITIVE_TYPES.put(Byte.class, (byte)11);
        PRIMITIVE_TYPES.put(Character.class, (byte)12);
        PRIMITIVE_TYPES.put(Double.class, (byte)13);
        PRIMITIVE_TYPES.put(Float.class, (byte)14);
        PRIMITIVE_TYPES.put(Integer.class, (byte)15);
        PRIMITIVE_TYPES.put(Long.class, (byte)16);
        PRIMITIVE_TYPES.put(Short.class, (byte)17);
        PRIMITIVE_TYPES.put(String.class, (byte)18);
        PRIMITIVE_TYPES.put(byte[].class, (byte)19);
        try {
            String cchm_initial_capacity = System.getProperty("cchm.initial_capacity");
            if (cchm_initial_capacity != null) {
                CCHM_INITIAL_CAPACITY = Integer.valueOf(cchm_initial_capacity);
            }
        }
        catch (SecurityException cchm_initial_capacity) {
            // empty catch block
        }
        try {
            String cchm_load_factor = System.getProperty("cchm.load_factor");
            if (cchm_load_factor != null) {
                CCHM_LOAD_FACTOR = Float.valueOf(cchm_load_factor).floatValue();
            }
        }
        catch (SecurityException cchm_load_factor) {
            // empty catch block
        }
        try {
            String cchm_concurrency_level = System.getProperty("cchm.concurrency_level");
            if (cchm_concurrency_level != null) {
                CCHM_CONCURRENCY_LEVEL = Integer.valueOf(cchm_concurrency_level);
            }
        }
        catch (SecurityException cchm_concurrency_level) {
            // empty catch block
        }
        try {
            tmp = System.getProperty("max.list.print_size");
            if (tmp != null) {
                MAX_LIST_PRINT_SIZE = Integer.valueOf(tmp);
            }
        }
        catch (SecurityException cchm_concurrency_level) {
            // empty catch block
        }
        try {
            tmp = System.getProperty("jgroups.msg.default_headers");
            DEFAULT_HEADERS = tmp != null ? Integer.valueOf(tmp) : 4;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(String.format("property %s has an incorrect value", "jgroups.msg.default_headers"), t);
        }
    }

    public static enum AddressScope {
        GLOBAL,
        SITE_LOCAL,
        LINK_LOCAL,
        LOOPBACK,
        NON_LOOPBACK;

    }
}

