#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wai-extra
version:              3.1.5
visibility:           public
id:                   wai-extra-3.1.5-8ah7ZiDfzSNDuE2iXhkFhW
key:                  wai-extra-3.1.5-8ah7ZiDfzSNDuE2iXhkFhW
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  c095a8cc5e8fc5678d33cdef9ead30cf
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip Network.Wai.Middleware.HttpAuth
    Network.Wai.Middleware.Jsonp Network.Wai.Middleware.Local
    Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.Vhost Network.Wai.Parse Network.Wai.Request
    Network.Wai.Test Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:       Network.Wai.Middleware.RequestLogger.Internal
import-dirs:          /usr/lib/ghc-8.10.2/site-local/wai-extra-3.1.5
library-dirs:         /usr/lib/ghc-8.10.2/site-local/wai-extra-3.1.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/wai-extra-3.1.5
hs-libraries:         HSwai-extra-3.1.5-8ah7ZiDfzSNDuE2iXhkFhW
depends:
    HUnit-1.6.1.0-AhWJ4ItV2KqIExS8jxtlOJ
    aeson-1.5.5.1-7ZKmq9KLIncxnBfAj9HU2
    ansi-terminal-0.11-2SXi8ZhU18i2uWLidRUotS base-4.14.1.0
    base64-bytestring-1.2.0.1-Fdadxgck2fY14EcGX9uAqX
    bytestring-0.10.10.0 call-stack-0.2.0-1Bicsj1gQrKCmn9kZBvIe8
    case-insensitive-1.2.1.0-6j421Scg55hFNBQMOoQNh8 containers-0.6.2.1
    cookie-0.4.5-9B2dS5wCPmq3hZq3aUzZ9g
    data-default-class-0.1.2.0-56BXPST0gStFZdhRwxhsn8 deepseq-1.4.4.0
    directory-1.3.6.0 fast-logger-3.0.2-4brp8rjZ8ZTJd0WKKbI6MC
    http-types-0.12.3-BjgB5kCegWL53v8V6hA7Kx
    http2-2.0.5-5g3hkqdfuyj97fVFyFNkvd
    iproute-1.7.10-1fUqgrKQWSO3V9zpOASNiA
    network-3.1.2.1-Gpsuc7SHQHF6OBh84JF5QV
    old-locale-1.0.0.7-LpTuchyagHAP7STZdm71P
    resourcet-1.2.4.2-E1PquPTZKgvLbHxPSs1hvZ
    streaming-commons-0.2.2.1-As0i3gD22xP4TiGwiD93Fh text-1.2.3.2
    time-1.9.3 transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.5.2-7IcOHcLTxJI58jp45CNrGP
    vault-0.3.1.4-BImjTYzn71yHBJpDx1XCE2
    void-0.7.3-FJLCa6y31Qt20kSi8TCcBC
    wai-3.2.2.1-BYB2v4x1FyK8eqy5kz3dj4
    wai-logger-2.3.6-6SHz7pFnU3l1gZ4D0sNnLi
    word8-0.1.3-724fxDOkAtI9odHi3S4RPp
    zlib-0.6.2.2-85jZF5E8OnCKweDgfCRJUx

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

