#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 test-framework
version:              0.8.2.0
visibility:           public
id:                   test-framework-0.8.2.0-5eYG3NRKVE7L7pW0FKysaQ
key:                  test-framework-0.8.2.0-5eYG3NRKVE7L7pW0FKysaQ
license:              BSD-3-Clause
maintainer:           Libraries List <libraries@haskell.org>
author:               Max Bolingbroke <batterseapower@hotmail.com>
homepage:             http://haskell.github.io/test-framework/
synopsis:
    Framework for running and organising tests, with HUnit and QuickCheck support

description:
    Allows tests such as QuickCheck properties and HUnit test cases to be assembled into test groups, run in
    parallel (but reported in deterministic order, to aid diff interpretation) and filtered and controlled by
    command line options. All of this comes with colored test output, progress reporting and test statistics output.

category:             Testing
abi:                  6cd6216c31ed2997ac46e9d2981252fd
exposed:              True
exposed-modules:
    Test.Framework Test.Framework.Options Test.Framework.Providers.API
    Test.Framework.Runners.API Test.Framework.Runners.Console
    Test.Framework.Runners.Options Test.Framework.Runners.TestPattern
    Test.Framework.Seed

hidden-modules:
    Test.Framework.Core Test.Framework.Improving
    Test.Framework.Runners.Console.Colors
    Test.Framework.Runners.Console.ProgressBar
    Test.Framework.Runners.Console.Run
    Test.Framework.Runners.Console.Statistics
    Test.Framework.Runners.Console.Table
    Test.Framework.Runners.Console.Utilities
    Test.Framework.Runners.Core Test.Framework.Runners.Processors
    Test.Framework.Runners.Statistics Test.Framework.Runners.ThreadPool
    Test.Framework.Runners.TimedConsumption
    Test.Framework.Runners.XML.JUnitWriter Test.Framework.Runners.XML
    Test.Framework.Utilities

import-dirs:          /usr/lib/ghc-8.10.5/site-local/test-framework-0.8.2.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/test-framework-0.8.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/test-framework-0.8.2.0
hs-libraries:         HStest-framework-0.8.2.0-5eYG3NRKVE7L7pW0FKysaQ
depends:
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i
    ansi-wl-pprint-0.6.9-18xfpSFHwXcSLsLHaSUhO base-4.14.2.0
    containers-0.6.4.1 hostname-1.0-B6rimLIP2kIHedZYMVt5f8
    old-locale-1.0.0.7-L6Wsx5CTYHFJNpULKIS1yv
    random-1.2.0-BSVdQCE475yEKcUUPfL4ub
    regex-posix-0.96.0.0-7OJz5NVRWC8Iss6JoaXwme time-1.9.3
    xml-1.3.14-9Z9ZesgMbrVGnsSsWvOX4O

haddock-interfaces:
    /usr/share/doc/haskell-test-framework/html/test-framework.haddock

haddock-html:         /usr/share/doc/haskell-test-framework/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

