#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 shake
version:              0.19.4
visibility:           public
id:                   shake-0.19.4-DOj6qxAjAzEmSCf3BPNVh
key:                  shake-0.19.4-DOj6qxAjAzEmSCf3BPNVh
license:              BSD-3-Clause
copyright:            Neil Mitchell 2011-2021
maintainer:           Neil Mitchell <ndmitchell@gmail.com>
author:               Neil Mitchell <ndmitchell@gmail.com>
homepage:             https://shakebuild.com
synopsis:
    Build system library, like Make, but more accurate dependencies.

description:
    Shake is a Haskell library for writing build systems - designed as a
    replacement for @make@. See "Development.Shake" for an introduction,
    including an example. The homepage contains links to a user
    manual, an academic paper and further information:
    <https://shakebuild.com>

    To use Shake the user writes a Haskell program
    that imports "Development.Shake", defines some build rules, and calls
    the '\''Development.Shake.shakeArgs'\'' function. Thanks to do notation and infix
    operators, a simple Shake build system
    is not too dissimilar from a simple Makefile. However, as build systems
    get more complex, Shake is able to take advantage of the excellent
    abstraction facilities offered by Haskell and easily support much larger
    projects. The Shake library provides all the standard features available in other
    build systems, including automatic parallelism and minimal rebuilds.
    Shake also provides more accurate dependency tracking, including seamless
    support for generated files, and dependencies on system information
    (e.g. compiler version).

category:             Development, Shake
abi:                  c160252f57bcc07cd885d5ccf37903eb
exposed:              True
exposed-modules:
    Development.Shake Development.Shake.Classes
    Development.Shake.Command Development.Shake.Config
    Development.Shake.Database Development.Shake.FilePath
    Development.Shake.Forward Development.Shake.Rule
    Development.Shake.Util

hidden-modules:
    Development.Ninja.Env Development.Ninja.Lexer
    Development.Ninja.Parse Development.Ninja.Type
    Development.Shake.Internal.Args
    Development.Shake.Internal.CmdOption
    Development.Shake.Internal.CompactUI
    Development.Shake.Internal.Core.Action
    Development.Shake.Internal.Core.Build
    Development.Shake.Internal.Core.Database
    Development.Shake.Internal.History.Shared
    Development.Shake.Internal.History.Symlink
    Development.Shake.Internal.History.Bloom
    Development.Shake.Internal.History.Cloud
    Development.Shake.Internal.History.Network
    Development.Shake.Internal.History.Server
    Development.Shake.Internal.History.Serialise
    Development.Shake.Internal.History.Types
    Development.Shake.Internal.Core.Monad
    Development.Shake.Internal.Core.Pool
    Development.Shake.Internal.Core.Rules
    Development.Shake.Internal.Core.Run
    Development.Shake.Internal.Core.Storage
    Development.Shake.Internal.Core.Types
    Development.Shake.Internal.Demo Development.Shake.Internal.Derived
    Development.Shake.Internal.Errors
    Development.Shake.Internal.FileInfo
    Development.Shake.Internal.FileName
    Development.Shake.Internal.FilePattern
    Development.Shake.Internal.Options Development.Shake.Internal.Paths
    Development.Shake.Internal.Profile
    Development.Shake.Internal.Progress
    Development.Shake.Internal.Resource
    Development.Shake.Internal.Rules.Default
    Development.Shake.Internal.Rules.Directory
    Development.Shake.Internal.Rules.File
    Development.Shake.Internal.Rules.Files
    Development.Shake.Internal.Rules.Oracle
    Development.Shake.Internal.Rules.OrderOnly
    Development.Shake.Internal.Rules.Rerun
    Development.Shake.Internal.Value General.Bilist General.Binary
    General.Chunks General.Cleanup General.Fence General.EscCodes
    General.Extra General.FileLock General.GetOpt General.Ids
    General.Intern General.ListBuilder General.Makefile General.Pool
    General.Process General.Template General.Thread General.Timing
    General.TypeMap General.Wait Paths_shake

import-dirs:          /usr/lib/ghc-8.10.5/site-local/shake-0.19.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/shake-0.19.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-shake
hs-libraries:         HSshake-0.19.4-DOj6qxAjAzEmSCf3BPNVh
depends:
    base-4.14.2.0 binary-0.8.8.0 bytestring-0.10.12.0 deepseq-1.4.4.0
    directory-1.3.6.0 extra-1.7.9-HHsi7iW1l3L1a3O3w2D3UA
    filepath-1.4.2.1 filepattern-0.1.2-DSg3wkERMhNJ2fV3brX1w7
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    heaps-0.4-8O0EXzXBd0u214X4NFU9VO
    js-dgtable-0.5.2-6yRnbuOP2KwLadSWqNIIzH
    js-flot-0.8.3-CYgrOfniO205HuZbh7zy8E
    js-jquery-3.3.1-LXAnt9TjlEYAha3fWRFrS
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh process-1.6.9.0
    random-1.2.0-BSVdQCE475yEKcUUPfL4ub time-1.9.3 transformers-0.5.6.2
    unix-2.7.2.2 unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du

haddock-interfaces:   /usr/share/doc/haskell-shake/html/shake.haddock
haddock-html:         /usr/share/doc/haskell-shake/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

