/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ingest.SimulateProcessorResult;
import org.elasticsearch.ingest.CompoundProcessor;
import org.elasticsearch.ingest.ConditionalProcessor;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;

public final class TrackingResultProcessor
implements Processor {
    private final Processor actualProcessor;
    private final List<SimulateProcessorResult> processorResultList;
    private final boolean ignoreFailure;

    TrackingResultProcessor(boolean ignoreFailure, Processor actualProcessor, List<SimulateProcessorResult> processorResultList) {
        this.ignoreFailure = ignoreFailure;
        this.processorResultList = processorResultList;
        this.actualProcessor = actualProcessor;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        Processor processor;
        if (this.actualProcessor instanceof PipelineProcessor) {
            PipelineProcessor pipelineProcessor = (PipelineProcessor)this.actualProcessor;
            Pipeline pipeline = pipelineProcessor.getPipeline(ingestDocument);
            IngestDocument ingestDocumentCopy = new IngestDocument(ingestDocument);
            ingestDocumentCopy.executePipeline(pipelineProcessor.getPipeline(ingestDocument), (result, e) -> {
                if (e instanceof ElasticsearchException) {
                    ElasticsearchException elasticsearchException = (ElasticsearchException)e;
                    if (elasticsearchException.getCause() instanceof IllegalStateException) {
                        if (this.ignoreFailure) {
                            this.processorResultList.add(new SimulateProcessorResult(pipelineProcessor.getTag(), new IngestDocument(ingestDocument), (Exception)e));
                        } else {
                            this.processorResultList.add(new SimulateProcessorResult(pipelineProcessor.getTag(), (Exception)e));
                        }
                        handler.accept(null, elasticsearchException);
                    }
                } else {
                    CompoundProcessor verbosePipelineProcessor = TrackingResultProcessor.decorate(pipeline.getCompoundProcessor(), this.processorResultList);
                    Pipeline verbosePipeline = new Pipeline(pipeline.getId(), pipeline.getDescription(), pipeline.getVersion(), verbosePipelineProcessor);
                    ingestDocument.executePipeline(verbosePipeline, handler);
                }
            });
            return;
        }
        if (this.actualProcessor instanceof ConditionalProcessor) {
            ConditionalProcessor conditionalProcessor = (ConditionalProcessor)this.actualProcessor;
            if (!conditionalProcessor.evaluate(ingestDocument)) {
                handler.accept(ingestDocument, null);
                return;
            }
            processor = conditionalProcessor.getInnerProcessor() instanceof PipelineProcessor ? conditionalProcessor.getInnerProcessor() : this.actualProcessor;
        } else {
            processor = this.actualProcessor;
        }
        processor.execute(ingestDocument, (result, e) -> {
            if (e != null) {
                if (this.ignoreFailure) {
                    this.processorResultList.add(new SimulateProcessorResult(processor.getTag(), new IngestDocument(ingestDocument), (Exception)e));
                } else {
                    this.processorResultList.add(new SimulateProcessorResult(processor.getTag(), (Exception)e));
                }
                handler.accept((IngestDocument)null, (Exception)e);
            } else if (result != null) {
                this.processorResultList.add(new SimulateProcessorResult(processor.getTag(), new IngestDocument(ingestDocument)));
                handler.accept((IngestDocument)result, (Exception)null);
            } else {
                this.processorResultList.add(new SimulateProcessorResult(processor.getTag()));
                handler.accept(null, null);
            }
        });
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return this.actualProcessor.getType();
    }

    @Override
    public String getTag() {
        return this.actualProcessor.getTag();
    }

    public static CompoundProcessor decorate(CompoundProcessor compoundProcessor, List<SimulateProcessorResult> processorResultList) {
        ArrayList<Processor> processors = new ArrayList<Processor>(compoundProcessor.getProcessors().size());
        for (Processor processor : compoundProcessor.getProcessors()) {
            if (processor instanceof CompoundProcessor) {
                processors.add(TrackingResultProcessor.decorate((CompoundProcessor)processor, processorResultList));
                continue;
            }
            processors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, processorResultList));
        }
        ArrayList<Processor> onFailureProcessors = new ArrayList<Processor>(compoundProcessor.getProcessors().size());
        for (Processor processor : compoundProcessor.getOnFailureProcessors()) {
            if (processor instanceof CompoundProcessor) {
                onFailureProcessors.add(TrackingResultProcessor.decorate((CompoundProcessor)processor, processorResultList));
                continue;
            }
            onFailureProcessors.add(new TrackingResultProcessor(compoundProcessor.isIgnoreFailure(), processor, processorResultList));
        }
        return new CompoundProcessor(compoundProcessor.isIgnoreFailure(), processors, onFailureProcessors);
    }
}

