/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.plain.AbstractLeafGeoPointFieldData;

final class LatLonPointDVLeafFieldData
extends AbstractLeafGeoPointFieldData {
    private final LeafReader reader;
    private final String fieldName;

    LatLonPointDVLeafFieldData(LeafReader reader, String fieldName) {
        this.reader = reader;
        this.fieldName = fieldName;
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public void close() {
    }

    @Override
    public MultiGeoPointValues getGeoPointValues() {
        try {
            final SortedNumericDocValues numericValues = DocValues.getSortedNumeric((LeafReader)this.reader, (String)this.fieldName);
            return new MultiGeoPointValues(){
                final GeoPoint point = new GeoPoint();

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return numericValues.advanceExact(doc);
                }

                @Override
                public int docValueCount() {
                    return numericValues.docValueCount();
                }

                @Override
                public GeoPoint nextValue() throws IOException {
                    long encoded = numericValues.nextValue();
                    this.point.reset(GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32))), GeoEncodingUtils.decodeLongitude((int)((int)encoded)));
                    return this.point;
                }
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }
}

