/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.Tessellator;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.util.NumericUtils;

final class LatLonShapeBoundingBoxQuery
extends ShapeQuery {
    private final Rectangle rectangle;
    private final EncodedRectangle encodedRectangle;

    LatLonShapeBoundingBoxQuery(String field, ShapeField.QueryRelation queryRelation, Rectangle rectangle) {
        super(field, queryRelation);
        this.rectangle = rectangle;
        this.encodedRectangle = new EncodedRectangle(rectangle.minLat, rectangle.maxLat, rectangle.minLon, rectangle.maxLon);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        if (this.queryRelation == ShapeField.QueryRelation.INTERSECTS || this.queryRelation == ShapeField.QueryRelation.DISJOINT) {
            return this.encodedRectangle.intersectRangeBBox(minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        }
        return this.encodedRectangle.relateRangeBBox(minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
    }

    @Override
    protected boolean queryMatches(byte[] t, ShapeField.DecodedTriangle scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        int aY = scratchTriangle.aY;
        int aX = scratchTriangle.aX;
        int bY = scratchTriangle.bY;
        int bX = scratchTriangle.bX;
        int cY = scratchTriangle.cY;
        int cX = scratchTriangle.cX;
        switch (queryRelation) {
            case INTERSECTS: {
                return this.encodedRectangle.intersectsTriangle(aX, aY, bX, bY, cX, cY);
            }
            case WITHIN: {
                return this.encodedRectangle.containsTriangle(aX, aY, bX, bY, cX, cY);
            }
            case DISJOINT: {
                return !this.encodedRectangle.intersectsTriangle(aX, aY, bX, bY, cX, cY);
            }
        }
        throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)queryRelation) + "]");
    }

    @Override
    protected Component2D.WithinRelation queryWithin(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        return this.encodedRectangle.withinTriangle(scratchTriangle.aX, scratchTriangle.aY, scratchTriangle.ab, scratchTriangle.bX, scratchTriangle.bY, scratchTriangle.bc, scratchTriangle.cX, scratchTriangle.cY, scratchTriangle.ca);
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && this.rectangle.equals(((LatLonShapeBoundingBoxQuery)o).rectangle);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.rectangle.hashCode();
        return hash;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.rectangle.toString());
        return sb.toString();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class EncodedRectangle {
        protected final byte[] bbox = new byte[16];
        private final byte[] west;
        protected final int minX;
        protected final int maxX;
        protected final int minY;
        protected final int maxY;

        EncodedRectangle(double minLat, double maxLat, double minLon, double maxLon) {
            int minXenc = GeoEncodingUtils.encodeLongitudeCeil(minLon);
            int maxXenc = GeoEncodingUtils.encodeLongitude(maxLon);
            int minYenc = GeoEncodingUtils.encodeLatitudeCeil(minLat);
            int maxYenc = GeoEncodingUtils.encodeLatitude(maxLat);
            if (minYenc > maxYenc) {
                minYenc = maxYenc;
            }
            this.minY = minYenc;
            this.maxY = maxYenc;
            if (minLon > maxLon) {
                this.west = new byte[16];
                this.minX = minXenc;
                this.maxX = maxXenc;
                EncodedRectangle.encode(GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY, this.west);
                EncodedRectangle.encode(this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY, this.bbox);
            } else {
                if (minXenc > maxXenc) {
                    minXenc = maxXenc;
                }
                this.west = null;
                this.minX = minXenc;
                this.maxX = maxXenc;
                EncodedRectangle.encode(this.minX, this.maxX, this.minY, this.maxY, this.bbox);
            }
        }

        private boolean crossesDateline() {
            return this.minX > this.maxX;
        }

        boolean queryContainsPoint(int x, int y) {
            if (this.crossesDateline()) {
                return EncodedRectangle.bboxContainsPoint(x, y, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || EncodedRectangle.bboxContainsPoint(x, y, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
            }
            return EncodedRectangle.bboxContainsPoint(x, y, this.minX, this.maxX, this.minY, this.maxY);
        }

        PointValues.Relation relateRangeBBox(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            PointValues.Relation eastRelation = EncodedRectangle.compareBBoxToRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return EncodedRectangle.compareBBoxToRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            }
            return eastRelation;
        }

        PointValues.Relation intersectRangeBBox(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            PointValues.Relation eastRelation = EncodedRectangle.intersectBBoxWithRangeBBox(this.bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            if (this.crossesDateline() && eastRelation == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return EncodedRectangle.intersectBBoxWithRangeBBox(this.west, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
            }
            return eastRelation;
        }

        boolean intersectsTriangle(int aX, int aY, int bX, int bY, int cX, int cY) {
            if (this.queryContainsPoint(aX, aY) || this.queryContainsPoint(bX, bY) || this.queryContainsPoint(cX, cY)) {
                return true;
            }
            int tMinX = StrictMath.min(StrictMath.min(aX, bX), cX);
            int tMaxX = StrictMath.max(StrictMath.max(aX, bX), cX);
            int tMinY = StrictMath.min(StrictMath.min(aY, bY), cY);
            int tMaxY = StrictMath.max(StrictMath.max(aY, bY), cY);
            if (this.crossesDateline() ? EncodedRectangle.boxesAreDisjoint(tMinX, tMaxX, tMinY, tMaxY, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) && EncodedRectangle.boxesAreDisjoint(tMinX, tMaxX, tMinY, tMaxY, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY) : tMaxX < this.minX || tMinX > this.maxX || tMinY > this.maxY || tMaxY < this.minY) {
                return false;
            }
            if (Tessellator.pointInTriangle(this.minX, this.minY, aX, aY, bX, bY, cX, cY)) {
                return true;
            }
            if (Tessellator.pointInTriangle(this.maxX, this.minY, aX, aY, bX, bY, cX, cY)) {
                return true;
            }
            if (Tessellator.pointInTriangle(this.maxX, this.maxY, aX, aY, bX, bY, cX, cY)) {
                return true;
            }
            if (Tessellator.pointInTriangle(this.minX, this.maxY, aX, aY, bX, bY, cX, cY)) {
                return true;
            }
            return this.queryIntersects(aX, aY, bX, bY, cX, cY);
        }

        Component2D.WithinRelation withinTriangle(int ax, int ay, boolean ab, int bx, int by, boolean bc, int cx, int cy, boolean ca) {
            int tMaxY;
            int tMinY;
            int tMaxX;
            if (this.crossesDateline()) {
                throw new IllegalArgumentException("withinTriangle is not supported for rectangles crossing the date line");
            }
            if (ax == bx && ay == by || ax == cx && ay == cy || bx == cx && by == cy) {
                return Component2D.WithinRelation.DISJOINT;
            }
            int tMinX = StrictMath.min(StrictMath.min(ax, bx), cx);
            if (EncodedRectangle.boxesAreDisjoint(tMinX, tMaxX = StrictMath.max(StrictMath.max(ax, bx), cx), tMinY = StrictMath.min(StrictMath.min(ay, by), cy), tMaxY = StrictMath.max(StrictMath.max(ay, by), cy), this.minX, this.maxX, this.minY, this.maxY)) {
                return Component2D.WithinRelation.DISJOINT;
            }
            if (EncodedRectangle.bboxContainsPoint(ax, ay, this.minX, this.maxX, this.minY, this.maxY) || EncodedRectangle.bboxContainsPoint(bx, by, this.minX, this.maxX, this.minY, this.maxY) || EncodedRectangle.bboxContainsPoint(cx, cy, this.minX, this.maxX, this.minY, this.maxY)) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
            if (EncodedRectangle.edgeIntersectsBox(ax, ay, bx, by, this.minX, this.maxX, this.minY, this.maxY)) {
                if (ab) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (EncodedRectangle.edgeIntersectsBox(bx, by, cx, cy, this.minX, this.maxX, this.minY, this.maxY)) {
                if (bc) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (EncodedRectangle.edgeIntersectsBox(cx, cy, ax, ay, this.minX, this.maxX, this.minY, this.maxY)) {
                if (ca) {
                    return Component2D.WithinRelation.NOTWITHIN;
                }
                relation = Component2D.WithinRelation.CANDIDATE;
            }
            if (relation == Component2D.WithinRelation.CANDIDATE) {
                return Component2D.WithinRelation.CANDIDATE;
            }
            if (Tessellator.pointInTriangle(this.minX, this.minY, ax, ay, bx, by, cx, cy)) {
                return Component2D.WithinRelation.CANDIDATE;
            }
            return relation;
        }

        boolean containsTriangle(int ax, int ay, int bx, int by, int cx, int cy) {
            if (this.crossesDateline()) {
                return EncodedRectangle.bboxContainsTriangle(ax, ay, bx, by, cx, cy, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || EncodedRectangle.bboxContainsTriangle(ax, ay, bx, by, cx, cy, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
            }
            return EncodedRectangle.bboxContainsTriangle(ax, ay, bx, by, cx, cy, this.minX, this.maxX, this.minY, this.maxY);
        }

        private static PointValues.Relation compareBBoxToRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            if (EncodedRectangle.disjoint(bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle)) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (Arrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 4, 8) >= 0 && Arrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 12, 16) <= 0 && Arrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 0, 4) >= 0 && Arrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 8, 12) <= 0) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        private static PointValues.Relation intersectBBoxWithRangeBBox(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            if (EncodedRectangle.disjoint(bbox, minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle)) {
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (Arrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 4, 8) >= 0 && Arrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 0, 4) >= 0) {
                if (Arrays.compareUnsigned(maxTriangle, minXOffset, minXOffset + 4, bbox, 12, 16) <= 0 && Arrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 8, 12) <= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                if (Arrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 12, 16) <= 0 && Arrays.compareUnsigned(maxTriangle, minYOffset, minYOffset + 4, bbox, 8, 12) <= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            }
            if (Arrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 12, 16) <= 0 && Arrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 8, 12) <= 0) {
                if (Arrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 4, 8) >= 0 && Arrays.compareUnsigned(minTriangle, maxYOffset, maxYOffset + 4, bbox, 0, 4) >= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
                if (Arrays.compareUnsigned(minTriangle, maxXOffset, maxXOffset + 4, bbox, 4, 8) >= 0 && Arrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 0, 4) >= 0) {
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        private static boolean disjoint(byte[] bbox, int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
            return Arrays.compareUnsigned(minTriangle, minXOffset, minXOffset + 4, bbox, 12, 16) > 0 || Arrays.compareUnsigned(maxTriangle, maxXOffset, maxXOffset + 4, bbox, 4, 8) < 0 || Arrays.compareUnsigned(minTriangle, minYOffset, minYOffset + 4, bbox, 8, 12) > 0 || Arrays.compareUnsigned(maxTriangle, maxYOffset, maxYOffset + 4, bbox, 0, 4) < 0;
        }

        private static void encode(int minX, int maxX, int minY, int maxY, byte[] b) {
            if (b == null) {
                b = new byte[16];
            }
            NumericUtils.intToSortableBytes(minY, b, 0);
            NumericUtils.intToSortableBytes(minX, b, 4);
            NumericUtils.intToSortableBytes(maxY, b, 8);
            NumericUtils.intToSortableBytes(maxX, b, 12);
        }

        private boolean queryIntersects(int ax, int ay, int bx, int by, int cx, int cy) {
            return this.edgeIntersectsQuery(ax, ay, bx, by) || this.edgeIntersectsQuery(bx, by, cx, cy) || this.edgeIntersectsQuery(cx, cy, ax, ay);
        }

        private boolean edgeIntersectsQuery(int ax, int ay, int bx, int by) {
            if (this.crossesDateline()) {
                return EncodedRectangle.edgeIntersectsBox(ax, ay, bx, by, GeoEncodingUtils.MIN_LON_ENCODED, this.maxX, this.minY, this.maxY) || EncodedRectangle.edgeIntersectsBox(ax, ay, bx, by, this.minX, GeoEncodingUtils.MAX_LON_ENCODED, this.minY, this.maxY);
            }
            return EncodedRectangle.edgeIntersectsBox(ax, ay, bx, by, this.minX, this.maxX, this.minY, this.maxY);
        }

        private static boolean bboxContainsPoint(int x, int y, int minX, int maxX, int minY, int maxY) {
            return !(x < minX || x > maxX || y < minY || y > maxY);
        }

        private static boolean bboxContainsTriangle(int ax, int ay, int bx, int by, int cx, int cy, int minX, int maxX, int minY, int maxY) {
            return EncodedRectangle.bboxContainsPoint(ax, ay, minX, maxX, minY, maxY) && EncodedRectangle.bboxContainsPoint(bx, by, minX, maxX, minY, maxY) && EncodedRectangle.bboxContainsPoint(cx, cy, minX, maxX, minY, maxY);
        }

        private static boolean edgeIntersectsBox(int ax, int ay, int bx, int by, int minX, int maxX, int minY, int maxY) {
            if (ax == bx && ay == by) {
                return Rectangle.containsPoint(ay, ax, minY, maxY, minX, maxX);
            }
            if (EncodedRectangle.bboxContainsPoint(ax, ay, minX, maxX, minY, maxY) || EncodedRectangle.bboxContainsPoint(bx, by, minX, maxX, minY, maxY)) {
                return true;
            }
            if (EncodedRectangle.boxesAreDisjoint(Math.min(ax, bx), Math.max(ax, bx), Math.min(ay, by), Math.max(ay, by), minX, maxX, minY, maxY)) {
                return false;
            }
            if (GeoUtils.orient(ax, ay, bx, by, minX, maxY) * GeoUtils.orient(ax, ay, bx, by, maxX, maxY) <= 0 && GeoUtils.orient(minX, maxY, maxX, maxY, ax, ay) * GeoUtils.orient(minX, maxY, maxX, maxY, bx, by) <= 0) {
                return true;
            }
            if (GeoUtils.orient(ax, ay, bx, by, maxX, maxY) * GeoUtils.orient(ax, ay, bx, by, maxX, minY) <= 0 && GeoUtils.orient(maxX, maxY, maxX, minY, ax, ay) * GeoUtils.orient(maxX, maxY, maxX, minY, bx, by) <= 0) {
                return true;
            }
            if (GeoUtils.orient(ax, ay, bx, by, maxX, minY) * GeoUtils.orient(ax, ay, bx, by, minX, minY) <= 0 && GeoUtils.orient(maxX, minY, minX, minY, ax, ay) * GeoUtils.orient(maxX, minY, minX, minY, bx, by) <= 0) {
                return true;
            }
            return GeoUtils.orient(ax, ay, bx, by, minX, minY) * GeoUtils.orient(ax, ay, bx, by, minX, maxY) <= 0 && GeoUtils.orient(minX, minY, minX, maxY, ax, ay) * GeoUtils.orient(minX, minY, minX, maxY, bx, by) <= 0;
        }

        private static boolean boxesAreDisjoint(int aMinX, int aMaxX, int aMinY, int aMaxY, int bMinX, int bMaxX, int bMinY, int bMaxY) {
            return aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY;
        }
    }
}

