.\" $XTermId: luit.man,v 1.41 2024/01/02 21:29:30 tom Exp $
.\" ---------------------------------------------------------------------------
.\" Copyright 2006-2021,2024 by Thomas E. Dickey
.\" Copyright (c) 2001 by Juliusz Chroboczek
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\" ---------------------------------------------------------------------------
.\" Escape single quotes in literal strings from groff's Unicode transform.
.TH LUIT 1 __vendorversion__
.ie \n(.g \{\
.ds `` \(lq
.ds '' \(rq
.ds '  \(aq
.\}
.el \{\
.ie t .ds `` ``
.el   .ds `` ""
.ie t .ds '' ''
.el   .ds '' ""
.ie t .ds '  \(aq
.el   .ds '  '
.\}
.de bP
.ie n  .IP \(bu 4
.el    .IP \(bu 2
..
.SH NAME
luit \-
Locale and ISO\ 2022 support for Unicode terminals
.SH SYNOPSIS
.B luit
[
.I options
] [
.B \-\-
] [
.I program
[
.I args
] ]
.\" ***************************************************************************
.SH DESCRIPTION
.B Luit
is a filter that can be run between an arbitrary application and a
UTF-8 terminal emulator.
It will convert application output from the
locale's encoding into UTF-8, and convert terminal input from UTF-8
into the locale's encoding.
.PP
\fBLuit\fP reads its input from the child process,
i.e., an application running in the terminal.
\fBLuit\fP writes its output to the terminal.
The two (input and output) can have different encodings.
.PP
An application may also request switching to a different output
encoding using ISO\ 2022 and ISO\ 6429 escape sequences.
Use of this feature is discouraged:
multilingual applications should be modified
to directly generate UTF-8 instead.
.PP
.B Luit
is usually invoked transparently by the terminal emulator.
For information about running
.B luit
from the command line, see EXAMPLES below.
.\" ***************************************************************************
.SH OPTIONS
.TP
.B \-V
Print \fBluit\fP's version and quit.
.TP
.BI \-alias " filename"
the locale alias file
.br
(default: __locale_alias__).
.TP
.BI \-argv0 " name"
Set the child's name (as passed in argv[0]).
.TP
.B \-c
Function as a simple converter from standard input to standard output.
.TP
.BI \-encoding " encoding"
Set up
.B luit
to use
.I encoding
rather than the current locale's encoding.
.TP
.BI \-g0 " charset"
Set the output charset initially selected in G0.
The default depends on the locale, but is usually
.BR ASCII .
.TP
.BI \-g1 " charset"
Set the output charset initially selected in G1.
The default depends on the locale.
.TP
.BI \-g2 " charset"
Set the output charset initially selected in G2.
The default depends on the locale.
.TP
.BI \-g3 " charset"
Set the output charset initially selected in G3.
The default depends on the locale.
.TP
.BI \-gl " gn"
Set the initial assignment of GL in the output.
The argument should be one of
.BR g0 ,
.BR g1 ,
.B g2
or
.BR g3 .
The default depends on the locale, but is usually
.BR g0 .
.TP
.BI \-gr " gk"
Set the initial assignment of GR in the output.
The default depends on the locale, and is usually
.B g2
except for EUC locales, where it is
.BR g1 .
.TP
.B \-h
Display a usage and options message on the standard output and quit.
.TP
.BI \-ilog " filename"
Log into
.I filename
all the bytes received from the child.
.TP
.B \-k7
Generate seven-bit characters for keyboard input.
.TP
.BI \-kg0 " charset"
Set the input charset initially selected in G0.
The default depends on the locale, but is usually
.BR ASCII .
.TP
.BI \-kg1 " charset"
Set the input charset initially selected in G1.
The default depends on the locale.
.TP
.BI \-kg2 " charset"
Set the input charset initially selected in G2.
The default depends on the locale.
.TP
.BI \-kg3 " charset"
Set the input charset initially selected in G3.
The default depends on the locale.
.TP
.BI \-kgl " gn"
Set the initial assignment of GL in the input.
The argument should be one of
.BR g0 ,
.BR g1 ,
.B g2
or
.BR g3 .
The default depends on the locale, but is usually
.BR g0 .
.TP
.BI \-kgr " gk"
Set the initial assignment of GR in the input.
The default depends on the locale, and is usually
.B g2
except for EUC locales, where it is
.BR g1 .
.TP
.B \-kls
Generate locking shifts (SO/SI) for keyboard input.
.TP
.B +kss
Disable generation of single-shifts for keyboard input.
.TP
.B +kssgr
Use GL codes after a single shift for keyboard input.
By default,
GR codes are generated after a single shift when generating eight-bit
keyboard input.
.TP
.B \-list
List the supported charsets and encodings, then quit.
\fBLuit\fP uses its internal tables for this,
which are based on the \fIfontenc\fP library.
.TP
.B \-list\-builtin
List the built-in encodings used as a fallback when data from
\fIiconv\fP or \fIfontenc\fP is missing.
.IP
This option relies on \fBluit\fP being configured to use \fIiconv\fP,
since the \fIfontenc\fP library does not supply a list of built-in encodings.
.TP
.B \-list\-fontenc
List the encodings provided by \*(``.enc\*('' files originally
distributed with the \fIfontenc\fP library.
.TP
.B \-list\-iconv
List the encodings and locales supported by the \fIiconv\fP library.
\fBLuit\fP adapts its internal tables of \fIfontenc\fP names
to \fIiconv\fP encodings.
.IP
To make scripting simpler,
.B luit
ignores spaces, underscores and ASCII minus-signs (dash) embedded in the names.
.B Luit
also ignores case when matching charset and encoding names.
.IP
This option lists only the encodings which are associated with the
locales supported on the current operating system.
The portable \fIiconv\fP application provides a list of its supported
encodings with the \fB\-l\fP option.
Other implementations may provide similar functionality.
There is no portable library call by which an application can
obtain the same information.
.TP
.BI \-olog " filename"
Log into
.I filename
all the bytes sent to the terminal emulator.
.TP
.B +ols
Disable interpretation of locking shifts in application output.
.TP
.B +osl
Disable interpretation of character set selection sequences in
application output.
.TP
.B +oss
Disable interpretation of single shifts in application output.
.TP
.B +ot
Disable interpretation of all sequences and pass all sequences in
application output to the terminal unchanged.
This may lead to interesting results.
.TP
.B \-p
In startup, establish a handshake between parent and child processes.
This is needed for some older systems, e.g., to successfully copy
the terminal settings to the pseudo-terminal.
.TP
.BI \-prefer " list"
Set the lookup-order preference for character set information.
The parameter is a comma-separated list of keywords.
The default order (listing all keywords) is
.RS
.IP
fontenc,builtin,iconv,posix
.RE
.IP
The default order uses \fBfontenc\fP first because this allows \fBluit\fP
to start more rapidly (about 0.1 seconds) than using \fBiconv\fP for
complex encodings such as eucJP.
However, you may find that
the iconv implementation is more accurate or complete.
In that case, you can use the \fB\-show-iconv\fP option to obtain
a text file which can be used as an encoding with the \fBfontenc\fP
configuration.
.IP
This option relies on \fBluit\fP being configured to use \fIiconv\fP,
since the \fIfontenc\fP library does not provide this choice.
.TP
.BI \-show\-builtin " encoding"
Show a built-in encoding, e.g., from a \*(``.enc\*('' file
using the \*(``.enc\*('' format.
.IP
This option relies on \fBluit\fP being configured to use \fIiconv\fP,
since the \fIfontenc\fP library does not supply a list of built-in encodings.
.TP
.BI \-show\-fontenc " encoding"
Show a given encoding, e.g., from a \*(``.enc\*('' file
using the \*(``.enc\*('' format.
If \fBluit\fP is configured to use the \fIfontenc\fP library,
it obtains the information using that library.
Otherwise \fBluit\fP reads the file directly.
.IP
Some of \fIfontenc\fP's encodings are built into the library.
The \fIfontenc\fP library uses those in preference to an external file.
Use the \fB\-show\-builtin\fP option to provide similar information
when \fBluit\fP is configured to use \fIiconv\fP.
.TP
.BI \-show\-iconv " encoding"
Show a given encoding, using the \*(``.enc\*('' format.
If \fBluit\fP is configured to use \fIiconv\fP,
it obtains the information using that interface.
If \fIiconv\fP cannot supply the information, \fBluit\fP
may use a built-in table.
.TP
.B \-t
Initialize \fBluit\fP using the locale and command-line options,
but do not open a pty connection.
This option is used for testing \fBluit\fP's configuration.
It will exit with success if no errors were detected.
Repeat the \fB\-t\fP option to cause warning messages to be treated as errors.
.TP
.B \-v
Be verbose.
Repeating the option, e.g., \*(``\fB\-v\ \-v\fP\*('' makes it more verbose.
.B Luit
does not use \fIgetopt\fP, so \*(``\fB\-vv\fP\*('' does not work.
.TP
.B \-x
Exit as soon as the child dies.
This may cause
.B luit
to lose data at the end of the child's output.
.TP
.B \-\-
End of options.
.\" ***************************************************************************
.SH ENVIRONMENT
\fBLuit\fP uses these environment variables:
.TP
FONT_ENCODINGS_DIRECTORY
overrides the location of the \*(``encodings.dir\*('' file,
which lists encodings in external \*(``.enc\*('' files.
.TP
LC_ALL
.TP
LC_CTYPE
.TP
LANG
During initialization,
\fBluit\fP calls \fBsetlocale\fP to check if the user's locale is supported
by the operating system.
If \fBsetlocale\fP returns a failure,
\fBluit\fP looks instead at these variables in succession to obtain
any clues from the user's environment for locale preference.
.TP
NCURSES_NO_UTF8_ACS
\fBLuit\fP sets this to tell ncurses to not rely upon VT100 SI/SO controls
for line-drawing.
.TP
SHELL
This is normally set by shells other than the Bourne shell,
as a convention.
\fBLuit\fP will use this value (rather than the user's entry in /etc/passwd)
to decide which shell to execute.
If SHELL is not set, \fBluit\fP executes /bin/sh.
.\" ***************************************************************************
.SH FILES
.TP
.B __locale_alias__
The file mapping locales to locale encodings.
.\" ***************************************************************************
.SH BUGS
.SS Limitations
None of this complexity should be necessary.
Stateless UTF-8
throughout the system is the way to go.
.PP
Charsets with a non-trivial intermediary byte are not yet supported.
.PP
Selecting alternate sets of control characters is not supported and
will never be.
.SS Security
On systems with SVR4 (\*(``Unix-98\*('') ptys (Linux version 2.2 and later,
SVR4),
.B luit
should be run as the invoking user.
.PP
On systems without SVR4 (\*(``Unix-98\*('') ptys (notably BSD variants),
running
.B luit
as an ordinary user will leave the tty world-writable; this is a
security hole, and \fBluit\fP will generate a warning (but still accept to
run).
A possible solution is to make
.B luit
suid root;
.B luit
should drop privileges sufficiently early to make this safe.
However,
the startup code has not been exhaustively audited, and the author
takes no responsibility for any resulting security issues.
.PP
.B Luit
will refuse to run if it is installed setuid and cannot safely drop
privileges.
.\" ***************************************************************************
.SH EXAMPLES
The most typical use of
.B luit
is to adapt an instance of
.B XTerm
to the locale's encoding.
Current versions of
.B XTerm
invoke
.B luit
automatically when it is needed.
If you are using an older release of
.BR XTerm ,
or a different terminal emulator, you may invoke
.B luit
manually:
.IP
$ xterm \-u8 \-e luit
.PP
If you are running in a UTF-8 locale but need to access a remote
machine that doesn't support UTF-8,
.B luit
can adapt the remote output to your terminal:
.IP
$ LC_ALL=fr_FR luit ssh legacy-machine
.PP
.B Luit
is also useful with applications that hard-wire an encoding that is
different from the one normally used on the system or want to use
legacy escape sequences for multilingual output.
In particular,
versions of
.B Emacs
that do not speak UTF-8 well can use
.B luit
for multilingual output:
.IP
$ luit \-encoding 'ISO 8859\-1' emacs \-nw
.PP
And then, in
.BR Emacs ,
.IP
M\-x set\-terminal\-coding\-system RET iso\-2022\-8bit\-ss2 RET
.\" ***************************************************************************
.SH AUTHORS
Luit was written by Juliusz Chroboczek <jch@pps.jussieu.fr> for the
XFree86 project.
.PP
Thomas E. Dickey has maintained \fBluit\fP for use by \fBxterm\fP since 2006.
.\" ***************************************************************************
.SH SEE ALSO
These are portable:
.bP
xterm(__mansuffix__),
.bP
ncurses(3X).
.PP
These are Linux-specific:
.bP
unicode(__miscmansuffix__),
.bP
utf-8(__miscmansuffix__),
.bP
charsets(__miscmansuffix__).
.PP
These are particularly useful:
.nf
.bP
\fICharacter Code Structure and Extension Techniques (ISO\ 2022, ECMA-35)\fP
.bP
\fIControl Functions for Coded Character Sets (ISO\ 6429, ECMA-48)\fP
.bP
http://czyborra.com/charsets/
.fi
