/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.InternalDiagnosticFactoryMethod;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryN;
import org.jetbrains.kotlin.diagnostics.KtLightSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtOffsetsOnlySimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtPsiSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.BaseDiagnosticRendererFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ$\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactoryN;", "name", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "defaultPositioningStrategy", "Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "psiType", "Lkotlin/reflect/KClass;", "rendererFactory", "Lorg/jetbrains/kotlin/diagnostics/rendering/BaseDiagnosticRendererFactory;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;Lkotlin/reflect/KClass;Lorg/jetbrains/kotlin/diagnostics/rendering/BaseDiagnosticRendererFactory;)V", "on", "Lorg/jetbrains/kotlin/diagnostics/KtSimpleDiagnostic;", "element", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "positioningStrategy", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.common"})
public final class KtDiagnosticFactory0
extends KtDiagnosticFactoryN {
    public KtDiagnosticFactory0(@NotNull String name2, @NotNull Severity severity, @NotNull AbstractSourceElementPositioningStrategy defaultPositioningStrategy, @NotNull KClass<?> psiType, @NotNull BaseDiagnosticRendererFactory rendererFactory) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)severity), (String)"severity");
        Intrinsics.checkNotNullParameter((Object)defaultPositioningStrategy, (String)"defaultPositioningStrategy");
        Intrinsics.checkNotNullParameter(psiType, (String)"psiType");
        Intrinsics.checkNotNullParameter((Object)rendererFactory, (String)"rendererFactory");
        super(name2, severity, defaultPositioningStrategy, psiType, rendererFactory, null);
    }

    @InternalDiagnosticFactoryMethod
    @Nullable
    public final KtSimpleDiagnostic on(@NotNull AbstractKtSourceElement element, @Nullable AbstractSourceElementPositioningStrategy positioningStrategy, @NotNull LanguageVersionSettings languageVersionSettings) {
        KtSimpleDiagnostic ktSimpleDiagnostic;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Severity severity = this.getEffectiveSeverity(languageVersionSettings);
        if (severity == null) {
            return null;
        }
        Severity effectiveSeverity = severity;
        AbstractKtSourceElement abstractKtSourceElement = element;
        if (abstractKtSourceElement instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement = (KtPsiSourceElement)element;
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtPsiSimpleDiagnostic(ktPsiSourceElement, effectiveSeverity, this, abstractSourceElementPositioningStrategy);
        } else if (abstractKtSourceElement instanceof KtLightSourceElement) {
            KtLightSourceElement ktLightSourceElement = (KtLightSourceElement)element;
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtLightSimpleDiagnostic(ktLightSourceElement, effectiveSeverity, this, abstractSourceElementPositioningStrategy);
        } else {
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtOffsetsOnlySimpleDiagnostic(element, effectiveSeverity, this, abstractSourceElementPositioningStrategy);
        }
        return ktSimpleDiagnostic;
    }
}

