/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.bootstrap;

import java.lang.reflect.Method;
import org.gradle.api.internal.DefaultClassPathProvider;
import org.gradle.api.internal.DefaultClassPathRegistry;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.DefaultClassLoaderFactory;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.installation.CurrentGradleInstallation;

public class ProcessBootstrap {
    public static void run(String bootstrapName, String moduleName, String mainClassName, String[] args) {
        try {
            ProcessBootstrap.runNoExit(bootstrapName, moduleName, mainClassName, args);
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runNoExit(String bootstrapName, String moduleName, String mainClassName, String[] args) throws Exception {
        VisitableURLClassLoader runtimeClassLoader;
        ClassLoader antClassLoader;
        try {
            DefaultModuleRegistry moduleRegistry = new DefaultModuleRegistry(CurrentGradleInstallation.get());
            DefaultClassPathRegistry classPathRegistry = new DefaultClassPathRegistry(new DefaultClassPathProvider(moduleRegistry));
            DefaultClassLoaderFactory classLoaderFactory = new DefaultClassLoaderFactory();
            ClassPath antClasspath = classPathRegistry.getClassPath("ANT");
            ClassPath runtimeClasspath = moduleRegistry.getModule(moduleName).getAllRequiredModulesClasspath();
            antClassLoader = classLoaderFactory.createIsolatedClassLoader("ant-loader", antClasspath);
            runtimeClassLoader = VisitableURLClassLoader.fromClassPath((String)"ant-and-gradle-loader", (ClassLoader)antClassLoader, (ClassPath)runtimeClasspath);
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Failed to bootstrap Gradle. Check MANIFEST.MF 'Class-Path' of the entry-point '" + bootstrapName + "' and ensure there are no missing dependencies for the manifest classpath", e);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)runtimeClassLoader);
        try {
            Class<?> mainClass = runtimeClassLoader.loadClass(mainClassName);
            Object entryPoint = mainClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method mainMethod = mainClass.getMethod("run", String[].class);
            mainMethod.invoke(entryPoint, new Object[]{args});
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            ClassLoaderUtils.tryClose((ClassLoader)runtimeClassLoader);
            ClassLoaderUtils.tryClose((ClassLoader)antClassLoader);
        }
    }
}

